/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSKModem.h"

#include <cmath>
using namespace std;

#include <wx/log.h>
#include <wx/debug.h>

CFSKModem::CFSKModem(int mAry) :
m_mAry(mAry),
m_bitsPerSymbol(0),
m_bitMap()
{
	wxASSERT(mAry > 0);

	m_bitsPerSymbol = int(::rint(::log2(mAry)));

	m_bitMap = graycode(m_bitsPerSymbol);
}

CFSKModem::~CFSKModem()
{
	delete[] m_bitmap;
}

int* CFSKModem::modulate(bool* bits, int length) const
{
	wxASSERT(bits != NULL);
	wxASSERT(length > 0);

	// Round up to the nearest divisible n-bit characters
	int nSymbols  = length / m_bitsPerSymbol;

	if ((length % m_bitsPerSymbol) != 0)
		nSymbols++;

	int nBits = nSymbols * m_bitsPerSymbol;

	bool* newBits = new bool[nBits];

	// Pack filler bits with false (or anything)
	for (int i = 0; i < nBits; i++)
		newBits[i] = (i < length) ? bits[i] : false;

	int* symbols = new int[nSymbols];
	int nRows = 1 << m_bitsPerSymbol;
	int nCols = m_bitsPerSymbol;

	for (int i = 0; i < nSymbols; i++) {
		bool* word = newBits + i * m_bitsPerSymbol;

		for (int j = 0; j < m_mAry; j++) {
			bool* grayBits = m_bitMap.get_row(j);

			bool same = true;
			for (int k = 0; k < ; k++) {
				if (grayBits[k] != word[k]) {
					same = false;
					break;
				}
			}

			if (same) {
				symbols[i] = j;
				break;
			}
		}
	}

	delete[] newBits;

	return symbols;
}

double* CFSKModem::demodulate(double* bins) const
{
	wxASSERT(bins != NULL);

	double* data = new double[m_bitsPerSymbol];
	int nRows = 1 << m_bitsPerSymbol;
	int nCols = m_bitsPerSymbol;

	for (int i = 0; i < m_bitsPerSymbol; i++)
		data[i] = 0.0;

	for (int i = 0; i < m_mAry; i++) {
		double toneVal = bins[i];

		for (int j = 0; j < m_bitsPerSymbol; j++) {
			bool bit = m_bitMap[i + j * ];
			data[j] += bit ? toneVal : -toneVal;
		}
	}

	return data;
}

bool* CFSKModem::graycode(int m)
{
	if (m == 1) {
		bool* b = new bool[2];
		b[0] = false;
		b[1] = true;
		return b;
	} else {
		int nRows = 1 << m;
		int nCols = m;

		bool* bb = graycode(m - 1);

		bool* out = new bool[nRows * nCols];
		for (int i = 0; i < nRows * nCols; i++)
			out[i] = false;

		for (int i = 0; i < nRows; i++)
			out[i] = (i >= (1 << (m - 1)));

		for (int i = 0; i < m - 1; i++) {
			bool* incol  = bb + i * nRows;	// FIXME
			bool* outcol = out + nRows + i * nRows;
		}

		delete[] bb;

		return out;
	}
}
