/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.om.Name;
import org.xml.sax.AttributeList;

public class AttributeCollection
implements AttributeList {
    private String[] list = null;
    private int used = 0;
    private static int RECSIZE = 5;
    private static int PREFIX = 0;
    private static int URI = 1;
    private static int LOCALNAME = 2;
    private static int TYPE = 3;
    private static int VALUE = 4;

    public AttributeCollection() {
    }

    public AttributeCollection(int n) {
        this.list = new String[n * 5];
    }

    public AttributeCollection copy() {
        AttributeCollection attributeCollection = new AttributeCollection();
        attributeCollection.list = new String[this.used];
        System.arraycopy(this.list, 0, attributeCollection.list, 0, this.used);
        attributeCollection.used = this.used;
        return attributeCollection;
    }

    public void addAttribute(Name name, String string, String string2) {
        this.addAttribute(name.getPrefix(), name.getURI(), name.getLocalName(), string, string2);
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        if (this.list == null) {
            this.list = new String[5 * RECSIZE];
        }
        if (this.list.length == this.used) {
            String[] stringArray = new String[this.used * 2];
            System.arraycopy(this.list, 0, stringArray, 0, this.used);
            this.list = stringArray;
        }
        this.list[this.used++] = string;
        this.list[this.used++] = string2;
        this.list[this.used++] = string3;
        this.list[this.used++] = string4;
        this.list[this.used++] = string5;
    }

    public void removeAttribute(Name name) {
        int n = this.findByName(name);
        if (n >= 0) {
            if (n + RECSIZE < this.used) {
                System.arraycopy(this.list, n + RECSIZE, this.list, n, this.used - (n + RECSIZE));
            }
            this.used -= RECSIZE;
        }
    }

    public void setAttribute(Name name, String string) {
        int n = this.findByName(name);
        if (n < 0) {
            this.addAttribute(name, "CDATA", string);
        } else {
            this.list[n + AttributeCollection.PREFIX] = name.getPrefix();
            this.list[n + AttributeCollection.VALUE] = string;
        }
    }

    public void setAttribute(Name name, String string, String string2) {
        int n = this.findByName(name);
        if (n < 0) {
            this.addAttribute(name, string, string2);
        } else {
            this.list[n + AttributeCollection.PREFIX] = name.getPrefix();
            this.list[n + AttributeCollection.VALUE] = string2;
        }
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.list = null;
        } else if (this.list.length > this.used) {
            String[] stringArray = new String[this.used];
            System.arraycopy(this.list, 0, stringArray, 0, this.used);
            this.list = stringArray;
        }
    }

    public int getLength() {
        return this.list == null ? 0 : this.used / RECSIZE;
    }

    public String getName(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 > this.used) {
            return null;
        }
        String string = this.list[n2 + PREFIX];
        String string2 = this.list[n2 + LOCALNAME];
        if (string == "") {
            return string2;
        }
        return string + ":" + string2;
    }

    public String getType(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 > this.used) {
            return null;
        }
        return this.list[n2 + TYPE];
    }

    public String getValue(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 > this.used) {
            return null;
        }
        return this.list[n2 + VALUE];
    }

    public String getType(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? null : this.list[n + TYPE];
    }

    public String getValue(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? null : this.list[n + VALUE];
    }

    public Name getExpandedName(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 > this.used) {
            return null;
        }
        String string = this.list[n2 + PREFIX];
        String string2 = this.list[n2 + URI];
        String string3 = this.list[n2 + LOCALNAME];
        return Name.reconstruct(string, string2, string3);
    }

    public String getValue(Name name) {
        int n = this.findByName(name);
        return n < 0 ? null : this.list[n + VALUE];
    }

    public int getPosition(Name name) {
        if (this.list == null) {
            return -1;
        }
        int n = this.findByName(name);
        if (n < 0) {
            return -1;
        }
        return n / RECSIZE;
    }

    private int findByName(Name name) {
        if (this.list == null) {
            return -1;
        }
        String string = name.getURI();
        String string2 = name.getLocalName();
        int n = 0;
        while (n < this.used) {
            if (string.equals(this.list[n + URI]) && string2.equals(this.list[n + LOCALNAME])) {
                return n;
            }
            n += RECSIZE;
        }
        return -1;
    }

    private int findByDisplayName(String string) {
        if (this.list == null) {
            return -1;
        }
        int n = string.indexOf(":");
        if (n < 0) {
            int n2 = 0;
            while (n2 < this.used) {
                if (string.equals(this.list[n2 + LOCALNAME])) {
                    return n2;
                }
                n2 += RECSIZE;
            }
            return -1;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n3 = 0;
        while (n3 < this.used) {
            if (string3.equals(this.list[n3 + LOCALNAME]) && string2.equals(this.list[n3 + PREFIX])) {
                return n3;
            }
            n3 += RECSIZE;
        }
        return -1;
    }
}

