/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.axis;

import com.icl.saxon.NameTest;
import com.icl.saxon.axis.AncestorAxis;
import com.icl.saxon.axis.AncestorOrSelfAxis;
import com.icl.saxon.axis.AttributeAxis;
import com.icl.saxon.axis.ChildrenAxis;
import com.icl.saxon.axis.DescendantsAxis;
import com.icl.saxon.axis.DescendantsOrSelfAxis;
import com.icl.saxon.axis.FollowingAxis;
import com.icl.saxon.axis.FollowingSiblingsAxis;
import com.icl.saxon.axis.NamespaceAxis;
import com.icl.saxon.axis.ParentAxis;
import com.icl.saxon.axis.PrecedingAxis;
import com.icl.saxon.axis.PrecedingSiblingsAxis;
import com.icl.saxon.axis.SelfAxis;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

public abstract class Axis {
    public static final int ANCESTOR = 1;
    public static final int ANCESTOR_OR_SELF = 2;
    public static final int ATTRIBUTE = 3;
    public static final int CHILD = 4;
    public static final int DESCENDANT = 5;
    public static final int DESCENDANT_OR_SELF = 6;
    public static final int FOLLOWING = 7;
    public static final int FOLLOWING_SIBLING = 8;
    public static final int NAMESPACE = 9;
    public static final int PARENT = 10;
    public static final int PRECEDING = 11;
    public static final int PRECEDING_SIBLING = 12;
    public static final int SELF = 13;
    protected int axisNumber;
    protected int nodeType = this.getPrincipalNodeType();
    protected NameTest nodeName;

    public static int lookup(String string) throws SAXException {
        if (string.equals("ancestor")) {
            return 1;
        }
        if (string.equals("ancestor-or-self")) {
            return 2;
        }
        if (string.equals("attribute")) {
            return 3;
        }
        if (string.equals("child")) {
            return 4;
        }
        if (string.equals("descendant")) {
            return 5;
        }
        if (string.equals("descendant-or-self")) {
            return 6;
        }
        if (string.equals("following")) {
            return 7;
        }
        if (string.equals("following-sibling")) {
            return 8;
        }
        if (string.equals("namespace")) {
            return 9;
        }
        if (string.equals("parent")) {
            return 10;
        }
        if (string.equals("preceding")) {
            return 11;
        }
        if (string.equals("preceding-sibling")) {
            return 12;
        }
        if (string.equals("self")) {
            return 13;
        }
        throw new SAXException("Unknown axis name: " + string);
    }

    public static Axis make(int n, int n2, NameTest nameTest) throws SAXException {
        Axis axis = Axis.makeAxis(n);
        axis.setNodeType(n2);
        axis.setNameTest(nameTest);
        axis.setAxisNumber(n);
        return axis;
    }

    public static Axis makeAxis(int n) throws SAXException {
        switch (n) {
            case 1: {
                return new AncestorAxis();
            }
            case 2: {
                return new AncestorOrSelfAxis();
            }
            case 3: {
                return new AttributeAxis();
            }
            case 4: {
                return new ChildrenAxis();
            }
            case 5: {
                return new DescendantsAxis();
            }
            case 6: {
                return new DescendantsOrSelfAxis();
            }
            case 7: {
                return new FollowingAxis();
            }
            case 8: {
                return new FollowingSiblingsAxis();
            }
            case 9: {
                return new NamespaceAxis();
            }
            case 10: {
                return new ParentAxis();
            }
            case 11: {
                return new PrecedingAxis();
            }
            case 12: {
                return new PrecedingSiblingsAxis();
            }
            case 13: {
                return new SelfAxis();
            }
        }
        throw new SAXException("Invalid axis number in call to Axis.make()");
    }

    private void setAxisNumber(int n) {
        this.axisNumber = n;
    }

    public int getAxisNumber() {
        return this.axisNumber;
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    public int getPrincipalNodeType() {
        return 1;
    }

    public void setNameTest(NameTest nameTest) {
        this.nodeName = nameTest;
    }

    public abstract NodeEnumeration getEnumeration(NodeInfo var1) throws SAXException;

    public abstract boolean isSorted();

    public boolean isReverseSorted() {
        return !this.isSorted();
    }

    public abstract boolean isSibling();

    public abstract boolean isPeer();

    public abstract boolean isWithinSubtree();
}

