/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.LastPositionFinder;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

public class FilterEnumerator
implements NodeEnumeration {
    private NodeEnumeration base;
    private Expression filter;
    private int position = 0;
    private int last = -1;
    private NodeInfo current = null;
    private Context filterContext;
    private int dataType = -1;
    private boolean finished = false;

    public FilterEnumerator(NodeEnumeration nodeEnumeration, Expression expression, Context context) throws SAXException {
        this.base = nodeEnumeration;
        this.filter = expression;
        this.filterContext = context == null ? new Context() : context.newContext();
        this.dataType = expression.getDataType();
        if (nodeEnumeration instanceof LastPositionFinder) {
            this.filterContext.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
        } else {
            this.base = new LookaheadEnumerator(nodeEnumeration);
            this.filterContext.setLastPositionFinder((LastPositionFinder)((Object)this.base));
        }
        this.current = this.getNextMatchingElement();
    }

    public boolean hasMoreElements() {
        return this.current != null;
    }

    public NodeInfo nextElement() throws SAXException {
        NodeInfo nodeInfo = this.current;
        this.current = this.getNextMatchingElement();
        return nodeInfo;
    }

    /*
     * Unable to fully structure code
     */
    private NodeInfo getNextMatchingElement() throws SAXException {
        if (!this.finished) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = this.base.nextElement();
            ++this.position;
            if (!this.matches(var1_1)) continue;
            return var1_1;
lbl7:
            // 2 sources

            ** while (this.base.hasMoreElements())
        }
lbl8:
        // 1 sources

        return null;
    }

    private boolean matches(NodeInfo nodeInfo) throws SAXException {
        this.filterContext.setPosition(this.position);
        this.filterContext.setContextNode(nodeInfo);
        if (this.dataType == 2) {
            int n = (int)this.filter.evaluateAsNumber(this.filterContext);
            if (this.position == n) {
                if (this.filter instanceof NumericValue) {
                    this.finished = true;
                }
                return true;
            }
            return false;
        }
        if (this.dataType == -1) {
            Value value = this.filter.evaluate(this.filterContext);
            if (value instanceof NumericValue) {
                return this.position == (int)value.asNumber();
            }
            return value.asBoolean();
        }
        return this.filter.evaluateAsBoolean(this.filterContext);
    }

    public boolean isSorted() throws SAXException {
        return this.base.isSorted();
    }

    public boolean isReverseSorted() throws SAXException {
        return this.base.isReverseSorted();
    }

    public boolean isPeer() throws SAXException {
        return this.base.isPeer();
    }
}

