/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.style.XSLNamespaceAlias;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.tree.Builder;
import java.util.Vector;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LiteralResultElement
extends StyleElement {
    private Name resultName;
    private Name[] attributeNames;
    private Expression[] attributeValues;
    private boolean[] attributeChecked;
    private int numberOfAttributes;
    private boolean toplevel;
    private Vector namespaceNodes = new Vector();

    public boolean requiresXSLprefix() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
    }

    public void validate() throws SAXException {
        this.toplevel = this.getParentNode() instanceof XSLStyleSheet;
        String string = this.getURI();
        if (this.toplevel) {
            if (string == "") {
                throw new SAXException("Top level elements must have a non-null namespace URI");
            }
        } else {
            int n;
            Object object;
            Object object2;
            Object object3;
            NodeInfo nodeInfo;
            this.addNamespaceNodes(this, this.namespaceNodes, null);
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            int n2 = 0;
            while (n2 < this.namespaceNodes.size()) {
                nodeInfo = (NamespaceInfo)this.namespaceNodes.elementAt(n2);
                object3 = xSLStyleSheet.getNamespaceAlias(nodeInfo.getNamespaceURI());
                if (object3 != null) {
                    this.namespaceNodes.removeElementAt(n2);
                    --n2;
                }
                ++n2;
            }
            this.resultName = this.getExpandedName();
            nodeInfo = xSLStyleSheet.getNamespaceAlias(string);
            if (nodeInfo != null) {
                object3 = ((XSLNamespaceAlias)nodeInfo).getResultPrefix();
                String string2 = ((XSLNamespaceAlias)nodeInfo).getResultURI();
                this.resultName = new Name((String)object3, string2, this.getLocalName());
            }
            int n3 = this.attributeList.getLength();
            this.attributeNames = new Name[n3];
            this.attributeValues = new Expression[n3];
            this.attributeChecked = new boolean[n3];
            this.numberOfAttributes = 0;
            int n4 = 0;
            while (n4 < n3) {
                Name name = this.attributeList.getExpandedName(n4);
                if (name.getURI().equals("http://www.w3.org/1999/XSL/Transform")) {
                    if (name.getLocalName().equals("use-attribute-sets")) {
                        this.findAttributeSets(this.attributeList.getValue(n4));
                    }
                } else {
                    Object object4;
                    object2 = name;
                    if (name.getPrefix() != "" && (object4 = xSLStyleSheet.getNamespaceAlias(name.getURI())) != null) {
                        String string3 = ((XSLNamespaceAlias)object4).getResultPrefix();
                        object = ((XSLNamespaceAlias)object4).getResultURI();
                        object2 = new Name(string3, (String)object, name.getLocalName());
                    }
                    this.attributeNames[this.numberOfAttributes] = object2;
                    this.attributeValues[this.numberOfAttributes] = object4 = AttributeValueTemplate.make(this.attributeList.getValue(n4), this);
                    this.attributeChecked[this.numberOfAttributes] = false;
                    n = 0;
                    if (object4 instanceof StringValue) {
                        object = ((StringValue)object4).asString();
                        int n5 = 0;
                        while (n5 < ((String)object).length()) {
                            char c = ((String)object).charAt(n5);
                            if (c < '!' || c > '~' || c == '<' || c == '>' || c == '&' || c == '\"' || c == '%') {
                                n = 1;
                                break;
                            }
                            ++n5;
                        }
                        this.attributeChecked[this.numberOfAttributes] = n == 0;
                    }
                    ++this.numberOfAttributes;
                }
                ++n4;
            }
            int n6 = 0;
            while (n6 < this.namespaceNodes.size()) {
                object2 = ((NamespaceInfo)this.namespaceNodes.elementAt(n6)).getNamespaceURI();
                if (this.isExcludedNamespace((String)object2)) {
                    boolean bl = true;
                    if (((String)object2).equals(this.resultName.getURI())) {
                        bl = false;
                    }
                    n = 0;
                    while (n < this.numberOfAttributes) {
                        object = this.attributeNames[n];
                        if (((String)object2).equals(((Name)object).getURI())) {
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                    if (bl) {
                        this.namespaceNodes.removeElementAt(n6);
                        continue;
                    }
                    ++n6;
                    continue;
                }
                ++n6;
            }
        }
    }

    public void process(Context context) throws SAXException {
        if (this.toplevel) {
            return;
        }
        Outputter outputter = context.getOutputter();
        outputter.writeStartTag(this.resultName);
        int n = 0;
        while (n < this.namespaceNodes.size()) {
            NamespaceInfo namespaceInfo = (NamespaceInfo)this.namespaceNodes.elementAt(n);
            outputter.writeNamespaceDeclaration(namespaceInfo.getNamespacePrefix(), namespaceInfo.getNamespaceURI(), false);
            ++n;
        }
        this.processAttributeSets(context);
        int n2 = 0;
        while (n2 < this.numberOfAttributes) {
            Name name = this.attributeNames[n2];
            String string = this.attributeValues[n2].evaluateAsString(context);
            outputter.writeAttribute(name, string, this.attributeChecked[n2]);
            ++n2;
        }
        this.processChildren(context);
        outputter.writeEndTag(this.resultName);
    }

    public DocumentInfo makeStyleSheet() throws SAXException {
        String string = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (string == null) {
            throw this.styleError("Not a stylesheet (the xsl namespace is not declared on the top-level element)");
        }
        Name name = new Name(string, "http://www.w3.org/1999/XSL/Transform", "version");
        String string2 = this.getAttributeValue(name);
        if (string2 == null) {
            throw this.styleError("There must be an xsl:version attribute on the outermost element");
        }
        Builder builder = new Builder();
        builder.setDocumentLocator(null);
        builder.setNodeFactory(new StyleNodeFactory());
        builder.setSystemId(this.getSystemId());
        builder.startDocument();
        builder.startPrefixMapping("xsl", "http://www.w3.org/1999/XSL/Transform");
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "version", "version", "CDATA", string2);
        builder.startElement("http://www.w3.org/1999/XSL/Transform", "stylesheet", "xsl:stylesheet", attributesImpl);
        attributesImpl.clear();
        attributesImpl.addAttribute("", "match", "match", "CDATA", "/");
        builder.startElement("http://www.w3.org/1999/XSL/Transform", "template", "xsl:template", attributesImpl);
        builder.graftElement(this);
        builder.endElement("http://www.w3.org/1999/XSL/Transform", "template", "xsl:template");
        builder.endElement("http://www.w3.org/1999/XSL/Transform", "stylesheet", "xsl:stylesheet");
        builder.endPrefixMapping("xsl");
        builder.endDocument();
        return builder.getCurrentDocument();
    }
}

