/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLAttributeSet;
import com.icl.saxon.style.XSLParam;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.style.XSLVariable;
import org.xml.sax.SAXException;

public class XSLAttribute
extends StyleElement {
    private static Name saxonDisable = Name.reconstruct("saxon", "http://icl.com/saxon", "disable-output-escaping");
    private Expression attributeName;
    private Expression namespace = null;
    private boolean disable = false;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String string;
        String[] stringArray = new String[]{"name", "namespace"};
        this.allowAttributes(stringArray);
        String string2 = this.getAttributeValue("name");
        if (string2 == null) {
            this.reportAbsence("name");
        }
        this.attributeName = AttributeValueTemplate.make(string2, this);
        String string3 = this.getAttributeValue("namespace");
        if (string3 != null) {
            this.namespace = AttributeValueTemplate.make(string3, this);
        }
        this.disable = (string = this.getAttributeValue(saxonDisable)) != null && string.equals("yes");
    }

    public void validate() throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getParentNode();
        while (nodeInfo != null) {
            if (nodeInfo instanceof XSLAttributeSet) {
                return;
            }
            if (nodeInfo instanceof XSLTemplate) {
                return;
            }
            if (nodeInfo instanceof XSLVariable) {
                return;
            }
            if (nodeInfo instanceof XSLParam) {
                return;
            }
            if (nodeInfo instanceof SAXONFunction) {
                return;
            }
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        throw this.styleError("Element must only be used within a template or within an attribute-set");
    }

    public void process(Context context) throws SAXException {
        Name name;
        Object object;
        String string;
        String string2;
        String string3 = this.attributeName.evaluateAsString(context);
        if (!Name.isQName(string3)) {
            context.getController().reportRecoverableError("Invalid attribute name: " + string3, this);
            return;
        }
        int n = string3.indexOf(":");
        if (this.namespace != null) {
            string2 = this.namespace.evaluateAsString(context).intern();
            if (n < 0) {
                string = this.getPrefixForURI(string2);
                if (string == null) {
                    string = "ns0";
                }
            } else {
                string = string3.substring(0, n).intern();
            }
            object = (n < 0 ? string3 : string3.substring(n + 1)).intern();
            name = new Name(string, string2, (String)object);
        } else {
            name = new Name(string3, this, false);
            string = name.getPrefix();
            string2 = name.getURI();
        }
        if (string == "" && string3.equals("xmlns") || string == "xmlns") {
            context.getController().reportRecoverableError("Invalid attribute name: " + string3, this);
            return;
        }
        object = context.getOutputter();
        if (string != "") {
            ((Outputter)object).writeNamespaceDeclaration(string, string2, true);
        }
        ((Outputter)object).writeAttribute(name, this.expandChildren(context), this.disable);
    }
}

