/*
    $Id: xkeyswrc.h,v 1.3 2001/06/21 21:14:35 dima Exp $

    xkeysw - window bound/multi code keyboard switch
    Copyright (C) 2000  Dima Barsky <dima@debian.org>,
                        Igor Belyi  <ibelyi@yahoo.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _XKEYSWRC_H_
#define _XKEYSWRC_H_

/* This include file contains definition of KeyCode */
#include <X11/X.h>

/* Types representing data in xkeyswrc resource file */

/* Type of elements */
typedef enum elem_type_t {
    string,			/* quoted string. Quotes are stripped */
    name,			/* name. String without quotes */
    pattern			/* pattern. Name with wildcards */
} elem_type_t;

/* Element in a list of strings */
typedef struct element_t {
    elem_type_t type;		/* type of the string */
    char* name;			/* the string itself */
    KeyCode keycode;		/* aixiliary field (KeyCode for the name) */
    KeySym  keysym;		/* auxiliary field (KeySym for the name) */
    struct element_t* next;
} element_t;

/* Group definition */
typedef struct group_t {
    int index;			/* auxiliary field (groupId) */
    char* name;			/* name of the group */
    element_t* pattern;		/* list of patterns representing the group */
    element_t* except;		/* list of patterns restricting the group */
    struct group_t* next;
} group_t;

/* Value of a keysym group */
typedef struct value_t {
    element_t* value;		/* list of string values */
    char* keymap;		/* keymap to switch to */
    int keymapId;		/* auxiliary field (index of the keymap) */
    struct value_t* next;
} value_t;

/* Keysym definition */
typedef struct keysym_t {
    char* keysym;		/* keysym */
    KeyCode keycode;		/* auxiliary field (keycode for keysym) */
    char* group_spec;		/* group restriction */
    int groupId;		/* auxiliary field (groupId for group_spec) */
    element_t* mod_list;	/* list of modifiers */
    value_t* values;		/* list of values for keysym groups */
    int complex_values;		/* auxiliary field (values with mult elem?) */
    int values_numb;		/* auxiliary field (number of values) */
    struct keysym_t* next;
} keysym_t;

/* Keymap definition */
typedef struct keymap_t {
    int index;			/* auxiliary field (keymapId) */
    char* name;			/* name of the keymap */
    char* prefix;		/* prefix for a window title */
    element_t* keymap_list;	/* list of keymaps this keymap is based on */
    keysym_t* keysym_list;	/* list of keysyms representing keymap */
    struct keymap_t* next;
} keymap_t;

/*
 * Auxiliary data types to ensure that groups and keymaps are stored in the
 * correct order in corresponding lists.
 */
typedef enum define_type_t {
    group,
    keymap,
    include
} define_type_t;

typedef struct define_t {
    define_type_t type;
    union {
	group_t* group;
	keymap_t* keymap;
	char* filename;
    } val;
} define_t;

/* Lists of parsed groups and keymaps */
extern group_t* group_list;
extern keymap_t* keymap_list;

/* Declaration of functions defined in xkeyswrc.l */
int includeFile(char* filename);
void beginNLmatch();
void beginInitial();

#endif
