#include "activities.h"
#include "proc_lcp3.h"
#include "lcp3.h"
#include "widgets.h"
#include "cfg.h"
#include "interface.h"

#include <glib.h>

void activity_connect()
{
	char * con_msg_1 = "establishing tcp connection...";
	char * con_msg_2 = "initiating authentication...";
	// do we need a passwd?
	if ( !config->user_passwd )
	{
		wnd_passwd = create_wnd_passwd();
		gtk_widget_show(wnd_passwd);
		while ( wnd_passwd ) gtk_main_iteration_do(TRUE);
	}
	wnd_conserver = create_wnd_conserver();
	gtk_widget_show(wnd_conserver);
	// try to connect:
	gtk_label_set_text(wdg_conserver->lb_status, con_msg_1);
	if ( ! proc_lcp3_init() )
	{
		g_print("proc_lcp3_init() failed!\n");
		return;
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_conserver->chk_gotip), TRUE);
	gtk_label_set_text(wdg_conserver->lb_status, con_msg_2);
	if ( !cmd_send(CMD3_PUBKEYREQ, NULL, 0) )
		g_print("cmd_send(CMD3_PUBKEYREQ) failed!\n");
}

void activity_disconnect()
{
	cmd_send(CMD3_UNREG, NULL, 0);
}
