dnl Some handy functions

dnl Try a list of directories, set the first one found
dnl Usage: AC_CHECK_DIRS(DIRECTORY..., ACTION-IF-FOUND, ACTION-IF-NOT-FOUND)

AC_DEFUN(AC_CHECK_DIRS,
[
for ac_dir in $1
do
AC_MSG_CHECKING([for directory ${ac_dir}])
if test -d ${ac_dir}
then
  AC_MSG_RESULT(yes)
  ifelse([$2], , :, [$2])
  break
else
  AC_MSG_RESULT(no)
fi
done
if test ! -d ${ac_dir}
then
  ifelse([$3], , :, [$3])
fi
])

dnl Check if a symbol is global
dnl Usage: AC_CHECK_GLOBAL_SYMBOL(OBJECT, SYMBOL, ACTION-IF-FOUND,
dnl                                               ACTION-IF-NOT-FOUND)

AC_DEFUN(AC_CHECK_GLOBAL_SYMBOL,
[
AC_MSG_CHECKING([for global symbol $2 in $1])
if objdump -T $1 | grep "\<$2\>" >/dev/null 2>&1 ;then
  AC_MSG_RESULT(yes)
  ifelse([$3], ,AC_DEFINE(translit(HAVE_GLOBAL_$2, [a-z], [A-Z])) , [$3])
else
  AC_MSG_RESULT(no)
  ifelse([$4], , :, [$4])
fi
])
