#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#define PLUGIN_NAME      	"CoverViewer"
#define PROG_NAME	      	"xmms"
#define DISPLAY_LIB	      	"gtk"
//#define __HEAVYDEBUG__ 	//display a lot of info (filenames, tags, ...)
//#define __DEBUG__	// display state (what's going on, etc...)

typedef struct image_name_buffer {
  gchar *imagename;
  struct image_name_buffer *next;
} image_name_buffer;

typedef struct fileinfo {
  gchar *filename;
  gchar *title;
  gchar *artist;
  gchar *album;
  gchar *track;
  gchar *year;
} fileinfo;

int xwin,ywin,Xwin,Ywin,posx,posy,Posx,Posy,slide_speed;

// Configuration variables
gchar *fontname,*title_format,*empty_picture,*image_dir, *image_keywords, *search_order, *get_all;
gboolean ratio,slide,conf,skinned,fullscreen,redrawskin,net_search,title_display,
		lock_file,smart_search,album_search,auto_hide,show_button;
gboolean managing;

GtkWidget *window,*drawzone;
int init,moving,slide_pause,im_found;
int imcount,scroll,scrolldir;
gboolean shuffle,repeat,internet_search,stream_play;
gint from_dir;
gchar *script_net,*script_album;
gchar *tempdir, *tempimg;;
GdkPixmap *imagebuffer;
struct image_name_buffer *first,*curimage;


void init_temp_img();
void clean_temp();
void purge_temp();

gchar *up(gchar *str);
gchar *replace(gchar *str, gchar *oldchaine, gchar *newchaine);
gchar *find_file(gchar *path, gchar *filter);
gchar *exists_file(gchar *path, gchar *filter, gchar *ext);
#endif
