#include "Prefs.h"

#include "CEgIOFile.h"
#include "EgOSUtils.h"

#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

Prefs::Prefs( const char* inPrefsName, bool inSysStored ) {

	mSysStored	= inSysStored;
	mDirty		= true;

	if ((inPrefsName != NULL) && (inPrefsName[0] == '~')) {
		mPrefName.Assign( g_get_home_dir() );
		mPrefName.Append( &inPrefsName[1] );
	}
	else { mPrefName.Assign( inPrefsName ); }

	mFileSpec.Assign( mPrefName.getCStr(), 0 );
}

CEgErr Prefs::Load() {
	CEgIFile iFile;
	
	mPrefs.Clear();
	iFile.open( &mFileSpec );
	mPrefs.SetArgs( &iFile );
	
	if ( iFile.noErr() )
		mDirty = false;
	
	return iFile;
}


CEgErr Prefs::Store() {
	CEgIOFile oFile;
	
	if ( mDirty ) {
		long origType = CEgIOFile::sCreatorType;
		#if EG_MAC
		CEgIOFile::sCreatorType = 'ttxt';
		#elif EG_WIN
		CEgIOFile::sCreatorType = '\?\?\?\?';
		#endif

		oFile.open( &mFileSpec );
		
		if ( oFile.noErr() ) {

			mPrefs.ExportTo( &oFile, true );
			oFile.Writeln();
		}
		mDirty = false;
		CEgIOFile::sCreatorType = origType;
	}
	
	return oFile;
}


void Prefs::SetPref( long inID, const UtilStr& inData ) { 
	
	if ( ! mDirty ) {
		const UtilStr* str;
		
		str = mPrefs.GetStr( inID );
		if ( str ) {
			if ( str -> compareTo( &inData ) )
				mDirty = true; }
		else
			mDirty = true;
	}
	
	mPrefs.SetArg( inID, inData );
}


void Prefs::SetPref( long inID, long inData ) {
	bool exists;
	long num;
	
	if ( ! mDirty ) {
	
		exists = mPrefs.GetArg( inID, num );
		if ( ! exists || num != inData )
			mDirty = true;
	}
	
	mPrefs.SetArg( inID, inData );
}
