#include "FrameBuffer.h"


FrameBuffer::FrameBuffer( int inDepth ) {
	
	if ( inDepth != 1 && ( inDepth & 0x7 != 0 ) )
		inDepth = 8;
	
	Resize( 0, 0, inDepth );
}




void FrameBuffer::Resize( int inX, int inY, int inDepth ) {
	long bytesPerRow;
	
	
	if ( inDepth <= 0 )
		inDepth = mDepth;
		
	// If depth isn't 1 or a multiple of 8, then fix it
	if ( inDepth != 1 && ( inDepth & 0x7 != 0 ) )
		inDepth = 8 * ( ( inDepth + 7 ) / 8 );

	if ( inX < 0 )	
		inX = 0;

	bytesPerRow = ( inDepth * inX + 7 ) / 8;

	Assign( 0, inX, inY, bytesPerRow, inDepth );
}




void FrameBuffer::Assign( char* inSource, int inX, int inY, int inBytesPerRow, int inDepth ) {
	long newSize;
	unsigned char *row;
	
	if ( inDepth <= 0 )
		inDepth = mDepth;
		
	// If depth isn't 1 or a multiple of 8, then fix it
	if ( inDepth != 1 && ( inDepth & 0x7 != 0 ) )
		inDepth = 8 * ( ( inDepth + 7 ) / 8 );

	// Redim the frame buffer....
	if ( inX < 0 )	inX = 0;
	if ( inY < 0 )	inY = 0;		
	mBounds.right = inX;
	mBounds.bottom = inY;
	
	mDepth = inDepth;
	mBytesPerRow = ( mDepth * inX + 7 ) / 8;

	newSize = mBytesPerRow * ( inY + 1 );
	
	mBits = mTempMem.Dim( newSize );
	
	if ( inSource ) {
		
		for ( int y = 0; y < inY; y++, inSource += inBytesPerRow ) {
			row = GetRow( y );
			for ( int x = 0; x < mBytesPerRow; x++ )
				row[ x ] = inSource[ x ];
		}
	}
}





/*

void FrameBuffer::Assign1Bit( VFrameBuffer* inFrame ) {
	unsigned char* base, *srce;
	long bits, x, y, b;

	FrameBuffer temp;
	
	temp.Assign8Bit( inFrame );
	Resize( GetX(), GetY(), 1 );
	
	for ( y = 0; y < inY; y++, inBits += mBytesPerRow ) {		
	??		
		base = GetRow( y );
		srce = temp.GetRow( y );		
		for ( x = 0; x < inX; x++ ) {				
			for ( bits = 0, b = 0; b < 8 && x < inX; b++, x++ ) {
				if ( srce[ x ] < 160 )  // Bias the 1 bit color a little: grays look more white than black
					bits = ( bits << 1 );
				else
					bits = ( bits << 1 ) | 1;
			}
			base[ x ] = bits;				
		}
	}
}
*/





void FrameBuffer::Assign8Bit( char* inSourceBits, int inX, int inY, int inBytesPerRow, int inDepth ) {
	VFrameBuffer srce;
	
	srce.Assign( inSourceBits, inX, inY, inBytesPerRow, inDepth );
	Assign8Bit( &srce );
}



void FrameBuffer::Assign8Bit( const VFrameBuffer* inSrce ) {


	if ( inSrce ) {
		Resize( inSrce -> GetX(), inSrce -> GetY(), 8 );
	
		/* I'm sitting on Seal's couch, in LA, writing this.  Lord, catch me... you have taken me so far.  Permit me to be your soldier, 
			and remind us that no matter how rich or powerful we are, we are still just men.  As I was shown Rodeo Drive 
			and the milllion dollar shops upon it, as I hear about ten-thousands suits being bought by the armload, I am
			reminded of a poem by Emily Dickinson...
			
				Success is counted sweetest
				By those who ne'er succeed,
				To comprehend a nectar
				Requires the sorest need.
				
				Not one of all the purple host
				Who took the flag to-day
				Can tell the definition,
				So clear, of victory.
				
				As he, defeated, dying,
				On whose forbidden ear
				The distant strains of triumph
				Break, agonized and clear.

		*/
		
		CopyBits( inSrce, mBounds, 0, 0, nil );
	}
}




