
#ifndef __FILE_SYS_ID_LIST_H__
#define __FILE_SYS_ID_LIST_H__

#include "AbstractStrList.h"
#include "GeneralFileSys.h"

#define FILE_SYS_STRIP_EXTNS	0x1
#define FILE_SYS_SORT_CI	0x2
#define FILE_SYS_SORT_CS	0x4
#define FILE_SYS_UNSORTED	0x8


class FileSysItemInfo {

public:
	UtilStr		mName;
	FileObj		mFileID;
};


class FileSysIDList : public AbstractStrList {

public:
	FileSysIDList();
	virtual	~FileSysIDList();

	// Sorts the item IDs in <inIDs> according to <inFlags>
	virtual void		Assign( GeneralFileSys* inFileSys, const XLongList& inIDs, long inFlags );

	// See AbstractStringArray.h for docs
	virtual const UtilStr*	Fetch( long inIndex ) const;

	// Looks for an item ID that matches the given string.
	// Returns FILE_SYS_INVALID_ID if item was not found
	FileObj			FindID( const UtilStr* inName,	bool inCaseSensitive = false ) const;
	FileObj			FindID( const char* inName, 	bool inCaseSensitive = false ) const;

	// Remove an item...
	void			RemoveItem( const UtilStr* inName, bool inCaseSensitive = false );

	// Returns the itemID at index inIndex (1 based indexing)
	// Returns FILE_SYS_INVALID_ID if item was not found
	FileObj			FetchID( long inIndex ) const;

	// Add a single file ID, to be indexed by the given name
	void			Add( const UtilStr* inName, FileObj inID, long inFlags );

protected:
	virtual void		DeleteItem( void* inPtr )									{ delete (FileSysItemInfo*) inPtr;						}

	static int		sNameComparitor( const void* inA, const void* inB, const void* inThis );
};

#endif // __FILE_SYS_ID_LIST_H__
