
#ifndef __MEM_FILE_SYS_H__
#define __MEM_FILE_SYS_H__

#include "GeneralFileSys.h"
#include "DictValue.h"

#include "Hashtable.h"

class CEgIStream;
class CEgOStream;
class MemFileSysDir;

class MemFileItem : public DictValue{

	public:
								MemFileItem();
		virtual 				~MemFileItem();

		unsigned long			mFlags;
		FileObj					mParent;
		UtilStr					mData;
		const UtilStr*			mName;			// Stored in MemFileSysDir name lookup hashtable
		MemFileSysDir*			mDir;			// Turns titles into file IDs
};






/*
    This class is a complete RAM-stored data structure acts as a virtual HFS storage.  It's
designed for speed in all categories and has no bottlenecks (ALL functions are O(1), ie,
the time needed to complete each fcn is independent of the number of items in the
file system.  For example, you could store a phonebook's worth of entries and time
to complete each fcn stays the same.   NOTE: that all titles used in MemFileSys (ie,
GetItemID()) are case sensitive!
	The only tradeoff is allocaton:  Each file object requires two data objects of
a couple dozen bytes each (as well as the bytes needed to store each object's title
and data portions).  Each folder object requires an additional hashtable on top
of that (another two separate structures each a dozen bytes).
    So if you have the RAM, no other data structure will beat MemFileSys in any category
or under any data circumstances.
*/


class MemFileSys : public GeneralFileSys {

	friend class MemFileSysDir;
	friend class MemFileSysDupes;

public:
	MemFileSys( bool inUniqueTitles );
	~MemFileSys();

	// See GeneralFileSys.h for the descriptions of all the fcns
	virtual FileResult		Catalog( FileObj inID, XLongList& outList );
	virtual FileResult		GetItemID( FileObj inParentID, const UtilStr& inTitle, FileObj& outID );
	virtual long			GetInfo( FileObj inID, long inParamID, FileResult* outResult = NULL );
	virtual FileResult		SetInfo( FileObj inID, long inParamID, long inParam );
	virtual FileResult		WriteData( FileObj inID, void* inData, long inNumBytes );
	virtual FileResult		SetName( FileObj inID, const UtilStr& inName );
	virtual const UtilStr*		GetName( FileObj inID );
	virtual FileResult		Read( FileObj inID, UtilStr& outBuf );
	virtual FileResult		Create( FileObj inParentID, const UtilStr& inTitle, FileObj& outID, long inFlags );
	virtual FileResult		Create( FileObj inParent, FileObj& outID, long inFlags )								{  return GeneralFileSys::Create( inParent, outID, inFlags );	}
	virtual FileResult		Delete( FileObj inID );
	virtual FileResult		DeleteContents( FileObj inID );
	virtual FileResult		GetParent( FileObj inID, FileObj& outParent );
	virtual FileResult		Move( FileObj inID, FileObj inNewParent, bool inReplace = true );

	// This is functionally identical to Read( FileObj, UtilStr& ) but is faster
	//    b/c data is not recopied.  This should be used only for instantanious access (ie,
	//    use the ptr immediately and don't use it again.  You'd want to use this version of Read()
	//    when there's lots of data and recopying it would be a waste.  Avoid using this whenever possible.
	// Note:  NULL is returned if the read failed (and the error info can be accessed via GetLastError())
	// Note:  For obvious reasons, this fcn should *not* be used in a multithreaded environment when
	//    write operations could operate in the same ID.
	const UtilStr*			Read( FileObj inID );
	void*				Get( FileObj inID );

	void				WriteToStream( FileObj inID, CEgOStream* inOStream );
	void				ReadFromStream( CEgIStream* inOStream );

protected:
	Hashtable			mSys;
	FileObj				mNextID;

	bool				TryReplace( MemFileItem* inDestParent, const UtilStr& inNewItem, bool inReplace );
	bool				GetFolder( FileObj inFolder, MemFileItem** outFolder );

	void				ReadFromStream_Internal( CEgIStream* inOStream );

	// Similar to Delete() except dir names aren't maintained
	FileResult			internalDelete( FileObj inID, bool inUpdateParent );

#ifdef EG_DEBUG
	long				mItemCount;
#endif
};

#endif // __MEM_FILE_SYS_H__
