
#ifndef __MEM_FILE_SYS_DIR__H__
#define __MEM_FILE_SYS_DIR__H__

#include "Hashtable.h"
#include "MemFileSys.h"

class MemFileSys;


/* This class is used internally inside MemFileSys.  Each instance of MemFileItem represents
*/

#define 	MEM_FILE_SYS_UNIQUE		1
#define		MEM_FILE_SYS_DUPE		2
#define		MEM_FILE_SYS_FNF		3

class MemFileSysDir : protected Hashtable {

public:
	MemFileSysDir();

	/* 	Looks for the given name, passes back its ID and returns one of the following:
		MEM_FILE_SYS_UNIQUE	-> Successful and name was unique
		MEM_FILE_SYS_DUPE 	-> Successful but name was not unique (and an arbitrary ID was chosen)
		MEM_FILE_SYS_FNF	-> Fail, the given bane was not found  */
	long			LookupName( const UtilStr* inName, FileObj& outID );

	const UtilStr*		AddName( const UtilStr* inName, FileObj inID );

	void			RemoveName( const UtilStr* inName, FileObj inID );

	void			RemoveAll( MemFileSys* inFileSys );

	// Returns a list of all the file items in this list...
	void			Catalog( XLongList& outList );

	long			NumEntries()				{ return Hashtable::NumEntries();	}
};

class MemFileSysDupes : protected Hashtable {

public:
	void			DeleteSubsFromFileSys( MemFileSys* inFileSys );
};

#endif // __MEM_FILE_SYS_DIR__H__
