

#ifndef RenderedGraphic_H
#define RenderedGraphic_H

/*  A RenderedGraphic represents a LogicalGraphic on a given output device.  It tracks/understands how much drawing has been done so
that subsequent updates don't necessitate a complete redraw or regen of components already computed.  RenderedGraphics
are associated with the drawing device they're being drawn on.  */
class RenderedGraphic {


	protected:
		
		// How we track what's on the screen (ie, this is a version number--everytime the master changes, it gets a newer ID)
		long						mRenderID;
		
		// The region on the output window fouled by this object (ie, the extents of mDrawCmds)
		Rect						mDirtyRgn;
		
		??	 						mNextUpdateTime; // Watch out -- this is dep on viewing param (ex, zoom scale)

};



#endif

