/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SDL_GFORCE_STATUS_H__
#define __SDL_GFORCE_STATUS_H__

#include <gtk/gtk.h>
#include <SDL/SDL_video.h>
#include <SDL/SDL_ttf.h>

#include <pthread.h>

#include "singit/song.h"
#include "singit/config_gen.h"
#include "singit/karaoke_data.h"
#include "singit/framerate_counter.h"
#include "singit/singleton.h"

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_SDL_GFORCE_STATUS            (sdl_gforce_status_get_type ())
#define SDL_GFORCE_STATUS(obj)            (GTK_CHECK_CAST ((obj), TYPE_SDL_GFORCE_STATUS, SDLGForceStatus))
#define SDL_GFORCE_STATUS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SDL_GFORCE_STATUS, SDLGForceStatus))
#define IS_SDL_GFORCE_STATUS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SDL_GFORCE_STATUS))
#define IS_SDL_GFORCE_STATUS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SDL_GFORCE_STATUS))

typedef struct _SDLGForceStatus       SDLGForceStatus;
typedef struct _SDLGForceStatusClass  SDLGForceStatusClass;

struct _SDLGForceStatus
{
	SingitSingleton       singleton;

	SingitConfigGen      *config;

	SingitSong           *song;
	GList                *next_lyric_line;

	gboolean toggle_yz;
	gboolean print_debug;
	gboolean is_fullscreen;

	guint time;
	gint toplines;
	gint lines;

	SDL_Surface *screen;
	SDL_Surface *current_text;
	SDL_Surface *next_text;
	TTF_Font *font;

	gint jump_to_song;
	SingitKaraokeData *skd;

	gboolean sdl_inuse;

	gboolean xmms_playing;
	gboolean singit_playing;

	guint longest_line;

	pthread_t render_thread;
	gboolean kill_render_thread;
	gboolean shutdown;

	SingitFramerateCounter *sfc;
};

struct _SDLGForceStatusClass {

	SingitSingletonClass  parent_class;
};

GtkType            sdl_gforce_status_get_type(void);

SingitSingleton*   sdl_gforce_status_ref(void);
void               sdl_gforce_status_unref(SingitSingleton** single);

SingitSingleton*   sdl_gforce_status_noref(void);

#define STATUS \
	SDL_GFORCE_STATUS(sdl_gforce_status_noref())

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif // __SDL_GFORCE_STATUS_H__
