/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2003 Nicolas Adenis-Lamarre (aspegic500@free.fr)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "singit/macros.h"
#include "singit/control.h"
#include "singit/config_xmms.h"
#include "singit/displayer_plugin.h"

#include "displayer_xosd_config.h"
#include "displayer_xosd_status.h"

SingitConfigXMMS *displayer_xosd_config = NULL;

extern DisplayerPlugin xosd_dp;

static gpointer displayer_xosd_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
  XosdConfigData *xosd_config_data = g_malloc(sizeof(XosdConfigData));

  xosd_config_data->forceGlobals = TRUE;
  xosd_config_data->debugEnable = FALSE;

  xosd_config_data->lyricFontName = NULL;
  xosd_config_data->normalTextColor = NULL;
  //xosd_config_data->progressTextColor = NULL;
  //xosd_config_data->progressBarColor = NULL;

  xosd_config_data->position=XOSD_top;
  xosd_config_data->alignement=XOSD_left;

  return xosd_config_data;
}

static void displayer_xosd_config_free_event(SingitConfigGen *scg, XosdConfigData *cfg_data, gpointer user_data)
{
  if (cfg_data->lyricFontName) { g_free(cfg_data->lyricFontName); }
  if (cfg_data->normalTextColor) { g_free(cfg_data->normalTextColor); }
  //if (cfg_data->progressTextColor) { g_free(cfg_data->progressTextColor); }
  //if (cfg_data->progressBarColor) { g_free(cfg_data->progressBarColor); }

  g_free(cfg_data);
}

#define GBL_VAR      forceGlobals
#define GBL_SESSION  xosd_dp.singit_session
#define CFG_DATA     cfg_data
#define CFG_FILE     cfg_file
#define SECTION     "DisplayerXosd"

static void displayer_xosd_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, XosdConfigData *cfg_data, gpointer user_data)
{
  READ_CFG_DEF(boolean,forceGlobals,TRUE);
  //READ_CFG_DEF_GBL(boolean, showEmpty,);
  //READ_CFG_DEF_GBL(boolean, autoResize,);
#ifdef CODEDEBUG
	READ_CFG_DEF_GBL(boolean,debugEnable,debug_enabled);
#endif
	READ_CFG_DEF_GBL(string,lyricFontName,lyric_font_name);
	READ_CFG_DEF_GBL_ARG(color,normalTextColor,color,1);

  //READ_CFG_DEF_GBL(color,progressTextColor,g_strdup);
  //READ_CFG_DEF_GBL(color,progressBarColor,g_strdup);

  // * global independant config *
  READ_CFG_DEF(int,shadow_offset,-1);
  READ_CFG_DEF(int,h_offset,-1);
  READ_CFG_DEF(int,v_offset,-1);

  READ_CFG_DEF_CAST(int,alignement,-1);
  READ_CFG_DEF_CAST(int,position,-1);
}

static void displayer_xosd_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, XosdConfigData *cfg_data, gpointer user_data)
{
  // * boolean values *
  WRITE_CFG(boolean, forceGlobals);
  //WRITE_CFG(boolean, showEmpty);
  //WRITE_CFG(boolean, autoResize);
#ifdef CODEDEBUG
  WRITE_CFG(boolean, debugEnable);
#endif

  // * string values *
  WRITE_CFG(del_string, lyricFontName);
  WRITE_CFG(del_string, normalTextColor);
  //WRITE_CFG(del_string, progressTextColor);
  //WRITE_CFG(del_string, progressBarColor);

  // * global independant config *
  WRITE_CFG(int, position);
  WRITE_CFG(int, alignement);

  WRITE_CFG(int, shadow_offset);
  WRITE_CFG(int, h_offset);
  WRITE_CFG(int, v_offset);
}

#undef SECTION
#undef CFG_FILE
#undef CFG_DATA
#undef GBL_SESSION
#undef GBL_VAR

static void displayer_xosd_config_update_event(SingitConfigGen *scg)
{
	XosdConfigData *ccd;

	g_return_if_fail(scg != NULL);

	ccd = singit_config_gen_get_data(scg);

	if (ccd->forceGlobals == FALSE) {
		displayer_xosd_status_set_font(STATUS, ccd->lyricFontName);
		displayer_xosd_status_set_color(STATUS, ccd->normalTextColor);
	}
	else {
		displayer_xosd_status_set_font
			(STATUS, singit_remote_cfg_lyric_font_name(xosd_dp.singit_session));
		displayer_xosd_status_set_color
			(STATUS, singit_remote_cfg_color(xosd_dp.singit_session, 1));
	}

	displayer_xosd_status_set_alignement(STATUS, ccd->alignement);
	displayer_xosd_status_set_position(STATUS, ccd->position);
	displayer_xosd_status_set_v_offset(STATUS, ccd->v_offset);
	displayer_xosd_status_set_h_offset(STATUS, ccd->h_offset);
	displayer_xosd_status_set_shadow_offset(STATUS, ccd->shadow_offset);
}

SingitConfigGen* displayer_xosd_config_new(void)
{
	SingitConfigGen *dcc;

	g_return_val_if_fail(displayer_xosd_config == NULL,
		SINGIT_CONFIG_GEN(displayer_xosd_config));

	dcc = singit_config_xmms_new();
	displayer_xosd_config = SINGIT_CONFIG_XMMS(dcc);
	singit_config_gen_clear_initial
		((SingitConfigGen**) &displayer_xosd_config);
	singit_config_gen_set_filename(dcc, CONFIG_FILENAME);

	gtk_signal_connect(GTK_OBJECT(dcc), "init_data",
		GTK_SIGNAL_FUNC(displayer_xosd_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "free_data",
		GTK_SIGNAL_FUNC(displayer_xosd_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "load",
		GTK_SIGNAL_FUNC(displayer_xosd_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "save",
		GTK_SIGNAL_FUNC(displayer_xosd_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "update",
		GTK_SIGNAL_FUNC(displayer_xosd_config_update_event), NULL);

	return dcc;
}
