/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EDITOR_QUERY_WIDGET_H__
#define __EDITOR_QUERY_WIDGET_H__

#include <gtk/gtkbin.h>
#include <pthread.h>

#include "editor_query_http.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_EDITOR_QUERY_WIDGET            (editor_query_widget_get_type ())
#define EDITOR_QUERY_WIDGET(obj)            (GTK_CHECK_CAST ((obj), TYPE_EDITOR_QUERY_WIDGET, EditorQueryWidget))
#define EDITOR_QUERY_WIDGET_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_EDITOR_QUERY_WIDGET, EditorQueryWidgetClass))
#define IS_EDITOR_QUERY_WIDGET(obj)         (GTK_CHECK_TYPE ((obj), TYPE_EDITOR_QUERY_WIDGET))
#define IS_EDITOR_QUERY_WIDGET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_EDITOR_QUERY_WIDGET))

typedef struct _EditorQueryWidget        EditorQueryWidget;
typedef struct _EditorQueryWidgetClass   EditorQueryWidgetClass;

struct _EditorQueryWidget
{
	GtkBin             bin;

	GtkWidget         *query_result_clist;
	GtkWidget         *artist_combo;
	GtkWidget         *album_combo;
	GtkWidget         *title_combo;

	pthread_t          query_thread;

	GList             *servers; // List of LyrixRequestHTTP stucts
	LyrixRequest      *request;
	LyrixQueryResult  *query_res;
	HTTPProxy         *default_proxy;

	SearchMatch        artist_match;
	SearchMatch        title_match;
};

struct _EditorQueryWidgetClass
{
	GtkBinClass        parent_class;

	void     (* set_text)   (EditorQueryWidget *eqw, const gchar *text);
	gchar**  (* get_text)   (EditorQueryWidget *eqw);
	void     (* error_info) (EditorQueryWidget *eqw, const gchar *text);
};

GtkType    editor_query_widget_get_type  (void);
GtkWidget* editor_query_widget_new       (void);

// This checks the server object and  appends it to the server list
// The object has to be createted with
//	lyrix_request_data_new
// and _must_ not be freed!
gboolean   editor_query_widget_add_server
	(EditorQueryWidget *eqw, LyrixRequestHTTP *server);

void       editor_query_widget_set_default_proxy
	(EditorQueryWidget *eqw, HTTPProxy *proxy);

void  editor_query_widget_set_search_matches
	(EditorQueryWidget *eqw, SearchMatch artist, SearchMatch title);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __EDITOR_QUERY_WIDGET_H__
