/* readicon.c - xpm2wico - .xpm to Windows .ico format converter
 *
 * Copyright (C) 2001-2002 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include "winutils.h"
#include "xpm2wico.h"

void print_icon_dir (IconDir *icon_dir)
{
  printf ("reserved = %x\n"
	  "type = %x\n"
	  "count = %x\n"
	  "entries = %x\n\n",
	  icon_dir->idReserved,
	  icon_dir->idType,
	  icon_dir->idCount,
	  (int) icon_dir->idEntries);
}

void print_icon_dir_entry (IconDirEntry *icon_dir_entry)
{
  printf ("IconDirEntry:\n"
	  "width = %u\n"
	  "height = %u\n"
	  "nbr_colors = %u\n"
	  "planes = %u\n"
	  "bitcount = %u\n"
	  "bytes_in_res = %u\n"
	  "offset = %u\n\n",
	  icon_dir_entry->bWidth,
	  icon_dir_entry->bHeight,
	  icon_dir_entry->bColorCount,
	  icon_dir_entry->wPlanes,
	  icon_dir_entry->wBitCount,
	  (int) icon_dir_entry->dwBytesInRes,
	  (int) icon_dir_entry->dwImageOffset);
}

IconDirEntry *read_icon_dir_entry (FILE *file)
{
  IconDirEntry *icon_dir_entry;

  icon_dir_entry = malloc (sizeof (IconDirEntry));
  icon_dir_entry->bWidth = read_byte (file);
  icon_dir_entry->bHeight = read_byte (file);
  icon_dir_entry->bColorCount = read_byte (file);
  icon_dir_entry->bReserved = read_byte (file);
  icon_dir_entry->wPlanes = read_word (file);
  icon_dir_entry->wBitCount = read_word (file);
  icon_dir_entry->dwBytesInRes = read_dword (file);
  icon_dir_entry->dwImageOffset = read_dword (file);

  return icon_dir_entry;
}

int icon_ok (IconDir *header)
{
  int ret_code;

  if (header->idReserved != 0
      || header->idType != 1
      || header->idCount == 0)
    ret_code = 0;
  else
    ret_code = 1;

  return ret_code;
}

BitmapInfoHeader *read_bm_ih (FILE *icon)
{
  BitmapInfoHeader *bm_ih;

  bm_ih = malloc (sizeof (BitmapInfoHeader));
  bm_ih->biSize = read_dword (icon);
  bm_ih->biWidth = read_long (icon);
  bm_ih->biHeight = read_long (icon);
  bm_ih->biPlanes = read_word (icon);
  bm_ih->biBitCount = read_word (icon);
  bm_ih->biCompression = read_dword (icon);
  bm_ih->biSizeImage = read_dword (icon);
  bm_ih->biXPelsPerMeter = read_long (icon);
  bm_ih->biYPelsPerMeter = read_long (icon);
  bm_ih->biClrUsed = read_dword (icon);
  bm_ih->biClrImportant = read_dword (icon);

  return bm_ih;
}

void print_bm_ih (BitmapInfoHeader *bm_ih)
{
  printf ("BitmapInfoHeader:\n"
	  "biSize = %d\n"
	  "biWidth = %d\n"
	  "biHeight = %d\n"
	  "biPlanes = %d\n"
	  "biBitCount = %d\n"
	  "biCompression = %d\n"
	  "biSizeImage = %d\n"
	  "biXPelsPerMeter = %d\n"
	  "biYPelsPerMeter = %d\n"
	  "biClrUsed = %d\n"
	  "biClrImportant = %d\n",
	  bm_ih->biSize, bm_ih->biWidth, bm_ih->biHeight,
	  bm_ih->biPlanes, bm_ih->biBitCount, bm_ih->biCompression,
	  bm_ih->biSizeImage, bm_ih->biXPelsPerMeter,
	  bm_ih->biYPelsPerMeter, bm_ih->biClrUsed,
	  bm_ih->biClrImportant);
}

void read_icon_data (FILE *icon, IconDir *header)
{
  IconDirEntry *icon_dir_entry;
  BitmapInfoHeader *icHeader;

  icon_dir_entry = header->idEntries;

  fseek (icon, icon_dir_entry->dwImageOffset, SEEK_SET);
  icHeader = read_bm_ih (icon);

  print_bm_ih (icHeader);
}

int read_icon (FILE *icon)
{
  int ret_code;
  IconDir header;

  header.idReserved = read_word (icon);
  header.idType = read_word (icon);
  header.idCount = read_word (icon);
  header.idEntries = read_icon_dir_entry (icon);

  if (!icon_ok (&header))
    {
      printf ("This file is not a windows ico file\n");
      ret_code = EXIT_FAILURE;
    }
  else
    {
      print_icon_dir (&header);
      print_icon_dir_entry (header.idEntries);

      read_icon_data (icon, &header);

      ret_code = EXIT_SUCCESS;
    }

  return ret_code;
}

int main (int argc, char *argv[])
{
  int ret_code;
  FILE *icon;

  if (!argv[1])
    {
      fprintf (stderr, "Please specify an icon file as argument...\n");
      exit (EXIT_FAILURE);
    }
	  
  icon = fopen (argv[1], "r");

  if (icon)
    ret_code = read_icon (icon);
  else
    {
      perror (argv[0]);
      ret_code = EXIT_FAILURE;
    }

  return ret_code;
}
