#ifndef debug_h
#define debug_h

#include "format.h"

enum DModule
  {
    MODULE_ALL  = -1,
    MODULE_ARG  = 1,
    MODULE_MAIN,
    MODULE_TREE,
    MODULE_CPPDIR,
    MODULE_SETUP,
    MODULE_NIGNORE
  };

extern Format::PrintF<std::ostream> out;
extern Format::PrintF<std::ostream> vout;
extern Format::PrintF<std::ostream> eout;

DModule string2module( std::string module );

std::string x2s( DModule module );

#define ERROR eout( MODULE_ALL )[0]( "%s: ", PACKAGE )[0]

#ifdef NDEBUG
#  define DEBUG( expr )
#  define DEBUG_OUT( level, module ) out(module)[level]
#else
#  define DEBUG( expr ) expr
#  define DEBUG_OUT( level, module ) out(module)[level]( "%s:%s: ", __FILE__, __LINE__ )[level]
#endif

#endif
