/* $Id: restore_tide_db.h,v 1.2 2002/10/03 15:13:28 flaterco Exp $ */

#include <stdio.h>
#include "nvtypes.h"



/*****************************************************************************\

                            DISTRIBUTION STATEMENT

    This source file is unclassified, distribution unlimited, public
    domain.  It is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

\*****************************************************************************/




/*  This file contains all of the extra verbiage for the XTide format
    harmonic constituent ASCII files and the XTide format subordinate station
    .xml files.  This is used by restore_tide_db when dumping a harmonic
    constituent database back to XTide format files.  */


/*  Legal BS.  */
/* Dollar sign \044 obfuscated to avoid CVS conflicts. */

NV_CHAR legal[] = {"\
# \044Id$\n\
#\n\
# ** The following boilerplate text is a placeholder only.  Please **\n\
# ** replace it with the up-to-date boilerplate and changelog.     **\n\
# Definitions and constants for xtide\n\
#\n\
# NOTE:  This file cannot be used as-is with harmgen because it\n\
# contains multiple constituents with the same frequency.  You must\n\
# reduce the constituent set before running harmgen.\n\
#\n\
# ********* NOT FOR NAVIGATION ********\n\
#\n\
# *** DO NOT RELY ON THIS DATA FILE FOR DECISIONS THAT CAN RESULT IN ***\n\
# ***                   HARM TO ANYONE OR ANYTHING.                  ***\n\
#\n\
# This data file is distributed in the hope that it will be useful,\n\
# but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\
#\n\
# Agencies like NOAA exist because there is a need for certifiably\n\
# correct tide predictions.  Please don't rely on this data if you need\n\
# guaranteed results.  There is NO WAY I can get certified data on a\n\
# zero budget.  I rely on users like you to tell me when something is\n\
# wrong.  Please continue to do so.\n\
#\n\
# WHOSOEVER CHOOSES TO REDISTRIBUTE THIS DATA ASSUMES ALL LIABILITY\n\
# ASSOCIATED THEREWITH.  NEITHER FLATERCO, INC., NOR DAVID FLATER, NOR\n\
# ROBERT KENNEY, NOR JAN DEPNER SHALL BE LIABLE PERSONALLY OR OTHERWISE\n\
# FOR ANY LOSSES THAT THE REDISTRIBUTOR MIGHT SUFFER AS A CONSEQUENCE OF\n\
# ANY CLAIMS THAT ARE MADE TO THIS DATA.\n\
#\n"};


NV_CHAR pre_num[] = {"\
#\n\
# ------------- Begin congen output -------------\n\
#\n\
# Number of constituents\n"};


NV_CHAR pre_speed[] = {"\
#\n\
# Constituent speeds\n\
# Format:  identifier [whitespace] speed [CR]\n\
# Speed is in degrees per solar hour.\n\
# Identifier is just a name for the constituent.  They are for\n\
# readability only; xtide assumes that the constituents will be listed\n\
# in the same order throughout this file.\n"};


NV_CHAR pre_year[] = {"\
#\n\
# Starting year for equilibrium arguments and node factors\n"};


NV_CHAR pre_equilibrium[] = {"\
#\n\
# The following table gives equilibrium arguments for each year that\n\
# we can predict tides for.  The equilibrium argument is in degrees for\n\
# the meridian of Greenwich, at the beginning of each year.\n\
#\n\
# First line:  how many years in this table [CR]\n\
# Remainder of table:  identifier [whitespace] arg [whitespace] arg...\n\
# Carriage returns inside the table will be ignored.\n\
#\n\
# The identifiers are for readability only; xtide assumes that they\n\
# are in the same order as defined above.\n\
#\n\
# DO NOT PUT COMMENT LINES INSIDE THE FOLLOWING TABLE.\n\
# DO NOT REMOVE THE \"*END*\" AT THE END.\n"};


NV_CHAR pre_node[] = {"\
#\n\
# Now come the node factors for the middle of each year that we can\n\
# predict tides for.\n\
#\n\
# First line:  how many years in this table [CR]\n\
# Remainder of table:  identifier [whitespace] factor [whitespace] factor...\n\
# Carriage returns inside the table will be ignored.\n\
#\n\
# The identifiers are for readability only; xtide assumes that they\n\
# are in the same order as defined above.\n\
#\n\
# DO NOT PUT COMMENT LINES INSIDE THE FOLLOWING TABLE.\n\
# DO NOT REMOVE THE \"*END*\" AT THE END.\n"};


NV_CHAR pre_data[] = {"\
#\n\
# ------------- End congen output -------------\n\
#\n\
# Harmonic constants.\n\
#\n\
# First line:  name of location\n\
# Second line:  time meridian [whitespace] tzfile\n\
# Third line:  DATUM [whitespace] units\n\
# Remaining lines:  identifier [whitespace] amplitude [whitespace] epoch\n\
#\n\
# The DATUM is the mean lower low water, or equivalent number for\n\
# calculating the absolute tide height.\n\
# The time meridian takes the format [-]HH:MM and is hours east of\n\
# Greenwich.  This is your time zone displacement in the _winter_.  Do\n\
# not include Daylight Savings Time!\n\
# The tzfile is a reference to a file in the zoneinfo directory as\n\
# described in the man page for tzset.\n\
# Epoch is \"modified\" or \"adapted\" epoch in degrees, also known as\n\
# Kappa Prime.\n\
# The identifiers are for readability only; xtide assumes that they\n\
# are in the same order as defined above.\n\
#\n\
# These data sets are included here without any effort to verify their\n\
# accuracy.  They are distributed in the hope that they will be useful,\n\
# but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\
#\n"};


/* Dollar sign \044 obfuscated to avoid CVS conflicts. */
NV_CHAR legal_xml[] = {"\
<?xml version=\"1.0\" encoding='ISO-8859-1'?>\n\
<!-- \044Id$ -->\n\
\n\
<!-- ** The following boilerplate text is a placeholder only.  Please ** -->\n\
<!-- ** replace it with the up-to-date boilerplate and changelog.     ** -->\n\
\n\
<!--\n\
\n\
Offset tide stations for use with XTide version 2.2.2 or later.\n\
\n\
All coordinates given in this file are approximate.  All tide\n\
predictions produced through the application of offsets are\n\
approximate.\n\
\n\
********* NOT FOR NAVIGATION ********\n\
\n\
*** DO NOT RELY ON THIS DATA FILE FOR DECISIONS THAT CAN RESULT IN ***\n\
***                   HARM TO ANYONE OR ANYTHING.                  ***\n\
\n\
This data file is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\
\n\
Agencies like NOAA exist because there is a need for certifiably\n\
correct tide predictions.  Please don't rely on this data if you need\n\
guaranteed results.  There is NO WAY I can get certified data on a\n\
zero budget.  I rely on users like you to tell me when something is\n\
wrong.  Please continue to do so.\n\
\n\
WHOSOEVER CHOOSES TO REDISTRIBUTE THIS DATA ASSUMES ALL LIABILITY\n\
ASSOCIATED THEREWITH.  NEITHER FLATERCO, INC., NOR DAVID FLATER, NOR\n\
ROBERT KENNEY, NOR JAN DEPNER SHALL BE LIABLE PERSONALLY OR OTHERWISE\n\
FOR ANY LOSSES THAT THE REDISTRIBUTOR MIGHT SUFFER AS A CONSEQUENCE OF\n\
ANY CLAIMS THAT ARE MADE TO THIS DATA.\n\
\n"};


NV_CHAR pre_data_xml[] = {"\
\n\
For the most part, you should be able to figure out how to encode any\n\
given subordinate station from the documentation at\n\
http://www.flaterco.com/xtide/harmonics.html.  However, there are some\n\
things you should know.\n\
\n\
1.  \"max\" offsets apply to High Tide, Max Flood, and Min Ebb events\n\
    (i.e., all events that appear as maxima in the graph).\n\
2.  \"min\" offsets apply to Low Tide, Max Ebb, and Min Flood events\n\
    (i.e., all events that appear as minima in the graph).\n\
3.  \"level\" (in levelAdd and levelMultiply) refers to tide height\n\
    or current velocity, as applicable.\n\
4.  If slack offsets are not provided for a current station, they will\n\
    be set to the average of the max and min time offsets.\n\
5.  If time zone is not provided, it will be inherited from the\n\
    reference station.\n\
\n\
-->\n\
\n\
<document>\n\
\n"};
