Name: yudit
Version: 2.4
Release: 8
Group: Applications/Editors
License: GPL
Source: %{name}-%{version}.tar.gz
Patch: http://yudit.org/download/yudit-2.4.patch1.txt
Patch1: http://yudit.org/download/yudit-2.4.patch2.txt
Patch2: http://yudit.org/download/yudit-2.4.patch3.txt
Patch3: http://yudit.org/download/yudit-2.4.patch4.txt
Patch4: http://yudit.org/download/yudit-2.4.patch5.txt
Patch5: http://yudit.org/download/yudit-2.4.patch7.txt
Patch6: http://yudit.org/download/yudit-2.4.patch8.txt
Summary: Unicode Text Editor
BuildRoot: /var/tmp/%{name}-%{version}-root
Prefix: /usr

%description
Yudit is a unicode text editor for the X Window System.
It does not need localized environment or unicode fonts.
It supports simultanious processing of many languages,
input methods, conversions for local character standards.
This package includes X11 editor interface, shell conversion
utilities and it also has support for postscript printing.
GNU (C) Gaspar Sinai <gsinai@yudit.org> 

%prep
%setup
%patch -p1 -b .pl1
%patch1 -p0 -b .pl2
%patch2 -p1 -b .pl3
%patch3 -p1 -b .pl4
%patch4 -p1 -b .pl5
%patch5 -p1 -b .pl6
%patch6 -p1 -b .pl7
autoconf
%configure

%build
make

%install
rm -fr $RPM_BUILD_ROOT
mkdir $RPM_BUILD_ROOT
mkdir $RPM_BUILD_ROOT%{prefix}
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/etc/X11/applnk/Editors $RPM_BUILD_ROOT/usr/share/pixmaps
install -m 644 gnome-yudit.png $RPM_BUILD_ROOT/usr/share/pixmaps/yudit.png
cat >$RPM_BUILD_ROOT/etc/X11/applnk/Editors/yudit.desktop <<EOF
[Desktop Entry]
Name=Yudit (Unicode editor)
Type=Application
Description=The Yudit Unicode editor
Exec=yudit
Icon=yudit.png
EOF


%clean

%files
%defattr(-,root,root)
%{prefix}/bin/uniconv
%{prefix}/bin/uniprint
%{prefix}/bin/yudit
%{prefix}/bin/mytool
%{_mandir}/man1/*

%dir %{_datadir}/yudit
%{_datadir}/yudit/data
%{_datadir}/yudit/fonts
%{_datadir}/yudit/src 
%{_datadir}/yudit/doc 
%dir %{_datadir}/yudit/locale
%{_datadir}/yudit/locale/az
%{_datadir}/yudit/locale/bg
%{_datadir}/yudit/locale/de
%{_datadir}/yudit/locale/en
%{_datadir}/yudit/locale/es
%{_datadir}/yudit/locale/fr
%{_datadir}/yudit/locale/hu
%{_datadir}/yudit/locale/ja
%{_datadir}/yudit/locale/sl
%{_datadir}/yudit/locale/sr
%{_datadir}/yudit/locale/yi

%dir %{_datadir}/yudit/config
%config %{_datadir}/yudit/config/*
%config /etc/X11/applnk/Editors/yudit.desktop
%config /usr/share/pixmaps/yudit.png

%doc CHANGELOG.TXT COPYING FAQ.TXT README.TXT TODO.TXT doc/*.utf8 doc/notinstalled doc/problems

%changelog
* Thu Oct 25 2001 Gaspar Sinai <gsinai@yudit.org> patch 1,2,3,4,5,7,8
- renamed yudit-2.4-destdir.patch to //yudit.org/download/yudit-2.4.patch5.txt
- added 7,8
- renamed bz2 to gz in Source:
- removed doc from being doc because yudit uses it.
* Wed Aug 29 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.3-4
- Fix build as non-root
- Add patches from yudit.org
- Set prefix correctly
- Use %%configure
- Add docs
- Add desktop file
- Fix up specfile

