/* cfg_cli.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "cfg_cli.hh"

cfg_cli::cfg_cli (QWidget * parent, groupList * gList, bool write, QTabWidget * tabWv):QWidget
  (parent)
{
  groups = gList;
  CfgWrite = write;
  tabView = tabWv;
  initView ();
  initData ();
  btnSave->setEnabled (false);
  btnDel->setEnabled (false);
  clear ();
}

cfg_cli::~cfg_cli ()
{
}

void
cfg_cli::initView ()
{
  cliGrid = new QGridLayout (this, 4, 3, 3, 3);
  // groups
  grpList = new QListBox (this);
  connect (grpList, SIGNAL (highlighted (int)), this,
	   SLOT (slotGrpListSelected (int)));
  cliGrid->addWidget (grpList, 0, 0);
  grpGroup = new QGroupBox (100, Qt::Vertical, tr ("Groups"), this, "groups");
  gWidget = new QWidget (grpGroup);
  gGrid = new QGridLayout (gWidget, 2, 3, 3, 3);
  lbGrpName = new QLabel (gWidget);
  lbGrpName->setText (tr ("Name"));
  edGrpName = new QLineEdit (gWidget);
  edGrpName->setEnabled (CfgWrite);
  connect (edGrpName, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotEdGrpName (const QString &)));
  gGrid->addWidget (lbGrpName, 0, 0);
  gGrid->addMultiCellWidget (edGrpName, 0, 0, 1, 2);
  btnGrpNew = new QPushButton (gWidget);
  btnGrpNew->setText (tr ("New"));
  connect (btnGrpNew, SIGNAL (clicked ()), this, SLOT (slotGrpBtnNew ()));
  btnGrpSave = new QPushButton (gWidget);
  btnGrpSave->setText (tr ("Save"));
  btnGrpSave->setEnabled (false);
  connect (btnGrpSave, SIGNAL (clicked ()), this, SLOT (slotGrpBtnSave ()));
  btnGrpDel = new QPushButton (gWidget);
  btnGrpDel->setText (tr ("Delete"));
  connect (btnGrpDel, SIGNAL (clicked ()), this, SLOT (slotGrpBtnDel ()));
  btnGrpDel->setEnabled (false);
  gGrid->addWidget (btnGrpNew, 1, 0);
  gGrid->addWidget (btnGrpSave, 1, 1);
  gGrid->addWidget (btnGrpDel, 1, 2);
  cliGrid->addWidget (grpGroup, 0, 1);
  // clients
  cliList = new QListBox (this);
  connect (cliList, SIGNAL (highlighted (int)), this,
	   SLOT (slotListSelected (int)));
  cliGrid->addMultiCellWidget (cliList, 1, 2, 0, 0);

  cliGroup =
    new QGroupBox (100, Qt::Vertical, tr ("Client Computers"), this,
		   "clients");
  cliWidget = new QWidget (cliGroup);
  cGrid = new QGridLayout (cliWidget, 6, 2, 3, 3);
  // name
  lbName = new QLabel (cliWidget);
  lbName->setText (tr ("Name"));
  edName = new QLineEdit (cliWidget);
  edName->setEnabled (CfgWrite);
  connect (edName, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotEdName (const QString &)));
  cGrid->addWidget (lbName, 0, 0);
  cGrid->addWidget (edName, 0, 1);
  // group
  lbGroup = new QLabel (cliWidget);
  lbGroup->setText (tr ("Group"));
  edGroup = new QComboBox (cliWidget);
  edGroup->setEnabled (CfgWrite);
  connect (edGroup, SIGNAL (activated (const QString &)), this,
	   SLOT (slotEdGroup (const QString &)));
  cGrid->addWidget (lbGroup, 1, 0);
  cGrid->addWidget (edGroup, 1, 1);
  // ip
  lbIp = new QLabel (cliWidget);
  lbIp->setText (tr ("IP"));
  edIp = new ipinput (cliWidget);
  edIp->setEnabled (CfgWrite);
  connect (edIp, SIGNAL (textChanged (const QString)), this,
	   SLOT (slotEdIp (const QString)));
  cGrid->addWidget (lbIp, 2, 0);
  cGrid->addWidget (edIp, 2, 1);
  // nr
  lbNr = new QLabel (cliWidget);
  lbNr->setText (tr ("Number"));
  edNr = new QSpinBox (cliWidget);
  edNr->setEnabled (CfgWrite);
  connect (edNr, SIGNAL (valueChanged (int)), this, SLOT (slotEdNr (int)));
  cGrid->addWidget (lbNr, 3, 0);
  cGrid->addWidget (edNr, 3, 1);
  // notes
  lbNotes = new QLabel (cliWidget);
  lbNotes->setText (tr ("Notes"));
  spNotes =
    new QSpacerItem (0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
  edNotes = new QMultiLineEdit (cliWidget);
  edNotes->setEnabled (false);
  cGrid->addWidget (lbNotes, 4, 0);
  cGrid->addItem (spNotes, 5, 0);
  cGrid->addMultiCellWidget (edNotes, 4, 5, 1, 1);
  // end group
  cliGrid->addWidget (cliGroup, 1, 1);
  // buttons
  btnWidget = new QWidget (this);
  btnBox = new QHBoxLayout (btnWidget);
  btnNew = new QPushButton (btnWidget);
  btnNew->setText (tr ("New"));
  btnNew->setEnabled (CfgWrite);
  connect (btnNew, SIGNAL (clicked ()), this, SLOT (slotBtnNew ()));
  btnBox->addWidget (btnNew);
  btnSave = new QPushButton (btnWidget);
  btnSave->setText (tr ("Save"));
  btnSave->setEnabled (false);
  connect (btnSave, SIGNAL (clicked ()), this, SLOT (slotBtnSave ()));
  btnBox->addWidget (btnSave);
  btnSpace =
    new QSpacerItem (0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  btnBox->addItem (btnSpace);
  btnDel = new QPushButton (btnWidget);
  btnDel->setText (tr ("Delete"));
  btnDel->setEnabled (false);
  connect (btnDel, SIGNAL (clicked ()), this, SLOT (slotBtnDel ()));
  btnBox->addWidget (btnDel);
  cliGrid->addWidget (btnWidget, 2, 1);
  // end
  sp1 = new QSpacerItem (0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
  sp2 = new QSpacerItem (0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  cliGrid->addItem (sp2, 0, 2);
  cliGrid->addItem (sp1, 3, 0);
}

void
cfg_cli::initData ()
{
  cliList->clear ();
  grpList->clear ();
  edGroup->clear ();
  compList::iterator ci;
  for (groupList::iterator gi = groups->begin (); gi != groups->end (); ++gi)
    {
      grpList->insertItem ((*gi).name);
      edGroup->insertItem ((*gi).name);
      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	cliList->insertItem ((*ci).name);
    }
}

void
cfg_cli::clear ()
{
  edName->clear ();
  edNr->setValue (0);
  edIp->clear ();
  edNotes->setText ("");
  edGrpName->clear ();
  cliList->clearSelection ();
  grpList->clearSelection ();
  currentItem = -1;
  btnGrpSave->setEnabled (false);
  btnGrpDel->setEnabled (false);
  btnSave->setEnabled (false);
  btnDel->setEnabled (false);
}

void
cfg_cli::slotListSelected (int i)
{
  if (i < 0)
    return;
  compList::iterator ci;
  for (groupList::iterator gi = groups->begin (); gi != groups->end (); ++gi)
    {
      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	{
	  if ((*ci).name == cliList->text (i))
	    {
	      edGroup->setCurrentText ((*gi).name);
	      edName->setText ((*ci).name);
	      edNr->setValue ((*ci).number);
	      edIp->setAddress ((*ci).address);
	      //qDebug((*ci).address);
	      btnDel->setEnabled (CfgWrite);
	      currentItem = i;
	      btnSave->setEnabled (false);
	    }
	}
    }
}

void
cfg_cli::slotBtnNew ()
{
  cliList->clearSelection ();
  clear ();
  currentItem = -1;
  lbName->setFocus ();
}

void
cfg_cli::setData(tarifList *tf,productList *pl,printInfo *pi,QString cur)
{
  tarife = tf;
  products = pl;
  pInfo = pi;
  curency = cur;
}

void
cfg_cli::slotBtnSave ()
{
  QString msg;
  compList::iterator ci;
  bool found = false;
  if (currentItem < 0)
    {
      // neuer rechner
      //qDebug("new commputer");
      compInfo c;
      c.name = edName->text();
      c.address = edIp->address();
      //qDebug(QString("address: %1") .arg(c.address));
      c.number = edNr->value();
      for(groupList::iterator gi = groups->begin(); gi != groups->end(); ++gi)
	if((*gi).name == edGroup->currentText())
	  {
	    c.view = new computerview((*gi).grid,c.name);
	    c.view->setTarif(tarife);
	    c.view->setProducts(products,pInfo);
	    c.view->setCurency(curency);
	    c.view->setClientIp(c.address);
	    (*gi).comp.append(c);
	  }
    }
  else
    {
      //qDebug("old computer");
      for (groupList::iterator gi = groups->begin (); gi != groups->end ();
	   ++gi)
	{
	  //qDebug((*gi).name);
	  for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	    {
	      //qDebug(QString("  %1") .arg((*ci).name)); 
	      if ((*ci).name == cliList->text (currentItem))
		{
		  if ((*ci).view->isActive ())
		    {
		      QMessageBox::warning (this, tr ("Change computer"),
					    tr
					    ("This computer is currently in use. is can not be changed"));
		      return;
		    }
		  if ((*gi).name == edGroup->currentText ())
		    {
		      //qDebug("gleiche gruppe");
		      // gleiche gruppe
		      (*ci).name = edName->text ();
		      (*ci).address = edIp->address ();
		      (*ci).number = edNr->value ();
		    }
		  else
		    {
		      //qDebug("andere gruppe");
		      // andere gruppe
		      for (groupList::iterator it = groups->begin ();
			   it != groups->end (); ++it)
			{
			  if ((*it).name == edGroup->currentText ())
			    {
			      compInfo c;
			      c.name = (*ci).name;
			      c.number = (*ci).number;
			      c.address = (*ci).address;
			      c.view = (*ci).view;
			      c.view->reparent((*it).grid,0,QPoint(0,0));
			      (*gi).comp.remove (ci);
			      (*it).comp.append (c);
			      found = true;
			      break;
			    }
			  if (found == true)
			    break;
			}
		    }
		}
	      if (found == true)
		break;
	    }
	  if (found == true)
	    break;
	}
    }
  initData ();
  clear ();
  emit configChanged();
}


void
cfg_cli::slotBtnDel ()
{
  QString msg;
  compList::iterator ci;
  bool found = false;
  for (groupList::iterator gi = groups->begin (); gi != groups->end (); ++gi)
    {
      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	{
	  if ((*ci).name == cliList->currentText ())
	    {
	      if ((*ci).view->isActive ())
		{
		  msg =
		    tr
		    ("This computer is currently in use. it can not be removed");
		  QMessageBox::information (this, tr ("Warning"), msg);
		  found = true;
		  break;
		}
	      else
		{
		  (*ci).view->~computerview ();
		  (*gi).comp.remove (ci);
		  initData ();
		  clear ();
		  found = true;
		  break;
		}
	    }
	}
      if (found)
	break;
    }
}

void
cfg_cli::slotGrpListSelected (int i)
{
  for (groupList::iterator gi = groups->begin (); gi != groups->end (); ++gi)
    if ((*gi).name == grpList->text (i))
      {
	edGrpName->setText ((*gi).name);
	btnGrpDel->setEnabled (CfgWrite);
	currentGroup = i;
	break;
      }
}

void
cfg_cli::slotGrpBtnNew ()
{
  grpList->clearSelection ();
  edGrpName->clear ();
  currentGroup = -1;
  edGrpName->setFocus ();
  btnGrpSave->setEnabled(true);
}

void
cfg_cli::slotGrpBtnSave ()
{
  if (currentGroup < 0)
    {
      qDebug("new group");
      // neue gruppe
      groupInfo gi;
      gi.name = edGrpName->text ();
      gi.priv = new zbtabwidget (tabView->parentWidget ());
      gi.grid = new QGrid (1, gi.priv);
      tabView->addTab (gi.priv, gi.name);
      (*groups).append (gi);
    }
  else
    {
      qDebug("old group");
      (*groups)[currentGroup].name = edGrpName->text ();
    }
  initData ();
  clear ();
}

void
cfg_cli::slotGrpBtnDel ()
{
  switch (QMessageBox::
	  warning (this, tr ("Delete Group"),
		   tr
		   ("All Computers in this group will be deleted. Continue?"),
		   tr ("&No"), tr ("&Yes")))
    {
    case 1:			// yes
      compList::iterator ci;
      groupList::iterator gi;
      for (gi = groups->begin (); gi != groups->end (); ++gi)
	{
	  if ((*gi).name == grpList->text (currentGroup))
	    {
	      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
		{
		  if ((*ci).view->isActive ())
		    {
		      QMessageBox::warning (this, tr ("Delete Group"),
					    tr
					    ("There is an active computer in this group. This Group can not be removed"));
		      return;
		    }
		}
	      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
		(*ci).view->~computerview ();
	      (*gi).comp.clear ();
	      (*gi).grid->~QGrid ();
	      tabView->removePage ((*gi).priv);
	      (*gi).priv->~zbtabwidget ();
	      break;
	    }
	}
      groups->remove (gi);
      initData ();
      clear ();
    }
}

void
cfg_cli::slotEdGrpName (const QString & s)
{
  if (currentGroup < 0)
    {
      // neue gruppe
    }
  else
    {
      for (groupList::iterator gi = groups->begin (); gi != groups->end ();
	   ++gi)
	{
	  if (grpList->text (currentGroup) != s)
	    btnGrpSave->setEnabled (CfgWrite);
	}
    }
}

void
cfg_cli::slotEdName (const QString & s)
{
  if (currentItem < 0)
    btnSave->setEnabled (true);
  else
    {
      if (s != cliList->text (currentItem))
	btnSave->setEnabled (true);
    }

}

void
cfg_cli::slotEdGroup (const QString & s)
{
  if (currentItem < 0 && !s.isNull ())
    btnSave->setEnabled (true);
  else
    {
      bool found = false;
      compList::iterator ci;
      for (groupList::iterator gi = groups->begin (); gi != groups->end ();
	   ++gi)
	{
	  for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	    {
	      if ((*ci).name == cliList->text (currentItem))
		{
		  if ((*gi).name != s)
		    btnSave->setEnabled (CfgWrite);
		  found = true;
		  break;
		}
	    }
	  if (found)
	    break;
	}
    }
}

void
cfg_cli::slotEdNr (int i)
{
  if (currentItem < 0 && i != 0)
    btnSave->setEnabled (true);
  else
    {
      bool found = false;
      compList::iterator ci;
      for (groupList::iterator gi = groups->begin (); gi != groups->end ();
	   ++gi)
	{
	  for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	    {
	      if ((*ci).name == cliList->text (currentItem))
		{
		  if ((*ci).number != i)
		    btnSave->setEnabled (true);
		  found = true;
		  break;
		}
	    }
	  if (found)
	    break;
	}
    }
}

void
cfg_cli::slotEdIp (const QString s)
{
  if (currentItem < 0 && !s.isNull ())
    btnSave->setEnabled (CfgWrite);
  else
    {
      compList::iterator ci;
      bool found = false;
      for (groupList::iterator gi = groups->begin (); gi != groups->end ();
	   ++gi)
	{
	  for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	    {
	      if ((*ci).name == cliList->text (currentItem))
		{
		  if ((*ci).address != s)
		    btnSave->setEnabled (true);
		  found = true;
		  break;
		}
	    }
	  if (found)
	    break;
	}
    }
}

void
cfg_cli::setEnabled (bool write)
{
  if (write == CfgWrite)
    return;
  CfgWrite = write;
  edGrpName->setEnabled (write);
  btnGrpNew->setEnabled (write);
  edName->setEnabled (write);
  edGroup->setEnabled (write);
  edNr->setEnabled (write);
  edIp->setEnabled (write);
  edNotes->setEnabled (write);
  btnNew->setEnabled (write);
}
