/* cfg_cmp.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "cfg_cmp.hh"

cfg_cmp::cfg_cmp (QWidget * parent, companyInfo * cmp, bool write):QWidget
  (parent)
{
  CfgWrite = write;
  info = cmp;
  initView ();
  setText ();
}

cfg_cmp::~cfg_cmp ()
{
}

void
cfg_cmp::initView ()
{
  cmpGrid = new QGridLayout (this, 12, 2, 3, 3);
  // company name
  cmpLbName = new QLabel (this);
  cmpLbName->setText (tr ("Company"));
  cmpEdName = new QLineEdit (this);
  cmpEdName->setMaximumWidth (300);
  cmpEdName->setEnabled (CfgWrite);
  connect (cmpEdName, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpName (const QString &)));
  cmpGrid->addWidget (cmpLbName, 0, 0);
  cmpGrid->addWidget (cmpEdName, 0, 1);
  // company owner
  cmpLbOwner = new QLabel (this);
  cmpLbOwner->setText (tr ("Owner"));
  cmpEdOwner = new QLineEdit (this);
  cmpEdOwner->setMaximumWidth (300);
  cmpEdOwner->setEnabled (CfgWrite);
  connect (cmpEdOwner, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpOwner (const QString &)));
  cmpGrid->addWidget (cmpLbOwner, 1, 0);
  cmpGrid->addWidget (cmpEdOwner, 1, 1);
  // street
  cmpLbStreet = new QLabel (this);
  cmpLbStreet->setText (tr ("Street"));
  cmpEdStreet = new QLineEdit (this);
  cmpEdStreet->setMaximumWidth (300);
  cmpEdStreet->setEnabled (CfgWrite);
  connect (cmpEdStreet, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpStreet (const QString &)));
  cmpGrid->addWidget (cmpLbStreet, 2, 0);
  cmpGrid->addWidget (cmpEdStreet, 2, 1);
  // zip
  cmpLbZip = new QLabel (this);
  cmpLbZip->setText (tr ("ZIP"));
  cmpEdZip = new QLineEdit (this);
  cmpEdZip->setMaximumWidth (100);
  cmpEdZip->setEnabled (CfgWrite);
  connect (cmpEdZip, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpZip (const QString &)));
  cmpGrid->addWidget (cmpLbZip, 3, 0);
  cmpGrid->addWidget (cmpEdZip, 3, 1);
  // city
  cmpLbCity = new QLabel (this);
  cmpLbCity->setText (tr ("City"));
  cmpEdCity = new QLineEdit (this);
  cmpEdCity->setMaximumWidth (300);
  cmpEdCity->setEnabled (CfgWrite);
  connect (cmpEdCity, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpCity (const QString &)));
  cmpGrid->addWidget (cmpLbCity, 4, 0);
  cmpGrid->addWidget (cmpEdCity, 4, 1);
  // telephone
  cmpLbTel = new QLabel (this);
  cmpLbTel->setText (tr ("Telephone"));
  cmpEdTel = new QLineEdit (this);
  cmpEdTel->setMaximumWidth (300);
  cmpEdTel->setEnabled (CfgWrite);
  connect (cmpEdTel, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpTel (const QString &)));
  cmpGrid->addWidget (cmpLbTel, 5, 0);
  cmpGrid->addWidget (cmpEdTel, 5, 1);
  // facsimile
  cmpLbFax = new QLabel (this);
  cmpLbFax->setText (tr ("Facsimile"));
  cmpEdFax = new QLineEdit (this);
  cmpEdFax->setMaximumWidth (300);
  cmpEdFax->setEnabled (CfgWrite);
  connect (cmpEdFax, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpFax (const QString &)));
  cmpGrid->addWidget (cmpLbFax, 6, 0);
  cmpGrid->addWidget (cmpEdFax, 6, 1);
  // mail
  cmpLbMail = new QLabel (this);
  cmpLbMail->setText (tr ("Mail"));
  cmpEdMail = new QLineEdit (this);
  cmpEdMail->setMaximumWidth (300);
  cmpEdMail->setEnabled (CfgWrite);
  connect (cmpEdMail, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpMail (const QString &)));
  cmpGrid->addWidget (cmpLbMail, 7, 0);
  cmpGrid->addWidget (cmpEdMail, 7, 1);
  // web
  cmpLbWeb = new QLabel (this);
  cmpLbWeb->setText (tr ("WWW"));
  cmpEdWeb = new QLineEdit (this);
  cmpEdWeb->setMaximumWidth (300);
  cmpEdWeb->setEnabled (CfgWrite);
  connect (cmpEdWeb, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCmpWeb (const QString &)));
  cmpGrid->addWidget (cmpLbWeb, 8, 0);
  cmpGrid->addWidget (cmpEdWeb, 8, 1);
  // buttons
  cmpBtnWidget = new QWidget (this);
  cmpBtnGrid = new QHBoxLayout (cmpBtnWidget);
  cmpBtnUndo = new QPushButton (cmpBtnWidget);
  cmpBtnUndo->setText (tr ("Undo"));
  cmpBtnUndo->setEnabled (false);
  connect (cmpBtnUndo, SIGNAL (clicked ()), this, SLOT (slotBtnUndo ()));
  cmpBtnGrid->addWidget (cmpBtnUndo);
  cmpBtnSpace =
    new QSpacerItem (0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
  cmpBtnGrid->addItem (cmpBtnSpace);
  cmpBtnSave = new QPushButton (cmpBtnWidget);
  cmpBtnSave->setText (tr ("Save"));
  cmpBtnSave->setEnabled (false);
  connect (cmpBtnSave, SIGNAL (clicked ()), this, SLOT (slotBtnSave ()));
  cmpBtnGrid->addWidget (cmpBtnSave);
  cmpGrid->addMultiCellWidget (cmpBtnWidget, 9, 9, 0, 1);
  // space
  cmpSpace =
    new QSpacerItem (0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
  cmpGrid->addItem (cmpSpace, 10, 0);
}

void
cfg_cmp::setText ()
{
  cmpEdName->setText (info->name);
  cmpEdOwner->setText (info->owner);
  cmpEdStreet->setText (info->street);
  cmpEdZip->setText (info->zip);
  cmpEdCity->setText (info->city);
  cmpEdTel->setText (info->tel);
  cmpEdFax->setText (info->fax);
  cmpEdMail->setText (info->mail);
  cmpEdWeb->setText (info->web);
  cmpBtnUndo->setEnabled (false);
  cmpBtnSave->setEnabled (false);
}

void
cfg_cmp::setEnabled (bool write)
{
  if (CfgWrite != write)
    {
      CfgWrite = write;
      cmpEdName->setEnabled (CfgWrite);
      cmpEdOwner->setEnabled (CfgWrite);
      cmpEdStreet->setEnabled (CfgWrite);
      cmpEdZip->setEnabled (CfgWrite);
      cmpEdCity->setEnabled (CfgWrite);
      cmpEdTel->setEnabled (CfgWrite);
      cmpEdFax->setEnabled (CfgWrite);
      cmpEdMail->setEnabled (CfgWrite);
      cmpEdWeb->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotBtnUndo ()
{
  setText ();
  cmpBtnUndo->setEnabled (false);
  cmpBtnSave->setEnabled (false);
}

void
cfg_cmp::slotBtnSave ()
{
  cmpBtnUndo->setEnabled (false);
  cmpBtnSave->setEnabled (false);
  info->name = cmpEdName->text ();
  info->owner = cmpEdOwner->text ();
  info->street = cmpEdStreet->text ();
  info->zip = cmpEdZip->text ();
  info->city = cmpEdCity->text ();
  info->tel = cmpEdTel->text ();
  info->fax = cmpEdFax->text ();
  info->mail = cmpEdMail->text ();
  info->web = cmpEdWeb->text ();
  setText ();
  emit configChanged ();
}

void
cfg_cmp::slotCmpName (const QString & s)
{
  if (info->name != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpOwner (const QString & s)
{
  if (info->owner != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpStreet (const QString & s)
{
  if (info->street != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpZip (const QString & s)
{
  if (info->zip != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpCity (const QString & s)
{
  if (info->city != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpTel (const QString & s)
{
  if (info->tel != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpFax (const QString & s)
{
  if (info->fax != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpMail (const QString & s)
{
  if (info->mail != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_cmp::slotCmpWeb (const QString & s)
{
  if (info->web != s)
    {
      cmpBtnUndo->setEnabled (CfgWrite);
      cmpBtnSave->setEnabled (CfgWrite);
    }
}
