/* computerview.hh
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef COMPUTERVIEW_H
#define COMPUTERVIEW_H

#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qpopupmenu.h>
#include <qaction.h>
#include <qaccel.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qvaluelist.h>
#include <qdragobject.h>
#include "zbbutton.hh"
#include "zbuser.hh"
#include "newuser.hh"
#include "printout.hh"
#include "zblabel.hh"
#include "history.hh"
#include "server.hh"

class computerview:public QWidget
{
Q_OBJECT public:
    computerview (QWidget * parent, QString title);
   ~computerview ();
public:
  void setTarif (tarifList * tarife);
  void setCurrentTarif (QString s);
  void setProducts (productList * products, printInfo * prints);
  //      void setGroups(groupList *gList);
  void updateView (QString title);
  void setCurency (QString s);
  QString tarif ();
  QString title ();
  void setOn (bool running);
  void setOff ();
  bool isOn ();
  bool isActive ();
  void setClientIp (QString s);
  void setName(QString name){gbox->setTitle("test");}
private:
  void initView ();
  void initMenu ();
  void dragEnterEvent (QDragEnterEvent * event);
  void dragLeaveEvent (QDragLeaveEvent * event);
  void dropEvent (QDropEvent * event);
public:
    zbuser * zbUser;
private:
    server * srv;
  QString clientIp;
  QString viewTitle;
  bool active;
  QPixmap icoStart;
  QPixmap icoStop;
  QPixmap icoPause;
  QPixmap icoMenu;
  QPixmap icoOk;
  QPixmap griff;
  ZLabel *lbGriff;
  tarifList *tfList;
  productList *pList;
  printInfo *pInfo;
  //      groupList *groups;
  // standard view
  QGroupBox *gbox;
  QWidget *priv;
  QVBoxLayout *vbox;
  // line 1
  QHBoxLayout *line1box;
  zbbutton *btnStart;
  zbbutton *btnStop;
  zbbutton *btnMenu;
  // line 2
  QComboBox *cmbTarif;
  // line 3
  QLabel *lbTime;
  // line 4
  QHBoxLayout *line3box;
  QLabel *lbPrice;
  QLabel *lbCurency;
  // line 5
  QHBoxLayout *line4box;
  QComboBox *cmbItem;
  zbbutton *btnItem;
  // free view
  QWidget *free;
  QLabel *lbInfo;
  QHBoxLayout *newUserBox;
  zbbutton *newUser;
  zbbutton *lock_unlock;
  QVBoxLayout *freeBox;
  // menubar
  QPopupMenu *mainMenu;
  QAction *viewHistory;
  QAction *printCalc;

  private slots:void slotBtnStart ();
  void slotBtnPause ();
  void slotBtnStop ();
  void slotBtnMenu ();
  void slotBtnItem ();
  void slotNewUser ();
  void slotViewHistory ();
  void slotPrintCalc ();
  void slotTarifChanged (int i);
  void slotTimeChanged (QTime tme);
  void slotPriceChanged (float p);
  void slotNameChanged (QString s);
  void slotItemChanged (int i);
  void startDrag ();
  void slotStarted ();
  void slotStopped ();
  void slotPaused ();
  void slotStatus (QString time, QString price);
  void slotUpdateUser(){ emit updateUser();}
  void slotBtnLock();
signals:
  void userDropped (QString oldView, QString newView, QString type);
  void started ();
  void paused ();
  void stopped ();
  void statusChanged (QString time, QString price);
  void updateUser();
};

#endif
