##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""
Revision information:
$Id: ExampleRegistry.py,v 1.1 2002/04/04 01:31:29 chrism Exp $
"""

################################################################
# "Example registry" code for use by CommentableDocument
################################################################

class ExampleRegistry:
    def __init__(self):
        self.example_types = []

    def registerDefault(self, func):
        self.register(lambda x,y: 1, func, priority=9999)

    def register(self, guard, func, priority=0):
        self.example_types.append((priority, guard, func))
        self.example_types.sort()

    def getColorizers(self):
        return map(lambda x: (x[1], x[2]), self.example_types)

example_registry = ExampleRegistry()

