# DocFinderEverywhere 0.4.1
# (c) 2001-2002, Stefan H. Holek, stefan@epy.co.at
# http://www.zope.org/Members/shh/
# License: ZPL
# Zope: 2.3.3. or higher

# Monkey patch wrapper around Dieter Maurer's DocFinder product
# http://www.dieter.handshake.de/pyprojects/zope/DocFinder.html
# Adds a Doc tab to all Zope objects

# Thanks to Dieter for his input on how to make this work with 
# PythonScripts and ExternalMethods, and for writing DocFinder 
# in the first place.

__doc__ = 'Add a Doc tab to all Zope objects'
__version__ = '0.4.1'

__refresh_module__ = 0

from AccessControl.Permission import registerPermissions
from Permissions import ViewDocPermission, ViewDocDefaultRoles

def initialize(context):
    # Register the helpfile
    if hasattr(context, 'registerHelp'):
        context.registerHelp()
        context.registerHelpTitle('DocFinderEverywhere')

    # Register our permission
    registerPermissions(((ViewDocPermission, (), ViewDocDefaultRoles),))

# Apply the DocFinderEverywhere patch
import Patch

