/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;

public class SequenceSaver {
    public SequenceSaver(Vector seqs, File fsave) {
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(null);
        String home = System.getProperty("user.home");
        JFileChooser fc = new JFileChooser(home);
        System.setSecurityManager(sm);
        if (fsave == null) {
            fsave = new File(home + System.getProperty("file.separator") + ((Sequence)seqs.get(0)).getName() + ".fasta");
        } else if (!fsave.getName().endsWith("fasta")) {
            String name = fsave.getName();
            int index = name.lastIndexOf(".");
            if (index > -1) {
                name = name.substring(0, index);
            }
            fsave = new File(home + System.getProperty("file.separator") + name + ".fasta");
        }
        fc.setSelectedFile(fsave);
        fc.addChoosableFileFilter(new SequenceFilter());
        int returnVal = fc.showSaveDialog(fc);
        if (returnVal == 0) {
            File files = fc.getSelectedFile();
            this.saveFile(files, seqs);
        }
    }

    public SequenceSaver(Vector seqs) {
        this(seqs, null);
    }

    private void saveFile(File fsave, Vector seqs) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(fsave));
            for (int i = 0; i < seqs.size(); ++i) {
                Sequence seq = (Sequence)seqs.get(i);
                int len = seq.getLength();
                pw.println(">" + seq.getName());
                String seqString = seq.getSequence();
                for (int j = 0; j < len; j += 60) {
                    int jstop = j + 60;
                    if (jstop > len) {
                        jstop = len;
                    }
                    pw.println(seqString.substring(j, jstop));
                }
            }
            pw.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException saving " + fsave.getName());
        }
    }
}

