/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class ImageCrop
extends Applet {
    private static final int LANDSCAPE = 0;
    private static final int PORTRAIT = 1;
    private int mCropOrientation = 0;
    private Image mOffscreenImage;
    private Image mImage;
    private boolean mImageLoaded = false;
    private Rectangle mCanvasRect = new Rectangle(10, 10, 610, 460);
    private Rectangle mImageRect = new Rectangle(this.mCanvasRect);
    private Rectangle mCropRect = new Rectangle(this.mCanvasRect);
    private Rectangle mResizeHandleRect = new Rectangle(0, 0, 10, 10);
    private Dimension mRawImageSize = new Dimension(4, 3);
    private int mCropToSize;
    private boolean mCropTooSmall = false;
    private float mImageScale;
    private String mStatus;
    private Dimension mCropRatio = new Dimension(4, 3);
    private Cursor resizeCursor = new Cursor(5);
    private Cursor normalCursor = new Cursor(0);
    private Cursor moveCursor = new Cursor(13);

    public int getCropOrientation() {
        return this.mCropOrientation;
    }

    public void setCropOrientation(int n) {
        this.mCropOrientation = n;
    }

    public void setCropOrientation(String string) {
        if ("landscape".equals(string)) {
            this.setCropOrientation(0);
        } else if ("portrait".equals(string)) {
            this.setCropOrientation(1);
        }
        this.constrainCrop();
        this.updateHandles();
        this.invalidate();
        this.repaint();
    }

    public void destroy() {
        if (this.mImage != null) {
            this.mImage.flush();
        }
        if (this.mOffscreenImage != null) {
            this.mOffscreenImage.flush();
        }
    }

    private int getIntParameter(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public void init() {
        Object object;
        this.setStatus("Initializing applet...");
        this.mRawImageSize.width = this.getIntParameter("IMAGE_WIDTH");
        this.mRawImageSize.height = this.getIntParameter("IMAGE_HEIGHT");
        if (this.mRawImageSize.width == 0 || this.mRawImageSize.height == 0) {
            this.setStatus("Invalid Image Size Parameters");
            return;
        }
        this.setCropOrientation(this.getParameter("CROP_ORIENTATION"));
        this.mCropRect.x = this.getIntParameter("CROP_X");
        this.mCropRect.y = this.getIntParameter("CROP_Y");
        this.mCropRect.width = this.getIntParameter("CROP_WIDTH");
        this.mCropRect.height = this.getIntParameter("CROP_HEIGHT");
        this.mCropRatio.width = this.getIntParameter("CROP_RATIO_WIDTH");
        this.mCropRatio.height = this.getIntParameter("CROP_RATIO_HEIGHT");
        this.mCropToSize = this.getIntParameter("CROP_TO_SIZE");
        String string = this.getParameter("IMAGE");
        if (string == null) {
            this.setStatus("No Image URL parameter provided.");
            return;
        }
        this.setStatus("Loading image...");
        this.setBackground(Color.white);
        this.setLayout(null);
        try {
            object = new URL(this.getCodeBase(), string).openConnection();
            ((URLConnection)object).setRequestProperty("Referer", this.getCodeBase().toString());
            this.mImage = this.createImage((ImageProducer)((URLConnection)object).getContent());
        }
        catch (MalformedURLException malformedURLException) {
            this.setStatus("Invalid URL: " + string);
            return;
        }
        catch (IOException iOException) {
            this.setStatus("Error loading image: " + string);
            return;
        }
        this.prepareImage(this.mImage, this);
        object = new MyMouseListener();
        this.addMouseListener((MouseListener)object);
        this.addMouseMotionListener((MouseMotionListener)object);
    }

    public void invalidate() {
        super.invalidate();
        this.mOffscreenImage = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.mOffscreenImage == null) {
            this.mOffscreenImage = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.mOffscreenImage.getGraphics();
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        if (this.mImageLoaded) {
            graphics2.setColor(Color.black);
            graphics2.fillRect(this.mImageRect.x + 1, this.mImageRect.y + 1, this.mImageRect.width, this.mImageRect.height);
            graphics2.drawImage(this.mImage, this.mImageRect.x, this.mImageRect.y, this.mImageRect.width, this.mImageRect.height, Color.white, this);
            Color color = this.mCropTooSmall ? Color.red : Color.cyan;
            int n = this.mResizeHandleRect.x + this.mImageRect.x;
            int n2 = this.mResizeHandleRect.y + this.mImageRect.y;
            int n3 = this.mResizeHandleRect.width;
            int n4 = this.mResizeHandleRect.height;
            graphics2.setColor(Color.black);
            graphics2.drawRect(n + 1, n2 + 1, n3, n4);
            graphics2.setColor(Color.white);
            graphics2.drawRect(n - 1, n2 - 1, n3, n4);
            graphics2.setColor(color);
            graphics2.fillRect(n, n2, n3, n4);
            n = this.mCropRect.x + this.mImageRect.x;
            n2 = this.mCropRect.y + this.mImageRect.y;
            n3 = this.mCropRect.width;
            n4 = this.mCropRect.height;
            graphics2.setColor(Color.black);
            graphics2.drawRect(n + 1, n2 + 1, n3, n4);
            graphics2.setColor(Color.white);
            graphics2.drawRect(n - 1, n2 - 1, n3, n4);
            graphics2.setColor(color);
            graphics2.drawRect(n, n2, n3, n4);
        } else {
            String string = this.getStatus();
            if (string != null) {
                graphics2.drawString(this.getStatus(), 100, 100);
            }
        }
        super.paint(graphics2);
        graphics.drawImage(this.mOffscreenImage, 0, 0, null);
        graphics2.dispose();
    }

    private void finishInitWithImage() {
        this.mImageLoaded = true;
        Dimension dimension = new Dimension(this.mImage.getWidth(this), this.mImage.getHeight(this));
        if (dimension.width > dimension.height) {
            this.mImageRect.width = dimension.width > this.mCanvasRect.width ? this.mCanvasRect.width : dimension.width;
            float f = (float)this.mImageRect.width / (float)dimension.width;
            this.mImageRect.height = (int)(f * (float)dimension.height);
        } else {
            this.mImageRect.height = dimension.height > this.mCanvasRect.height ? this.mCanvasRect.height : dimension.height;
            float f = (float)this.mImageRect.height / (float)dimension.height;
            this.mImageRect.width = (int)(f * (float)dimension.width);
        }
        this.mImageRect.x = this.mCanvasRect.x + (this.mCanvasRect.width - this.mImageRect.width) / 2;
        this.mImageRect.y = this.mCanvasRect.y + (this.mCanvasRect.height - this.mImageRect.height) / 2;
        this.mImageScale = (float)this.mRawImageSize.width / (float)this.mImageRect.width;
        if (this.mCropRect.width > 0 && this.mCropRect.height > 0) {
            this.mCropRect.x = (int)((float)this.mCropRect.x / this.mImageScale);
            this.mCropRect.y = (int)((float)this.mCropRect.y / this.mImageScale);
            this.mCropRect.width = (int)((float)this.mCropRect.width / this.mImageScale);
            this.mCropRect.height = (int)((float)this.mCropRect.height / this.mImageScale);
        } else {
            this.mCropRect.x = 0;
            this.mCropRect.y = 0;
            this.mCropRect.width = this.mImageRect.width;
            this.mCropRect.height = this.mImageRect.height;
        }
        this.mCropToSize = (int)((float)this.mCropToSize / this.mImageScale);
        this.mCropOrientation = this.mCropRect.width < this.mCropRect.height ? 1 : 0;
        this.constrainCrop();
        this.updateHandles();
    }

    private void constrainCrop() {
        int n;
        float f;
        if (this.mCropToSize > 0) {
            this.mCropTooSmall = this.mCropOrientation == 0 && this.mCropRect.width < this.mCropToSize ? true : this.mCropOrientation == 1 && this.mCropRect.height < this.mCropToSize;
        }
        switch (this.mCropOrientation) {
            case 0: {
                f = (float)this.getCropRatio().height / (float)this.getCropRatio().width;
                break;
            }
            default: {
                f = (float)this.getCropRatio().width / (float)this.getCropRatio().height;
            }
        }
        float f2 = (float)this.mCropRect.height / (float)this.mCropRect.width;
        if (f2 > f) {
            int n2;
            this.mCropRect.height = n2 = (int)Math.ceil((float)this.mCropRect.width * f);
            return;
        }
        this.mCropRect.width = n = (int)Math.ceil((float)this.mCropRect.height / f);
    }

    public int getCropX() {
        return (int)((float)this.mCropRect.x * this.mImageScale);
    }

    public int getCropY() {
        return (int)((float)this.mCropRect.y * this.mImageScale);
    }

    public int getCropWidth() {
        return (int)Math.ceil((float)this.mCropRect.width * this.mImageScale);
    }

    public int getCropHeight() {
        return (int)Math.ceil((float)this.mCropRect.height * this.mImageScale);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x40) > 0) {
            this.setStatus("Error loading image");
        } else if (n == 32) {
            if (!this.mImageLoaded) {
                this.finishInitWithImage();
            }
            this.invalidate();
            this.repaint();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public String getStatus() {
        return this.mStatus;
    }

    public void setStatus(String string) {
        this.mStatus = string;
    }

    public Dimension getCropRatio() {
        return this.mCropRatio;
    }

    public void setCropRatio(int n, int n2) {
        this.mCropRatio.width = n;
        this.mCropRatio.height = n2;
        this.constrainCrop();
        this.updateHandles();
        this.invalidate();
        this.repaint();
    }

    public void updateHandles() {
        this.mResizeHandleRect.x = this.mCropRect.x + this.mCropRect.width - this.mResizeHandleRect.width;
        this.mResizeHandleRect.y = this.mCropRect.y + this.mCropRect.height - this.mResizeHandleRect.height;
    }

    class MyMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean mOnMoveHandle = false;
        private boolean mOnResizeHandle = false;
        private Point mMouseDownPoint;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ((ImageCrop)ImageCrop.this).mCropRect.x = 0;
                ((ImageCrop)ImageCrop.this).mCropRect.y = 0;
                ((ImageCrop)ImageCrop.this).mCropRect.width = ((ImageCrop)ImageCrop.this).mImageRect.width;
                ((ImageCrop)ImageCrop.this).mCropRect.height = ((ImageCrop)ImageCrop.this).mImageRect.height;
                ImageCrop.this.constrainCrop();
                ImageCrop.this.updateHandles();
                ImageCrop.this.invalidate();
                ImageCrop.this.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mMouseDownPoint = mouseEvent.getPoint();
            this.mMouseDownPoint.x -= ((ImageCrop)ImageCrop.this).mImageRect.x;
            this.mMouseDownPoint.y -= ((ImageCrop)ImageCrop.this).mImageRect.y;
            if (ImageCrop.this.mResizeHandleRect.contains(this.mMouseDownPoint)) {
                this.mOnResizeHandle = true;
                return;
            }
            if (ImageCrop.this.mCropRect.contains(this.mMouseDownPoint)) {
                this.mOnMoveHandle = true;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mOnMoveHandle = false;
            this.mOnResizeHandle = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point.x -= ((ImageCrop)ImageCrop.this).mImageRect.x;
            point.y -= ((ImageCrop)ImageCrop.this).mImageRect.y;
            int n = point.x - this.mMouseDownPoint.x;
            int n2 = point.y - this.mMouseDownPoint.y;
            boolean bl = false;
            if (this.mOnMoveHandle) {
                if (((ImageCrop)ImageCrop.this).mCropRect.x + ((ImageCrop)ImageCrop.this).mCropRect.width + n < ((ImageCrop)ImageCrop.this).mImageRect.width && ((ImageCrop)ImageCrop.this).mCropRect.x + n > 0) {
                    ((ImageCrop)ImageCrop.this).mCropRect.x += n;
                    bl = true;
                }
                if (((ImageCrop)ImageCrop.this).mCropRect.y + ((ImageCrop)ImageCrop.this).mCropRect.height + n2 < ((ImageCrop)ImageCrop.this).mImageRect.height && ((ImageCrop)ImageCrop.this).mCropRect.y + n2 > 0) {
                    ((ImageCrop)ImageCrop.this).mCropRect.y += n2;
                    bl = true;
                }
            }
            if (this.mOnResizeHandle) {
                if (((ImageCrop)ImageCrop.this).mCropRect.x + ((ImageCrop)ImageCrop.this).mCropRect.width + n <= ((ImageCrop)ImageCrop.this).mImageRect.width && ((ImageCrop)ImageCrop.this).mCropRect.width + n >= 10) {
                    ((ImageCrop)ImageCrop.this).mCropRect.width += n;
                    bl = true;
                }
                if (((ImageCrop)ImageCrop.this).mCropRect.y + ((ImageCrop)ImageCrop.this).mCropRect.height + n2 <= ((ImageCrop)ImageCrop.this).mImageRect.height && ((ImageCrop)ImageCrop.this).mCropRect.height + n2 >= 10) {
                    ((ImageCrop)ImageCrop.this).mCropRect.height += n2;
                    bl = true;
                }
                ImageCrop.this.constrainCrop();
            }
            this.mMouseDownPoint = point;
            if (bl) {
                ImageCrop.this.updateHandles();
                ImageCrop.this.invalidate();
                ImageCrop.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point.x -= ((ImageCrop)ImageCrop.this).mImageRect.x;
            point.y -= ((ImageCrop)ImageCrop.this).mImageRect.y;
            if (ImageCrop.this.mResizeHandleRect.contains(point)) {
                ImageCrop.this.setCursor(ImageCrop.this.resizeCursor);
                return;
            }
            if (ImageCrop.this.mCropRect.contains(point)) {
                ImageCrop.this.setCursor(ImageCrop.this.moveCursor);
                return;
            }
            ImageCrop.this.setCursor(ImageCrop.this.normalCursor);
        }

        MyMouseListener() {
            ImageCrop.this = ImageCrop.this;
        }
    }
}

