package GCPlugins::GCAmazon;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

###################################
#														   #
#			Plugin soumis par MeV			   #
#														   #
###################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginAmazon;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

	    if ($self->{parsingEnded})
        {
            if ($tagname eq "a")
            {
                if (($attr->{href} =~ /http\:\/\/images\.amazon\.com\/images\/P\/([0-9A-Z]*)\.[0-9]{2}\.LZZZZZZZ\.jpg/) && ($attr->{class} eq "tiny"))
                {
                    $self->{movieIdx} = 0;
                    $self->{movieList}[0]->{"url"} = '/exec/obidos/ASIN/' . $1;
                }
            }
            return;
        }

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ /\/exec\/obidos\/tg\/detail\/-\/[A-Z0-9]*\/qid=/)
                {
                    my $url = $attr->{href}; 
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieIdx}++;
                    $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
            elsif ($tagname eq "div")
            {
                $self->{isActors} = 1 if $attr->{class} eq "actors";
                $self->{isYear} = 1 if $attr->{class} eq "year";
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if ($self->{insideAge})
                {
                    $self->{curInfo}->{age} = 18 if $attr->{alt} eq 'R';
                    $self->{curInfo}->{age} = 13 if $attr->{alt} =~ /PG\-13/;
                    $self->{curInfo}->{age} = 5 if $attr->{alt} eq 'PG';
                    $self->{curInfo}->{age} = 2 if $attr->{alt} eq 'G';
                    $self->{insideAge} = 0;
                }
                elsif ($attr->{src} =~ /^http\:\/\/images\.amazon\.com\/images\/P\/[A-Z0-9_.]*?ZZZZZZZ.?\.jpg/)
                {
                	$self->{curInfo}->{image} = $attr->{src};
                }
            }
            elsif ($tagname eq "b")
            {
            	$self->{insideNameAndDate} = 1 if $attr->{class} eq "sans";
            }
            elsif ($tagname eq "div")
            {
            	$self->{insideSynopsis} = 1 if $attr->{class} eq "synopsis";
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
        return if ($self->{parsingEnded});

        if ($self->{parsingList})
        {
            if (($self->{inside}->{title}) && ($origtext !~ /Amazon.com: DVD Search Results/))
            {
                $self->{parsingEnded} = 1;
            }
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            elsif ($self->{isYear})
            {
                $self->{movieList}[$self->{movieIdx}]->{"year"} = $origtext if $origtext =~ /[0-9]{4}/;
                $self->{isYear} = 0;
            }
            elsif ($self->{isActors})
            {
                $origtext =~ s/\n//g;
                $self->{movieList}[$self->{movieIdx}]->{"actors"} = $origtext;
                $self->{isActors} = 0;
            }
        }
       	else
        {
            $origtext =~ s/\s{2,}//g;
            $origtext =~ s/\[endline\]/\n/g;
            $origtext =~ s/\n//g if !$self->{insideSynopsis};
            $origtext =~ s/\n*$//g if $self->{insideSynopsis};

            if ($self->{insideNameAndDate})
            {
                if ($origtext =~ m/(.*) \(([0-9]{4})\)/)
                {
		            $self->{curInfo}->{title} = $1;
                    $self->{curInfo}->{date} = $2;
                }
                $self->{insideNameAndDate} = 0;
            }
            elsif ($self->{insideActors})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $self->{curInfo}->{actors} = $origtext;
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideDirector})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $self->{curInfo}->{director} = $origtext;
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideTime})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/\n//g;
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext;
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{inside}->{b})
            {
                $self->{insideActors} = 1 if $origtext =~ /Starring:/;
				$self->{insideDirector} = 1 if $origtext =~ /Director:/;
				$self->{insideTime} = 1 if $origtext =~ /Run Time:/;
    			$self->{insideAge} = 1 if $origtext =~ /Rated:/;
			}        
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html =~ s/<b class=h1>([^<]*)<\/b>/$1/g;
        $html =~ s/<b><i>|<\/i><\/b>|<i>|<\/i>|<I>|<\/I>|<p>|<\/p>| ?<span class="(small|serif)">|<\/span>//g;
        $html =~ s/<br>/\[endline\]/g;
        $html =~ s/<a href="?\/exec\/obidos\/tg\/detail\/-\/[A-Z0-9]*\/qid=[0-9]*\/sr=[0-9]*-[0-9]*\/ref=sr_[0-9]*_[0-9]*\/[0-9]*-[0-9]*-[0-9]*\?v=glance&s=dvd"?><img src="?http\:\/\/(images\.amazon\.com\/images\/P\/[A-Z0-9]*\.[0-9]*\.THUMBZZZ.jpg|g-images\.amazon\.com\/images\/[A-Z0-9]*\/[0-9]*\/x-site\/icons\/no-img-sm\.gif)"? width=[0-9]* height=[0-9]* align=center border=0><\/a>//g;
        
        #$html =~ s/<font face=verdana,arial,helvetica size=-1>[^<]*<br>~ ([^<]*)<\/font>/<div class="actors">$1<\/div>/g;
        $html=~ s/<a href="?\/exec\/obidos\/search-handle-url\/index=dvd&field-(?:actor|director)=[^\/]*\/[0-9]*-[0-9]*-[0-9]*"?>([^<]*)<\/a>/$1/g;
        $html =~ s/<a href="?\/exec\/obidos\/ASIN\/[A-Z0-9]*\/[0-9]*-[0-9]*-[0-9]*"?>([^<]*)<\/a>/$1/g;
        #$html =~ s/<img src="http\:\/\/g-images\.amazon\.com\/images\/[^"]*"[^>]*>//g;
        $html =~ s/<a href="?\/exec\/obidos\/tg\/?[a-z0-9]*\/detail\/-\/?[a-z0-9]*\/[A-Z0-9]*\/?[a-z0-9]*\/[0-9]*-[0-9]*-[0-9]*[^>]*"?>([^<]*)<\/a>/$1/g;
        $html=~ s/<a name="[a-z0-9]*">([^<]*)<\/a>/$1\[endline\]/g;
        $html=~ s/\[endline\]~ (.*)/<div class="actors">$1<\/div>/g;
        $html=~ s/<a name="amzn-reviews">Editorial Reviews\[endline\]([^<]*)<\/a>([^<]*)(<a|<hr)/<div class="synopsis">$1\n$2<\/div><a /g;
        $html =~ s/\(([0-9]{4})\)\n<font face=verdana,arial,helvetica size=-1>/<div class="year">$1<\/div><font face=verdana,arial,helvetica size=-1>/g;
        $html =~ s/(Starring)<\/a>:/$1:/g;

        $self->{parsingEnded} = 0;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.amazon.com/exec/obidos/search-handle-url/index=dvd&field-keywords=$word/104-1525153-8491932";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return "http://www.amazon.com" . $url;
    }

    sub getName
    {
        return "Amazon";
    }
    
    sub getImageFile
    {
        return "amazon.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'EN';
    }
    
    sub hasSearchDirector
    {
        return 0;
    }

    sub hasSearchActors
    {
        return 1;
    }

}

1;
