# Copyright (C) 2005 Michael Gebhart
# 
# This file is part of Gnome-Art.
#
# Gnome-Art is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# Gnome-Art is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Gnome-Art; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


require 'gtk2'
require 'libglade2'
require 'net/http'
require 'open-uri'
require 'rexml/document'

module GnomeArt
  class MainWindow

   

    #Signalhandlers begin

  	def on_button_preview_clicked
      #Show the preview of the current selected item
      show_preview
  	end

  	def on_mainWindow_destroy
      #Quit the application
  		quit
  	end

  	def on_menu_file_quit_activate
      #Quit the application
  		quit
  	end

    def on_menu_file_delete_cached_files_activate
      delete_cached_files
    end

  	def on_menu_help_homepage_activate 
      #Goto Gnome-Art homepage
  		goto_website("http://art.gnome.org")
  	end

  	def on_menu_help_about_activate
      #Open About-Dialog (Gtk 2.6)
      about = Gtk::AboutDialog.new
      about.name = "GNOME Art"
      about.copyright = "Copyright © 2005 Michael Gebhart"
      about.license = "GNU GPL - General Public License version 2"
      about.authors = ["Michael Gebhart"]
      about.version = GnomeArt::Version
      about.comments = GnomeArt::Title + "\nA frontend for art.gnome.org"
      about.website = "http://www.miketech.net/gnome-art/"

      about.show
      
  	end

  	def on_button_install_clicked
      #Install the selected item
  		install_art
  	end

  	def on_button_download_only_clicked
      #Download the selected item
  		download_only_art
  	end

    def on_menu_resolution_all_activate

    end

    def on_menu_resolution_1600_activate

    end

    def on_menu_resolution_1280_activate

    end

    def on_menu_resolution_1024_activate

    end

    def on_menu_resolution_800_activate

    end


    def on_menu_art_backgrounds_gnome_activate
      @active_content = Config::Backgrounds_gnome

      reload_content(false)
    end

    def on_menu_art_backgrounds_other_activate
      @active_content = Config::Backgrounds_other

      reload_content(false)
    end

    def on_menu_art_backgrounds_all_activate
      @active_content = Config::Backgrounds_all

      reload_content(false)
    end

    def on_menu_art_desktop_themes_application_activate
      @active_content = Config::Desktop_themes_application

      reload_content(false)
    end

    def on_menu_art_desktop_themes_window_border_activate
      @active_content = Config::Desktop_themes_window_border

      reload_content(false)
    end

    def on_menu_art_desktop_themes_icons_activate
      @active_content = Config::Desktop_themes_icons

      reload_content(false)
    end

    def on_menu_art_other_themes_login_manager_activate
      @active_content = Config::Other_themes_login_manager

      reload_content(false)
    end 

    def on_menu_art_other_themes_splash_screen_activate
      @active_content = Config::Other_themes_splash_screens

      reload_content(false)
    end 

    def on_menu_art_other_themes_gtk_plus_engines_activate
      @active_content = Config::Other_themes_gtk_plus_engines

      reload_content(false)
    end 

    def on_treeview_art_button_release_event
      set_buttons    
    end

    #Signalhandlers end


    
  	def quit() 
      #Quit main-loop
  		Gtk::main_quit
  	end


    #Open a website
  	def goto_website(url) 
  		cmd = "gnome-open"
  		system(cmd + " \"" + url + "\"")
  	end


    def delete_cached_files
      GnomeArt::delete_cached_files

      d = Gtk::MessageDialog.new(@main_window, Gtk::Dialog::MODAL, Gtk::MessageDialog::INFO, Gtk::MessageDialog::BUTTONS_OK, "Cached files deleted!")
      d.run
      d.destroy
    end


    def show_preview
      selection = @treeview_art.selection
        
      if (!iter = selection.selected)
        puts "Nothing selected"

        return
      end

      location = iter[4]

      if (location == nil)
        puts "Error"

        return
      end

      Thread.new {
      
        filename = GetArt.get_filename_by_location(location)

        if (filename == nil)
          return
        end

        temp_file = Config::Temp_dir + "/" + filename

        if (!FileTest.exist?(temp_file))     
          show_download_file_dialog 

          GetArt.download(location, temp_file)

          hide_download_dialog
        end

        
      	cmd = "gnome-open #{temp_file}"
        system(cmd)
      }
    end

    def download_only_art

      selection = @treeview_art.selection
        
      if (!iter = selection.selected)
        puts "Nothing selected"

        return
      end

      location = iter[3]

      Thread.new {

    		file_save_as = Gtk::FileChooserDialog.new("Download Background", 
    																																					@main_window, 
    																																					Gtk::FileChooser::ACTION_SAVE,
             																																	nil,
    	  																                                      [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
                                       																				[Gtk::Stock::SAVE, Gtk::Dialog::RESPONSE_ACCEPT])			
      
        filename = GetArt.get_filename_by_location(location)

        file_save_as.set_current_name(filename)																																			

    		if (file_save_as.run == Gtk::Dialog::RESPONSE_ACCEPT)
          #Save the stuff

          temp_file =  Config::Temp_dir + "/" + filename

          if (FileTest.exist?(temp_file))     
            show_download_file_dialog 

            GetArt.download(temp_file, file_save_as.filename)

            hide_download_dialog

          else 
            show_download_file_dialog 

            GetArt.download(location, file_save_as.filename)

            hide_download_dialog

          end

      	end		

      	file_save_as.destroy
      }
  	end

  	def method(handler, *other_args) 
  	  #puts handler
    	super(handler, *other_args)
  	end


  	def install_art

      selection = @treeview_art.selection
        
      if (!iter = selection.selected)
        puts "Nothing selected"

        return
      end


      location = iter[3]
      art_name = iter[5]

      if (location == nil)
        puts "Error"

        return
      end

    
      filename = GetArt.get_filename_by_location(location)

      if (filename == nil)
        #Error
        return
      end

        
      case @active_content
        when Config::Other_themes_splash_screens
          GnomeSplashScreenManager::init_directories

        else

      end

      download_file = "#{Config::Home_dir}/#{Config::Gnome_dir}/#{Config::Program_dir}/download/#{Config::Category_dirs[@active_content]}/" + filename

      temp_file =  Config::Temp_dir + "/" + filename
      
      thread = Thread.new {

        case @active_content
          when Config::Desktop_themes_icons, Config::Desktop_themes_window_border,
            Config::Desktop_themes_application
              
            if (!FileTest.exist?(temp_file))    
              show_download_file_dialog 

              GetArt.download(location, temp_file)

              hide_download_dialog
            end

          else

            if (!FileTest.exist?(download_file))
              if (FileTest.exist?(temp_file))     
                show_download_file_dialog 

                GetArt.download(temp_file, download_file)
      
                hide_download_dialog
              else 
                show_download_file_dialog 

                GetArt.download(location, download_file)

                hide_download_dialog

              end 
            end

        end

        case @active_content
          when Config::Backgrounds_gnome, Config::Backgrounds_other, Config::Backgrounds_all
            #add entry in backgrounds.xml
            if (GetArt.find_backgrounds_entry(download_file))
              GetArt.update_backgrounds_entry(art_name, download_file)
            else
              GetArt.add_backgrounds_entry(art_name, download_file)
            end
          
            #open gnome-background-properties
    	     	system("gnome-background-properties &")
          when Config::Other_themes_splash_screens
            
            author = iter[2]
            name = iter[5]
            description = iter[6]
            license = iter[7]
            
            if (!GnomeSplashScreenManager::SplashScreens.find_splash_screen_with_filename(GnomeSplashScreenManager::Config::Gnome_splash_screens_file, download_file))
              GnomeSplashScreenManager::SplashScreens.add_splash_screens_entry(GnomeSplashScreenManager::Config::Gnome_splash_screens_file, name, download_file, description, author, license)
            end

            #open gnome-splashscreen-manager
    	     	system("gnome-splashscreen-manager &")

          when Config::Desktop_themes_icons, Config::Desktop_themes_window_border, Config::Desktop_themes_application

            command_param = ""

            if (download_file.downcase[-3..-1] == ".gz")
              command_param = "-xzf"
            elsif (download_file.downcase[-4..-1] == ".bz2")
              command_param = "-xjf"
            end
    
            folder = ""

            case @active_content
              when Config::Desktop_themes_icons
                folder = "~/.icons/"
              when Config::Desktop_themes_window_border, Config::Desktop_themes_application
                folder = "~/.themes/"
            end

            command = "tar #{command_param} #{temp_file} -C " + folder

            system(command)

            system("gnome-theme-manager &")

        end
      }
  	end

=begin
    def refresh_gui

      while(Gtk.events_pending?)
        Gtk.main_iteration
      end 

    end
=end

    def show_download_dialog(text)
      @download_status = -1
      @download_dialog = DownloadDialog.new(@main_window, text)
      @download_dialog_text = text

      @download_dialog.show

      proc = Proc.new { 
        if (@download_status != -1)
          @download_dialog.set_progressbar_status(@download_status)
          @download_dialog.set_text(@download_dialog_text)
        end

        true
      }

      @download_timer = Gtk::timeout_add(100, &proc)
    end

    def hide_download_dialog
      Gtk::timeout_remove(@download_timer)

      @download_dialog.hide
    end

  	def reload_backgrounds

      Thread.new {

        show_download_dialog("Preparing download")

        @liststore_backgrounds[@active_content].clear


        count = GetArt.get_backgrounds(@active_content, true)

        @download_dialog.set_progressbar(count)
        @download_status = 0

        @download_dialog_text = "Downloading background " + (@download_status + 1).to_s + " / " + count.to_s

        GetArt.get_backgrounds(@active_content, false) { |pixbuf, name, description, author, license, download_location, preview_location, resolution, release_date, download_start_timestamp, download_count, vote_sum, vote_count|

    			newStore = @liststore_backgrounds[@active_content].append()

          displayed_description = description

          if (displayed_description.length > 50)
            displayed_description = displayed_description[0..50] + "..."
          end

          if (displayed_description != "")
            displayed_description = displayed_description.gsub("\n", " ")
            displayed_description << "\n"    
          end

    			newStore[0] = pixbuf
    			newStore[1] = "<b>" + name + "</b>\n" + displayed_description + "<i>Resolution: " + resolution + "\nAuthor: " + author + "</i>"
          newStore[2] = author
          newStore[3] = download_location
          newStore[4] = preview_location
          newStore[5] = name
          newStore[6] = description
          newStore[7] = license
          newStore[8] = resolution
          newStore[9] = release_date
          newStore[10] = download_start_timestamp
          newStore[11] = download_count
          newStore[12] = vote_sum
          newStore[13] = vote_count

          @download_status += 1
          @download_dialog_text = "Downloading background " + (@download_status + 1).to_s + " / " + count.to_s
    		}

        reload_view

        hide_download_dialog
      }
  	end

    def show_download_file_dialog
      show_download_dialog("Downloading file")
    end

    def reload_themes


      Thread.new {

        show_download_dialog("Preparing download")

        @liststore_themes[@active_content].clear

        count = GetArt.get_themes(@active_content, true) 

        @download_dialog.set_progressbar(count)
        @download_status = 0

          @download_dialog_text = "Downloading theme " + (@download_status + 1).to_s + " / " + count.to_s

        GetArt.get_themes(@active_content, false) { |pixbuf, name, description, author, license, download_location, preview_location, release_date, download_start_timestamp, download_count, vote_sum, vote_count|


    			newStore = @liststore_themes[@active_content].append()

          displayed_description = description

          if (displayed_description.length > 50)
            displayed_description = displayed_description[0..50] + "..."
          end

          if (displayed_description != "")
            displayed_description = displayed_description.gsub("\n", " ")
            displayed_description << "\n"    
          end

    			newStore[0] = pixbuf
    			newStore[1] = "<b>" + name + "</b>\n" + displayed_description + "<i>Author: " + author + "</i>"
          newStore[2] = author
          newStore[3] = download_location
          newStore[4] = preview_location
          newStore[5] = name
          newStore[6] = description
          newStore[7] = license
          newStore[8] = release_date
          newStore[9] = download_start_timestamp
          newStore[10] = download_count
          newStore[11] = vote_sum
          newStore[12] = vote_count


          @download_status += 1
          @download_dialog_text = "Downloading theme " + (@download_status + 1).to_s + " / " + count.to_s
    		}

        reload_view

        hide_download_dialog
      }
    end

    def init_themes
  		@liststore_themes[@active_content] = Gtk::ListStore.new(Gdk::Pixbuf, String, String, String, String, String, String, String, String, Integer, Integer, Integer, Integer)
    end

  	def init_backgrounds
  		@liststore_backgrounds[@active_content] = Gtk::ListStore.new(Gdk::Pixbuf, String, String, String, String, String, String, String, String, String, Integer, Integer, Integer, Integer)
  	end

    def init_treeview
  		@treeview_art.headers_visible=false
  	

  		@renderer_art_image = Gtk::CellRendererPixbuf.new
  		#@renderer_art_image.background="blue"

  		@renderer_art_description = Gtk::CellRendererText.new

  		col = Gtk::TreeViewColumn.new("Image", @renderer_art_image, :pixbuf => 0)
  		@treeview_art.append_column(col)

  		col = Gtk::TreeViewColumn.new("Description", @renderer_art_description, :markup => 1)
  		@treeview_art.append_column(col)

  		col.set_cell_data_func(@renderer_art_description) do |col, renderer, model, iter|
        #renderer.font = "Times New Roman"
  		end

      @treeview_art.signal_connect("row-activated") do |view, path, column|
        puts "Row #{path.to_str} was clicked!"

        if iter = @treeview_art.model.get_iter(path)
          puts "Double-clicked row contains name #{iter[0]}!"
        end
      end

    end

  	def init_glade
    	@glade = GladeXML.new("/usr/share/gnome-art/glade/gnome_art.glade", "main_window", nil, GladeXML::FILE) { |handler| method(handler) }

  		@main_window = @glade.get_widget("main_window")
      @label_list = @glade.get_widget("label_list")
  		@treeview_art = @glade.get_widget("treeview_art")
  		@button_install = @glade.get_widget("button_install")
  		@button_download_only = @glade.get_widget("button_download_only")
  		@button_preview = @glade.get_widget("button_preview")
      @menu_resolution = @glade.get_widget("menu_resolution")
  	end

    def set_buttons

      case @active_content
        when Config::Backgrounds_gnome, Config::Backgrounds_other, Config::Backgrounds_all            
          @menu_resolution.hide
          @button_install.sensitive=true
          @button_download_only.sensitive=true
          @button_preview.sensitive=true
        when Config::Other_themes_splash_screens, Config::Desktop_themes_icons,
          Config::Desktop_themes_window_border, Config::Desktop_themes_application
          @menu_resolution.hide
          @button_install.sensitive=true
          @button_download_only.sensitive=true
          @button_preview.sensitive=true
        when Config::Nothing
          @menu_resolution.hide
          @button_install.sensitive=false
          @button_download_only.sensitive=false
          @button_preview.sensitive=false
        else 
          @menu_resolution.hide
          @button_install.sensitive=false
          @button_download_only.sensitive=true 
          @button_preview.sensitive=false
      end

      selection = @treeview_art.selection
        
      if (!iter = selection.selected)
        #puts "Nothing selected"

        @button_install.sensitive=false
        @button_download_only.sensitive=false
        @button_preview.sensitive=false

        return
      end


      preview = iter[4];
      download = iter[3];

      if (preview == "")
        @button_preview.sensitive=false
      else
        @button_preview.sensitive=true
      end

      #Bz2-backgrounds deactivate preview and installation
      case @active_content
        when Config::Backgrounds_gnome, Config::Backgrounds_other, Config::Backgrounds_all 
          if (preview.downcase[-4..-1] == ".bz2" || preview.downcase[-3..-1] == ".gz")
            @button_preview.sensitive=false
          end

          if (download.downcase[-4..-1] == ".bz2" || download.downcase[-3..-1] == ".gz")
            @button_install.sensitive=false
          end
      end
      
      
    end

    def reload_view
      case @active_content
        when Config::Backgrounds_gnome, Config::Backgrounds_other, Config::Backgrounds_all 

          #Filtering
          filter_model = Gtk::TreeModelFilter.new(@liststore_backgrounds[@active_content])

          filter_model.set_visible_func do |model, iter|
            if (@resolution_filter.empty?)
              true
            end            
    
          end

          @treeview_art.model = Gtk::TreeModelSort.new(filter_model)

          @treeview_art.columns_autosize      

        when Config::Nothing
          #nothing to do
          @treeview_art.model = nil
        else 
          @treeview_art.model = @liststore_themes[@active_content]

          @treeview_art.columns_autosize
      end

      set_buttons
    end

    def reload_content(complete_reload)



      #set Label
      label = ""
      case @active_content
        when Config::Backgrounds_gnome then label = "GNOME Backgrounds"
        when Config::Backgrounds_other then label = "Other Backgrounds"
        when Config::Backgrounds_all then label = "All Backgrounds"
        when Config::Desktop_themes_application then label = "Application Themes"
        when Config::Desktop_themes_window_border then label = "Window Border Themes"
        when Config::Desktop_themes_icons then label = "Icon Themes"
        when Config::Other_themes_login_manager then label = "Login Manager Themes"
        when Config::Other_themes_splash_screens then label = "Splash Screen Themes"
        when Config::Other_themes_gtk_plus_engines then label = "GTK+ Engine Themes"
        when Config::Nothing then label = "No category selected"
        else label = "Other"
      end

      label = "<b>" + label + "</b>"

      @label_list.set_markup(label)

      @treeview_art.model = nil

      case @active_content
        when Config::Backgrounds_gnome, Config::Backgrounds_other, Config::Backgrounds_all 
          if (@liststore_backgrounds[@active_content] == nil)
            #Reload data
            init_backgrounds

            reload_backgrounds
          else
            reload_view
          end
        when Config::Nothing
          #nothing to do
        else 
          if (@liststore_themes[@active_content] == nil)
            #Reload data
            init_themes
    

            reload_themes
          else
            reload_view
          end
      end

    end

  	def initialize(application)

      Thread.abort_on_exception = true


      @application = application

      @active_content = Config::Nothing

  		init_glade
      @main_window.hide

      init_treeview
    
      @liststore_backgrounds = []
      @liststore_themes = []

      @resolution_filter = []
  
      reload_content(true)

      @main_window.resize(500,400)
  
      @main_window.show_all
      @menu_resolution.hide #show when function is implemented

      set_buttons

  	end

  end
end
