# Copyright (C) 2005 Michael Gebhart
# 
# This file is part of Gnome-SplashScreen-Manager.
#
# Gnome-SplashScreen-Manager is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# Gnome-SplashScreen-Manager is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Gnome-SplashScreen-Manager; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


require 'gtk2'
require 'libglade2'
require 'gconf2'
require 'net/http'
require 'open-uri'
require 'rexml/document'

module GnomeSplashScreenManager
  class MainWindow

   

    #Signalhandlers begin
    def on_menu_file_quit_activate
      #Quit the application
      quit
    end

  	def on_main_window_destroy
      #Quit the application
  		quit
  	end

  	def on_menu_help_about_activate() 
      #Open About-Dialog (Gtk 2.6)
      about = Gtk::AboutDialog.new
      about.name = "GNOME Splash Screen Manager"
      about.copyright = "Copyright © 2005 Michael Gebhart"
      about.license = "GNU GPL - General Public License version 2"
      about.authors = ["Michael Gebhart"]
      about.version = GnomeSplashScreenManager::Version
      about.comments = ""
      about.website = "http://www.miketech.net/gnome-art/"

      about.show
      
  	end

  	def on_button_install_new_splash_screen_clicked
      #Install the selected item
  		install_new_splash_screen_dialog
  	end

    def on_button_delete_splash_screen_clicked
      delete_splash_screen
    end

    def on_button_activate_clicked
      set_current_splash_screen
    end

  	def on_button_preview_clicked
      #Show the preview of the current selected item
      show_preview
  	end


    def on_treeview_splash_screens_button_release_event
      set_buttons    
    end

    def on_checkbutton_splash_screen_active_clicked
      splash_screen_active_changed
    end

    #Signalhandlers end


    
  	def quit() 
      #Quit main-loop
  		Gtk::main_quit
  	end


    #Open a website
  	def goto_website(url) 
  		cmd = "gnome-open"
  		system(cmd + " \"" + url + "\"")
  	end


    def gnome_open_file(filename)
  		cmd = "gnome-open"
  		system(cmd + " \"" + filename + "\"")
    end


    def splash_screen_active_changed
      if (@checkbutton_splash_screen_active.active?)
        activate_splash_screen
        set_buttons
      else
        deactivate_splash_screen
        set_buttons
      end
    end


    def delete_splash_screen
      selection = @treeview_splash_screens.selection
        
      if (!iter = selection.selected)

        return
      end

      filename = iter[3]

      SplashScreens.delete_splash_screens_entry(Config::Gnome_splash_screens_file, filename) 

      to_delete = []

      @liststore_splash_screens.each { |model, path, iter|
        if (iter[3] == filename)
          puts "Eintrag gelöscht"
          to_delete.push(Gtk::TreeRowReference.new(model,path))
        end              
      }

      to_delete.each { |entry|
        entry = entry.path
        @liststore_splash_screens.remove @liststore_splash_screens.get_iter(entry)
      }

      set_buttons
    
      
    end

    def install_new_splash_screen_dialog

  		file_open = Gtk::FileChooserDialog.new("Install new splash screen", 
  																																					@main_window, 
  																																					Gtk::FileChooser::ACTION_OPEN,
           																																	nil,
  	  																                                      [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
                                     																				[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_ACCEPT])			
    
																									

  		if (file_open.run == Gtk::Dialog::RESPONSE_ACCEPT)
        #Open Splash Screen
        splash_screen_filename = file_open.filename

        filename = File.basename(splash_screen_filename)

        activated = 0
        
        if (@active_splash_screen == splash_screen_filename)
          activated = 1
        end
        
        install_new_splash_screen(filename, splash_screen_filename, "", "", "", 0, activated)

    	end		

    	file_open.destroy

  	end

  	def method(handler, *other_args) 
  	  #puts handler
    	super(handler, *other_args)
  	end


  	def install_new_splash_screen(name, filename, description, author, license, first = 0, activated = 0)

      if (name != "" && filename != "" && !find_splash_screen_with_filename(filename))
        pixbuf = SplashScreens.create_thumbnail(filename)
  
        add_new_splash_screen_to_list(pixbuf, name, filename, description, author, license, first, activated)

        SplashScreens.add_splash_screens_entry(Config::Gnome_splash_screens_file, name, filename, description, author, license)
      end
  	end

    def set_entry_values(entry)

      description = entry[4]

      displayed_description = description

      if (displayed_description.length > 50)
        displayed_description = displayed_description[0..50] + "..."
      end

      if (displayed_description != "")
        displayed_description = displayed_description.gsub("\n", " ")
        displayed_description << "\n"    
      end

      if (entry[7] == 1)
        entry[1] = "<b>" + entry[2] + "</b>  (Activated)\n" + displayed_description + "<i>Author: " + entry[5] + "</i>"
      else
        entry[1] = "<b>" + entry[2] + "</b>\n" + displayed_description + "<i>Author: " + entry[5] + "</i>"  
      end
    end

    def add_new_splash_screen_to_list(pixbuf, name, filename, description, author, license, first = 0, activated = 0)

      if (first == 1)
        newStore = @liststore_splash_screens.prepend()
      else
        newStore = @liststore_splash_screens.append()
      end

      newStore[0] = pixbuf
      newStore[1] = ""
      newStore[2] = name
      newStore[3] = filename
      newStore[4] = description
      newStore[5] = author
      newStore[6] = license
      newStore[7] = activated

      set_entry_values(newStore)
  
    end


    def show_preview
      selection = @treeview_splash_screens.selection
        
      if (!iter = selection.selected)

        return
      end

      filename = iter[3]

      gnome_open_file(filename)
    end


  	def reload_splash_screens

      @liststore_splash_screens.clear

      to_delete = []
      SplashScreens.get_splash_screens(Config::Gnome_splash_screens_file) { |pixbuf, name, filename, description, author, license|

        if (pixbuf!=nil && name != "" && filename != "")

          if (@active_splash_screen == filename)
            activated = 1
          else
            activated = 0
          end

          add_new_splash_screen_to_list(pixbuf, name, filename, description, author, license, 0, activated)
        else
          to_delete.push(filename)
        end


  		}

      to_delete.each { |entry|
        puts "DELETE " + entry
        SplashScreens.delete_splash_screens_entry(Config::Gnome_splash_screens_file, entry)
      }


      @treeview_splash_screens.model = @liststore_splash_screens

      set_buttons

  	end


    def set_current_splash_screen

      @liststore_splash_screens.each { |model, path, iter|
        iter[7] = 0
        set_entry_values(iter)
      }  

      selection = @treeview_splash_screens.selection
        
      if (!iter = selection.selected)

        return
      end

      filename = iter[3]      
      iter[7] = 1
      
      @active_splash_screen = filename

      set_entry_values(iter)

      @checkbutton_splash_screen_active.active=true
      SplashScreens.set_current_splash_screen(filename)
      SplashScreens.set_current_splash_screen_active(true)
    end

    def activate_splash_screen
      SplashScreens.set_current_splash_screen_active(true)
    end


    def deactivate_splash_screen
      SplashScreens.set_current_splash_screen_active(false)
    end


  	def init_splash_screens
  		@liststore_splash_screens = Gtk::ListStore.new(Gdk::Pixbuf, String, String, String, String, String, String, Integer)
  	end

    def init_treeview
  		@treeview_splash_screens.headers_visible=false

  		@renderer_splash_screens_image = Gtk::CellRendererPixbuf.new

  		@renderer_splash_screens_description = Gtk::CellRendererText.new

  		col = Gtk::TreeViewColumn.new("Image", @renderer_splash_screens_image, :pixbuf => 0)
  		@treeview_splash_screens.append_column(col)

  		col = Gtk::TreeViewColumn.new("Description", @renderer_splash_screens_description, :markup => 1)
  		@treeview_splash_screens.append_column(col)

  		col.set_cell_data_func(@renderer_splash_screens_description) do |col, renderer, model, iter|
        #renderer.font = "Times New Roman"
  		end

      @treeview_splash_screens.signal_connect("row-activated") do |view, path, column|
        if iter = @treeview_splash_screens.model.get_iter(path) 
          set_current_splash_screen
        end
      end

    end

  	def init_glade
    	@glade = GladeXML.new("/usr/share/gnome-splashscreen-manager/glade/gnome_splashscreen_manager.glade", "main_window", nil, GladeXML::FILE) { |handler| method(handler) }

  		@main_window = @glade.get_widget("main_window")
  		@treeview_splash_screens = @glade.get_widget("treeview_splash_screens")

  		@button_install_new_splash_screen = @glade.get_widget("button_install_new_splash_screen")
  		@button_delete_splash_screen = @glade.get_widget("button_delete_splash_screen")
      @button_preview = @glade.get_widget("button_preview")
      @button_activate = @glade.get_widget("button_activate")
      @checkbutton_splash_screen_active = @glade.get_widget("checkbutton_splash_screen_active")
      
      
  	end

    def set_buttons

      if (!@checkbutton_splash_screen_active.active?)
        @treeview_splash_screens.sensitive=false

        @button_activate.sensitive = false
        @button_preview.sensitive = false
        @button_delete_splash_screen.sensitive = false
        @button_install_new_splash_screen.sensitive = false

        return
      end

      #Always sensitive, when checkbutton_splash_screen is active
      @button_install_new_splash_screen.sensitive = true
      @treeview_splash_screens.sensitive=true

      selection = @treeview_splash_screens.selection
        
      if (!iter = selection.selected)

        @button_activate.sensitive = false
        @button_preview.sensitive = false
        @button_delete_splash_screen.sensitive = false
      else
        @button_activate.sensitive = true
        @button_preview.sensitive = true
        @button_delete_splash_screen.sensitive = true
      end
      
    end


    def check_splash_screen_active
      @checkbutton_splash_screen_active.active = SplashScreens.get_current_splash_screen_active

      splash_screen_active_changed
    end


    def find_splash_screen_with_filename(filename)
      @liststore_splash_screens.each { |model, path, iter|
        if (iter[3] == filename)
          return true
        end              
      }  

      return false
    end


    #Add old splash screen
    def add_old_splash_screen
      if (@old_splash_screen == "")
        return
      end

      if (!find_splash_screen_with_filename(@old_splash_screen) && File.exists?(@old_splash_screen))
      	install_new_splash_screen(File.basename(@old_splash_screen), @old_splash_screen, "Unknown", "Unknown", "Unknown", 1, 1)
      end
    end

  	def initialize(application)
      @application = application

  		init_glade

      @main_window.show_all

      init_treeview
  		init_splash_screens

      @old_splash_screen = SplashScreens.get_current_splash_screen
      @active_splash_screen = @old_splash_screen

      reload_splash_screens
      check_splash_screen_active
      add_old_splash_screen

  	end

  end
end
