/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001 - 2006 Magnus Loef (Magnus-swe) <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "commands.h"
#include "activate_button_clicked.h"

extern int activated;



void activate_button_clicked(struct w *widgets)
{
    gchar *start, *test;

    /* Remove the shutdown file if it exists */
    unlink(GP_SHUTMSG);

    if( activated )
      return;

    /* Start the server */
    start = g_strdup_printf("%s -c %s", PROFTPD_BINARY, PROFTPD_CONF);
    if( ! run_command(start) )
    {
        printf("Starting proftpd failed using this command: %s\n", start);
        test = g_strdup_printf("%s -c %s 2>&1", PROFTPD_BINARY, PROFTPD_CONF);
	run_command_show_err(test);
	g_free(test);
    }
    g_free(start);
}
