/*
 * help_widget.cpp - implementation of help-widget for side-bar
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qlabel.h>
#include <qmessagebox.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qvbox.h>

#include "help_widget.h"
#include "italc.h"
#include "client_manager.h"
#include "embed.h"
#include "user_list.h"
#include "italc_rfb_ext.h"

#include "help_widget.moc"


helpWidget::helpWidget( QWidget * _parent ) :
	sideBarWidget( tr( "Help for iTALC" ), embed::getIconPixmap( "help" ), _parent )
{

	contentParent()->setSpacing( 15 );

	m_whatsThisTxt = new QLabel( tr( "If you want to know, what a specific button etc. does, you can activate the \"What's this\"-mode. Then click on the corresponding button etc. and a short explanation to it will be shown." ), contentParent() );
	m_whatsThisTxt->setAlignment( m_whatsThisTxt->alignment() | WordBreak );

	m_whatsThisBtn = new QPushButton( embed::getIconPixmap( "whatsthis" ), tr( "Enter \"What's this\"-mode" ), contentParent() );
	connect( m_whatsThisBtn, SIGNAL( clicked() ), italc::inst(), SLOT( enterWhatsThisMode() ) );

	new QLabel( "\n", contentParent() );


	m_supportTxt = new QLabel (tr("Do you want to get support by another person working in your network? No problem! Just click on the button below and select the user you want to get support from. Then your desktop will be released to this user and the selected user will get an invitation."), contentParent());
	m_supportTxt->setAlignment (m_supportTxt->alignment()|WordBreak);

	m_supportBtn = new QPushButton( embed::getIconPixmap( "support" ), tr( "Get support" ), contentParent() );
	connect( m_supportBtn, SIGNAL( clicked() ), this, SLOT( supportBtnClicked() ) );


	QLabel * filler = new QLabel( contentParent() );
	filler->setFixedHeight( 2048 );
}




helpWidget::~helpWidget()
{
}




void helpWidget::supportBtnClicked( void )
{
	QMessageBox::information( this, tr( "Function not implemented yet." ), tr( "This function is not completely implemented yet. This is why it is disabled at the moment." ), QMessageBox::Ok );
	return;
#if 0
	if( clientManager::inst()->demoRunning() )
	{
		QMessageBox::information( this, tr( "Demo running" ), tr( "You can't get support from another person while a demo is running! Please stop the demo on all clients and try again!" ), QMessageBox::Ok );
		return;
	}


	QDialog user_dialog;

	QListBox user_list( &user_dialog );
	user_list.setGeometry( 10, 10, 300, 400 );
	user_list.insertStringList( userList::getLoggedInUsers() );
	connect( &user_list, SIGNAL( highlighted( const QString & ) ), this, SLOT( userSelected( const QString & ) ) );
	user_list.sort();
	user_list.setCurrentItem( 0 );

	QPushButton ok_btn( embed::getIconPixmap( "apply" ), tr( "OK" ), &user_dialog );
	ok_btn.setGeometry( 10, 420, 145, 32 );
	QPushButton cancel_btn( embed::getIconPixmap( "cancel" ), tr( "Cancel" ), &user_dialog );
	cancel_btn.setGeometry( 165, 420, 145, 32 );
	connect( &ok_btn, SIGNAL( clicked() ), &user_dialog, SLOT( accept() ) );
	connect( &cancel_btn, SIGNAL( clicked() ), &user_dialog, SLOT( reject() ) );

	if( user_dialog.exec() == QDialog::Rejected )
	{
		return;
	}

	client * c = userList::getClientFromUser( m_supportUser );

	if( c != NULL )
	{
		if( c->inviteForSupportingLocalUser() == TRUE )
		{
			system( "killall ivs" );
			system( "ivs -rfbport "SUPPORT_PORT/*" -allow "+c->getIP()+*/" &" );
			system( "ivs -viewonly -X -rfbport "DEMO_PORT" &" );	// new demo-ivs on port 5919
			c->processCmd( client::EXEC_CMDS_IRFB, "vncviewer "+MASTER_HOST+"::"SUPPORT_PORT );
		}
	}
#endif
}




void helpWidget::userSelected( const QString & _user )
{
	m_supportUser = _user;
}
