/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DGUIVIEW_H
#define _DGUIVIEW_H

#include "../datastruct/DItem.h"
#include "../datastruct/DBase.h"

class DDataControl;
class DDataItem;

/**
 * @short Base class for mindmap views
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class DGuiView : public DBase
{
	public:
		DGuiView(QWidget* parent=0, const char* name=0);
		virtual ~DGuiView();

		/**
		 * Set the mindmap data
		 */
		void setDataTree(DDataControl* ctrl);

		/** 
		 * Return the mindmap data (very convenient, use it :)
		 */
		DDataControl* dataTree() const;

		/**
		 * Returns a view item form the id
		 */
		DDataItem* dataItem(int id);

		/**
		 * Set the view to read-write mode (for the part)
		 */
		inline void setReadWrite(bool val=true) { m_readWrite = val; }

	private:
		/**
		 * Mindmap data that the view observes
		 */
		DDataControl* m_data;

	protected:
		/**
		 * Connect the view to the data
		 */
		virtual void plug()=0;

		/**
		 * Disconnect the view from the data
		 */
		virtual void unplug()=0;

		/**
		 * Is the view is read-only (for the part)
		 */
		bool m_readWrite;
};

#endif // _DGUIVIEW_H
