#
# spec file for package OpenOffice_org-icon-themes (Version 3.0.0.2)
#
# Copyright (c) 2008 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild


Name:           OpenOffice_org-l10n
Version:        3.0.0.2
Release:        5
%define         piece      l10n
%define	      ooo_build_version 3.0.0.2b
# test_build_langs:   	   1 = de and cs
#			   2 = all supported languages 
%define		test_build_langs 	1
# build_module_in_parallel 0 = no
#			   1 = yes (the number is defined be the number of cpus)
#			   2,3,4... = yes (force the number of modules to be built in parallel)
%define		build_module_in_parallel	1
# prepare_build:	   0 = no
#			   1 = yes (just build, install and create packages; without %%prep section and configure)
%define		prepare_build 		1
#
%if %test_build_langs == 0
%define       ooo_langs		"en-US"
%else
%if %test_build_langs == 1
%define       ooo_langs		"en-US cs de"
%else
%define       ooo_langs		"en-US cs de es fr it"
%endif
%endif
BuildRequires:  OpenOffice_org-bootstrap = %version
BuildRequires:  OpenOffice_org-base-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-calc-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-components-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-filters-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-impress-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-libs-core-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-libs-extern-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-libs-gui-l10n-prebuilt = %version
BuildRequires:  OpenOffice_org-l10n-extras-prebuilt = %version
BuildRequires:  OpenOffice_org-writer-l10n-prebuilt = %version
BuildRequires:  unzip
%define	      ooo_basis_dir	basis3.0
%define	      ooo_home		ooo3
License:        LGPL v2.1 only; LGPL v3 only
Group:          Productivity/Office/Suite
AutoReqProv:    on
Summary:        Icon Themes for OpenOffice.org
Url:            http://www.openoffice.org/
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildArch:      noarch

%description
This package provides various icon themes for the OpenOffice.org office
suite.

####################################################
# Start of a section generated by ooo-l10n-gen-spec
# Do not edit!
####################################################

#
# l10n packages
#

%if %test_build_langs >= 2

%package -n OpenOffice_org-l10n-af
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        African Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:af)
Provides:       OpenOffice_org-af:%_prefix/ooo-2.0/program/resource/sw680af.res
Provides:       OpenOffice_org-af = %version
Obsoletes:      OpenOffice_org-af < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-african

%description -n OpenOffice_org-l10n-af
African localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ar
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Arabic Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ar)
Provides:       OpenOffice_org-ar:%_prefix/ooo-2.0/program/resource/sw680ar.res
Provides:       OpenOffice_org-ar = %version
Obsoletes:      OpenOffice_org-ar < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-ar

%description -n OpenOffice_org-l10n-ar
Arabic localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-be-BY
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Belorussian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:be_BY)
Provides:       OpenOffice_org-be-BY:%_prefix/ooo-2.0/program/resource/sw680be-BY.res
Provides:       OpenOffice_org-be-BY = %version
Obsoletes:      OpenOffice_org-be-BY < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-ru

%description -n OpenOffice_org-l10n-be-BY
Belorussian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-bg
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Bulgarian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:bg)
Provides:       OpenOffice_org-bg:%_prefix/ooo-2.0/program/resource/sw680bg.res
Provides:       OpenOffice_org-bg = %version
Obsoletes:      OpenOffice_org-bg < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-bg
Recommends:     myspell-bulgarian
Recommends:     OpenOffice_org-thesaurus-bg

%description -n OpenOffice_org-l10n-bg
Bulgarian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-br
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Breton French Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:br)
Provides:       OpenOffice_org-br:%_prefix/ooo-2.0/program/resource/sw680br.res
Provides:       OpenOffice_org-br = %version
Obsoletes:      OpenOffice_org-br < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-br
Breton French localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ca
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Catalan Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ca)
Provides:       OpenOffice_org-ca:%_prefix/ooo-2.0/program/resource/sw680ca.res
Provides:       OpenOffice_org-ca = %version
Obsoletes:      OpenOffice_org-ca < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-catalan

%description -n OpenOffice_org-l10n-ca
Catalan localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-l10n-cs
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Czech Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:cs)
Provides:       OpenOffice_org-cs:%_prefix/ooo-2.0/program/resource/sw680cs.res
Provides:       OpenOffice_org-cs = %version
Obsoletes:      OpenOffice_org-cs < %version
PreReq:         OpenOffice_org-ure = %version
PreReq:         coreutils
Recommends:     myspell-czech
Recommends:     OpenOffice_org-thesaurus-cs

%description -n OpenOffice_org-l10n-cs
Czech localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-l10n-cy
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Welsh Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:cy)
Provides:       OpenOffice_org-cy:%_prefix/ooo-2.0/program/resource/sw680cy.res
Provides:       OpenOffice_org-cy = %version
Obsoletes:      OpenOffice_org-cy < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-welsh

%description -n OpenOffice_org-l10n-cy
Welsh localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-da
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Danish Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:da)
Provides:       OpenOffice_org-da:%_prefix/ooo-2.0/program/resource/sw680da.res
Provides:       OpenOffice_org-da = %version
Obsoletes:      OpenOffice_org-da < %version
PreReq:         OpenOffice_org-ure = %version
PreReq:         coreutils
Recommends:     myspell-danish

%description -n OpenOffice_org-l10n-da
Danish localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-l10n-de
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        German Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:de)
Provides:       OpenOffice_org-de:%_prefix/ooo-2.0/program/resource/sw680de.res
Provides:       OpenOffice_org-de = %version
Obsoletes:      OpenOffice_org-de < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-german
Recommends:     OpenOffice_org-thesaurus-de

%description -n OpenOffice_org-l10n-de
German localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-l10n-el
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Greek Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:el)
Provides:       OpenOffice_org-el:%_prefix/ooo-2.0/program/resource/sw680el.res
Provides:       OpenOffice_org-el = %version
Obsoletes:      OpenOffice_org-el < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-el
Recommends:     myspell-greek

%description -n OpenOffice_org-l10n-el
Greek localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-en-GB
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        British Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:en_GB)
Provides:       OpenOffice_org-en-GB:%_prefix/ooo-2.0/program/resource/sw680en-GB.res
Provides:       OpenOffice_org-en-GB = %version
Obsoletes:      OpenOffice_org-en-GB < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-british

%description -n OpenOffice_org-l10n-en-GB
British localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif

%if %test_build_langs >= 2

%package -n OpenOffice_org-l10n-en-ZA
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        South Africa English Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:en_ZA)
Provides:       OpenOffice_org-en-ZA:%_prefix/ooo-2.0/program/resource/sw680en-ZA.res
Provides:       OpenOffice_org-en-ZA = %version
Obsoletes:      OpenOffice_org-en-ZA < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     OpenOffice_org-thesaurus-en

%description -n OpenOffice_org-l10n-en-ZA
South Africa English localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-es
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Spanish Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:es)
Provides:       OpenOffice_org-es:%_prefix/ooo-2.0/program/resource/sw680es.res
Provides:       OpenOffice_org-es = %version
Obsoletes:      OpenOffice_org-es < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-spanish
Recommends:     OpenOffice_org-thesaurus-es

%description -n OpenOffice_org-l10n-es
Spanish localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-et
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Estonian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:et)
Provides:       OpenOffice_org-et:%_prefix/ooo-2.0/program/resource/sw680et.res
Provides:       OpenOffice_org-et = %version
Obsoletes:      OpenOffice_org-et < %version
PreReq:         OpenOffice_org-ure = %version
PreReq:         coreutils
Recommends:     myspell-estonian

%description -n OpenOffice_org-l10n-et
Estonian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-fi
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Finnish Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:fi)
Provides:       OpenOffice_org-fi:%_prefix/ooo-2.0/program/resource/sw680fi.res
Provides:       OpenOffice_org-fi = %version
Obsoletes:      OpenOffice_org-fi < %version
PreReq:         OpenOffice_org-ure = %version
PreReq:         coreutils

%description -n OpenOffice_org-l10n-fi
Finnish localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-fr
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        French Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:fr)
Provides:       OpenOffice_org-fr:%_prefix/ooo-2.0/program/resource/sw680fr.res
Provides:       OpenOffice_org-fr = %version
Obsoletes:      OpenOffice_org-fr < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-french
Recommends:     OpenOffice_org-thesaurus-fr

%description -n OpenOffice_org-l10n-fr
French localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ga
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Gaelic Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ga)
Provides:       OpenOffice_org-ga:%_prefix/ooo-2.0/program/resource/sw680ga.res
Provides:       OpenOffice_org-ga = %version
Obsoletes:      OpenOffice_org-ga < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-gaelic-scots

%description -n OpenOffice_org-l10n-ga
Gaelic localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-gl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Galician Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:gl)
Provides:       OpenOffice_org-gl:%_prefix/ooo-2.0/program/resource/sw680gl.res
Provides:       OpenOffice_org-gl = %version
Obsoletes:      OpenOffice_org-gl < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-gl
Galician localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-gu-IN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Gujarati Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:gu_IN)
Provides:       OpenOffice_org-gu-IN:%_prefix/ooo-2.0/program/resource/sw680gu-IN.res
Provides:       OpenOffice_org-gu-IN = %version
Obsoletes:      OpenOffice_org-gu-IN < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-gu
Recommends:     myspell-gujarati

%description -n OpenOffice_org-l10n-gu-IN
Gujarati localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-he
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Hebrew Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:he)
Provides:       OpenOffice_org-he:%_prefix/ooo-2.0/program/resource/sw680he.res
Provides:       OpenOffice_org-he = %version
Obsoletes:      OpenOffice_org-he < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-hebrew

%description -n OpenOffice_org-l10n-he
Hebrew localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-hi-IN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Hindi Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:hi_IN)
Provides:       OpenOffice_org-hi-IN:%_prefix/ooo-2.0/program/resource/sw680hi-IN.res
Provides:       OpenOffice_org-hi-IN = %version
Obsoletes:      OpenOffice_org-hi-IN < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-hi
Recommends:     myspell-hindi

%description -n OpenOffice_org-l10n-hi-IN
Hindi localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-hr
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Croatian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:hr)
Provides:       OpenOffice_org-hr:%_prefix/ooo-2.0/program/resource/sw680hr.res
Provides:       OpenOffice_org-hr = %version
Obsoletes:      OpenOffice_org-hr < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-croatian

%description -n OpenOffice_org-l10n-hr
Croatian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-l10n-hu
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Hungarian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:hu)
Provides:       OpenOffice_org-hu:%_prefix/ooo-2.0/program/resource/sw680hu.res
Provides:       OpenOffice_org-hu = %version
Obsoletes:      OpenOffice_org-hu < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-hungarian

%description -n OpenOffice_org-l10n-hu
Hungarian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-l10n-it
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Italian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:it)
Provides:       OpenOffice_org-it:%_prefix/ooo-2.0/program/resource/sw680it.res
Provides:       OpenOffice_org-it = %version
Obsoletes:      OpenOffice_org-it < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-italian

%description -n OpenOffice_org-l10n-it
Italian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-l10n-ja
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Japanese Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ja)
Provides:       OpenOffice_org-ja:%_prefix/ooo-2.0/program/resource/sw680ja.res
Provides:       OpenOffice_org-ja = %version
Obsoletes:      OpenOffice_org-ja < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-ja

%description -n OpenOffice_org-l10n-ja
Japanese localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-l10n-ka
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Georgian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ka)
Provides:       OpenOffice_org-ka:%_prefix/ooo-2.0/program/resource/sw680ka.res
Provides:       OpenOffice_org-ka = %version
Obsoletes:      OpenOffice_org-ka < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-ka
Georgian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-km
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Khmer Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:km)
Provides:       OpenOffice_org-km:%_prefix/ooo-2.0/program/resource/sw680km.res
Provides:       OpenOffice_org-km = %version
Obsoletes:      OpenOffice_org-km < %version
PreReq:         OpenOffice_org-ure = %version
%if %suse_version > 1010
Requires:       scalable-font-km
%endif

%description -n OpenOffice_org-l10n-km
Khmer localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ko
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Korean Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ko)
Provides:       OpenOffice_org-ko:%_prefix/ooo-2.0/program/resource/sw680ko.res
Provides:       OpenOffice_org-ko = %version
Obsoletes:      OpenOffice_org-ko < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-ko

%description -n OpenOffice_org-l10n-ko
Korean localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-lt
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Lithuanian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:lt)
Provides:       OpenOffice_org-lt:%_prefix/ooo-2.0/program/resource/sw680lt.res
Provides:       OpenOffice_org-lt = %version
Obsoletes:      OpenOffice_org-lt < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-lithuanian

%description -n OpenOffice_org-l10n-lt
Lithuanian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-mk
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Macedonian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:mk)
Provides:       OpenOffice_org-mk:%_prefix/ooo-2.0/program/resource/sw680mk.res
Provides:       OpenOffice_org-mk = %version
Obsoletes:      OpenOffice_org-mk < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-ru
Recommends:     myspell-macedonian

%description -n OpenOffice_org-l10n-mk
Macedonian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-nb
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Norwegian Bokmaal Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:nb)
Provides:       OpenOffice_org-nb:%_prefix/ooo-2.0/program/resource/sw680nb.res
Provides:       OpenOffice_org-nb = %version
Obsoletes:      OpenOffice_org-nb < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-norsk-bokmaal
Recommends:     OpenOffice_org-thesaurus-nb

%description -n OpenOffice_org-l10n-nb
Norwegian Bokmaal localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-nl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Dutch Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:nl)
Provides:       OpenOffice_org-nl:%_prefix/ooo-2.0/program/resource/sw680nl.res
Provides:       OpenOffice_org-nl = %version
Obsoletes:      OpenOffice_org-nl < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-dutch

%description -n OpenOffice_org-l10n-nl
Dutch localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-nn
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Norwegian Nynorsk Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:nn)
Provides:       OpenOffice_org-nn:%_prefix/ooo-2.0/program/resource/sw680nn.res
Provides:       OpenOffice_org-nn = %version
Obsoletes:      OpenOffice_org-nn < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-norsk-nynorsk

%description -n OpenOffice_org-l10n-nn
Norwegian Nynorsk localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-nr
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Ndebele Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:nr)
Provides:       OpenOffice_org-nr:%_prefix/ooo-2.0/program/resource/sw680nr.res
Provides:       OpenOffice_org-nr = %version
Obsoletes:      OpenOffice_org-nr < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-ndebele

%description -n OpenOffice_org-l10n-nr
Ndebele localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-pa-IN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Punjabi Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pa_IN)
Provides:       OpenOffice_org-pa-IN:%_prefix/ooo-2.0/program/resource/sw680pa-IN.res
Provides:       OpenOffice_org-pa-IN = %version
Obsoletes:      OpenOffice_org-pa-IN < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-pa

%description -n OpenOffice_org-l10n-pa-IN
Punjabi localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-pl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Polish Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pl)
Provides:       OpenOffice_org-pl:%_prefix/ooo-2.0/program/resource/sw680pl.res
Provides:       OpenOffice_org-pl = %version
Obsoletes:      OpenOffice_org-pl < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-polish
Recommends:     OpenOffice_org-thesaurus-pl

%description -n OpenOffice_org-l10n-pl
Polish localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-pt
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Portuguese Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pt)
Provides:       OpenOffice_org-pt:%_prefix/ooo-2.0/program/resource/sw680pt.res
Provides:       OpenOffice_org-pt = %version
Obsoletes:      OpenOffice_org-pt < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-portuguese
Recommends:     OpenOffice_org-thesaurus-pt

%description -n OpenOffice_org-l10n-pt
Portuguese localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-pt-BR
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Brazilian Portuguese Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pt_BR)
Provides:       OpenOffice_org-pt-BR:%_prefix/ooo-2.0/program/resource/sw680pt-BR.res
Provides:       OpenOffice_org-pt-BR = %version
Obsoletes:      OpenOffice_org-pt-BR < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-brazilian

%description -n OpenOffice_org-l10n-pt-BR
Brazilian Portuguese localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ru
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Russian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ru)
Provides:       OpenOffice_org-ru:%_prefix/ooo-2.0/program/resource/sw680ru.res
Provides:       OpenOffice_org-ru = %version
Obsoletes:      OpenOffice_org-ru < %version
PreReq:         OpenOffice_org-ure = %version
Provides:       locale(OpenOffice_org:ru)
Requires:       scalable-font-ru
Recommends:     myspell-russian

%description -n OpenOffice_org-l10n-ru
Russian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-rw
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Kinyarwanda Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:rw)
Provides:       OpenOffice_org-rw:%_prefix/ooo-2.0/program/resource/sw680rw.res
Provides:       OpenOffice_org-rw = %version
Obsoletes:      OpenOffice_org-rw < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-kinyarwanda

%description -n OpenOffice_org-l10n-rw
Kinyarwanda localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-sh
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Latin Serbian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:sh)
Provides:       OpenOffice_org-sh:%_prefix/ooo-2.0/program/resource/sw680sh.res
Provides:       OpenOffice_org-sh = %version
Obsoletes:      OpenOffice_org-sh < %version
PreReq:         OpenOffice_org-ure = %version
Provides:       OpenOffice_org-sh-YU:%_prefix/ooo-2.0/program/resource/sw680sh-YU.res
Provides:       OpenOffice_org-sh-YU = %version
Obsoletes:      OpenOffice_org-sh-YU < %version

%description -n OpenOffice_org-l10n-sh
Latin Serbian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-sk
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Slovak Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:sk)
Provides:       OpenOffice_org-sk:%_prefix/ooo-2.0/program/resource/sw680sk.res
Provides:       OpenOffice_org-sk = %version
Obsoletes:      OpenOffice_org-sk < %version
PreReq:         OpenOffice_org-ure = %version
PreReq:         coreutils
Recommends:     myspell-slovak
Recommends:     OpenOffice_org-thesaurus-sk

%description -n OpenOffice_org-l10n-sk
Slovak localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-sl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Slovene Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:sl)
Provides:       OpenOffice_org-sl:%_prefix/ooo-2.0/program/resource/sw680sl.res
Provides:       OpenOffice_org-sl = %version
Obsoletes:      OpenOffice_org-sl < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-slovene

%description -n OpenOffice_org-l10n-sl
Slovene localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-sr
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Serbian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:sr)
Provides:       OpenOffice_org-sr:%_prefix/ooo-2.0/program/resource/sw680sr.res
Provides:       OpenOffice_org-sr = %version
Obsoletes:      OpenOffice_org-sr < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-ru
Provides:       OpenOffice_org-sr-CS:%_prefix/ooo-2.0/program/resource/sw680sr-CS.res
Provides:       OpenOffice_org-sr-CS = %version
Obsoletes:      OpenOffice_org-sr-CS < %version

%description -n OpenOffice_org-l10n-sr
Serbian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ss
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Swazi Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ss)
Provides:       OpenOffice_org-ss:%_prefix/ooo-2.0/program/resource/sw680ss.res
Provides:       OpenOffice_org-ss = %version
Obsoletes:      OpenOffice_org-ss < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-ss
Swazi localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-st
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Sotho Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:st)
Provides:       OpenOffice_org-st:%_prefix/ooo-2.0/program/resource/sw680st.res
Provides:       OpenOffice_org-st = %version
Obsoletes:      OpenOffice_org-st < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-sotho-northern

%description -n OpenOffice_org-l10n-st
Sotho localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-sv
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Swedish Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:sv)
Provides:       OpenOffice_org-sv:%_prefix/ooo-2.0/program/resource/sw680sv.res
Provides:       OpenOffice_org-sv = %version
Obsoletes:      OpenOffice_org-sv < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-swedish

%description -n OpenOffice_org-l10n-sv
Swedish localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-tg
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Tajiki Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:tg)
Provides:       OpenOffice_org-tg:%_prefix/ooo-2.0/program/resource/sw680tg.res
Provides:       OpenOffice_org-tg = %version
Obsoletes:      OpenOffice_org-tg < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-tg
Tajiki localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-th
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Thai Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:th)
Provides:       OpenOffice_org-th:%_prefix/ooo-2.0/program/resource/sw680th.res
Provides:       OpenOffice_org-th = %version
Obsoletes:      OpenOffice_org-th < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-th
Thai localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-tr
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Turkish Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:tr)
Provides:       OpenOffice_org-tr:%_prefix/ooo-2.0/program/resource/sw680tr.res
Provides:       OpenOffice_org-tr = %version
Obsoletes:      OpenOffice_org-tr < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-tr
Turkish localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ts
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Tsonga Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ts)
Provides:       OpenOffice_org-ts:%_prefix/ooo-2.0/program/resource/sw680ts.res
Provides:       OpenOffice_org-ts = %version
Obsoletes:      OpenOffice_org-ts < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-tsonga

%description -n OpenOffice_org-l10n-ts
Tsonga localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-uk
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Ukrainian Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:uk)
Provides:       OpenOffice_org-uk:%_prefix/ooo-2.0/program/resource/sw680uk.res
Provides:       OpenOffice_org-uk = %version
Obsoletes:      OpenOffice_org-uk < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-ukrainian

%description -n OpenOffice_org-l10n-uk
Ukrainian localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-ve
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Venda Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ve)
Provides:       OpenOffice_org-ve:%_prefix/ooo-2.0/program/resource/sw680ve.res
Provides:       OpenOffice_org-ve = %version
Obsoletes:      OpenOffice_org-ve < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-venda

%description -n OpenOffice_org-l10n-ve
Venda localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-vi
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Vietnamese Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:vi)
Provides:       OpenOffice_org-vi:%_prefix/ooo-2.0/program/resource/sw680vi.res
Provides:       OpenOffice_org-vi = %version
Obsoletes:      OpenOffice_org-vi < %version
PreReq:         OpenOffice_org-ure = %version

%description -n OpenOffice_org-l10n-vi
Vietnamese localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-xh
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Xhosa Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:xh)
Provides:       OpenOffice_org-xh:%_prefix/ooo-2.0/program/resource/sw680xh.res
Provides:       OpenOffice_org-xh = %version
Obsoletes:      OpenOffice_org-xh < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-xhosa

%description -n OpenOffice_org-l10n-xh
Xhosa localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-zh-CN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Chinese Simplified Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:zh_CN)
Provides:       OpenOffice_org-zh-CN:%_prefix/ooo-2.0/program/resource/sw680zh-CN.res
Provides:       OpenOffice_org-zh-CN = %version
Obsoletes:      OpenOffice_org-zh-CN < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-zh-CN

%description -n OpenOffice_org-l10n-zh-CN
Chinese Simplified localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-zh-TW
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Chinese Traditional Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:zh_TW)
Provides:       OpenOffice_org-zh-TW:%_prefix/ooo-2.0/program/resource/sw680zh-TW.res
Provides:       OpenOffice_org-zh-TW = %version
Obsoletes:      OpenOffice_org-zh-TW < %version
PreReq:         OpenOffice_org-ure = %version
Requires:       scalable-font-zh-TW

%description -n OpenOffice_org-l10n-zh-TW
Chinese Traditional localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%package -n OpenOffice_org-l10n-zu
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Zulu Localization Files for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:zu)
Provides:       OpenOffice_org-zu:%_prefix/ooo-2.0/program/resource/sw680zu.res
Provides:       OpenOffice_org-zu = %version
Obsoletes:      OpenOffice_org-zu < %version
PreReq:         OpenOffice_org-ure = %version
Recommends:     myspell-zulu

%description -n OpenOffice_org-l10n-zu
Zulu localization files for OpenOffice.org.
The localized help content is in OpenOffice.org-help-de.

%endif

####################################################
# End of a section generated by ooo-l10n-gen-spec
####################################################


%prep

%build

%install
# setup env.
export OO_INSTDIR=%{_libdir}/%ooo_home
export OO_TOOLSDIR=$OO_INSTDIR/ooo-build/bin
export DESTDIR=$RPM_BUILD_ROOT

$OO_TOOLSDIR/piece/install-l10n-merged %piece %ooo_build_tag

%clean
rm -rf $RPM_BUILD_ROOT

####################################################
# Start of a section generated by ooo-l10n-gen-spec
# Do not edit!
####################################################

# FIXME: call script that links noarch stuff to the ooo-home
# it will be better to fix OOo to find the noarch stuff
# on the right place

#
# l10n scripts
#

%if %test_build_langs >= 2

# af
%posttrans -n OpenOffice_org-l10n-af
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-af.txt || true

%preun -n OpenOffice_org-l10n-af
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-af.txt || true

# ar
%posttrans -n OpenOffice_org-l10n-ar
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ar.txt || true

%preun -n OpenOffice_org-l10n-ar
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ar.txt || true

# be-BY
%posttrans -n OpenOffice_org-l10n-be-BY
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-be_BY.txt || true

%preun -n OpenOffice_org-l10n-be-BY
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-be_BY.txt || true

# bg
%posttrans -n OpenOffice_org-l10n-bg
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-bg.txt || true

%preun -n OpenOffice_org-l10n-bg
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-bg.txt || true

# br
%posttrans -n OpenOffice_org-l10n-br
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-br.txt || true

%preun -n OpenOffice_org-l10n-br
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-br.txt || true

# ca
%posttrans -n OpenOffice_org-l10n-ca
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ca.txt || true

%preun -n OpenOffice_org-l10n-ca
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ca.txt || true

%endif
%if %test_build_langs >= 1

# cs
%posttrans -n OpenOffice_org-l10n-cs
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-cs.txt || true

%preun -n OpenOffice_org-l10n-cs
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-cs.txt || true

%endif
%if %test_build_langs >= 2

# cy
%posttrans -n OpenOffice_org-l10n-cy
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-cy.txt || true

%preun -n OpenOffice_org-l10n-cy
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-cy.txt || true

# da
%posttrans -n OpenOffice_org-l10n-da
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-da.txt || true

%preun -n OpenOffice_org-l10n-da
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-da.txt || true

%endif
%if %test_build_langs >= 1

# de
%posttrans -n OpenOffice_org-l10n-de
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-de.txt || true

%preun -n OpenOffice_org-l10n-de
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-de.txt || true

%endif
%if %test_build_langs >= 2

# el
%posttrans -n OpenOffice_org-l10n-el
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-el.txt || true

%preun -n OpenOffice_org-l10n-el
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-el.txt || true

# en-GB
%posttrans -n OpenOffice_org-l10n-en-GB
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-en_GB.txt || true

%preun -n OpenOffice_org-l10n-en-GB
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-en_GB.txt || true

%endif

%if %test_build_langs >= 2

# en-ZA
%posttrans -n OpenOffice_org-l10n-en-ZA
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-en_ZA.txt || true

%preun -n OpenOffice_org-l10n-en-ZA
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-en_ZA.txt || true

# es
%posttrans -n OpenOffice_org-l10n-es
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-es.txt || true

%preun -n OpenOffice_org-l10n-es
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-es.txt || true

# et
%posttrans -n OpenOffice_org-l10n-et
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-et.txt || true

%preun -n OpenOffice_org-l10n-et
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-et.txt || true

# fi
%posttrans -n OpenOffice_org-l10n-fi
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-fi.txt || true

%preun -n OpenOffice_org-l10n-fi
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-fi.txt || true

# fr
%posttrans -n OpenOffice_org-l10n-fr
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-fr.txt || true

%preun -n OpenOffice_org-l10n-fr
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-fr.txt || true

# ga
%posttrans -n OpenOffice_org-l10n-ga
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ga.txt || true

%preun -n OpenOffice_org-l10n-ga
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ga.txt || true

# gl
%posttrans -n OpenOffice_org-l10n-gl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-gl.txt || true

%preun -n OpenOffice_org-l10n-gl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-gl.txt || true

# gu-IN
%posttrans -n OpenOffice_org-l10n-gu-IN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-gu_IN.txt || true

%preun -n OpenOffice_org-l10n-gu-IN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-gu_IN.txt || true

# he
%posttrans -n OpenOffice_org-l10n-he
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-he.txt || true

%preun -n OpenOffice_org-l10n-he
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-he.txt || true

# hi-IN
%posttrans -n OpenOffice_org-l10n-hi-IN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-hi_IN.txt || true

%preun -n OpenOffice_org-l10n-hi-IN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-hi_IN.txt || true

# hr
%posttrans -n OpenOffice_org-l10n-hr
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-hr.txt || true

%preun -n OpenOffice_org-l10n-hr
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-hr.txt || true

%endif
%if %test_build_langs >= 1

# hu
%posttrans -n OpenOffice_org-l10n-hu
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-hu.txt || true

%preun -n OpenOffice_org-l10n-hu
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-hu.txt || true

%endif
%if %test_build_langs >= 2

# it
%posttrans -n OpenOffice_org-l10n-it
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-it.txt || true

%preun -n OpenOffice_org-l10n-it
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-it.txt || true

%endif
%if %test_build_langs >= 1

# ja
%posttrans -n OpenOffice_org-l10n-ja
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ja.txt || true

%preun -n OpenOffice_org-l10n-ja
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ja.txt || true

%endif
%if %test_build_langs >= 2

# ka
%posttrans -n OpenOffice_org-l10n-ka
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ka.txt || true

%preun -n OpenOffice_org-l10n-ka
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ka.txt || true

# km
%posttrans -n OpenOffice_org-l10n-km
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-km.txt || true

%preun -n OpenOffice_org-l10n-km
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-km.txt || true

# ko
%posttrans -n OpenOffice_org-l10n-ko
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ko.txt || true

%preun -n OpenOffice_org-l10n-ko
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ko.txt || true

# lt
%posttrans -n OpenOffice_org-l10n-lt
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-lt.txt || true

%preun -n OpenOffice_org-l10n-lt
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-lt.txt || true

# mk
%posttrans -n OpenOffice_org-l10n-mk
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-mk.txt || true

%preun -n OpenOffice_org-l10n-mk
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-mk.txt || true

# nb
%posttrans -n OpenOffice_org-l10n-nb
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-nb.txt || true

%preun -n OpenOffice_org-l10n-nb
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-nb.txt || true

# nl
%posttrans -n OpenOffice_org-l10n-nl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-nl.txt || true

%preun -n OpenOffice_org-l10n-nl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-nl.txt || true

# nn
%posttrans -n OpenOffice_org-l10n-nn
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-nn.txt || true

%preun -n OpenOffice_org-l10n-nn
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-nn.txt || true

# nr
%posttrans -n OpenOffice_org-l10n-nr
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-nr.txt || true

%preun -n OpenOffice_org-l10n-nr
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-nr.txt || true

# pa-IN
%posttrans -n OpenOffice_org-l10n-pa-IN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-pa_IN.txt || true

%preun -n OpenOffice_org-l10n-pa-IN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-pa_IN.txt || true

# pl
%posttrans -n OpenOffice_org-l10n-pl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-pl.txt || true

%preun -n OpenOffice_org-l10n-pl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-pl.txt || true

# pt
%posttrans -n OpenOffice_org-l10n-pt
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-pt.txt || true

%preun -n OpenOffice_org-l10n-pt
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-pt.txt || true

# pt-BR
%posttrans -n OpenOffice_org-l10n-pt-BR
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-pt_BR.txt || true

%preun -n OpenOffice_org-l10n-pt-BR
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-pt_BR.txt || true

# ru
%posttrans -n OpenOffice_org-l10n-ru
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ru.txt || true

%preun -n OpenOffice_org-l10n-ru
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ru.txt || true

# rw
%posttrans -n OpenOffice_org-l10n-rw
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-rw.txt || true

%preun -n OpenOffice_org-l10n-rw
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-rw.txt || true

# sh
%posttrans -n OpenOffice_org-l10n-sh
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-sh.txt || true

%preun -n OpenOffice_org-l10n-sh
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-sh.txt || true

# sk
%posttrans -n OpenOffice_org-l10n-sk
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-sk.txt || true

%preun -n OpenOffice_org-l10n-sk
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-sk.txt || true

# sl
%posttrans -n OpenOffice_org-l10n-sl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-sl.txt || true

%preun -n OpenOffice_org-l10n-sl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-sl.txt || true

# sr
%posttrans -n OpenOffice_org-l10n-sr
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-sr.txt || true

%preun -n OpenOffice_org-l10n-sr
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-sr.txt || true

# ss
%posttrans -n OpenOffice_org-l10n-ss
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ss.txt || true

%preun -n OpenOffice_org-l10n-ss
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ss.txt || true

# st
%posttrans -n OpenOffice_org-l10n-st
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-st.txt || true

%preun -n OpenOffice_org-l10n-st
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-st.txt || true

# sv
%posttrans -n OpenOffice_org-l10n-sv
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-sv.txt || true

%preun -n OpenOffice_org-l10n-sv
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-sv.txt || true

# tg
%posttrans -n OpenOffice_org-l10n-tg
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-tg.txt || true

%preun -n OpenOffice_org-l10n-tg
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-tg.txt || true

# th
%posttrans -n OpenOffice_org-l10n-th
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-th.txt || true

%preun -n OpenOffice_org-l10n-th
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-th.txt || true

# tr
%posttrans -n OpenOffice_org-l10n-tr
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-tr.txt || true

%preun -n OpenOffice_org-l10n-tr
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-tr.txt || true

# ts
%posttrans -n OpenOffice_org-l10n-ts
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ts.txt || true

%preun -n OpenOffice_org-l10n-ts
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ts.txt || true

# uk
%posttrans -n OpenOffice_org-l10n-uk
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-uk.txt || true

%preun -n OpenOffice_org-l10n-uk
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-uk.txt || true

# ve
%posttrans -n OpenOffice_org-l10n-ve
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-ve.txt || true

%preun -n OpenOffice_org-l10n-ve
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-ve.txt || true

# vi
%posttrans -n OpenOffice_org-l10n-vi
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-vi.txt || true

%preun -n OpenOffice_org-l10n-vi
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-vi.txt || true

# xh
%posttrans -n OpenOffice_org-l10n-xh
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-xh.txt || true

%preun -n OpenOffice_org-l10n-xh
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-xh.txt || true

# zh-CN
%posttrans -n OpenOffice_org-l10n-zh-CN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-zh_CN.txt || true

%preun -n OpenOffice_org-l10n-zh-CN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-zh_CN.txt || true

# zh-TW
%posttrans -n OpenOffice_org-l10n-zh-TW
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-zh_TW.txt || true

%preun -n OpenOffice_org-l10n-zh-TW
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-zh_TW.txt || true

# zu
%posttrans -n OpenOffice_org-l10n-zu
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-l10n-zu.txt || true

%preun -n OpenOffice_org-l10n-zu
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-l10n-zu.txt || true

%endif

#
# l10n files
#

%if %test_build_langs >= 2

%files -f files-l10n-af.txt -n OpenOffice_org-l10n-af
%defattr(-,root,root)

%files -f files-l10n-ar.txt -n OpenOffice_org-l10n-ar
%defattr(-,root,root)

%files -f files-l10n-be_BY.txt -n OpenOffice_org-l10n-be-BY
%defattr(-,root,root)

%files -f files-l10n-bg.txt -n OpenOffice_org-l10n-bg
%defattr(-,root,root)

%files -f files-l10n-br.txt -n OpenOffice_org-l10n-br
%defattr(-,root,root)

%files -f files-l10n-ca.txt -n OpenOffice_org-l10n-ca
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-l10n-cs.txt -n OpenOffice_org-l10n-cs
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-l10n-cy.txt -n OpenOffice_org-l10n-cy
%defattr(-,root,root)

%files -f files-l10n-da.txt -n OpenOffice_org-l10n-da
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-l10n-de.txt -n OpenOffice_org-l10n-de
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-l10n-el.txt -n OpenOffice_org-l10n-el
%defattr(-,root,root)

%files -f files-l10n-en_GB.txt -n OpenOffice_org-l10n-en-GB
%defattr(-,root,root)

%endif

%if %test_build_langs >= 2

%files -f files-l10n-en_ZA.txt -n OpenOffice_org-l10n-en-ZA
%defattr(-,root,root)

%files -f files-l10n-es.txt -n OpenOffice_org-l10n-es
%defattr(-,root,root)

%files -f files-l10n-et.txt -n OpenOffice_org-l10n-et
%defattr(-,root,root)

%files -f files-l10n-fi.txt -n OpenOffice_org-l10n-fi
%defattr(-,root,root)

%files -f files-l10n-fr.txt -n OpenOffice_org-l10n-fr
%defattr(-,root,root)

%files -f files-l10n-ga.txt -n OpenOffice_org-l10n-ga
%defattr(-,root,root)

%files -f files-l10n-gl.txt -n OpenOffice_org-l10n-gl
%defattr(-,root,root)

%files -f files-l10n-gu_IN.txt -n OpenOffice_org-l10n-gu-IN
%defattr(-,root,root)

%files -f files-l10n-he.txt -n OpenOffice_org-l10n-he
%defattr(-,root,root)

%files -f files-l10n-hi_IN.txt -n OpenOffice_org-l10n-hi-IN
%defattr(-,root,root)

%files -f files-l10n-hr.txt -n OpenOffice_org-l10n-hr
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-l10n-hu.txt -n OpenOffice_org-l10n-hu
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-l10n-it.txt -n OpenOffice_org-l10n-it
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-l10n-ja.txt -n OpenOffice_org-l10n-ja
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-l10n-ka.txt -n OpenOffice_org-l10n-ka
%defattr(-,root,root)

%files -f files-l10n-km.txt -n OpenOffice_org-l10n-km
%defattr(-,root,root)

%files -f files-l10n-ko.txt -n OpenOffice_org-l10n-ko
%defattr(-,root,root)

%files -f files-l10n-lt.txt -n OpenOffice_org-l10n-lt
%defattr(-,root,root)

%files -f files-l10n-mk.txt -n OpenOffice_org-l10n-mk
%defattr(-,root,root)

%files -f files-l10n-nb.txt -n OpenOffice_org-l10n-nb
%defattr(-,root,root)

%files -f files-l10n-nl.txt -n OpenOffice_org-l10n-nl
%defattr(-,root,root)

%files -f files-l10n-nn.txt -n OpenOffice_org-l10n-nn
%defattr(-,root,root)

%files -f files-l10n-nr.txt -n OpenOffice_org-l10n-nr
%defattr(-,root,root)

%files -f files-l10n-pa_IN.txt -n OpenOffice_org-l10n-pa-IN
%defattr(-,root,root)

%files -f files-l10n-pl.txt -n OpenOffice_org-l10n-pl
%defattr(-,root,root)

%files -f files-l10n-pt.txt -n OpenOffice_org-l10n-pt
%defattr(-,root,root)

%files -f files-l10n-pt_BR.txt -n OpenOffice_org-l10n-pt-BR
%defattr(-,root,root)

%files -f files-l10n-ru.txt -n OpenOffice_org-l10n-ru
%defattr(-,root,root)

%files -f files-l10n-rw.txt -n OpenOffice_org-l10n-rw
%defattr(-,root,root)

%files -f files-l10n-sh.txt -n OpenOffice_org-l10n-sh
%defattr(-,root,root)

%files -f files-l10n-sk.txt -n OpenOffice_org-l10n-sk
%defattr(-,root,root)

%files -f files-l10n-sl.txt -n OpenOffice_org-l10n-sl
%defattr(-,root,root)

%files -f files-l10n-sr.txt -n OpenOffice_org-l10n-sr
%defattr(-,root,root)

%files -f files-l10n-ss.txt -n OpenOffice_org-l10n-ss
%defattr(-,root,root)

%files -f files-l10n-st.txt -n OpenOffice_org-l10n-st
%defattr(-,root,root)

%files -f files-l10n-sv.txt -n OpenOffice_org-l10n-sv
%defattr(-,root,root)

%files -f files-l10n-tg.txt -n OpenOffice_org-l10n-tg
%defattr(-,root,root)

%files -f files-l10n-th.txt -n OpenOffice_org-l10n-th
%defattr(-,root,root)

%files -f files-l10n-tr.txt -n OpenOffice_org-l10n-tr
%defattr(-,root,root)

%files -f files-l10n-ts.txt -n OpenOffice_org-l10n-ts
%defattr(-,root,root)

%files -f files-l10n-uk.txt -n OpenOffice_org-l10n-uk
%defattr(-,root,root)

%files -f files-l10n-ve.txt -n OpenOffice_org-l10n-ve
%defattr(-,root,root)

%files -f files-l10n-vi.txt -n OpenOffice_org-l10n-vi
%defattr(-,root,root)

%files -f files-l10n-xh.txt -n OpenOffice_org-l10n-xh
%defattr(-,root,root)

%files -f files-l10n-zh_CN.txt -n OpenOffice_org-l10n-zh-CN
%defattr(-,root,root)

%files -f files-l10n-zh_TW.txt -n OpenOffice_org-l10n-zh-TW
%defattr(-,root,root)

%files -f files-l10n-zu.txt -n OpenOffice_org-l10n-zu
%defattr(-,root,root)

%endif

####################################################
# End of a section generated by ooo-l10n-gen-spec
####################################################




%changelog
* Fri Aug 29 2008 pmladek@suse.cz
- added build dependency on exact version of
  OpenOffice_org-icon-themes-prebuilt to avoid inconsistent state [bnc#421559]
* Wed Aug 27 2008 pmladek@suse.cz
- updated to version 3.0.0.2
* Thu Aug 21 2008 pmladek@suse.cz
- updated to version 3.0.0.1
* Fri Aug 15 2008 pmladek@suse.cz
- updated to version 3.0.0
* Fri Jul 18 2008 pmladek@suse.cz
- updated to version 2.99.25
* Thu Jul 03 2008 pmladek@suse.cz
- updated to version 2.99.21
- updated for the new three layer structure (basis subdir dir)
* Tue Jun 24 2008 pmladek@suse.cz
- updated to version 2.4.1.7
* Thu Jun 05 2008 pmladek@suse.cz
- updated ooo-build to version 2.4.0.14
* Thu May 22 2008 pmladek@suse.cz
- updated ooo-build to version 2.4.0.13
* Fri May 09 2008 pmladek@suse.cz
- updated ooo-build to ooo-build-2.4.0.10
* Thu Apr 24 2008 pmladek@suse.cz
- updated ooo-build to ooo-build-2.4.0.8
* Mon Apr 14 2008 pmladek@suse.cz
- split from the OpenOffice_org-i18n source package to get it faster
