# ---------------------------------------------------------------------------
# - MTH0111.als                                                             -
# - afnix:mth module algebra test unit                                      -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2016 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   qr direct solver test unit
# @author amaury darsch

# get the module
interp:library "afnix-mth"
# load matrix generator
interp:load "MTHXXXX"

# create a qr solver
const qr (afnix:mth:Qr)  

# check representation
assert true (afnix:mth:qr-p qr)
assert true (afnix:mth:direct-p qr)
assert true (afnix:mth:solver-p qr)
assert "Qr" (qr:repr)

# create 3x3 matrix
trans m (afnix:mth:Rmatrix 3)
mth-set-3x3 m
# set lhs and factorize
qr:set-lhs m
qr:factorize
# get the qr matrix and compare
trans qrm (qr:get-qr)
assert true (qrm:?= m)

# create 3x3 matrix
trans m (afnix:mth:Rmatrix 3)
mth-set-3x3 m
# create a 3x3 permutation
trans p (afnix:mth:Permute 3)
p:set 0 2
p:set 1 0
p:set 2 1
# set lhs and factorize
qr:set-lhs m
qr:set-permutation p
qr:factorize
# get the qr matrix and compare
trans qrm (qr:get-qr)
assert true (qrm:?= m)

# create a 5x5 matrix
trans m (afnix:mth:Rmatrix 5)
mth-set-5x5 m
# set lhs and factorize
qr:set-lhs m
qr:factorize
# get the qr matrix and compare
trans qrm (qr:get-qr)
assert true (qrm:?= m)

# create a 9x9 matrix
trans m (afnix:mth:Rmatrix 9)
mth-set-9x9 m
# set lhs and factorize
qr:set-lhs m
qr:factorize
# get the qr matrix and compare
trans qrm (qr:get-qr)
assert true (qrm:?= m)

# create a random matrix
trans m (afnix:mth:get-random-r-matrix 17 100.0 true)
# set lhs and factorize
qr:set-lhs m
qr:factorize
# get the qr matrix and compare
trans qrm (qr:get-qr)
assert true (qrm:?= m)

# create a random matrix
trans m (afnix:mth:get-random-r-matrix 64 100.0 true)
# set lhs and factorize
qr:set-lhs m
qr:factorize
# get the qr matrix and compare
trans qrm (qr:get-qr)
assert true (qrm:?= m)

# create a random matrix
trans m (afnix:mth:get-random-r-matrix 128 100.0 true)
# set lhs and factorize
qr:set-lhs m
qr:factorize
# get the qr matrix and compare
trans qrm (qr:get-qr)
assert true (qrm:?= m)
