// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package kinesis provides a client for Amazon Kinesis.
package kinesis

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToStream = "AddTagsToStream"

// AddTagsToStreamRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToStreamRequest method.
//    req, resp := client.AddTagsToStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStream
func (c *Kinesis) AddTagsToStreamRequest(input *AddTagsToStreamInput) (req *request.Request, output *AddTagsToStreamOutput) {
	op := &request.Operation{
		Name:       opAddTagsToStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToStreamInput{}
	}

	output = &AddTagsToStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToStream API operation for Amazon Kinesis.
//
// Adds or updates tags for the specified Amazon Kinesis stream. Each stream
// can have up to 10 tags.
//
// If tags have already been assigned to the stream, AddTagsToStream overwrites
// any existing tags that correspond to the specified tag keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation AddTagsToStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStream
func (c *Kinesis) AddTagsToStream(input *AddTagsToStreamInput) (*AddTagsToStreamOutput, error) {
	req, out := c.AddTagsToStreamRequest(input)
	return out, req.Send()
}

// AddTagsToStreamWithContext is the same as AddTagsToStream with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) AddTagsToStreamWithContext(ctx aws.Context, input *AddTagsToStreamInput, opts ...request.Option) (*AddTagsToStreamOutput, error) {
	req, out := c.AddTagsToStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStream = "CreateStream"

// CreateStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateStreamRequest method.
//    req, resp := client.CreateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream
func (c *Kinesis) CreateStreamRequest(input *CreateStreamInput) (req *request.Request, output *CreateStreamOutput) {
	op := &request.Operation{
		Name:       opCreateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamInput{}
	}

	output = &CreateStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateStream API operation for Amazon Kinesis.
//
// Creates an Amazon Kinesis stream. A stream captures and transports data records
// that are continuously emitted from different data sources or producers. Scale-out
// within a stream is explicitly supported by means of shards, which are uniquely
// identified groups of data records in a stream.
//
// You specify and control the number of shards that a stream is composed of.
// Each shard can support reads up to 5 transactions per second, up to a maximum
// data read total of 2 MB per second. Each shard can support writes up to 1,000
// records per second, up to a maximum data write total of 1 MB per second.
// You can add shards to a stream if the amount of data input increases and
// you can remove shards if the amount of data input decreases.
//
// The stream name identifies the stream. The name is scoped to the AWS account
// used by the application. It is also scoped by region. That is, two streams
// in two different accounts can have the same name, and two streams in the
// same account, but in two different regions, can have the same name.
//
// CreateStream is an asynchronous operation. Upon receiving a CreateStream
// request, Amazon Kinesis immediately returns and sets the stream status to
// CREATING. After the stream is created, Amazon Kinesis sets the stream status
// to ACTIVE. You should perform read and write operations only on an ACTIVE
// stream.
//
// You receive a LimitExceededException when making a CreateStream request if
// you try to do one of the following:
//
//    * Have more than five streams in the CREATING state at any point in time.
//
//    * Create more shards than are authorized for your account.
//
// For the default shard limit for an AWS account, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Streams Developer Guide. If you need to increase this
// limit, contact AWS Support (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
//
// You can use DescribeStream to check the stream status, which is returned
// in StreamStatus.
//
// CreateStream has a limit of 5 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation CreateStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream
func (c *Kinesis) CreateStream(input *CreateStreamInput) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	return out, req.Send()
}

// CreateStreamWithContext is the same as CreateStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) CreateStreamWithContext(ctx aws.Context, input *CreateStreamInput, opts ...request.Option) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDecreaseStreamRetentionPeriod = "DecreaseStreamRetentionPeriod"

// DecreaseStreamRetentionPeriodRequest generates a "aws/request.Request" representing the
// client's request for the DecreaseStreamRetentionPeriod operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DecreaseStreamRetentionPeriod for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DecreaseStreamRetentionPeriod method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DecreaseStreamRetentionPeriodRequest method.
//    req, resp := client.DecreaseStreamRetentionPeriodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod
func (c *Kinesis) DecreaseStreamRetentionPeriodRequest(input *DecreaseStreamRetentionPeriodInput) (req *request.Request, output *DecreaseStreamRetentionPeriodOutput) {
	op := &request.Operation{
		Name:       opDecreaseStreamRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecreaseStreamRetentionPeriodInput{}
	}

	output = &DecreaseStreamRetentionPeriodOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DecreaseStreamRetentionPeriod API operation for Amazon Kinesis.
//
// Decreases the Amazon Kinesis stream's retention period, which is the length
// of time data records are accessible after they are added to the stream. The
// minimum value of a stream's retention period is 24 hours.
//
// This operation may result in lost data. For example, if the stream's retention
// period is 48 hours and is decreased to 24 hours, any data already in the
// stream that is older than 24 hours is inaccessible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DecreaseStreamRetentionPeriod for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod
func (c *Kinesis) DecreaseStreamRetentionPeriod(input *DecreaseStreamRetentionPeriodInput) (*DecreaseStreamRetentionPeriodOutput, error) {
	req, out := c.DecreaseStreamRetentionPeriodRequest(input)
	return out, req.Send()
}

// DecreaseStreamRetentionPeriodWithContext is the same as DecreaseStreamRetentionPeriod with the addition of
// the ability to pass a context and additional request options.
//
// See DecreaseStreamRetentionPeriod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DecreaseStreamRetentionPeriodWithContext(ctx aws.Context, input *DecreaseStreamRetentionPeriodInput, opts ...request.Option) (*DecreaseStreamRetentionPeriodOutput, error) {
	req, out := c.DecreaseStreamRetentionPeriodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteStreamRequest method.
//    req, resp := client.DeleteStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream
func (c *Kinesis) DeleteStreamRequest(input *DeleteStreamInput) (req *request.Request, output *DeleteStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	output = &DeleteStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStream API operation for Amazon Kinesis.
//
// Deletes an Amazon Kinesis stream and all its shards and data. You must shut
// down any applications that are operating on the stream before you delete
// the stream. If an application attempts to operate on a deleted stream, it
// will receive the exception ResourceNotFoundException.
//
// If the stream is in the ACTIVE state, you can delete it. After a DeleteStream
// request, the specified stream is in the DELETING state until Amazon Kinesis
// completes the deletion.
//
// Note: Amazon Kinesis might continue to accept data read and write operations,
// such as PutRecord, PutRecords, and GetRecords, on a stream in the DELETING
// state until the stream deletion is complete.
//
// When you delete a stream, any shards in that stream are also deleted, and
// any tags are dissociated from the stream.
//
// You can use the DescribeStream operation to check the state of the stream,
// which is returned in StreamStatus.
//
// DeleteStream has a limit of 5 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DeleteStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream
func (c *Kinesis) DeleteStream(input *DeleteStreamInput) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	return out, req.Send()
}

// DeleteStreamWithContext is the same as DeleteStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DeleteStreamWithContext(ctx aws.Context, input *DeleteStreamInput, opts ...request.Option) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLimits = "DescribeLimits"

// DescribeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLimits operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLimits for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLimits method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLimitsRequest method.
//    req, resp := client.DescribeLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits
func (c *Kinesis) DescribeLimitsRequest(input *DescribeLimitsInput) (req *request.Request, output *DescribeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLimitsInput{}
	}

	output = &DescribeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLimits API operation for Amazon Kinesis.
//
// Describes the shard limits and usage for the account.
//
// If you update your account limits, the old limits might be returned for a
// few minutes.
//
// This operation has a limit of 1 transaction per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DescribeLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits
func (c *Kinesis) DescribeLimits(input *DescribeLimitsInput) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	return out, req.Send()
}

// DescribeLimitsWithContext is the same as DescribeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeLimitsWithContext(ctx aws.Context, input *DescribeLimitsInput, opts ...request.Option) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStreamRequest method.
//    req, resp := client.DescribeStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStream
func (c *Kinesis) DescribeStreamRequest(input *DescribeStreamInput) (req *request.Request, output *DescribeStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartShardId"},
			OutputTokens:    []string{"StreamDescription.Shards[-1].ShardId"},
			LimitToken:      "Limit",
			TruncationToken: "StreamDescription.HasMoreShards",
		},
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	output = &DescribeStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStream API operation for Amazon Kinesis.
//
// Describes the specified Amazon Kinesis stream.
//
// The information returned includes the stream name, Amazon Resource Name (ARN),
// creation time, enhanced metric configuration, and shard map. The shard map
// is an array of shard objects. For each shard object, there is the hash key
// and sequence number ranges that the shard spans, and the IDs of any earlier
// shards that played in a role in creating the shard. Every record ingested
// in the stream is identified by a sequence number, which is assigned when
// the record is put into the stream.
//
// You can limit the number of shards returned by each call. For more information,
// see Retrieving Shards from a Stream (http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-retrieve-shards.html)
// in the Amazon Kinesis Streams Developer Guide.
//
// There are no guarantees about the chronological order shards returned. To
// process shards in chronological order, use the ID of the parent shard to
// track the lineage to the oldest shard.
//
// This operation has a limit of 10 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DescribeStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStream
func (c *Kinesis) DescribeStream(input *DescribeStreamInput) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	return out, req.Send()
}

// DescribeStreamWithContext is the same as DescribeStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeStreamWithContext(ctx aws.Context, input *DescribeStreamInput, opts ...request.Option) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStreamPages iterates over the pages of a DescribeStream operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStream method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStream operation.
//    pageNum := 0
//    err := client.DescribeStreamPages(params,
//        func(page *DescribeStreamOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kinesis) DescribeStreamPages(input *DescribeStreamInput, fn func(*DescribeStreamOutput, bool) bool) error {
	return c.DescribeStreamPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStreamPagesWithContext same as DescribeStreamPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeStreamPagesWithContext(ctx aws.Context, input *DescribeStreamInput, fn func(*DescribeStreamOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.DescribeStreamRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeStreamOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDisableEnhancedMonitoring = "DisableEnhancedMonitoring"

// DisableEnhancedMonitoringRequest generates a "aws/request.Request" representing the
// client's request for the DisableEnhancedMonitoring operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableEnhancedMonitoring for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableEnhancedMonitoring method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableEnhancedMonitoringRequest method.
//    req, resp := client.DisableEnhancedMonitoringRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoring
func (c *Kinesis) DisableEnhancedMonitoringRequest(input *DisableEnhancedMonitoringInput) (req *request.Request, output *EnhancedMonitoringOutput) {
	op := &request.Operation{
		Name:       opDisableEnhancedMonitoring,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableEnhancedMonitoringInput{}
	}

	output = &EnhancedMonitoringOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableEnhancedMonitoring API operation for Amazon Kinesis.
//
// Disables enhanced monitoring.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DisableEnhancedMonitoring for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoring
func (c *Kinesis) DisableEnhancedMonitoring(input *DisableEnhancedMonitoringInput) (*EnhancedMonitoringOutput, error) {
	req, out := c.DisableEnhancedMonitoringRequest(input)
	return out, req.Send()
}

// DisableEnhancedMonitoringWithContext is the same as DisableEnhancedMonitoring with the addition of
// the ability to pass a context and additional request options.
//
// See DisableEnhancedMonitoring for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DisableEnhancedMonitoringWithContext(ctx aws.Context, input *DisableEnhancedMonitoringInput, opts ...request.Option) (*EnhancedMonitoringOutput, error) {
	req, out := c.DisableEnhancedMonitoringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableEnhancedMonitoring = "EnableEnhancedMonitoring"

// EnableEnhancedMonitoringRequest generates a "aws/request.Request" representing the
// client's request for the EnableEnhancedMonitoring operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableEnhancedMonitoring for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableEnhancedMonitoring method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableEnhancedMonitoringRequest method.
//    req, resp := client.EnableEnhancedMonitoringRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoring
func (c *Kinesis) EnableEnhancedMonitoringRequest(input *EnableEnhancedMonitoringInput) (req *request.Request, output *EnhancedMonitoringOutput) {
	op := &request.Operation{
		Name:       opEnableEnhancedMonitoring,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableEnhancedMonitoringInput{}
	}

	output = &EnhancedMonitoringOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableEnhancedMonitoring API operation for Amazon Kinesis.
//
// Enables enhanced Amazon Kinesis stream monitoring for shard-level metrics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation EnableEnhancedMonitoring for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoring
func (c *Kinesis) EnableEnhancedMonitoring(input *EnableEnhancedMonitoringInput) (*EnhancedMonitoringOutput, error) {
	req, out := c.EnableEnhancedMonitoringRequest(input)
	return out, req.Send()
}

// EnableEnhancedMonitoringWithContext is the same as EnableEnhancedMonitoring with the addition of
// the ability to pass a context and additional request options.
//
// See EnableEnhancedMonitoring for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) EnableEnhancedMonitoringWithContext(ctx aws.Context, input *EnableEnhancedMonitoringInput, opts ...request.Option) (*EnhancedMonitoringOutput, error) {
	req, out := c.EnableEnhancedMonitoringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecords = "GetRecords"

// GetRecordsRequest generates a "aws/request.Request" representing the
// client's request for the GetRecords operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRecords for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRecords method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRecordsRequest method.
//    req, resp := client.GetRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecords
func (c *Kinesis) GetRecordsRequest(input *GetRecordsInput) (req *request.Request, output *GetRecordsOutput) {
	op := &request.Operation{
		Name:       opGetRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRecordsInput{}
	}

	output = &GetRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecords API operation for Amazon Kinesis.
//
// Gets data records from an Amazon Kinesis stream's shard.
//
// Specify a shard iterator using the ShardIterator parameter. The shard iterator
// specifies the position in the shard from which you want to start reading
// data records sequentially. If there are no records available in the portion
// of the shard that the iterator points to, GetRecords returns an empty list.
// Note that it might take multiple calls to get to a portion of the shard that
// contains records.
//
// You can scale by provisioning multiple shards per stream while considering
// service limits (for more information, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Streams Developer Guide). Your application should have
// one thread per shard, each reading continuously from its stream. To read
// from a stream continually, call GetRecords in a loop. Use GetShardIterator
// to get the shard iterator to specify in the first GetRecords call. GetRecords
// returns a new shard iterator in NextShardIterator. Specify the shard iterator
// returned in NextShardIterator in subsequent calls to GetRecords. Note that
// if the shard has been closed, the shard iterator can't return more data and
// GetRecords returns null in NextShardIterator. You can terminate the loop
// when the shard is closed, or when the shard iterator reaches the record with
// the sequence number or other attribute that marks it as the last record to
// process.
//
// Each data record can be up to 1 MB in size, and each shard can read up to
// 2 MB per second. You can ensure that your calls don't exceed the maximum
// supported size or throughput by using the Limit parameter to specify the
// maximum number of records that GetRecords can return. Consider your average
// record size when determining this limit.
//
// The size of the data returned by GetRecords varies depending on the utilization
// of the shard. The maximum size of data that GetRecords can return is 10 MB.
// If a call returns this amount of data, subsequent calls made within the next
// 5 seconds throw ProvisionedThroughputExceededException. If there is insufficient
// provisioned throughput on the shard, subsequent calls made within the next
// 1 second throw ProvisionedThroughputExceededException. Note that GetRecords
// won't return any data when it throws an exception. For this reason, we recommend
// that you wait one second between calls to GetRecords; however, it's possible
// that the application will get exceptions for longer than 1 second.
//
// To detect whether the application is falling behind in processing, you can
// use the MillisBehindLatest response attribute. You can also monitor the stream
// using CloudWatch metrics and other mechanisms (see Monitoring (http://docs.aws.amazon.com/kinesis/latest/dev/monitoring.html)
// in the Amazon Kinesis Streams Developer Guide).
//
// Each Amazon Kinesis record includes a value, ApproximateArrivalTimestamp,
// that is set when a stream successfully receives and stores a record. This
// is commonly referred to as a server-side timestamp, whereas a client-side
// timestamp is set when a data producer creates or sends the record to a stream
// (a data producer is any data source putting data records into a stream, for
// example with PutRecords). The timestamp has millisecond precision. There
// are no guarantees about the timestamp accuracy, or that the timestamp is
// always increasing. For example, records in a shard or across a stream might
// have timestamps that are out of order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation GetRecords for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The request rate for the stream is too high, or the requested data is too
//   large for the available throughput. Reduce the frequency or size of your
//   requests. For more information, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//   in the Amazon Kinesis Streams Developer Guide, and Error Retries and Exponential
//   Backoff in AWS (http://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//   in the AWS General Reference.
//
//   * ErrCodeExpiredIteratorException "ExpiredIteratorException"
//   The provided iterator exceeds the maximum age allowed.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecords
func (c *Kinesis) GetRecords(input *GetRecordsInput) (*GetRecordsOutput, error) {
	req, out := c.GetRecordsRequest(input)
	return out, req.Send()
}

// GetRecordsWithContext is the same as GetRecords with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) GetRecordsWithContext(ctx aws.Context, input *GetRecordsInput, opts ...request.Option) (*GetRecordsOutput, error) {
	req, out := c.GetRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetShardIterator = "GetShardIterator"

// GetShardIteratorRequest generates a "aws/request.Request" representing the
// client's request for the GetShardIterator operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetShardIterator for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetShardIterator method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetShardIteratorRequest method.
//    req, resp := client.GetShardIteratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIterator
func (c *Kinesis) GetShardIteratorRequest(input *GetShardIteratorInput) (req *request.Request, output *GetShardIteratorOutput) {
	op := &request.Operation{
		Name:       opGetShardIterator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetShardIteratorInput{}
	}

	output = &GetShardIteratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetShardIterator API operation for Amazon Kinesis.
//
// Gets an Amazon Kinesis shard iterator. A shard iterator expires five minutes
// after it is returned to the requester.
//
// A shard iterator specifies the shard position from which to start reading
// data records sequentially. The position is specified using the sequence number
// of a data record in a shard. A sequence number is the identifier associated
// with every record ingested in the stream, and is assigned when a record is
// put into the stream. Each stream has one or more shards.
//
// You must specify the shard iterator type. For example, you can set the ShardIteratorType
// parameter to read exactly from the position denoted by a specific sequence
// number by using the AT_SEQUENCE_NUMBER shard iterator type, or right after
// the sequence number by using the AFTER_SEQUENCE_NUMBER shard iterator type,
// using sequence numbers returned by earlier calls to PutRecord, PutRecords,
// GetRecords, or DescribeStream. In the request, you can specify the shard
// iterator type AT_TIMESTAMP to read records from an arbitrary point in time,
// TRIM_HORIZON to cause ShardIterator to point to the last untrimmed record
// in the shard in the system (the oldest data record in the shard), or LATEST
// so that you always read the most recent data in the shard.
//
// When you read repeatedly from a stream, use a GetShardIterator request to
// get the first shard iterator for use in your first GetRecords request and
// for subsequent reads use the shard iterator returned by the GetRecords request
// in NextShardIterator. A new shard iterator is returned by every GetRecords
// request in NextShardIterator, which you use in the ShardIterator parameter
// of the next GetRecords request.
//
// If a GetShardIterator request is made too often, you receive a ProvisionedThroughputExceededException.
// For more information about throughput limits, see GetRecords, and Streams
// Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Streams Developer Guide.
//
// If the shard is closed, GetShardIterator returns a valid iterator for the
// last sequence number of the shard. Note that a shard can be closed as a result
// of using SplitShard or MergeShards.
//
// GetShardIterator has a limit of 5 transactions per second per account per
// open shard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation GetShardIterator for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The request rate for the stream is too high, or the requested data is too
//   large for the available throughput. Reduce the frequency or size of your
//   requests. For more information, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//   in the Amazon Kinesis Streams Developer Guide, and Error Retries and Exponential
//   Backoff in AWS (http://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//   in the AWS General Reference.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIterator
func (c *Kinesis) GetShardIterator(input *GetShardIteratorInput) (*GetShardIteratorOutput, error) {
	req, out := c.GetShardIteratorRequest(input)
	return out, req.Send()
}

// GetShardIteratorWithContext is the same as GetShardIterator with the addition of
// the ability to pass a context and additional request options.
//
// See GetShardIterator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) GetShardIteratorWithContext(ctx aws.Context, input *GetShardIteratorInput, opts ...request.Option) (*GetShardIteratorOutput, error) {
	req, out := c.GetShardIteratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIncreaseStreamRetentionPeriod = "IncreaseStreamRetentionPeriod"

// IncreaseStreamRetentionPeriodRequest generates a "aws/request.Request" representing the
// client's request for the IncreaseStreamRetentionPeriod operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See IncreaseStreamRetentionPeriod for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the IncreaseStreamRetentionPeriod method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the IncreaseStreamRetentionPeriodRequest method.
//    req, resp := client.IncreaseStreamRetentionPeriodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod
func (c *Kinesis) IncreaseStreamRetentionPeriodRequest(input *IncreaseStreamRetentionPeriodInput) (req *request.Request, output *IncreaseStreamRetentionPeriodOutput) {
	op := &request.Operation{
		Name:       opIncreaseStreamRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IncreaseStreamRetentionPeriodInput{}
	}

	output = &IncreaseStreamRetentionPeriodOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// IncreaseStreamRetentionPeriod API operation for Amazon Kinesis.
//
// Increases the Amazon Kinesis stream's retention period, which is the length
// of time data records are accessible after they are added to the stream. The
// maximum value of a stream's retention period is 168 hours (7 days).
//
// Upon choosing a longer stream retention period, this operation will increase
// the time period records are accessible that have not yet expired. However,
// it will not make previous data that has expired (older than the stream's
// previous retention period) accessible after the operation has been called.
// For example, if a stream's retention period is set to 24 hours and is increased
// to 168 hours, any data that is older than 24 hours will remain inaccessible
// to consumer applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation IncreaseStreamRetentionPeriod for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod
func (c *Kinesis) IncreaseStreamRetentionPeriod(input *IncreaseStreamRetentionPeriodInput) (*IncreaseStreamRetentionPeriodOutput, error) {
	req, out := c.IncreaseStreamRetentionPeriodRequest(input)
	return out, req.Send()
}

// IncreaseStreamRetentionPeriodWithContext is the same as IncreaseStreamRetentionPeriod with the addition of
// the ability to pass a context and additional request options.
//
// See IncreaseStreamRetentionPeriod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) IncreaseStreamRetentionPeriodWithContext(ctx aws.Context, input *IncreaseStreamRetentionPeriodInput, opts ...request.Option) (*IncreaseStreamRetentionPeriodOutput, error) {
	req, out := c.IncreaseStreamRetentionPeriodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListStreams for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListStreams method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListStreamsRequest method.
//    req, resp := client.ListStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams
func (c *Kinesis) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartStreamName"},
			OutputTokens:    []string{"StreamNames[-1]"},
			LimitToken:      "Limit",
			TruncationToken: "HasMoreStreams",
		},
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for Amazon Kinesis.
//
// Lists your Amazon Kinesis streams.
//
// The number of streams may be too large to return from a single call to ListStreams.
// You can limit the number of returned streams using the Limit parameter. If
// you do not specify a value for the Limit parameter, Amazon Kinesis uses the
// default limit, which is currently 10.
//
// You can detect if there are more streams available to list by using the HasMoreStreams
// flag from the returned output. If there are more streams available, you can
// request more streams by using the name of the last stream returned by the
// ListStreams request in the ExclusiveStartStreamName parameter in a subsequent
// request to ListStreams. The group of stream names returned by the subsequent
// request is then added to the list. You can continue this process until all
// the stream names have been collected in the list.
//
// ListStreams has a limit of 5 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation ListStreams for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams
func (c *Kinesis) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamsPages iterates over the pages of a ListStreams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStreams operation.
//    pageNum := 0
//    err := client.ListStreamsPages(params,
//        func(page *ListStreamsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kinesis) ListStreamsPages(input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool) error {
	return c.ListStreamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamsPagesWithContext same as ListStreamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListStreamsPagesWithContext(ctx aws.Context, input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.ListStreamsRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListStreamsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForStream = "ListTagsForStream"

// ListTagsForStreamRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForStreamRequest method.
//    req, resp := client.ListTagsForStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream
func (c *Kinesis) ListTagsForStreamRequest(input *ListTagsForStreamInput) (req *request.Request, output *ListTagsForStreamOutput) {
	op := &request.Operation{
		Name:       opListTagsForStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForStreamInput{}
	}

	output = &ListTagsForStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForStream API operation for Amazon Kinesis.
//
// Lists the tags for the specified Amazon Kinesis stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation ListTagsForStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream
func (c *Kinesis) ListTagsForStream(input *ListTagsForStreamInput) (*ListTagsForStreamOutput, error) {
	req, out := c.ListTagsForStreamRequest(input)
	return out, req.Send()
}

// ListTagsForStreamWithContext is the same as ListTagsForStream with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListTagsForStreamWithContext(ctx aws.Context, input *ListTagsForStreamInput, opts ...request.Option) (*ListTagsForStreamOutput, error) {
	req, out := c.ListTagsForStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMergeShards = "MergeShards"

// MergeShardsRequest generates a "aws/request.Request" representing the
// client's request for the MergeShards operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See MergeShards for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the MergeShards method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the MergeShardsRequest method.
//    req, resp := client.MergeShardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShards
func (c *Kinesis) MergeShardsRequest(input *MergeShardsInput) (req *request.Request, output *MergeShardsOutput) {
	op := &request.Operation{
		Name:       opMergeShards,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MergeShardsInput{}
	}

	output = &MergeShardsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// MergeShards API operation for Amazon Kinesis.
//
// Merges two adjacent shards in an Amazon Kinesis stream and combines them
// into a single shard to reduce the stream's capacity to ingest and transport
// data. Two shards are considered adjacent if the union of the hash key ranges
// for the two shards form a contiguous set with no gaps. For example, if you
// have two shards, one with a hash key range of 276...381 and the other with
// a hash key range of 382...454, then you could merge these two shards into
// a single shard that would have a hash key range of 276...454. After the merge,
// the single child shard receives data for all hash key values covered by the
// two parent shards.
//
// MergeShards is called when there is a need to reduce the overall capacity
// of a stream because of excess capacity that is not being used. You must specify
// the shard to be merged and the adjacent shard for a stream. For more information
// about merging shards, see Merge Two Shards (http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-merge.html)
// in the Amazon Kinesis Streams Developer Guide.
//
// If the stream is in the ACTIVE state, you can call MergeShards. If a stream
// is in the CREATING, UPDATING, or DELETING state, MergeShards returns a ResourceInUseException.
// If the specified stream does not exist, MergeShards returns a ResourceNotFoundException.
//
// You can use DescribeStream to check the state of the stream, which is returned
// in StreamStatus.
//
// MergeShards is an asynchronous operation. Upon receiving a MergeShards request,
// Amazon Kinesis immediately returns a response and sets the StreamStatus to
// UPDATING. After the operation is completed, Amazon Kinesis sets the StreamStatus
// to ACTIVE. Read and write operations continue to work while the stream is
// in the UPDATING state.
//
// You use DescribeStream to determine the shard IDs that are specified in the
// MergeShards request.
//
// If you try to operate on too many streams in parallel using CreateStream,
// DeleteStream, MergeShards or SplitShard, you will receive a LimitExceededException.
//
// MergeShards has limit of 5 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation MergeShards for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShards
func (c *Kinesis) MergeShards(input *MergeShardsInput) (*MergeShardsOutput, error) {
	req, out := c.MergeShardsRequest(input)
	return out, req.Send()
}

// MergeShardsWithContext is the same as MergeShards with the addition of
// the ability to pass a context and additional request options.
//
// See MergeShards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) MergeShardsWithContext(ctx aws.Context, input *MergeShardsInput, opts ...request.Option) (*MergeShardsOutput, error) {
	req, out := c.MergeShardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecord = "PutRecord"

// PutRecordRequest generates a "aws/request.Request" representing the
// client's request for the PutRecord operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRecord for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRecord method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRecordRequest method.
//    req, resp := client.PutRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecord
func (c *Kinesis) PutRecordRequest(input *PutRecordInput) (req *request.Request, output *PutRecordOutput) {
	op := &request.Operation{
		Name:       opPutRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	output = &PutRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecord API operation for Amazon Kinesis.
//
// Writes a single data record into an Amazon Kinesis stream. Call PutRecord
// to send data into the stream for real-time ingestion and subsequent processing,
// one record at a time. Each shard can support writes up to 1,000 records per
// second, up to a maximum data write total of 1 MB per second.
//
// You must specify the name of the stream that captures, stores, and transports
// the data; a partition key; and the data blob itself.
//
// The data blob can be any type of data; for example, a segment from a log
// file, geographic/location data, website clickstream data, and so on.
//
// The partition key is used by Amazon Kinesis to distribute data across shards.
// Amazon Kinesis segregates the data records that belong to a stream into multiple
// shards, using the partition key associated with each data record to determine
// which shard a given data record belongs to.
//
// Partition keys are Unicode strings, with a maximum length limit of 256 characters
// for each key. An MD5 hash function is used to map partition keys to 128-bit
// integer values and to map associated data records to shards using the hash
// key ranges of the shards. You can override hashing the partition key to determine
// the shard by explicitly specifying a hash value using the ExplicitHashKey
// parameter. For more information, see Adding Data to a Stream (http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
// in the Amazon Kinesis Streams Developer Guide.
//
// PutRecord returns the shard ID of where the data record was placed and the
// sequence number that was assigned to the data record.
//
// Sequence numbers increase over time and are specific to a shard within a
// stream, not across all shards within a stream. To guarantee strictly increasing
// ordering, write serially to a shard and use the SequenceNumberForOrdering
// parameter. For more information, see Adding Data to a Stream (http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
// in the Amazon Kinesis Streams Developer Guide.
//
// If a PutRecord request cannot be processed because of insufficient provisioned
// throughput on the shard involved in the request, PutRecord throws ProvisionedThroughputExceededException.
//
// Data records are accessible for only 24 hours from the time that they are
// added to a stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation PutRecord for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The request rate for the stream is too high, or the requested data is too
//   large for the available throughput. Reduce the frequency or size of your
//   requests. For more information, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//   in the Amazon Kinesis Streams Developer Guide, and Error Retries and Exponential
//   Backoff in AWS (http://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//   in the AWS General Reference.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecord
func (c *Kinesis) PutRecord(input *PutRecordInput) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	return out, req.Send()
}

// PutRecordWithContext is the same as PutRecord with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) PutRecordWithContext(ctx aws.Context, input *PutRecordInput, opts ...request.Option) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecords = "PutRecords"

// PutRecordsRequest generates a "aws/request.Request" representing the
// client's request for the PutRecords operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRecords for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRecords method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRecordsRequest method.
//    req, resp := client.PutRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecords
func (c *Kinesis) PutRecordsRequest(input *PutRecordsInput) (req *request.Request, output *PutRecordsOutput) {
	op := &request.Operation{
		Name:       opPutRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordsInput{}
	}

	output = &PutRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecords API operation for Amazon Kinesis.
//
// Writes multiple data records into an Amazon Kinesis stream in a single call
// (also referred to as a PutRecords request). Use this operation to send data
// into the stream for data ingestion and processing.
//
// Each PutRecords request can support up to 500 records. Each record in the
// request can be as large as 1 MB, up to a limit of 5 MB for the entire request,
// including partition keys. Each shard can support writes up to 1,000 records
// per second, up to a maximum data write total of 1 MB per second.
//
// You must specify the name of the stream that captures, stores, and transports
// the data; and an array of request Records, with each record in the array
// requiring a partition key and data blob. The record size limit applies to
// the total size of the partition key and data blob.
//
// The data blob can be any type of data; for example, a segment from a log
// file, geographic/location data, website clickstream data, and so on.
//
// The partition key is used by Amazon Kinesis as input to a hash function that
// maps the partition key and associated data to a specific shard. An MD5 hash
// function is used to map partition keys to 128-bit integer values and to map
// associated data records to shards. As a result of this hashing mechanism,
// all data records with the same partition key map to the same shard within
// the stream. For more information, see Adding Data to a Stream (http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
// in the Amazon Kinesis Streams Developer Guide.
//
// Each record in the Records array may include an optional parameter, ExplicitHashKey,
// which overrides the partition key to shard mapping. This parameter allows
// a data producer to determine explicitly the shard where the record is stored.
// For more information, see Adding Multiple Records with PutRecords (http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-putrecords)
// in the Amazon Kinesis Streams Developer Guide.
//
// The PutRecords response includes an array of response Records. Each record
// in the response array directly correlates with a record in the request array
// using natural ordering, from the top to the bottom of the request and response.
// The response Records array always includes the same number of records as
// the request array.
//
// The response Records array includes both successfully and unsuccessfully
// processed records. Amazon Kinesis attempts to process all records in each
// PutRecords request. A single record failure does not stop the processing
// of subsequent records.
//
// A successfully-processed record includes ShardId and SequenceNumber values.
// The ShardId parameter identifies the shard in the stream where the record
// is stored. The SequenceNumber parameter is an identifier assigned to the
// put record, unique to all records in the stream.
//
// An unsuccessfully-processed record includes ErrorCode and ErrorMessage values.
// ErrorCode reflects the type of error and can be one of the following values:
// ProvisionedThroughputExceededException or InternalFailure. ErrorMessage provides
// more detailed information about the ProvisionedThroughputExceededException
// exception including the account ID, stream name, and shard ID of the record
// that was throttled. For more information about partially successful responses,
// see Adding Multiple Records with PutRecords (http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-add-data-to-stream.html#kinesis-using-sdk-java-putrecords)
// in the Amazon Kinesis Streams Developer Guide.
//
// By default, data records are accessible for only 24 hours from the time that
// they are added to an Amazon Kinesis stream. This retention period can be
// modified using the DecreaseStreamRetentionPeriod and IncreaseStreamRetentionPeriod
// operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation PutRecords for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The request rate for the stream is too high, or the requested data is too
//   large for the available throughput. Reduce the frequency or size of your
//   requests. For more information, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//   in the Amazon Kinesis Streams Developer Guide, and Error Retries and Exponential
//   Backoff in AWS (http://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//   in the AWS General Reference.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecords
func (c *Kinesis) PutRecords(input *PutRecordsInput) (*PutRecordsOutput, error) {
	req, out := c.PutRecordsRequest(input)
	return out, req.Send()
}

// PutRecordsWithContext is the same as PutRecords with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) PutRecordsWithContext(ctx aws.Context, input *PutRecordsInput, opts ...request.Option) (*PutRecordsOutput, error) {
	req, out := c.PutRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromStream = "RemoveTagsFromStream"

// RemoveTagsFromStreamRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromStream operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromStream for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromStream method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromStreamRequest method.
//    req, resp := client.RemoveTagsFromStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStream
func (c *Kinesis) RemoveTagsFromStreamRequest(input *RemoveTagsFromStreamInput) (req *request.Request, output *RemoveTagsFromStreamOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromStreamInput{}
	}

	output = &RemoveTagsFromStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromStream API operation for Amazon Kinesis.
//
// Removes tags from the specified Amazon Kinesis stream. Removed tags are deleted
// and cannot be recovered after this operation successfully completes.
//
// If you specify a tag that does not exist, it is ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation RemoveTagsFromStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStream
func (c *Kinesis) RemoveTagsFromStream(input *RemoveTagsFromStreamInput) (*RemoveTagsFromStreamOutput, error) {
	req, out := c.RemoveTagsFromStreamRequest(input)
	return out, req.Send()
}

// RemoveTagsFromStreamWithContext is the same as RemoveTagsFromStream with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) RemoveTagsFromStreamWithContext(ctx aws.Context, input *RemoveTagsFromStreamInput, opts ...request.Option) (*RemoveTagsFromStreamOutput, error) {
	req, out := c.RemoveTagsFromStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSplitShard = "SplitShard"

// SplitShardRequest generates a "aws/request.Request" representing the
// client's request for the SplitShard operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SplitShard for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SplitShard method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SplitShardRequest method.
//    req, resp := client.SplitShardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShard
func (c *Kinesis) SplitShardRequest(input *SplitShardInput) (req *request.Request, output *SplitShardOutput) {
	op := &request.Operation{
		Name:       opSplitShard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SplitShardInput{}
	}

	output = &SplitShardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SplitShard API operation for Amazon Kinesis.
//
// Splits a shard into two new shards in the Amazon Kinesis stream to increase
// the stream's capacity to ingest and transport data. SplitShard is called
// when there is a need to increase the overall capacity of a stream because
// of an expected increase in the volume of data records being ingested.
//
// You can also use SplitShard when a shard appears to be approaching its maximum
// utilization; for example, the producers sending data into the specific shard
// are suddenly sending more than previously anticipated. You can also call
// SplitShard to increase stream capacity, so that more Amazon Kinesis applications
// can simultaneously read data from the stream for real-time processing.
//
// You must specify the shard to be split and the new hash key, which is the
// position in the shard where the shard gets split in two. In many cases, the
// new hash key might simply be the average of the beginning and ending hash
// key, but it can be any hash key value in the range being mapped into the
// shard. For more information about splitting shards, see Split a Shard (http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-split.html)
// in the Amazon Kinesis Streams Developer Guide.
//
// You can use DescribeStream to determine the shard ID and hash key values
// for the ShardToSplit and NewStartingHashKey parameters that are specified
// in the SplitShard request.
//
// SplitShard is an asynchronous operation. Upon receiving a SplitShard request,
// Amazon Kinesis immediately returns a response and sets the stream status
// to UPDATING. After the operation is completed, Amazon Kinesis sets the stream
// status to ACTIVE. Read and write operations continue to work while the stream
// is in the UPDATING state.
//
// You can use DescribeStream to check the status of the stream, which is returned
// in StreamStatus. If the stream is in the ACTIVE state, you can call SplitShard.
// If a stream is in CREATING or UPDATING or DELETING states, DescribeStream
// returns a ResourceInUseException.
//
// If the specified stream does not exist, DescribeStream returns a ResourceNotFoundException.
// If you try to create more shards than are authorized for your account, you
// receive a LimitExceededException.
//
// For the default shard limit for an AWS account, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Streams Developer Guide. If you need to increase this
// limit, contact AWS Support (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
//
// If you try to operate on too many streams simultaneously using CreateStream,
// DeleteStream, MergeShards, and/or SplitShard, you receive a LimitExceededException.
//
// SplitShard has limit of 5 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation SplitShard for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShard
func (c *Kinesis) SplitShard(input *SplitShardInput) (*SplitShardOutput, error) {
	req, out := c.SplitShardRequest(input)
	return out, req.Send()
}

// SplitShardWithContext is the same as SplitShard with the addition of
// the ability to pass a context and additional request options.
//
// See SplitShard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) SplitShardWithContext(ctx aws.Context, input *SplitShardInput, opts ...request.Option) (*SplitShardOutput, error) {
	req, out := c.SplitShardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateShardCount = "UpdateShardCount"

// UpdateShardCountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateShardCount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateShardCount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateShardCount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateShardCountRequest method.
//    req, resp := client.UpdateShardCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount
func (c *Kinesis) UpdateShardCountRequest(input *UpdateShardCountInput) (req *request.Request, output *UpdateShardCountOutput) {
	op := &request.Operation{
		Name:       opUpdateShardCount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateShardCountInput{}
	}

	output = &UpdateShardCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateShardCount API operation for Amazon Kinesis.
//
// Updates the shard count of the specified stream to the specified number of
// shards.
//
// Updating the shard count is an asynchronous operation. Upon receiving the
// request, Amazon Kinesis returns immediately and sets the status of the stream
// to UPDATING. After the update is complete, Amazon Kinesis sets the status
// of the stream back to ACTIVE. Depending on the size of the stream, the scaling
// action could take a few minutes to complete. You can continue to read and
// write data to your stream while its status is UPDATING.
//
// To update the shard count, Amazon Kinesis performs splits and merges and
// individual shards. This can cause short-lived shards to be created, in addition
// to the final shards. We recommend that you double or halve the shard count,
// as this results in the fewest number of splits or merges.
//
// This operation has a rate limit of twice per rolling 24 hour period. You
// cannot scale above double your current shard count, scale below half your
// current shard count, or exceed the shard limits for your account.
//
// For the default limits for an AWS account, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Streams Developer Guide. If you need to increase a
// limit, contact AWS Support (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation UpdateShardCount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used. For more information, see the returned message.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed (5).
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is not available for this operation. For successful operation,
//   the resource needs to be in the ACTIVE state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource could not be found. The stream might not be specified
//   correctly.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount
func (c *Kinesis) UpdateShardCount(input *UpdateShardCountInput) (*UpdateShardCountOutput, error) {
	req, out := c.UpdateShardCountRequest(input)
	return out, req.Send()
}

// UpdateShardCountWithContext is the same as UpdateShardCount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateShardCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) UpdateShardCountWithContext(ctx aws.Context, input *UpdateShardCountInput, opts ...request.Option) (*UpdateShardCountOutput, error) {
	req, out := c.UpdateShardCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input for AddTagsToStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStreamInput
type AddTagsToStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The set of key-value pairs to use to create the tags.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s AddTagsToStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToStreamInput"}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamName sets the StreamName field's value.
func (s *AddTagsToStreamInput) SetStreamName(v string) *AddTagsToStreamInput {
	s.StreamName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToStreamInput) SetTags(v map[string]*string) *AddTagsToStreamInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStreamOutput
type AddTagsToStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToStreamOutput) GoString() string {
	return s.String()
}

// Represents the input for CreateStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStreamInput
type CreateStreamInput struct {
	_ struct{} `type:"structure"`

	// The number of shards that the stream will use. The throughput of the stream
	// is a function of the number of shards; more shards are required for greater
	// provisioned throughput.
	//
	// DefaultShardLimit;
	//
	// ShardCount is a required field
	ShardCount *int64 `min:"1" type:"integer" required:"true"`

	// A name to identify the stream. The stream name is scoped to the AWS account
	// used by the application that creates the stream. It is also scoped by region.
	// That is, two streams in two different AWS accounts can have the same name,
	// and two streams in the same AWS account but in two different regions can
	// have the same name.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamInput"}
	if s.ShardCount == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardCount"))
	}
	if s.ShardCount != nil && *s.ShardCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ShardCount", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardCount sets the ShardCount field's value.
func (s *CreateStreamInput) SetShardCount(v int64) *CreateStreamInput {
	s.ShardCount = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *CreateStreamInput) SetStreamName(v string) *CreateStreamInput {
	s.StreamName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStreamOutput
type CreateStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamOutput) GoString() string {
	return s.String()
}

// Represents the input for DecreaseStreamRetentionPeriod.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriodInput
type DecreaseStreamRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The new retention period of the stream, in hours. Must be less than the current
	// retention period.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `min:"1" type:"integer" required:"true"`

	// The name of the stream to modify.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DecreaseStreamRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseStreamRetentionPeriodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecreaseStreamRetentionPeriodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecreaseStreamRetentionPeriodInput"}
	if s.RetentionPeriodHours == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodHours"))
	}
	if s.RetentionPeriodHours != nil && *s.RetentionPeriodHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionPeriodHours", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriodHours sets the RetentionPeriodHours field's value.
func (s *DecreaseStreamRetentionPeriodInput) SetRetentionPeriodHours(v int64) *DecreaseStreamRetentionPeriodInput {
	s.RetentionPeriodHours = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DecreaseStreamRetentionPeriodInput) SetStreamName(v string) *DecreaseStreamRetentionPeriodInput {
	s.StreamName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriodOutput
type DecreaseStreamRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DecreaseStreamRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseStreamRetentionPeriodOutput) GoString() string {
	return s.String()
}

// Represents the input for DeleteStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStreamInput
type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream to delete.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamInput"}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamName sets the StreamName field's value.
func (s *DeleteStreamInput) SetStreamName(v string) *DeleteStreamInput {
	s.StreamName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStreamOutput
type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimitsInput
type DescribeLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLimitsInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimitsOutput
type DescribeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The number of open shards.
	//
	// OpenShardCount is a required field
	OpenShardCount *int64 `type:"integer" required:"true"`

	// The maximum number of shards.
	//
	// ShardLimit is a required field
	ShardLimit *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DescribeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLimitsOutput) GoString() string {
	return s.String()
}

// SetOpenShardCount sets the OpenShardCount field's value.
func (s *DescribeLimitsOutput) SetOpenShardCount(v int64) *DescribeLimitsOutput {
	s.OpenShardCount = &v
	return s
}

// SetShardLimit sets the ShardLimit field's value.
func (s *DescribeLimitsOutput) SetShardLimit(v int64) *DescribeLimitsOutput {
	s.ShardLimit = &v
	return s
}

// Represents the input for DescribeStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamInput
type DescribeStreamInput struct {
	_ struct{} `type:"structure"`

	// The shard ID of the shard to start with.
	ExclusiveStartShardId *string `min:"1" type:"string"`

	// The maximum number of shards to return in a single call. The default value
	// is 100. If you specify a value greater than 100, at most 100 shards are returned.
	Limit *int64 `min:"1" type:"integer"`

	// The name of the stream to describe.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamInput"}
	if s.ExclusiveStartShardId != nil && len(*s.ExclusiveStartShardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartShardId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartShardId sets the ExclusiveStartShardId field's value.
func (s *DescribeStreamInput) SetExclusiveStartShardId(v string) *DescribeStreamInput {
	s.ExclusiveStartShardId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeStreamInput) SetLimit(v int64) *DescribeStreamInput {
	s.Limit = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DescribeStreamInput) SetStreamName(v string) *DescribeStreamInput {
	s.StreamName = &v
	return s
}

// Represents the output for DescribeStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamOutput
type DescribeStreamOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the stream, the stream ARN, an array of shard objects
	// that comprise the stream, and whether there are more shards available.
	//
	// StreamDescription is a required field
	StreamDescription *StreamDescription `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamOutput) GoString() string {
	return s.String()
}

// SetStreamDescription sets the StreamDescription field's value.
func (s *DescribeStreamOutput) SetStreamDescription(v *StreamDescription) *DescribeStreamOutput {
	s.StreamDescription = v
	return s
}

// Represents the input for DisableEnhancedMonitoring.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoringInput
type DisableEnhancedMonitoringInput struct {
	_ struct{} `type:"structure"`

	// List of shard-level metrics to disable.
	//
	// The following are the valid shard-level metrics. The value "ALL" disables
	// every metric.
	//
	//    * IncomingBytes
	//
	//    * IncomingRecords
	//
	//    * OutgoingBytes
	//
	//    * OutgoingRecords
	//
	//    * WriteProvisionedThroughputExceeded
	//
	//    * ReadProvisionedThroughputExceeded
	//
	//    * IteratorAgeMilliseconds
	//
	//    * ALL
	//
	// For more information, see Monitoring the Amazon Kinesis Streams Service with
	// Amazon CloudWatch (http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
	// in the Amazon Kinesis Streams Developer Guide.
	//
	// ShardLevelMetrics is a required field
	ShardLevelMetrics []*string `min:"1" type:"list" required:"true"`

	// The name of the Amazon Kinesis stream for which to disable enhanced monitoring.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableEnhancedMonitoringInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableEnhancedMonitoringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableEnhancedMonitoringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableEnhancedMonitoringInput"}
	if s.ShardLevelMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardLevelMetrics"))
	}
	if s.ShardLevelMetrics != nil && len(s.ShardLevelMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardLevelMetrics", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardLevelMetrics sets the ShardLevelMetrics field's value.
func (s *DisableEnhancedMonitoringInput) SetShardLevelMetrics(v []*string) *DisableEnhancedMonitoringInput {
	s.ShardLevelMetrics = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DisableEnhancedMonitoringInput) SetStreamName(v string) *DisableEnhancedMonitoringInput {
	s.StreamName = &v
	return s
}

// Represents the input for EnableEnhancedMonitoring.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoringInput
type EnableEnhancedMonitoringInput struct {
	_ struct{} `type:"structure"`

	// List of shard-level metrics to enable.
	//
	// The following are the valid shard-level metrics. The value "ALL" enables
	// every metric.
	//
	//    * IncomingBytes
	//
	//    * IncomingRecords
	//
	//    * OutgoingBytes
	//
	//    * OutgoingRecords
	//
	//    * WriteProvisionedThroughputExceeded
	//
	//    * ReadProvisionedThroughputExceeded
	//
	//    * IteratorAgeMilliseconds
	//
	//    * ALL
	//
	// For more information, see Monitoring the Amazon Kinesis Streams Service with
	// Amazon CloudWatch (http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
	// in the Amazon Kinesis Streams Developer Guide.
	//
	// ShardLevelMetrics is a required field
	ShardLevelMetrics []*string `min:"1" type:"list" required:"true"`

	// The name of the stream for which to enable enhanced monitoring.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableEnhancedMonitoringInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableEnhancedMonitoringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableEnhancedMonitoringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableEnhancedMonitoringInput"}
	if s.ShardLevelMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardLevelMetrics"))
	}
	if s.ShardLevelMetrics != nil && len(s.ShardLevelMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardLevelMetrics", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardLevelMetrics sets the ShardLevelMetrics field's value.
func (s *EnableEnhancedMonitoringInput) SetShardLevelMetrics(v []*string) *EnableEnhancedMonitoringInput {
	s.ShardLevelMetrics = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *EnableEnhancedMonitoringInput) SetStreamName(v string) *EnableEnhancedMonitoringInput {
	s.StreamName = &v
	return s
}

// Represents enhanced metrics types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnhancedMetrics
type EnhancedMetrics struct {
	_ struct{} `type:"structure"`

	// List of shard-level metrics.
	//
	// The following are the valid shard-level metrics. The value "ALL" enhances
	// every metric.
	//
	//    * IncomingBytes
	//
	//    * IncomingRecords
	//
	//    * OutgoingBytes
	//
	//    * OutgoingRecords
	//
	//    * WriteProvisionedThroughputExceeded
	//
	//    * ReadProvisionedThroughputExceeded
	//
	//    * IteratorAgeMilliseconds
	//
	//    * ALL
	//
	// For more information, see Monitoring the Amazon Kinesis Streams Service with
	// Amazon CloudWatch (http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
	// in the Amazon Kinesis Streams Developer Guide.
	ShardLevelMetrics []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s EnhancedMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnhancedMetrics) GoString() string {
	return s.String()
}

// SetShardLevelMetrics sets the ShardLevelMetrics field's value.
func (s *EnhancedMetrics) SetShardLevelMetrics(v []*string) *EnhancedMetrics {
	s.ShardLevelMetrics = v
	return s
}

// Represents the output for EnableEnhancedMonitoring and DisableEnhancedMonitoring.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnhancedMonitoringOutput
type EnhancedMonitoringOutput struct {
	_ struct{} `type:"structure"`

	// Represents the current state of the metrics that are in the enhanced state
	// before the operation.
	CurrentShardLevelMetrics []*string `min:"1" type:"list"`

	// Represents the list of all the metrics that would be in the enhanced state
	// after the operation.
	DesiredShardLevelMetrics []*string `min:"1" type:"list"`

	// The name of the Amazon Kinesis stream.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnhancedMonitoringOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnhancedMonitoringOutput) GoString() string {
	return s.String()
}

// SetCurrentShardLevelMetrics sets the CurrentShardLevelMetrics field's value.
func (s *EnhancedMonitoringOutput) SetCurrentShardLevelMetrics(v []*string) *EnhancedMonitoringOutput {
	s.CurrentShardLevelMetrics = v
	return s
}

// SetDesiredShardLevelMetrics sets the DesiredShardLevelMetrics field's value.
func (s *EnhancedMonitoringOutput) SetDesiredShardLevelMetrics(v []*string) *EnhancedMonitoringOutput {
	s.DesiredShardLevelMetrics = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *EnhancedMonitoringOutput) SetStreamName(v string) *EnhancedMonitoringOutput {
	s.StreamName = &v
	return s
}

// Represents the input for GetRecords.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecordsInput
type GetRecordsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to return. Specify a value of up to 10,000.
	// If you specify a value that is greater than 10,000, GetRecords throws InvalidArgumentException.
	Limit *int64 `min:"1" type:"integer"`

	// The position in the shard from which you want to start sequentially reading
	// data records. A shard iterator specifies this position using the sequence
	// number of a data record in the shard.
	//
	// ShardIterator is a required field
	ShardIterator *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecordsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.ShardIterator == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardIterator"))
	}
	if s.ShardIterator != nil && len(*s.ShardIterator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardIterator", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetRecordsInput) SetLimit(v int64) *GetRecordsInput {
	s.Limit = &v
	return s
}

// SetShardIterator sets the ShardIterator field's value.
func (s *GetRecordsInput) SetShardIterator(v string) *GetRecordsInput {
	s.ShardIterator = &v
	return s
}

// Represents the output for GetRecords.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecordsOutput
type GetRecordsOutput struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds the GetRecords response is from the tip of the
	// stream, indicating how far behind current time the consumer is. A value of
	// zero indicates record processing is caught up, and there are no new records
	// to process at this moment.
	MillisBehindLatest *int64 `type:"long"`

	// The next position in the shard from which to start sequentially reading data
	// records. If set to null, the shard has been closed and the requested iterator
	// will not return any more data.
	NextShardIterator *string `min:"1" type:"string"`

	// The data records retrieved from the shard.
	//
	// Records is a required field
	Records []*Record `type:"list" required:"true"`
}

// String returns the string representation
func (s GetRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecordsOutput) GoString() string {
	return s.String()
}

// SetMillisBehindLatest sets the MillisBehindLatest field's value.
func (s *GetRecordsOutput) SetMillisBehindLatest(v int64) *GetRecordsOutput {
	s.MillisBehindLatest = &v
	return s
}

// SetNextShardIterator sets the NextShardIterator field's value.
func (s *GetRecordsOutput) SetNextShardIterator(v string) *GetRecordsOutput {
	s.NextShardIterator = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *GetRecordsOutput) SetRecords(v []*Record) *GetRecordsOutput {
	s.Records = v
	return s
}

// Represents the input for GetShardIterator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIteratorInput
type GetShardIteratorInput struct {
	_ struct{} `type:"structure"`

	// The shard ID of the Amazon Kinesis shard to get the iterator for.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`

	// Determines how the shard iterator is used to start reading data records from
	// the shard.
	//
	// The following are the valid Amazon Kinesis shard iterator types:
	//
	//    * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific
	//    sequence number, provided in the value StartingSequenceNumber.
	//
	//    * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted
	//    by a specific sequence number, provided in the value StartingSequenceNumber.
	//
	//    * AT_TIMESTAMP - Start reading from the position denoted by a specific
	//    timestamp, provided in the value Timestamp.
	//
	//    * TRIM_HORIZON - Start reading at the last untrimmed record in the shard
	//    in the system, which is the oldest data record in the shard.
	//
	//    * LATEST - Start reading just after the most recent record in the shard,
	//    so that you always read the most recent data in the shard.
	//
	// ShardIteratorType is a required field
	ShardIteratorType *string `type:"string" required:"true" enum:"ShardIteratorType"`

	// The sequence number of the data record in the shard from which to start reading.
	// Used with shard iterator type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
	StartingSequenceNumber *string `type:"string"`

	// The name of the Amazon Kinesis stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The timestamp of the data record from which to start reading. Used with shard
	// iterator type AT_TIMESTAMP. A timestamp is the Unix epoch date with precision
	// in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480.
	// If a record with this exact timestamp does not exist, the iterator returned
	// is for the next (later) record. If the timestamp is older than the current
	// trim horizon, the iterator returned is for the oldest untrimmed data record
	// (TRIM_HORIZON).
	Timestamp *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s GetShardIteratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetShardIteratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetShardIteratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetShardIteratorInput"}
	if s.ShardId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardId"))
	}
	if s.ShardId != nil && len(*s.ShardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardId", 1))
	}
	if s.ShardIteratorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardIteratorType"))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardId sets the ShardId field's value.
func (s *GetShardIteratorInput) SetShardId(v string) *GetShardIteratorInput {
	s.ShardId = &v
	return s
}

// SetShardIteratorType sets the ShardIteratorType field's value.
func (s *GetShardIteratorInput) SetShardIteratorType(v string) *GetShardIteratorInput {
	s.ShardIteratorType = &v
	return s
}

// SetStartingSequenceNumber sets the StartingSequenceNumber field's value.
func (s *GetShardIteratorInput) SetStartingSequenceNumber(v string) *GetShardIteratorInput {
	s.StartingSequenceNumber = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *GetShardIteratorInput) SetStreamName(v string) *GetShardIteratorInput {
	s.StreamName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *GetShardIteratorInput) SetTimestamp(v time.Time) *GetShardIteratorInput {
	s.Timestamp = &v
	return s
}

// Represents the output for GetShardIterator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIteratorOutput
type GetShardIteratorOutput struct {
	_ struct{} `type:"structure"`

	// The position in the shard from which to start reading data records sequentially.
	// A shard iterator specifies this position using the sequence number of a data
	// record in a shard.
	ShardIterator *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetShardIteratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetShardIteratorOutput) GoString() string {
	return s.String()
}

// SetShardIterator sets the ShardIterator field's value.
func (s *GetShardIteratorOutput) SetShardIterator(v string) *GetShardIteratorOutput {
	s.ShardIterator = &v
	return s
}

// The range of possible hash key values for the shard, which is a set of ordered
// contiguous positive integers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/HashKeyRange
type HashKeyRange struct {
	_ struct{} `type:"structure"`

	// The ending hash key of the hash key range.
	//
	// EndingHashKey is a required field
	EndingHashKey *string `type:"string" required:"true"`

	// The starting hash key of the hash key range.
	//
	// StartingHashKey is a required field
	StartingHashKey *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HashKeyRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HashKeyRange) GoString() string {
	return s.String()
}

// SetEndingHashKey sets the EndingHashKey field's value.
func (s *HashKeyRange) SetEndingHashKey(v string) *HashKeyRange {
	s.EndingHashKey = &v
	return s
}

// SetStartingHashKey sets the StartingHashKey field's value.
func (s *HashKeyRange) SetStartingHashKey(v string) *HashKeyRange {
	s.StartingHashKey = &v
	return s
}

// Represents the input for IncreaseStreamRetentionPeriod.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriodInput
type IncreaseStreamRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The new retention period of the stream, in hours. Must be more than the current
	// retention period.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `min:"1" type:"integer" required:"true"`

	// The name of the stream to modify.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IncreaseStreamRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseStreamRetentionPeriodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseStreamRetentionPeriodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncreaseStreamRetentionPeriodInput"}
	if s.RetentionPeriodHours == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodHours"))
	}
	if s.RetentionPeriodHours != nil && *s.RetentionPeriodHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionPeriodHours", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriodHours sets the RetentionPeriodHours field's value.
func (s *IncreaseStreamRetentionPeriodInput) SetRetentionPeriodHours(v int64) *IncreaseStreamRetentionPeriodInput {
	s.RetentionPeriodHours = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *IncreaseStreamRetentionPeriodInput) SetStreamName(v string) *IncreaseStreamRetentionPeriodInput {
	s.StreamName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriodOutput
type IncreaseStreamRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s IncreaseStreamRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseStreamRetentionPeriodOutput) GoString() string {
	return s.String()
}

// Represents the input for ListStreams.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamsInput
type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream to start the list with.
	ExclusiveStartStreamName *string `min:"1" type:"string"`

	// The maximum number of streams to list.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.ExclusiveStartStreamName != nil && len(*s.ExclusiveStartStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartStreamName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartStreamName sets the ExclusiveStartStreamName field's value.
func (s *ListStreamsInput) SetExclusiveStartStreamName(v string) *ListStreamsInput {
	s.ExclusiveStartStreamName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListStreamsInput) SetLimit(v int64) *ListStreamsInput {
	s.Limit = &v
	return s
}

// Represents the output for ListStreams.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamsOutput
type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// If set to true, there are more streams available to list.
	//
	// HasMoreStreams is a required field
	HasMoreStreams *bool `type:"boolean" required:"true"`

	// The names of the streams that are associated with the AWS account making
	// the ListStreams request.
	//
	// StreamNames is a required field
	StreamNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// SetHasMoreStreams sets the HasMoreStreams field's value.
func (s *ListStreamsOutput) SetHasMoreStreams(v bool) *ListStreamsOutput {
	s.HasMoreStreams = &v
	return s
}

// SetStreamNames sets the StreamNames field's value.
func (s *ListStreamsOutput) SetStreamNames(v []*string) *ListStreamsOutput {
	s.StreamNames = v
	return s
}

// Represents the input for ListTagsForStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStreamInput
type ListTagsForStreamInput struct {
	_ struct{} `type:"structure"`

	// The key to use as the starting point for the list of tags. If this parameter
	// is set, ListTagsForStream gets all tags that occur after ExclusiveStartTagKey.
	ExclusiveStartTagKey *string `min:"1" type:"string"`

	// The number of tags to return. If this number is less than the total number
	// of tags associated with the stream, HasMoreTags is set to true. To list additional
	// tags, set ExclusiveStartTagKey to the last key in the response.
	Limit *int64 `min:"1" type:"integer"`

	// The name of the stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForStreamInput"}
	if s.ExclusiveStartTagKey != nil && len(*s.ExclusiveStartTagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartTagKey", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartTagKey sets the ExclusiveStartTagKey field's value.
func (s *ListTagsForStreamInput) SetExclusiveStartTagKey(v string) *ListTagsForStreamInput {
	s.ExclusiveStartTagKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForStreamInput) SetLimit(v int64) *ListTagsForStreamInput {
	s.Limit = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *ListTagsForStreamInput) SetStreamName(v string) *ListTagsForStreamInput {
	s.StreamName = &v
	return s
}

// Represents the output for ListTagsForStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStreamOutput
type ListTagsForStreamOutput struct {
	_ struct{} `type:"structure"`

	// If set to true, more tags are available. To request additional tags, set
	// ExclusiveStartTagKey to the key of the last tag returned.
	//
	// HasMoreTags is a required field
	HasMoreTags *bool `type:"boolean" required:"true"`

	// A list of tags associated with StreamName, starting with the first tag after
	// ExclusiveStartTagKey and up to the specified Limit.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForStreamOutput) GoString() string {
	return s.String()
}

// SetHasMoreTags sets the HasMoreTags field's value.
func (s *ListTagsForStreamOutput) SetHasMoreTags(v bool) *ListTagsForStreamOutput {
	s.HasMoreTags = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForStreamOutput) SetTags(v []*Tag) *ListTagsForStreamOutput {
	s.Tags = v
	return s
}

// Represents the input for MergeShards.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShardsInput
type MergeShardsInput struct {
	_ struct{} `type:"structure"`

	// The shard ID of the adjacent shard for the merge.
	//
	// AdjacentShardToMerge is a required field
	AdjacentShardToMerge *string `min:"1" type:"string" required:"true"`

	// The shard ID of the shard to combine with the adjacent shard for the merge.
	//
	// ShardToMerge is a required field
	ShardToMerge *string `min:"1" type:"string" required:"true"`

	// The name of the stream for the merge.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MergeShardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeShardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergeShardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MergeShardsInput"}
	if s.AdjacentShardToMerge == nil {
		invalidParams.Add(request.NewErrParamRequired("AdjacentShardToMerge"))
	}
	if s.AdjacentShardToMerge != nil && len(*s.AdjacentShardToMerge) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdjacentShardToMerge", 1))
	}
	if s.ShardToMerge == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardToMerge"))
	}
	if s.ShardToMerge != nil && len(*s.ShardToMerge) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardToMerge", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdjacentShardToMerge sets the AdjacentShardToMerge field's value.
func (s *MergeShardsInput) SetAdjacentShardToMerge(v string) *MergeShardsInput {
	s.AdjacentShardToMerge = &v
	return s
}

// SetShardToMerge sets the ShardToMerge field's value.
func (s *MergeShardsInput) SetShardToMerge(v string) *MergeShardsInput {
	s.ShardToMerge = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *MergeShardsInput) SetStreamName(v string) *MergeShardsInput {
	s.StreamName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShardsOutput
type MergeShardsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MergeShardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeShardsOutput) GoString() string {
	return s.String()
}

// Represents the input for PutRecord.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecordInput
type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The data blob to put into the record, which is base64-encoded when the blob
	// is serialized. When the data blob (the payload before base64-encoding) is
	// added to the partition key size, the total size must not exceed the maximum
	// record size (1 MB).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`

	// The hash value used to explicitly determine the shard the data record is
	// assigned to by overriding the partition key hash.
	ExplicitHashKey *string `type:"string"`

	// Determines which shard in the stream the data record is assigned to. Partition
	// keys are Unicode strings with a maximum length limit of 256 characters for
	// each key. Amazon Kinesis uses the partition key as input to a hash function
	// that maps the partition key and associated data to a specific shard. Specifically,
	// an MD5 hash function is used to map partition keys to 128-bit integer values
	// and to map associated data records to shards. As a result of this hashing
	// mechanism, all data records with the same partition key map to the same shard
	// within the stream.
	//
	// PartitionKey is a required field
	PartitionKey *string `min:"1" type:"string" required:"true"`

	// Guarantees strictly increasing sequence numbers, for puts from the same client
	// and to the same partition key. Usage: set the SequenceNumberForOrdering of
	// record n to the sequence number of record n-1 (as returned in the result
	// when putting record n-1). If this parameter is not set, records will be coarsely
	// ordered based on arrival time.
	SequenceNumberForOrdering *string `type:"string"`

	// The name of the stream to put the data record into.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordInput"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.PartitionKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKey"))
	}
	if s.PartitionKey != nil && len(*s.PartitionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionKey", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *PutRecordInput) SetData(v []byte) *PutRecordInput {
	s.Data = v
	return s
}

// SetExplicitHashKey sets the ExplicitHashKey field's value.
func (s *PutRecordInput) SetExplicitHashKey(v string) *PutRecordInput {
	s.ExplicitHashKey = &v
	return s
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *PutRecordInput) SetPartitionKey(v string) *PutRecordInput {
	s.PartitionKey = &v
	return s
}

// SetSequenceNumberForOrdering sets the SequenceNumberForOrdering field's value.
func (s *PutRecordInput) SetSequenceNumberForOrdering(v string) *PutRecordInput {
	s.SequenceNumberForOrdering = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *PutRecordInput) SetStreamName(v string) *PutRecordInput {
	s.StreamName = &v
	return s
}

// Represents the output for PutRecord.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecordOutput
type PutRecordOutput struct {
	_ struct{} `type:"structure"`

	// The sequence number identifier that was assigned to the put data record.
	// The sequence number for the record is unique across all records in the stream.
	// A sequence number is the identifier associated with every record put into
	// the stream.
	//
	// SequenceNumber is a required field
	SequenceNumber *string `type:"string" required:"true"`

	// The shard ID of the shard where the data record was placed.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordOutput) GoString() string {
	return s.String()
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *PutRecordOutput) SetSequenceNumber(v string) *PutRecordOutput {
	s.SequenceNumber = &v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *PutRecordOutput) SetShardId(v string) *PutRecordOutput {
	s.ShardId = &v
	return s
}

// A PutRecords request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecordsInput
type PutRecordsInput struct {
	_ struct{} `type:"structure"`

	// The records associated with the request.
	//
	// Records is a required field
	Records []*PutRecordsRequestEntry `min:"1" type:"list" required:"true"`

	// The stream name associated with the request.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordsInput"}
	if s.Records == nil {
		invalidParams.Add(request.NewErrParamRequired("Records"))
	}
	if s.Records != nil && len(s.Records) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Records", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.Records != nil {
		for i, v := range s.Records {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Records", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecords sets the Records field's value.
func (s *PutRecordsInput) SetRecords(v []*PutRecordsRequestEntry) *PutRecordsInput {
	s.Records = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *PutRecordsInput) SetStreamName(v string) *PutRecordsInput {
	s.StreamName = &v
	return s
}

// PutRecords results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecordsOutput
type PutRecordsOutput struct {
	_ struct{} `type:"structure"`

	// The number of unsuccessfully processed records in a PutRecords request.
	FailedRecordCount *int64 `min:"1" type:"integer"`

	// An array of successfully and unsuccessfully processed record results, correlated
	// with the request by natural ordering. A record that is successfully added
	// to a stream includes SequenceNumber and ShardId in the result. A record that
	// fails to be added to a stream includes ErrorCode and ErrorMessage in the
	// result.
	//
	// Records is a required field
	Records []*PutRecordsResultEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordsOutput) GoString() string {
	return s.String()
}

// SetFailedRecordCount sets the FailedRecordCount field's value.
func (s *PutRecordsOutput) SetFailedRecordCount(v int64) *PutRecordsOutput {
	s.FailedRecordCount = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *PutRecordsOutput) SetRecords(v []*PutRecordsResultEntry) *PutRecordsOutput {
	s.Records = v
	return s
}

// Represents the output for PutRecords.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecordsRequestEntry
type PutRecordsRequestEntry struct {
	_ struct{} `type:"structure"`

	// The data blob to put into the record, which is base64-encoded when the blob
	// is serialized. When the data blob (the payload before base64-encoding) is
	// added to the partition key size, the total size must not exceed the maximum
	// record size (1 MB).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`

	// The hash value used to determine explicitly the shard that the data record
	// is assigned to by overriding the partition key hash.
	ExplicitHashKey *string `type:"string"`

	// Determines which shard in the stream the data record is assigned to. Partition
	// keys are Unicode strings with a maximum length limit of 256 characters for
	// each key. Amazon Kinesis uses the partition key as input to a hash function
	// that maps the partition key and associated data to a specific shard. Specifically,
	// an MD5 hash function is used to map partition keys to 128-bit integer values
	// and to map associated data records to shards. As a result of this hashing
	// mechanism, all data records with the same partition key map to the same shard
	// within the stream.
	//
	// PartitionKey is a required field
	PartitionKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecordsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordsRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordsRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordsRequestEntry"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.PartitionKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKey"))
	}
	if s.PartitionKey != nil && len(*s.PartitionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *PutRecordsRequestEntry) SetData(v []byte) *PutRecordsRequestEntry {
	s.Data = v
	return s
}

// SetExplicitHashKey sets the ExplicitHashKey field's value.
func (s *PutRecordsRequestEntry) SetExplicitHashKey(v string) *PutRecordsRequestEntry {
	s.ExplicitHashKey = &v
	return s
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *PutRecordsRequestEntry) SetPartitionKey(v string) *PutRecordsRequestEntry {
	s.PartitionKey = &v
	return s
}

// Represents the result of an individual record from a PutRecords request.
// A record that is successfully added to a stream includes SequenceNumber and
// ShardId in the result. A record that fails to be added to the stream includes
// ErrorCode and ErrorMessage in the result.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecordsResultEntry
type PutRecordsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code for an individual record result. ErrorCodes can be either
	// ProvisionedThroughputExceededException or InternalFailure.
	ErrorCode *string `type:"string"`

	// The error message for an individual record result. An ErrorCode value of
	// ProvisionedThroughputExceededException has an error message that includes
	// the account ID, stream name, and shard ID. An ErrorCode value of InternalFailure
	// has the error message "Internal Service Failure".
	ErrorMessage *string `type:"string"`

	// The sequence number for an individual record result.
	SequenceNumber *string `type:"string"`

	// The shard ID for an individual record result.
	ShardId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutRecordsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutRecordsResultEntry) SetErrorCode(v string) *PutRecordsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutRecordsResultEntry) SetErrorMessage(v string) *PutRecordsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *PutRecordsResultEntry) SetSequenceNumber(v string) *PutRecordsResultEntry {
	s.SequenceNumber = &v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *PutRecordsResultEntry) SetShardId(v string) *PutRecordsResultEntry {
	s.ShardId = &v
	return s
}

// The unit of data of the Amazon Kinesis stream, which is composed of a sequence
// number, a partition key, and a data blob.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/Record
type Record struct {
	_ struct{} `type:"structure"`

	// The approximate time that the record was inserted into the stream.
	ApproximateArrivalTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The data blob. The data in the blob is both opaque and immutable to the Amazon
	// Kinesis service, which does not inspect, interpret, or change the data in
	// the blob in any way. When the data blob (the payload before base64-encoding)
	// is added to the partition key size, the total size must not exceed the maximum
	// record size (1 MB).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`

	// Identifies which shard in the stream the data record is assigned to.
	//
	// PartitionKey is a required field
	PartitionKey *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the record in the stream.
	//
	// SequenceNumber is a required field
	SequenceNumber *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Record) GoString() string {
	return s.String()
}

// SetApproximateArrivalTimestamp sets the ApproximateArrivalTimestamp field's value.
func (s *Record) SetApproximateArrivalTimestamp(v time.Time) *Record {
	s.ApproximateArrivalTimestamp = &v
	return s
}

// SetData sets the Data field's value.
func (s *Record) SetData(v []byte) *Record {
	s.Data = v
	return s
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *Record) SetPartitionKey(v string) *Record {
	s.PartitionKey = &v
	return s
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *Record) SetSequenceNumber(v string) *Record {
	s.SequenceNumber = &v
	return s
}

// Represents the input for RemoveTagsFromStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStreamInput
type RemoveTagsFromStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// A list of tag keys. Each corresponding tag is removed from the stream.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromStreamInput"}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamName sets the StreamName field's value.
func (s *RemoveTagsFromStreamInput) SetStreamName(v string) *RemoveTagsFromStreamInput {
	s.StreamName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromStreamInput) SetTagKeys(v []*string) *RemoveTagsFromStreamInput {
	s.TagKeys = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStreamOutput
type RemoveTagsFromStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromStreamOutput) GoString() string {
	return s.String()
}

// The range of possible sequence numbers for the shard.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SequenceNumberRange
type SequenceNumberRange struct {
	_ struct{} `type:"structure"`

	// The ending sequence number for the range. Shards that are in the OPEN state
	// have an ending sequence number of null.
	EndingSequenceNumber *string `type:"string"`

	// The starting sequence number for the range.
	//
	// StartingSequenceNumber is a required field
	StartingSequenceNumber *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SequenceNumberRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SequenceNumberRange) GoString() string {
	return s.String()
}

// SetEndingSequenceNumber sets the EndingSequenceNumber field's value.
func (s *SequenceNumberRange) SetEndingSequenceNumber(v string) *SequenceNumberRange {
	s.EndingSequenceNumber = &v
	return s
}

// SetStartingSequenceNumber sets the StartingSequenceNumber field's value.
func (s *SequenceNumberRange) SetStartingSequenceNumber(v string) *SequenceNumberRange {
	s.StartingSequenceNumber = &v
	return s
}

// A uniquely identified group of data records in an Amazon Kinesis stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/Shard
type Shard struct {
	_ struct{} `type:"structure"`

	// The shard ID of the shard adjacent to the shard's parent.
	AdjacentParentShardId *string `min:"1" type:"string"`

	// The range of possible hash key values for the shard, which is a set of ordered
	// contiguous positive integers.
	//
	// HashKeyRange is a required field
	HashKeyRange *HashKeyRange `type:"structure" required:"true"`

	// The shard ID of the shard's parent.
	ParentShardId *string `min:"1" type:"string"`

	// The range of possible sequence numbers for the shard.
	//
	// SequenceNumberRange is a required field
	SequenceNumberRange *SequenceNumberRange `type:"structure" required:"true"`

	// The unique identifier of the shard within the stream.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Shard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Shard) GoString() string {
	return s.String()
}

// SetAdjacentParentShardId sets the AdjacentParentShardId field's value.
func (s *Shard) SetAdjacentParentShardId(v string) *Shard {
	s.AdjacentParentShardId = &v
	return s
}

// SetHashKeyRange sets the HashKeyRange field's value.
func (s *Shard) SetHashKeyRange(v *HashKeyRange) *Shard {
	s.HashKeyRange = v
	return s
}

// SetParentShardId sets the ParentShardId field's value.
func (s *Shard) SetParentShardId(v string) *Shard {
	s.ParentShardId = &v
	return s
}

// SetSequenceNumberRange sets the SequenceNumberRange field's value.
func (s *Shard) SetSequenceNumberRange(v *SequenceNumberRange) *Shard {
	s.SequenceNumberRange = v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *Shard) SetShardId(v string) *Shard {
	s.ShardId = &v
	return s
}

// Represents the input for SplitShard.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShardInput
type SplitShardInput struct {
	_ struct{} `type:"structure"`

	// A hash key value for the starting hash key of one of the child shards created
	// by the split. The hash key range for a given shard constitutes a set of ordered
	// contiguous positive integers. The value for NewStartingHashKey must be in
	// the range of hash keys being mapped into the shard. The NewStartingHashKey
	// hash key value and all higher hash key values in hash key range are distributed
	// to one of the child shards. All the lower hash key values in the range are
	// distributed to the other child shard.
	//
	// NewStartingHashKey is a required field
	NewStartingHashKey *string `type:"string" required:"true"`

	// The shard ID of the shard to split.
	//
	// ShardToSplit is a required field
	ShardToSplit *string `min:"1" type:"string" required:"true"`

	// The name of the stream for the shard split.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SplitShardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SplitShardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SplitShardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SplitShardInput"}
	if s.NewStartingHashKey == nil {
		invalidParams.Add(request.NewErrParamRequired("NewStartingHashKey"))
	}
	if s.ShardToSplit == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardToSplit"))
	}
	if s.ShardToSplit != nil && len(*s.ShardToSplit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardToSplit", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewStartingHashKey sets the NewStartingHashKey field's value.
func (s *SplitShardInput) SetNewStartingHashKey(v string) *SplitShardInput {
	s.NewStartingHashKey = &v
	return s
}

// SetShardToSplit sets the ShardToSplit field's value.
func (s *SplitShardInput) SetShardToSplit(v string) *SplitShardInput {
	s.ShardToSplit = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *SplitShardInput) SetStreamName(v string) *SplitShardInput {
	s.StreamName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShardOutput
type SplitShardOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SplitShardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SplitShardOutput) GoString() string {
	return s.String()
}

// Represents the output for DescribeStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StreamDescription
type StreamDescription struct {
	_ struct{} `type:"structure"`

	// Represents the current enhanced monitoring settings of the stream.
	//
	// EnhancedMonitoring is a required field
	EnhancedMonitoring []*EnhancedMetrics `type:"list" required:"true"`

	// If set to true, more shards in the stream are available to describe.
	//
	// HasMoreShards is a required field
	HasMoreShards *bool `type:"boolean" required:"true"`

	// The current retention period, in hours.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `min:"1" type:"integer" required:"true"`

	// The shards that comprise the stream.
	//
	// Shards is a required field
	Shards []*Shard `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) for the stream being described.
	//
	// StreamARN is a required field
	StreamARN *string `type:"string" required:"true"`

	// The approximate time that the stream was created.
	//
	// StreamCreationTimestamp is a required field
	StreamCreationTimestamp *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The name of the stream being described.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The current status of the stream being described. The stream status is one
	// of the following states:
	//
	//    * CREATING - The stream is being created. Amazon Kinesis immediately returns
	//    and sets StreamStatus to CREATING.
	//
	//    * DELETING - The stream is being deleted. The specified stream is in the
	//    DELETING state until Amazon Kinesis completes the deletion.
	//
	//    * ACTIVE - The stream exists and is ready for read and write operations
	//    or deletion. You should perform read and write operations only on an ACTIVE
	//    stream.
	//
	//    * UPDATING - Shards in the stream are being merged or split. Read and
	//    write operations continue to work while the stream is in the UPDATING
	//    state.
	//
	// StreamStatus is a required field
	StreamStatus *string `type:"string" required:"true" enum:"StreamStatus"`
}

// String returns the string representation
func (s StreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamDescription) GoString() string {
	return s.String()
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *StreamDescription) SetEnhancedMonitoring(v []*EnhancedMetrics) *StreamDescription {
	s.EnhancedMonitoring = v
	return s
}

// SetHasMoreShards sets the HasMoreShards field's value.
func (s *StreamDescription) SetHasMoreShards(v bool) *StreamDescription {
	s.HasMoreShards = &v
	return s
}

// SetRetentionPeriodHours sets the RetentionPeriodHours field's value.
func (s *StreamDescription) SetRetentionPeriodHours(v int64) *StreamDescription {
	s.RetentionPeriodHours = &v
	return s
}

// SetShards sets the Shards field's value.
func (s *StreamDescription) SetShards(v []*Shard) *StreamDescription {
	s.Shards = v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *StreamDescription) SetStreamARN(v string) *StreamDescription {
	s.StreamARN = &v
	return s
}

// SetStreamCreationTimestamp sets the StreamCreationTimestamp field's value.
func (s *StreamDescription) SetStreamCreationTimestamp(v time.Time) *StreamDescription {
	s.StreamCreationTimestamp = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StreamDescription) SetStreamName(v string) *StreamDescription {
	s.StreamName = &v
	return s
}

// SetStreamStatus sets the StreamStatus field's value.
func (s *StreamDescription) SetStreamStatus(v string) *StreamDescription {
	s.StreamStatus = &v
	return s
}

// Metadata assigned to the stream, consisting of a key-value pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
	// Unicode letters, digits, white space, _ . / = + - % @
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An optional string, typically used to describe or define the tag. Maximum
	// length: 256 characters. Valid characters: Unicode letters, digits, white
	// space, _ . / = + - % @
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCountInput
type UpdateShardCountInput struct {
	_ struct{} `type:"structure"`

	// The scaling type. Uniform scaling creates shards of equal size.
	//
	// ScalingType is a required field
	ScalingType *string `type:"string" required:"true" enum:"ScalingType"`

	// The name of the stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The new number of shards.
	//
	// TargetShardCount is a required field
	TargetShardCount *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateShardCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateShardCountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateShardCountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateShardCountInput"}
	if s.ScalingType == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingType"))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.TargetShardCount == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetShardCount"))
	}
	if s.TargetShardCount != nil && *s.TargetShardCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TargetShardCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScalingType sets the ScalingType field's value.
func (s *UpdateShardCountInput) SetScalingType(v string) *UpdateShardCountInput {
	s.ScalingType = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *UpdateShardCountInput) SetStreamName(v string) *UpdateShardCountInput {
	s.StreamName = &v
	return s
}

// SetTargetShardCount sets the TargetShardCount field's value.
func (s *UpdateShardCountInput) SetTargetShardCount(v int64) *UpdateShardCountInput {
	s.TargetShardCount = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCountOutput
type UpdateShardCountOutput struct {
	_ struct{} `type:"structure"`

	// The current number of shards.
	CurrentShardCount *int64 `min:"1" type:"integer"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`

	// The updated number of shards.
	TargetShardCount *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s UpdateShardCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateShardCountOutput) GoString() string {
	return s.String()
}

// SetCurrentShardCount sets the CurrentShardCount field's value.
func (s *UpdateShardCountOutput) SetCurrentShardCount(v int64) *UpdateShardCountOutput {
	s.CurrentShardCount = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *UpdateShardCountOutput) SetStreamName(v string) *UpdateShardCountOutput {
	s.StreamName = &v
	return s
}

// SetTargetShardCount sets the TargetShardCount field's value.
func (s *UpdateShardCountOutput) SetTargetShardCount(v int64) *UpdateShardCountOutput {
	s.TargetShardCount = &v
	return s
}

const (
	// MetricsNameIncomingBytes is a MetricsName enum value
	MetricsNameIncomingBytes = "IncomingBytes"

	// MetricsNameIncomingRecords is a MetricsName enum value
	MetricsNameIncomingRecords = "IncomingRecords"

	// MetricsNameOutgoingBytes is a MetricsName enum value
	MetricsNameOutgoingBytes = "OutgoingBytes"

	// MetricsNameOutgoingRecords is a MetricsName enum value
	MetricsNameOutgoingRecords = "OutgoingRecords"

	// MetricsNameWriteProvisionedThroughputExceeded is a MetricsName enum value
	MetricsNameWriteProvisionedThroughputExceeded = "WriteProvisionedThroughputExceeded"

	// MetricsNameReadProvisionedThroughputExceeded is a MetricsName enum value
	MetricsNameReadProvisionedThroughputExceeded = "ReadProvisionedThroughputExceeded"

	// MetricsNameIteratorAgeMilliseconds is a MetricsName enum value
	MetricsNameIteratorAgeMilliseconds = "IteratorAgeMilliseconds"

	// MetricsNameAll is a MetricsName enum value
	MetricsNameAll = "ALL"
)

const (
	// ScalingTypeUniformScaling is a ScalingType enum value
	ScalingTypeUniformScaling = "UNIFORM_SCALING"
)

const (
	// ShardIteratorTypeAtSequenceNumber is a ShardIteratorType enum value
	ShardIteratorTypeAtSequenceNumber = "AT_SEQUENCE_NUMBER"

	// ShardIteratorTypeAfterSequenceNumber is a ShardIteratorType enum value
	ShardIteratorTypeAfterSequenceNumber = "AFTER_SEQUENCE_NUMBER"

	// ShardIteratorTypeTrimHorizon is a ShardIteratorType enum value
	ShardIteratorTypeTrimHorizon = "TRIM_HORIZON"

	// ShardIteratorTypeLatest is a ShardIteratorType enum value
	ShardIteratorTypeLatest = "LATEST"

	// ShardIteratorTypeAtTimestamp is a ShardIteratorType enum value
	ShardIteratorTypeAtTimestamp = "AT_TIMESTAMP"
)

const (
	// StreamStatusCreating is a StreamStatus enum value
	StreamStatusCreating = "CREATING"

	// StreamStatusDeleting is a StreamStatus enum value
	StreamStatusDeleting = "DELETING"

	// StreamStatusActive is a StreamStatus enum value
	StreamStatusActive = "ACTIVE"

	// StreamStatusUpdating is a StreamStatus enum value
	StreamStatusUpdating = "UPDATING"
)
