/* windowmenu.c generated by valac 0.32.1, the Vala compiler
 * generated from windowmenu.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/common.h>
#include <glib/gi18n-lib.h>


#define BUDGIE_TYPE_WINDOW_MENU (budgie_window_menu_get_type ())
#define BUDGIE_WINDOW_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenu))
#define BUDGIE_WINDOW_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenuClass))
#define BUDGIE_IS_WINDOW_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_WINDOW_MENU))
#define BUDGIE_IS_WINDOW_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_WINDOW_MENU))
#define BUDGIE_WINDOW_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenuClass))

typedef struct _BudgieWindowMenu BudgieWindowMenu;
typedef struct _BudgieWindowMenuClass BudgieWindowMenuClass;
typedef struct _BudgieWindowMenuPrivate BudgieWindowMenuPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BudgieWindowMenu {
	GtkMenu parent_instance;
	BudgieWindowMenuPrivate * priv;
};

struct _BudgieWindowMenuClass {
	GtkMenuClass parent_class;
};

struct _BudgieWindowMenuPrivate {
	MetaWindow* window;
	GtkMenuItem* minimize;
	GtkMenuItem* maximize;
	GtkMenuItem* unmaximize;
	GtkMenuItem* move;
	GtkMenuItem* resize;
	GtkMenuItem* always_on_top;
	GtkMenuItem* close;
};


static gpointer budgie_window_menu_parent_class = NULL;

GType budgie_window_menu_get_type (void) G_GNUC_CONST;
#define BUDGIE_WINDOW_MENU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenuPrivate))
enum  {
	BUDGIE_WINDOW_MENU_DUMMY_PROPERTY,
	BUDGIE_WINDOW_MENU_META_WINDOW
};
gboolean budgie_window_menu_can_show (BudgieWindowMenu* self);
static void budgie_window_menu_update_menus (BudgieWindowMenu* self);
static void budgie_window_menu_minimize_cb (BudgieWindowMenu* self);
static void budgie_window_menu_unmaximize_cb (BudgieWindowMenu* self);
static void budgie_window_menu_maximize_cb (BudgieWindowMenu* self);
static void budgie_window_menu_close_cb (BudgieWindowMenu* self);
static void budgie_window_menu_move_cb (BudgieWindowMenu* self);
static void budgie_window_menu_resize_cb (BudgieWindowMenu* self);
static void budgie_window_menu_always_on_top_cb (BudgieWindowMenu* self);
BudgieWindowMenu* budgie_window_menu_new (void);
BudgieWindowMenu* budgie_window_menu_construct (GType object_type);
MetaWindow* budgie_window_menu_get_meta_window (BudgieWindowMenu* self);
void budgie_window_menu_set_meta_window (BudgieWindowMenu* self, MetaWindow* value);
static GObject * budgie_window_menu_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _budgie_window_menu_minimize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _budgie_window_menu_unmaximize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _budgie_window_menu_maximize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _budgie_window_menu_move_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _budgie_window_menu_resize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _budgie_window_menu_always_on_top_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _budgie_window_menu_close_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void budgie_window_menu_finalize (GObject* obj);
static void _vala_budgie_window_menu_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_window_menu_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gboolean budgie_window_menu_can_show (BudgieWindowMenu* self) {
	gboolean result = FALSE;
	MetaWindow* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->window;
	result = _tmp0_ != NULL;
	return result;
}


static void budgie_window_menu_update_menus (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	MetaWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkMenuItem* _tmp4_ = NULL;
	MetaWindow* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkMenuItem* _tmp7_ = NULL;
	MetaWindow* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GtkMenuItem* _tmp10_ = NULL;
	MetaWindow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkMenuItem* _tmp13_ = NULL;
	MetaWindow* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean is_max = FALSE;
	MetaWindow* _tmp16_ = NULL;
	MetaMaximizeFlags _tmp17_ = 0;
	GtkMenuItem* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GtkMenuItem* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GtkMenuItem* _tmp22_ = NULL;
	MetaWindow* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->minimize;
	_tmp2_ = self->priv->window;
	_tmp3_ = meta_window_can_minimize (_tmp2_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp3_);
	_tmp4_ = self->priv->maximize;
	_tmp5_ = self->priv->window;
	_tmp6_ = meta_window_can_maximize (_tmp5_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, _tmp6_);
	_tmp7_ = self->priv->close;
	_tmp8_ = self->priv->window;
	_tmp9_ = meta_window_can_close (_tmp8_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp9_);
	_tmp10_ = self->priv->move;
	_tmp11_ = self->priv->window;
	_tmp12_ = meta_window_allows_move (_tmp11_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp12_);
	_tmp13_ = self->priv->resize;
	_tmp14_ = self->priv->window;
	_tmp15_ = meta_window_allows_resize (_tmp14_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, _tmp15_);
	_tmp16_ = self->priv->window;
	_tmp17_ = meta_window_get_maximized (_tmp16_);
	is_max = _tmp17_ != 0;
	_tmp18_ = self->priv->unmaximize;
	_tmp19_ = is_max;
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, _tmp19_);
	_tmp20_ = self->priv->maximize;
	_tmp21_ = is_max;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, !_tmp21_);
	_tmp22_ = self->priv->minimize;
	_tmp23_ = self->priv->window;
	_tmp24_ = meta_window_can_minimize (_tmp23_);
	gtk_widget_set_visible ((GtkWidget*) _tmp22_, _tmp24_);
}


static void budgie_window_menu_minimize_cb (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->window;
	meta_window_minimize (_tmp1_);
}


static void budgie_window_menu_unmaximize_cb (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->window;
	meta_window_unmaximize (_tmp1_, META_MAXIMIZE_BOTH);
}


static void budgie_window_menu_maximize_cb (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->window;
	meta_window_maximize (_tmp1_, META_MAXIMIZE_BOTH);
}


static void budgie_window_menu_close_cb (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->window;
	meta_window_delete (_tmp1_, (guint32) CLUTTER_CURRENT_TIME);
}


static void budgie_window_menu_move_cb (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->window;
	meta_window_begin_grab_op (_tmp1_, META_GRAB_OP_KEYBOARD_MOVING, TRUE, (guint32) CLUTTER_CURRENT_TIME);
}


static void budgie_window_menu_resize_cb (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	MetaWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->window;
	meta_window_begin_grab_op (_tmp1_, META_GRAB_OP_KEYBOARD_RESIZING_UNKNOWN, TRUE, (guint32) CLUTTER_CURRENT_TIME);
}


static void budgie_window_menu_always_on_top_cb (BudgieWindowMenu* self) {
	MetaWindow* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	MetaWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkMenuItem* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->always_on_top;
	g_object_freeze_notify ((GObject*) _tmp1_);
	_tmp2_ = self->priv->window;
	_tmp3_ = meta_window_is_above (_tmp2_);
	if (_tmp3_) {
		MetaWindow* _tmp4_ = NULL;
		_tmp4_ = self->priv->window;
		meta_window_unmake_above (_tmp4_);
	} else {
		MetaWindow* _tmp5_ = NULL;
		_tmp5_ = self->priv->window;
		meta_window_make_above (_tmp5_);
	}
	_tmp6_ = self->priv->always_on_top;
	g_object_thaw_notify ((GObject*) _tmp6_);
}


BudgieWindowMenu* budgie_window_menu_construct (GType object_type) {
	BudgieWindowMenu * self = NULL;
	self = (BudgieWindowMenu*) g_object_new (object_type, NULL);
	return self;
}


BudgieWindowMenu* budgie_window_menu_new (void) {
	return budgie_window_menu_construct (BUDGIE_TYPE_WINDOW_MENU);
}


MetaWindow* budgie_window_menu_get_meta_window (BudgieWindowMenu* self) {
	MetaWindow* result;
	MetaWindow* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window;
	result = _tmp0_;
	return result;
}


void budgie_window_menu_set_meta_window (BudgieWindowMenu* self, MetaWindow* value) {
	MetaWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->window = _tmp0_;
	budgie_window_menu_update_menus (self);
	g_object_notify ((GObject *) self, "meta-window");
}


static void _budgie_window_menu_minimize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	budgie_window_menu_minimize_cb ((BudgieWindowMenu*) self);
}


static void _budgie_window_menu_unmaximize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	budgie_window_menu_unmaximize_cb ((BudgieWindowMenu*) self);
}


static void _budgie_window_menu_maximize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	budgie_window_menu_maximize_cb ((BudgieWindowMenu*) self);
}


static void _budgie_window_menu_move_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	budgie_window_menu_move_cb ((BudgieWindowMenu*) self);
}


static void _budgie_window_menu_resize_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	budgie_window_menu_resize_cb ((BudgieWindowMenu*) self);
}


static void _budgie_window_menu_always_on_top_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	budgie_window_menu_always_on_top_cb ((BudgieWindowMenu*) self);
}


static void _budgie_window_menu_close_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	budgie_window_menu_close_cb ((BudgieWindowMenu*) self);
}


static GObject * budgie_window_menu_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BudgieWindowMenu * self;
	GtkMenuItem* item = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
	GtkMenuItem* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMenuItem* _tmp6_ = NULL;
	GtkMenuItem* _tmp7_ = NULL;
	GtkMenuItem* _tmp8_ = NULL;
	GtkMenuItem* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkMenuItem* _tmp11_ = NULL;
	GtkMenuItem* _tmp12_ = NULL;
	GtkMenuItem* _tmp13_ = NULL;
	GtkMenuItem* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkMenuItem* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_ = NULL;
	GtkMenuItem* _tmp18_ = NULL;
	GtkMenuItem* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkMenuItem* _tmp21_ = NULL;
	GtkMenuItem* _tmp22_ = NULL;
	GtkMenuItem* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_ = NULL;
	GtkMenuItem* _tmp27_ = NULL;
	GtkMenuItem* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkMenuItem* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_ = NULL;
	GtkMenuItem* _tmp33_ = NULL;
	GtkMenuItem* _tmp34_ = NULL;
	parent_class = G_OBJECT_CLASS (budgie_window_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenu);
	item = NULL;
	_tmp0_ = _ ("Minimize");
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->minimize);
	self->priv->minimize = _tmp1_;
	_tmp2_ = self->priv->minimize;
	g_signal_connect_object (_tmp2_, "activate", (GCallback) _budgie_window_menu_minimize_cb_gtk_menu_item_activate, self, 0);
	_tmp3_ = self->priv->minimize;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->minimize;
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
	_tmp5_ = _ ("Unmaximize");
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->unmaximize);
	self->priv->unmaximize = _tmp6_;
	_tmp7_ = self->priv->maximize;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) _budgie_window_menu_unmaximize_cb_gtk_menu_item_activate, self, 0);
	_tmp8_ = self->priv->unmaximize;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->unmaximize;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	_tmp10_ = _ ("Maximize");
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->maximize);
	self->priv->maximize = _tmp11_;
	_tmp12_ = self->priv->maximize;
	g_signal_connect_object (_tmp12_, "activate", (GCallback) _budgie_window_menu_maximize_cb_gtk_menu_item_activate, self, 0);
	_tmp13_ = self->priv->maximize;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->maximize;
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
	_tmp15_ = _ ("Move");
	_tmp16_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->move);
	self->priv->move = _tmp16_;
	_tmp17_ = self->priv->move;
	g_signal_connect_object (_tmp17_, "activate", (GCallback) _budgie_window_menu_move_cb_gtk_menu_item_activate, self, 0);
	_tmp18_ = self->priv->move;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->move;
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
	_tmp20_ = _ ("Resize");
	_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->resize);
	self->priv->resize = _tmp21_;
	_tmp22_ = self->priv->resize;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) _budgie_window_menu_resize_cb_gtk_menu_item_activate, self, 0);
	_tmp23_ = self->priv->resize;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->resize;
	gtk_widget_show_all ((GtkWidget*) _tmp24_);
	_tmp25_ = _ ("Always On Top");
	_tmp26_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp25_);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->always_on_top);
	self->priv->always_on_top = _tmp26_;
	_tmp27_ = self->priv->always_on_top;
	g_signal_connect_object (_tmp27_, "activate", (GCallback) _budgie_window_menu_always_on_top_cb_gtk_menu_item_activate, self, 0);
	_tmp28_ = self->priv->always_on_top;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->always_on_top;
	gtk_widget_show_all ((GtkWidget*) _tmp29_);
	_tmp30_ = _ ("Close");
	_tmp31_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->close);
	self->priv->close = _tmp31_;
	_tmp32_ = self->priv->close;
	g_signal_connect_object (_tmp32_, "activate", (GCallback) _budgie_window_menu_close_cb_gtk_menu_item_activate, self, 0);
	_tmp33_ = self->priv->close;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->close;
	gtk_widget_show_all ((GtkWidget*) _tmp34_);
	_g_object_unref0 (item);
	return obj;
}


static void budgie_window_menu_class_init (BudgieWindowMenuClass * klass) {
	budgie_window_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieWindowMenuPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_window_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_window_menu_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_window_menu_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_window_menu_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WINDOW_MENU_META_WINDOW, g_param_spec_object ("meta-window", "meta-window", "meta-window", meta_window_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void budgie_window_menu_instance_init (BudgieWindowMenu * self) {
	self->priv = BUDGIE_WINDOW_MENU_GET_PRIVATE (self);
	self->priv->window = NULL;
	self->priv->minimize = NULL;
	self->priv->maximize = NULL;
	self->priv->unmaximize = NULL;
	self->priv->move = NULL;
	self->priv->resize = NULL;
	self->priv->always_on_top = NULL;
	self->priv->close = NULL;
}


static void budgie_window_menu_finalize (GObject* obj) {
	BudgieWindowMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenu);
	_g_object_unref0 (self->priv->minimize);
	_g_object_unref0 (self->priv->maximize);
	_g_object_unref0 (self->priv->unmaximize);
	_g_object_unref0 (self->priv->move);
	_g_object_unref0 (self->priv->resize);
	_g_object_unref0 (self->priv->always_on_top);
	_g_object_unref0 (self->priv->close);
	G_OBJECT_CLASS (budgie_window_menu_parent_class)->finalize (obj);
}


GType budgie_window_menu_get_type (void) {
	static volatile gsize budgie_window_menu_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_window_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieWindowMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_window_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieWindowMenu), 0, (GInstanceInitFunc) budgie_window_menu_instance_init, NULL };
		GType budgie_window_menu_type_id;
		budgie_window_menu_type_id = g_type_register_static (gtk_menu_get_type (), "BudgieWindowMenu", &g_define_type_info, 0);
		g_once_init_leave (&budgie_window_menu_type_id__volatile, budgie_window_menu_type_id);
	}
	return budgie_window_menu_type_id__volatile;
}


static void _vala_budgie_window_menu_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieWindowMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenu);
	switch (property_id) {
		case BUDGIE_WINDOW_MENU_META_WINDOW:
		g_value_set_object (value, budgie_window_menu_get_meta_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_window_menu_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieWindowMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_WINDOW_MENU, BudgieWindowMenu);
	switch (property_id) {
		case BUDGIE_WINDOW_MENU_META_WINDOW:
		budgie_window_menu_set_meta_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



