/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.lut;

import ucar.jpeg.icc.lut.LookUpTable;
import ucar.jpeg.icc.lut.LookUpTable32Gamma;
import ucar.jpeg.icc.lut.LookUpTable32Interp;
import ucar.jpeg.icc.tags.ICCCurveType;

abstract class LookUpTable32
extends LookUpTable {
    protected final int dwMaxOutput;
    public final int[] lut;

    public String toString() {
        StringBuffer rep = new StringBuffer("[LookUpTable32 ");
        rep.append("max= " + this.dwMaxOutput);
        rep.append(", nentries= " + this.dwNumInput);
        return rep.append("]").toString();
    }

    public String toStringWholeLut() {
        int col;
        int row;
        StringBuffer rep = new StringBuffer("[LookUpTable32" + eol);
        rep.append("max output = " + this.dwMaxOutput + eol);
        for (row = 0; row < this.dwNumInput / 10; ++row) {
            rep.append("lut[" + 10 * row + "] : ");
            for (col = 0; col < 10; ++col) {
                rep.append(this.lut[10 * row + col] + " ");
            }
            rep.append(eol);
        }
        rep.append("lut[" + 10 * row + "] : ");
        for (col = 0; col < this.dwNumInput % 10; ++col) {
            rep.append(this.lut[10 * row + col] + " ");
        }
        rep.append(eol + eol);
        return rep.toString();
    }

    public static LookUpTable32 createInstance(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        if (curve.count == 1) {
            return new LookUpTable32Gamma(curve, dwNumInput, dwMaxOutput);
        }
        return new LookUpTable32Interp(curve, dwNumInput, dwMaxOutput);
    }

    protected LookUpTable32(int dwNumInput, int dwMaxOutput) {
        super(null, dwNumInput);
        this.lut = new int[dwNumInput];
        this.dwMaxOutput = dwMaxOutput;
    }

    protected LookUpTable32(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        super(curve, dwNumInput);
        this.dwMaxOutput = dwMaxOutput;
        this.lut = new int[dwNumInput];
    }

    public final int elementAt(int index) {
        return this.lut[index];
    }
}

