package js

// generated by hasher -file hash.go -type Hash; DO NOT EDIT, except for adding more constants to the list and rerun go generate

// uses github.com/tdewolff/hasher
//go:generate hasher -type=Hash -file=hash.go

// Hash defines perfect hashes for a predefined list of strings
type Hash uint32

// Unique hash definitions to be used instead of strings
const (
	Break      Hash = 0x5    // break
	Case       Hash = 0x3404 // case
	Catch      Hash = 0xba05 // catch
	Class      Hash = 0x505  // class
	Const      Hash = 0x2c05 // const
	Continue   Hash = 0x3e08 // continue
	Debugger   Hash = 0x8408 // debugger
	Default    Hash = 0xab07 // default
	Delete     Hash = 0xcd06 // delete
	Do         Hash = 0x4c02 // do
	Else       Hash = 0x3704 // else
	Enum       Hash = 0x3a04 // enum
	Export     Hash = 0x1806 // export
	Extends    Hash = 0x4507 // extends
	False      Hash = 0x5a05 // false
	Finally    Hash = 0x7a07 // finally
	For        Hash = 0xc403 // for
	Function   Hash = 0x4e08 // function
	If         Hash = 0x5902 // if
	Implements Hash = 0x5f0a // implements
	Import     Hash = 0x6906 // import
	In         Hash = 0x4202 // in
	Instanceof Hash = 0x710a // instanceof
	Interface  Hash = 0x8c09 // interface
	Let        Hash = 0xcf03 // let
	New        Hash = 0x1203 // new
	Null       Hash = 0x5504 // null
	Package    Hash = 0x9507 // package
	Private    Hash = 0x9c07 // private
	Protected  Hash = 0xa309 // protected
	Public     Hash = 0xb506 // public
	Return     Hash = 0xd06  // return
	Static     Hash = 0x2f06 // static
	Super      Hash = 0x905  // super
	Switch     Hash = 0x2606 // switch
	This       Hash = 0x2304 // this
	Throw      Hash = 0x1d05 // throw
	True       Hash = 0xb104 // true
	Try        Hash = 0x6e03 // try
	Typeof     Hash = 0xbf06 // typeof
	Var        Hash = 0xc703 // var
	Void       Hash = 0xca04 // void
	While      Hash = 0x1405 // while
	With       Hash = 0x2104 // with
	Yield      Hash = 0x8005 // yield
)

// String returns the hash' name.
func (i Hash) String() string {
	start := uint32(i >> 8)
	n := uint32(i & 0xff)
	if start+n > uint32(len(_Hash_text)) {
		return ""
	}
	return _Hash_text[start : start+n]
}

// ToHash returns the hash whose name is s. It returns zero if there is no
// such hash. It is case sensitive.
func ToHash(s []byte) Hash {
	if len(s) == 0 || len(s) > _Hash_maxLen {
		return 0
	}
	h := uint32(_Hash_hash0)
	for i := 0; i < len(s); i++ {
		h ^= uint32(s[i])
		h *= 16777619
	}
	if i := _Hash_table[h&uint32(len(_Hash_table)-1)]; int(i&0xff) == len(s) {
		t := _Hash_text[i>>8 : i>>8+i&0xff]
		for i := 0; i < len(s); i++ {
			if t[i] != s[i] {
				goto NEXT
			}
		}
		return i
	}
NEXT:
	if i := _Hash_table[(h>>16)&uint32(len(_Hash_table)-1)]; int(i&0xff) == len(s) {
		t := _Hash_text[i>>8 : i>>8+i&0xff]
		for i := 0; i < len(s); i++ {
			if t[i] != s[i] {
				return 0
			}
		}
		return i
	}
	return 0
}

const _Hash_hash0 = 0x9acb0442
const _Hash_maxLen = 10
const _Hash_text = "breakclassupereturnewhilexporthrowithiswitchconstaticaselsen" +
	"umcontinuextendsdofunctionullifalseimplementsimportryinstanc" +
	"eofinallyieldebuggerinterfacepackageprivateprotectedefaultru" +
	"epublicatchtypeoforvarvoidelete"

var _Hash_table = [1 << 6]Hash{
	0x0:  0x2f06, // static
	0x1:  0x9c07, // private
	0x3:  0xb104, // true
	0x6:  0x5a05, // false
	0x7:  0x4c02, // do
	0x9:  0x2c05, // const
	0xa:  0x2606, // switch
	0xb:  0x6e03, // try
	0xc:  0x1203, // new
	0xd:  0x4202, // in
	0xf:  0x8005, // yield
	0x10: 0x5f0a, // implements
	0x11: 0xc403, // for
	0x12: 0x505,  // class
	0x13: 0x3a04, // enum
	0x16: 0xc703, // var
	0x17: 0x5902, // if
	0x19: 0xcf03, // let
	0x1a: 0x9507, // package
	0x1b: 0xca04, // void
	0x1c: 0xcd06, // delete
	0x1f: 0x5504, // null
	0x20: 0x1806, // export
	0x21: 0xd06,  // return
	0x23: 0x4507, // extends
	0x25: 0x2304, // this
	0x26: 0x905,  // super
	0x27: 0x1405, // while
	0x29: 0x5,    // break
	0x2b: 0x3e08, // continue
	0x2e: 0x3404, // case
	0x2f: 0xab07, // default
	0x31: 0x8408, // debugger
	0x32: 0x1d05, // throw
	0x33: 0xbf06, // typeof
	0x34: 0x2104, // with
	0x35: 0xba05, // catch
	0x36: 0x4e08, // function
	0x37: 0x710a, // instanceof
	0x38: 0xa309, // protected
	0x39: 0x8c09, // interface
	0x3b: 0xb506, // public
	0x3c: 0x3704, // else
	0x3d: 0x7a07, // finally
	0x3f: 0x6906, // import
}
