// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/logging/type/log_severity.proto
// DO NOT EDIT!

package google_logging_type // import "google.golang.org/genproto/googleapis/logging/type"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The severity of the event described in a log entry, expressed as one of the
// standard severity levels listed below.  For your reference, the levels are
// assigned the listed numeric values. The effect of using numeric values other
// than those listed is undefined.
//
// You can filter for log entries by severity.  For example, the following
// filter expression will match log entries with severities `INFO`, `NOTICE`,
// and `WARNING`:
//
//     severity > DEBUG AND severity <= WARNING
//
// If you are writing log entries, you should map other severity encodings to
// one of these standard levels. For example, you might map all of Java's FINE,
// FINER, and FINEST levels to `LogSeverity.DEBUG`. You can preserve the
// original severity level in the log entry payload if you wish.
type LogSeverity int32

const (
	// (0) The log entry has no assigned severity level.
	LogSeverity_DEFAULT LogSeverity = 0
	// (100) Debug or trace information.
	LogSeverity_DEBUG LogSeverity = 100
	// (200) Routine information, such as ongoing status or performance.
	LogSeverity_INFO LogSeverity = 200
	// (300) Normal but significant events, such as start up, shut down, or
	// a configuration change.
	LogSeverity_NOTICE LogSeverity = 300
	// (400) Warning events might cause problems.
	LogSeverity_WARNING LogSeverity = 400
	// (500) Error events are likely to cause problems.
	LogSeverity_ERROR LogSeverity = 500
	// (600) Critical events cause more severe problems or outages.
	LogSeverity_CRITICAL LogSeverity = 600
	// (700) A person must take an action immediately.
	LogSeverity_ALERT LogSeverity = 700
	// (800) One or more systems are unusable.
	LogSeverity_EMERGENCY LogSeverity = 800
)

var LogSeverity_name = map[int32]string{
	0:   "DEFAULT",
	100: "DEBUG",
	200: "INFO",
	300: "NOTICE",
	400: "WARNING",
	500: "ERROR",
	600: "CRITICAL",
	700: "ALERT",
	800: "EMERGENCY",
}
var LogSeverity_value = map[string]int32{
	"DEFAULT":   0,
	"DEBUG":     100,
	"INFO":      200,
	"NOTICE":    300,
	"WARNING":   400,
	"ERROR":     500,
	"CRITICAL":  600,
	"ALERT":     700,
	"EMERGENCY": 800,
}

func (x LogSeverity) String() string {
	return proto.EnumName(LogSeverity_name, int32(x))
}
func (LogSeverity) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func init() {
	proto.RegisterEnum("google.logging.type.LogSeverity", LogSeverity_name, LogSeverity_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/logging/type/log_severity.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 282 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x8f, 0x41, 0x4a, 0xfb, 0x40,
	0x14, 0x87, 0xff, 0xfd, 0xb7, 0x49, 0xcd, 0x8b, 0xca, 0x30, 0x2e, 0x04, 0x8f, 0x20, 0x98, 0x59,
	0x78, 0x82, 0x24, 0x9d, 0x86, 0x81, 0x98, 0x94, 0x31, 0x45, 0x5c, 0x49, 0x8c, 0xe3, 0x30, 0x10,
	0xe7, 0x85, 0x24, 0x14, 0xba, 0xf5, 0x04, 0x1e, 0xc1, 0x03, 0x78, 0x04, 0x0f, 0xe0, 0x11, 0x3c,
	0x88, 0x07, 0x90, 0xb4, 0x59, 0xb8, 0x70, 0xe1, 0x72, 0xf8, 0x7d, 0x7c, 0xf3, 0x3d, 0xe0, 0x1a,
	0x51, 0xd7, 0x2a, 0xd0, 0x58, 0x97, 0x56, 0x07, 0xd8, 0x6a, 0xa6, 0x95, 0x6d, 0x5a, 0xec, 0x91,
	0xed, 0xa7, 0xb2, 0x31, 0x1d, 0xab, 0x51, 0x6b, 0x63, 0x35, 0xeb, 0xb7, 0x8d, 0x1a, 0x1e, 0x77,
	0x9d, 0xda, 0xa8, 0xd6, 0xf4, 0xdb, 0x60, 0x87, 0xd2, 0x93, 0x51, 0x33, 0x72, 0xc1, 0xc0, 0x9d,
	0x89, 0xbf, 0xb9, 0xcb, 0xc6, 0xb0, 0x4e, 0xb5, 0x1b, 0x53, 0xa9, 0x0a, 0xed, 0xa3, 0xd1, 0xac,
	0xb4, 0x16, 0xfb, 0xb2, 0x37, 0x68, 0xbb, 0xbd, 0xff, 0xfc, 0x79, 0x02, 0x7e, 0x8a, 0xfa, 0x7a,
	0xfc, 0x95, 0xfa, 0x30, 0x5f, 0xf0, 0x65, 0xb8, 0x4e, 0x0b, 0xf2, 0x8f, 0x7a, 0xe0, 0x2c, 0x78,
	0xb4, 0x4e, 0xc8, 0x03, 0xf5, 0x60, 0x26, 0xb2, 0x65, 0x4e, 0x3e, 0x26, 0xd4, 0x07, 0x37, 0xcb,
	0x0b, 0x11, 0x73, 0xf2, 0xf6, 0x9f, 0x1e, 0xc2, 0xfc, 0x26, 0x94, 0x99, 0xc8, 0x12, 0xf2, 0x32,
	0xa5, 0x00, 0x0e, 0x97, 0x32, 0x97, 0xe4, 0x6b, 0x4a, 0x8f, 0xe0, 0x20, 0x96, 0xa2, 0x10, 0x71,
	0x98, 0x92, 0xcf, 0xd9, 0x30, 0x85, 0x29, 0x97, 0x05, 0x79, 0x77, 0xe8, 0x31, 0x78, 0xfc, 0x8a,
	0xcb, 0x84, 0x67, 0xf1, 0x2d, 0x79, 0x75, 0xa3, 0x0b, 0x38, 0xad, 0xf0, 0x29, 0xf8, 0xe5, 0xd4,
	0x88, 0xfc, 0x88, 0x5b, 0x0d, 0xc5, 0xab, 0xc9, 0xbd, 0xbb, 0x4b, 0xbf, 0xfc, 0x0e, 0x00, 0x00,
	0xff, 0xff, 0x01, 0xa8, 0xad, 0x71, 0x63, 0x01, 0x00, 0x00,
}
