#
# Copyright 2005-2018 ECMWF.
#
# This software is licensed under the terms of the Apache Licence Version 2.0
# which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
#
# In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
# virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
#

import traceback
import sys

from gribapi import *

INPUT = '../../data/sample.grib2'
OUTPUT = 'out.mw.grib'
VERBOSE = 1  # verbose error reporting


def example():
    fin = open(INPUT)
    fout = open(OUTPUT, 'w')

    gid = grib_new_from_file(fin)

    mgid = grib_multi_new()

    for step in range(12, 132, 12):
        grib_set(gid, "step", step)
        grib_multi_append(gid, 4, mgid)

    grib_multi_write(mgid, fout)

    grib_multi_release(mgid)
    grib_release(gid)
    fin.close()
    fout.close()


def main():
    try:
        example()
    except GribInternalError, err:
        if VERBOSE:
            traceback.print_exc(file=sys.stderr)
        else:
            print >>sys.stderr, err.msg

        return 1

if __name__ == "__main__":
    sys.exit(main())
