/*
   Copyright (C) 2013-2020 Laurent Montel <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "knoteswidget.h"
#include "knotesiconview.h"
#include "knoteslistwidgetsearchline.h"

#include <QVBoxLayout>

KNotesWidget::KNotesWidget(KNotesPart *part, QWidget *parent)
    : QWidget(parent)
{
    QVBoxLayout *lay = new QVBoxLayout(this);
    mSearchLine = new KNotesListWidgetSearchLine;
    lay->addWidget(mSearchLine);
    mIconView = new KNotesIconView(part, parent);
    mSearchLine->setListWidget(mIconView);
    lay->addWidget(mIconView);
}

KNotesWidget::~KNotesWidget()
{
}

void KNotesWidget::slotFocusQuickSearch()
{
    mSearchLine->setFocus();
}

void KNotesWidget::updateClickMessage(const QString &shortcutStr)
{
    mSearchLine->updateClickMessage(shortcutStr);
}

KNotesIconView *KNotesWidget::notesView() const
{
    return mIconView;
}
