; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-shuffle | FileCheck %s --check-prefixes=AVX,AVX512

declare <1 x i8> @llvm.sadd.sat.v1i8(<1 x i8>, <1 x i8>)
declare <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8>, <2 x i8>)
declare <4 x i8> @llvm.sadd.sat.v4i8(<4 x i8>, <4 x i8>)
declare <8 x i8> @llvm.sadd.sat.v8i8(<8 x i8>, <8 x i8>)
declare <12 x i8> @llvm.sadd.sat.v12i8(<12 x i8>, <12 x i8>)
declare <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8>, <64 x i8>)

declare <1 x i16> @llvm.sadd.sat.v1i16(<1 x i16>, <1 x i16>)
declare <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16>, <2 x i16>)
declare <4 x i16> @llvm.sadd.sat.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16>, <8 x i16>)
declare <12 x i16> @llvm.sadd.sat.v12i16(<12 x i16>, <12 x i16>)
declare <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16>, <32 x i16>)

declare <16 x i1> @llvm.sadd.sat.v16i1(<16 x i1>, <16 x i1>)
declare <16 x i4> @llvm.sadd.sat.v16i4(<16 x i4>, <16 x i4>)

declare <2 x i32> @llvm.sadd.sat.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32>, <16 x i32>)
declare <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64>, <8 x i64>)

declare <4 x i24> @llvm.sadd.sat.v4i24(<4 x i24>, <4 x i24>)
declare <2 x i128> @llvm.sadd.sat.v2i128(<2 x i128>, <2 x i128>)

; Legal types, depending on architecture.

define <16 x i8> @v16i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE-LABEL: v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i8> %z
}

define <32 x i8> @v32i8(<32 x i8> %x, <32 x i8> %y) nounwind {
; SSE-LABEL: v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm2, %xmm0
; SSE-NEXT:    paddsb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddsb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddsb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> %x, <32 x i8> %y)
  ret <32 x i8> %z
}

define <64 x i8> @v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; SSE-LABEL: v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm4, %xmm0
; SSE-NEXT:    paddsb %xmm5, %xmm1
; SSE-NEXT:    paddsb %xmm6, %xmm2
; SSE-NEXT:    paddsb %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddsb %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddsb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddsb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddsb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddsb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddsb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> %x, <64 x i8> %y)
  ret <64 x i8> %z
}

define <8 x i16> @v8i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE-LABEL: v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  ret <8 x i16> %z
}

define <16 x i16> @v16i16(<16 x i16> %x, <16 x i16> %y) nounwind {
; SSE-LABEL: v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsw %xmm2, %xmm0
; SSE-NEXT:    paddsw %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddsw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddsw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> %x, <16 x i16> %y)
  ret <16 x i16> %z
}

define <32 x i16> @v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; SSE-LABEL: v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsw %xmm4, %xmm0
; SSE-NEXT:    paddsw %xmm5, %xmm1
; SSE-NEXT:    paddsw %xmm6, %xmm2
; SSE-NEXT:    paddsw %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddsw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddsw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddsw %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddsw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddsw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddsw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddsw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> %x, <32 x i16> %y)
  ret <32 x i16> %z
}

; Too narrow vectors, legalized by widening.

define void @v8i8(<8 x i8>* %px, <8 x i8>* %py, <8 x i8>* %pz) nounwind {
; SSE-LABEL: v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddsb %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpmovwb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <8 x i8>, <8 x i8>* %px
  %y = load <8 x i8>, <8 x i8>* %py
  %z = call <8 x i8> @llvm.sadd.sat.v8i8(<8 x i8> %x, <8 x i8> %y)
  store <8 x i8> %z, <8 x i8>* %pz
  ret void
}

define void @v4i8(<4 x i8>* %px, <4 x i8>* %py, <4 x i8>* %pz) nounwind {
; SSE-LABEL: v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddsb %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX512-NEXT:    vpmovdb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i8>, <4 x i8>* %px
  %y = load <4 x i8>, <4 x i8>* %py
  %z = call <4 x i8> @llvm.sadd.sat.v4i8(<4 x i8> %x, <4 x i8> %y)
  store <4 x i8> %z, <4 x i8>* %pz
  ret void
}

define void @v2i8(<2 x i8>* %px, <2 x i8>* %py, <2 x i8>* %pz) nounwind {
; SSE2-LABEL: v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    movzwl (%rsi), %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    paddsb %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, (%rdx)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    movzwl (%rsi), %eax
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    paddsb %xmm0, %xmm1
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movw %ax, (%rdx)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movzwl (%rsi), %eax
; SSE41-NEXT:    movd %eax, %xmm1
; SSE41-NEXT:    paddsb %xmm0, %xmm1
; SSE41-NEXT:    pextrw $0, %xmm1, (%rdx)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    movzwl (%rsi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movzwl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    movzwl (%rsi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movzwl (%rdi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm0
; AVX512-NEXT:    movzwl (%rsi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm1
; AVX512-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpmovqb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i8>, <2 x i8>* %px
  %y = load <2 x i8>, <2 x i8>* %py
  %z = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %x, <2 x i8> %y)
  store <2 x i8> %z, <2 x i8>* %pz
  ret void
}

define void @v4i16(<4 x i16>* %px, <4 x i16>* %py, <4 x i16>* %pz) nounwind {
; SSE-LABEL: v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddsw %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512-NEXT:    vpmovdw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i16>, <4 x i16>* %px
  %y = load <4 x i16>, <4 x i16>* %py
  %z = call <4 x i16> @llvm.sadd.sat.v4i16(<4 x i16> %x, <4 x i16> %y)
  store <4 x i16> %z, <4 x i16>* %pz
  ret void
}

define void @v2i16(<2 x i16>* %px, <2 x i16>* %py, <2 x i16>* %pz) nounwind {
; SSE-LABEL: v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddsw %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; AVX512-NEXT:    vpmovqw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i16>, <2 x i16>* %px
  %y = load <2 x i16>, <2 x i16>* %py
  %z = call <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16> %x, <2 x i16> %y)
  store <2 x i16> %z, <2 x i16>* %pz
  ret void
}

define <12 x i8> @v12i8(<12 x i8> %x, <12 x i8> %y) nounwind {
; SSE-LABEL: v12i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v12i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <12 x i8> @llvm.sadd.sat.v12i8(<12 x i8> %x, <12 x i8> %y)
  ret <12 x i8> %z
}

define void @v12i16(<12 x i16>* %px, <12 x i16>* %py, <12 x i16>* %pz) nounwind {
; SSE-LABEL: v12i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    paddsw (%rsi), %xmm0
; SSE-NEXT:    paddsw 16(%rsi), %xmm1
; SSE-NEXT:    movq %xmm1, 16(%rdx)
; SSE-NEXT:    movdqa %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v12i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vpaddsw 16(%rsi), %xmm1, %xmm1
; AVX1-NEXT:    vpaddsw (%rsi), %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX1-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v12i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpaddsw (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v12i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpaddsw (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %x = load <12 x i16>, <12 x i16>* %px
  %y = load <12 x i16>, <12 x i16>* %py
  %z = call <12 x i16> @llvm.sadd.sat.v12i16(<12 x i16> %x, <12 x i16> %y)
  store <12 x i16> %z, <12 x i16>* %pz
  ret void
}

; Scalarization

define void @v1i8(<1 x i8>* %px, <1 x i8>* %py, <1 x i8>* %pz) nounwind {
; SSE-LABEL: v1i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movb (%rdi), %cl
; SSE-NEXT:    movb (%rsi), %dil
; SSE-NEXT:    xorl %esi, %esi
; SSE-NEXT:    movl %ecx, %eax
; SSE-NEXT:    addb %dil, %al
; SSE-NEXT:    setns %sil
; SSE-NEXT:    addl $127, %esi
; SSE-NEXT:    addb %dil, %cl
; SSE-NEXT:    movzbl %cl, %eax
; SSE-NEXT:    cmovol %esi, %eax
; SSE-NEXT:    movb %al, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i8:
; AVX:       # %bb.0:
; AVX-NEXT:    movb (%rdi), %cl
; AVX-NEXT:    movb (%rsi), %dil
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %ecx, %eax
; AVX-NEXT:    addb %dil, %al
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $127, %esi
; AVX-NEXT:    addb %dil, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    cmovol %esi, %eax
; AVX-NEXT:    movb %al, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i8>, <1 x i8>* %px
  %y = load <1 x i8>, <1 x i8>* %py
  %z = call <1 x i8> @llvm.sadd.sat.v1i8(<1 x i8> %x, <1 x i8> %y)
  store <1 x i8> %z, <1 x i8>* %pz
  ret void
}

define void @v1i16(<1 x i16>* %px, <1 x i16>* %py, <1 x i16>* %pz) nounwind {
; SSE-LABEL: v1i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    movzwl (%rsi), %ecx
; SSE-NEXT:    xorl %esi, %esi
; SSE-NEXT:    movl %eax, %edi
; SSE-NEXT:    addw %cx, %di
; SSE-NEXT:    setns %sil
; SSE-NEXT:    addl $32767, %esi # imm = 0x7FFF
; SSE-NEXT:    addw %cx, %ax
; SSE-NEXT:    cmovol %esi, %eax
; SSE-NEXT:    movw %ax, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i16:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    movzwl (%rsi), %ecx
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %eax, %edi
; AVX-NEXT:    addw %cx, %di
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $32767, %esi # imm = 0x7FFF
; AVX-NEXT:    addw %cx, %ax
; AVX-NEXT:    cmovol %esi, %eax
; AVX-NEXT:    movw %ax, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i16>, <1 x i16>* %px
  %y = load <1 x i16>, <1 x i16>* %py
  %z = call <1 x i16> @llvm.sadd.sat.v1i16(<1 x i16> %x, <1 x i16> %y)
  store <1 x i16> %z, <1 x i16>* %pz
  ret void
}

; Promotion

define <16 x i4> @v16i4(<16 x i4> %x, <16 x i4> %y) nounwind {
; SSE-LABEL: v16i4:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $4, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $4, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    psrlw $4, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psubb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i4:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i4> @llvm.sadd.sat.v16i4(<16 x i4> %x, <16 x i4> %y)
  ret <16 x i4> %z
}

define <16 x i1> @v16i1(<16 x i1> %x, <16 x i1> %y) nounwind {
; SSE-LABEL: v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $7, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddsb %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX512-NEXT:    vpmovb2m %xmm1, %k0
; AVX512-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512-NEXT:    vpmovb2m %xmm0, %k1
; AVX512-NEXT:    korw %k0, %k1, %k0
; AVX512-NEXT:    vpmovm2b %k0, %xmm0
; AVX512-NEXT:    retq
  %z = call <16 x i1> @llvm.sadd.sat.v16i1(<16 x i1> %x, <16 x i1> %y)
  ret <16 x i1> %z
}

; Expanded

define <2 x i32> @v2i32(<2 x i32> %x, <2 x i32> %y) nounwind {
; SSE2-LABEL: v2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllq $32, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-NEXT:    psllq $32, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    paddq %xmm1, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm5
; SSE2-NEXT:    pxor %xmm1, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm1
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    pand %xmm2, %xmm4
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,3,2,3]
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    psllq $32, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSSE3-NEXT:    psllq $32, %xmm0
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    paddq %xmm1, %xmm0
; SSSE3-NEXT:    por %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm1, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSSE3-NEXT:    por %xmm2, %xmm3
; SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    pand %xmm6, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    por %xmm3, %xmm5
; SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,0,3,2]
; SSSE3-NEXT:    pand %xmm4, %xmm3
; SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSSE3-NEXT:    por %xmm2, %xmm4
; SSSE3-NEXT:    movdqa %xmm2, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm7, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm4, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; SSSE3-NEXT:    pand %xmm1, %xmm2
; SSSE3-NEXT:    pandn %xmm3, %xmm2
; SSSE3-NEXT:    movdqa %xmm4, %xmm1
; SSSE3-NEXT:    pandn {{.*}}(%rip), %xmm1
; SSSE3-NEXT:    pand {{.*}}(%rip), %xmm4
; SSSE3-NEXT:    por %xmm1, %xmm4
; SSSE3-NEXT:    pand %xmm2, %xmm4
; SSSE3-NEXT:    pandn %xmm0, %xmm2
; SSSE3-NEXT:    por %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,3,2,3]
; SSSE3-NEXT:    psrad $31, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    psllq $32, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE41-NEXT:    psllq $32, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm3
; SSE41-NEXT:    paddq %xmm1, %xmm2
; SSE41-NEXT:    por %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm1, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm4
; SSE41-NEXT:    por %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE41-NEXT:    pand %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE41-NEXT:    por %xmm3, %xmm5
; SSE41-NEXT:    pxor %xmm1, %xmm5
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm4
; SSE41-NEXT:    movdqa %xmm2, %xmm3
; SSE41-NEXT:    por %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE41-NEXT:    pand %xmm7, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm1
; SSE41-NEXT:    pandn %xmm4, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; SSE41-NEXT:    blendvpd %xmm0, {{.*}}(%rip), %xmm3
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE41-NEXT:    psrad $31, %xmm2
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpxor %xmm4, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vblendvpd %xmm1, {{.*}}(%rip), %xmm3, %xmm1
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm5
; AVX2-NEXT:    vpxor %xmm4, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqq %xmm3, %xmm5, %xmm3
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm1
; AVX2-NEXT:    vpxor %xmm4, %xmm1, %xmm2
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm5, %xmm2
; AVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vmovapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vblendvpd %xmm1, {{.*}}(%rip), %xmm3, %xmm1
; AVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpnltq %xmm2, %xmm1, %k0
; AVX512-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnltq %xmm2, %xmm0, %k1
; AVX512-NEXT:    kxorw %k0, %k1, %k0
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnltq %xmm2, %xmm0, %k2
; AVX512-NEXT:    kxorw %k2, %k1, %k1
; AVX512-NEXT:    kandnw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtq %xmm0, %xmm2, %k2
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm1 = [9223372036854775808,9223372036854775808]
; AVX512-NEXT:    vmovdqa64 {{.*}}(%rip), %xmm1 {%k2}
; AVX512-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; AVX512-NEXT:    vpsraq $32, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %z = call <2 x i32> @llvm.sadd.sat.v2i32(<2 x i32> %x, <2 x i32> %y)
  ret <2 x i32> %z
}

define <4 x i32> @v4i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; SSE2-LABEL: v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE2-NEXT:    pxor %xmm2, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE2-NEXT:    pxor %xmm3, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm2
; SSE2-NEXT:    pandn %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm1
; SSE2-NEXT:    psrld $1, %xmm3
; SSE2-NEXT:    por %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm5
; SSSE3-NEXT:    pxor %xmm2, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm4
; SSSE3-NEXT:    paddd %xmm1, %xmm0
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm3
; SSSE3-NEXT:    pxor %xmm3, %xmm2
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSSE3-NEXT:    movdqa %xmm3, %xmm1
; SSSE3-NEXT:    pandn {{.*}}(%rip), %xmm1
; SSSE3-NEXT:    psrld $1, %xmm3
; SSSE3-NEXT:    por %xmm1, %xmm3
; SSSE3-NEXT:    pand %xmm2, %xmm3
; SSSE3-NEXT:    pandn %xmm0, %xmm2
; SSSE3-NEXT:    por %xmm3, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE41-NEXT:    pxor %xmm3, %xmm4
; SSE41-NEXT:    pxor %xmm5, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE41-NEXT:    pxor %xmm3, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE41-NEXT:    paddd %xmm1, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm3
; SSE41-NEXT:    pandn %xmm4, %xmm3
; SSE41-NEXT:    movaps {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    blendvps %xmm0, {{.*}}(%rip), %xmm1
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpxor %xmm4, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtd %xmm0, %xmm2, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovaps {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vblendvps %xmm1, {{.*}}(%rip), %xmm3, %xmm1
; AVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtd %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpgtd %xmm0, %xmm2, %xmm5
; AVX2-NEXT:    vpxor %xmm4, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm5, %xmm3
; AVX2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtd %xmm0, %xmm2, %xmm1
; AVX2-NEXT:    vpxor %xmm4, %xmm1, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm5, %xmm2
; AVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vblendvps %xmm1, %xmm3, %xmm4, %xmm1
; AVX2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpnltd %xmm2, %xmm1, %k0
; AVX512-NEXT:    vpcmpnltd %xmm2, %xmm0, %k1
; AVX512-NEXT:    kxorw %k0, %k1, %k0
; AVX512-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnltd %xmm2, %xmm0, %k2
; AVX512-NEXT:    kxorw %k2, %k1, %k1
; AVX512-NEXT:    kandnw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtd %xmm0, %xmm2, %k2
; AVX512-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; AVX512-NEXT:    vpbroadcastd {{.*}}(%rip), %xmm1 {%k2}
; AVX512-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1}
; AVX512-NEXT:    retq
  %z = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %z
}

define <8 x i32> @v8i32(<8 x i32> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: v8i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm8
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm7
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm7
; SSE2-NEXT:    paddd %xmm2, %xmm8
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm5, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    pandn %xmm7, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm7
; SSE2-NEXT:    pandn %xmm4, %xmm7
; SSE2-NEXT:    psrld $1, %xmm2
; SSE2-NEXT:    por %xmm7, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn %xmm8, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE2-NEXT:    pxor %xmm5, %xmm2
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm7
; SSE2-NEXT:    pxor %xmm5, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm7, %xmm2
; SSE2-NEXT:    paddd %xmm3, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE2-NEXT:    pxor %xmm6, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm7, %xmm5
; SSE2-NEXT:    pandn %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm6, %xmm2
; SSE2-NEXT:    pandn %xmm4, %xmm2
; SSE2-NEXT:    psrld $1, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pandn %xmm1, %xmm5
; SSE2-NEXT:    por %xmm6, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v8i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa %xmm0, %xmm8
; SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm7
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm5
; SSSE3-NEXT:    pxor %xmm5, %xmm7
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm7
; SSSE3-NEXT:    paddd %xmm2, %xmm8
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm8, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm5, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm0
; SSSE3-NEXT:    pandn %xmm7, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm7
; SSSE3-NEXT:    pandn %xmm4, %xmm7
; SSSE3-NEXT:    psrld $1, %xmm2
; SSSE3-NEXT:    por %xmm7, %xmm2
; SSSE3-NEXT:    pand %xmm0, %xmm2
; SSSE3-NEXT:    pandn %xmm8, %xmm0
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm2
; SSSE3-NEXT:    pxor %xmm5, %xmm2
; SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm7
; SSSE3-NEXT:    pxor %xmm5, %xmm7
; SSSE3-NEXT:    pcmpeqd %xmm7, %xmm2
; SSSE3-NEXT:    paddd %xmm3, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm6
; SSSE3-NEXT:    pxor %xmm6, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm7, %xmm5
; SSSE3-NEXT:    pandn %xmm2, %xmm5
; SSSE3-NEXT:    movdqa %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSSE3-NEXT:    psrld $1, %xmm6
; SSSE3-NEXT:    por %xmm2, %xmm6
; SSSE3-NEXT:    pand %xmm5, %xmm6
; SSSE3-NEXT:    pandn %xmm1, %xmm5
; SSSE3-NEXT:    por %xmm6, %xmm5
; SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v8i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm6
; SSE41-NEXT:    pxor %xmm8, %xmm8
; SSE41-NEXT:    pxor %xmm7, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE41-NEXT:    pxor %xmm4, %xmm7
; SSE41-NEXT:    pxor %xmm5, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm7
; SSE41-NEXT:    paddd %xmm2, %xmm6
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm2
; SSE41-NEXT:    pandn %xmm7, %xmm2
; SSE41-NEXT:    movaps {{.*#+}} xmm9 = [2147483647,2147483647,2147483647,2147483647]
; SSE41-NEXT:    movaps {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movaps %xmm5, %xmm7
; SSE41-NEXT:    blendvps %xmm0, %xmm9, %xmm7
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm7, %xmm6
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm4, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    paddd %xmm3, %xmm1
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm8
; SSE41-NEXT:    pxor %xmm8, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE41-NEXT:    pandn %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm9, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    movaps %xmm6, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpcmpgtd %xmm6, %xmm3, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm7
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm8
; AVX1-NEXT:    vpcmpgtd %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm9
; AVX1-NEXT:    vpcmpgtd %xmm0, %xmm3, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm9, %xmm4, %xmm9
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm9, %ymm8
; AVX1-NEXT:    vpaddd %xmm2, %xmm6, %xmm9
; AVX1-NEXT:    vpcmpgtd %xmm9, %xmm3, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm7, %xmm2
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtd %xmm0, %xmm3, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vandnps %ymm8, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps {{.*#+}} ymm3 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vblendvps %ymm1, {{.*}}(%rip), %ymm3, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX1-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm2, %ymm5
; AVX2-NEXT:    vpxor %ymm4, %ymm5, %ymm5
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm2, %ymm1
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm5, %ymm2
; AVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm4 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vblendvps %ymm1, %ymm3, %ymm4, %ymm1
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpnltd %ymm2, %ymm1, %k0
; AVX512-NEXT:    vpcmpnltd %ymm2, %ymm0, %k1
; AVX512-NEXT:    kxorw %k0, %k1, %k0
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpnltd %ymm2, %ymm0, %k2
; AVX512-NEXT:    kxorw %k2, %k1, %k1
; AVX512-NEXT:    kandnw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtd %ymm0, %ymm2, %k2
; AVX512-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX512-NEXT:    vpbroadcastd {{.*}}(%rip), %ymm1 {%k2}
; AVX512-NEXT:    vmovdqa32 %ymm1, %ymm0 {%k1}
; AVX512-NEXT:    retq
  %z = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> %x, <8 x i32> %y)
  ret <8 x i32> %z
}

define <16 x i32> @v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; SSE2-LABEL: v16i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm11
; SSE2-NEXT:    pxor %xmm10, %xmm10
; SSE2-NEXT:    pxor %xmm12, %xmm12
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm12
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm9
; SSE2-NEXT:    pxor %xmm9, %xmm12
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm9, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm12
; SSE2-NEXT:    paddd %xmm4, %xmm11
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    pxor %xmm9, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pandn %xmm12, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm12 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    pandn %xmm12, %xmm1
; SSE2-NEXT:    psrld $1, %xmm4
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    pand %xmm0, %xmm4
; SSE2-NEXT:    pandn %xmm11, %xmm0
; SSE2-NEXT:    por %xmm4, %xmm0
; SSE2-NEXT:    pxor %xmm11, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm11
; SSE2-NEXT:    pxor %xmm9, %xmm11
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm11
; SSE2-NEXT:    paddd %xmm5, %xmm8
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    pxor %xmm9, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    pandn %xmm11, %xmm1
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm12, %xmm4
; SSE2-NEXT:    psrld $1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    pandn %xmm8, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2-NEXT:    pxor %xmm9, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE2-NEXT:    paddd %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm8
; SSE2-NEXT:    pxor %xmm9, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm8
; SSE2-NEXT:    pandn %xmm4, %xmm8
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pandn %xmm12, %xmm4
; SSE2-NEXT:    psrld $1, %xmm6
; SSE2-NEXT:    por %xmm4, %xmm6
; SSE2-NEXT:    pand %xmm8, %xmm6
; SSE2-NEXT:    pandn %xmm2, %xmm8
; SSE2-NEXT:    por %xmm6, %xmm8
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm2
; SSE2-NEXT:    pxor %xmm9, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE2-NEXT:    paddd %xmm7, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm10
; SSE2-NEXT:    pxor %xmm10, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm9
; SSE2-NEXT:    pandn %xmm2, %xmm9
; SSE2-NEXT:    movdqa %xmm10, %xmm2
; SSE2-NEXT:    pandn %xmm12, %xmm2
; SSE2-NEXT:    psrld $1, %xmm10
; SSE2-NEXT:    por %xmm2, %xmm10
; SSE2-NEXT:    pand %xmm9, %xmm10
; SSE2-NEXT:    pandn %xmm3, %xmm9
; SSE2-NEXT:    por %xmm10, %xmm9
; SSE2-NEXT:    movdqa %xmm8, %xmm2
; SSE2-NEXT:    movdqa %xmm9, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v16i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa %xmm1, %xmm8
; SSSE3-NEXT:    movdqa %xmm0, %xmm11
; SSSE3-NEXT:    pxor %xmm10, %xmm10
; SSSE3-NEXT:    pxor %xmm12, %xmm12
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm12
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm9
; SSSE3-NEXT:    pxor %xmm9, %xmm12
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    pxor %xmm9, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm12
; SSSE3-NEXT:    paddd %xmm4, %xmm11
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm11, %xmm4
; SSSE3-NEXT:    movdqa %xmm4, %xmm0
; SSSE3-NEXT:    pxor %xmm9, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSSE3-NEXT:    pandn %xmm12, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm12 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm4, %xmm1
; SSSE3-NEXT:    pandn %xmm12, %xmm1
; SSSE3-NEXT:    psrld $1, %xmm4
; SSSE3-NEXT:    por %xmm1, %xmm4
; SSSE3-NEXT:    pand %xmm0, %xmm4
; SSSE3-NEXT:    pandn %xmm11, %xmm0
; SSSE3-NEXT:    por %xmm4, %xmm0
; SSSE3-NEXT:    pxor %xmm11, %xmm11
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm11
; SSSE3-NEXT:    pxor %xmm9, %xmm11
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm8, %xmm4
; SSSE3-NEXT:    pxor %xmm9, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm11
; SSSE3-NEXT:    paddd %xmm5, %xmm8
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm8, %xmm5
; SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSSE3-NEXT:    pxor %xmm9, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm1
; SSSE3-NEXT:    pandn %xmm11, %xmm1
; SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSSE3-NEXT:    pandn %xmm12, %xmm4
; SSSE3-NEXT:    psrld $1, %xmm5
; SSSE3-NEXT:    por %xmm4, %xmm5
; SSSE3-NEXT:    pand %xmm1, %xmm5
; SSSE3-NEXT:    pandn %xmm8, %xmm1
; SSSE3-NEXT:    por %xmm5, %xmm1
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm4
; SSSE3-NEXT:    pxor %xmm9, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSSE3-NEXT:    pxor %xmm9, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm4
; SSSE3-NEXT:    paddd %xmm6, %xmm2
; SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm6
; SSSE3-NEXT:    movdqa %xmm6, %xmm8
; SSSE3-NEXT:    pxor %xmm9, %xmm8
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm8
; SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSSE3-NEXT:    movdqa %xmm6, %xmm4
; SSSE3-NEXT:    pandn %xmm12, %xmm4
; SSSE3-NEXT:    psrld $1, %xmm6
; SSSE3-NEXT:    por %xmm4, %xmm6
; SSSE3-NEXT:    pand %xmm8, %xmm6
; SSSE3-NEXT:    pandn %xmm2, %xmm8
; SSSE3-NEXT:    por %xmm6, %xmm8
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm7, %xmm2
; SSSE3-NEXT:    pxor %xmm9, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSSE3-NEXT:    pxor %xmm9, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm2
; SSSE3-NEXT:    paddd %xmm7, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm10
; SSSE3-NEXT:    pxor %xmm10, %xmm9
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm9
; SSSE3-NEXT:    pandn %xmm2, %xmm9
; SSSE3-NEXT:    movdqa %xmm10, %xmm2
; SSSE3-NEXT:    pandn %xmm12, %xmm2
; SSSE3-NEXT:    psrld $1, %xmm10
; SSSE3-NEXT:    por %xmm2, %xmm10
; SSSE3-NEXT:    pand %xmm9, %xmm10
; SSSE3-NEXT:    pandn %xmm3, %xmm9
; SSSE3-NEXT:    por %xmm10, %xmm9
; SSSE3-NEXT:    movdqa %xmm8, %xmm2
; SSSE3-NEXT:    movdqa %xmm9, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v16i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm9
; SSE41-NEXT:    pxor %xmm8, %xmm8
; SSE41-NEXT:    pxor %xmm11, %xmm11
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm11
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm10
; SSE41-NEXT:    pxor %xmm10, %xmm11
; SSE41-NEXT:    pxor %xmm12, %xmm12
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm12
; SSE41-NEXT:    pxor %xmm10, %xmm12
; SSE41-NEXT:    pcmpeqd %xmm12, %xmm11
; SSE41-NEXT:    paddd %xmm4, %xmm9
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm9, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm10, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm12, %xmm4
; SSE41-NEXT:    pandn %xmm11, %xmm4
; SSE41-NEXT:    movaps {{.*#+}} xmm12 = [2147483647,2147483647,2147483647,2147483647]
; SSE41-NEXT:    movaps {{.*#+}} xmm11 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movaps %xmm11, %xmm13
; SSE41-NEXT:    blendvps %xmm0, %xmm12, %xmm13
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm13, %xmm9
; SSE41-NEXT:    xorps %xmm13, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm13
; SSE41-NEXT:    pxor %xmm10, %xmm13
; SSE41-NEXT:    pxor %xmm14, %xmm14
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm14
; SSE41-NEXT:    pxor %xmm10, %xmm14
; SSE41-NEXT:    pcmpeqd %xmm14, %xmm13
; SSE41-NEXT:    paddd %xmm5, %xmm1
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm10, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm14, %xmm4
; SSE41-NEXT:    pandn %xmm13, %xmm4
; SSE41-NEXT:    movaps %xmm11, %xmm5
; SSE41-NEXT:    blendvps %xmm0, %xmm12, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    pxor %xmm13, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm13
; SSE41-NEXT:    pxor %xmm10, %xmm13
; SSE41-NEXT:    xorps %xmm5, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE41-NEXT:    pxor %xmm10, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm13
; SSE41-NEXT:    paddd %xmm6, %xmm2
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm10, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE41-NEXT:    pandn %xmm13, %xmm4
; SSE41-NEXT:    movaps %xmm11, %xmm5
; SSE41-NEXT:    blendvps %xmm0, %xmm12, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pxor %xmm10, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE41-NEXT:    paddd %xmm7, %xmm3
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm8
; SSE41-NEXT:    pxor %xmm8, %xmm10
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm10
; SSE41-NEXT:    pandn %xmm0, %xmm10
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm12, %xmm11
; SSE41-NEXT:    movdqa %xmm10, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm11, %xmm3
; SSE41-NEXT:    movaps %xmm9, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm9
; AVX1-NEXT:    vpxor %xmm12, %xmm12, %xmm12
; AVX1-NEXT:    vpcmpgtd %xmm9, %xmm12, %xmm7
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX1-NEXT:    vpcmpgtd %xmm7, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm10
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm10, %xmm8
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm11
; AVX1-NEXT:    vpcmpgtd %xmm0, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm11, %xmm6, %xmm11
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX1-NEXT:    vpaddd %xmm9, %xmm7, %xmm9
; AVX1-NEXT:    vpcmpgtd %xmm9, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm10, %xmm10
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtd %xmm0, %xmm12, %xmm2
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm4, %ymm4
; AVX1-NEXT:    vandnps %ymm8, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm2, %ymm7
; AVX1-NEXT:    vmovaps {{.*#+}} ymm8 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm10 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vblendvps %ymm7, %ymm8, %ymm10, %ymm7
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX1-NEXT:    vblendvps %ymm4, %ymm7, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm7
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpcmpgtd %xmm2, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm7, %xmm6, %xmm9
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm11
; AVX1-NEXT:    vpcmpgtd %xmm1, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm7
; AVX1-NEXT:    vpcmpeqd %xmm11, %xmm7, %xmm11
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm11, %ymm9
; AVX1-NEXT:    vpaddd %xmm4, %xmm2, %xmm11
; AVX1-NEXT:    vpcmpgtd %xmm11, %xmm12, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtd %xmm1, %xmm12, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm2
; AVX1-NEXT:    vandnps %ymm9, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-NEXT:    vblendvps %ymm3, %ymm8, %ymm10, %ymm3
; AVX1-NEXT:    vinsertf128 $1, %xmm11, %ymm1, %ymm1
; AVX1-NEXT:    vblendvps %ymm2, %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpgtd %ymm2, %ymm4, %ymm5
; AVX2-NEXT:    vpcmpeqd %ymm6, %ymm6, %ymm6
; AVX2-NEXT:    vpxor %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm4, %ymm7
; AVX2-NEXT:    vpxor %ymm6, %ymm7, %ymm7
; AVX2-NEXT:    vpcmpeqd %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm6, %ymm2, %ymm8
; AVX2-NEXT:    vpcmpeqd %ymm8, %ymm7, %ymm7
; AVX2-NEXT:    vpandn %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm7 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm8 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vblendvps %ymm2, %ymm7, %ymm8, %ymm2
; AVX2-NEXT:    vblendvps %ymm5, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtd %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm6, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm4, %ymm5
; AVX2-NEXT:    vpxor %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm5, %ymm2
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm4, %ymm3
; AVX2-NEXT:    vpxor %ymm6, %ymm3, %ymm4
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpandn %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vblendvps %ymm3, %ymm7, %ymm8, %ymm3
; AVX2-NEXT:    vblendvps %ymm2, %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpnltd %zmm2, %zmm1, %k0
; AVX512-NEXT:    vpcmpnltd %zmm2, %zmm0, %k1
; AVX512-NEXT:    kxorw %k0, %k1, %k0
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpcmpnltd %zmm2, %zmm0, %k2
; AVX512-NEXT:    kxorw %k2, %k1, %k1
; AVX512-NEXT:    kandnw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtd %zmm0, %zmm2, %k2
; AVX512-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX512-NEXT:    vpbroadcastd {{.*}}(%rip), %zmm1 {%k2}
; AVX512-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %z = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> %x, <16 x i32> %y)
  ret <16 x i32> %z
}

define <2 x i64> @v2i64(<2 x i64> %x, <2 x i64> %y) nounwind {
; SSE2-LABEL: v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    paddq %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    pxor %xmm5, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm4
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    pandn %xmm3, %xmm1
; SSE2-NEXT:    movdqa %xmm4, %xmm2
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm2
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    pandn %xmm0, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    paddq %xmm1, %xmm0
; SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm1, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm5
; SSSE3-NEXT:    pxor %xmm5, %xmm4
; SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    pand %xmm6, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    por %xmm3, %xmm1
; SSSE3-NEXT:    pxor %xmm5, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,0,3,2]
; SSSE3-NEXT:    pand %xmm4, %xmm3
; SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSSE3-NEXT:    movdqa %xmm2, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm7, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,0,3,2]
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm3, %xmm1
; SSSE3-NEXT:    movdqa %xmm4, %xmm2
; SSSE3-NEXT:    pandn {{.*}}(%rip), %xmm2
; SSSE3-NEXT:    pand {{.*}}(%rip), %xmm4
; SSSE3-NEXT:    por %xmm2, %xmm4
; SSSE3-NEXT:    pand %xmm1, %xmm4
; SSSE3-NEXT:    pandn %xmm0, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm2, %xmm3
; SSE41-NEXT:    paddq %xmm1, %xmm2
; SSE41-NEXT:    pxor %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm1, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm4
; SSE41-NEXT:    pxor %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE41-NEXT:    pand %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE41-NEXT:    por %xmm3, %xmm5
; SSE41-NEXT:    pxor %xmm1, %xmm5
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm4
; SSE41-NEXT:    movdqa %xmm2, %xmm3
; SSE41-NEXT:    pxor %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE41-NEXT:    pand %xmm7, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm1
; SSE41-NEXT:    pandn %xmm4, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; SSE41-NEXT:    blendvpd %xmm0, {{.*}}(%rip), %xmm3
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpxor %xmm4, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vmovapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vblendvpd %xmm1, {{.*}}(%rip), %xmm3, %xmm1
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm5
; AVX2-NEXT:    vpxor %xmm4, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqq %xmm3, %xmm5, %xmm3
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm1
; AVX2-NEXT:    vpxor %xmm4, %xmm1, %xmm2
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm5, %xmm2
; AVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vmovapd {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vblendvpd %xmm1, {{.*}}(%rip), %xmm3, %xmm1
; AVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpnltq %xmm2, %xmm1, %k0
; AVX512-NEXT:    vpcmpnltq %xmm2, %xmm0, %k1
; AVX512-NEXT:    kxorw %k0, %k1, %k0
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpnltq %xmm2, %xmm0, %k2
; AVX512-NEXT:    kxorw %k2, %k1, %k1
; AVX512-NEXT:    kandnw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtq %xmm0, %xmm2, %k2
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm1 = [9223372036854775808,9223372036854775808]
; AVX512-NEXT:    vmovdqa64 {{.*}}(%rip), %xmm1 {%k2}
; AVX512-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; AVX512-NEXT:    retq
  %z = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> %x, <2 x i64> %y)
  ret <2 x i64> %z
}

define <4 x i64> @v4i64(<4 x i64> %x, <4 x i64> %y) nounwind {
; SSE2-LABEL: v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [2147483648,2147483648]
; SSE2-NEXT:    paddq %xmm2, %xmm9
; SSE2-NEXT:    pxor %xmm10, %xmm2
; SSE2-NEXT:    movdqa %xmm10, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-NEXT:    pxor %xmm6, %xmm7
; SSE2-NEXT:    pxor %xmm10, %xmm0
; SSE2-NEXT:    movdqa %xmm10, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm6, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm4
; SSE2-NEXT:    movdqa %xmm9, %xmm0
; SSE2-NEXT:    pxor %xmm10, %xmm0
; SSE2-NEXT:    movdqa %xmm10, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm0, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm7
; SSE2-NEXT:    pxor %xmm6, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    pandn %xmm4, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    pandn %xmm11, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [9223372036854775807,9223372036854775807]
; SSE2-NEXT:    pand %xmm8, %xmm5
; SSE2-NEXT:    por %xmm2, %xmm5
; SSE2-NEXT:    pand %xmm0, %xmm5
; SSE2-NEXT:    pandn %xmm9, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    paddq %xmm3, %xmm1
; SSE2-NEXT:    pxor %xmm10, %xmm3
; SSE2-NEXT:    movdqa %xmm10, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm6, %xmm4
; SSE2-NEXT:    pxor %xmm10, %xmm2
; SSE2-NEXT:    movdqa %xmm10, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm5
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pxor %xmm10, %xmm2
; SSE2-NEXT:    movdqa %xmm10, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,0,3,2]
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pandn %xmm5, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    pandn %xmm11, %xmm3
; SSE2-NEXT:    pand %xmm8, %xmm4
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm2, %xmm4
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa %xmm0, %xmm9
; SSSE3-NEXT:    movdqa {{.*#+}} xmm10 = [2147483648,2147483648]
; SSSE3-NEXT:    paddq %xmm2, %xmm9
; SSSE3-NEXT:    pxor %xmm10, %xmm2
; SSSE3-NEXT:    movdqa %xmm10, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm10, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pand %xmm7, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm7
; SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSSE3-NEXT:    pxor %xmm6, %xmm7
; SSSE3-NEXT:    pxor %xmm10, %xmm0
; SSSE3-NEXT:    movdqa %xmm10, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm10, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pand %xmm4, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    por %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm6, %xmm2
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm7
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,0,3,2]
; SSSE3-NEXT:    pand %xmm7, %xmm4
; SSSE3-NEXT:    movdqa %xmm9, %xmm0
; SSSE3-NEXT:    pxor %xmm10, %xmm0
; SSSE3-NEXT:    movdqa %xmm10, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm7
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm10, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSSE3-NEXT:    por %xmm0, %xmm5
; SSSE3-NEXT:    movdqa %xmm5, %xmm7
; SSSE3-NEXT:    pxor %xmm6, %xmm7
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm7
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[1,0,3,2]
; SSSE3-NEXT:    pand %xmm7, %xmm0
; SSSE3-NEXT:    pandn %xmm4, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSSE3-NEXT:    movdqa %xmm5, %xmm2
; SSSE3-NEXT:    pandn %xmm11, %xmm2
; SSSE3-NEXT:    movdqa {{.*#+}} xmm8 = [9223372036854775807,9223372036854775807]
; SSSE3-NEXT:    pand %xmm8, %xmm5
; SSSE3-NEXT:    por %xmm2, %xmm5
; SSSE3-NEXT:    pand %xmm0, %xmm5
; SSSE3-NEXT:    pandn %xmm9, %xmm0
; SSSE3-NEXT:    por %xmm5, %xmm0
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    paddq %xmm3, %xmm1
; SSSE3-NEXT:    pxor %xmm10, %xmm3
; SSSE3-NEXT:    movdqa %xmm10, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm10, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm3, %xmm4
; SSSE3-NEXT:    pxor %xmm6, %xmm4
; SSSE3-NEXT:    pxor %xmm10, %xmm2
; SSSE3-NEXT:    movdqa %xmm10, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm10, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm3
; SSSE3-NEXT:    pxor %xmm6, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,0,3,2]
; SSSE3-NEXT:    pand %xmm4, %xmm5
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    pxor %xmm10, %xmm2
; SSSE3-NEXT:    movdqa %xmm10, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm10, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pand %xmm7, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm4, %xmm6
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,0,3,2]
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm5, %xmm2
; SSSE3-NEXT:    movdqa %xmm4, %xmm3
; SSSE3-NEXT:    pandn %xmm11, %xmm3
; SSSE3-NEXT:    pand %xmm8, %xmm4
; SSSE3-NEXT:    por %xmm3, %xmm4
; SSSE3-NEXT:    pand %xmm2, %xmm4
; SSSE3-NEXT:    pandn %xmm1, %xmm2
; SSSE3-NEXT:    por %xmm4, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm9
; SSE41-NEXT:    movdqa {{.*#+}} xmm10 = [2147483648,2147483648]
; SSE41-NEXT:    paddq %xmm2, %xmm9
; SSE41-NEXT:    pxor %xmm10, %xmm2
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pand %xmm7, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm2, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE41-NEXT:    pxor %xmm4, %xmm7
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[1,1,3,3]
; SSE41-NEXT:    por %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm7
; SSE41-NEXT:    movdqa %xmm9, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm8 = xmm2[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm8, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm2
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm2
; SSE41-NEXT:    pandn %xmm7, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm8 = [9223372036854775807,9223372036854775807]
; SSE41-NEXT:    movapd {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSE41-NEXT:    movapd %xmm11, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm9
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    paddq %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm10, %xmm3
; SSE41-NEXT:    movdqa %xmm10, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    por %xmm3, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm2
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm3
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE41-NEXT:    por %xmm0, %xmm3
; SSE41-NEXT:    pxor %xmm4, %xmm3
; SSE41-NEXT:    pcmpeqq %xmm3, %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,3,3]
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm0, %xmm4
; SSE41-NEXT:    pcmpeqq %xmm3, %xmm4
; SSE41-NEXT:    pandn %xmm2, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm11
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm11, %xmm1
; SSE41-NEXT:    movapd %xmm9, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm3, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm7
; AVX1-NEXT:    vpcmpeqq %xmm4, %xmm7, %xmm8
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm9
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm3, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm9, %xmm4, %xmm9
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm9, %ymm8
; AVX1-NEXT:    vpaddq %xmm2, %xmm6, %xmm9
; AVX1-NEXT:    vpcmpgtq %xmm9, %xmm3, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm7, %xmm2
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm3, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vandnpd %ymm8, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX1-NEXT:    vmovapd {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vblendvpd %ymm1, {{.*}}(%rip), %ymm3, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX1-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm5
; AVX2-NEXT:    vpxor %ymm4, %ymm5, %ymm5
; AVX2-NEXT:    vpcmpeqq %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm1
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm5, %ymm2
; AVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vblendvpd %ymm1, %ymm3, %ymm4, %ymm1
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpnltq %ymm2, %ymm1, %k0
; AVX512-NEXT:    vpcmpnltq %ymm2, %ymm0, %k1
; AVX512-NEXT:    kxorw %k0, %k1, %k0
; AVX512-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpcmpnltq %ymm2, %ymm0, %k2
; AVX512-NEXT:    kxorw %k2, %k1, %k1
; AVX512-NEXT:    kandnw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtq %ymm0, %ymm2, %k2
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX512-NEXT:    vpbroadcastq {{.*}}(%rip), %ymm1 {%k2}
; AVX512-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1}
; AVX512-NEXT:    retq
  %z = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> %x, <4 x i64> %y)
  ret <4 x i64> %z
}

define <8 x i64> @v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; SSE2-LABEL: v8i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm13
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [2147483648,2147483648]
; SSE2-NEXT:    paddq %xmm4, %xmm13
; SSE2-NEXT:    pxor %xmm9, %xmm4
; SSE2-NEXT:    movdqa %xmm9, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm10, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm10
; SSE2-NEXT:    pxor %xmm10, %xmm1
; SSE2-NEXT:    pxor %xmm9, %xmm0
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm11 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm11, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm14 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm0, %xmm14
; SSE2-NEXT:    pxor %xmm10, %xmm14
; SSE2-NEXT:    pcmpeqd %xmm14, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm11 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm11
; SSE2-NEXT:    movdqa %xmm13, %xmm0
; SSE2-NEXT:    pxor %xmm9, %xmm0
; SSE2-NEXT:    movdqa %xmm9, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm1[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm12, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm10, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm14, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn %xmm11, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    pandn %xmm11, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm12 = [9223372036854775807,9223372036854775807]
; SSE2-NEXT:    pand %xmm12, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pandn %xmm13, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm8, %xmm1
; SSE2-NEXT:    paddq %xmm5, %xmm8
; SSE2-NEXT:    pxor %xmm9, %xmm5
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    pand %xmm13, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    pxor %xmm10, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm1
; SSE2-NEXT:    movdqa %xmm9, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm13 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm13, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm15 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm15
; SSE2-NEXT:    pxor %xmm10, %xmm15
; SSE2-NEXT:    pcmpeqd %xmm15, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm13
; SSE2-NEXT:    movdqa %xmm8, %xmm1
; SSE2-NEXT:    pxor %xmm9, %xmm1
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm14 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm14, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pxor %xmm10, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm15, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    pandn %xmm13, %xmm1
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pandn %xmm11, %xmm5
; SSE2-NEXT:    pand %xmm12, %xmm4
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    pandn %xmm8, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    paddq %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm9, %xmm6
; SSE2-NEXT:    movdqa %xmm9, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm8, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm5
; SSE2-NEXT:    pxor %xmm10, %xmm5
; SSE2-NEXT:    pxor %xmm9, %xmm4
; SSE2-NEXT:    movdqa %xmm9, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm8, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm4, %xmm6
; SSE2-NEXT:    pxor %xmm10, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm8
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pxor %xmm9, %xmm5
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    pand %xmm13, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pxor %xmm10, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pandn %xmm8, %xmm6
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pandn %xmm11, %xmm5
; SSE2-NEXT:    pand %xmm12, %xmm4
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pandn %xmm2, %xmm6
; SSE2-NEXT:    por %xmm4, %xmm6
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    paddq %xmm7, %xmm3
; SSE2-NEXT:    pxor %xmm9, %xmm7
; SSE2-NEXT:    movdqa %xmm9, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm7, %xmm4
; SSE2-NEXT:    pxor %xmm10, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm2
; SSE2-NEXT:    movdqa %xmm9, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm5
; SSE2-NEXT:    pxor %xmm10, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm4
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm8, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm4, %xmm7
; SSE2-NEXT:    pxor %xmm7, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm10, %xmm5
; SSE2-NEXT:    pandn %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm7, %xmm2
; SSE2-NEXT:    pandn %xmm11, %xmm2
; SSE2-NEXT:    pand %xmm12, %xmm7
; SSE2-NEXT:    por %xmm2, %xmm7
; SSE2-NEXT:    pand %xmm5, %xmm7
; SSE2-NEXT:    pandn %xmm3, %xmm5
; SSE2-NEXT:    por %xmm7, %xmm5
; SSE2-NEXT:    movdqa %xmm6, %xmm2
; SSE2-NEXT:    movdqa %xmm5, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v8i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa %xmm1, %xmm8
; SSSE3-NEXT:    movdqa %xmm0, %xmm13
; SSSE3-NEXT:    movdqa {{.*#+}} xmm9 = [2147483648,2147483648]
; SSSE3-NEXT:    paddq %xmm4, %xmm13
; SSSE3-NEXT:    pxor %xmm9, %xmm4
; SSSE3-NEXT:    movdqa %xmm9, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm10, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm10, %xmm10
; SSSE3-NEXT:    pxor %xmm10, %xmm1
; SSSE3-NEXT:    pxor %xmm9, %xmm0
; SSSE3-NEXT:    movdqa %xmm9, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pand %xmm11, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm14 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm0, %xmm14
; SSSE3-NEXT:    pxor %xmm10, %xmm14
; SSSE3-NEXT:    pcmpeqd %xmm14, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm1[1,0,3,2]
; SSSE3-NEXT:    pand %xmm1, %xmm11
; SSSE3-NEXT:    movdqa %xmm13, %xmm0
; SSSE3-NEXT:    pxor %xmm9, %xmm0
; SSSE3-NEXT:    movdqa %xmm9, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm1[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pand %xmm12, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    por %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSSE3-NEXT:    pxor %xmm10, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm14, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,0,3,2]
; SSSE3-NEXT:    pand %xmm4, %xmm0
; SSSE3-NEXT:    pandn %xmm11, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSSE3-NEXT:    pandn %xmm11, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm12 = [9223372036854775807,9223372036854775807]
; SSSE3-NEXT:    pand %xmm12, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    pand %xmm0, %xmm1
; SSSE3-NEXT:    pandn %xmm13, %xmm0
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    movdqa %xmm8, %xmm1
; SSSE3-NEXT:    paddq %xmm5, %xmm8
; SSSE3-NEXT:    pxor %xmm9, %xmm5
; SSSE3-NEXT:    movdqa %xmm9, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    pand %xmm13, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm5, %xmm4
; SSSE3-NEXT:    pxor %xmm10, %xmm4
; SSSE3-NEXT:    pxor %xmm9, %xmm1
; SSSE3-NEXT:    movdqa %xmm9, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm5[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pand %xmm13, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm5[1,1,3,3]
; SSSE3-NEXT:    por %xmm1, %xmm15
; SSSE3-NEXT:    pxor %xmm10, %xmm15
; SSSE3-NEXT:    pcmpeqd %xmm15, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[1,0,3,2]
; SSSE3-NEXT:    pand %xmm4, %xmm13
; SSSE3-NEXT:    movdqa %xmm8, %xmm1
; SSSE3-NEXT:    pxor %xmm9, %xmm1
; SSSE3-NEXT:    movdqa %xmm9, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm14 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pand %xmm14, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSSE3-NEXT:    pxor %xmm10, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm15, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,0,3,2]
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm13, %xmm1
; SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSSE3-NEXT:    pandn %xmm11, %xmm5
; SSSE3-NEXT:    pand %xmm12, %xmm4
; SSSE3-NEXT:    por %xmm5, %xmm4
; SSSE3-NEXT:    pand %xmm1, %xmm4
; SSSE3-NEXT:    pandn %xmm8, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    paddq %xmm6, %xmm2
; SSSE3-NEXT:    pxor %xmm9, %xmm6
; SSSE3-NEXT:    movdqa %xmm9, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSSE3-NEXT:    pand %xmm8, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    por %xmm6, %xmm5
; SSSE3-NEXT:    pxor %xmm10, %xmm5
; SSSE3-NEXT:    pxor %xmm9, %xmm4
; SSSE3-NEXT:    movdqa %xmm9, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm6[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm8, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSSE3-NEXT:    por %xmm4, %xmm6
; SSSE3-NEXT:    pxor %xmm10, %xmm6
; SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[1,0,3,2]
; SSSE3-NEXT:    pand %xmm5, %xmm8
; SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSSE3-NEXT:    pxor %xmm9, %xmm5
; SSSE3-NEXT:    movdqa %xmm9, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    pand %xmm13, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm5, %xmm4
; SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSSE3-NEXT:    pxor %xmm10, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[1,0,3,2]
; SSSE3-NEXT:    pand %xmm5, %xmm6
; SSSE3-NEXT:    pandn %xmm8, %xmm6
; SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSSE3-NEXT:    pandn %xmm11, %xmm5
; SSSE3-NEXT:    pand %xmm12, %xmm4
; SSSE3-NEXT:    por %xmm5, %xmm4
; SSSE3-NEXT:    pand %xmm6, %xmm4
; SSSE3-NEXT:    pandn %xmm2, %xmm6
; SSSE3-NEXT:    por %xmm4, %xmm6
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    paddq %xmm7, %xmm3
; SSSE3-NEXT:    pxor %xmm9, %xmm7
; SSSE3-NEXT:    movdqa %xmm9, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm7, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm7
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm7
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm7, %xmm4
; SSSE3-NEXT:    pxor %xmm10, %xmm4
; SSSE3-NEXT:    pxor %xmm9, %xmm2
; SSSE3-NEXT:    movdqa %xmm9, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pand %xmm7, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm5
; SSSE3-NEXT:    pxor %xmm10, %xmm5
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,0,3,2]
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pxor %xmm9, %xmm4
; SSSE3-NEXT:    movdqa %xmm9, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm7
; SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm8, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSSE3-NEXT:    por %xmm4, %xmm7
; SSSE3-NEXT:    pxor %xmm7, %xmm10
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm10
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[1,0,3,2]
; SSSE3-NEXT:    pand %xmm10, %xmm5
; SSSE3-NEXT:    pandn %xmm2, %xmm5
; SSSE3-NEXT:    movdqa %xmm7, %xmm2
; SSSE3-NEXT:    pandn %xmm11, %xmm2
; SSSE3-NEXT:    pand %xmm12, %xmm7
; SSSE3-NEXT:    por %xmm2, %xmm7
; SSSE3-NEXT:    pand %xmm5, %xmm7
; SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSSE3-NEXT:    por %xmm7, %xmm5
; SSSE3-NEXT:    movdqa %xmm6, %xmm2
; SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v8i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    movdqa {{.*#+}} xmm10 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm11
; SSE41-NEXT:    paddq %xmm4, %xmm8
; SSE41-NEXT:    pxor %xmm10, %xmm4
; SSE41-NEXT:    movdqa %xmm10, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    pand %xmm9, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm12 = xmm0[1,1,3,3]
; SSE41-NEXT:    por %xmm4, %xmm12
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm9
; SSE41-NEXT:    pxor %xmm9, %xmm12
; SSE41-NEXT:    pxor %xmm10, %xmm11
; SSE41-NEXT:    movdqa %xmm10, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm11, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm13 = xmm0[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm11
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[1,1,3,3]
; SSE41-NEXT:    pand %xmm13, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm11 = xmm0[1,1,3,3]
; SSE41-NEXT:    por %xmm4, %xmm11
; SSE41-NEXT:    pxor %xmm9, %xmm11
; SSE41-NEXT:    pcmpeqq %xmm11, %xmm12
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm14 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm13, %xmm14
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm14, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm9, %xmm4
; SSE41-NEXT:    pcmpeqq %xmm11, %xmm4
; SSE41-NEXT:    pandn %xmm12, %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm12 = [9223372036854775807,9223372036854775807]
; SSE41-NEXT:    movapd {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSE41-NEXT:    movapd %xmm11, %xmm13
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm13
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm13, %xmm8
; SSE41-NEXT:    movdqa %xmm1, %xmm14
; SSE41-NEXT:    paddq %xmm5, %xmm1
; SSE41-NEXT:    pxor %xmm10, %xmm5
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,3,3]
; SSE41-NEXT:    pand %xmm13, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm15 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm0, %xmm15
; SSE41-NEXT:    pxor %xmm9, %xmm15
; SSE41-NEXT:    pxor %xmm10, %xmm14
; SSE41-NEXT:    movdqa %xmm10, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm14, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm13 = xmm0[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm14
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm14[1,1,3,3]
; SSE41-NEXT:    pand %xmm13, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE41-NEXT:    por %xmm4, %xmm5
; SSE41-NEXT:    pxor %xmm9, %xmm5
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm15
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm14 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm13, %xmm14
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm14, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm9, %xmm4
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm4
; SSE41-NEXT:    pandn %xmm15, %xmm4
; SSE41-NEXT:    movapd %xmm11, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    paddq %xmm6, %xmm2
; SSE41-NEXT:    pxor %xmm10, %xmm6
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm6, %xmm5
; SSE41-NEXT:    pxor %xmm9, %xmm5
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm0, %xmm6
; SSE41-NEXT:    pxor %xmm9, %xmm6
; SSE41-NEXT:    pcmpeqq %xmm6, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm14 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm13, %xmm14
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm14, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm9, %xmm4
; SSE41-NEXT:    pcmpeqq %xmm6, %xmm4
; SSE41-NEXT:    pandn %xmm5, %xmm4
; SSE41-NEXT:    movapd %xmm11, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm5
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    paddq %xmm7, %xmm3
; SSE41-NEXT:    pxor %xmm10, %xmm7
; SSE41-NEXT:    movdqa %xmm10, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm7, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    por %xmm6, %xmm4
; SSE41-NEXT:    pxor %xmm9, %xmm4
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE41-NEXT:    por %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm9, %xmm5
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm4
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm10, %xmm0
; SSE41-NEXT:    movdqa %xmm10, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm13 = xmm6[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm13, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm0, %xmm9
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm9
; SSE41-NEXT:    pandn %xmm4, %xmm9
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm11
; SSE41-NEXT:    movdqa %xmm9, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm11, %xmm3
; SSE41-NEXT:    movapd %xmm8, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm9
; AVX1-NEXT:    vpxor %xmm12, %xmm12, %xmm12
; AVX1-NEXT:    vpcmpgtq %xmm9, %xmm12, %xmm7
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX1-NEXT:    vpcmpgtq %xmm7, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm10
; AVX1-NEXT:    vpcmpeqq %xmm8, %xmm10, %xmm8
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm11
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqq %xmm11, %xmm6, %xmm11
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX1-NEXT:    vpaddq %xmm9, %xmm7, %xmm9
; AVX1-NEXT:    vpcmpgtq %xmm9, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm4, %xmm10, %xmm10
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm12, %xmm2
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm4, %ymm4
; AVX1-NEXT:    vandnpd %ymm8, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm2, %ymm7
; AVX1-NEXT:    vmovapd {{.*#+}} ymm8 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX1-NEXT:    vmovapd {{.*#+}} ymm10 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vblendvpd %ymm7, %ymm8, %ymm10, %ymm7
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX1-NEXT:    vblendvpd %ymm4, %ymm7, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm7
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm12, %xmm6
; AVX1-NEXT:    vpxor %xmm5, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqq %xmm7, %xmm6, %xmm9
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm11
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm12, %xmm7
; AVX1-NEXT:    vpxor %xmm5, %xmm7, %xmm7
; AVX1-NEXT:    vpcmpeqq %xmm11, %xmm7, %xmm11
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm11, %ymm9
; AVX1-NEXT:    vpaddq %xmm4, %xmm2, %xmm11
; AVX1-NEXT:    vpcmpgtq %xmm11, %xmm12, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm12, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpcmpeqq %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm2
; AVX1-NEXT:    vandnpd %ymm9, %ymm2, %ymm2
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-NEXT:    vblendvpd %ymm3, %ymm8, %ymm10, %ymm3
; AVX1-NEXT:    vinsertf128 $1, %xmm11, %ymm1, %ymm1
; AVX1-NEXT:    vblendvpd %ymm2, %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm4, %ymm5
; AVX2-NEXT:    vpcmpeqd %ymm6, %ymm6, %ymm6
; AVX2-NEXT:    vpxor %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm4, %ymm7
; AVX2-NEXT:    vpxor %ymm6, %ymm7, %ymm7
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm6, %ymm2, %ymm8
; AVX2-NEXT:    vpcmpeqq %ymm8, %ymm7, %ymm7
; AVX2-NEXT:    vpandn %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm7 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm8 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vblendvpd %ymm2, %ymm7, %ymm8, %ymm2
; AVX2-NEXT:    vblendvpd %ymm5, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm6, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm4, %ymm5
; AVX2-NEXT:    vpxor %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm5, %ymm2
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm4, %ymm3
; AVX2-NEXT:    vpxor %ymm6, %ymm3, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpandn %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vblendvpd %ymm3, %ymm7, %ymm8, %ymm3
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpnltq %zmm2, %zmm1, %k0
; AVX512-NEXT:    vpcmpnltq %zmm2, %zmm0, %k1
; AVX512-NEXT:    kxorw %k0, %k1, %k0
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpcmpnltq %zmm2, %zmm0, %k2
; AVX512-NEXT:    kxorw %k2, %k1, %k1
; AVX512-NEXT:    kandnw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpgtq %zmm0, %zmm2, %k2
; AVX512-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX512-NEXT:    vpbroadcastq {{.*}}(%rip), %zmm1 {%k2}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %z = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> %x, <8 x i64> %y)
  ret <8 x i64> %z
}

define <2 x i128> @v2i128(<2 x i128> %x, <2 x i128> %y) nounwind {
; SSE-LABEL: v2i128:
; SSE:       # %bb.0:
; SSE-NEXT:    pushq %r15
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %r13
; SSE-NEXT:    pushq %r12
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    movq %rdi, %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r14
; SSE-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; SSE-NEXT:    movq %r8, %r13
; SSE-NEXT:    adcq %r14, %r13
; SSE-NEXT:    movq %r13, %r10
; SSE-NEXT:    sarq $63, %r10
; SSE-NEXT:    xorl %edi, %edi
; SSE-NEXT:    testq %r13, %r13
; SSE-NEXT:    setns %dil
; SSE-NEXT:    movabsq $9223372036854775807, %r12 # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    leaq (%rdi,%r12), %r15
; SSE-NEXT:    testq %r8, %r8
; SSE-NEXT:    setns %r8b
; SSE-NEXT:    cmpb %dil, %r8b
; SSE-NEXT:    setne %dil
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    setns %bl
; SSE-NEXT:    cmpb %bl, %r8b
; SSE-NEXT:    sete %bl
; SSE-NEXT:    testb %dil, %bl
; SSE-NEXT:    cmoveq %r13, %r15
; SSE-NEXT:    cmoveq %rcx, %r10
; SSE-NEXT:    addq %r9, %rsi
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    adcq %r11, %rdi
; SSE-NEXT:    setns %bl
; SSE-NEXT:    movzbl %bl, %ebx
; SSE-NEXT:    addq %rbx, %r12
; SSE-NEXT:    movq %rdi, %rcx
; SSE-NEXT:    sarq $63, %rcx
; SSE-NEXT:    testq %r11, %r11
; SSE-NEXT:    setns %r8b
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    setns %dl
; SSE-NEXT:    cmpb %r8b, %dl
; SSE-NEXT:    sete %r8b
; SSE-NEXT:    cmpb %bl, %dl
; SSE-NEXT:    setne %dl
; SSE-NEXT:    testb %dl, %r8b
; SSE-NEXT:    cmoveq %rsi, %rcx
; SSE-NEXT:    cmoveq %rdi, %r12
; SSE-NEXT:    movq %r15, 24(%rax)
; SSE-NEXT:    movq %r10, 16(%rax)
; SSE-NEXT:    movq %r12, 8(%rax)
; SSE-NEXT:    movq %rcx, (%rax)
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r12
; SSE-NEXT:    popq %r13
; SSE-NEXT:    popq %r14
; SSE-NEXT:    popq %r15
; SSE-NEXT:    retq
;
; AVX-LABEL: v2i128:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %r15
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %r13
; AVX-NEXT:    pushq %r12
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    movq %rdi, %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r14
; AVX-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; AVX-NEXT:    movq %r8, %r13
; AVX-NEXT:    adcq %r14, %r13
; AVX-NEXT:    movq %r13, %r10
; AVX-NEXT:    sarq $63, %r10
; AVX-NEXT:    xorl %edi, %edi
; AVX-NEXT:    testq %r13, %r13
; AVX-NEXT:    setns %dil
; AVX-NEXT:    movabsq $9223372036854775807, %r12 # imm = 0x7FFFFFFFFFFFFFFF
; AVX-NEXT:    leaq (%rdi,%r12), %r15
; AVX-NEXT:    testq %r8, %r8
; AVX-NEXT:    setns %r8b
; AVX-NEXT:    cmpb %dil, %r8b
; AVX-NEXT:    setne %dil
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    setns %bl
; AVX-NEXT:    cmpb %bl, %r8b
; AVX-NEXT:    sete %bl
; AVX-NEXT:    testb %dil, %bl
; AVX-NEXT:    cmoveq %r13, %r15
; AVX-NEXT:    cmoveq %rcx, %r10
; AVX-NEXT:    addq %r9, %rsi
; AVX-NEXT:    movq %rdx, %rdi
; AVX-NEXT:    adcq %r11, %rdi
; AVX-NEXT:    setns %bl
; AVX-NEXT:    movzbl %bl, %ebx
; AVX-NEXT:    addq %rbx, %r12
; AVX-NEXT:    movq %rdi, %rcx
; AVX-NEXT:    sarq $63, %rcx
; AVX-NEXT:    testq %r11, %r11
; AVX-NEXT:    setns %r8b
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    setns %dl
; AVX-NEXT:    cmpb %r8b, %dl
; AVX-NEXT:    sete %r8b
; AVX-NEXT:    cmpb %bl, %dl
; AVX-NEXT:    setne %dl
; AVX-NEXT:    testb %dl, %r8b
; AVX-NEXT:    cmoveq %rsi, %rcx
; AVX-NEXT:    cmoveq %rdi, %r12
; AVX-NEXT:    movq %r15, 24(%rax)
; AVX-NEXT:    movq %r10, 16(%rax)
; AVX-NEXT:    movq %r12, 8(%rax)
; AVX-NEXT:    movq %rcx, (%rax)
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r12
; AVX-NEXT:    popq %r13
; AVX-NEXT:    popq %r14
; AVX-NEXT:    popq %r15
; AVX-NEXT:    retq
  %z = call <2 x i128> @llvm.sadd.sat.v2i128(<2 x i128> %x, <2 x i128> %y)
  ret <2 x i128> %z
}
