const double cheb_table_tmax = 30;
const double cheb_table_delta = 0.5;
const size_t cheb_table_mmax = 40;
double cheb_table[][328]={
{
// [0,0.5]: m=0 maxabs=1.411093464298574e-13 maxrel=1.4110934642985724e-13
0.9225620128254464,
-0.14376122975414912,
0.020941648881248522,
-0.002452715479378476,
0.000235997651027557,
-0.000019170981830737773,
1.3470072437538336e-6,
-8.303934753460698e-8,
// [0,0.5]: m=1 maxabs=1.25954802143724e-13 maxrel=3.7786440643117147e-13
0.28752245950823613,
-0.08376659545364744,
0.014716292882247196,
-0.0018879840616398504,
0.00019170973868261638,
-0.00001613669564431154,
1.1628054288774348e-6,
-7.304190347568398e-8,
// [0,0.5]: m=2 maxabs=1.136590821460004e-13 maxrel=5.682954107300009e-13
0.16753319090723864,
-0.05886517146532266,
0.011327904375232989,
-0.0015336804559930917,
0.0001613668844793646,
-0.000013929219001881977,
1.0228171231509808e-6,
-6.51888648831467e-8,
// [0,0.5]: m=3 maxabs=1.0361156377314273e-13 maxrel=7.252809464119972e-13
0.11773034293059441,
-0.045311617443446695,
0.009202082740855884,
-0.0012909373750767904,
0.00013929212463536714,
-0.000012251733430757432,
9.128535270351977e-7,
-5.885792285057865e-8,
// [0,0.5]: m=4 maxabs=9.514611321037592e-14 maxrel=8.563150188933809e-13
0.09062323488684626,
-0.036808330911033936,
0.00774562425497998,
-0.001114339092641799,
0.00012251727407221023,
-0.000010934125035884645,
8.242035120648305e-7,
-5.364621615348856e-8,
// [0,0.5]: m=5 maxabs=8.804068585277491e-14 maxrel=9.68447544380522e-13
0.07361666182202371,
-0.03098249697179002,
0.0066860345600377345,
-0.000980140117682248,
0.00010934119466087979,
-9.871961462956802e-6,
7.512250821927126e-7,
-4.928136842444809e-8,
// [0,0.5]: m=6 maxabs=8.125444761475364e-14 maxrel=1.0563078189917948e-12
0.06196499394354022,
-0.026744138195616916,
0.005880840710038178,
-0.0008747313378877381,
0.00009871956213210447,
-8.997609440122808e-6,
6.901067626117111e-7,
-4.557506783637167e-8,
// [0,0.5]: m=7 maxabs=7.653599976009673e-14 maxrel=1.1480399964014491e-12
0.0534882763912485,
-0.023523362798435792,
0.005248388028671893,
-0.0007897581600109213,
0.00008997606328415283,
-8.265358783570978e-6,
6.381711135859793e-7,
-4.238254286901429e-8,
// [0,0.5]: m=8 maxabs=7.184530748105544e-14 maxrel=1.2213702271779405e-12
0.04704672559683674,
-0.020993552076006772,
0.004738548963444083,
-0.0007198100535157448,
0.00008265354267238555,
-7.643199811999523e-6,
5.935003036547157e-7,
-3.960946752950958e-8,
// [0,0.5]: m=9 maxabs=6.766809335090329e-14 maxrel=1.2856937736671601e-12
0.04198710415198017,
-0.01895419581747007,
0.0043188603242978185,
-0.0006612297936172897,
0.00007643195541467157,
-7.108062267567646e-6,
5.546691984803327e-7,
-3.7176771940317704e-8,
// [0,0.5]: m=10 maxabs=6.399047958183246e-14 maxrel=1.343800071218478e-12
0.0379083916349086,
-0.01727544126298479,
0.00396737876472532,
-0.0006114570115350189,
0.00007108058240301862,
-6.642895717927431e-6,
5.20603679102592e-7,
-3.50253705444214e-8,
// [0,0.5]: m=11 maxabs=6.065287161405308e-14 maxrel=1.3950160471232155e-12
0.034550882525939706,
-0.015869515026567523,
0.0036687420720807272,
-0.00056864595256331,
0.00006642891889229259,
-6.234828149552755e-6,
4.904777198532567e-7,
-3.310922853823398e-8,
// [0,0.5]: m=12 maxabs=5.766914723537298e-14 maxrel=1.4417286808843165e-12
0.03173903005310666,
-0.014674968257666293,
0.00341187571810913,
-0.0005314325773998331,
0.00006234824510581609,
-5.873960645336854e-6,
4.636456415095204e-7,
-3.1391750520628365e-8,
// [0,0.5]: m=13 maxabs=5.4962978612849156e-14 maxrel=1.4840004225469183e-12
0.029349936515305538,
-0.013647502843291156,
0.003188595466997968,
-0.0004987871266390196,
0.00005873957178393859,
-5.552556242282228e-6,
4.395954996380482e-7,
-2.984359213897343e-8,
// [0,0.5]: m=14 maxabs=5.2506610170866e-14 maxrel=1.5226916949551062e-12
0.0272950056865564,
-0.01275438184021614,
0.002992722762318964,
-0.000469917685274407,
0.00005552552932042527,
-5.264480549109295e-6,
4.179161586552558e-7,
-2.8440851578993155e-8,
// [0,0.5]: m=15 maxabs=5.024453075819224e-14 maxrel=1.5575804535039528e-12
0.025508763680407467,
-0.011970891022748025,
0.002819506114030703,
-0.0004442052956660456,
0.000052644773691397244,
-5.0048073680924955e-6,
3.98273693321161e-7,
-2.7164043419514205e-8,
// [0,0.5]: m=16 maxabs=4.817327092787593e-14 maxrel=1.589717940619901e-12
0.02394178204547227,
-0.01127802443073419,
0.0026652317762792727,
-0.00042115920505719117,
0.000050048043242483934,
-4.769535393930988e-6,
3.8039401088449464e-7,
-2.5996896738579224e-8,
// [0,0.5]: m=17 maxabs=4.62685445512534e-14 maxrel=1.6193990592938647e-12
0.022556048861445584,
-0.010660927080775193,
0.0025269552325345376,
-0.0004003853196127293,
0.00004769532470993796,
-4.555380903175274e-6,
3.640501043460616e-7,
-2.492588739530693e-8,
// [0,0.5]: m=18 maxabs=4.451300439356487e-14 maxrel=1.646981162561897e-12
0.02132185416152843,
-0.010107820906759473,
0.002402311919783391,
-0.00038156353282465546,
0.00004555378094031779,
-4.359623885234812e-6,
3.49052308330826e-7,
-2.3939580389840875e-8,
// [0,0.5]: m=19 maxabs=4.286848653833886e-14 maxrel=1.6718709749952114e-12
0.020215641813497737,
-0.009609247656644513,
0.0022893811989838325,
-0.00036443114707476444,
0.00004359621171530621,
-4.179992041901345e-6,
3.352409523697958e-7,
-2.302836907505328e-8,
// [0,0.5]: m=20 maxabs=4.135233822033513e-14 maxrel=1.6954458670337358e-12
0.01921849531326865,
-0.009157524774270868,
0.00218658688440505,
-0.000348770560290821,
0.00004179989433128124,
-4.014572424762317e-6,
3.224806490694054e-7,
-2.2183925233398725e-8,
// [0,0.5]: m=21 maxabs=3.994374275784196e-14 maxrel=1.7175809385871982e-12
0.01831504954852195,
-0.008746347516721608,
0.0020926233636423316,
-0.00033439999057490024,
0.000040145698961345484,
-3.861743009100007e-6,
3.1065584724586754e-7,
-2.1399241596745044e-8,
// [0,0.5]: m=22 maxabs=3.8614944575243726e-14 maxrel=1.737672505885961e-12
0.017492695033424144,
-0.008370493434384512,
0.002006399945277804,
-0.000321166399060502,
0.00003861740572527672,
-3.7201195371934274e-6,
2.996673311257624e-7,
-2.066814145099031e-8,
// [0,0.5]: m=23 maxabs=3.739716869510801e-14 maxrel=1.7576669286700687e-12
0.016740986868750574,
-0.00802559976159363,
0.0019269983961322577,
-0.00030894002649152204,
0.00003720117178800002,
-3.58851342404007e-6,
2.8942943671444157e-7,
-1.9985338163826077e-8,
// [0,0.5]: m=24 maxabs=3.622796507229964e-14 maxrel=1.7751702885426749e-12
0.016051199523169416,
-0.007707993565635991,
0.0018536401606614825,
-0.0002976101300174255,
0.00003588511140561272,
-3.46589841348168e-6,
2.798678173789143e-7,
-1.9346188569718172e-8,
// [0,0.5]: m=25 maxabs=3.5148967070242065e-14 maxrel=1.7925973205823369e-12
0.015415987131254643,
-0.007414560624338108,
0.0017856607817685816,
-0.0002870816235494107,
0.00003465896195377122,
-3.3513837575807534e-6,
2.709176055738249e-7,
-1.8746650450075794e-8,
// [0,0.5]: m=26 maxabs=3.412548021941575e-14 maxrel=1.8086504516290254e-12
0.014829121248659437,
-0.007142643109317453,
0.0017224897429103242,
-0.00027727240590611765,
0.00003351381604801715,
-3.2441925998928415e-6,
2.625220040177222e-7,
-1.8183140800481856e-8,
// [0,0.5]: m=27 maxabs=3.315750451982069e-14 maxrel=1.8236627485901287e-12
0.014285286218618536,
-0.006889958954401658,
0.001663634437007689,
-0.0002681112179485536,
0.00003244190505184376,
-3.143644309894139e-6,
2.5463100726347754e-7,
-1.76525244920714e-8,
// [0,0.5]: m=28 maxabs=3.2241570524504937e-14 maxrel=1.8377695198967725e-12
0.013779917908787437,
-0.00665453773128034,
0.0016086673092169947,
-0.00025953591042197097,
0.00003143642275134206,
-3.0491400597233444e-6,
2.472004634273491e-7,
-1.715199805066048e-8,
// [0,0.5]: m=29 maxabs=3.137073933956458e-14 maxrel=1.850873621034302e-12
0.013309075462545247,
-0.006434669220579505,
0.0015572154640141568,
-0.00025149203354295793,
0.00003049138083197864,
-2.960150887624969e-6,
2.401912188317175e-7,
-1.6679058475536852e-8,
// [0,0.5]: m=30 maxabs=3.0558888752807434e-14 maxrel=1.864092213921245e-12
0.012869338441143973,
-0.006228861840205241,
0.0015089522027015754,
-0.00024393168070503657,
0.000029601489622517304,
-2.8762077936633863e-6,
2.3356843485313553e-7,
-1.6231483396872182e-8,
// [0,0.5]: m=31 maxabs=2.977479374166592e-14 maxrel=1.875812005724945e-12
0.01245772368039578,
-0.0060358087953693,
0.001463590085642141,
-0.0002368125344560681,
0.000028762059109472827,
-2.7968934648322474e-6,
2.2730101673926678e-7,
-1.5807319737100514e-8,
// [0,0.5]: m=32 maxabs=2.903927098785175e-14 maxrel=1.887552614210356e-12
0.012071617590724271,
-0.005854360327524268,
0.0014208752081109922,
-0.00023009707463338204,
0.000027968916324224185,
-2.721835388524948e-6,
2.2136110904022543e-7,
-1.5404749064787066e-8,
// [0,0.5]: m=33 maxabs=2.8336707980081144e-14 maxrel=1.898559434665429e-12
0.01170872065503456,
-0.005683500817773353,
0.001380582449141206,
-0.00022375191740665786,
0.000027218336007166497,
-2.650699961589224e-6,
2.1572369804815742e-7,
-1.5022166964979248e-8,
// [0,0.5]: m=34 maxabs=2.7668839441830073e-14 maxrel=1.9091499214862678e-12
0.011367001635533067,
-0.005522329782249959,
0.0013425115057499675,
-0.00021774726064725756,
0.00002650698214524668,
-2.583187550851548e-6,
2.1036625179600554e-7,
-1.4658127763426493e-8,
// [0,0.5]: m=35 maxabs=2.7021787585290724e-14 maxrel=1.918546918555634e-12
0.011044659564486562,
-0.00537004600902377,
0.0013064835651647292,
-0.00021205641619909048,
0.000025831858431842727,
-2.519028280199131e-6,
2.0526842667067615e-7,
-1.4311311928043234e-8,
// [0,0.5]: m=36 maxabs=2.6414634368698842e-14 maxrel=1.9282683089150074e-12
0.010740092018034499,
-0.005225934247006,
0.0012723384984465482,
-0.00020665541356914104,
0.000025190266106181084,
-2.4579784243667666e-6,
2.0041180060110032e-7,
-1.3980528903564301e-8,
// [0,0.5]: m=37 maxabs=2.5826563110342704e-14 maxrel=1.936992233275695e-12
0.010451868493999265,
-0.005089353980441285,
0.0012399324826385771,
-0.00020152266263511219,
0.000024579767921323288,
-2.3998173146447185e-6,
1.9577964770313006e-7,
-1.3664698686284856e-8,
// [0,0.5]: m=38 maxabs=2.526971687455415e-14 maxrel=1.9457681993406618e-12
0.010178707960870118,
-0.004959729917504462,
0.0012091359770057006,
-0.00019663866536195185,
0.000023998157214443713,
-2.344344688564512e-6,
1.9135676040491244e-7,
-1.3362809304229503e-8,
// [0,0.5]: m=39 maxabs=2.4738891490905246e-14 maxrel=1.9543724277815116e-12
0.009919459834996714,
-0.0048365438952549375,
0.001179831993342565,
-0.00019198576842457157,
0.000023443431276216575,
-2.2913783519283156e-6,
1.871292708635997e-7,
-1.3073987683537115e-8,
// [0,0.5]: m=40 maxabs=2.4223678618540134e-14 maxrel=1.9621179681017485e-12
0.00967308779049814,
-0.004719327960873158,
0.0011519146116853152,
-0.00018754795010364724,
0.000022913768316428348,
-2.2407522482314507e-6,
1.8308451879954172e-7,
-1.2797353663708085e-8
},
{
// [0.5,1.]: m=0 maxabs=8.981704269217516e-14 maxrel=1.0497251310654137e-13
0.7975078096148953,
-0.10838041895797,
0.014826330095336892,
-0.0016762034818245484,
0.00015770431459094725,
-0.000012614628517204322,
8.764037421556591e-7,
-5.356872801365819e-8,
// [0.5,1.]: m=1 maxabs=8.021361352916756e-14 maxrel=3.220218061181868e-13
0.21676083791590028,
-0.059305320335623204,
0.01005722089475729,
-0.0012616363453658982,
0.00012614623479738224,
-0.000010499291753055304,
7.501222708505832e-7,
-4.680460528251248e-8,
// [0.5,1.]: m=2 maxabs=7.208122987378829e-14 maxrel=5.12120461486707e-13
0.11861064067121105,
-0.04022888353844853,
0.007569818075572084,
-0.0010091715014848423,
0.00010499287256441454,
-8.985886286207017e-6,
6.554082987005183e-7,
-4.154758945361639e-8,
// [0.5,1.]: m=3 maxabs=6.550315845288424e-14 maxrel=6.737481434451337e-13
0.08045776707686565,
-0.030279272265817482,
0.006055029011940928,
-0.000839944439422004,
0.00008985882227901756,
-7.850894335181635e-6,
5.817963715371467e-7,
-3.734639204974008e-8,
// [0.5,1.]: m=4 maxabs=5.997979890537408e-14 maxrel=8.102803815743808e-13
0.060558544531605474,
-0.02422011601464185,
0.005039666639363324,
-0.0007188719030152923,
0.00007850890556444262,
-6.968838839386282e-6,
5.229704944657889e-7,
-3.391336358019627e-8,
// [0.5,1.]: m=5 maxabs=5.530992330804452e-14 maxrel=9.267602395554064e-13
0.04844023202925661,
-0.020158666527123344,
0.004313231420699947,
-0.0006280724576774045,
0.00006968835358021978,
-6.2639997876937495e-6,
4.748985516074664e-7,
-3.105602527447127e-8,
// [0.5,1.]: m=6 maxabs=5.1333937101105676e-14 maxrel=1.0275070600511627e-12
0.040317333054221256,
-0.017252925654827948,
0.00376843474850001,
-0.0005575079474755027,
0.00006263996542633406,
-5.688042024256179e-6,
4.348881603404269e-7,
-2.8641210691500128e-8,
// [0.5,1.]: m=7 maxabs=4.789224572476769e-14 maxrel=1.1151905614909464e-12
0.034505851309632234,
-0.015073738968047727,
0.0033450476871301135,
-0.000501120761471288,
0.0000568803898642686,
-5.208692673916165e-6,
4.010741783609909e-7,
-2.6573828481460285e-8,
// [0.5,1.]: m=8 maxabs=4.488770466437586e-14 maxrel=1.1922508724033003e-12
0.030147477936073343,
-0.01338019072431746,
0.0030067245709526898,
-0.0004550440870430186,
0.0000520868983952652,
-4.803596109985165e-6,
3.7212429637440703e-7,
-2.47840384047724e-8,
// [0.5,1.]: m=9 maxabs=4.220235272356376e-14 maxrel=1.2593344954354098e-12
0.02676038144861398,
-0.012026898261137259,
0.002730264524260109,
-0.0004166960941648811,
0.00004803593443929759,
-4.456784221150877e-6,
3.47061814022337e-7,
-2.3219575085295393e-8,
// [0.5,1.]: m=10 maxabs=3.982925100842749e-14 maxrel=1.3192719586334077e-12
0.024053796522254877,
-0.01092105807571158,
0.002500176566876381,
-0.0003842883286631169,
0.000044567817040920463,
-4.156551568322061e-6,
3.2515461493506755e-7,
-2.1840492559227332e-8,
// [0.5,1.]: m=11 maxabs=3.772329670859165e-14 maxrel=1.3734446238816572e-12
0.021842116151404526,
-0.01000070624737252,
0.0023057299737678366,
-0.00035654334163533294,
0.000041565491824989154,
-3.894124460240105e-6,
3.0584324372888107e-7,
-2.0615731507424177e-8,
// [0.5,1.]: m=12 maxabs=3.582550922587302e-14 maxrel=1.4221096037053253e-12
0.02000141249472734,
-0.00922291987600827,
0.0021392600515139893,
-0.0003325246971252259,
0.00003894122189335661,
-3.6627986429815996e-6,
2.886929344241711e-7,
-1.9520837357808205e-8,
// [0.5,1.]: m=13 maxabs=3.4094255196848167e-14 maxrel=1.4655062426581553e-12
0.018445839751999732,
-0.008557040187953202,
0.001995148184367372,
-0.0003115304992347145,
0.00003662796487611509,
-3.457364074146503e-6,
2.7336070293098234e-7,
-1.8536188625747213e-8,
// [0.5,1.]: m=14 maxabs=3.2536473515420994e-14 maxrel=1.5055816065995e-12
0.017114080375890302,
-0.007980592720236384,
0.0018691829969518096,
-0.0002930244083192479,
0.000034573620174711406,
-3.273711137845886e-6,
2.59572422482181e-7,
-1.764596793414677e-8,
// [0.5,1.]: m=15 maxabs=3.112440860597587e-14 maxrel=1.5426597610779223e-12
0.015961185440457427,
-0.00747673197136425,
0.0017581464513878836,
-0.00027658961910780055,
0.000032737091746831474,
-3.1085550903314776e-6,
2.47106369876225e-7,
-1.6837212403893455e-8,
// [0.5,1.]: m=16 maxabs=2.9802549317281546e-14 maxrel=1.5752360879397984e-12
0.014953463942713813,
-0.0070325857898295525,
0.0016595377160593865,
-0.0002618973628553303,
0.000031085532060961754,
-2.959239195836092e-6,
2.3578128519998327e-7,
-1.609927506933016e-8,
// [0.5,1.]: m=17 maxabs=2.859865122495364e-14 maxrel=1.6057528600957001e-12
0.014065171579645,
-0.006638150849175512,
0.00157138417848484,
-0.0002486848589617415,
0.000029592373923751812,
-2.8235917019097695e-6,
2.254475574677907e-7,
-1.5423209758035724e-8,
// [0.5,1.]: m=18 maxabs=2.7505775435088253e-14 maxrel=1.634957418786033e-12
0.0132763016983374,
-0.0062855366994841125,
0.0014921091550766938,
-0.0002367395695878407,
0.000028235899613339165,
-2.6998200514978254e-6,
2.1598060640976855e-7,
-1.4801595342190576e-8,
// [0.5,1.]: m=19 maxabs=2.6468410796454123e-14 maxrel=1.660459996985103e-12
0.01257107339895517,
-0.0059684366064118345,
0.001420437418781692,
-0.0002258877526968544,
0.000026998183783912,
-2.5864317235945027e-6,
2.0727587576173613e-7,
-1.4228093532335367e-8,
// [0.5,1.]: m=20 maxabs=2.5510843437714925e-14 maxrel=1.684409365239768e-12
0.011936873212811049,
-0.005681749661750398,
0.001355326517392485,
-0.00021598600532630937,
0.000025864301090500864,
-2.4821739920323815e-6,
1.9924495899995203e-7,
-1.3697341160466034e-8,
// [0.5,1.]: m=21 maxabs=2.4640012252774568e-14 maxrel=1.7080724534937647e-12
0.011363499323488622,
-0.005421306056674125,
0.0012959160331258504,
-0.0002069149245454405,
0.00002482172434942887,
-2.3859876887981807e-6,
1.9181259389773346e-7,
-1.3204733328896212e-8,
// [0.5,1.]: m=22 maxabs=2.381254915473363e-14 maxrel=1.7291551658288188e-12
0.010842612113336494,
-0.005183664120055303,
0.001241489548399183,
-0.00019857429270616088,
0.000023859861869977533,
-2.2969712409369472e-6,
1.849143246434206e-7,
-1.274628734679836e-8,
// [0.5,1.]: m=23 maxabs=2.3038862484447975e-14 maxrel=1.748874547896392e-12
0.010367328240099246,
-0.004965958181566516,
0.001191445757328547,
-0.00019087937615940958,
0.00002296969785022504,
-2.214352411783859e-6,
1.7849461998352736e-7,
-1.2318588871751288e-8,
// [0.5,1.]: m=24 maxabs=2.2312013348013693e-14 maxrel=1.7672111640976848e-12
0.009931916363122016,
-0.004765783017674846,
0.0011452762580139667,
-0.00018375804837415035,
0.000022143510014099266,
-2.137465948466288e-6,
1.7250538644598775e-7,
-1.19186459249874e-8,
// [0.5,1.]: m=25 maxabs=2.163373646890676e-14 maxrel=1.784769972693369e-12
0.009531566035339039,
-0.004581105020782285,
0.0011025482912689576,
-0.0001771485310487775,
0.000021374645825632263,
-2.065735682738066e-6,
1.6690475439898355e-7,
-1.1543835032940226e-8,
// [0.5,1.]: m=26 maxabs=2.0997092953223273e-14 maxrel=1.8014348669146822e-12
0.009162210041554219,
-0.004410193154146407,
0.001062891187287012,
-0.00017099760378588174,
0.00002065734356821362,
-1.9986601066583525e-6,
1.6165611887442573e-7,
-1.1191860124741219e-8,
// [0.5,1.]: m=27 maxabs=2.0396878630535298e-14 maxrel=1.8171530059906436e-12
0.00882038630828274,
-0.004251564738541793,
0.0010259856236828878,
-0.0001652591727924485,
0.000019986588164428045,
-1.935800661832957e-6,
1.567273253131927e-7,
-1.0860710012388857e-8,
// [0.5,1.]: m=28 maxabs=1.9820950436510998e-14 maxrel=1.831162043105232e-12
0.00850312947707381,
-0.004103942484430127,
0.000991555037693795,
-0.00015989311737018923,
0.000019357994094534146,
-1.8767721858284164e-6,
1.5209002149204094e-7,
-1.0548580437725323e-8,
// [0.5,1.]: m=29 maxabs=1.9277981988530257e-14 maxrel=1.8445314307417503e-12
0.008207884968850717,
-0.003966220140761211,
0.0009593587051355595,
-0.00015486435330820577,
0.00001876770967416018,
-1.8212350114559181e-6,
1.4771909803349694e-7,
-1.0253881159074995e-8,
// [0.5,1.]: m=30 maxabs=1.8764503839641122e-14 maxrel=1.8572431751039526e-12
0.007932440281513159,
-0.0038374348108005762,
0.0009291861207384236,
-0.00015014206705493864,
0.000018212338261381217,
-1.7688884574281017e-6,
1.435922589555649e-7,
-9.975190596758146e-9,
// [0.5,1.]: m=31 maxabs=1.8289189607223477e-14 maxrel=1.870475522810791e-12
0.007674869621592118,
-0.0037167444734699595,
0.000900852403196242,
-0.00014569908543820423,
0.00001768887302244021,
-1.7194653844919612e-6,
1.3968962623729956e-7,
-9.71124591179708e-9,
// [0.5,1.]: m=32 maxabs=1.7827753162613647e-14 maxrel=1.882041638970876e-12
0.007433488946931128,
-0.0036034096035455743,
0.0008741945134728275,
-0.00014151135375075808,
0.000017194642600528184,
-1.6727276590943848e-6,
1.3599341666809125e-7,
-9.460897651429824e-9,
// [0.5,1.]: m=33 maxabs=1.739060284666749e-14 maxrel=1.89321154480691e-12
0.007206819207082577,
-0.003496778044884256,
0.0008490681233278525,
-0.00013755750108626293,
0.00001672726561553464,
-1.6284623088807781e-6,
1.3248768176803357e-7,
-9.223128174370196e-9,
// [0.5,1.]: m=34 maxabs=1.6970799765481104e-14 maxrel=1.9034468603851893e-12
0.0069935560897601305,
-0.003396272484525172,
0.0008253450073212343,
-0.00013381847637162938,
0.00001628461237544918,
-1.586478295617065e-6,
1.2915807676350892e-7,
-8.997013382959989e-9,
// [0.5,1.]: m=35 maxabs=1.6580486983386322e-14 maxrel=1.91432089075972e-12
0.006792544969042169,
-0.003301380020708838,
0.0008029108590143017,
-0.00013027724204361246,
0.000015864772496801603,
-1.5466037610562247e-6,
1.259916554290043e-7,
-8.781715636530492e-9,
// [0.5,1.]: m=36 maxabs=1.6198847818671425e-14 maxrel=1.923653025793748e-12
0.006602760041409676,
-0.003211643427681543,
0.0007816634530284809,
-0.0001269185149955959,
0.000015466027391053764,
-1.5086836810837862e-6,
1.229767163070563e-7,
-8.576472412780917e-9,
// [0.5,1.]: m=37 maxabs=1.5839760059144226e-14 maxrel=1.9332226336533125e-12
0.006423286855355264,
-0.0031266538039294387,
0.0007615110907248795,
-0.00012372854650160775,
0.000015086826797816308,
-1.4725778455829474e-6,
1.2010264219588944e-7,
-8.380606229072273e-9,
// [0.5,1.]: m=38 maxabs=1.5491080640472887e-14 maxrel=1.9417305008209367e-12
0.006253307607851234,
-0.003046044354897982,
0.0007423712797435801,
-0.00012069493444171034,
0.000014725768671108408,
-1.4381591479857932e-6,
1.1735979420417085e-7,
-8.193479287941075e-9,
// [0.5,1.]: m=39 maxabs=1.5160615818299306e-14 maxrel=1.9502836328468543e-12
0.006092088709788461,
-0.0029694851111474823,
0.0007241696073697399,
-0.00011780646243921534,
0.000014381581890506633,
-1.405312070282863e-6,
1.1473938702617291e-7,
-8.014529618955606e-9,
// [0.5,1.]: m=40 maxabs=1.4840559336981585e-14 maxrel=1.9580321009309876e-12
0.0059389702222876276,
-0.0028966784218192243,
0.0007068387753382312,
-0.00011505296150644142,
0.000014053111331170004,
-1.3739314098642542e-6,
1.1223340177612003e-7,
-7.84322643289348e-9
},
{
// [1.,1.5]: m=0 maxabs=5.795364188543317e-14 maxrel=7.760011941123063e-14
0.7024234313969104,
-0.08318372690734321,
0.01062987823653928,
-0.0011557527698907095,
0.00010607082572914465,
-8.341290834362573e-6,
5.723949562944893e-7,
-3.4662256857854546e-8,
// [1.,1.5]: m=1 maxabs=5.129230373768223e-14 maxrel=2.7071129306794425e-13
0.1663674538146601,
-0.04251951291677796,
0.006934516621862405,
-0.0008485677806003662,
0.00008341287477209323,
-6.857463589136635e-6,
4.853790464573009e-7,
-3.0066373375641155e-8,
// [1.,1.5]: m=2 maxabs=4.581057755359552e-14 maxrel=4.568776967620602e-13
0.08503902583353165,
-0.027738066461528474,
0.005091406685861164,
-0.0006673040347543273,
0.00006857460623413862,
-5.81459793201449e-6,
4.210233264794111e-7,
-2.6534619528060602e-8,
// [1.,1.5]: m=3 maxabs=4.1494585545365226e-14 maxrel=6.218068495962204e-13
0.05547613292303671,
-0.020365626720261272,
0.004003824210474224,
-0.0005485977771681699,
0.00005814595332157146,
-5.043378019814367e-6,
3.715678903712286e-7,
-2.373823198260165e-8,
// [1.,1.5]: m=4 maxabs=3.785166624581393e-14 maxrel=7.6278101513451e-13
0.040731253440503885,
-0.016015296820927526,
0.003291586664802797,
-0.0004651684653077274,
0.0000504337562733864,
-4.450763027582442e-6,
3.3241183164118305e-7,
-2.1470796802837308e-8,
// [1.,1.5]: m=5 maxabs=3.480549182199866e-14 maxrel=8.841765938271223e-13
0.03203059364183793,
-0.013166346640073009,
0.0027910107934935595,
-0.0004034708156841857,
0.00004450760829927266,
-3.981593370154883e-6,
3.006614943786509e-7,
-1.9595995410905315e-8,
// [1.,1.5]: m=6 maxabs=3.222422328974517e-14 maxrel=9.89473682307492e-13
0.026332693280130045,
-0.011164043156375307,
0.0024208248956346986,
-0.00035606157033188395,
0.0000398159133201108,
-3.601180210110211e-6,
2.744091271574088e-7,
-1.8020482604705348e-8,
// [1.,1.5]: m=7 maxabs=2.998989945268704e-14 maxrel=1.0808728223776606e-12
0.022328086312735737,
-0.009683299566250976,
0.002136369423416634,
-0.00031852795806266857,
0.000036011783105544825,
-3.2866551654379394e-6,
2.5234754210746427e-7,
-1.6678213748229658e-8,
// [1.,1.5]: m=8 maxabs=2.8036600818737156e-14 maxrel=1.1606814079749635e-12
0.019366599132488015,
-0.008545477678508714,
0.0019111677497113694,
-0.00028809487114862353,
0.000032866533865278015,
-3.0223500331380354e-6,
2.3355187479632806e-7,
-1.5521181117737856e-8,
// [1.,1.5]: m=9 maxabs=2.6336571812279885e-14 maxrel=1.2318160586835856e-12
0.017090955357004448,
-0.007644670984671394,
0.0017285692281390943,
-0.00026293283787172806,
0.000030223483695230765,
-2.7971798449288163e-6,
2.173497754372625e-7,
-1.4513634039410047e-8,
// [1.,1.5]: m=10 maxabs=2.4816954047324202e-14 maxrel=1.2943742121253036e-12
0.015289341969330529,
-0.006914276899247254,
0.0015775970284071352,
-0.0002417884019278899,
0.000027971782773599547,
-2.603086611140667e-6,
2.0324100105439597e-7,
-1.3628456199754226e-8,
// [1.,1.5]: m=11 maxabs=2.3463869736062293e-14 maxrel=1.3503524052837054e-12
0.01382855379848292,
-0.006310388101084336,
0.0014507304126791221,
-0.00022377476394529,
0.000026030851293909978,
-2.434075211011128e-6,
1.9084579428202002e-7,
-1.2844705164724931e-8,
// [1.,1.5]: m=12 maxabs=2.225997164373439e-14 maxrel=1.4012738424583736e-12
0.012620776202157714,
-0.005802921638854913,
0.0013426485847240091,
-0.00020824728480862466,
0.00002434073807768125,
-2.2855947803462767e-6,
1.7987077537356995e-7,
-1.2145934263730419e-8,
// [1.,1.5]: m=13 maxabs=2.1167095853869e-14 maxrel=1.446892364133262e-12
0.011605843277699403,
-0.005370594327646203,
0.0012494837098519828,
-0.00019472635460025,
0.000022855934469465255,
-2.1541295958062815e-6,
1.700857405472307e-7,
-1.1519064396786151e-8,
// [1.,1.5]: m=14 maxabs=2.017830347256222e-14 maxrel=1.4884581098807815e-12
0.01074118865528246,
-0.004997934828710605,
0.001168358128555936,
-0.00018284790363605794,
0.00002154128323971702,
-2.0369212796512673e-6,
1.6130758771819764e-7,
-1.0953563401778441e-8,
// [1.,1.5]: m=15 maxabs=1.9269308371150373e-14 maxrel=1.5257096320427558e-12
0.009995869657411694,
-0.004673432504027468,
0.0010970874227300368,
-0.00017233067376586135,
0.000020369200616397068,
-1.931775718695119e-6,
1.533888609475683e-7,
-1.0440880540713496e-8,
// [1.,1.5]: m=16 maxabs=1.8453988337441274e-14 maxrel=1.5610963085252614e-12
0.00934686500804586,
-0.004388349681180231,
0.0010339840434662269,
-0.00016295399453362155,
0.000019317745570954155,
-1.836926122546346e-6,
1.4620950265814394e-7,
-9.973919253814266e-9,
// [1.,1.5]: m=17 maxabs=1.7687240561059525e-14 maxrel=1.5920651221443224e-12
0.008776699362351686,
-0.004135936164541593,
0.00097772396804395,
-0.00015454233749408845,
0.000018369250000205955,
-1.7509339507190109e-6,
1.3967078038524935e-7,
-9.546888340112308e-9,
// [1.,1.5]: m=18 maxabs=1.699508589414478e-14 maxrel=1.6218771439894679e-12
0.008271872329074788,
-0.003910895863235318,
0.0009272540257698152,
-0.00014695435761872703,
0.000017509328776823577,
-1.6726162710449575e-6,
1.336907555800867e-7,
-9.154845577929458e-9,
// [1.,1.5]: m=19 maxabs=1.634803403760543e-14 maxrel=1.6487621257382756e-12
0.00782179172646256,
-0.0037090160944917524,
0.0008817261464870895,
-0.00014007497371668968,
0.000016726152383534226,
-1.6009914402355049e-6,
1.2820088379492327e-7,
-8.79367929961778e-9,
// [1.,1.5]: m=20 maxabs=1.5759962779249292e-14 maxrel=1.6749215465399657e-12
0.007418032188975719,
-0.003526904577686449,
0.000840449843047186,
-0.0001338095495394696,
0.000016009904446580247,
-1.5352381213196034e-6,
1.2314335825665613e-7,
-8.459883036455802e-9,
// [1.,1.5]: m=21 maxabs=1.520138181998476e-14 maxrel=1.698015373971363e-12
0.007053809155365381,
-0.0033617993642294274,
0.0008028572979579992,
-0.00012807955394747737,
0.000015352371598952917,
-1.4746638848747048e-6,
1.1846912525370474e-7,
-8.150470478986715e-9,
// [1.,1.5]: m=22 maxabs=1.4682699500667695e-14 maxrel=1.7197381635180528e-12
0.006723598728451615,
-0.003211429184153161,
0.0007684773243801699,
-0.00012281927993919702,
0.00001474662957751938,
-1.41868091532138e-6,
1.1413625527215573e-7,
-7.862859256147254e-9,
// [1.,1.5]: m=23 maxabs=1.4191772756966259e-14 maxrel=1.739247567590967e-12
0.006422858368299326,
-0.0030739092901036712,
0.0007369156803073816,
-0.0001179733332971816,
0.000014186800188239641,
-1.3667869862222284e-6,
1.1010872161362029e-7,
-7.594835502075274e-9,
// [1.,1.5]: m=24 maxabs=1.3740744653212289e-14 maxrel=1.7585465672406664e-12
0.006147818580200572,
-0.002947662714056927,
0.0007078400004326548,
-0.00011349468840512659,
0.000013667861206114834,
-1.318550460569992e-6,
1.0635538275394797e-7,
-7.344455351834844e-9,
// [1.,1.5]: m=25 maxabs=1.3318339486811936e-14 maxrel=1.7767781164249407e-12
0.005895325428107298,
-0.0028313599947869953,
0.0006809681310597803,
-0.00010934316738886381,
0.0000131854962221623,
-1.2735983157415527e-6,
1.0284919360036353e-7,
-7.11003147680312e-9,
// [1.,1.5]: m=26 maxabs=1.2915883640385317e-14 maxrel=1.793202113791862e-12
0.005662719989567613,
-0.002723872517510351,
0.0006560590049453169,
-0.00010548423892474974,
0.000012735974997970707,
-1.2316065242277322e-6,
9.956654661125394e-8,
-6.890102612124872e-9,
// [1.,1.5]: m=27 maxabs=1.2542050731312315e-14 maxrel=1.8093931051253147e-12
0.005447745035014519,
-0.0026242360132544967,
0.0006329054341416349,
-0.00010188806105439794,
0.00001231605733387667,
-1.1922922920810742e-6,
9.648674472743123e-8,
-6.683355603689168e-9,
// [1.,1.5]: m=28 maxabs=1.218643241873707e-14 maxrel=1.824257822932542e-12
0.005248472026502989,
-0.002531621730229895,
0.0006113283669026801,
-0.0000985287121346735,
0.000011922915236502886,
-1.1554076935642853e-6,
9.359156961868284e-8,
-6.48864099873404e-9,
// [1.,1.5]: m=29 maxabs=1.1853365511349523e-14 maxrel=1.838764550571558e-12
0.00506324346045394,
-0.002445313461453323,
0.0005911722733692653,
-0.00009538356818330472,
0.000011554069453813548,
-1.1207344657485208e-6,
9.086491371006848e-8,
-6.304941155973302e-9,
// [1.,1.5]: m=30 maxabs=1.1532441668293814e-14 maxrel=1.8516085474562443e-12
0.004890626922900947,
-0.0023646890874892954,
0.0005723014096465466,
-0.00009243279513765134,
0.000011207337369231858,
-1.0880797068795316e-6,
8.829249583055088e-8,
-6.131348277017262e-9,
// [1.,1.5]: m=31 maxabs=1.1233201868687814e-14 maxrel=1.8645704803267974e-12
0.0047293781749730346,
-0.002289205632758862,
0.0005545967713587499,
-0.00008965893204395534,
0.000010880789966898415,
-1.0572722963407803e-6,
8.586159741287833e-8,
-5.967056611070383e-9,
// [1.,1.5]: m=32 maxabs=1.094783985688963e-14 maxrel=1.8766647841711693e-12
0.004578411265512336,
-0.0022183870797598385,
0.0005379535927811133,
-0.00008704654674112353,
0.000010572716065716816,
-1.0281599170251134e-6,
8.356086300471139e-8,
-5.8113270217388705e-9,
// [1.,1.5]: m=33 maxabs=1.067635563289926e-14 maxrel=1.88811695994451e-12
0.004436774159514422,
-0.0021518143655935395,
0.0005222792809514316,
-0.00008458194975938776,
0.000010281592440004129,
-1.0006065279737314e-6,
8.138011778768186e-8,
-5.6635167509123e-9,
// [1.,1.5]: m=34 maxabs=1.0417014473240727e-14 maxrel=1.8988363962813154e-12
0.00430362873118195,
-0.002089117118411963,
0.0005074916990483331,
-0.00008225295526696438,
0.00001000605872128593,
-9.744902631435866e-7,
7.931021858081875e-8,
-5.5230283949665415e-9,
// [1.,1.5]: m=35 maxabs=1.0172418463127997e-14 maxrel=1.9095089533366303e-12
0.004178234236818907,
-0.0020299667909302577,
0.0004935177320833019,
-0.00008004868029173365,
9.744896213189192e-6,
-9.497016202397511e-7,
7.734293230469829e-8,
-5.389339668645384e-9,
// [1.,1.5]: m=36 maxabs=9.938230793871128e-15 maxrel=1.919536878180943e-12
0.0040599335818556105,
-0.0019740709231943886,
0.0004802920822208031,
-0.00007795937525348766,
9.497009932538405e-6,
-9.261419433775373e-7,
7.547081586292161e-8,
-5.26196584587658e-9,
// [1.,1.5]: m=37 maxabs=9.711849380256155e-15 maxrel=1.9285727211881378e-12
0.003948141846383999,
-0.0019211683238630824,
0.0004677562519802688,
-0.00007597628026170903,
9.261413306789543e-6,
-9.037221092197213e-7,
7.368713163395083e-8,
-5.140468972401869e-9,
// [1.,1.5]: m=38 maxabs=9.498478392711007e-15 maxrel=1.9378051074741445e-12
0.003842336647721466,
-0.0018710250030143215,
0.0004558576820206606,
-0.00007409150272389864,
9.037215091154235e-6,
-8.823614005110646e-7,
7.198576083695361e-8,
-5.02445361379389e-9,
// [1.,1.5]: m=39 maxabs=9.292046299069767e-15 maxrel=1.946174158813649e-12
0.0037420500060240435,
-0.0018234307232842437,
0.00044454901678418215,
-0.00007229791266574368,
8.823608131937201e-6,
-8.619865421183153e-7,
7.036113851189507e-8,
-4.91355906015385e-9,
// [1.,1.5]: m=40 maxabs=9.096889908022376e-15 maxrel=1.954724614553538e-12
0.003646861446564009,
-0.0017781960624418584,
0.0004337874764244577,
-0.00007058905284734813,
8.619859684792903e-6,
-8.425308666228172e-7,
6.880818708230206e-8,
-4.8074465701622525e-9
},
{
// [1.5,2.]: m=0 maxabs=3.7414515929867775e-14 maxrel=5.6402295292533146e-14
0.6288120982551069,
-0.06500545068637688,
0.007723527171441156,
-0.000804566329115313,
0.00007184539872947243,
-5.544940252809949e-6,
3.753853406319305e-7,
-2.2502900500837e-8,
// [1.5,2.]: m=1 maxabs=3.2807090377673376e-14 maxrel=2.2357252163440913e-13
0.13001090137273852,
-0.03089410866683112,
0.004827397976214841,
-0.000574763946722431,
0.00005544938240877851,
-4.49736041636672e-6,
3.151047836098216e-7,
-1.9365776038485654e-8,
// [1.5,2.]: m=2 maxabs=2.921274333544943e-14 maxrel=4.0369421658328357e-13
0.061788217333647553,
-0.01930959188827018,
0.0034485836817401317,
-0.0004435957227808949,
0.00004497358545086678,
-3.774888137453038e-6,
2.71180718287428e-7,
-1.6983928497738224e-8,
// [1.5,2.]: m=3 maxabs=2.6277591214096674e-14 maxrel=5.684199782832476e-13
0.038619183776527365,
-0.013794334712198052,
0.0026615743379381543,
-0.0003597892740998014,
0.00003774886464820332,
-3.248499896853594e-6,
2.3782856261664634e-7,
-1.511662193466603e-8,
// [1.5,2.]: m=4 maxabs=2.3925306180672123e-14 maxrel=7.143721963675906e-13
0.027588669424384364,
-0.010646297338455525,
0.0021587356457250084,
-0.000301991449041698,
0.000032484983960187216,
-2.8488370955389033e-6,
2.1168071480906482e-7,
-1.3614793160758674e-8,
// [1.5,2.]: m=5 maxabs=2.1926904736346842e-14 maxrel=8.40194957529392e-13
0.02129259467690017,
-0.008634942570808499,
0.0018119486952956143,
-0.00025988035534160666,
0.000028488357020400283,
-2.535525444064478e-6,
1.9065167708068905e-7,
-1.238168971813313e-8,
// [1.5,2.]: m=6 maxabs=8.873457524316564e-14 maxrel=4.163254887197986e-12
0.017269885141580062,
-0.0072477947681872865,
0.0015592821270721455,
-0.00022790732725678557,
0.000025355308659585694,
-2.28343783223844e-6,
1.732096229169124e-7,
-1.1531276092220351e-8,
// [1.5,2.]: m=7 maxabs=1.8797463585684682e-14 maxrel=1.045298614319481e-12
0.014495589540183054,
-0.006237128521792625,
0.001367443798469066,
-0.000202842342825831,
0.000022835620589470665,
-2.076683949409076e-6,
1.5895974930986287e-7,
-1.047843405536351e-8,
// [1.5,2.]: m=8 maxabs=1.7536319618649543e-14 maxrel=1.128637340682839e-12
0.012474257043576598,
-0.005469775184374681,
0.001217054057785108,
-0.000182685344771556,
0.000020766828414751572,
-1.9038685107479132e-6,
1.467335524873359e-7,
-9.729185028453377e-9,
// [1.5,2.]: m=9 maxabs=1.6438239658356224e-14 maxrel=1.2025310848562544e-12
0.010939550368741224,
-0.004868216222274192,
0.001096112069406595,
-0.00016613498197851317,
0.000019038674747876665,
-1.7573978825581797e-6,
1.3624173283487346e-7,
-9.079310515665043e-9,
// [1.5,2.]: m=10 maxabs=1.5485876470044957e-14 maxrel=1.2695371394439956e-12
0.009736432444540696,
-0.004384448269314831,
0.000996809892606092,
-0.00015230973043639168,
0.000017573969039133363,
-1.6317092915644743e-6,
1.2714163827153303e-7,
-8.51057659618131e-9,
// [1.5,2.]: m=11 maxabs=1.4611575838152646e-14 maxrel=1.3271638981993756e-12
0.008768896538622825,
-0.003987239562598211,
0.0009138583832609866,
-0.00014059206527363853,
0.00001631708449428219,
-1.52269601056888e-6,
1.191747623987256e-7,
-8.00821188074786e-9,
// [1.5,2.]: m=12 maxabs=1.383788916786699e-14 maxrel=1.379595057460085e-12
0.007974479125189622,
-0.0036554335256590827,
0.0008435523922950461,
-0.00013053697134262872,
0.000015226951394327714,
-1.4272614626398718e-6,
1.1214284587492669e-7,
-7.561750821652746e-9,
// [1.5,2.]: m=13 maxabs=1.3145734500952244e-14 maxrel=1.4273420358369076e-12
0.007310867051311691,
-0.00337420956218542,
0.0007832218286774824,
-0.000121815890937916,
0.000014272606337622745,
-1.3430282741201594e-6,
1.0589103431065748e-7,
-7.1622557504409935e-9,
// [1.5,2.]: m=14 maxabs=1.2516029879172663e-14 maxrel=1.4702704454138742e-12
0.006748419124364677,
-0.0031328873080667054,
0.0007308953462190449,
-0.00011418111643110672,
0.000013430274856164702,
-1.2681414009001532e-6,
1.0029680433285898e-7,
-6.802696721737299e-9,
// [1.5,2.]: m=15 maxabs=1.194704057905227e-14 maxrel=1.5097802587790718e-12
0.006265774616127505,
-0.0029235813785502885,
0.0006850866991535312,
-0.00010744245187754534,
0.000012681406453294019,
-1.2011326092129221e-6,
9.526192627385635e-8,
-6.477408676738215e-9,
// [1.5,2.]: m=16 maxabs=1.1422286727569286e-14 maxrel=1.545229232872767e-12
0.0058471627570949505,
-0.0027403467905772103,
0.0006446547118051203,
-0.00010145149310153766,
0.000012011318893388976,
-1.1408249647996646e-6,
9.070675765572032e-8,
-6.181712308053304e-9,
// [1.5,2.]: m=17 maxabs=1.0946105133413653e-14 maxrel=1.578399411343608e-12
0.0054806935811490326,
-0.0025786188414471827,
0.0006087089591265603,
-0.00009609078207741247,
0.0000114082427490655,
-1.0862641726840195e-6,
8.656605002627673e-8,
-5.911762405641599e-9,
// [1.5,2.]: m=18 maxabs=1.0505485370515544e-14 maxrel=1.6085784435548176e-12
0.005157237682889197,
-0.0024348358309744206,
0.0005765446929607969,
-0.00009126616326074396,
0.000010862635110178718,
-1.0366684536438242e-6,
8.278584323979124e-8,
-5.664335966320954e-9,
// [1.5,2.]: m=19 maxabs=1.0102162162350936e-14 maxrel=1.6369842226991234e-12
0.004869671661943839,
-0.0023061787665337222,
0.0005475969800439448,
-0.00008690129325841813,
0.000010366678148431585,
-9.913913194279065e-7,
7.932113519307015e-8,
-5.4367492800977926e-9,
// [1.5,2.]: m=20 maxabs=9.72485980632598e-15 maxrel=1.6626759633457375e-12
0.004612357533062657,
-0.0021903879150715136,
0.0005214077600102896,
-0.00008293362935641678,
9.913907064890424e-6,
-9.498936073304285e-7,
7.613410113037549e-8,
-5.226697772137387e-9,
// [1.5,2.]: m=21 maxabs=9.378782472868608e-15 maxrel=1.6872777557474221e-12
0.0043807758301383955,
-0.002085631035126822,
0.0004976017765828412,
-0.00007931145309221036,
9.498930150767975e-6,
-9.117221180506759e-7,
7.319271511507414e-8,
-5.032241120823046e-9,
// [1.5,2.]: m=22 maxabs=9.054389182860945e-15 maxrel=1.7098173355188055e-12
0.004171262070249152,
-0.0019904071015932998,
0.00047586871898321206,
-0.00007599163072773757,
9.117215455156164e-6,
-8.76493183505785e-7,
7.046968490787372e-8,
-4.851709005464286e-9,
// [1.5,2.]: m=23 maxabs=8.750812574565003e-15 maxrel=1.7306985252294754e-12
0.003980814203182282,
-0.0019034748713589395,
0.0004559497847809357,
-0.00007293790659626145,
8.764926307911675e-6,
-8.438798491834259e-7,
6.794161237732841e-8,
-4.6836585864659325e-9,
// [1.5,2.]: m=24 maxabs=8.465450562766819e-15 maxrel=1.7499367995865095e-12
0.003806949742713704,
-0.0018237991347029798,
0.0004376274399783368,
-0.00007011958729306091,
8.438793148187728e-6,
-8.136017838315986e-7,
6.558831973768507e-8,
-4.5268376548080114e-9,
// [1.5,2.]: m=25 maxabs=8.200905232680356e-15 maxrel=1.7685778865785662e-12
0.0036475982694018985,
-0.0017505097556356872,
0.0004207175241476871,
-0.00006751051628894435,
8.136012651660643e-6,
-7.85417262876014e-7,
6.339231521634165e-8,
-4.380166206785687e-9,
// [1.5,2.]: m=26 maxabs=7.951105052139695e-15 maxrel=1.7858132956884628e-12
0.003501019511267449,
-0.0016828700924473275,
0.0004050630981099057,
-0.00006508826694621556,
7.854167615129507e-6,
-7.591167657751008e-7,
6.133836448938492e-8,
-4.242683294220641e-9,
// [1.5,2.]: m=27 maxabs=7.71518265940685e-15 maxrel=1.8018333814848304e-12
0.003365740184890848,
-0.0016202523884223433,
0.00039052960204249477,
-0.00006283350160925707,
7.591162790570188e-6,
-7.345177812482457e-7,
5.941313599533438e-8,
-4.1135562370911e-9,
// [1.5,2.]: m=28 maxabs=7.494005416219807e-15 maxrel=1.8172186173647542e-12
0.0032405047768409943,
-0.0015621184042713696,
0.00037700101001003557,
-0.000060729458266520225,
7.345173086037848e-6,
-7.114606043676775e-7,
5.760491197745811e-8,
-3.992045190339423e-9,
// [1.5,2.]: m=29 maxabs=7.284971237364601e-15 maxrel=1.831708583623887e-12
0.0031242368085391318,
-0.00150800403625351,
0.00036437674994468423,
-0.000058761536153341324,
7.114601440285e-6,
-6.898048800505453e-7,
5.590335621919648e-8,
-3.877501726544399e-9,
// [1.5,2.]: m=30 maxabs=7.086779080234251e-15 maxrel=1.8452888474626576e-12
0.003016008072503533,
-0.0014575069960977298,
0.0003525692172549463,
-0.00005691695876207366,
6.8980443353142e-6,
-6.694267738292334e-7,
5.4299311366301534e-8,
-3.769333757060758e-9,
// [1.5,2.]: m=31 maxabs=6.901163668304733e-15 maxrel=1.858716317027895e-12
0.0029150139921920535,
-0.001410276865438671,
0.0003415017528996737,
-0.00005518449792646186,
6.69426337408568e-6,
-6.502165968530566e-7,
5.278463841447536e-8,
-3.667034587236955e-9,
// [1.5,2.]: m=32 maxabs=6.722920831148116e-15 maxrel=1.870879251285835e-12
0.002820553730874023,
-0.001366007008112187,
0.00033110698787748306,
-0.00005355424645159918,
6.5021617196257345e-6,
-6.320768590336491e-7,
5.135207905141752e-8,
-3.5701357902692517e-9,
// [1.5,2.]: m=33 maxabs=6.55508633484736e-15 maxrel=1.8828465812112534e-12
0.002732014016221136,
-0.0013244279481131975,
0.0003213254790201241,
-0.0000520174296255822,
6.320764451872491e-6,
-6.149206138055253e-7,
4.9995139613119935e-8,
-3.4782203174829136e-9,
// [1.5,2.]: m=34 maxabs=6.394190732450511e-15 maxrel=1.8938693344509286e-12
0.0026488558962232474,
-0.001285301912768947,
0.0003121045780559186,
-0.00005056624807495649,
6.149202104971783e-6,
-5.986700730868815e-7,
4.870799089651529e-8,
-3.3909143486979536e-9,
// [1.5,2.]: m=35 maxabs=6.241535066564552e-15 maxrel=1.904530102327549e-12
0.00257060382553482,
-0.001248418308993283,
0.00030339748874481405,
-0.00004919374605439844,
5.986696796455712e-6,
-5.832554344409251e-7,
4.748539064936863e-8,
-3.3078770166033316e-9,
// [1.5,2.]: m=36 maxabs=6.0958182945825e-15 maxrel=1.914640886174609e-12
0.0024968366179835564,
-0.001213589951826056,
0.0002951624766153687,
-0.000047893700498563354,
5.832550491780387e-6,
-5.686138774307012e-7,
4.6322605528671095e-8,
-3.2288110367146775e-9,
// [1.5,2.]: m=37 maxabs=5.956173054766367e-15 maxrel=1.9241072899160476e-12
0.002427179903649178,
-0.0011806499033818756,
0.0002873622032728414,
-0.00004666052711662646,
5.686135023293898e-6,
-5.546887246275316e-7,
4.521535493902991e-8,
-3.1534283371776515e-9,
// [1.5,2.]: m=38 maxabs=5.823900389723136e-15 maxrel=1.9335238408251835e-12
0.0023612998067608732,
-0.0011494488100819884,
0.00027996316297558473,
-0.000045489200558993124,
5.546883570668465e-6,
-5.414286949672151e-7,
4.415975593405417e-8,
-3.0814840746326595e-9,
// [1.5,2.]: m=39 maxabs=5.695530852500852e-15 maxrel=1.94190522532438e-12
0.00229889762016117,
-0.0011198526489601378,
0.00027293520362344203,
-0.000044375186251916994,
5.414283355605933e-6,
-5.287872868581462e-7,
4.3152280607941e-8,
-3.012748641992847e-9,
// [1.5,2.]: m=40 maxabs=5.574967570920464e-15 maxrel=1.9507216385630686e-12
0.0022397052979175303,
-0.0010917408116157428,
0.00026625111777490697,
-0.000043314381964056344,
5.287869357600546e-6,
-5.167222328423391e-7,
4.218971295556376e-8,
-2.94700695978025e-9
},
{
// [2.,2.5]: m=0 maxabs=2.3869795029440866e-14 maxrel=3.990643517883973e-14
0.5707922624165785,
-0.05171033753940945,
0.005690633355124788,
-0.0005658616184509315,
0.00004903366526890262,
-3.7072490297551508e-6,
2.4728091378206547e-7,
-1.466047485809212e-8,
// [2.,2.5]: m=1 maxabs=2.1038726316646716e-14 maxrel=1.8183517511048067e-13
0.10342067507880964,
-0.022762533408287447,
0.003395169711578308,
-0.0003922698110636363,
0.00003707247789699716,
-2.9626785959022963e-6,
2.0528754642130373e-7,
-1.2509243541519407e-8,
// [2.,2.5]: m=2 maxabs=1.8630930131990908e-14 maxrel=3.519066787583468e-13
0.04552506681656534,
-0.01358067883566858,
0.002353618867286078,
-0.0002965802488928068,
0.0000296267739556747,
-2.4593640760295426e-6,
1.7516773553951638e-7,
-1.089659674966763e-8,
// [2.,2.5]: m=3 maxabs=1.6715795414512513e-14 maxrel=5.168017198052216e-13
0.027161357671328892,
-0.009414475459724394,
0.001779481494145063,
-0.00023701456842739382,
0.000024593630257011365,
-2.098395786704131e-6,
1.5258599760288182e-7,
-9.645357181835959e-9,
// [2.,2.5]: m=4 maxabs=1.5126788710517758e-14 maxrel=6.643472626883464e-13
0.01882895091944134,
-0.007117925968134598,
0.001422087411278054,
-0.0001967493798679535,
0.000020983948344858052,
-1.8277890375903661e-6,
1.350655021463988e-7,
-8.647756909283126e-9,
// [2.,2.5]: m=5 maxabs=1.383268499743906e-14 maxrel=7.951039178832883e-13
0.014235851936262346,
-0.005688349637460385,
0.0011804962798636445,
-0.00016787189281582108,
0.00001827788163325064,
-1.6178479807371975e-6,
1.2109657973934226e-7,
-7.834604828514855e-9,
// [2.,2.5]: m=6 maxabs=1.272940086671781e-14 maxrel=9.086694292758047e-13
0.01137669927491445,
-0.004721985112462304,
0.0010072313574998304,
-0.00014622333274416798,
0.000016178471749243937,
-1.450474100349007e-6,
1.0971024134903932e-7,
-7.159552906523513e-9,
// [2.,2.5]: m=7 maxabs=1.1796119636642288e-14 maxrel=1.0086553973332649e-12
0.009443970224918703,
-0.004028925423562966,
0.0008773399970278588,
-0.00012942803143934192,
0.000014504733509037688,
-1.3140514534289604e-6,
1.0025770841134311e-7,
-6.590468907098711e-9,
// [2.,2.5]: m=8 maxabs=1.0984269049885143e-14 maxrel=1.0960115207893982e-12
0.008057850847120438,
-0.003509359982149378,
0.0007765681891621236,
-0.00011603810654325057,
0.000013140507512604593,
-1.2008032624728976e-6,
9.228907292620028e-8,
-6.104427554747395e-9,
// [2.,2.5]: m=9 maxabs=1.0276501871686605e-14 maxrel=1.1731380177874872e-12
0.007018719964293703,
-0.003106272751098562,
0.0006962286397527584,
-0.00010512428213496454,
0.000012008026041263973,
-1.1053372105381807e-6,
8.548304513004397e-8,
-5.684613673676698e-9,
// [2.,2.5]: m=10 maxabs=9.652868782072943e-15 maxrel=1.2414592501141412e-12
0.006212545502192321,
-0.002784914553817137,
0.000630745693270052,
-0.00009606441608364987,
0.000011053365969570896,
-1.02380212098857e-6,
7.960422815237871e-8,
-5.318424386008149e-9,
// [2.,2.5]: m=11 maxabs=9.164544123585472e-15 maxrel=1.3116299825211324e-12
0.005569829107629704,
-0.0025229827682001337,
0.0005763864969400085,
-0.0000884271229573764,
0.00001023801537523478,
-9.533768309032634e-7,
7.447657820032904e-8,
-4.996992181007757e-9,
// [2.,2.5]: m=12 maxabs=8.61116733474887e-15 maxrel=1.3577481242404318e-12
0.005045965536397444,
-0.0023055459831406665,
0.0005305627379718033,
-0.0000819043074929691,
9.533765771938548e-6,
-8.919504712252097e-7,
6.99651564645454e-8,
-4.7106834823215026e-9,
// [2.,2.5]: m=13 maxabs=8.167078124898808e-15 maxrel=1.4068574391781528e-12
0.004611091966277279,
-0.0021222509475357903,
0.0004914258453460523,
-0.00007627030023219676,
8.919499536669629e-6,
-8.379109401250561e-7,
6.596613430145333e-8,
-4.45581961591277e-9,
// [2.,2.5]: m=14 maxabs=7.771561172376096e-15 maxrel=1.4522949225048425e-12
0.004244501895067726,
-0.0019657033772560997,
0.00045762180176243803,
-0.00007135616141376105,
8.379104482968432e-6,
-7.900084770164225e-7,
6.239720447988796e-8,
-4.2269863899804185e-9,
// [2.,2.5]: m=15 maxabs=7.40553451894499e-15 maxrel=1.4922745536453521e-12
0.003931406754508515,
-0.0018304872031233072,
0.0004281369688350601,
-0.00006703299291723436,
7.900080076395661e-6,
-7.47258775496178e-7,
5.919282285768438e-8,
-4.020410878196008e-9,
// [2.,2.5]: m=16 maxabs=7.07940650546135e-15 maxrel=1.5302894005646338e-12
0.003660974406243109,
-0.0017125478715970203,
0.0004021979578393564,
-0.00006320079033909987,
7.472583278022211e-6,
-7.08876492471667e-7,
5.6300075454114376e-8,
-3.833003306180876e-9,
// [2.,2.5]: m=17 maxabs=6.774095173689432e-15 maxrel=1.563650707373301e-12
0.0034250957431906756,
-0.0016087918277809463,
0.000379204742356797,
-0.000059780809282198574,
7.0887606325611976e-6,
-6.742275607530269e-7,
5.367577611709552e-8,
-3.662228783349593e-9,
// [2.,2.5]: m=18 maxabs=6.499141502747108e-15 maxrel=1.5955879360941713e-12
0.003217583655558671,
-0.0015168189660032915,
0.000358684856001436,
-0.00005671022201471953,
6.7422715009007765e-6,
-6.427945660850094e-7,
5.128434106314421e-8,
-3.505966987467994e-9,
// [2.,2.5]: m=19 maxabs=6.244137151778517e-15 maxrel=1.6247078073276194e-12
0.003033637932003496,
-0.0014347394207220796,
0.00034026133238460445,
-0.00005393830335323103,
6.427941708332844e-6,
-6.141511720666297e-7,
4.909619314355516e-8,
-3.3624544085495422e-9,
// [2.,2.5]: m=20 maxabs=6.006913716438689e-15 maxrel=1.6512763113233906e-12
0.0028694788414411906,
-0.0013610453263838223,
0.0003236298204047134,
-0.00005142365984816967,
6.141507914908902e-6,
-5.879429872016748e-7,
4.708654276541635e-8,
-3.2301950572104407e-9,
// [2.,2.5]: m=21 maxabs=5.788338558465611e-15 maxrel=1.6763152514167608e-12
0.002722090652764777,
-0.0012945192785837763,
0.00030854195936406786,
-0.00004913218472274224,
5.879426204913864e-6,
-5.638730411653178e-7,
4.5234466362857284e-8,
-3.1079204251622017e-9,
// [2.,2.5]: m=22 maxabs=5.584074869169342e-15 maxrel=1.6993169513606337e-12
0.0025890385571647927,
-0.0012341678345318987,
0.00029479310860113075,
-0.00004703552661435262,
5.638726883027638e-6,
-5.416906400906908e-7,
4.352217806777885e-8,
-2.9945391700784172e-9,
// [2.,2.5]: m=23 maxabs=5.3958573720258585e-15 maxrel=1.7214579629599838e-12
0.002468335669061127,
-0.0011791724315829894,
0.00028221315994201917,
-0.00004510992792312865,
5.41690298969811e-6,
-5.211827061430151e-7,
4.193446481618328e-8,
-2.8891201076623983e-9,
// [2.,2.5]: m=24 maxabs=5.217180854000247e-15 maxrel=1.74126874979812e-12
0.002358344863163394,
-0.0011288526370425126,
0.00027065956778635057,
-0.000043335332937962096,
5.211823761752862e-6,
-5.021669971789201e-7,
4.045823918128581e-8,
-2.7908535894674435e-9,
// [2.,2.5]: m=25 maxabs=5.051514762044462e-15 maxrel=1.7603741151879459e-12
0.0022577052740825197,
-0.001082638268509664,
0.00026001199786786737,
-0.000041694695524641236,
5.02166677269235e-6,
-4.844867316861743e-7,
3.908218389001179e-8,
-2.6990401642752633e-9,
// [2.,2.5]: m=26 maxabs=4.8949559683375554e-15 maxrel=1.7779265753744811e-12
0.0021652765370169104,
-0.0010400479889196514,
0.00025016817337979955,
-0.000040173436254604717,
4.84486422477867e-6,
-4.680063067045281e-7,
3.779645710741879e-8,
-2.613061168546277e-9,
// [2.,2.5]: m=27 maxabs=4.747938153748521e-15 maxrel=1.7944886729490543e-12
0.002080095977836954,
-0.0010006726910461114,
0.00024104061775284813,
-0.00003875901272042079,
4.680060064586039e-6,
-4.5260783826167973e-7,
3.6592464335520375e-8,
-2.5323819154069293e-9,
// [2.,2.5]: m=28 maxabs=4.610461318277359e-15 maxrel=1.8104789464997755e-12
0.0020013453820899446,
-0.0009641624686123702,
0.00023255407654105032,
-0.00003744057647601986,
4.526075469886579e-6,
-4.381883701456893e-7,
3.546266574530238e-8,
-2.456524056759607e-9,
// [2.,2.5]: m=29 maxabs=4.47948969584111e-15 maxrel=1.825079684792718e-12
0.0019283249372225154,
-0.0009302163038349595,
0.00022464345906921763,
-0.000036208696927495555,
4.381880862228404e-6,
-4.2465758038087075e-7,
3.440041973917837e-8,
-2.3850747959126642e-9,
// [2.,2.5]: m=30 maxabs=4.357191690784745e-15 maxrel=1.839491721602919e-12
0.001860432607667765,
-0.0008985738340135118,
0.0002172521817713935,
-0.00003505513743182766,
4.246573051928573e-6,
-4.119359133670534e-7,
3.339985370842033e-8,
-2.317655352039176e-9,
// [2.,2.5]: m=31 maxabs=4.240097856156311e-15 maxrel=1.8525808911117233e-12
0.0017971476680249262,
-0.0008690087248844297,
0.00021033082479204553,
-0.000033972672460431346,
4.119356452690003e-6,
-3.999530159027604e-7,
3.245575507609197e-8,
-2.2539369051135243e-9,
// [2.,2.5]: m=32 maxabs=4.13167763890776e-15 maxrel=1.866142786407575e-12
0.0017380174497668112,
-0.0008413232970259788,
0.00020383603495883397,
-0.00003295493731028054,
3.999527544096759e-6,
-3.8864644985303694e-7,
3.156348191682083e-8,
-2.193623233647111e-9,
// [2.,2.5]: m=33 maxabs=4.026293187742169e-15 maxrel=1.8779301588476445e-12
0.0016826465940499625,
-0.0008153441377488913,
0.0001977296240529799,
-0.00003199630380900125,
3.886461948381365e-6,
-3.7796061061768863e-7,
3.071888633251976e-8,
-2.136449651692591e-9,
// [2.,2.5]: m=34 maxabs=3.9256792261355145e-15 maxrel=1.8889108037774636e-12
0.0016306882754958377,
-0.0007909184941785214,
0.00019197782304048017,
-0.00003109177692241606,
3.7796036200899864e-6,
-3.6784581869066534e-7,
2.991825173563623e-8,
-2.082176630869232e-9,
// [2.,2.5]: m=35 maxabs=3.831570477563773e-15 maxrel=1.900155054580822e-12
0.0015818369883551415,
-0.0007679112901789184,
0.0001865506617166482,
-0.000030236908280574453,
3.6784557597661914e-6,
-3.5825755022828807e-7,
2.915823775053824e-8,
-2.030590509026767e-9,
// [2.,2.5]: m=36 maxabs=3.7409311759439845e-15 maxrel=1.9103996144142423e-12
0.0015358225803559855,
-0.0007462026449314877,
0.00018142144986082377,
-0.00002942772348120894,
3.5825731381747463e-6,
-3.4915578896508653e-7,
2.8435832201538506e-8,
-1.9814948091132505e-9,
// [2.,2.5]: m=37 maxabs=3.653978161710647e-15 maxrel=1.919911180635953e-12
0.0014924052898611674,
-0.0007256857975539101,
0.00017656634106049082,
-0.000028660660680513584,
3.4915555807077824e-6,
-3.4050446727733464e-7,
2.7748315236787193e-8,
-1.9347144911581473e-9,
// [2.,2.5]: m=38 maxabs=3.5711451157327545e-15 maxrel=1.929086495420694e-12
0.001451371595106053,
-0.0007062653623960975,
0.0001719639642523549,
-0.000027932518478815697,
3.4050424168914693e-6,
-3.3227099347104513e-7,
2.7093220706092154e-8,
-1.8900890427998144e-9,
// [2.,2.5]: m=39 maxabs=3.492865718879301e-15 maxrel=1.9383479998787447e-12
0.001412530724790468,
-0.0006878558552052044,
0.00016759511103850455,
-0.000027240411502941758,
3.3227077270620076e-6,
-3.244258423846498e-7,
2.646831073760339e-8,
-1.8474733651153086e-9,
// [2.,2.5]: m=40 maxabs=3.417622088108807e-15 maxrel=1.9470320129889215e-12
0.0013757117104087138,
-0.0006703804423896319,
0.00016344246918000984,
-0.00002658173239210864,
3.24425626034006e-6,
-3.169422028176618e-7,
2.5871548764295305e-8,
-1.8067365324586533e-9
},
{
// [2.5,3.]: m=0 maxabs=1.5654144647214707e-14 maxrel=2.8655271275652815e-14
0.5242522560799032,
-0.041847672261198905,
0.004253594828355123,
-0.0004023330753386338,
0.00003373862143556551,
-2.493982023680281e-6,
1.636766080889586e-7,
-9.587122021436658e-9,
// [2.5,3.]: m=1 maxabs=1.3572476476042539e-14 maxrel=1.4618992454609164e-13
0.08369534452238862,
-0.01701437930549703,
0.0024139984528086973,
-0.0002699092882400792,
0.00002493981012895318,
-1.96107926663901e-6,
1.342518844734822e-7,
-8.105118827349819e-9,
// [2.5,3.]: m=2 maxabs=1.394717674685353e-15 maxrel=3.549998623615018e-14
0.03402875861099553,
-0.009655993804128168,
0.0016194557297479855,
-0.00019951876324327266,
0.000019610781790526014,
-1.6083413953503005e-6,
1.1351412246870553e-7,
-7.1011972732699995e-9,
// [2.5,3.]: m=3 maxabs=1.0623446566881967e-14 maxrel=4.644974914427114e-13
0.019311987608769666,
-0.006477822914066181,
0.001197112529673008,
-0.00015688652014944336,
0.000016083934930432875,
-1.3596458522863695e-6,
9.814348139493797e-8,
-6.167317219302441e-9,
// [2.5,3.]: m=4 maxabs=9.591286098675766e-15 maxrel=6.147404200264652e-13
0.012955645828127527,
-0.004788450113318335,
0.0009413191213559406,
-0.0001286716943883945,
0.00001359645241232108,
-1.1756583060879095e-6,
8.636198105852381e-8,
-5.502617458807314e-9,
// [2.5,3.]: m=5 maxabs=8.734332701543224e-15 maxrel=7.486414201721261e-13
0.009576900226632334,
-0.003765276480574677,
0.0007720301667463084,
-0.0001087718132504852,
0.00001175657751711254,
-1.034481882545589e-6,
7.705437802744268e-8,
-4.964974039676946e-9,
// [2.5,3.]: m=6 maxabs=8.017891905964802e-15 maxrel=8.667799970617099e-13
0.007530552961145342,
-0.003088120662569523,
0.0006526308798862873,
-0.00009405279676420035,
0.000010344813721415254,
-9.229569301583892e-7,
6.95259588555636e-8,
-4.521582912372741e-9,
// [2.5,3.]: m=7 maxabs=7.40553451894499e-15 maxrel=9.701322381282014e-13
0.006176241325135374,
-0.002610523515492137,
0.0005643167809375243,
-0.00008275867188419544,
9.22956460469278e-6,
-8.327552619420161e-7,
6.331719117910926e-8,
-4.149915653156702e-9,
// [2.5,3.]: m=8 maxabs=6.884250114413959e-15 maxrel=1.0617954898557916e-12
0.00522104703098087,
-0.0022572671200059595,
0.000496552031632522,
-0.00007383666660500697,
8.327548255446037e-6,
-7.583685268599234e-7,
5.8112783188158945e-8,
-3.834038664063267e-9,
// [2.5,3.]: m=9 maxabs=6.42194630806614e-15 maxrel=1.1412294528421783e-12
0.004514534240008657,
-0.0019862081230507607,
0.0004430199999373362,
-0.0000666205252049678,
7.583681179309862e-6,
-6.960174824399574e-7,
5.368962128270009e-8,
-3.5624007243648715e-9,
// [2.5,3.]: m=10 maxabs=6.027296717281416e-15 maxrel=1.213608325193781e-12
0.003972416246099186,
-0.0017720799964986017,
0.00039972315149520966,
-0.00006066957939316966,
6.960171135926045e-6,
-6.430280008867663e-7,
4.9885591697957656e-8,
-3.3263419618350795e-9,
// [2.5,3.]: m=11 maxabs=5.672545766444159e-15 maxrel=1.2770274137682456e-12
0.003544159992994406,
-0.0015988926029343877,
0.0003640174766274777,
-0.00005568149094159789,
6.430276430303468e-6,
-5.974573202554051e-7,
4.6580238587650105e-8,
-3.119382354244881e-9,
// [2.5,3.]: m=12 maxabs=5.154730808865082e-15 maxrel=1.2834960196509813e-12
0.0031977852058660316,
-0.0014560699036413715,
0.00033408894591285604,
-0.0000514423261884476,
5.974569694180795e-6,
-5.578612715416123e-7,
4.3682543824589034e-8,
-2.937560470682184e-9,
// [2.5,3.]: m=13 maxabs=5.079270337660091e-15 maxrel=1.3863312970326196e-12
0.0029121398072817924,
-0.0013363557809111676,
0.000308653957146054,
-0.00004779666675450102,
5.578613516593822e-6,
-5.231466635371454e-7,
4.112113893560621e-8,
-2.7737149086278204e-9,
// [2.5,3.]: m=14 maxabs=4.825567029298483e-15 maxrel=1.4329241365841661e-12
0.002672711561819941,
-0.0012346158260178122,
0.0002867800007562392,
-0.00004462901078781776,
5.231463581384599e-6,
-4.924681872989566e-7,
3.884177915784921e-8,
-2.6279296447478162e-9,
// [2.5,3.]: m=15 maxabs=4.595282487862562e-15 maxrel=1.4750739499516785e-12
0.002469231652033336,
-0.0011471200005867279,
0.00026777406494585737,
-0.00004185180617745373,
4.9246789566274455e-6,
-4.6516510921450704e-7,
3.680034370020271e-8,
-2.49662167462508e-9,
// [2.5,3.]: m=16 maxabs=4.386681989876351e-15 maxrel=1.513799661217032e-12
0.0022942400011712817,
-0.0010710962574614399,
0.0002511108372735249,
-0.000039397524533513964,
4.651648307439406e-6,
-4.407124695080775e-7,
3.496161693005227e-8,
-2.3777482747168386e-9,
// [2.5,3.]: m=17 maxabs=4.197163450125885e-15 maxrel=1.5496544473219251e-12
0.0021421925149207968,
-0.0010044433468776363,
0.00023638514740045917,
-0.00003721327511710115,
4.407122038864724e-6,
-4.1868829265240267e-7,
3.329697405432178e-8,
-2.2696277857110355e-9,
// [2.5,3.]: m=18 maxabs=4.020655336445245e-15 maxrel=1.5815910141283338e-12
0.00200888669375329,
-0.0009455405874818464,
0.000223279650892907,
-0.00003525706110997438,
4.186880387769008e-6,
-3.9874961588387965e-7,
3.178291772862662e-8,
-2.1708698091372727e-9,
// [2.5,3.]: m=19 maxabs=3.860627095786384e-15 maxrel=1.6119699796967386e-12
0.0018910811749617796,
-0.0008931186015400164,
0.00021154236684296944,
-0.00003349512436551031,
3.987493719806069e-6,
-3.8061489108609775e-7,
3.039997838814707e-8,
-2.080312490616234e-9,
// [2.5,3.]: m=20 maxabs=3.71057351511439e-15 maxrel=1.6390893500668753e-12
0.0017862372030781944,
-0.0008461694654216998,
0.00020097074636931086,
-0.00003190002776500506,
3.8061465610423856e-6,
-3.640508760145552e-7,
2.913189600663245e-8,
-1.9969821260203328e-9,
// [2.5,3.]: m=21 maxabs=3.574397722250211e-15 maxrel=1.6654731696079319e-12
0.0016923389308416317,
-0.0008038829836022491,
0.00019140016675959546,
-0.000030449247489428673,
3.640506499851135e-6,
-3.4886273687589574e-7,
2.7964981501690772e-8,
-1.920046743991644e-9,
// [2.5,3.]: m=22 maxabs=3.445594504158933e-15 maxrel=1.6889261543355415e-12
0.0016077659672027915,
-0.0007656006652328982,
0.00018269548510004257,
-0.000029124124217844955,
3.4886251892190005e-6,
-3.348864770519367e-7,
2.6887630945720753e-8,
-1.8488005153372444e-9,
// [2.5,3.]: m=23 maxabs=3.3263322651855276e-15 maxrel=1.7110877947033675e-12
0.0015312013304641476,
-0.0007307819386593392,
0.00017474474546510594,
-0.00002790907114717247,
3.348862664171098e-6,
-3.2198308629342677e-7,
2.5889946696501896e-8,
-1.7826377096327846e-9,
// [2.5,3.]: m=24 maxabs=3.2159604840265033e-15 maxrel=1.732291958427008e-12
0.0014615638773170891,
-0.0006989789801796903,
0.00016745442703546985,
-0.000026790968541620135,
3.2198288307022715e-6,
-3.100339721524549e-7,
2.4963431431577972e-8,
-1.7210323211368518e-9,
// [2.5,3.]: m=25 maxabs=3.1116602350333977e-15 maxrel=1.7515908876638942e-12
0.0013979579603578395,
-0.0006698177065173071,
0.0001607458113974862,
-0.000025758695627950465,
3.1003377523248807e-6,
-2.9893735063566935e-7,
2.4100752517527465e-8,
-1.6635308049865229e-9,
// [2.5,3.]: m=26 maxabs=3.0140820395097023e-15 maxrel=1.76980206796771e-12
0.0013396354130331201,
-0.0006429832440179316,
0.0001545521739110679,
-0.000024802764899014987,
2.989371594586479e-6,
-2.88605378363485e-7,
2.329554991776918e-8,
-1.6097398527459816e-9,
// [2.5,3.]: m=27 maxabs=2.92300905702092e-15 maxrel=1.78727703459536e-12
0.0012859664880344138,
-0.0006182086941214338,
0.00014881658953293784,
-0.000023915033668609154,
2.88605193351839e-6,
-2.7896185280087505e-7,
2.254227705323681e-8,
-1.5593092073081978e-9,
// [2.5,3.]: m=28 maxabs=2.8360560427875825e-15 maxrel=1.802968783602696e-12
0.0012364173882414625,
-0.0005952663566552266,
0.0001434902021464675,
-0.00002308847452869121,
2.7896167309285826e-6,
-2.699403464229694e-7,
2.1836079399403427e-8,
-1.5119360920439776e-9,
// [2.5,3.]: m=29 maxabs=2.7560419224581523e-15 maxrel=1.8190342942487237e-12
0.0011905327133090921,
-0.0005739608071528787,
0.00013853084730290627,
-0.000022316991166411964,
2.699401720230108e-6,
-2.6148269409421496e-7,
2.117268690225099e-8,
-1.4673503288611503e-9,
// [2.5,3.]: m=30 maxabs=2.6790635682116815e-15 maxrel=1.83330512485214e-12
0.0011479216143044306,
-0.0005541233878196802,
0.00013390194712568804,
-0.000021595269438838962,
2.6148252453587e-6,
-2.53537748056724e-7,
2.054832991302137e-8,
-1.4253134523747573e-9,
// [2.5,3.]: m=31 maxabs=2.605337820482667e-15 maxrel=1.8461535508624955e-12
0.0011082467756380716,
-0.0005356077871496096,
0.00012957161675674787,
-0.000020918656088493882,
2.535375830880848e-6,
-2.4606035365633653e-7,
1.9959668366122962e-8,
-1.3856130405962655e-9,
// [2.5,3.]: m=32 maxabs=2.5370330836160804e-15 maxrel=1.859403649684038e-12
0.0010712155742979605,
-0.0005182864657105024,
0.00012551193665168026,
-0.000020283059305997798,
2.460601927384309e-6,
-2.390104965431893e-7,
1.940373176416108e-8,
-1.348061474771833e-9,
// [2.5,3.]: m=33 maxabs=2.471547272397956e-15 maxrel=1.871478403739353e-12
0.0010365729314197828,
-0.0005020477453249461,
0.00012169835595333693,
-0.000019684866689001443,
2.390103400419757e-6,
-2.3235259519266458e-7,
1.8877869305719605e-8,
-1.3124877897480534e-9,
// [2.5,3.]: m=34 maxabs=2.4103982698697735e-15 maxrel=1.8837679657003046e-12
0.0010040954906487,
-0.0004867934225645564,
0.00011810920024835752,
-0.000019120877154609014,
2.3235244270730516e-6,
-2.260549023169691e-7,
1.8379709447230143e-8,
-1.2787406857933108e-9,
// [2.5,3.]: m=35 maxabs=2.3507671503830707e-15 maxrel=1.8943156191305916e-12
0.0009735868451279522,
-0.00047243679977592606,
0.00011472526303905391,
-0.00001858824411593154,
2.2605475379292982e-6,
-2.2008900443772796e-7,
1.7907122255205087e-8,
-1.2466817962912214e-9,
// [2.5,3.]: m=36 maxabs=2.2948223182828187e-15 maxrel=1.9050309243240114e-12
0.0009448735995507165,
-0.00045890105096851094,
0.00011152946480452174,
-0.000018084427811344572,
2.2008885923388954e-6,
-2.1442939390838483e-7,
1.7458191281141135e-8,
-1.2161897625577608e-9,
// [2.5,3.]: m=37 maxabs=2.241696411831029e-15 maxrel=1.9154405793254414e-12
0.0009178021019359165,
-0.00044611785805870823,
0.00010850656697421737,
-0.000017607155112755044,
2.144292523790792e-6,
-2.090531103524404e-7,
1.7031185657880264e-8,
-1.1871506668793123e-9,
// [2.5,3.]: m=38 maxabs=2.190088388420719e-15 maxrel=1.9246059692003224e-12
0.0008922357161163306,
-0.0004340262667645652,
0.00010564293078051075,
-0.000017154385482194842,
2.090529718349561e-6,
-2.0393942809840384e-7,
1.6624540257021974e-8,
-1.1594633474915286e-9,
// [2.5,3.]: m=39 maxabs=2.1415161310933684e-15 maxrel=1.934007818954025e-12
0.0008680525335280671,
-0.00042257172201551986,
0.00010292631299511093,
-0.000016724282006785377,
2.0393929221764737e-6,
-1.9906959149384535e-7,
1.6236834384716354e-8,
-1.1330378040856731e-9,
// [2.5,3.]: m=40 maxabs=2.0946785972419946e-15 maxrel=1.9426602971363422e-12
0.0008451434440300019,
-0.00041170525089856034,
0.00010034569214028388,
-0.000016315186651412583,
1.9906945875473965e-6,
-1.9442658833227648e-7,
1.586677650109984e-8,
-1.1077889969999483e-9
},
{
// [3.,3.5]: m=0 maxabs=9.992007221626409e-15 maxrel=1.9811906028979838e-14
0.48628724457869804,
-0.0344240797497667,
0.0032263513602634325,
-0.00028935848255486,
0.000023417539308012155,
-1.6889767311736403e-6,
1.088992737245835e-7,
-6.295293406342314e-9,
// [3.,3.5]: m=1 maxabs=8.701372955499664e-15 maxrel=1.1485533408390322e-13
0.0688481594995277,
-0.012905405435912579,
0.0017361508958615214,
-0.00018734052021095952,
0.000016889760331043165,
-1.3048155830356826e-6,
8.815617548102899e-8,
-5.268932720169385e-9,
// [3.,3.5]: m=2 maxabs=7.629313847345998e-15 maxrel=2.579051179464385e-13
0.02581081087182121,
-0.006944603579030781,
0.0011240431216327066,
-0.00013511825924372226,
0.000013048150983007522,
-1.0561789350753595e-6,
7.378051120624779e-8,
-4.520203852523916e-9,
// [3.,3.5]: m=3 maxabs=6.772360450213455e-15 maxrel=4.1411773829546387e-13
0.013889207158058182,
-0.004496172482670213,
0.0008107095557862899,
-0.00010438536226596778,
0.000010561785032466146,
-8.838839691740313e-7,
6.32966799670155e-8,
-3.952311825691985e-9,
// [3.,3.5]: m=4 maxabs=6.087144677202616e-15 maxrel=5.645926300553452e-13
0.008992344965337393,
-0.0032428382197192897,
0.0006263121738871312,
-0.00008449441729242979,
8.838835807642342e-6,
-7.582446550324355e-7,
5.534479694091496e-8,
-3.5079994353849673e-9,
// [3.,3.5]: m=5 maxabs=5.523359547510154e-15 maxrel=7.014345103621947e-13
0.006485676439435854,
-0.002505248692470483,
0.0005069665040159912,
-0.00007071080957412567,
7.582443066732189e-6,
-6.629557184789155e-7,
4.912313725173202e-8,
-3.1515245117491478e-9,
// [3.,3.5]: m=6 maxabs=5.052382123782451e-15 maxrel=8.230629351631045e-13
0.0050104973849384535,
-0.0020278660132713746,
0.00042426485768574885,
-0.00006065965623654538,
6.6295539779412936e-6,
-5.884053033963601e-7,
4.413159593587956e-8,
-2.8595791008133794e-9,
// [3.,3.5]: m=7 maxabs=4.659467256473704e-15 maxrel=9.31471362546799e-13
0.0040557320265404515,
-0.0016970594281876588,
0.00036395793764016574,
-0.00005303653403163133,
5.884050099552698e-6,
-5.285980042280257e-7,
4.004348498292613e-8,
-2.6163061403077205e-9,
// [3.,3.5]: m=8 maxabs=4.318594093444261e-15 maxrel=1.026325878723642e-12
0.0033941188563731497,
-0.0014558317482062638,
0.0003182192043944479,
-0.00004707249497238534,
5.285977299939403e-6,
-4.796177862264052e-7,
3.663708916379784e-8,
-2.4106327576022175e-9,
// [3.,3.5]: m=9 maxabs=4.023691102528204e-15 maxrel=1.1101948721563543e-12
0.002911663496410525,
-0.0012728768153954786,
0.0002824349700259474,
-0.00004228790568904356,
4.79617531004442e-6,
-4.388071051052985e-7,
3.375702152813384e-8,
-2.2345506968789637e-9,
// [3.,3.5]: m=10 maxabs=3.7665183472146424e-15 maxrel=1.1847605083993666e-12
0.002545753630789096,
-0.001129739878070582,
0.0002537274343108726,
-0.00003836948381802919,
4.3880686901504476e-6,
-4.0430340427609727e-7,
3.129128067794601e-8,
-2.0822783241314656e-9,
// [3.,3.5]: m=11 maxabs=3.5388358909926865e-15 maxrel=1.2508513682890028e-12
0.0022594797561390515,
-0.0010149097353496861,
0.00023021690305864752,
-0.00003510462546822099,
4.0430322303033525e-6,
-3.747651628991633e-7,
2.915746583844146e-8,
-1.949034993038976e-9,
// [3.,3.5]: m=12 maxabs=3.339776372124348e-15 maxrel=1.3111565237434578e-12
0.002029819470697721,
-0.00092086761044565,
0.00021062775296748154,
-0.000032344329396974073,
3.7476495213865933e-6,
-3.492026771217482e-7,
2.72932332819773e-8,
-1.8317557324575235e-9,
// [3.,3.5]: m=13 maxabs=3.367965628608971e-15 maxrel=1.4545408129302747e-12
0.0018417352208899495,
-0.0008425110101844443,
0.00019406597651002922,
-0.000029981263552509606,
3.4920249663724615e-6,
-3.2687183559696754e-7,
2.565053134765455e-8,
-1.7255847776984404e-9,
// [3.,3.5]: m=14 maxabs=2.998469528225911e-15 maxrel=1.4131511192033759e-12
0.0016850220203639432,
-0.0007762639045314404,
0.00017988758209527717,
-0.000027936262029431747,
3.268707300104978e-6,
-3.0719870062026226e-7,
2.4193564538664903e-8,
-1.6347060801221902e-9,
// [3.,3.5]: m=15 maxabs=2.851885394505871e-15 maxrel=1.4567697636948656e-12
0.0015525278090614682,
-0.0007195503268662833,
0.00016761757231198817,
-0.00002614971899341342,
3.0719852013133107e-6,
-2.8974108750916545e-7,
2.289166099782339e-8,
-1.5511632935377558e-9,
// [3.,3.5]: m=16 maxabs=2.7193958890281422e-15 maxrel=1.4967868774468157e-12
0.0014391006537312213,
-0.000670470287806792,
0.00015689831408952204,
-0.000024575939255604572,
2.897409155064839e-6,
-2.741465448344046e-7,
2.1721789061476725e-8,
-1.4756907708579555e-9,
// [3.,3.5]: m=17 maxabs=2.5992662883167483e-15 maxrel=1.5337815078635594e-12
0.0013409405756122932,
-0.0006275932549838334,
0.00014745563565752028,
-0.000023179328209076493,
2.741463798209202e-6,
-2.601337743943042e-7,
2.0664947458734452e-8,
-1.4071822878155665e-9,
// [3.,3.5]: m=18 maxabs=2.4880271454197356e-15 maxrel=1.5669859188613352e-12
0.0012551865099664342,
-0.0005898225413168565,
0.00013907596937264352,
-0.000021931762914183427,
2.6013361681293194e-6,
-2.474750982953892e-7,
1.9705595811483856e-8,
-1.34471941606317e-9,
// [3.,3.5]: m=19 maxabs=2.3867626625095895e-15 maxrel=1.5981447687007692e-12
0.0011796450826325321,
-0.0005563038762331671,
0.0001315905775983885,
-0.00002081073964050859,
2.474749472661125e-6,
-2.3598431858839633e-7,
1.8830904602289468e-8,
-1.2875392789680527e-9,
// [3.,3.5]: m=20 maxabs=2.293521275675836e-15 maxrel=1.62703247680119e-12
0.0011126077524651976,
-0.0005263623091874385,
0.00012486443795196674,
-0.000019798044025001952,
2.359841734872588e-6,
-2.255077232388974e-7,
1.8030191166552818e-8,
-1.2350024845730706e-9,
// [3.,3.5]: m=21 maxabs=2.2063514210080015e-15 maxrel=1.6531207235842436e-12
0.0010527246183737891,
-0.0004994577506490522,
0.00011878826425440002,
-0.000018878780230373637,
2.2550758401994664e-6,
-2.1591732761125067e-7,
1.7294491172341638e-8,
-1.1865660192044508e-9,
// [3.,3.5]: m=22 maxabs=2.126120460244074e-15 maxrel=1.6778004783521913e-12
0.00099891550129705,
-0.0004751530559025398,
0.00011327268148320012,
-0.00001804065132323603,
2.159171931173715e-6,
-2.0710572476343551e-7,
1.6616226434210973e-8,
-1.1417713773523322e-9,
// [3.,3.5]: m=23 maxabs=2.0517441912115686e-15 maxrel=1.7009876929925434e-12
0.0009503061118040633,
-0.0004530907248582828,
0.00010824390803671213,
-0.000017273418428477006,
2.0710559509483737e-6,
-1.98982127338002e-7,
1.5988948244015602e-8,
-1.1002234789212778e-9,
// [3.,3.5]: m=24 maxabs=1.981921571303502e-15 maxrel=1.7222403608737786e-12
0.0009061814497155866,
-0.00043297563111009734,
0.00010364051066480671,
-0.000016568489076609887,
1.9898200210630392e-6,
-1.914692817739264e-7,
1.540713580033671e-8,
-1.061582696761982e-9,
// [3.,3.5]: m=25 maxabs=1.9177368026923602e-15 maxrel=1.7430793523444376e-12
0.0008659512622192488,
-0.00041456204165769855,
0.00009941093455056106,
-0.000015918600229549178,
1.914691605865951e-6,
-1.845010453184766e-7,
1.4866035208913816e-8,
-1.0255547582114311e-9,
// [3.,3.5]: m=26 maxabs=1.8557204384261894e-15 maxrel=1.7608800430834133e-12
0.0008291240833144773,
-0.00039764373723357,
0.00009551160146550276,
-0.000015317571593141504,
1.8450092771349641e-6,
-1.7802046270245486e-7,
1.436153046153292e-8,
-9.918861387778896e-10,
// [3.,3.5]: m=27 maxabs=1.799125085022446e-15 maxrel=1.7791120143068699e-12
0.0007952874744662527,
-0.0003820464049241344,
0.00009190542964401361,
-0.000014760111731383244,
1.7802034912578573e-6,
-1.7197823198262206e-7,
1.3890040901225925e-8,
-9.603497116979719e-10,
// [3.,3.5]: m=28 maxabs=1.7454570774844136e-15 maxrel=1.795854231907519e-12
0.000764092809847405,
-0.000367621717667124,
0.00008856067047125276,
-0.000014241664287383382,
1.719781213316827e-6,
-1.6633145947468055e-7,
1.3448437821394005e-8,
-9.30752897570898e-10,
// [3.,3.5]: m=29 maxabs=1.694716415812092e-15 maxrel=1.8114532405511647e-12
0.0007352434353334082,
-0.00035424268100325027,
0.00008544998580477898,
-0.000013758284976943345,
1.663313521915554e-6,
-1.610426583116007e-7,
1.3033973688005743e-8,
-9.029210107580575e-10,
// [3.,3.5]: m=30 maxabs=1.6469031000054812e-15 maxrel=1.826256435436365e-12
0.000708485362005685,
-0.0003417999423629651,
0.00008254970993984684,
-0.00001330654242131597,
1.6104255411282421e-6,
-1.5607892214711013e-7,
1.264422779393827e-8,
-8.767012456171572e-10,
// [3.,3.5]: m=31 maxabs=1.6016918694128357e-15 maxrel=1.840238219893457e-12
0.0006835998847251372,
-0.00033019883892738364,
0.00007983925460388254,
-0.000012883437608889963,
1.5607882087350977e-6,
-1.51411248514593e-7,
1.227705771550365e-8,
-8.519578930212444e-10,
// [3.,3.5]: m=32 maxabs=1.5587574633824097e-15 maxrel=1.8533215021521544e-12
0.0006603976778539977,
-0.0003193570176063653,
0.0000773006257271929,
-0.000012486338036149767,
1.5141115004630492e-6,
-1.4701397805806514e-7,
1.1930561531807472e-8,
-8.285694171203327e-10,
// [3.,3.5]: m=33 maxabs=1.5185335627831975e-15 maxrel=1.8663103318727837e-12
0.000638714035211979,
-0.0003092025021212331,
0.00007491802828894148,
-0.000012112923505083756,
1.4701388202885408e-6,
-1.4286432659257651e-7,
1.1603044451110743e-8,
-8.064281010094779e-10,
// [3.,3.5]: m=34 maxabs=1.4802612260944592e-15 maxrel=1.8785651163070937e-12
0.0006184050042417328,
-0.00029967211238872887,
0.00007267754110080611,
-0.0000117611412434906,
1.4286423287745741e-6,
-1.3894199450862934e-7,
1.1292992103061099e-8,
-7.854374778223278e-10,
// [3.,3.5]: m=35 maxabs=1.443181511795455e-15 maxrel=1.889325004848319e-12
0.0005993442247767459,
-0.000290710163655643,
0.00007056684752934029,
-0.000011429168533132396,
1.3894190325542505e-6,
-1.3522883850025953e-7,
1.0999046200518766e-8,
-7.655094960757292e-10,
// [3.,3.5]: m=36 maxabs=1.4082702018414217e-15 maxrel=1.900048292067483e-12
0.0005814203273105878,
-0.0002822673893882867,
0.00006857501126570083,
-0.0000111153814233026,
1.3522874933263084e-6,
-1.317085915597703e-7,
1.0719985870693315e-8,
-7.465662027463669e-10,
// [3.,3.5]: m=37 maxabs=1.3752020355806138e-15 maxrel=1.910542389643925e-12
0.0005645347787758941,
-0.00027430004435133294,
0.0000666922886050124,
-0.00001081832840523779,
1.3170850460713134e-6,
-1.2836662873111135e-7,
1.0454710204296383e-8,
-7.285357570366181e-10,
// [3.,3.5]: m=38 maxabs=1.3434349119267885e-15 maxrel=1.920252839969848e-12
0.0005486000887019997,
-0.00026676915372535827,
0.0000649099704952711,
-0.000010536708156084513,
1.2836654362224409e-6,
-1.2518976352404296e-7,
1.0202224082264716e-8,
-7.113548221150393e-10,
// [3.,3.5]: m=39 maxabs=1.3135109319661886e-15 maxrel=1.930131622665596e-12
0.0005335383074500666,
-0.00025963988130241005,
0.00006322024899883386,
-0.000010269350636820934,
1.2518968044206504e-6,
-1.2216607743065243e-7,
9.961625907017294e-9,
-6.949638702183719e-10,
// [3.,3.5]: m=40 maxabs=1.2843458935263286e-15 maxrel=1.9387628299813185e-12
0.0005192797626041833,
-0.0002528809953319462,
0.00006161610388197026,
-0.000010015200970908257,
1.2216599608019495e-6,
-1.1928476961110813e-7,
9.732096728894405e-9,
-6.793105488048214e-10
},
{
// [3.5,4.]: m=0 maxabs=6.8833827526759706e-15 maxrel=1.465026324944697e-14
0.4548219890540052,
-0.02875361621319911,
0.0024833991912293395,
-0.00021060617162847324,
0.000016404819232111816,
-1.151990835873639e-6,
7.28573787482038e-8,
-4.152248574545361e-9,
// [3.5,4.]: m=1 maxabs=2.968458812091512e-14 maxrel=4.726311416498358e-13
0.05750723242658047,
-0.009933596759485365,
0.0012636370260804834,
-0.00013123873517164054,
0.000011519930072019537,
-8.726876584631566e-7,
5.8093098809610205e-8,
-4.069862150195418e-9,
// [3.5,4.]: m=2 maxabs=4.898859096158503e-15 maxrel=2.1673093988441202e-13
0.019867193523087426,
-0.005054548117295767,
0.000787432130388883,
-0.00009215935418796254,
8.729985220940091e-6,
-6.966103718310833e-7,
4.813211479701927e-8,
-2.923703257792193e-9,
// [3.5,4.]: m=3 maxabs=4.328135072562134e-15 maxrel=3.658181684278131e-13
0.010109096234589337,
-0.0031497285190754815,
0.0005529561253363841,
-0.0000698399809547372,
6.966100947966684e-6,
-5.76633247378761e-7,
4.094069327723694e-8,
-2.5389157960884123e-9,
// [3.5,4.]: m=4 maxabs=3.869300713166268e-15 maxrel=5.147077215523736e-13
0.00629945703814902,
-0.0022118244991568997,
0.00041903988591341767,
-0.000055728895124126045,
5.766330012199441e-6,
-4.904479589834488e-7,
3.555269156593718e-8,
-2.24091272657723e-9,
// [3.5,4.]: m=5 maxabs=3.49893725104522e-15 maxrel=6.53834790847292e-13
0.004423648998312065,
-0.0016761595416966528,
0.00033437337091072407,
-0.00004613071837563257,
4.904477378526458e-6,
-4.258808412577442e-7,
3.137985382627474e-8,
-2.0038710472898225e-9,
// [3.5,4.]: m=6 maxabs=3.191891195797325e-15 maxrel=7.793759606093988e-13
0.003352319083391719,
-0.0013374934818742557,
0.00027678431040679963,
-0.00003923588977349803,
4.258806380129525e-6,
-3.7587908786209396e-7,
2.806066334566495e-8,
-1.8111527483954027e-9,
// [3.5,4.]: m=7 maxabs=2.9312489935318098e-15 maxrel=8.904390975547092e-13
0.002674986963747006,
-0.0011071372400152742,
0.00023541533877920252,
-0.0000340705155414494,
3.7587890441781306e-6,
-3.361086676692333e-7,
2.536200674569759e-8,
-1.6515659017375004e-9,
// [3.5,4.]: m=8 maxabs=2.706168622523819e-15 maxrel=9.875844221248915e-13
0.0022142744800292156,
-0.0009416613536345563,
0.00020442309337865417,
-0.000030070371631958702,
3.3610849485491013e-6,
-3.0377503382161213e-7,
2.3127445861775806e-8,
-1.5174236305534204e-9,
// [3.5,4.]: m=9 maxabs=2.5196858488563123e-15 maxrel=1.0764049979436423e-12
0.0018833227072685792,
-0.0008176923721421619,
0.00018042222988478475,
-0.00002688873443150602,
3.0377489896841823e-6,
-2.770030848524502e-7,
2.1248391158009194e-8,
-1.4030406791200398e-9,
// [3.5,4.]: m=10 maxabs=2.3548871186385156e-15 maxrel=1.1544801087284543e-12
0.0016353847442831578,
-0.0007216889182651714,
0.0001613324067009839,
-0.000024302042875413244,
2.7700293555967678e-6,
-2.54491501337083e-7,
1.9647347585094853e-8,
-1.3045062859904207e-9,
// [3.5,4.]: m=11 maxabs=2.209820867959955e-15 maxrel=1.2239842384794194e-12
0.0014433778365292498,
-0.0006453296256137412,
0.00014581225735743803,
-0.00002216028245211388,
2.5449136141638895e-6,
-2.3531114200133222e-7,
1.8267565032019125e-8,
-1.218743255569209e-9,
// [3.5,4.]: m=12 maxabs=2.08080080943418e-15 maxrel=1.285855185765588e-12
0.00129065925122645,
-0.0005832490283130964,
0.00013296169481152458,
-0.000020359353579373387,
2.3531101033380376e-6,
-2.187819881529698e-7,
1.7066616990053514e-8,
-1.1434418752087774e-9,
// [3.5,4.]: m=13 maxabs=1.9658753791507166e-15 maxrel=1.3414760113746977e-12
0.0011664980566252134,
-0.000531846778194481,
0.0001221561215699189,
-0.000018824922890415895,
2.1878186332986073e-6,
-2.0439559592554106e-7,
1.6012180060914546e-8,
-1.0768164891773289e-9,
// [3.5,4.]: m=14 maxabs=1.6412652487085566e-15 maxrel=1.2261378868523287e-12
0.0010636935563870923,
-0.0004886244852755518,
0.00011294953745135089,
-0.000017502589049751287,
2.0439546485871595e-6,
-1.9176302669275763e-7,
1.5079467264888146e-8,
-1.0206830485861758e-9,
// [3.5,4.]: m=15 maxabs=1.7707189881033258e-15 maxrel=1.4377718419955512e-12
0.0009772489705712096,
-0.00045179814878307587,
0.00010501553295196631,
-0.000016351675877493485,
1.9176449947810635e-6,
-1.8058900563019563e-7,
1.4248046184442186e-8,
-9.64255158166047e-10,
// [3.5,4.]: m=16 maxabs=1.6868017399529478e-15 maxrel=1.4794028558348672e-12
0.0009035962975653132,
-0.0004200621309129999,
0.00009811005534515395,
-0.000015341195752026257,
1.8058889877365287e-6,
-1.7063293906926676e-7,
1.3502991561684279e-8,
-9.162975723929275e-10,
// [3.5,4.]: m=17 maxabs=1.6106907474444654e-15 maxrel=1.5176955246605429e-12
0.000840124261825203,
-0.00039244022052818635,
0.00009204717458843196,
-0.000014447145998364002,
1.7063283741060725e-6,
-1.6170857680782184e-7,
1.283141878056476e-8,
-8.728508091803078e-10,
// [3.5,4.]: m=18 maxabs=1.5413018084053931e-15 maxrel=1.5530147878853422e-12
0.0007848804410556082,
-0.00036818869753993985,
0.00008668287606344541,
-0.000013650659544378491,
1.6170847916280183e-6,
-1.5366453183786311e-7,
1.2223035650265577e-8,
-8.333133900869289e-10,
// [3.5,4.]: m=19 maxabs=1.476683358925257e-15 maxrel=1.5845312661775418e-12
0.0007363773950791493,
-0.0003467315034752815,
0.00008190395733633056,
-0.000012936709472930967,
1.5366443844704077e-6,
-1.463774847132267e-7,
1.1669376073831318e-8,
-7.971816322825995e-10,
// [3.5,4.]: m=20 maxabs=1.4180280213937912e-15 maxrel=1.614498495568866e-12
0.0006934630069498627,
-0.0003276158285991689,
0.00007762025690480679,
-0.000012293184921464423,
1.463773950509174e-6,
-1.3974599715779004e-7,
1.1163413294874001e-8,
-7.640365382670022e-10,
// [3.5,4.]: m=21 maxabs=1.3633842319005218e-15 maxrel=1.641707071692935e-12
0.0006552316571976628,
-0.0003104810269028905,
0.00007375910959346525,
-0.00001171022025725212,
1.397459109543693e-6,
-1.3368588907471158e-7,
1.0699269832601643e-8,
-7.335233332010733e-10,
// [3.5,4.]: m=22 maxabs=1.3130772510971944e-15 maxrel=1.6673344954871357e-12
0.0006209620538051299,
-0.00029503643768502173,
0.00007026132160595474,
-0.000011179700429232839,
1.336858058374366e-6,
-1.2812673313516873e-7,
1.0271990266471906e-8,
-7.053428723578419e-10,
// [3.5,4.]: m=23 maxabs=1.2662397172458206e-15 maxrel=1.6910568507684044e-12
0.000590072875369414,
-0.0002810452857605004,
0.00006707820263565924,
-0.000010694890999721665,
1.281266528191944e-6,
-1.230091689312998e-7,
9.877370160309962e-9,
-6.792387965901793e-10,
// [3.5,4.]: m=24 maxabs=1.2225463696946548e-15 maxrel=1.71308641435087e-12
0.0005620905715203938,
-0.00026831280990298955,
0.00006416934605641942,
-0.000010250157811289114,
1.2300909156098642e-6,
-1.1828281991972267e-7,
9.511817828566579e-9,
-6.549897370284676e-10,
// [3.5,4.]: m=25 maxabs=1.1815635275747027e-15 maxrel=1.7333943341704737e-12
0.0005366256198053947,
-0.00025667738360807843,
0.00006150094692379472,
-9.840752028405502e-6,
1.1828274518018542e-6,
-1.1390466135208284e-7,
9.172248036740872e-9,
-6.324058603443388e-10,
// [3.5,4.]: m=26 maxabs=1.1435080313204615e-15 maxrel=1.752837487818161e-12
0.0005133547672155904,
-0.0002460037870981862,
0.0000590445122247252,
-9.46264349408717e-6,
1.1390458901646622e-6,
-1.0983773126534121e-7,
8.855995987305716e-9,
-6.113219592781541e-10,
// [3.5,4.]: m=27 maxabs=1.1078377798456884e-15 maxrel=1.7711186974414854e-12
0.0004920075741958242,
-0.00023617804832114933,
0.000056775861017054723,
-9.112390230869613e-6,
1.098376612608411e-6,
-1.0605010263129944e-7,
8.56074736129847e-9,
-5.915938207367807e-10,
// [3.5,4.]: m=28 maxabs=1.0741190922813892e-15 maxrel=1.7879801939704335e-12
0.00047235609664176827,
-0.00022710344350854186,
0.00005467434143609502,
-8.787035287641304e-6,
1.0605003480607908e-6,
-1.0251405697704256e-7,
8.284483994807854e-9,
-5.730945053083892e-10,
// [3.5,4.]: m=29 maxabs=1.0426772292793096e-15 maxrel=1.804364628011985e-12
0.00045420688701656737,
-0.00021869736520167948,
0.000052722211775385607,
-8.484024492317466e-6,
1.0251399092099043e-6,
-9.920541412734952e-8,
8.025437151451449e-9,
-5.557141700964901e-10,
// [3.5,4.]: m=30 maxabs=1.0127532493187097e-15 maxrel=1.819353823595271e-12
0.00043739473040285736,
-0.00021088884657482636,
0.00005090414700201115,
-8.201140342227761e-6,
9.920534999340967e-7,
-9.610298811141423e-8,
7.782050893313042e-9,
-5.393539564942435e-10,
// [3.5,4.]: m=31 maxabs=9.84455572616838e-16 maxrel=1.8334457174778634e-12
0.0004217776931491645,
-0.00020361658749638577,
0.00004920684210016244,
-7.936448465503394e-6,
9.610292574498166e-7,
-9.318813769833624e-8,
7.552950656130091e-9,
-5.239272303461924e-10,
// [3.5,4.]: m=32 maxabs=9.580010396081917e-16 maxrel=1.8473766515310494e-12
0.0004072331749922973,
-0.00019682736790320517,
0.000047618690838452454,
-7.68825395686067e-6,
9.318807716986211e-7,
-9.044439733273951e-8,
7.3369173387717866e-9,
-5.09355772880079e-10,
// [3.5,4.]: m=33 maxabs=9.32630708772031e-16 maxrel=1.859994768142964e-12
0.0003936547358059486,
-0.00019047476286984175,
0.000046129523785407074,
-7.4550655319880305e-6,
9.044433837467556e-7,
-8.785716863346815e-8,
7.132867106319363e-9,
-4.955708437026163e-10,
// [3.5,4.]: m=34 maxabs=9.087782609773498e-16 maxrel=1.8724056141438962e-12
0.0003809495257392329,
-0.00018451809467042924,
0.00004473039323510252,
-7.2355659180053745e-6,
8.785711110560411e-7,
-8.541346386004149e-8,
6.939832233996453e-9,
-4.825110105164536e-10,
// [3.5,4.]: m=35 maxabs=8.86172645681027e-16 maxrel=1.884331138266595e-12
0.0003690361893404199,
-0.00017892157248129787,
0.00004341339555003926,
-7.028587252740802e-6,
8.54134078684001e-7,
-8.310169091899083e-8,
6.756945915187838e-9,
-4.70119890254159e-10,
// [3.5,4.]: m=36 maxabs=8.647054426658141e-16 maxrel=1.8957786301033932e-12
0.0003578431449621672,
-0.0001736535817525421,
0.00004217152355750294,
-6.8330905338343776e-6,
8.310163618647347e-7,
-8.091147008567177e-8,
6.583430147716794e-9,
-4.5834800932082185e-10,
// [3.5,4.]: m=37 maxabs=8.438345508454681e-16 maxrel=1.905747605064327e-12
0.00034730716350466574,
-0.00016868609379334067,
0.00004099854324312388,
-6.648148361710425e-6,
8.091141659483867e-7,
-7.883348058961389e-8,
6.418584350932021e-9,
-4.471503232705836e-10,
// [3.5,4.]: m=38 maxabs=8.241562814148562e-16 maxrel=1.9157408393840373e-12
0.00033737218758627215,
-0.00016399417254622464,
0.00003988889020946151,
-6.472930378101915e-6,
7.883342836067303e-7,
-7.685932896083333e-8,
6.261775521923884e-9,
-4.364859067662039e-10,
// [3.5,4.]: m=39 maxabs=8.055080040481055e-16 maxrel=1.9256045852259295e-12
0.0003279883450920509,
-0.0001595555604215121,
0.00003883758230678621,
-6.3066909219835074e-6,
7.685927807171007e-7,
-7.49814371273821e-8,
6.112431215323161e-9,
-4.263170234577599e-10,
// [3.5,4.]: m=40 maxabs=7.875644580934704e-16 maxrel=1.934742795934905e-12
0.00031911112084263485,
-0.00015535032882028587,
0.000037840145569228916,
-6.148758519773181e-6,
7.498138735288188e-7,
-7.319294511524798e-8,
5.970031559759873e-9,
-4.1661041043587123e-10
},
{
// [4.,4.5]: m=0 maxabs=4.385380947269368e-15 maxrel=9.943256922082634e-15
0.4283564875120432,
-0.024358367859001362,
0.0019394996070971695,
-0.0001551856626974428,
0.000011604813952672952,
-7.917283449142736e-7,
4.903488946869265e-8,
-2.75183810129835e-9,
// [4.,4.5]: m=1 maxabs=3.649858193455202e-15 maxrel=6.907294729561706e-14
0.048716735718002044,
-0.007757998426176684,
0.0009311139762392296,
-0.00009283859988263128,
7.91728278158139e-6,
-5.875731533222716e-7,
3.852801106378539e-8,
-2.250931816064736e-9,
// [4.,4.5]: m=2 maxabs=3.157196726277789e-15 maxrel=1.801458386904166e-13
0.01551599685235192,
-0.0037244559031037673,
0.0005570315994354635,
-0.00006333833636387483,
5.8757296626601975e-6,
-4.616247329431553e-7,
3.151905064235694e-8,
-1.896934381242633e-9,
// [4.,4.5]: m=3 maxabs=2.770353391134961e-15 maxrel=3.1974867892928105e-13
0.007448911806206186,
-0.002228126396144205,
0.00038003001831487366,
-0.00004700590119018984,
4.616245576772981e-6,
-3.7761536385264854e-7,
2.6562686514105122e-8,
-1.6351610423128097e-9,
// [4.,4.5]: m=4 maxabs=2.465042059363043e-15 maxrel=4.658331715270869e-13
0.004456252792287359,
-0.0015201200718587941,
0.0002820354072513432,
-0.00003693002064881843,
3.7761521455599954e-6,
-3.1821428315949526e-7,
2.2897065888411523e-8,
-1.4345779920297678e-9,
// [4.,4.5]: m=5 maxabs=2.2191450066433305e-15 maxrel=6.057131065668285e-13
0.0030402401437164875,
-0.0011281416277586886,
0.00022158012399715063,
-0.0000302092670290414,
3.1821414411632638e-6,
-2.742861053279155e-7,
2.0088541057222447e-8,
-1.2764715441509996e-9,
// [4.,4.5]: m=6 maxabs=2.01574867908505e-15 maxrel=7.335012912799933e-13
0.002256283255516381,
-0.0008863204948665741,
0.0001812556022696737,
-0.000025457176409228463,
2.742859780684976e-6,
-2.406316485413826e-7,
1.7874673777752387e-8,
-1.148910988458164e-9,
// [4.,4.5]: m=7 maxabs=1.846613140177311e-15 maxrel=8.48534488128386e-13
0.0017726409897322857,
-0.0007250224080591002,
0.00015274305854255784,
-0.00002194291902732923,
2.406315323504082e-6,
-2.141045866253696e-7,
1.6088470691715738e-8,
-1.0439801954336357e-9,
// [4.,4.5]: m=8 maxabs=1.7034984534092246e-15 maxrel=9.511481539365725e-13
0.001450044816117355,
-0.0006109722332362745,
0.00013165751424505735,
-0.000019250559946109723,
2.1410447895939984e-6,
-1.9270302734350862e-7,
1.461916511500559e-8,
-9.562958001536744e-10,
// [4.,4.5]: m=9 maxabs=1.5812004483528597e-15 maxrel=1.042731357281808e-12
0.0012219444664719411,
-0.0005266300561171289,
0.00011550335972809216,
-0.00001712839277485478,
1.9270295242998885e-6,
-1.7509927954189026e-7,
1.3390669227555842e-8,
-8.818680251522556e-10,
// [4.,4.5]: m=10 maxabs=1.4732139119733034e-15 maxrel=1.122875513942351e-12
0.0010532601122335305,
-0.00046201343811349193,
0.0001027703567190205,
-0.000015416268149473508,
1.7509918629086296e-6,
-1.6038126208729035e-7,
1.2349137642884105e-8,
-8.180489479601424e-10,
// [4.,4.5]: m=11 maxabs=1.4109807072726355e-15 maxrel=1.222106545423407e-12
0.0009240268762263137,
-0.000411081426130966,
0.00009249760895927873,
-0.000014007964694727655,
1.6038117781414818e-6,
-1.4790367458202102e-7,
1.1455404458919477e-8,
-7.62600785310312e-10,
// [4.,4.5]: m=12 maxabs=1.2977900004651488e-15 maxrel=1.260148444314228e-12
0.0008221628522618921,
-0.00036999043515147285,
0.00008404778824031745,
-0.000012830521890459133,
1.479035521614485e-6,
-1.3719786095851689e-7,
1.0680665413466248e-8,
-7.143042810517347e-10,
// [4.,4.5]: m=13 maxabs=1.2246063538223773e-15 maxrel=1.3183528769959165e-12
0.0007399808703023434,
-0.00033619115230540343,
0.00007698313140067889,
-0.00001183231040745431,
1.3719778366986593e-6,
-1.2791613392970942e-7,
1.0002734101676214e-8,
-6.71601703462829e-10,
// [4.,4.5]: m=14 maxabs=1.1587952819525071e-15 maxrel=1.3704587155909517e-12
0.0006723823046102362,
-0.000307932524983887,
0.00007099386249957586,
-0.000010975847446476307,
1.279160607753923e-6,
-1.1979518332499434e-7,
9.404765229542954e-9,
-6.336652445857792e-10,
// [4.,4.5]: m=15 maxabs=1.0998146837692957e-15 maxrel=1.4178821736866343e-12
0.0006158650499672329,
-0.0002839754494125922,
0.00006585508473080699,
-0.000010233308290082077,
1.1979511405476407e-6,
-1.1263227635123177e-7,
8.873530080426954e-9,
-5.997450494860852e-10,
// [4.,4.5]: m=16 maxabs=1.046905617752003e-15 maxrel=1.4615813265510154e-12
0.0005679508988246696,
-0.0002634203383673287,
0.00006139984978999045,
-9.583631360462688e-6,
1.126322103416857e-6,
-1.0626889500954957e-7,
8.398543020425317e-9,
-5.692407913012412e-10,
// [4.,4.5]: m=17 maxabs=9.985502008591496e-16 maxrel=1.5011010691247408e-12
0.0005268406767341655,
-0.00024559939863099366,
0.000057501788210066894,
-9.010597986098576e-6,
1.062688319314081e-6,
-1.0057939188750566e-7,
7.971389840063779e-9,
-5.416650864695674e-10,
// [4.,4.5]: m=18 maxabs=9.542063320044925e-16 maxrel=1.5369429842568036e-12
0.0004911987972615172,
-0.00023000715233575345,
0.000054063587961778644,
-8.501526734921634e-6,
1.005793315627724e-6,
-9.546294644793221e-8,
7.585243736888303e-9,
-5.166189572444611e-10,
// [4.,4.5]: m=19 maxabs=9.140908516225288e-16 maxrel=1.5707048902697423e-12
0.00046001430467105696,
-0.000216254351364906,
0.00005100916045275259,
-8.046365813134061e-6,
9.546288881985866e-7,
-9.083776015296938e-8,
7.234509455484503e-9,
-4.93770571778948e-10,
// [4.,4.5]: m=20 maxabs=8.767942968890274e-16 maxrel=1.6011267550660921e-12
0.0004325087027293802,
-0.00020403664134924836,
0.00004827819492031416,
-7.637049575957556e-6,
9.083770478639166e-7,
-8.663679728914468e-8,
6.914560173878205e-9,
-4.728455885807483e-10,
// [4.,4.5]: m=21 maxabs=8.425335082384855e-16 maxrel=1.6294995545975854e-12
0.0004080732826980829,
-0.000193112779238271,
0.000045822297495531115,
-7.267034102170566e-6,
8.663674422863109e-7,
-8.280461763859438e-8,
6.6215364866057315e-9,
-4.5361165449059507e-10,
// [4.,4.5]: m=22 maxabs=8.106579643674117e-16 maxrel=1.6554465771756272e-12
0.0003862255584761435,
-0.00018328918955646427,
0.00004360220465128086,
-6.930956564626999e-6,
8.2804566633898e-7,
-7.929498538910675e-8,
6.352195149273769e-9,
-4.3587233674803294e-10,
// [4.,4.5]: m=23 maxabs=7.813302956016788e-16 maxrel=1.6800659306250586e-12
0.0003665783791125434,
-0.00017440881819548898,
0.00004158573942477817,
-6.624381715963631e-6,
7.929493604423397e-7,
-7.606904357452547e-8,
6.103791329631823e-9,
-4.1946194088702736e-10,
// [4.,4.5]: m=24 maxabs=7.539541907464198e-16 maxrel=1.7028178077757697e-12
0.00034881763639060733,
-0.00016634295730434353,
0.00003974629033139841,
-6.343610674181054e-6,
7.606899609252511e-7,
-7.309390670710199e-8,
5.873986448053321e-9,
-4.042362981059362e-10,
// [4.,4.5]: m=25 maxabs=7.28583859910259e-16 maxrel=1.7244483247641873e-12
0.00033268591460832884,
-0.0001589851609446563,
0.000038061664079506344,
-6.085534924754699e-6,
7.309386081904163e-7,
-7.034155968273647e-8,
5.660776369956603e-9,
-3.9007227806111455e-10,
// [4.,4.5]: m=26 maxabs=7.046229918983293e-16 maxrel=1.7441203624857568e-12
0.00031797032188896556,
-0.00015224665594999038,
0.000036513209581868395,
-5.847523586850571e-6,
7.034151524397674e-7,
-6.778799230587558e-8,
5.462433760430016e-9,
-3.768633597178621e-10,
// [4.,4.5]: m=27 maxabs=6.821800069278794e-16 maxrel=1.7625617317333747e-12
0.0003044933118996452,
-0.00014605283797149442,
0.000035085141553329686,
-5.627335458512258e-6,
6.778794933807779e-7,
-6.541251139006856e-8,
5.277462010008894e-9,
-3.645160880311821e-10,
// [4.,4.5]: m=28 maxabs=6.610922746730363e-16 maxrel=1.7798196737622739e-12
0.00029210567594266374,
-0.00014034056586864684,
0.00003376401278230022,
-5.423049733996892e-6,
6.541246973952738e-7,
-6.319718865069676e-8,
5.104558350936832e-9,
-3.5294932099044226e-10,
// [4.,4.5]: m=29 maxabs=6.414682153510487e-16 maxrel=1.7966317207467617e-12
0.00028068113173697774,
-0.00013505605079512225,
0.00003253829843429001,
-5.233010942188795e-6,
6.319714825000606e-7,
-6.112641562809006e-8,
4.942583074579776e-9,
-3.4209152783845303e-10,
// [4.,4.5]: m=30 maxabs=6.22819937984298e-16 maxrel=1.8120489955138255e-12
0.0002701121015899386,
-0.00013015319341305056,
0.00003139806568252048,
-5.055784824193291e-6,
6.112637644465409e-7,
-5.918654155753224e-8,
4.790535248616341e-9,
-3.3187946032675223e-10,
// [4.,4.5]: m=31 maxabs=6.054184931159057e-16 maxrel=1.8272023216007468e-12
0.0002603063868258034,
-0.0001255922624153785,
0.00003033470897375838,
-4.890122703751314e-6,
5.918650343155561e-7,
-5.736557640588984e-8,
4.647532309733555e-9,
-3.2225744405175636e-10,
// [4.,4.5]: m=32 maxabs=5.888301998768775e-16 maxrel=1.8411377310996313e-12
0.0002511845248304665,
-0.00012133883558919627,
0.000029340736250388815,
-4.7349325079974555e-6,
5.736553924830513e-7,
-5.5652946551445836e-8,
4.512792900674288e-9,
-3.131762268760074e-10,
// [4.,4.5]: m=33 maxabs=5.730550582672134e-16 maxrel=1.8541166357666142e-12
0.0002426776711781107,
-0.00011736294470409496,
0.000028409595075064568,
-4.589255038100316e-6,
5.565291043955553e-7,
-5.4039292571099635e-8,
4.385622829834747e-9,
-3.0459138443451405e-10,
// [4.,4.5]: m=34 maxabs=5.58201488504162e-16 maxrel=1.8667636424721303e-12
0.00023472588940791572,
-0.00011363838001073918,
0.00002753553025494521,
-4.452244415827939e-6,
5.403925744580228e-7,
-5.25163000247276e-8,
4.265403422602481e-9,
-2.9646314296878943e-10,
// [4.,4.5]: m=35 maxabs=5.441610703704747e-16 maxrel=1.8790022983126433e-12
0.00022727676002121035,
-0.00011014212073779283,
0.000026713466520703104,
-4.323151875166305e-6,
5.251626572034534e-7,
-5.107655760061173e-8,
4.1515815446981324e-9,
-2.887566007843039e-10,
// [4.,4.5]: m=36 maxabs=5.306085432144059e-16 maxrel=1.8899370771681133e-12
0.0002202842414753253,
-0.00010685386580796807,
0.00002593891127602719,
-4.201312251360015e-6,
5.107652421596996e-7,
-4.971343877688169e-8,
4.043660976407663e-9,
-2.8143951367595916e-10,
// [4.,4.5]: m=37 maxabs=5.178691676877012e-16 maxrel=1.9009190874051164e-12
0.00021370773161568117,
-0.00010375564483605563,
0.0000252078735326105,
-4.086132659357989e-6,
4.971340619599206e-7,
-4.8421000175312256e-8,
3.941195403453978e-9,
-2.744832250493888e-10,
// [4.,4.5]: m=38 maxabs=5.055634730299907e-16 maxrel=1.9107778075645243e-12
0.00020751128967186317,
-0.00010083149386885107,
0.0000245167959799803,
-3.977082959124442e-6,
4.842096839298436e-7,
-4.71938964081646e-8,
3.843782349062721e-9,
-2.6786160292518614e-10,
// [4.,4.5]: m=39 maxabs=4.938540895671473e-16 maxrel=1.9202856474909403e-12
0.0002016629877374597,
-0.00009806718366449797,
0.000023862497778073256,
-3.87368768829995e-6,
4.71938652983061e-7,
-4.602730651278873e-8,
3.75105798078502e-9,
-2.615511728133757e-10,
// [4.,4.5]: m=40 maxabs=4.827952274077951e-16 maxrel=1.9298526759818988e-12
0.00019613436732875803,
-0.00009544999086274637,
0.000023242126152660118,
-3.7755192056287066e-6,
4.6027276020450487e-7,
-4.491687134283342e-8,
3.6626923602351187e-9,
-2.555309848389416e-10
},
{
// [4.5,5.]: m=0 maxabs=8.382183835919932e-15 maxrel=2.011836067642901e-14
0.4057932930418428,
-0.020902189357755428,
0.0015363347846143681,
-0.00011579321558600053,
8.293317692000655e-6,
-5.484701983176997e-7,
3.361231183880962e-8,
-1.8487849247325814e-9,
// [4.5,5.]: m=1 maxabs=2.366162821232365e-15 maxrel=5.2512094967389497e-14
0.041804378720050626,
-0.006145338997738305,
0.0006947591420685595,
-0.00006634828234401183,
5.485400426143796e-6,
-3.9798922962880384e-7,
2.565979668455639e-8,
-1.4800189353115515e-9,
// [4.5,5.]: m=2 maxabs=2.0435042547006788e-15 maxrel=1.4823617351805428e-13
0.012290677995475724,
-0.0027790365670663847,
0.0003980896941498511,
-0.00004388325168272271,
3.979891139571471e-6,
-3.0745435856665874e-7,
2.072397813859498e-8,
-1.2348184091384703e-9,
// [4.5,5.]: m=3 maxabs=1.777224201138239e-15 maxrel=2.7664274093860287e-13
0.005558073134131724,
-0.001592358775568741,
0.0002632995101868064,
-0.0000318391703574056,
3.0745424064056524e-6,
-2.482917779387013e-7,
1.7291196815568266e-8,
-1.0559722050748564e-9,
// [4.5,5.]: m=4 maxabs=1.5746952353179466e-15 maxrel=4.185445897747684e-13
0.003184717551136723,
-0.0010531980398483163,
0.00019103502221934994,
-0.000024596375207993506,
2.4829167842015124e-6,
-2.0714918013027016e-7,
1.4786787279582107e-8,
-9.204643386550694e-10,
// [4.5,5.]: m=5 maxabs=1.40989650510015e-15 maxrel=5.577168980339772e-13
0.002106396079695857,
-0.0007641400880812063,
0.0001475782513229088,
-0.000019863366100655026,
2.0714908234407102e-6,
-1.7713593800726401e-7,
1.2889586263566544e-8,
-8.146909443148922e-10,
// [4.5,5.]: m=6 maxabs=1.2776238400569184e-15 maxrel=6.885904912812819e-13
0.0015282801761617817,
-0.0005903130045786259,
0.00011918019666448252,
-0.00001657195510606624,
1.7713585738180287e-6,
-1.54401269160928e-7,
1.1408252136735498e-8,
-7.300217365435578e-10,
// [4.5,5.]: m=7 maxabs=1.1653004949874202e-15 maxrel=8.060365833030748e-13
0.0011806260091566897,
-0.00047672078601270173,
0.00009943173069094295,
-0.000014170894398959073,
1.5440119503662722e-6,
-1.366512323572351e-7,
1.0222701898574628e-8,
-6.608598654330206e-10,
// [4.5,5.]: m=8 maxabs=1.0722759485881639e-15 maxrel=9.124240286077203e-13
0.0009534415720248707,
-0.00039772692217451296,
0.00008502536644489813,
-0.000012352119172827485,
1.366511642145001e-6,
-1.2244615428894037e-7,
9.254217434561826e-9,
-6.033780147044824e-10,
// [4.5,5.]: m=9 maxabs=9.916113069552424e-16 maxrel=1.0062222588097454e-12
0.0007954538443485257,
-0.00034010146523751983,
0.0000741127150861648,
-0.000010932114810160044,
1.224460900067624e-6,
-1.1084255040308573e-7,
8.449332404790567e-9,
-5.548309977755251e-10,
// [4.5,5.]: m=10 maxabs=9.230897296541585e-16 maxrel=1.0909632738862573e-12
0.0006802029304749119,
-0.00029645085983512587,
0.00006559268892323106,
-9.795707375837425e-6,
1.1084246261624423e-6,
-1.01199052517121e-7,
7.77044357741273e-9,
-5.134922437627053e-10,
// [4.5,5.]: m=11 maxabs=8.630249292984615e-16 maxrel=1.1663202633666399e-12
0.0005929017196698253,
-0.00026237075522636956,
0.000058774244295929125,
-8.867415671298996e-6,
1.0119899798350012e-6,
-9.306616955786596e-8,
7.190636563841592e-9,
-4.777385581214531e-10,
// [4.5,5.]: m=12 maxabs=7.930938891731465e-16 maxrel=1.2077619489232726e-12
0.0005247415104523608,
-0.00023509697674724758,
0.00005320449406439267,
-8.095937298032279e-6,
9.306611950599028e-7,
-8.612006226051288e-8,
6.689960483629954e-9,
-4.468010405763444e-10,
// [4.5,5.]: m=13 maxabs=7.631699092125466e-16 maxrel=1.2940918892838779e-12
0.000470193953494814,
-0.00021281797585559996,
0.00004857562373471506,
-7.445305841024544e-6,
8.612012621078146e-7,
-8.012255159566215e-8,
6.2535034770613145e-9,
-4.19163859155829e-10,
// [4.5,5.]: m=14 maxabs=7.213197053546061e-16 maxrel=1.3485916681684732e-12
0.0004256359517108431,
-0.000194302494553224,
0.00004467183508042334,
-6.889625522288294e-6,
8.012250588476778e-7,
-7.48939580093196e-8,
5.869756976113476e-9,
-3.9488919911259684e-10,
// [4.5,5.]: m=15 maxabs=6.839147304038562e-16 maxrel=1.3982171402618192e-12
0.0003886049891061102,
-0.00017868733995718802,
0.00004133775316613903,
-6.409815050699947e-6,
7.489391482871503e-7,
-7.029711760668532e-8,
5.529829995562471e-9,
-3.732416002465664e-10,
// [4.5,5.]: m=16 maxabs=6.499792024050599e-16 maxrel=1.442923434192934e-12
0.0003573746799140557,
-0.00016535101231901885,
0.00003845889033498339,
-5.9915270075848495e-6,
7.029707655885442e-7,
-6.622527655421675e-8,
5.226695911894785e-9,
-3.5382088894089114e-10,
// [4.5,5.]: m=17 maxabs=6.191878607064716e-16 maxrel=1.4836053086537706e-12
0.000330702024637733,
-0.00015383556101150337,
0.00003594916207479075,
-5.623779261747144e-6,
6.622523751458971e-7,
-6.259423664538919e-8,
4.954741675589715e-9,
-3.3630249715304186e-10,
// [4.5,5.]: m=18 maxabs=5.912696547649698e-16 maxrel=1.5211135736782017e-12
0.0003076711220227136,
-0.0001437966479862441,
0.00003374267559857695,
-5.2980315177968935e-6,
6.259419921824924e-7,
-5.933674107468232e-8,
4.709432136985592e-9,
-3.204229348059162e-10,
// [4.5,5.]: m=19 maxabs=5.656282733856877e-16 maxrel=1.555245965722335e-12
0.0002875932959722097,
-0.0001349707020955131,
0.00003178818913358057,
-5.0075478892620765e-6,
5.933670533767797e-7,
-5.63984488698217e-8,
4.487064715713794e-9,
-3.0596366768528944e-10,
// [4.5,5.]: m=20 maxabs=5.423179266772493e-16 maxrel=1.5873054141255175e-12
0.0002699414041907579,
-0.00012715275624841725,
0.000030045287361300534,
-4.746947862751651e-6,
5.639841459159911e-7,
-5.373499606003148e-8,
4.284587606275908e-9,
-2.9274372076089754e-10,
// [4.5,5.]: m=21 maxabs=5.207423034447878e-16 maxrel=1.6166309967267636e-12
0.0002543055124965769,
-0.00012018114917115295,
0.000028481687201203362,
-4.511884128966978e-6,
5.373496316321895e-7,
-5.130982111887016e-8,
4.0994642793013544e-9,
-2.806112185117481e-10,
// [4.5,5.]: m=22 maxabs=5.007387733624302e-16 maxrel=1.6435743154349215e-12
0.00024036229834205818,
-0.0001139267485416818,
0.000027071304797558587,
-4.298807578119324e-6,
5.130978946789421e-7,
-4.909253163523935e-8,
3.929569352253177e-9,
-2.694381142387484e-10,
// [4.5,5.]: m=23 maxabs=4.821989162129281e-16 maxrel=1.6685682244997185e-12
0.00022785349708312472,
-0.00010828521893717885,
0.00002579284549161174,
-4.104793279386973e-6,
4.909250114040971e-7,
-4.705766291425563e-8,
3.773108776162125e-9,
-2.591157166241627e-10,
// [4.5,5.]: m=24 maxabs=4.651227319962814e-16 maxrel=1.692370032307088e-12
0.0002165704378741281,
-0.00010317138172273717,
0.000024628759698336183,
-3.927409839394504e-6,
4.7057633578548146e-7,
-4.518372362573621e-8,
3.6285585694223928e-9,
-2.495506149144848e-10,
// [4.5,5.]: m=25 maxabs=4.493475903866173e-16 maxrel=1.7151219364863178e-12
0.00020634276344525242,
-0.00009851503855830426,
0.000023564459057642858,
-3.764620087478672e-6,
4.518369527883624e-7,
-4.345245324075094e-8,
3.494615310978091e-9,
-2.406628186778359e-10,
// [4.5,5.]: m=26 maxabs=4.3422297008044453e-16 maxrel=1.7349051825186363e-12
0.00019703007711639368,
-0.00009425783600362812,
0.000022587720545478995,
-3.614704699867086e-6,
4.3452425768538707e-7,
-4.1848239700946126e-8,
3.3701586254307757e-9,
-2.323837203954008e-10,
// [4.5,5.]: m=27 maxabs=4.2026386710969366e-16 maxrel=1.7542046493810056e-12
0.00018851567200704926,
-0.00009035088196252263,
0.000021688228219085892,
-3.47620283703916e-6,
4.1848213205084445e-7,
-4.035765865832097e-8,
3.254219592133835e-9,
-2.2465257428793154e-10,
// [4.5,5.]: m=28 maxabs=4.071721258769312e-16 maxrel=1.772336366968145e-12
0.00018070176392484476,
-0.00008675291266402728,
0.000020857217041478096,
-3.3478655491320664e-6,
4.0357633011056564e-7,
-3.896910430980637e-8,
3.145956573111539e-9,
-2.1741687279341692e-10,
// [4.5,5.]: m=29 maxabs=3.947851160562843e-16 maxrel=1.7890195248348425e-12
0.00017350582532785986,
-0.00008342886796022274,
0.00002008719331350242,
-3.2286188685605598e-6,
3.8969079358679627e-7,
-3.767249259721879e-8,
3.0446347227082373e-9,
-2.106311949883289e-10,
// [4.5,5.]: m=30 maxabs=3.832383629193137e-16 maxrel=1.8052631349707851e-12
0.00016685773592025715,
-0.00008034877305454294,
0.000019371713229475227,
-3.1175343273783517e-6,
3.767246844257761e-7,
-3.645902125257386e-8,
2.9496097326113376e-9,
-2.0425459338968184e-10,
// [4.5,5.]: m=31 maxabs=3.723692361401465e-16 maxrel=1.820716766881431e-12
0.00016069754610890268,
-0.0000774868527242958,
0.000018705205981857464,
-3.0138052196010912e-6,
3.645899780818826e-7,
-3.53209726026819e-8,
2.8603144226025533e-9,
-1.9825125832739054e-10,
// [4.5,5.]: m=32 maxabs=3.619880003385978e-16 maxrel=1.834777318879124e-12
0.00015497370544841372,
-0.00007482082373935574,
0.000018082831334700184,
-2.916727347648204e-6,
3.532094979969244e-7,
-3.4251552175108727e-8,
2.7762475514201064e-9,
-1.9258960996871432e-10,
// [4.5,5.]: m=33 maxabs=3.52175970677604e-16 maxrel=1.8481290926769406e-12
0.00014964164747853858,
-0.00007233132515595095,
0.000017500364102512377,
-2.825683298051288e-6,
3.4251529999397513e-7,
-3.324475524929887e-8,
2.6969644214263067e-9,
-1.8724121317673948e-10,
// [4.5,5.]: m=34 maxabs=3.4293314715716505e-16 maxrel=1.8610741182626586e-12
0.00014466265031173303,
-0.00007000145623214052,
0.000016954099804537123,
-2.7401295163455146e-6,
3.3244733611660056e-7,
-3.229525541641718e-8,
2.6220693269084132e-9,
-1.821810211135771e-10,
// [4.5,5.]: m=35 maxabs=3.340426893427839e-16 maxrel=1.8726994341346415e-12
0.00014000291246411646,
-0.00006781639904491888,
0.00001644077711387691,
-2.6595856181028413e-6,
3.2295234342595195e-7,
-3.139831200044487e-8,
2.5512087774805876e-9,
-1.7738635653608095e-10,
// [4.5,5.]: m=36 maxabs=3.2572143766895767e-16 maxrel=1.884446171396396e-12
0.00013563279808967766,
-0.00006576310828672412,
0.000015957513724013253,
-2.583625498785986e-6,
3.1398291464072446e-7,
-3.0549691770201854e-8,
2.4840663270523742e-9,
-1.7283686750435728e-10,
// [4.5,5.]: m=37 maxabs=3.1777965675550135e-16 maxrel=1.8954862901369212e-12
0.00013152621657329155,
-0.00006383005473148678,
0.000015501753007751343,
-2.5118698997417364e-6,
3.0549671727229714e-7,
-2.9745602989317313e-8,
2.4203575301352193e-9,
-1.6851423948707607e-10,
// [4.5,5.]: m=38 maxabs=3.101902415481028e-16 maxrel=1.9058552613084146e-12
0.0001276601094628204,
-0.00006200701187045453,
0.00001507121941314944,
-2.4439801601819544e-6,
2.9745583395557767e-7,
-2.898263936534844e-8,
2.3598262379665732e-9,
-1.6440219536147131e-10,
// [4.5,5.]: m=39 maxabs=3.0300740215538635e-16 maxrel=1.916083624034462e-12
0.00012401402374076018,
-0.000060284877495873985,
0.000014663880975393444,
-2.3796529406127943e-6,
2.898262029287898e-7,
-2.8257732785223674e-8,
2.3022411216278883e-9,
-1.6048541027182316e-10,
// [4.5,5.]: m=40 maxabs=2.9614982341441554e-16 maxrel=1.925859778380511e-12
0.00012056975499160246,
-0.00005865552374849635,
0.000014277917657664269,
-2.3186157465085504e-6,
2.825771413193165e-7,
-2.756811200650718e-8,
2.247392654686823e-9,
-1.5675039745926832e-10
},
{
// [5.,5.5]: m=0 maxabs=1.887379141862766e-15 maxrel=4.769573996119677e-15
0.3863194216613601,
-0.018146281107722657,
0.0012336924793731872,
-0.00008750035868421456,
5.9902239129842355e-6,
-3.8330107329780066e-7,
2.2647808084540863e-8,
-1.2271109811241744e-9,
// [5.,5.5]: m=1 maxabs=1.5543122344752192e-15 maxrel=3.9959246260862756e-14
0.03629256221544419,
-0.004934769916530936,
0.000525002152174753,
-0.00004792182960347869,
3.833009946095386e-6,
-2.71406801188965e-7,
1.7181943350234968e-8,
-9.773381558017516e-10,
// [5.,5.5]: m=2 maxabs=1.3183898417423734e-15 maxrel=1.1990336902943175e-13
0.009869539833061155,
-0.0021000086079107118,
0.0002875309776857744,
-0.000030664111091044577,
2.714067158924126e-6,
-2.0588077149763636e-7,
1.3685437025142004e-8,
-8.066763105223509e-10,
// [5.,5.5]: m=3 maxabs=1.1423154089307275e-15 maxrel=2.3680214562745123e-13
0.004200017215820886,
-0.0011501239100746275,
0.00018398466659885667,
-0.00002171256399887981,
2.058807013277352e-6,
-1.6396872455363075e-7,
1.1295712331388609e-8,
-6.839328973384502e-10,
// [5.,5.5]: m=4 maxabs=1.0065732969355423e-15 maxrel=3.723978150021886e-13
0.00230024782014879,
-0.0007359386658172386,
0.0001302753840414794,
-0.000016470479233884276,
1.639686604123551e-6,
-1.3532652483314732e-7,
9.577110727251484e-9,
-5.920588813872388e-10,
// [5.,5.5]: m=5 maxabs=8.975025583835006e-16 maxrel=5.102746307916467e-13
0.0014718773316340348,
-0.0005211015356570323,
0.00009882287544580923,
-0.000013117513186758095,
1.3532646817657994e-6,
-1.1472994123466584e-7,
8.290634089723982e-9,
-5.210254290532963e-10,
// [5.,5.5]: m=6 maxabs=8.090316611086834e-16 maxrel=6.416031981866579e-13
0.0010422030713136941,
-0.00039529150132876684,
0.00007870507915804218,
-0.000010826135629581752,
1.147298869490773e-6,
-9.931325726304169e-8,
7.296152956808028e-9,
-4.64679034975724e-10,
// [5.,5.5]: m=7 maxabs=7.362816953349061e-16 maxrel=7.626348696741528e-13
0.0007905830026571716,
-0.00031482031622298063,
0.0000649568138122673,
-9.178407322848564e-6,
9.931321088819018e-7,
-8.739671987321554e-8,
6.506988438641438e-9,
-4.189644588655088e-10,
// [5.,5.5]: m=8 maxabs=6.750242725894751e-16 maxrel=8.717052460541118e-13
0.0006296406324456562,
-0.00025982725487633094,
0.000055070443967758735,
-7.945071780171973e-6,
8.739667555874881e-7,
-7.794082503975935e-8,
5.866980165406826e-9,
-3.8122491995531017e-10,
// [5.,5.5]: m=9 maxabs=5.959859342152818e-16 maxrel=9.274054181943497e-13
0.000519654509752353,
-0.00022028177552965518,
0.00004767043071071908,
-6.991747699882697e-6,
7.79407853818508e-7,
-7.027267069426724e-8,
5.338421883249118e-9,
-3.4958617953229173e-10,
// [5.,5.5]: m=10 maxabs=5.785302792382652e-16 maxrel=1.0572219305601949e-12
0.0004405635510589852,
-0.0001906817225269697,
0.000041950486228633416,
-6.235275467277098e-6,
7.027263650331272e-7,
-6.393984508855472e-8,
4.895043201853749e-9,
-3.22649955240743e-10,
// [5.,5.5]: m=11 maxabs=5.397158414632841e-16 maxrel=1.1353787758629928e-12
0.00038136344505367286,
-0.00016780194462202627,
0.000037411652829212894,
-5.6218226201608605e-6,
6.393981103822569e-7,
-5.862820118163796e-8,
4.518188811162717e-9,
-2.9950986601866636e-10,
// [5.,5.5]: m=12 maxabs=5.057803134644878e-16 maxrel=1.2055657402057393e-12
0.0003356038892438043,
-0.00014964661104398909,
0.000033730935744848656,
-5.11519579753774e-6,
5.862816931806286e-7,
-5.411348636799773e-8,
4.1941578472475665e-9,
-2.794123364463578e-10,
// [5.,5.5]: m=13 maxabs=4.76073173938385e-16 maxrel=1.2693604886624669e-12
0.00029929322208774355,
-0.00013492374272372034,
0.000030691174807724226,
-4.690263772245344e-6,
5.411345638404276e-7,
-5.023171771552181e-8,
3.912731931059197e-9,
-2.618022612731325e-10,
// [5.,5.5]: m=14 maxabs=4.491307499521202e-16 maxrel=1.3254978691471827e-12
0.00026984748544721973,
-0.00012276469899041262,
0.000028141582654703948,
-4.329086129970093e-6,
5.023168940073318e-7,
-4.686043896660045e-8,
3.6661378063555277e-9,
-2.462503230813819e-10,
// [5.,5.5]: m=15 maxabs=4.251156718315663e-16 maxrel=1.376495069693944e-12
0.0002455293979806155,
-0.00011256633039183654,
0.000025974516799964753,
-4.018544231058834e-6,
4.6860412106302843e-7,
-4.3906495881894684e-8,
3.448364121314483e-9,
-2.324199951261365e-10,
// [5.,5.5]: m=16 maxabs=4.037026789249776e-16 maxrel=1.4234585907991348e-12
0.00022513266078347436,
-0.00010389806698496936,
0.00002411126540542356,
-3.74884156405777e-6,
4.3906470455741706e-7,
-4.1297852750772705e-8,
3.25469356644676e-9,
-2.200429595578272e-10,
// [5.,5.5]: m=17 maxabs=3.8429546003748705e-16 maxrel=1.4661717874229549e-12
0.00020779613396974982,
-0.00009644506141767486,
0.000022493049402488268,
-3.5125257970008904e-6,
4.129782856374338e-7,
-3.8977982981995975e-8,
3.081375383314924e-9,
-2.0890378256656565e-10,
// [5.,5.5]: m=18 maxabs=3.665416494630369e-16 maxrel=1.5047881833477727e-12
0.0001928901228351689,
-0.00008997219741578049,
0.000021075154799338584,
-3.3038340518756597e-6,
3.8977959880177366e-7,
-3.69019440554984e-8,
2.925392114471459e-9,
-1.9882742418181752e-10,
// [5.,5.5]: m=19 maxabs=3.503870370930029e-16 maxrel=1.5404035811864727e-12
0.00017994439483138828,
-0.00008430061901211784,
0.000019823004327807125,
-3.1182441995843447e-6,
3.6901921996536777e-7,
-3.503357856039798e-8,
2.784289623791025e-9,
-1.8966971560194086e-10,
// [5.,5.5]: m=20 maxabs=3.356147824928879e-16 maxrel=1.5733175977097968e-12
0.0001686012380240707,
-0.00007929201713416201,
0.00001870946521337218,
-2.952160842293183e-6,
3.5033557406228465e-7,
-3.3343483282056824e-8,
2.6560528754488595e-9,
-1.813117120291447e-10,
// [5.,5.5]: m=21 maxabs=3.220080452281948e-16 maxrel=1.6035984351008408e-12
0.00015858403426816586,
-0.00007483786068389491,
0.000017712965068946817,
-2.8026913760096925e-6,
3.334346302908073e-7,
-3.180751385215571e-8,
2.539012218663274e-9,
-1.736535582980521e-10,
// [5.,5.5]: m=22 maxabs=3.0943130002736297e-16 maxrel=1.631505384860442e-12
0.00014967572136763768,
-0.00007085186011307094,
0.000016816148270671317,
-2.6674835507607268e-6,
3.180749437234295e-7,
-3.0405666693062495e-8,
2.4317730583451426e-9,
-1.666115656373259e-10,
// [5.,5.5]: m=23 maxabs=2.977761266731438e-16 maxrel=1.6573016881943363e-12
0.00014170372022599567,
-0.00006726459292632007,
0.000016004901318618845,
-2.5446058043212547e-6,
3.040564794779642e-7,
-2.9121233532033105e-8,
2.3331618748438353e-9,
-1.6011471264191757e-10,
// [5.,5.5]: m=24 maxabs=2.869612100026009e-16 maxrel=1.6812912050459398e-12
0.0001345291858524993,
-0.00006401960512397633,
0.000015267634839472547,
-2.432457855612805e-6,
2.912121546916741e-7,
-2.794015348452662e-8,
2.2421839809381297e-9,
-1.5410243069854127e-10,
// [5.,5.5]: m=25 maxabs=2.770949702329828e-16 maxrel=1.7048565786877003e-12
0.00012803921024781684,
-0.00006107053921284798,
0.000014594747146733563,
-2.3297030392211497e-6,
2.7940136070219834e-7,
-2.685051167038023e-8,
2.1579913274590433e-9,
-1.485226108686004e-10,
// [5.,5.5]: m=26 maxabs=2.676624113323589e-16 maxrel=1.7254944432772553e-12
0.00012214107842556428,
-0.000058378988446959755,
0.000013978218247977571,
-2.23521648453198e-6,
2.6850494803557793e-7,
-2.5842146708156702e-8,
2.079856232899517e-9,
-1.433306737668868e-10,
// [5.,5.5]: m=27 maxabs=2.588803737352263e-16 maxrel=1.7450330439414776e-12
0.00011675797689379216,
-0.000055912872856662575,
0.0000134112989194175,
-2.148044994078591e-6,
2.584213041003008e-7,
-2.4906341513480827e-8,
2.0071509152093595e-9,
-1.3848748786152625e-10,
// [5.,5.5]: m=28 maxabs=2.5074885744158504e-16 maxrel=1.7640334633414251e-12
0.00011182574571320142,
-0.00005364519554685313,
0.000012888269976348607,
-2.067375665551868e-6,
2.490632568339069e-7,
-2.4035576308926662e-8,
1.9393312368182257e-9,
-1.3395936947397836e-10,
// [5.,5.5]: m=29 maxabs=2.430239169626258e-16 maxrel=1.7812714513804075e-12
0.00010729039109358605,
-0.000051553079778718556,
0.000012404254004841612,
-1.9925111217432917e-6,
2.4035560940333096e-7,
-2.3223330958015874e-8,
1.8759229244456293e-9,
-1.2971682047155697e-10,
// [5.,5.5]: m=30 maxabs=2.3575976240697294e-16 maxrel=1.797510632646759e-12
0.0001031061595573209,
-0.000049617015896579445,
0.000011955066741610566,
-1.9228497866929026e-6,
2.3223316095590996e-7,
-2.2463925056327662e-8,
1.8165110277261998e-9,
-1.2573344312591226e-10,
// [5.,5.5]: m=31 maxabs=2.289563937746264e-16 maxrel=1.8131508924072778e-12
0.00009923403179304586,
-0.00004782026684731197,
0.000011537098731004854,
-1.8578700528140705e-6,
2.2463910599861978e-7,
-2.1752387094435762e-8,
1.760730734261834e-9,
-1.2198649375666235e-10,
// [5.,5.5]: m=32 maxabs=2.2250539084833765e-16 maxrel=1.8277029282840977e-12
0.00009564053369451417,
-0.00004614839480834088,
0.000011147220327419483,
-1.7971174751593818e-6,
2.1752373050192362e-7,
-2.1084347962479746e-8,
1.7082602940560869e-9,
-1.184555429138049e-10,
// [5.,5.5]: m=33 maxabs=2.1646096373673096e-16 maxrel=1.8419344962238597e-12
0.00009229678961657477,
-0.000044588881197252924,
0.000010782704861213578,
-1.7401943409985026e-6,
2.1084334297309223e-7,
-2.045595255334669e-8,
1.6588146747581545e-9,
-1.1512248645059e-10,
// [5.,5.5]: m=34 maxabs=2.1067403464108958e-16 maxrel=1.854888431997297e-12
0.0000891777623944019,
-0.000043130819335504745,
0.000010441166055970527,
-1.6867511177204677e-6,
2.0455939249082607e-7,
-1.9863786660950135e-8,
1.6121405235058276e-9,
-1.119711911915958e-10,
// [5.,5.5]: m=35 maxabs=2.0519881367003778e-16 maxrel=1.867282170904114e-12
0.00008626163867090802,
-0.0000417646641174474,
0.000010120506716061171,
-1.6364793972948344e-6,
1.9863773680982811e-7,
-1.930481580399296e-8,
1.5680119509292368e-9,
-1.0898733991251174e-10,
// [5.,5.5]: m=36 maxabs=2.000217482964195e-16 maxrel=1.8792611697867742e-12
0.00008352932823479597,
-0.00004048202676057563,
9.818876393252208e-6,
-1.5891060412702899e-6,
1.9304803168011343e-7,
-1.8776334184868904e-8,
1.5262269407719028e-9,
-1.0615786662363448e-10,
// [5.,5.5]: m=37 maxabs=1.9508862841161045e-16 maxrel=1.8905614145211576e-12
0.00008096405352105503,
-0.00003927550547196013,
9.53463625686109e-6,
-1.5443882953447864e-6,
1.877632186993139e-7,
-1.8275921342134464e-8,
1.4866041359894562e-9,
-1.0347120017306574e-10,
// [5.,5.5]: m=38 maxabs=1.903723489612985e-16 maxrel=1.9011259483176096e-12
0.0000785510109438265,
-0.00003813854492889175,
9.266329781065634e-6,
-1.5021096916838396e-6,
1.8275909350594035e-7,
-1.780140574636394e-8,
1.448980455313803e-9,
-1.0091668845733548e-10,
// [5.,5.5]: m=39 maxabs=1.8588646247263974e-16 maxrel=1.911284184781621e-12
0.000076277089857692,
-0.00003706531902808601,
9.012658158893484e-6,
-1.4620765951282305e-6,
1.7801394024534464e-7,
-1.7350833533817412e-8,
1.4132087458041273e-9,
-9.848491953470827e-11,
// [5.,5.5]: m=40 maxabs=1.816445214727902e-16 maxrel=1.9213818896917858e-12
0.00007413063805608243,
-0.00003605063254166029,
8.772459579373567e-6,
-1.424115278524591e-6,
1.7350822063394053e-7,
-1.6922442065112957e-8,
1.3791558838492356e-9,
-9.616728978315061e-11
},
{
// [5.5,6.]: m=0 maxabs=1.27675647831893e-15 maxrel=3.3817410436780496e-15
0.3693249610515071,
-0.015919225228477836,
0.0010036148977082817,
-0.00006695980999414568,
4.37402656076367e-6,
-2.702412709702681e-7,
1.555512611607224e-8,
-8.265401581906769e-10,
// [5.5,6.]: m=1 maxabs=1.0200174038743626e-15 maxrel=3.0044103301997535e-14
0.031838450456955346,
-0.004014459590189317,
0.0004017588599699233,
-0.00003499223797406835,
2.702412731139762e-6,
-1.8641787972246244e-7,
1.1571477175007679e-8,
-6.484444291424306e-10,
// [5.5,6.]: m=2 maxabs=8.586881206085195e-16 maxrel=9.661480687703072e-14
0.008028919180378222,
-0.0016070354393644245,
0.0002099534278758695,
-0.000021619322478677057,
1.8641784162070772e-6,
-1.3865947508536795e-7,
9.079422484553077e-9,
-5.289707909546646e-10,
// [5.5,6.]: m=3 maxabs=7.363901155521546e-16 maxrel=2.0074090297894605e-13
0.0032140708787284987,
-0.000839813711069165,
0.00012971593490555846,
-0.000014913444695134802,
1.3865943068204142e-6,
-1.0878640664941316e-7,
7.4070084010619386e-9,
-4.4435420147406777e-10,
// [5.5,6.]: m=4 maxabs=6.431487287184012e-16 maxrel=3.276544981900352e-13
0.001679627422138036,
-0.0005188637392493731,
0.00008948066820083949,
-0.000011092769369708906,
1.0878636654568307e-6,
-8.87409203424936e-8,
6.222242742364138e-9,
-3.8180522706410077e-10,
// [5.5,6.]: m=5 maxabs=5.728924279413405e-16 maxrel=4.640782724146285e-13
0.0010377274784983915,
-0.00035792267247725915,
0.00006655661624517677,
-8.702922369515942e-6,
8.874088461670052e-7,
-7.454167557422905e-8,
5.34641315328041e-9,
-3.3395978734497734e-10,
// [5.5,6.]: m=6 maxabs=5.139118297581291e-16 maxrel=5.955297567092071e-13
0.0007158453449541455,
-0.0002662264646912805,
0.00005221753424136384,
-7.0992823457814656e-6,
7.45416431924435e-7,
-6.404583062252518e-8,
4.676473864477006e-9,
-2.9633044566319207e-10,
// [5.5,6.]: m=7 maxabs=4.658816735170213e-16 maxrel=7.18593697767031e-13
0.0005324529293823318,
-0.00020887013670562783,
0.00004259569409668099,
-5.963341847777457e-6,
6.404580123041525e-7,
-5.60179204169455e-8,
4.1495666805028955e-9,
-2.660395838796726e-10,
// [5.5,6.]: m=8 maxabs=4.2587461335230614e-16 maxrel=8.308877004833942e-13
0.0004177402734110135,
-0.00017038277615140778,
0.00003578005111085126,
-5.123673521612537e-6,
5.601788981166397e-7,
-4.9704340316475036e-8,
3.725507681523326e-9,
-2.411995872514455e-10,
// [5.5,6.]: m=9 maxabs=3.9221013589663123e-16 maxrel=9.324929565896034e-13
0.0003407655523026229,
-0.000143120204228079,
0.00003074204114815628,
-4.481439797604629e-6,
4.970431569220565e-7,
-4.462341222314943e-8,
3.377581857096151e-9,
-2.2047759195429812e-10,
// [5.5,6.]: m=10 maxabs=3.647256108241237e-16 maxrel=1.0274745275281893e-12
0.00028624040845597217,
-0.0001229681643945157,
0.000026888638803170318,
-3.976353178211113e-6,
4.462339024896449e-7,
-4.045488913903597e-8,
3.087377024227703e-9,
-2.0296894429436322e-10,
// [5.5,6.]: m=11 maxabs=3.3810844748960456e-16 maxrel=1.1043851100434098e-12
0.00024593632878865476,
-0.00010755455502761327,
0.0000238581191174284,
-3.5698784890023265e-6,
4.0454852437030766e-7,
-3.697854066022076e-8,
2.8420187206925174e-9,
-1.879509843123195e-10,
// [5.5,6.]: m=12 maxabs=3.161533534967731e-16 maxrel=1.1770023798357044e-12
0.00021510911005507064,
-0.00009543247629883498,
0.000021419270948972286,
-3.2363950299726824e-6,
3.697852073735468e-7,
-3.403860928542857e-8,
2.631950902390728e-9,
-1.749730460921279e-10,
// [5.5,6.]: m=13 maxabs=2.878285717405893e-16 maxrel=1.2045547809088026e-12
0.00019086495259745966,
-0.0000856770836360812,
0.000019418370195930774,
-2.958288051275908e-6,
3.403858892580687e-7,
-3.152204515266004e-8,
2.450259025425579e-9,
-1.6364131184583142e-10,
// [5.5,6.]: m=14 maxabs=2.798325807185087e-16 maxrel=1.30161117075315e-12
0.00017135416727202438,
-0.00007767348062546013,
0.00001774972832091634,
-2.723093247837879e-6,
3.1522027471497027e-7,
-2.934503379271198e-8,
2.291544178560158e-9,
-1.536658273307422e-10,
// [5.5,6.]: m=15 maxabs=2.6459954019508736e-16 maxrel=1.3550756500239715e-12
0.00015534696125079004,
-0.00007099891314223808,
0.000016338559499523397,
-2.5217678547567018e-6,
2.9345017142225795e-7,
-2.7444222755854223e-8,
2.151854193340328e-9,
-1.4481953222071033e-10,
// [5.5,6.]: m=16 maxabs=2.5088438271314573e-16 maxrel=1.403399518851776e-12
0.00014199782628435275,
-0.00006535423786438026,
0.0000151306071403913,
-2.3476067199301355e-6,
2.744420696112807e-7,
-2.5770904136318487e-8,
2.027978767168849e-9,
-1.369232895823285e-10,
// [5.5,6.]: m=17 maxabs=2.385515830011231e-16 maxrel=1.447676000853942e-12
0.00013070847572864324,
-0.00006052242843477184,
0.000014085640330857795,
-2.1955416285705874e-6,
2.5770889098873017e-7,
-2.4287057425203925e-8,
1.9174072202962973e-9,
-1.2983355069482194e-10,
// [5.5,6.]: m=18 maxabs=2.2733009051589814e-16 maxrel=1.4879270789435842e-12
0.00012104485686943163,
-0.000056342561202884094,
0.000013173249782178247,
-2.0616759496562434e-6,
2.42870430887751e-7,
-2.2962598527245848e-8,
1.8181284256219481e-9,
-1.2343398395834037e-10,
// [5.5,6.]: m=19 maxabs=2.1711148504022226e-16 maxrel=1.524851337732204e-12
0.00011268512240566196,
-0.00005269299901383942,
0.000012370055708169506,
-1.942968041988779e-6,
2.2962584858234423e-7,
-2.1773430160131794e-8,
1.7285136189462987e-9,
-1.1762929623103043e-10,
// [5.5,6.]: m=20 maxabs=2.0786866151978334e-16 maxrel=1.5595865140333027e-12
0.00010538599802757639,
-0.000049480222722966576,
0.000011657808261775076,
-1.8370111770459663e-6,
2.1773417035905705e-7,
-2.0700035315935158e-8,
1.6472300970017895e-9,
-1.1234102513743624e-10,
// [5.5,6.]: m=21 maxabs=1.9927635930283571e-16 maxrel=1.5908650590874073e-12
0.00009896044544583479,
-0.00004663123294211238,
0.00001102206707172297,
-1.7418775623019625e-6,
2.0700022716632433e-7,
-1.972644706457554e-8,
1.5731775650444907e-9,
-1.0750379643755057e-10,
// [5.5,6.]: m=22 maxabs=1.9130747333506726e-16 maxrel=1.6193373210475765e-12
0.00009326246588413059,
-0.00004408826818624573,
0.00001045126538286612,
-1.656005843192217e-6,
1.9726434984209912e-7,
-1.8839482392695203e-8,
1.505439936639545e-9,
-1.0306262224589309e-10,
// [5.5,6.]: m=23 maxabs=1.8401621372510224e-16 maxrel=1.6463430723961095e-12
0.00008817653637240083,
-0.000041805061434812766,
9.936035067862408e-6,
-1.5781186648289741e-6,
1.8839470778981953e-7,
-1.80281648938385e-8,
1.443248397326291e-9,
-9.897105186178111e-11,
// [5.5,6.]: m=24 maxabs=1.7728060772853604e-16 maxrel=1.6716764045578487e-12
0.00008361012286953801,
-0.000039744140178490503,
9.468711997380933e-6,
-1.507161380679931e-6,
1.802815368643047e-7,
-1.7283284548407026e-8,
1.385953362568329e-9,
-9.51897987331236e-11,
// [5.5,6.]: m=25 maxabs=1.709515775466519e-16 maxrel=1.6946356775795497e-12
0.00007948828035689697,
-0.00003787484789998842,
9.042968292159572e-6,
-1.4422558763475016e-6,
1.7283273769830587e-7,
-1.6597058542193457e-8,
1.3330022295841886e-9,
-9.16848912866918e-11,
// [5.5,6.]: m=26 maxabs=1.6511043834238626e-16 maxrel=1.716632680481153e-12
0.00007574969579989544,
-0.00003617187308228275,
8.653535265900619e-6,
-1.382665355793329e-6,
1.6597048120647957e-7,
-1.5962866428182198e-8,
1.2839220289241356e-9,
-8.842739610630372e-11,
// [5.5,6.]: m=27 maxabs=1.5958100726271018e-16 maxrel=1.7364397647808432e-12
0.00007234374616448691,
-0.00003461414098021221,
8.295992142308484e-6,
-1.3277671852759952e-6,
1.5962856361989403e-7,
-1.5375042331637507e-8,
1.2383057328631658e-9,
-8.539207811523563e-11,
// [5.5,6.]: m=28 maxabs=1.5443104694340404e-16 maxrel=1.7552645111576926e-12
0.0000692282819603484,
-0.00003318396848860914,
7.966603118961677e-6,
-1.2770317339057965e-6,
1.5375032585779453e-7,
-1.4828709631423053e-8,
1.1958010662632113e-9,
-8.255714590015181e-11,
// [5.5,6.]: m=29 maxabs=1.496198998029996e-16 maxrel=1.7731641196722293e-12
0.00006636793697714484,
-0.00003186641239781523,
7.662190410501477e-6,
-1.2300057281059688e-6,
1.4828700203944692e-7,
-1.4319648963055544e-8,
1.1561018115999093e-9,
-7.990336588129402e-11,
// [5.5,6.]: m=30 maxabs=1.451475658414969e-16 maxrel=1.790621036742429e-12
0.00006373282479555875,
-0.00003064876156640577,
7.380034375513634e-6,
-1.1862990403143224e-6,
1.4319639796118415e-7,
-1.3844191416003805e-8,
1.1189404233565567e-9,
-7.741411767684472e-11,
// [5.5,6.]: m=31 maxabs=1.4086496726017916e-16 maxrel=1.8062082905398484e-12
0.00006129752313274209,
-0.000029520137428741058,
7.1177942485555665e-6,
-1.1455741162665179e-6,
1.3844182523535508e-7,
-1.3399132169434607e-8,
1.0840822286070703e-9,
-7.507464114758817e-11,
// [5.5,6.]: m=32 maxabs=1.368534192219828e-16 maxrel=1.8212769927349676e-12
0.000059040274857414705,
-0.00002847117692305613,
6.873444704061059e-6,
-1.1075374484802839e-6,
1.3399123559514878e-7,
-1.2981659683268349e-8,
1.0513204110046863e-9,
-7.287165991924104e-11,
// [5.5,6.]: m=33 maxabs=1.3305871161828353e-16 maxrel=1.8354681607311205e-12
0.00005694235384604668,
-0.0000274937787471088,
6.645224697185207e-6,
-1.0719326501632911e-6,
1.298165127816216e-7,
-1.2589297166974346e-8,
1.0204721878726837e-9,
-7.079383537023029e-11,
// [5.5,6.]: m=34 maxabs=1.294672919219253e-16 maxrel=1.8488991270550174e-12
0.000054987557494153706,
-0.000026580898721522535,
6.4315959071149195e-6,
-1.0385347909717976e-6,
1.2589288989571402e-7,
-1.2219854642336988e-8,
9.91375311176634e-10,
-6.8830781146029e-11,
// [5.5,6.]: m=35 maxabs=1.2602495002428382e-16 maxrel=1.8610613633256706e-12
0.00005316179744298301,
-0.000025726383563053973,
6.231208751790499e-6,
-1.007145735340828e-6,
1.2219846694696152e-7,
-1.1871388663805396e-8,
9.638852993062432e-10,
-6.697322925224591e-11,
// [5.5,6.]: m=36 maxabs=1.2282655361545158e-16 maxrel=1.873615622383877e-12
0.00005145276712604743,
-0.00002492483494347578,
6.042874417855869e-6,
-9.775902829852847e-7,
1.1871380916704665e-7,
-1.1542168630662544e-8,
9.378731006992277e-10,
-6.521296361738959e-11,
// [5.5,6.]: m=37 maxabs=1.1976368247818003e-16 maxrel=1.8852080670582356e-12
0.00004984966988689273,
-0.000024171497609368285,
5.865541703569643e-6,
-9.497129555039946e-7,
1.1542161083236847e-7,
-1.1230648633554544e-8,
9.132230508963131e-10,
-6.354247683381693e-11,
// [5.5,6.]: m=38 maxabs=1.1683633661246917e-16 maxrel=1.8960336974473982e-12
0.00004834299521867882,
-0.000023462166753774637,
5.698277738567206e-6,
-9.233753067951689e-7,
1.1230641242031433e-7,
-1.0935443370300627e-8,
8.898312503653941e-10,
-6.195523590667626e-11,
// [5.5,6.]: m=39 maxabs=1.14044516018319e-16 maxrel=1.906287951860365e-12
0.00004692433350749295,
-0.00002279311089523991,
5.540251846178349e-6,
-8.984536605079202e-7,
1.0935436160043901e-7,
-1.065530806039424e-8,
8.676040530544214e-10,
-6.044512861027585e-11,
// [5.5,6.]: m=40 maxabs=1.1139499695930755e-16 maxrel=1.9162832177380447e-12
0.000045586221790424995,
-0.000022161007327088257,
5.390721968319626e-6,
-8.748371977773162e-7,
1.0655301028756791e-7,
-1.038912104363769e-8,
8.464568456071931e-10,
-5.900662404473703e-11
},
{
// [6.,6.5]: m=0 maxabs=9.43689570931383e-16 maxrel=2.6097021813184936e-15
0.35434650944701185,
-0.014096642212430895,
0.0008264939914920365,
-0.00005188217587981761,
3.2295722260187684e-6,
-1.9231140678995915e-7,
1.0764944014582687e-8,
-5.599918422508938e-10,
// [6.,6.5]: m=1 maxabs=6.696032617270475e-16 maxrel=2.2374217339587304e-14
0.028193284424862155,
-0.003305975965534218,
0.0003112930552763257,
-0.00002583659493290131,
1.9231138970230213e-6,
-1.2901626196600507e-7,
7.840815558481505e-9,
-4.323331366150662e-10,
// [6.,6.5]: m=2 maxabs=5.594483210025203e-16 maxrel=7.689694482390068e-14
0.006611951931068268,
-0.0012451722207645615,
0.00015501956961551478,
-0.000015384924791200118,
1.290162367264992e-6,
-9.395914903907285e-8,
6.053487025670747e-9,
-3.482629269615218e-10,
// [6.,6.5]: m=3 maxabs=4.77048955893622e-16 maxrel=1.688781136305963e-13
0.002490344441528885,
-0.0006200782781789934,
0.00009230954877034023,
-0.000010321310255906515,
9.395911802617118e-7,
-7.25332167700597e-8,
4.876673018265968e-9,
-2.896450880841314e-10,
// [6.,6.5]: m=4 maxabs=4.145989107584569e-16 maxrel=2.8766731056475723e-13
0.0012401565563577713,
-0.00036923819483980757,
0.00006192786155467112,
-7.5167391047439515e-6,
7.253318761075691e-7,
-5.842740925268563e-8,
4.05602225527822e-9,
-2.46912126532729e-10,
// [6.,6.5]: m=5 maxabs=3.651592916931179e-16 maxrel=4.176252868725539e-13
0.0007384763896793345,
-0.0002477114460099417,
0.000045100434646160153,
-5.8026633609456755e-6,
5.842739031336746e-7,
-4.8591937070747784e-8,
3.457306340720108e-9,
-2.1451183822171287e-10,
// [6.,6.5]: m=6 maxabs=3.2699537522162814e-16 maxrel=5.496240252462768e-13
0.0004954228920195065,
-0.00018040173840119382,
0.0000348159801994002,
-4.674198612683091e-6,
4.859189647233711e-7,
-4.141667431579595e-8,
3.0043665881406985e-9,
-1.8934709638499454e-10,
// [6.,6.5]: m=7 maxabs=2.951198313505543e-16 maxrel=6.738515580253027e-13
0.0003608034768022429,
-0.00013926392063232126,
0.000028045191690030992,
-3.887358328519268e-6,
4.1416655733854744e-7,
-3.5988938312495666e-8,
2.6514541176703688e-9,
-1.6922533936737166e-10,
// [6.,6.5]: m=8 maxabs=2.6904476910227793e-16 maxrel=7.892492411341266e-13
0.0002785278412645097,
-0.0001121807666108668,
0.000023324149983860532,
-3.3133384288253427e-6,
3.598892133252231e-7,
-3.176013738042698e-8,
2.369697886618575e-9,
-1.5282986973867123e-10,
// [6.,6.5]: m=9 maxabs=2.4692704478357363e-16 maxrel=8.934961499781575e-13
0.00022436153322161152,
-0.00009329659979945995,
0.00001988003058471106,
-2.8791191457008016e-6,
3.176012169085852e-7,
-2.8384159869077965e-8,
2.1401203311151655e-9,
-1.3923884870670435e-10,
// [6.,6.5]: m=10 maxabs=2.2811613709095013e-16 maxrel=9.874810597283778e-13
0.0001865931995988077,
-0.00007952012221402756,
0.000017274714885010077,
-2.540814727809991e-6,
2.838414545545045e-7,
-2.5633516468451477e-8,
1.9498051556218797e-9,
-1.2780480111730712e-10,
// [6.,6.5]: m=11 maxabs=2.1190731461229184e-16 maxrel=1.071854768133827e-12
0.00015904024442795096,
-0.00006909885942474389,
0.000015244888376882129,
-2.2707362482644758e-6,
2.56335031008298e-7,
-2.3353388461711964e-8,
1.7896950437585397e-9,
-1.180622455508616e-10,
// [6.,6.5]: m=12 maxabs=1.9783979142429242e-16 maxrel=1.1477940988760318e-12
0.00013819771884939034,
-0.00006097955340042981,
0.000013624417498961059,
-2.0506845320037086e-6,
2.3353375956978493e-7,
-2.1435214739801274e-8,
1.6532716279382178e-9,
-1.0966880878564958e-10,
// [6.,6.5]: m=13 maxabs=1.8547988665795767e-16 maxrel=1.2160100300819335e-12
0.00012195910680076835,
-0.00005449766989587802,
0.000012304107200775313,
-1.8682740752227638e-6,
2.1435203073457274e-7,
-1.9800872182087528e-8,
1.535736556316832e-9,
-1.0236669220110051e-10,
// [6.,6.5]: m=14 maxabs=1.744752346072298e-16 maxrel=1.2769599051945092e-12
0.00010899533979167008,
-0.00004921642870938952,
0.000011209644459604904,
-1.7148199943217406e-6,
1.9800861156724441e-7,
-1.8392853722142982e-8,
1.4334864670009611e-9,
-9.595966234846636e-11,
// [6.,6.5]: m=15 maxabs=1.6471741505486026e-16 maxrel=1.3322939489717352e-12
0.0000984328574186981,
-0.000044838577750240234,
0.000010288919973711235,
-1.5840724196998862e-6,
1.8392843345304204e-7,
-1.7167976953284407e-8,
1.3437673649380102e-9,
-9.02947807109822e-11,
// [6.,6.5]: m=16 maxabs=1.560166926206641e-16 maxrel=1.382804467561517e-12
0.00008967715550040383,
-0.00004115567981159047,
9.504434525564734e-6,
-1.4714307977940674e-6,
1.7167967133999371e-7,
-1.6093238868597794e-8,
1.2644410756549171e-9,
-8.525175160039623e-11,
// [6.,6.5]: m=17 maxabs=1.4816977939730025e-16 maxrel=1.4286987057633836e-12
0.00008231135962310788,
-0.00003801773802341149,
8.828584793782129e-6,
-1.373440524511882e-6,
1.6093229511293764e-7,
-1.5143017017291338e-8,
1.1938239577954245e-9,
-8.073487217856774e-11,
// [6.,6.5]: m=18 maxabs=1.4108180769467626e-16 maxrel=1.47077160333139e-12
0.00007603547604675323,
-0.00003531433910025844,
8.240643153760495e-6,
-1.287461355708533e-6,
1.5143008099147816e-7,
-1.4297137398458178e-8,
1.1305735501229679e-9,
-7.666675413868601e-11,
// [6.,6.5]: m=19 maxabs=1.345494896054511e-16 maxrel=1.508369153783201e-12
0.00007062867820045045,
-0.00003296257254376924,
7.724768140633541e-6,
-1.2114434988650764e-6,
1.429712888589322e-7,
-1.3539513523367761e-8,
1.073607022581973e-9,
-7.298439283548661e-11,
// [6.,6.5]: m=20 maxabs=1.2866769281971724e-16 maxrel=1.5438202865939579e-12
0.00006592514508747493,
-0.00003089907249452804,
7.2686609992904764e-6,
-1.143773031067129e-6,
1.353950538980647e-7,
-1.2857170643479264e-8,
1.0220417814090703e-9,
-6.963591186069818e-11,
// [6.,6.5]: m=21 maxabs=1.232060243758215e-16 maxrel=1.5756262412886194e-12
0.00006179814498899543,
-0.0000290746439321435,
6.862638192242254e-6,
-1.083163031895286e-6,
1.2857162859543928e-7,
-1.2239534541216696e-8,
9.751517811141314e-10,
-6.657824881266284e-11,
// [6.,6.5]: m=22 maxabs=1.1828645701816853e-16 maxrel=1.6063691798817547e-12
0.00005814928786422879,
-0.000027450552706685253,
6.4989781969677115e-6,
-1.0285755200462293e-6,
1.22395270775642e-7,
-1.1677905383740409e-8,
9.323343529220895e-10,
-6.377545007395116e-11,
// [6.,6.5]: m=23 maxabs=1.136921503122612e-16 maxrel=1.6341657370174834e-12
0.000054901105413314574,
-0.000025995912728106735,
6.171453125647318e-6,
-9.791645567403678e-7,
1.1677898223865256e-7,
-1.1165063245631172e-8,
8.930854209157751e-10,
-6.119708739057598e-11,
// [6.,6.5]: m=24 maxabs=1.094366567852556e-16 maxrel=1.6599524830839473e-12
0.00005199182545615959,
-0.000024685812445149756,
5.8749873456179315e-6,
-9.342341554824528e-7,
1.1165056343148402e-7,
-1.0694968422976539e-8,
8.569801688003037e-10,
-5.881751598952637e-11,
// [6.,6.5]: m=25 maxabs=1.0550642390999565e-16 maxrel=1.6842863246135037e-12
0.00004937162489024762,
-0.000023499949327183748,
5.605404937880927e-6,
-8.932067189727075e-7,
1.0694961771155923e-7,
-1.0262531471952076e-8,
8.236581828762247e-10,
-5.661472300001396e-11,
// [6.,6.5]: m=26 maxabs=1.0182691278712297e-16 maxrel=1.7066667558941283e-12
0.00004699989865431732,
-0.00002242161969823277,
5.359240318657367e-6,
-8.555990733249121e-7,
1.0262525045049185e-7,
-9.863434521723407e-9,
7.928117618542426e-10,
-5.456981810133205e-11,
// [6.,6.5]: m=27 maxabs=9.837101836232542e-17 maxrel=1.7271946160874042e-12
0.000044843239396416974,
-0.00002143696122319873,
5.133594444614688e-6,
-8.210040608648185e-7,
9.863428297973126e-8,
-9.493991271466864e-9,
7.641766959205339e-10,
-5.266659614438672e-11,
// [6.,6.5]: m=28 maxabs=9.515229316275908e-17 maxrel=1.7466352506184155e-12
0.0000428739224463504,
-0.000020534377728761525,
4.926024369701761e-6,
-7.890762517520142e-7,
9.493985255851986e-8,
-9.15103630109031e-9,
7.37524832686886e-10,
-5.089086170646635e-11,
// [6.,6.5]: m=29 maxabs=9.215040839768984e-17 maxrel=1.7651520570881444e-12
0.000041068755457477615,
-0.000019704097430730923,
4.7344575148755915e-6,
-7.595207435191221e-7,
9.151030483212715e-8,
-8.831836661611742e-9,
7.126582251775109e-10,
-4.923029068033382e-11,
// [6.,6.5]: m=30 maxabs=8.93450352763836e-17 maxrel=1.7828465392802195e-12
0.0000394081948614179,
-0.000018937830012944495,
4.5571244653369735e-6,
-7.320843009465001e-7,
8.831831031419338e-8,
-8.534020854792342e-9,
6.89404247308108e-10,
-4.767405933299333e-11,
// [6.,6.5]: m=31 maxabs=8.666841116306001e-17 maxrel=1.7987731825662752e-12
0.000037875660025846395,
-0.000018228497816218775,
4.39250580977585e-6,
-7.065482876868606e-7,
8.534015389239713e-8,
-8.255521242433862e-9,
6.676117792812418e-10,
-4.6212722504091545e-11,
// [6.,6.5]: m=32 maxabs=8.417474616634335e-17 maxrel=1.8144006644804237e-12
0.00003645699563239619,
-0.000017570023195317008,
4.239289730099791e-6,
-6.827229826115237e-7,
8.255515936901544e-8,
-7.994527175254815e-9,
6.471478801881168e-10,
-4.483783159181181e-11,
// [6.,6.5]: m=33 maxabs=8.179627765045328e-17 maxrel=1.8286460245210136e-12
0.000035140046390593595,
-0.000016957158877878678,
4.096337899549286e-6,
-6.604429757971338e-7,
7.994522001359923e-8,
-7.749446344412674e-9,
6.278952218703464e-10,
-4.3542078500218344e-11,
// [6.,6.5]: m=34 maxabs=7.957366319685799e-17 maxrel=1.842721242193419e-12
0.000033914317755718094,
-0.00001638535155687067,
3.96265785855098e-6,
-6.395634131853019e-7,
7.749441321420273e-8,
-7.51887309959307e-9,
6.097498079081899e-10,
-4.2318780750678984e-11,
// [6.,6.5]: m=35 maxabs=7.745269269693322e-17 maxrel=1.855696775447916e-12
0.00003277070311370314,
-0.00001585063139400644,
3.837380482776797e-6,
-6.19956913612485e-7,
7.518868215279749e-8,
-7.30156189799138e-9,
5.926191853516234e-10,
-4.116203650208196e-11,
// [6.,6.5]: m=36 maxabs=7.544691867783504e-17 maxrel=1.868148022191094e-12
0.000031701262787975774,
-0.000015349521891979568,
3.719741485243349e-6,
-6.015110223274019e-7,
7.301557137772086e-8,
-7.09640522742688e-9,
5.7642088206119e-10,
-4.006663043141856e-11,
// [6.,6.5]: m=37 maxabs=7.353601234882934e-17 maxrel=1.87982848323181e-12
0.00003069904378392299,
-0.000014878965902860108,
3.6090661374377083e-6,
-5.841260955539453e-7,
7.096400595350137e-8,
-6.9024151236421755e-9,
5.610810779632841e-10,
-3.902777905771265e-11,
// [6.,6.5]: m=38 maxabs=7.172674997349415e-17 maxrel=1.8911416995064774e-12
0.000029757931805684895,
-0.000014436264512601342,
3.5047565767141715e-6,
-5.677135336152386e-7,
6.902410603557156e-8,
-6.7187074544366526e-9,
5.465335282132878e-10,
-3.804125254361958e-11,
// [6.,6.5]: m=39 maxabs=7.000557902467341e-17 maxrel=1.901961194898317e-12
0.00002887252902516826,
-0.000014019026270624298,
3.406281204997727e-6,
-5.521942976046746e-7,
6.718703045486942e-8,
-6.5444887342973765e-9,
5.327186316901613e-10,
-3.710317538371887e-11,
// [6.,6.5]: m=40 maxabs=6.835217071163302e-17 maxrel=1.9119278861328723e-12
0.000028038052541214924,
-0.000013625124784629647,
3.3131657888638185e-6,
-5.374976580985618e-7,
6.544484419060501e-8,
-6.3790447674380706e-9,
5.19582557623614e-10,
-3.621012606036787e-11
},
{
// [6.5,7.]: m=0 maxabs=5.551115123125783e-16 maxrel=1.597449992617686e-15
0.34102752653081364,
-0.01258728321888945,
0.0006884520342631803,
-0.00004069012616535122,
2.4114574268878486e-6,
-1.3817736912053228e-7,
7.509342295414309e-9,
-3.8202083803995124e-10,
// [6.5,7.]: m=1 maxabs=4.510281037539698e-16 maxrel=1.6946383432936285e-14
0.025174566437779065,
-0.0027538081367608895,
0.00024414075697130693,
-0.00001929167094055694,
1.381773995222114e-6,
-9.000260321263611e-8,
5.347429997319764e-9,
-2.8975280498907557e-10,
// [6.5,7.]: m=2 maxabs=3.668940151690947e-16 maxrel=6.088238447957024e-14
0.005507616273521607,
-0.0009765630276598874,
0.00011575002566152883,
-0.000011054200966295066,
9.000257894754303e-7,
-6.40827683525825e-8,
4.057311359109799e-9,
-2.302796088467665e-10,
// [6.5,7.]: m=3 maxabs=3.1051550219984847e-16 maxrel=1.4100566949918524e-13
0.001953126055319614,
-0.0004630001024609812,
0.0000663252058122859,
-7.200213718382816e-6,
6.408274858750485e-7,
-4.861667803160322e-8,
3.2245543587267804e-9,
-1.8948502008647323e-10,
// [6.5,7.]: m=4 maxabs=2.669305748659312e-16 maxrel=2.494390597137067e-13
0.0009260002049218296,
-0.00026530082309281715,
0.000043201282323103015,
-5.1266261409297835e-6,
4.861666091986267e-7,
-3.863460827984924e-8,
2.6533386984462416e-9,
-1.601302146635995e-10,
// [6.5,7.]: m=5 maxabs=2.338624086051233e-16 maxrel=3.740568678311136e-13
0.0005306016461855218,
-0.00017280512915743396,
0.000030759756856473715,
-3.889338271941762e-6,
3.8634593739644953e-7,
-3.178824469941006e-8,
2.2422883538355397e-9,
-1.381780232172643e-10,
// [6.5,7.]: m=6 maxabs=2.082752373344654e-16 maxrel=5.038459538078965e-13
0.0003456102583146623,
-0.00012303902730750895,
0.000023336029641455433,
-3.0907722352814397e-6,
3.1788231625254104e-7,
-2.6861994247602147e-8,
1.934911034647329e-9,
-1.2124153303186433e-10,
// [6.5,7.]: m=7 maxabs=1.8724171518824662e-16 maxrel=6.289152521660465e-13
0.000246078054614924,
-0.00009334411846049968,
0.000018544633420742528,
-2.5430627424505982e-6,
2.686198210536684e-7,
-2.317849792513024e-8,
1.6977688247493143e-9,
-1.0782143286181342e-10,
// [6.5,7.]: m=8 maxabs=1.7149367863289466e-16 maxrel=7.525749994067991e-13
0.0001866882369209077,
-0.00007417853358788439,
0.000015258376462448673,
-2.1489623755627205e-6,
2.3178483657457032e-7,
-2.0336785686326918e-8,
1.510021824896584e-9,
-9.693155052494263e-11,
// [6.5,7.]: m=9 maxabs=1.5569143196891844e-16 maxrel=8.538413317548322e-13
0.00014835706717520247,
-0.00006103350576073996,
0.000012893774289679082,
-1.8542821699292688e-6,
2.0336746572373228e-7,
-1.808713218357938e-8,
1.358139765372855e-9,
-8.805292262683132e-11,
// [6.5,7.]: m=10 maxabs=1.4338573731120796e-16 maxrel=9.505111834082578e-13
0.00012206701152140905,
-0.00005157509708002205,
0.000011125693026369383,
-1.6269428734450834e-6,
1.8087123124862283e-7,
-1.626746025487718e-8,
1.2330308710183263e-9,
-8.057769275158555e-11,
// [6.5,7.]: m=11 maxabs=1.2262326570811055e-16 maxrel=9.577435068899168e-13
0.00010315019415999062,
-0.00004450277203280124,
9.761657245830958e-6,
-1.446972757460711e-6,
1.626745318664735e-7,
-1.476845977361366e-8,
1.1283277417915062e-9,
-7.440135512732385e-11,
// [6.5,7.]: m=12 maxabs=1.238158880978446e-16 maxrel=1.1167496358251762e-12
0.00008900554406589404,
-0.000039046628920681564,
8.681836505707032e-6,
-1.301398836252745e-6,
1.4768522838260054e-7,
-1.3514475673191108e-8,
1.0395989171782518e-9,
-6.880170378250274e-11,
// [6.5,7.]: m=13 maxabs=1.1586055465723222e-16 maxrel=1.1875148131399712e-12
0.00007809325784130591,
-0.00003472734596024006,
7.808393023008593e-6,
-1.1814843305754966e-6,
1.3514468353814684e-7,
-1.2451153361009672e-8,
9.634580303700711e-10,
-6.408944352311874e-11,
// [6.5,7.]: m=14 maxabs=1.0885389811754465e-16 maxrel=1.251381126261012e-12
0.00006945469192042622,
-0.00003123357203346879,
7.088905988613923e-6,
-1.0811598108749715e-6,
1.2451146489184918e-7,
-1.1539007937994959e-8,
8.974719587856583e-10,
-5.996878470260788e-11,
// [6.5,7.]: m=15 maxabs=1.0264684068006513e-16 maxrel=1.309291488204412e-12
0.00006246714406688686,
-0.000028355623899437845,
6.486958870121439e-6,
-9.960939198145509e-7,
1.1539001444914354e-7,
-1.0748537132974634e-8,
8.39770707390612e-10,
-5.633670531402109e-11,
// [6.5,7.]: m=16 maxabs=9.704964696460872e-17 maxrel=1.3611118729778242e-12
0.00005671124779882773,
-0.0000259478354286177,
5.976563523495773e-6,
-9.231221903073447e-7,
1.0748530988533802e-7,
-1.0057331284306086e-8,
7.88910506468458e-10,
-5.311243982439548e-11,
// [6.5,7.]: m=17 maxabs=9.20623169711754e-17 maxrel=1.408810324821692e-12
0.0000518956708571899,
-0.000023906254044927938,
5.538733146210489e-6,
-8.598844412699139e-7,
1.0057325465009779e-7,
-9.44808913577347e-9,
7.43760306371537e-10,
-5.0231765572477325e-11,
// [6.5,7.]: m=18 maxabs=8.754932542820448e-17 maxrel=1.452219399426312e-12
0.00004781250808981244,
-0.000022154932538315328,
5.1593066517881925e-6,
-8.045878982700433e-7,
9.448083580582478e-8,
-8.90725739162187e-9,
7.034224099382117e-10,
-4.7643381939372046e-11,
// [6.5,7.]: m=19 maxabs=8.344290969991564e-17 maxrel=1.4917652959313398e-12
0.00004430986507658923,
-0.00002063722656290652,
4.827527393582251e-6,
-7.558484562584334e-7,
8.907252122526225e-8,
-8.424079148140181e-9,
6.671757461663831e-10,
-4.530528398275792e-11,
// [6.5,7.]: m=20 maxabs=7.972274099557475e-17 maxrel=1.5284889571405832e-12
0.00004127445312577379,
-0.000019310109532157785,
4.535090741325483e-6,
-7.125818566562525e-7,
8.424074113962448e-8,
-7.989915174666689e-9,
6.344350569890861e-10,
-4.3183322963444173e-11,
// [6.5,7.]: m=21 maxabs=7.630072788866737e-17 maxrel=1.5619789624993717e-12
0.000038620219064277995,
-0.00001814036292501953,
4.2754911435428055e-6,
-6.739275404052395e-7,
7.989910364991448e-8,
-7.597752311262911e-9,
6.047204745569381e-10,
-4.124908035382602e-11,
// [6.5,7.]: m=22 maxabs=7.316331785203745e-17 maxrel=1.5930182352122652e-12
0.000036280725850003114,
-0.000017101964535620137,
4.043565245892775e-6,
-6.391943712591595e-7,
7.597747688918185e-8,
-7.241841414498871e-9,
5.776351927904811e-10,
-3.9478998617383245e-11,
// [6.5,7.]: m=23 maxabs=7.024952451348265e-17 maxrel=1.6212458842694809e-12
0.00003420392907120562,
-0.000016174260946603485,
3.835166230886584e-6,
-6.078212937769504e-7,
7.241836972071022e-8,
-6.917427291819778e-9,
5.528481355662978e-10,
-3.7853207484181396e-11,
// [6.5,7.]: m=24 maxabs=6.75796766637371e-17 maxrel=1.6479815811724606e-12
0.000032348521893173774,
-0.000015340664888043344,
3.6469277658569826e-6,
-5.793483778849535e-7,
6.917423030744822e-8,
-6.6205445177747405e-9,
5.300812395227958e-10,
-3.6354854042077676e-11,
// [6.5,7.]: m=25 maxabs=6.508601166702044e-17 maxrel=1.6724001423801434e-12
0.00003068132977605471,
-0.000014587711029276617,
3.4760902703852112e-6,
-5.533952084837007e-7,
6.620540416702793e-8,
-6.347861176752452e-9,
5.090991825867341e-10,
-3.49696376760705e-11,
// [6.5,7.]: m=26 maxabs=6.278208205048874e-17 maxrel=1.6955268655007971e-12
0.000029175422058522423,
-0.00001390436104864406,
3.3203712538670253e-6,
-5.296445491878982e-7,
6.347857220510218e-8,
-6.0965581226478955e-9,
4.897015734456921e-10,
-3.368530625259484e-11,
// [6.5,7.]: m=27 maxabs=6.064078275982987e-17 maxrel=1.7173140467185196e-12
0.000027808722097258305,
-0.000013281484983738057,
3.177867297996366e-6,
-5.078298468352131e-7,
6.096554295750657e-8,
-5.864234622070293e-9,
4.71716752123506e-10,
-3.2491329469779594e-11,
// [6.5,7.]: m=28 maxabs=5.862823247715365e-17 maxrel=1.7373766110521719e-12
0.000026562969967447295,
-0.00001271146916134206,
3.046979083781892e-6,
-4.877255693906981e-7,
5.8642309277361004e-8,
-5.648834045678982e-9,
4.5499681549223906e-10,
-3.137850577046928e-11,
// [6.5,7.]: m=29 maxabs=5.677153625677223e-17 maxrel=1.7570432935067076e-12
0.00002542293832265617,
-0.000012187916305498974,
2.926353419030431e-6,
-4.691396593471048e-7,
5.648830463976666e-8,
-5.448584647000326e-9,
4.394136919388353e-10,
-3.033891251429716e-11,
// [6.5,7.]: m=30 maxabs=5.5002931462905247e-17 maxrel=1.7747281275234984e-12
0.000024375832610970796,
-0.000011705413647444175,
2.8148379586882735e-6,
-4.5190758421410356e-7,
5.4485811730855045e-8,
-5.2619522020213365e-9,
4.2485595376191033e-10,
-2.936560147368794e-11,
// [6.5,7.]: m=31 maxabs=5.3335970622708784e-17 maxrel=1.7912219410347635e-12
0.000023410827294862066,
-0.00001125935180696668,
2.711445507809317e-6,
-4.3588760528729564e-7,
5.26194883515005e-8,
-5.087601714351737e-9,
4.1122616937108417e-10,
-2.845243827720463e-11,
// [6.5,7.]: m=32 maxabs=5.177742999976087e-17 maxrel=1.807152732430538e-12
0.00002251870361390779,
-0.000010845782004289263,
2.615325634177745e-6,
-4.209569847155396e-7,
5.087598442542792e-8,
-4.924366218962452e-9,
3.9843883404390825e-10,
-2.7594077495585114e-11,
// [6.5,7.]: m=33 maxabs=5.031714519869446e-17 maxrel=1.82257254205854e-12
0.000021691564008553744,
-0.000010461302510552563,
2.52574191067214e-6,
-4.070089217285752e-7,
4.924363047475464e-8,
-4.771221339492523e-9,
3.8641857404433596e-10,
-2.6785702429235367e-11,
// [6.5,7.]: m=34 maxabs=4.8928011165197405e-17 maxrel=1.836845379934144e-12
0.000020922605021080975,
-0.000010102967617274758,
2.44205353268855e-6,
-3.939500603369669e-7,
4.771218250126456e-8,
-4.627264183007841e-9,
3.7509870714928065e-10,
-2.602313030051942e-11,
// [6.5,7.]: m=35 maxabs=4.759986350390266e-17 maxrel=1.849851748746395e-12
0.00002020593523452604,
-9.768214106044155e-6,
2.3637003642761666e-6,
-3.816984484021609e-7,
4.6272611770862515e-8,
-4.4916959824082445e-9,
3.6442002740084455e-10,
-2.5302585259870462e-11,
// [6.5,7.]: m=36 maxabs=4.633947847838826e-17 maxrel=1.8621002035404078e-12
0.00001953642821206549,
-9.454801433060615e-6,
2.290190692605978e-6,
-3.701818559188673e-7,
4.491693057764134e-8,
-4.363807546672868e-9,
3.5432979747490927e-10,
-2.462070945866346e-11,
// [6.5,7.]: m=37 maxabs=4.5173961142966346e-17 maxrel=1.874979739432379e-12
0.000018909602866098983,
-9.160762747010765e-6,
2.2210911376466027e-6,
-3.5933638113269024e-7,
4.363804703643614e-8,
-4.242967118763259e-9,
3.447808760003619e-10,
-2.3974438479398074e-11,
// [6.5,7.]: m=38 maxabs=4.403216073006755e-17 maxrel=1.8858153568401086e-12
0.00001832152549399985,
-8.884364527772837e-6,
2.156018288879031e-6,
-3.491052888373514e-7,
4.2429643414921636e-8,
-4.128610080966079e-9,
3.3573101858401003e-10,
-2.3361112064424955e-11,
// [6.5,7.]: m=39 maxabs=4.296489921652713e-17 maxrel=1.89694150649734e-12
0.00001776872905552449,
-8.62407313327124e-6,
2.0946317350570454e-6,
-3.394380371037994e-7,
4.128607371633112e-8,
-4.020230345561609e-9,
3.2714224112040577e-10,
-2.2778269267802095e-11,
// [6.5,7.]: m=40 maxabs=4.194507154803295e-17 maxrel=1.9074184103401287e-12
0.000017248146266521818,
-8.37852691852473e-6,
2.0366282246055057e-6,
-3.3028945785343293e-7,
4.0202277030811105e-8,
-3.917372981155657e-9,
3.1898030767148637e-10,
-2.2223676137476407e-11
},
{
// [7.,7.5]: m=0 maxabs=3.3306690738754696e-16 maxrel=9.945233054831201e-16
0.32909028563741366,
-0.011323452112019636,
0.0005795736059406165,
-0.00003228846242390565,
1.8208950316577646e-6,
-1.0026654332354007e-7,
5.2819721349784174e-9,
-2.621489307694311e-10,
// [7.,7.5]: m=1 maxabs=2.949029909160572e-16 maxrel=1.2361603809030116e-14
0.02264690422403918,
-0.0023182944235611677,
0.00019373077457871484,
-0.000014567168084894544,
1.0026648802118502e-6,
-6.330968146830864e-8,
3.6719381867353845e-9,
-1.9527941004223735e-10,
// [7.,7.5]: m=2 maxabs=2.419939248987646e-16 maxrel=4.794859750034221e-14
0.004636588847122169,
-0.0007749230981644233,
0.00008740300852575095,
-8.02132503537155e-6,
6.330965959163419e-7,
-4.400583255170606e-8,
2.7346147351288533e-9,
-1.5296367433153158e-10,
// [7.,7.5]: m=3 maxabs=2.0144476364780672e-16 maxrel=1.1594971862839323e-13
0.0015498461963287492,
-0.0003496120339813419,
0.000048127950222187104,
-5.064777629333603e-6,
4.400581929747752e-7,
-3.27687128684096e-8,
2.141917037573847e-9,
-1.2442383233422241e-10,
// [7.,7.5]: m=4 maxabs=1.723881454251952e-16 maxrel=2.145362600196647e-13
0.0006992240679625946,
-0.00019251180078693974,
0.000030388665784460513,
-3.5204696147353255e-6,
3.276870164273133e-7,
-2.5663931560945358e-8,
1.742292037274655e-9,
-1.0418076092406578e-10,
// [7.,7.5]: m=5 maxabs=1.5016200088924236e-16 maxrel=3.326392085086719e-13
0.0003850236015738055,
-0.00012155466305068855,
0.000021122817695508972,
-2.6214996172003335e-6,
2.5663922107895584e-7,
-2.0874043253217078e-8,
1.4588330309426998e-9,
-8.922578344154124e-11,
// [7.,7.5]: m=6 maxabs=1.36501053515925e-16 maxrel=4.714126587691724e-13
0.0002431093261011823,
-0.00008449127070608004,
0.00001572899771058441,
-2.053116805006232e-6,
2.087403345234069e-7,
-1.7476857326349154e-8,
1.2494720162466253e-9,
-7.769157064633346e-11,
// [7.,7.5]: m=7 maxabs=1.1907250359322052e-16 maxrel=5.844325739520678e-13
0.00016898254141203603,
-0.00006291599077030968,
0.000012318700854260338,
-1.669925488084089e-6,
1.7476810820353314e-7,
-1.4967296381359213e-8,
1.0895208499334521e-9,
-6.884441185223648e-11,
// [7.,7.5]: m=8 maxabs=1.0771548583643487e-16 maxrel=7.032927478574594e-13
0.00012583198154058774,
-0.00004927480335682515,
0.0000100195529335912,
-1.3981472738721776e-6,
1.4967289598774895e-7,
-1.3051131255013747e-8,
9.640388662085298e-10,
-6.165032221306524e-11,
// [7.,7.5]: m=9 maxabs=9.82287168271867e-17 maxrel=8.128546253858416e-13
0.00009854960671360192,
-0.000040078211679909175,
8.388883647884841e-6,
-1.197385346136301e-6,
1.3051125053097788e-7,
-1.1547555278000964e-8,
8.633028981053879e-10,
-5.576304192880846e-11,
// [7.,7.5]: m=10 maxabs=9.027338338657431e-17 maxrel=9.1306670748376e-13
0.00008015642335977368,
-0.00003355553454186632,
7.184312081096618e-6,
-1.0440919911756362e-6,
1.1547549576059805e-7,
-1.0340560209493828e-8,
7.808650264209877e-10,
-5.0865643239051636e-11,
// [7.,7.5]: m=11 maxabs=1.0411051361292056e-16 maxrel=1.2518086468155773e-12
0.00006711106908368098,
-0.000028737248278593786,
6.264551952040525e-6,
-9.238057978919467e-7,
1.0340553523797142e-7,
-9.352793568960987e-9,
7.123341512619229e-10,
-4.690220813701348e-11,
// [7.,7.5]: m=12 maxabs=7.757466544133784e-17 maxrel=1.0849779949369096e-12
0.00005747449655745096,
-0.000025058207761898302,
5.542834753774501e-6,
-8.272460810686672e-7,
9.352849984174352e-8,
-8.531258615640047e-9,
6.544337348750997e-10,
-4.3205640338229844e-11,
// [7.,7.5]: m=13 maxabs=7.249246775781204e-17 maxrel=1.1590992791327284e-12
0.000050116415523760886,
-0.000022171338975877714,
4.963476489837327e-6,
-7.482295675133256e-7,
8.531254050986716e-8,
-7.838144738695779e-9,
6.050249937794616e-10,
-4.01599138468896e-11,
// [7.,7.5]: m=14 maxabs=6.794559489695096e-17 maxrel=1.2246328119258672e-12
0.000044342677951721864,
-0.000019853905922720844,
4.489377408300656e-6,
-6.825017891788991e-7,
7.838140441850253e-8,
-7.246235080876537e-9,
5.623763770670997e-10,
-3.750614490090445e-11,
// [7.,7.5]: m=15 maxabs=6.398825696737886e-17 maxrel=1.2850738111253612e-12
0.000039707811845410144,
-0.00001795750959885184,
4.095010738103254e-6,
-6.270526093642837e-7,
7.246231039805718e-8,
-6.735326041756792e-9,
5.252153569967619e-10,
-3.5174507965469905e-11,
// [7.,7.5]: m=16 maxabs=6.041716606175473e-17 maxrel=1.3389588614353153e-12
0.00003591501919767392,
-0.00001638004292007727,
3.762315659043882e-6,
-5.79699776582747e-7,
6.735322230647046e-8,
-6.290167760452873e-9,
4.925650792085976e-10,
-3.311066291815446e-11,
// [7.,7.5]: m=17 maxabs=5.723232218007857e-17 maxrel=1.3882665902590393e-12
0.0000327600858401265,
-0.000015049262605636297,
3.47819866219038e-6,
-5.38827000006098e-7,
6.290164167781491e-8,
-5.8990540880636476e-9,
4.636642698682064e-10,
-3.12715695030455e-11,
// [7.,7.5]: m=18 maxabs=5.436596268657001e-17 maxrel=1.4333261191767883e-12
0.000030098525211245946,
-0.000013912794619832897,
3.232962002602851e-6,
-5.032142905658239e-7,
5.8990506634490606e-8,
-5.55286264331731e-9,
4.3791160417043716e-10,
-2.9622995934407525e-11,
// [7.,7.5]: m=19 maxabs=5.179098252691694e-17 maxrel=1.475149734735838e-12
0.00002782558923964028,
-0.00001293184798293296,
3.01928574583915e-6,
-4.7192515219543036e-7,
5.552859384813114e-8,
-5.244387794143055e-9,
4.148262080186071e-10,
-2.8137071791830925e-11,
// [7.,7.5]: m=20 maxabs=4.940573774744883e-17 maxrel=1.512306815494009e-12
0.000025863695965841425,
-0.000012077142957193316,
2.8315509155244164e-6,
-4.44229797316909e-7,
5.2443846589456766e-8,
-4.967867780264595e-9,
3.940193211593331e-10,
-2.6791280388822704e-11,
// [7.,7.5]: m=21 maxabs=4.726443845678996e-17 maxrel=1.54765268940855e-12
0.0000241542859143633,
-0.000011326203637129355,
2.665378786139537e-6,
-4.1955177143253593e-7,
4.9678647965666053e-8,
-4.718644254547327e-9,
3.7517339436722424e-10,
-2.5566803378348252e-11,
// [7.,7.5]: m=22 maxabs=4.527560509663686e-17 maxrel=1.579458713210853e-12
0.000022652407274236308,
-0.00001066151512068277,
2.517310630739033e-6,
-3.974301387347273e-7,
4.7186413963101745e-8,
-4.4929126876462416e-9,
3.580267119930171e-10,
-2.444806676505354e-11,
// [7.,7.5]: m=23 maxabs=4.345956645772364e-17 maxrel=1.6093792698351256e-12
0.000021323030241343117,
-0.000010069242500079099,
2.3845808345044506e-6,
-3.774922266933692e-7,
4.49290990858878e-8,
-4.287537010367281e-9,
3.4236165333447895e-10,
-2.342223985777861e-11,
// [7.,7.5]: m=24 maxabs=4.1758724299637007e-17 maxrel=1.6362093115942723e-12
0.0000201384850001375,
-9.538323316066142e-6,
2.2649533621451653e-6,
-3.59433670746027e-7,
4.287534365248325e-8,
-4.099910508455741e-9,
3.279959845141386e-10,
-2.2478186114875886e-11,
// [7.,7.5]: m=25 maxabs=4.020695994026713e-17 maxrel=1.6620442268634671e-12
0.000019076646632112454,
-9.059813427480362e-6,
2.15660202638078e-6,
-3.430035932274473e-7,
4.0999079684858217e-8,
-3.927849345334026e-9,
3.147758936424025e-10,
-2.160660155511805e-11,
// [7.,7.5]: m=26 maxabs=3.8760227666356784e-17 maxrel=1.6858933598599375e-12
0.0000181196268549416,
-8.626408085210775e-6,
2.058021561200299e-6,
-3.2799344996560113e-7,
3.927846897939376e-8,
-3.769510884094769e-9,
3.0257073881565527e-10,
-2.0799522014866007e-11,
// [7.,7.5]: m=27 maxabs=3.7415139346116955e-17 maxrel=1.7082508967892278e-12
0.00001725281617040311,
-8.232086225220342e-6,
1.9679607015639906e-6,
-3.14228535054726e-7,
3.76950852317666e-8,
-3.6233300330163642e-9,
2.9126887225916906e-10,
-2.005010999527076e-11,
// [7.,7.5]: m=28 maxabs=3.614797805702452e-17 maxrel=1.7286163530867881e-12
0.000016464172450422927,
-7.871842787356448e-6,
1.8853712120337788e-6,
-3.015614378208929e-7,
3.623327758674279e-8,
-3.4879692645190576e-9,
2.807743267699691e-10,
-1.935240552263924e-11,
// [7.,7.5]: m=29 maxabs=3.497229632623555e-17 maxrel=1.7481521724818021e-12
0.000015743685574695682,
-7.541484829871925e-6,
1.8093686285775296e-6,
-2.8986695121547893e-7,
3.4879670612942256e-8,
-3.362278927048212e-9,
2.710041872936933e-10,
-1.8701306770907194e-11,
// [7.,7.5]: m=30 maxabs=3.3877929758382996e-17 maxrel=1.766905540328746e-12
0.000015082969659727206,
-7.237474496641692e-6,
1.7392017088907575e-6,
-2.7903807163591626e-7,
3.362276797168186e-8,
-3.245265628043636e-9,
2.6188643932702904e-10,
-1.8092301544477915e-11,
// [7.,7.5]: m=31 maxabs=3.2824220771998647e-17 maxrel=1.7831824287227529e-12
0.000014474948993267303,
-6.956806818451703e-6,
1.6742284313622583e-6,
-2.689828282150699e-7,
3.2452635650766327e-8,
-3.13606669193667e-9,
2.533582484701287e-10,
-1.752144790069514e-11,
// [7.,7.5]: m=32 maxabs=3.1858603212128744e-17 maxrel=1.7999153633395096e-12
0.000013913613636887745,
-6.6969137088610915e-6,
1.6138969707966166e-6,
-2.596217487076242e-7,
3.136064683122934e-8,
-3.033929441075362e-9,
2.4536456040027597e-10,
-1.698532432191621e-11,
// [7.,7.5]: m=33 maxabs=3.094041949730508e-17 maxrel=1.815282882935781e-12
0.00001339382741770695,
-6.455587867091093e-6,
1.557730493707819e-6,
-2.50885818449098e-7,
3.0339274917869677e-8,
-2.9381943431583494e-9,
2.3785692022684237e-10,
-1.6480847013113694e-11,
// [7.,7.5]: m=34 maxabs=3.0066281495738645e-17 maxrel=1.829379591996417e-12
0.00001291117573416741,
-6.230921959201214e-6,
1.5053149121156057e-6,
-2.427148245458609e-7,
2.938192447114901e-8,
-2.848281070834246e-9,
2.3079255690313095e-10,
-1.6005322498020343e-11,
// [7.,7.5]: m=35 maxabs=2.924635360279648e-17 maxrel=1.8431261447051105e-12
0.000012461843918388042,
-6.0212596332704244e-6,
1.4562889486578607e-6,
-2.3505600344490604e-7,
2.8482792269327818e-8,
-2.7636770302055977e-9,
2.2413352092642075e-10,
-1.5556336890402835e-11,
// [7.,7.5]: m=36 maxabs=2.847047142311154e-17 maxrel=1.8562075187939357e-12
0.000012042519266526875,
-5.825155779853797e-6,
1.410336022012982e-6,
-2.2786292924942342e-7,
2.763675238329334e-8,
-2.683927807535008e-9,
2.1784606425709932e-10,
-1.513172821188017e-11,
// [7.,7.5]: m=37 maxabs=2.773524682489481e-17 maxrel=1.868677783859819e-12
0.00001165031155969397,
-5.641344073667337e-6,
1.3671775768052914e-6,
-2.2109459444472959e-7,
2.6839260617755283e-8,
-2.608629162779664e-9,
2.119000769862676e-10,
-1.47295850078146e-11,
// [7.,7.5]: m=38 maxabs=2.7037291676357267e-17 maxrel=1.8805623545207666e-12
0.000011282688147321398,
-5.468710293208949e-6,
1.326567567943169e-6,
-2.1471464542355108e-7,
2.6086274627822906e-8,
-2.53742033742394e-9,
2.0626859390085354e-10,
-1.434816606898507e-11,
// [7.,7.5]: m=39 maxabs=2.636644158213186e-17 maxrel=1.891371750399804e-12
0.000010937420586404939,
-5.3062702581140875e-6,
1.2882878737855476e-6,
-2.086907433568212e-7,
2.537418678504329e-8,
-2.4699783729711523e-9,
2.0092740624101534e-10,
-1.3985912888568908e-11,
// [7.,7.5]: m=40 maxabs=2.5741331267058187e-17 maxrel=1.9026571299697292e-12
0.000010612540516215519,
-5.153151481820047e-6,
1.2521444613576536e-6,
-2.0299402715723773e-7,
2.4699767500773053e-8,
-2.40601330194307e-9,
1.9585472051725368e-10,
-1.3641437205160137e-11
},
{
// [7.5,8.]: m=0 maxabs=2.220446049250313e-16 maxrel=6.862345985369669e-16
0.31831584432385973,
-0.010254358122041259,
0.0004927048886768897,
-0.000025910555121330713,
1.3903225824211272e-6,
-7.349142312794843e-8,
3.747380414035669e-9,
-1.8150865414174106e-10,
// [7.5,8.]: m=1 maxabs=1.942890293094024e-16 maxrel=9.022251034019006e-15
0.020508716244082743,
-0.0019708195545700366,
0.0001554633307114248,
-0.000011122585993935794,
7.34914590262015e-7,
-4.491829518968382e-8,
2.5395635148457737e-9,
-1.3241242273033808e-10,
// [7.5,8.]: m=2 maxabs=1.5785983631388945e-16 maxrel=3.696939878494884e-14
0.0039416391091399924,
-0.0006218533227459124,
0.00006673551597059552,
-5.879320711281187e-6,
4.4918286470903907e-7,
-3.0436471918845966e-8,
1.8540398443338141e-9,
-1.0210357860166756e-10,
// [7.5,8.]: m=3 maxabs=1.3097162243624894e-16 maxrel=9.44643878329686e-14
0.0012437066454918208,
-0.00026694206380216374,
0.00003527592427357339,
-3.593466122491069e-6,
3.04364640939237e-7,
-2.221771584267003e-8,
1.4296991514745389e-9,
-8.203067509808804e-11,
// [7.5,8.]: m=4 maxabs=1.3032110113275763e-16 maxrel=2.1359038485870588e-13
0.0005338841276043796,
-0.00014110369702782582,
0.000021560796739899452,
-2.4349197847621462e-6,
2.2217709365039542e-7,
-1.7130884036917182e-8,
1.148629560327401e-9,
-6.800931794423066e-11,
// [7.5,8.]: m=5 maxabs=9.660241356845845e-17 maxrel=2.934328707698986e-13
0.00028220739405563207,
-0.00008624318690440888,
0.00001460951871334191,
-1.7774189575104432e-6,
1.7130878257016077e-7,
-1.3762217087986312e-8,
9.522852831972138e-10,
-5.777674347241916e-11,
// [7.5,8.]: m=6 maxabs=7.665309359472516e-17 maxrel=3.747367964788636e-13
0.00017248637380877353,
-0.000058438074804511366,
0.000010664513749423469,
-1.3704722154569662e-6,
1.376221112863547e-7,
-1.140864835180038e-8,
8.090625588655964e-10,
-5.0072482299695445e-11,
// [7.5,8.]: m=7 maxabs=7.586704701967317e-17 maxrel=5.403406747826914e-13
0.00011687614960892376,
-0.00004265805495350862,
8.222833298646491e-6,
-1.1009786559589098e-6,
1.1408649251159856e-7,
-9.6920410163154e-9,
7.008430562327361e-10,
-4.404122145263139e-11,
// [7.5,8.]: m=8 maxabs=6.833184192089892e-17 maxrel=6.599963845256289e-13
0.00008531610990701348,
-0.00003289133315624587,
6.60587193892217e-6,
-9.126934734805401e-7,
9.692036828243547e-8,
-8.39539497643855e-9,
6.167098114835276e-10,
-3.926192602234564e-11,
// [7.5,8.]: m=9 maxabs=6.211123195626334e-17 maxrel=7.718954806799161e-13
0.00006578266631245138,
-0.000026423487721348867,
5.476160844312111e-6,
-7.753643197450927e-7,
8.395391604818038e-8,
-7.387309251993166e-9,
5.497122191432776e-10,
-3.5367342042320544e-11,
// [7.5,8.]: m=10 maxabs=5.687995647402078e-17 maxrel=8.743884663406151e-13
0.00005284697544266962,
-0.00002190464334584962,
4.652185921171342e-6,
-6.716325843226906e-7,
7.387305649831987e-8,
-6.5844896631469905e-9,
4.952581097927104e-10,
-3.2151912705053637e-11,
// [7.5,8.]: m=11 maxabs=5.248216141187645e-17 maxrel=9.683182717523947e-13
0.000043809286691673514,
-0.00001860874365592134,
4.029795508409369e-6,
-5.909856025338485e-7,
6.584486363898083e-8,
-5.932052172739745e-9,
4.502323757046955e-10,
-2.945348686375188e-11,
// [7.5,8.]: m=12 maxabs=4.864679622670898e-17 maxrel=1.0522029060792203e-12
0.00003721748731181863,
-0.00001611918200711482,
3.5459136175107193e-6,
-5.26759970033683e-7,
5.932049098183646e-8,
-5.392603614120106e-9,
4.1244716673133467e-10,
-2.7159807735692813e-11,
// [7.5,8.]: m=13 maxabs=4.535353212778426e-17 maxrel=1.1286694852726665e-12
0.00003223836401420728,
-0.000014183654445444837,
3.1605598223481327e-6,
-4.74564911777329e-7,
5.392600754152818e-8,
-4.939920384704751e-9,
3.803288006780225e-10,
-2.5188177571639625e-11,
// [7.5,8.]: m=14 maxabs=4.246006757996357e-17 maxrel=1.1974939692948481e-12
0.000028367308890868837,
-0.000012642239266465924,
2.8473894726683746e-6,
-4.3140897739726874e-7,
4.93991771186036e-8,
-4.555141831473029e-9,
3.527200267122393e-10,
-2.3476593821300897e-11,
// [7.5,8.]: m=15 maxabs=3.99054162110446e-17 maxrel=1.2596901879172538e-12
0.000025284478532912186,
-0.000011389557869210825,
2.5884538662732346e-6,
-3.951942754557637e-7,
4.555139311269916e-8,
-4.224398642345435e-9,
3.2875297937532175e-10,
-2.1977830682909866e-11,
// [7.5,8.]: m=16 maxabs=3.763536791240307e-17 maxrel=1.3160538076175848e-12
0.000022779115738403233,
-0.000010353815444921648,
2.371165654507323e-6,
-3.6441195174806255e-7,
4.224396277145238e-8,
-3.937290056122715e-9,
3.077653389432364e-10,
-2.0655140060425888e-11,
// [7.5,8.]: m=17 maxabs=3.5609265102570786e-17 maxrel=1.3674095283062282e-12
0.000020707630889825814,
-9.484662599005861e-6,
2.186471712169376e-6,
-3.379524631024972e-7,
3.937287813675692e-8,
-3.685879157256139e-9,
2.8924373935867704e-10,
-1.9479740789665547e-11,
// [7.5,8.]: m=18 maxabs=3.3793226463657566e-17 maxrel=1.4144759703922572e-12
0.000018969325197994988,
-8.745886830680868e-6,
2.0277147802184196e-6,
-3.1498374496109886e-7,
3.685877021826701e-8,
-3.464014128305831e-9,
2.7278465746082657e-10,
-1.8428706487848527e-11,
// [7.5,8.]: m=19 maxabs=3.214320628240619e-17 maxrel=1.457159647722973e-12
0.00001749177366134593,
-8.110859103799985e-6,
1.8899024712876641e-6,
-2.948708446915184e-7,
3.4640120985920486e-8,
-3.266859587838483e-9,
2.5806686783058105e-10,
-1.748354268946465e-11,
// [7.5,8.]: m=20 maxabs=3.0645652031660586e-17 maxrel=1.4963250185818821e-12
0.00001622171820758487,
-7.559609868913032e-6,
1.7692250696065337e-6,
-2.7712161744175264e-7,
3.266857644856435e-8,
-3.090566523492475e-9,
2.4483175314684973e-10,
-1.6629270566063746e-11,
// [7.5,8.]: m=21 maxabs=2.927345865710862e-17 maxrel=1.5319962953438692e-12
0.000015119219737811673,
-7.076900262943208e-6,
1.6627297060334571e-6,
-2.613492308836623e-7,
3.0905646786610625e-8,
-2.932035917116662e-9,
2.3286884785928246e-10,
-1.5853477427427635e-11,
// [7.5,8.]: m=22 maxabs=2.8019849895172255e-17 maxrel=1.564995165016503e-12
0.000014153800525872643,
-6.650918809342449e-6,
1.568095386628364e-6,
-2.4724576594260546e-7,
2.9320341471179722e-8,
-2.7887463738811865e-9,
2.2200534179707076e-10,
-1.514605650906333e-11,
// [7.5,8.]: m=23 maxabs=2.687466135048444e-17 maxrel=1.5958780564105176e-12
0.000013301837618671857,
-6.2723815323526755e-6,
1.4834745969043885e-6,
-2.345632981646175e-7,
2.788744712137128e-8,
-2.6586270531054216e-9,
2.1209798520700093e-10,
-1.4498296228429214e-11,
// [7.5,8.]: m=24 maxabs=2.5814176100522057e-17 maxrel=1.6242288495013888e-12
0.000012544763064692908,
-5.9338983740426425e-6,
1.4073797901726484e-6,
-2.2310012005206523e-7,
2.6586254639405828e-8,
-2.5399621560808564e-9,
2.0302720628986934e-10,
-1.3903013059406605e-11,
// [7.5,8.]: m=25 maxabs=2.4833311947601577e-17 maxrel=1.6505519206862708e-12
0.000011867796748073052,
-5.629519147648507e-6,
1.3386007214874083e-6,
-2.1269055878151412e-7,
2.5399605888238694e-8,
-2.4313185679627057e-9,
1.9469235124936062e-10,
-1.3354274710484004e-11,
// [7.5,8.]: m=26 maxabs=2.3920210430461442e-17 maxrel=1.67481844753297e-12
0.000011259038295285227,
-5.354402873403295e-6,
1.2761433538211292e-6,
-2.03197348945885e-7,
2.4313170582284265e-8,
-2.3314906176305466e-9,
1.8700816934704226e-10,
-1.2846818798944026e-11,
// [7.5,8.]: m=27 maxabs=2.3078259680890667e-17 maxrel=1.6979631487524323e-12
0.000010708805746795267,
-5.104573403197815e-6,
1.219184094764235e-6,
-1.9450584811310707e-7,
2.331489164631764e-8,
-2.2394569265306703e-9,
1.79901979285053e-10,
-1.2376177420680488e-11,
// [7.5,8.]: m=28 maxabs=2.2290519039944168e-17 maxrel=1.7194090141974545e-12
0.000010209146806384666,
-4.876736367397576e-6,
1.1670350897321117e-6,
-1.8651959953179453e-7,
2.239455521517219e-8,
-2.154346757178075e-9,
1.7331145290144068e-10,
-1.1938529050526974e-11,
// [7.5,8.]: m=29 maxabs=2.155021224404391e-17 maxrel=1.7391642732569461e-12
9.753472734784572e-6,
-4.668140347667569e-6,
1.119117598207832e-6,
-1.7915689214262523e-7,
2.154345400141305e-8,
-2.075413451324685e-9,
1.6718285354533213e-10,
-1.1530533833276475e-11,
// [7.5,8.]: m=30 maxabs=2.0857339293189892e-17 maxrel=1.7577164388620456e-12
9.336280695324899e-6,
-4.476470381942901e-6,
1.0749413538413344e-6,
-1.7234806754066304e-7,
2.0754121356468238e-8,
-2.0020132118266917e-9,
1.6146960560020035e-10,
-1.114931559026336e-11,
// [7.5,8.]: m=31 maxabs=2.0213594253276623e-17 maxrel=1.7757058072252037e-12
8.952940763875853e-6,
-4.299765404825648e-6,
1.0340884061992838e-6,
-1.6603339243445922e-7,
2.0020119385285206e-8,
-1.933588115646847e-9,
1.5613115259387448e-10,
-1.079231787201919e-11,
// [7.5,8.]: m=32 maxabs=1.959864833357e-17 maxrel=1.7917867702877796e-12
8.599530809641645e-6,
-4.136353614584763e-6,
9.96200355534015e-7,
-1.6016136357469684e-7,
1.933586879085959e-8,
-1.86965231852578e-9,
1.5113202569312992e-10,
-1.045734132921784e-11,
// [7.5,8.]: m=33 maxabs=1.9026054061226094e-17 maxrel=1.8075442406783575e-12
8.272707229160206e-6,
-3.984801412230955e-6,
9.609681823447606e-7,
-1.5468734652247215e-7,
1.8696511225430773e-8,
-1.8097808774361193e-9,
1.464410589138406e-10,
-1.0142396997113155e-11,
// [7.5,8.]: m=34 maxabs=1.848734110677236e-17 maxrel=1.8225881770600686e-12
7.96960282445283e-6,
-3.84387271976375e-6,
9.281240800069338e-7,
-1.495724744102045e-7,
1.8097797145011835e-8,
-1.7536005193534966e-9,
1.4203077561462977e-10,
-9.84575750757486e-12,
// [7.5,8.]: m=35 maxabs=1.797912133841978e-17 maxrel=1.836928208176627e-12
7.68774543951865e-6,
-3.712496310685797e-6,
8.974348473107227e-7,
-1.4478275083324007e-7,
1.7535993866483683e-8,
-1.70078207588934e-9,
1.37876853192684e-10,
-9.565882347198315e-12,
// [7.5,8.]: m=36 maxabs=1.7496312558484828e-17 maxrel=1.8503476732920267e-12
7.424992621362952e-6,
-3.589739380159183e-6,
8.686965058283192e-7,
-1.4028831427540884e-7,
1.7007809713724577e-8,
-1.6510341803176463e-9,
1.339576850132295e-10,
-9.301406784431878e-12,
// [7.5,8.]: m=37 maxabs=1.7040608832862014e-17 maxrel=1.8632991308158974e-12
7.179478760310001e-6,
-3.474786014473978e-6,
8.41729886456742e-7,
-1.3606283127452427e-7,
1.6510331078255882e-8,
-1.6040980374593084e-9,
1.302540136206265e-10,
-9.051080968777443e-12,
// [7.5,8.]: m=38 maxabs=1.659845763439527e-17 maxrel=1.874538585118352e-12
6.949572028939791e-6,
-3.3669195372197186e-6,
8.163769884318219e-7,
-1.3208299291465945e-7,
1.6040969908263005e-8,
-1.5597429890831329e-9,
1.2674863073272618e-10,
-8.813816990499116e-12,
// [7.5,8.]: m=39 maxabs=1.618679962202968e-17 maxrel=1.8861814584207996e-12
6.733839074431468e-6,
-3.2655079453399023e-6,
7.924979582533717e-7,
-1.2832809476109842e-7,
1.5597419684930024e-8,
-1.517762826639255e-9,
1.2342609349850972e-10,
-8.588619675169283e-12,
// [7.5,8.]: m=40 maxabs=1.5792082268609176e-17 maxrel=1.896924457335418e-12
6.53101589067203e-6,
-3.1699918248351285e-6,
7.699685693131605e-7,
-1.2477968461338844e-7,
1.5177618312810005e-8,
-1.4779726432760523e-9,
1.2027252345624458e-10,
-8.374593504213992e-12
},
{
// [8.,8.5]: m=0 maxabs=1.1102230246251565e-16 maxrel=3.54354369844392e-16
0.3085296009370361,
-0.009341464920598007,
0.00042263281037406943,
-0.00002101521951538335,
1.0732090188495387e-6,
-5.4415289342891514e-8,
2.6822983351906977e-9,
-1.263575988103175e-10,
// [8.,8.5]: m=1 maxabs=1.3183898417423734e-16 maxrel=6.739949555921986e-15
0.01868292984119599,
-0.0016905312414026274,
0.00012609131711320846,
-8.58567575824963e-6,
5.441526585068495e-7,
-3.215345396034074e-8,
1.7696122909347558e-9,
-9.031779014030725e-11,
// [8.,8.5]: m=2 maxabs=1.0581813203458523e-16 maxrel=2.9017595063893634e-14
0.0033810624828051333,
-0.0005043652683855726,
0.00005151405455939277,
-4.3532239528194796e-6,
3.215344081130449e-7,
-2.120962179765292e-8,
1.2648703626221259e-9,
-6.84994475783229e-11,
// [8.,8.5]: m=3 maxabs=6.591949208711867e-17 maxrel=5.892910051731321e-14
0.0010087305367711828,
-0.00020605621818319504,
0.000026119343725935215,
-2.5722774042221066e-6,
2.1209612125498676e-7,
-1.515797589173297e-8,
9.592726755230017e-10,
-5.449642710154072e-11,
// [8.,8.5]: m=4 maxabs=7.258733544790452e-17 maxrel=1.5495827740638515e-13
0.00041211243636941994,
-0.00010447737484919056,
0.0000154336643226532,
-1.6967708736407509e-6,
1.515806992658126e-7,
-1.1494013780279412e-8,
7.605173135962599e-10,
-4.4549665618053583e-11,
// [8.,8.5]: m=5 maxabs=6.236872997222864e-17 maxrel=2.5716275512073e-13
0.00020895474969834788,
-0.00006173465725395225,
0.000010180625245009876,
-1.2126470602286443e-6,
1.1494009551964588e-7,
-9.11213522164753e-9,
6.238309391967219e-10,
-3.752326356199036e-11,
// [8.,8.5]: m=6 maxabs=5.4508264221708735e-17 maxrel=3.7393228931998234e-13
0.00012346931450787568,
-0.00004072250094851651,
7.2758823641193224e-6,
-9.19522024962629e-7,
9.1121315629974e-8,
-7.473867921601038e-9,
5.254426913765094e-10,
-3.227518699604291e-11,
// [8.,8.5]: m=7 maxabs=4.8382521947165635e-17 maxrel=4.963733070464806e-13
0.00008144500189700771,
-0.00002910352942890366,
5.517132152183778e-6,
-7.289716279618344e-7,
7.473864720779588e-8,
-6.294724406712643e-9,
4.5195487038690195e-10,
-2.8234108911123524e-11,
// [8.,8.5]: m=8 maxabs=4.3408744480888384e-17 maxrel=6.164821359134968e-13
0.000058207058857785304,
-0.000022068528584275623,
4.373829769886195e-6,
-5.979101559638131e-7,
6.294721584323915e-8,
-5.4140672098712356e-9,
3.953678683235171e-10,
-2.5042419812775235e-11,
// [8.,8.5]: m=9 maxabs=3.699839913606784e-17 maxrel=6.870887183501063e-13
0.00004413705716852867,
-0.000017495319057730757,
3.587460936942529e-6,
-5.035785986362313e-7,
5.414065161510909e-8,
-4.73603274458389e-9,
3.506670925967916e-10,
-2.2376138520718236e-11,
// [8.,8.5]: m=10 maxabs=3.589386817284823e-17 maxrel=8.351652101032338e-13
0.00003499063811517927,
-0.000014349843730842047,
3.0214716281524306e-6,
-4.331259693961307e-7,
4.7359868023962323e-8,
-4.200466371441176e-9,
3.146134843592663e-10,
-2.035109835553447e-11,
// [8.,8.5]: m=11 maxabs=3.302750867933968e-17 maxrel=9.318636228056961e-13
0.00002869968746166748,
-0.00001208588649445954,
2.598755817971413e-6,
-3.788796701939353e-7,
4.2004642449911446e-8,
-3.768392284681287e-9,
2.849834294685572e-10,
-1.858517448276424e-11,
// [8.,8.5]: m=12 maxabs=6.518765562069095e-17 maxrel=2.174220953901617e-12
0.00002417177298891637,
-0.000010395023255325106,
2.2732780213225947e-6,
-3.3603780093724974e-7,
3.768392099920027e-8,
-3.413459194025103e-9,
2.6020353500885644e-10,
-1.6911628818127556e-11,
// [8.,8.5]: m=13 maxabs=2.8429813841643337e-17 maxrel=1.098499962841338e-12
0.000020790046510372555,
-9.093112075118914e-6,
2.016226844919912e-6,
-3.014718429576071e-7,
3.413389940378218e-8,
-3.117135389663298e-9,
2.3933857785318373e-10,
-1.5812997773310685e-11,
// [8.,8.5]: m=14 maxabs=2.6556176962316824e-17 maxrel=1.169511855451669e-12
0.000018186224150224523,
-8.064907365315846e-6,
1.808831059022794e-6,
-2.730717697623441e-7,
3.117133687269686e-8,
-2.866547546762043e-9,
2.2143644113119808e-10,
-1.4707471097063506e-11,
// [8.,8.5]: m=15 maxabs=2.49163211764325e-17 maxrel=1.234084011162769e-12
0.000016129814730619152,
-7.235324222670127e-6,
1.6384306197751061e-6,
-2.4937123181385e-7,
2.866545946403222e-8,
-2.652083740758649e-9,
2.0595578801727552e-10,
-1.3742749837396975e-11,
// [8.,8.5]: m=16 maxabs=2.3466200770733137e-17 maxrel=1.2927633221968096e-12
0.000014470648445328505,
-6.553722466507955e-6,
1.496227392010597e-6,
-2.293241794002351e-7,
2.6520822374648025e-8,
-2.4666341311764446e-9,
1.924466058948621e-10,
-1.2894033527838149e-11,
// [8.,8.5]: m=17 maxabs=2.21787106909066e-17 maxrel=1.3464472509818363e-12
0.000013107444933004773,
-5.984909556184645e-6,
1.375945077468894e-6,
-2.1216705329798469e-7,
2.4666327077370417e-8,
-2.3048060129506135e-9,
1.8056203218444272e-10,
-1.2141977859902501e-11,
// [8.,8.5]: m=18 maxabs=2.100472302601214e-17 maxrel=1.3941677920133208e-12
0.000011969819112358758,
-5.503780298672976e-6,
1.2730023207980857e-6,
-1.9733106471770304e-7,
2.3048046662557334e-8,
-2.1624426629144887e-9,
1.700307856589108e-10,
-1.1471221991034129e-11,
// [8.,8.5]: m=19 maxabs=1.9954402171416807e-17 maxrel=1.4382558996983602e-12
0.000011007560597335978,
-5.092009272577196e-6,
1.1839863892629026e-6,
-1.843847978965829e-7,
2.1624413875790822e-8,
-2.0362933538350497e-9,
1.6063791833066457e-10,
-1.0869439045777737e-11,
// [8.,8.5]: m=20 maxabs=1.9010807468175517e-17 maxrel=1.4792643422223392e-12
0.000010184018545144845,
-4.735945546966416e-6,
1.106308788292551e-6,
-1.7299571440329016e-7,
2.0362921366365496e-8,
-1.923782469879895e-9,
1.5221109235611875e-10,
-1.0326685584511626e-11,
// [8.,8.5]: m=21 maxabs=1.8145139796081622e-17 maxrel=1.5164387116865479e-12
9.471891093923782e-6,
-4.42523514356617e-6,
1.037974287288157e-6,
-1.6290375509719496e-7,
1.923781311867197e-8,
-1.8228450831958753e-9,
1.4461065735771887e-10,
-9.834777370253183e-12,
// [8.,8.5]: m=22 maxabs=1.7354011023346105e-17 maxrel=1.5506825598125238e-12
8.850470287123692e-6,
-4.1518971399859e-6,
9.774225314134675e-7,
-1.539028716230113e-7,
1.8228439760037698e-8,
-1.7318077918926851e-9,
1.377223129156877e-10,
-9.38697656000708e-12,
// [8.,8.5]: m=23 maxabs=1.6627256754601916e-17 maxrel=1.5822134507808128e-12
8.303794279963502e-6,
-3.909690116886767e-6,
9.234172305349915e-7,
-1.4582786876398454e-7,
1.7318067291045287e-8,
-1.6493011664929483e-9,
1.3145167524783664e-10,
-8.977616611204938e-12,
// [8.,8.5]: m=24 maxabs=1.5961488858060036e-17 maxrel=1.611725138924829e-12
7.819380233765297e-6,
-3.6936689137418116e-6,
8.749672133813488e-7,
-1.385448743388238e-7,
1.6493001127036636e-8,
-1.5741942851195752e-9,
1.257201619072472e-10,
-8.602179791813739e-12,
// [8.,8.5]: m=25 maxabs=1.5346542938353414e-17 maxrel=1.6391298979267621e-12
7.387337827475949e-6,
-3.4998688454623933e-6,
8.312692467681506e-7,
-1.3194433153605967e-7,
1.574193305659111e-8,
-1.5055457574880648e-9,
1.204618453563079e-10,
-8.256484708306594e-12,
// [8.,8.5]: m=26 maxabs=1.4777336797798524e-17 maxrel=1.6646914165344228e-12
6.9997376909173886e-6,
-3.3250769793215597e-6,
7.916659899259165e-7,
-1.2593577449674715e-7,
1.5055448119555745e-8,
-1.4425657006618934e-9,
1.156210318139083e-10,
-7.937231644639778e-12,
// [8.,8.5]: m=27 maxabs=1.4242011975133806e-17 maxrel=1.6877637821621745e-12
6.650153958636003e-6,
-3.1666639522416418e-6,
7.556146476633137e-7,
-1.2044388344565129e-7,
1.4425647905625955e-8,
-1.384586842055703e-9,
1.1115036018161916e-10,
-7.641513971747928e-12,
// [8.,8.5]: m=28 maxabs=1.3743956602148277e-17 maxrel=1.70932883440362e-12
6.333327904476413e-6,
-3.022458583459192e-6,
7.226633013329573e-7,
-1.1540547100933565e-7,
1.3845859634405612e-8,
-1.3310417695264282e-9,
1.070093099741057e-10,
-7.366851366161932e-12,
// [8.,8.5]: m=29 maxabs=1.3284864744736447e-17 maxrel=1.730234575012427e-12
6.044917166911747e-6,
-2.8906531983877073e-6,
6.92432826692262e-7,
-1.1076715484734344e-7,
1.3310409219758845e-8,
-1.2814450787018645e-9,
1.0316302448038338e-10,
-7.1110846177189546e-12,
// [8.,8.5]: m=30 maxabs=1.2854572007531262e-17 maxrel=1.7497606896518183e-12
5.781306396769002e-6,
-2.769731300057967e-6,
6.646029296983591e-7,
-1.0648354220569677e-7,
1.2814442603668358e-8,
-1.2353791770389167e-9,
9.958135469047172e-11,
-6.872339642726372e-12,
// [8.,8.5]: m=31 maxabs=1.2447996192849198e-17 maxrel=1.7676742820333903e-12
5.53946260010977e-6,
-2.658411712300702e-6,
6.389012538275566e-7,
-1.0251580054607229e-7,
1.2353783851252326e-8,
-1.192482924829669e-9,
9.623810876224637e-11,
-6.648983884525806e-12,
// [8.,8.5]: m=32 maxabs=1.207021949837378e-17 maxrel=1.785129743308031e-12
5.316823424595393e-6,
-2.5556050090215426e-6,
6.150948038537883e-7,
-9.883052235600752e-8,
1.1924821550465914e-8,
-1.1524424613696647e-9,
9.311040495044481e-11,
-6.439593786929769e-12,
// [8.,8.5]: m=33 maxabs=1.1712771594632465e-17 maxrel=1.8013200337175131e-12
5.1112100180372635e-6,
-2.4603792093184836e-6,
5.929831346954665e-7,
-9.539881626694574e-8,
1.1524417152418763e-8,
-1.1149837767472556e-9,
9.017818976369329e-11,
-6.242899429858513e-12,
// [8.,8.5]: m=34 maxabs=1.1376499514572508e-17 maxrel=1.8167287292905486e-12
4.920758418631311e-6,
-2.3719325328659527e-6,
5.723928981453839e-7,
-9.219557385241523e-8,
1.1149830515368157e-8,
-1.0798666063221874e-9,
8.742380387329699e-11,
-6.057789373721807e-12,
// [8.,8.5]: m=35 maxabs=1.1058862159352145e-17 maxrel=1.8313003436778516e-12
4.743865065726394e-6,
-2.2895715868361385e-6,
5.531734436438882e-7,
-8.919887393750789e-8,
1.0798659003443756e-8,
-1.0468794244463157e-9,
8.483164352555673e-11,
-5.8832760566919656e-12,
// [8.,8.5]: m=36 maxabs=1.0754777331287851e-17 maxrel=1.8444852320003447e-12
4.579143173666916e-6,
-2.212693768991084e-6,
5.351932441405949e-7,
-8.638949540549185e-8,
1.046878736899863e-8,
-1.015835293087945e-9,
8.238786624557596e-11,
-5.718486105940302e-12,
// [8.,8.5]: m=37 maxabs=1.0468480195115898e-17 maxrel=1.8572680116303196e-12
4.425387537976959e-6,
-2.1407729711301646e-6,
5.18336972933222e-7,
-8.375051624028882e-8,
1.0158346259635893e-8,
-9.865684204608714e-10,
8.008015467364932e-11,
-5.562616738201145e-12,
// [8.,8.5]: m=38 maxabs=1.0198276684941776e-17 maxrel=1.8696475852170094e-12
4.281545942255232e-6,
-2.073347886444798e-6,
5.025030979311398e-7,
-8.126698159909389e-8,
9.865677679604928e-9,
-9.589312423708684e-10,
7.789751085205074e-11,
-5.414985587698674e-12,
// [8.,8.5]: m=39 maxabs=9.942472734870977e-18 maxrel=1.8815837665983216e-12
4.146695772884651e-6,
-2.010012386573184e-6,
4.876018900697088e-7,
-7.892562748973379e-8,
9.589306085754266e-9,
-9.327920254145524e-10,
7.583008407646677e-11,
-5.274947659602192e-12,
// [8.,8.5]: m=40 maxabs=9.697680213114485e-18 maxrel=1.892666470932293e-12
4.020024773141548e-6,
-1.9504075552574264e-6,
4.7355376540150346e-7,
-7.671464954176381e-8,
9.32791407859684e-9,
-9.080327895181597e-10,
7.386902850577519e-11,
-5.1419340850803376e-12
},
{
// [8.5,9.]: m=0 maxabs=2.220446049250313e-16 maxrel=7.305012809221604e-16
0.2995907749600616,
-0.008555208960998274,
0.0003655199460198421,
-0.000017217067282633242,
8.372725235108247e-7,
-4.070166592184655e-8,
1.937384913704568e-9,
-8.87587296740098e-11,
// [8.5,9.]: m=1 maxabs=9.020562075079397e-17 maxrel=5.0484038102564215e-15
0.017110417921996888,
-0.0014620797840250656,
0.00010330240369089694,
-6.698182476805079e-6,
4.0701666364761457e-7,
-2.3225860933629963e-8,
1.2427341843241714e-9,
-6.200808672773903e-11,
// [8.5,9.]: m=2 maxabs=7.068998164605489e-17 maxrel=2.2503891547613554e-14
0.0029241595680499265,
-0.0004132096147181114,
0.00004018909487268606,
-3.2561351257299627e-6,
2.3225845751614302e-7,
-1.4895433242831436e-8,
8.685842984815151e-10,
-4.620984355720776e-11,
// [8.5,9.]: m=3 maxabs=5.551115123125783e-17 maxrel=6.087259475116912e-14
0.0008264192294363255,
-0.000160756379457771,
0.000019536810761159144,
-1.858069041523293e-6,
1.489542585390353e-7,
-1.0409635003534003e-8,
6.471497002915554e-10,
-3.579186490608033e-11,
// [8.5,9.]: m=4 maxabs=4.7488055154865094e-17 maxrel=1.306306503939942e-13
0.0003215127589106928,
-0.00007814724300230278,
0.00001114841444121941,
-1.191635448294813e-6,
1.0409455288181411e-7,
-7.753991054807804e-9,
5.058110916751604e-10,
-2.9293904623408993e-11,
// [8.5,9.]: m=5 maxabs=4.03594258707729e-17 maxrel=2.2361291123960667e-13
0.00015629448600458328,
-0.00004459365774099482,
7.149812691881591e-6,
-8.327573781777547e-7,
7.753988253820864e-8,
-6.060564966412467e-9,
4.102042110486843e-10,
-2.4446776775392153e-11,
// [8.5,9.]: m=6 maxabs=3.507394027990607e-17 maxrel=3.3461892254036525e-13
0.00008918731548197123,
-0.00002859925074714492,
4.996544270848169e-6,
-6.203198755334595e-7,
6.060562589308933e-8,
-4.914624547322667e-9,
3.423309205764945e-10,
-2.086886587971109e-11,
// [8.5,9.]: m=7 maxabs=3.0913314442992945e-17 maxrel=4.5336826941474345e-13
0.000057198501494273744,
-0.000019986177065673794,
3.7219192547447093e-6,
-4.84845715845977e-7,
4.9146224875953445e-8,
-4.101167786775218e-9,
2.922300612724666e-10,
-1.8141584132335677e-11,
// [8.5,9.]: m=8 maxabs=2.7633602871224294e-17 maxrel=5.733673597230616e-13
0.00003997235413133346,
-0.0000148876770033478,
2.9090742964295263e-6,
-3.9317042424763164e-7,
4.101165982978315e-8,
-3.5007584130291267e-9,
2.540398910489559e-10,
-1.600619725495811e-11,
// [8.5,9.]: m=9 maxabs=2.4936649967166602e-17 maxrel=6.883527521755895e-13
0.00002977535400667533,
-0.000011636297171752704,
2.3590225467077854e-6,
-3.28093837079089e-7,
3.5007567849794734e-8,
-3.0431176291212618e-9,
2.2413883728939222e-10,
-1.4296241216895981e-11,
// [8.5,9.]: m=10 maxabs=2.2690318591048197e-17 maxrel=7.955994422692421e-13
0.000023272594343493966,
-9.436090174232341e-6,
1.9685630235739384e-6,
-2.800610467286192e-7,
3.0431161608929535e-8,
-2.684828367553261e-9,
2.0019441044714857e-10,
-1.2900461330399836e-11,
// [8.5,9.]: m=11 maxabs=2.080990544814365e-17 maxrel=8.946039320714226e-13
0.00001887218034845414,
-7.87425208282891e-6,
1.6803662813838747e-6,
-2.434497515528686e-7,
2.6848270175754473e-8,
-2.3979295582866247e-9,
1.80649660130218e-10,
-1.1742338509160381e-11,
// [8.5,9.]: m=12 maxabs=1.9203930980149497e-17 maxrel=9.846741375453451e-13
0.00001574850416564809,
-6.7214651150204005e-6,
1.4606985102503742e-6,
-2.1478658201652063e-7,
2.397928314050419e-8,
-2.1637580390395324e-9,
1.6443255579411355e-10,
-1.0767709796708197e-11,
// [8.5,9.]: m=13 maxabs=1.7818185078441462e-17 maxrel=1.0661972676046673e-12
0.000013442930230031767,
-5.842794031297735e-6,
1.2887194929631807e-6,
-1.9183465328926057e-7,
2.1637568886761995e-8,
-1.969464212587078e-9,
1.5078471777651877e-10,
-9.937332932442733e-12,
// [8.5,9.]: m=14 maxabs=1.6623868622812898e-17 maxrel=1.1406754297516572e-12
0.00001168558806258714,
-5.154877962846575e-6,
1.1510079205343296e-6,
-1.731009113354414e-7,
1.969463148125015e-8,
-1.8059583057967363e-9,
1.3915671013753536e-10,
-9.222151314473909e-12,
// [8.5,9.]: m=15 maxabs=1.5571853702323057e-17 maxrel=1.2078413365647685e-12
0.000010309755925685373,
-4.604031673738839e-6,
1.0386054687603457e-6,
-1.5755738779408493e-7,
1.8059573082649978e-8,
-1.6666554273389809e-9,
1.2914205187524496e-10,
-8.600308476339277e-12,
// [8.5,9.]: m=16 maxabs=1.4640117460343327e-17 maxrel=1.268557272969264e-12
9.208063347470352e-6,
-4.1544218671752505e-6,
9.453443274678018e-7,
-1.444768993077809e-7,
1.6666544895553387e-8,
-1.5466840018471376e-9,
1.2043433376617698e-10,
-8.055022095459064e-12,
// [8.5,9.]: m=17 maxabs=1.381341330382313e-17 maxrel=1.323893882568195e-12
8.30884373434356e-6,
-3.781377302475337e-6,
8.668613965124823e-7,
-1.333326549946183e-7,
1.5466831143088175e-8,
-1.442372036465623e-9,
1.1279870675636823e-10,
-7.573264937184131e-12,
// [8.5,9.]: m=18 maxabs=1.3066330244344837e-17 maxrel=1.3735397017455575e-12
7.562754604944156e-6,
-3.467445579072869e-6,
7.999959305939287e-7,
-1.2373492823091822e-7,
1.4423712009352015e-8,
-1.3509052282601028e-9,
1.0605245910468817e-10,
-7.14472677298691e-12,
// [8.5,9.]: m=19 maxabs=1.2403950479591974e-17 maxrel=1.4198994823605596e-12
6.934891158139558e-6,
-3.1999837157732947e-6,
7.424095699791745e-7,
-1.1538996017597737e-7,
1.3509044365172698e-8,
-1.2700940951315691e-9,
1.0005151093850316e-10,
-6.761192915485057e-12,
// [8.5,9.]: m=20 maxabs=1.1797474889357895e-17 maxrel=1.461491954409985e-12
6.3999674315407e-6,
-2.9696382736513062e-6,
6.923397616214175e-7,
-1.0807260554178541e-7,
1.2700933408050973e-8,
-1.1982121400734e-9,
9.468084556158768e-11,
-6.416044555064016e-12,
// [8.5,9.]: m=21 maxabs=1.12469034736426e-17 maxrel=1.4996767691563895e-12
5.939276547297032e-6,
-2.769359040525866e-6,
6.484356337904473e-7,
-1.0160770568283575e-7,
1.1982114204469753e-8,
-1.1338812395433092e-9,
8.984764115884846e-11,
-6.103878821934909e-12,
// [8.5,9.]: m=22 maxabs=1.0747154034762563e-17 maxrel=1.5351483427573086e-12
5.538718081046388e-6,
-2.5937425294778475e-6,
6.096462346100777e-7,
-9.585714099115351e-8,
1.1338805554019808e-8,
-1.0759890957601826e-9,
8.547619751750993e-11,
-5.8202354245914835e-12,
// [8.5,9.]: m=23 maxabs=1.0290603276192495e-17 maxrel=1.5680661534732431e-12
5.187485058950578e-6,
-2.438584933009099e-6,
5.751428464377358e-7,
-9.07106616774941e-8,
1.075988441381525e-8,
-1.0236288286041934e-9,
8.150423457341038e-11,
-5.5614236361752674e-12,
// [8.5,9.]: m=24 maxabs=9.861157571934565e-18 maxrel=1.5969607529773202e-12
4.877169866013233e-6,
-2.300571380550993e-6,
5.44263970536956e-7,
-8.607928329586512e-8,
1.0236281995741957e-8,
-9.76054179964549e-10,
7.78800574095814e-11,
-5.3243354397499415e-12,
// [8.5,9.]: m=25 maxabs=9.481686811564638e-18 maxrel=1.6264544656335197e-12
4.601142761097874e-6,
-2.1770558771611144e-6,
5.164757002225654e-7,
-8.189045542355299e-8,
9.760535674205881e-9,
-9.326457987022305e-10,
7.456043822333022e-11,
-5.106455909119427e-12,
// [8.5,9.]: m=26 maxabs=9.122544841928815e-18 maxrel=1.6525536974966812e-12
4.354111754317697e-6,
-2.0659027960996504e-6,
4.913427329763538e-7,
-7.808447701557147e-8,
9.326452187215985e-9,
-8.928856958788623e-10,
7.150894086219978e-11,
-4.90548742321301e-12,
// [8.5,9.]: m=27 maxabs=8.787966827763366e-18 maxrel=1.6766033088766824e-12
4.131805592194952e-6,
-1.965370927296425e-6,
4.6850686251165206e-7,
-7.4611801856302e-8,
8.928851381077743e-9,
-8.563374501802423e-10,
6.86946747797707e-11,
-4.719573891756092e-12,
// [8.5,9.]: m=28 maxabs=8.48134090085731e-18 maxrel=1.699952269179501e-12
3.930741854588641e-6,
-1.874027445605941e-6,
4.4767081154185964e-7,
-7.143098867155086e-8,
8.563369114503861e-9,
-8.22630929731051e-10,
6.609127321713378e-11,
-4.547098675344701e-12,
// [8.5,9.]: m=29 maxabs=8.18996156700183e-18 maxrel=1.7207080242613555e-12
3.7480548912077942e-6,
-1.7906832418833407e-6,
4.285859324215326e-7,
-6.850712427460649e-8,
8.2263040699198e-9,
-7.914502595155884e-10,
6.367610391468795e-11,
-4.386680433118252e-12,
// [8.5,9.]: m=30 maxabs=7.921452122722217e-18 maxrel=1.7409613330646336e-12
3.58136648376275e-6,
-1.7143437255481918e-6,
4.110427460252953e-7,
-6.581059807361181e-8,
7.914497559994136e-9,
-7.625243250918918e-10,
6.142963795840028e-11,
-4.23709768881475e-12,
// [8.5,9.]: m=31 maxabs=7.670730370334944e-18 maxrel=1.7601880584373328e-12
3.4286874510925754e-6,
-1.6441709800998208e-6,
3.9486358880688647e-7,
-6.33161405324499e-8,
7.625238384196758e-9,
-7.356191643603973e-10,
5.933493471821515e-11,
-4.097285370498105e-12,
// [8.5,9.]: m=32 maxabs=7.431867079209231e-18 maxrel=1.7774689778816562e-12
3.288341960195912e-6,
-1.5794543513542095e-6,
3.798968435518292e-7,
-6.100206200717324e-8,
7.3561868820849155e-9,
-7.10531846514552e-10,
5.737723734217587e-11,
-3.966346575485288e-12,
// [8.5,9.]: m=33 maxabs=7.20909741408135e-18 maxrel=1.7941878867611803e-12
3.1589087027048123e-6,
-1.5195873704539152e-6,
3.6601237238916326e-7,
-5.884964519193456e-8,
7.105313849768916e-9,
-6.87085551706053e-10,
5.554362274984148e-11,
-3.8434577588744466e-12,
// [8.5,9.]: m=34 maxabs=6.999033243162284e-18 maxrel=1.8099245618597824e-12
3.0391747409043317e-6,
-1.4640494859161427e-6,
3.530978714872599e-7,
-5.68426564184833e-8,
6.870851040797702e-9,
-6.651255143076446e-10,
5.3822737786493587e-11,
-3.727902644217332e-12,
// [8.5,9.]: m=35 maxabs=6.8012510499784046e-18 maxrel=1.8249249061073255e-12
2.928098971828888e-6,
-1.412391482414824e-6,
3.410559388369825e-7,
-5.4966949695176555e-8,
6.651250793221706e-9,
-6.44515711475401e-10,
5.220456236747026e-11,
-3.6190480016104173e-12,
// [8.5,9.]: m=36 maxabs=6.614056768635204e-18 maxrel=1.8390669892401053e-12
2.824782964826336e-6,
-1.3642237519140441e-6,
3.2980169848858864e-7,
-5.321014370202825e-8,
6.4451528808724715e-9,
-6.251361252728341e-10,
5.0680224007549464e-11,
-3.5163329208495424e-12,
// [8.5,9.]: m=37 maxabs=6.435332816764547e-18 maxrel=1.8520426295868495e-12
2.728447503824871e-6,
-1.3192067906153077e-6,
3.192608625208116e-7,
-5.156135661050246e-8,
6.251357136528515e-9,
-6.068804723210982e-10,
4.924183778333688e-11,
-3.4192525481482353e-12,
// [8.5,9.]: m=38 maxabs=6.2680438096818225e-18 maxrel=1.864974577168809e-12
2.638413581227479e-6,
-1.2770434468339275e-6,
3.0936813996385673e-7,
-5.001098706587468e-8,
6.068800711814165e-9,
-5.896542994811635e-10,
4.78823735453011e-11,
-3.3273594702467914e-12,
// [8.5,9.]: m=39 maxabs=6.1071075497035054e-18 maxrel=1.876629587813681e-12
2.554086893664808e-6,
-1.2374725566912204e-6,
3.000659226881037e-7,
-4.855053226516145e-8,
5.896539087212186e-9,
-5.733733942910472e-10,
4.6595543458911026e-11,
-3.2402509114032964e-12,
// [8.5,9.]: m=40 maxabs=5.955488652144986e-18 maxrel=1.8881282963989708e-12
2.474945113379467e-6,
-1.2002636876688827e-6,
2.9130319387648043e-7,
-4.7172436039286725e-8,
5.733730134080181e-9,
-5.579624384655722e-10,
4.537570719316397e-11,
-3.157564927093659e-12
},
{
// [9.,9.5]: m=0 maxabs=2.220446049250313e-16 maxrel=7.516681238125082e-16
0.2913846672994536,
-0.00787266366614606,
0.00031851263747722424,
-0.00001423918225192913,
6.599453857605646e-7,
-3.075259525720967e-8,
1.4123840576281755e-9,
-6.267990005594356e-11,
// [9.,9.5]: m=1 maxabs=5.898059818321144e-17 maxrel=3.595415267806771e-15
0.015745327332291423,
-0.0012740505498599023,
0.00008543509356537788,
-5.279564850602134e-6,
3.0752523518282473e-7,
-1.693236452164102e-8,
8.797728604847063e-10,
-4.288266678935936e-11,
// [9.,9.5]: m=2 maxabs=4.683753385137379e-17 maxrel=1.7174163202523714e-14
0.002548101099719575,
-0.000341740374230723,
0.000031677389108395944,
-2.460203112098894e-6,
1.6932358576615704e-7,
-1.0545493985208449e-8,
6.005442451410246e-10,
-3.134951698992406e-11,
// [9.,9.5]: m=3 maxabs=3.7947076036992655e-17 maxrel=5.054878920279056e-14
0.000683480748461407,
-0.00012670955640995928,
0.000014761218675789099,
-1.354589629835588e-6,
1.0545489952468237e-7,
-7.197476609451293e-9,
4.3901884852605105e-10,
-2.413841941839321e-11,
// [9.,9.5]: m=4 maxabs=3.0899761915836876e-17 maxrel=1.0838843933238341e-13
0.0002534191128198999,
-0.00005904487468426427,
8.127537780879046e-6,
-8.43639951604055e-7,
7.197474080061158e-8,
-5.260974510967547e-9,
3.3801950107453293e-10,
-1.9339303546099848e-11,
// [9.,9.5]: m=5 maxabs=2.6183482465524932e-17 maxrel=1.9297159962462966e-13
0.0001180897493685136,
-0.00003251015110790135,
5.061839711034586e-6,
-5.757985508072079e-7,
5.2609726341502394e-8,
-4.050240679404307e-9,
2.7081027015148855e-10,
-1.5980679819982384e-11,
// [9.,9.5]: m=6 maxabs=2.256495771485456e-17 maxrel=2.966617116401837e-13
0.00006502030221579064,
-0.000020247358830918935,
3.4547913060030116e-6,
-4.208783394055876e-7,
4.0502391340984247e-8,
-3.244648495847737e-9,
2.2377896339248242e-10,
-1.3531825454887149e-11,
// [9.,9.5]: m=7 maxabs=2.5038293920837118e-17 maxrel=5.20782302851087e-13
0.00004049471766183082,
-0.000013819165212643214,
2.5252700372126652e-6,
-3.2401958498122773e-7,
3.2446469606977555e-8,
-2.6809746874567858e-9,
1.8949941066856496e-10,
-1.168081762882836e-11,
// [9.,9.5]: m=8 maxabs=1.7611509039311413e-17 maxrel=5.303218511166637e-13
0.000027638330425188728,
-0.000010101080139647768,
1.9441175241522866e-6,
-2.595721754557137e-7,
2.6809644349802097e-8,
-2.2700049222163753e-9,
1.6362301807613768e-10,
-1.0251664104225534e-11,
// [9.,9.5]: m=9 maxabs=1.5819187322921313e-17 maxrel=6.454691485824654e-13
0.000020202160279284603,
-7.776470087704445e-6,
1.5574330535025686e-6,
-2.144775107893254e-7,
2.2700038950647027e-8,
-1.9600587626692244e-9,
1.4355622056975902e-10,
-9.113129194668465e-12,
// [9.,9.5]: m=10 maxabs=1.098093512820475e-17 maxrel=5.775334963359941e-13
0.000015552940175408568,
-6.229732205956667e-6,
1.2868650647342412e-6,
-1.8160063491720463e-7,
1.960058453238664e-8,
-1.7195742397325034e-9,
1.275993924094761e-10,
-8.256553913760531e-12,
// [9.,9.5]: m=11 maxabs=1.3118846287074604e-17 maxrel=8.559684179858656e-13
0.000012459464412016341,
-5.147460254465012e-6,
1.0896037899139562e-6,
-1.568049170512087e-7,
1.719602432291325e-8,
-1.5285762183505597e-9,
1.1468961118059454e-10,
-7.428989559143073e-12,
// [9.,9.5]: m=12 maxabs=1.208207795963534e-17 maxrel=9.492868254191831e-13
0.000010294920508923953,
-4.358415153023025e-6,
9.408295028903972e-7,
-1.375684598921727e-7,
1.5285754406888737e-8,
-1.3737283924899833e-9,
1.040307442615661e-10,
-6.791794183107012e-12,
// [9.,9.5]: m=13 maxabs=4.529932201915998e-18 maxrel=4.1862313718431845e-13
8.716830306024105e-6,
-3.76331800532634e-6,
8.254107615417155e-7,
-1.2228628744601253e-7,
1.3737262079376482e-8,
-1.245955810750318e-9,
9.514166737799207e-11,
-6.408697704074042e-12,
// [9.,9.5]: m=14 maxabs=1.0410034921755351e-17 maxrel=1.1103516091755774e-12
7.526636010907095e-6,
-3.301643033922355e-6,
7.337176772737238e-7,
-1.098984397574529e-7,
1.2460239269428502e-8,
-1.1391282461496854e-9,
8.754205177216681e-11,
-5.78807841836502e-12,
// [9.,9.5]: m=15 maxabs=9.73410262984642e-18 maxrel=1.1800663964101072e-12
6.6032860678398445e-6,
-2.934870703834217e-6,
6.593906390114839e-7,
-9.968212457613539e-8,
1.139127623739622e-8,
-1.048484608098485e-9,
8.105301795497156e-11,
-5.386666023893028e-12,
// [9.,9.5]: m=16 maxabs=9.136944402032138e-18 maxrel=1.2431007106800005e-12
5.869741407663882e-6,
-2.63756255112804e-6,
5.980927478948559e-7,
-9.113040661471018e-8,
1.0484840236649147e-8,
-9.70747754463744e-10,
7.543203402897432e-11,
-5.0358698063761714e-12,
// [9.,9.5]: m=17 maxabs=8.6075488099982e-18 maxrel=1.3004054169795393e-12
5.275125102251789e-6,
-2.3923709869632744e-6,
5.467824401004026e-7,
-8.387890653739927e-8,
9.707472047691486e-9,
-9.034118279050813e-10,
7.05197731219572e-11,
-4.726877143310085e-12,
// [9.,9.5]: m=18 maxabs=8.133210359535792e-18 maxrel=1.3522839890203382e-12
4.784741973922497e-6,
-2.1871297560530413e-6,
5.032734396140481e-7,
-7.765995032071399e-8,
9.034113078066308e-9,
-8.445674746028124e-10,
6.619293654800844e-11,
-4.45278894299177e-12,
// [9.,9.5]: m=19 maxabs=7.707999820014133e-18 maxrel=1.3997025729549418e-12
4.374259512102259e-6,
-2.0130937543465333e-6,
4.659597022920494e-7,
-7.227306900606092e-8,
8.44566983597686e-9,
-7.927371928911184e-10,
6.235477300636018e-11,
-4.208103371833218e-12,
// [9.,9.5]: m=20 maxabs=7.32514092785519e-18 maxrel=1.4432404638251971e-12
4.026187508689433e-6,
-1.8638388052730804e-6,
4.336384143859882e-7,
-6.756551448827453e-8,
7.927367261284463e-9,
-7.467616107038097e-10,
5.892839696782456e-11,
-3.988410658309549e-12,
// [9.,9.5]: m=21 maxabs=6.97870445242818e-18 maxrel=1.4833411517558692e-12
3.727677610542675e-6,
-1.7345536538425837e-6,
4.053930872633695e-7,
-6.341908614360651e-8,
7.467611653245416e-9,
-7.057194594151309e-10,
5.5852009865185616e-11,
-3.790126651961355e-12,
// [9.,9.5]: m=22 maxabs=6.664455228996835e-18 maxrel=1.5205401194287627e-12
3.46910730768184e-6,
-1.6215723455277373e-6,
3.8051451718132973e-7,
-5.974103425411332e-8,
7.057190330597932e-9,
-6.688702505729845e-10,
5.3075417847770867e-11,
-3.610312889214463e-12,
// [9.,9.5]: m=23 maxabs=6.37392292808861e-18 maxrel=1.5541296995428438e-12
3.2431446910522763e-6,
-1.522058065359533e-6,
3.584462058314602e-7,
-5.645765727502712e-8,
6.68869841695268e-9,
-6.356125643444801e-10,
5.0557462528973865e-11,
-3.446540950690216e-12,
// [9.,9.5]: m=24 maxabs=6.10795458265076e-18 maxrel=1.5853284557256157e-12
3.0441161307160046e-6,
-1.4337848201062668e-6,
3.3874594394388787e-7,
-5.3509716116755296e-8,
6.356121728784233e-9,
-6.054532571980067e-10,
4.826409638258023e-11,
-3.2967775801519388e-12,
// [9.,9.5]: m=25 maxabs=5.862315027947013e-18 maxrel=1.6140382120180248e-12
2.867569640209543e-6,
-1.3549837726905984e-6,
3.2105829698313405e-7,
-5.084909723707167e-8,
6.054528808630735e-9,
-5.779844285547719e-10,
4.616692666001677e-11,
-3.1593023300147524e-12,
// [9.,9.5]: m=26 maxabs=5.637427780450996e-18 maxrel=1.6412721653780182e-12
2.7099675453776545e-6,
-1.284233184969369e-6,
3.050945837208792e-7,
-4.8436348934393156e-8,
5.779840489769145e-9,
-5.528658808611424e-10,
4.4242112428429395e-11,
-3.0327411259907335e-12,
// [9.,9.5]: m=27 maxabs=5.428210642479184e-18 maxrel=1.6663973802737608e-12
2.5684663699360243e-6,
-1.2203783320360505e-6,
2.906180938666066e-7,
-4.623883781626893e-8,
5.5286553405747405e-9,
-5.298119273206139e-10,
4.246947009019094e-11,
-2.9157942896549413e-12,
// [9.,9.5]: m=28 maxabs=5.234240097557949e-18 maxrel=1.689976006751913e-12
2.4407566640694825e-6,
-1.1624723727247178e-6,
2.77433027148829e-7,
-4.422935239108269e-8,
5.2981159255977594e-9,
-5.085808497621323e-10,
4.083182795553643e-11,
-2.807436542207296e-12,
// [9.,9.5]: m=29 maxabs=5.052975046845529e-18 maxrel=1.7118360847177032e-12
2.3249447454469e-6,
-1.1097321059519566e-6,
2.653761145895904e-7,
-4.2385033138274925e-8,
5.0858052574327836e-9,
-4.889668971703901e-10,
3.931447934646329e-11,
-2.706766828637535e-12,
// [9.,9.5]: m=30 maxabs=4.8831449409210415e-18 maxrel=1.7321026053120078e-12
2.2194642119014603e-6,
-1.061504455806633e-6,
2.543101990648234e-7,
-4.068654412892508e-8,
4.8896658377619535e-9,
-4.707938808291977e-10,
3.7904761222023744e-11,
-2.6130024352616295e-12,
// [9.,9.5]: m=31 maxabs=4.723479230363606e-18 maxrel=1.7508258539224577e-12
2.1230089116108963e-6,
-1.0172407937930766e-6,
2.441192650007005e-7,
-3.911742535171146e-8,
4.70793578209427e-9,
-4.5391009208921356e-10,
3.659171299543683e-11,
-2.5254603042492177e-12,
// [9.,9.5]: m=32 maxabs=4.575248464594103e-18 maxrel=1.7689625124880226e-12
2.0344815875838594e-6,
-9.76477057616456e-7,
2.3470455232995313e-7,
-3.7663581708872564e-8,
4.539097995285637e-9,
-4.38184222944328e-10,
3.5365800317820455e-11,
-2.443547344860059e-12,
// [9.,9.5]: m=33 maxabs=4.4346409953498894e-18 maxrel=1.785508373336767e-12
1.952954115230707e-6,
-9.388182070085485e-7,
2.259814904648882e-7,
-3.63128764129008e-8,
4.381839406898841e-9,
-4.2350207760475957e-10,
3.421869630245006e-11,
-2.3667379416714994e-12,
// [9.,9.5]: m=34 maxabs=4.304621437946354e-18 maxrel=1.802055477715753e-12
1.8776364140149592e-6,
-9.039259596187044e-7,
2.178772586826158e-7,
-3.5054804887948214e-8,
4.235018038798878e-9,
-4.0976388689290773e-10,
3.314309285338989e-11,
-2.294573954578475e-12,
// [9.,9.5]: m=35 maxabs=4.180531111173599e-18 maxrel=1.8170749697464462e-12
1.807851919235333e-6,
-8.715090325559325e-7,
2.1032882952718385e-7,
-3.388023128989657e-8,
4.097636207665787e-9,
-3.9688211713380156e-10,
3.213255360390333e-11,
-2.226650185648183e-12,
// [9.,9.5]: m=36 maxabs=4.064064080926133e-18 maxrel=1.8316047553680232e-12
1.7430180651098384e-6,
-8.413153159967504e-7,
2.032813879336761e-7,
-3.278117413927229e-8,
3.968818581902416e-9,
-3.8477966170845457e-10,
3.1181386578417664e-11,
-2.1626060744656114e-12,
// [9.,9.5]: m=37 maxabs=3.95310276483582e-18 maxrel=1.8450141932222824e-12
1.682630631991536e-6,
-8.131255496818263e-7,
1.9668704502437538e-7,
-3.175063076951928e-8,
3.847794099768598e-9,
-3.7338834346946814e-10,
3.02845422874932e-11,
-2.102120507724491e-12,
// [9.,9.5]: m=38 maxabs=3.8484941958499136e-18 maxrel=1.8579695030360216e-12
1.6262510993617379e-6,
-7.867481781004579e-7,
1.9050378480080515e-7,
-3.0782432678270966e-8,
3.733880985811034e-9,
-3.626476647175201e-10,
2.943752298217173e-11,
-2.044905936763713e-12,
// [9.,9.5]: m=39 maxabs=3.748120791600279e-18 maxrel=1.869713687308947e-12
1.573496356199052e-6,
-7.620151372591611e-7,
1.8469459624848433e-7,
-2.9871125648453173e-8,
3.626474262512052e-9,
-3.525037618962361e-10,
2.863631327550901e-11,
-1.9907049172946304e-12,
// [9.,9.5]: m=40 maxabs=3.654100134455052e-18 maxrel=1.8815354584718924e-12
1.524030274516507e-6,
-7.387783831000434e-7,
1.7922675406510325e-7,
-2.901186985425836e-8,
3.5250352927616003e-9,
-3.42908524541881e-10,
2.7877314397393475e-11,
-1.939287687210172e-12
},
{
// [9.5,10.]: m=0 maxabs=1.6653345369377348e-16 maxrel=5.791939648379163e-16
0.2838169076324133,
-0.007275861870991553,
0.0002794671574563395,
-0.000011880760299808352,
5.25325839395937e-7,
-2.346730412407927e-8,
1.0391506513073553e-9,
-4.476487797048936e-11,
// [9.5,10.]: m=1 maxabs=3.8163916471489756e-17 maxrel=2.522563755377056e-15
0.014551723741983597,
-0.00111786862980066,
0.00007128456176341692,
-4.202607686402373e-6,
2.3467295274639464e-7,
-1.2459459551843213e-8,
6.279867211692149e-10,
-2.985175594650605e-11,
// [9.5,10.]: m=2 maxabs=3.122502256758253e-17 maxrel=1.3093059660017168e-14
0.0022357372596010106,
-0.0002851382470326703,
0.00002521564612400673,
-1.8773844627938926e-6,
1.2459451649134018e-7,
-7.527794218947844e-9,
4.181820053939858e-10,
-2.1399522227628977e-11,
// [9.5,10.]: m=3 maxabs=3.3285006695304986e-17 maxrel=5.337100825023452e-14
0.0005702764940653161,
-0.00010086258448030989,
0.000011264306779148694,
-9.967567595362977e-7,
7.527791224427852e-8,
-5.012161313383381e-9,
2.996760255453514e-10,
-1.6079139803407928e-11,
// [9.5,10.]: m=4 maxabs=2.0328790734103208e-17 maxrel=9.00191330479636e-14
0.00020172516896031773,
-0.00004505722710030848,
5.980540595355246e-6,
-6.022238868706684e-7,
5.012101381598683e-8,
-3.591017884079428e-9,
2.2703037956579667e-10,
-1.28215228214209e-11,
// [9.5,10.]: m=5 maxabs=8.551644635479416e-18 maxrel=8.300043381312621e-14
0.00009011445420074125,
-0.000023922162370195318,
3.6133433198455463e-6,
-4.009685391280409e-7,
3.591017899062409e-8,
-2.720318943055353e-9,
1.7951920218918997e-10,
-1.0699694676578708e-11,
// [9.5,10.]: m=6 maxabs=1.4602848010664138e-17 maxrel=2.621218848495555e-13
0.000047844324742344396,
-0.00001445337327999189,
2.4058111215145796e-6,
-2.8728167595484225e-7,
2.7204320090920516e-8,
-2.151189832747458e-9,
1.4680193352161433e-10,
-8.800553073197512e-12,
// [9.5,10.]: m=7 maxabs=1.2793585635328952e-17 maxrel=3.7432337027792617e-13
0.00002890674655998047,
-9.62324447876221e-6,
1.7236900554439701e-6,
-2.176348570147493e-7,
2.1511896285740673e-8,
-1.7587796947964908e-9,
1.2322124500882832e-10,
-7.576812408752952e-12,
// [9.5,10.]: m=8 maxabs=1.123504501238104e-17 maxrel=4.875690921376337e-13
0.000019246488957372175,
-6.894760219091139e-6,
1.3058091334375192e-6,
-1.7209537453899945e-7,
1.758792961244117e-8,
-1.4763567389205068e-9,
1.0565515405390735e-10,
-6.5802621767116186e-12,
// [9.5,10.]: m=9 maxabs=1.0076303940537157e-17 maxrel=6.041734348256293e-13
0.000013789520438177452,
-5.223236528072339e-6,
1.032572247734736e-6,
-1.4070366413991943e-7,
1.4763560696648391e-8,
-1.2656799067416062e-9,
9.214502312472045e-11,
-5.8190077198386375e-12,
// [9.5,10.]: m=10 maxabs=9.09205165582766e-18 maxrel=7.137591135673302e-13
0.000010446473056119423,
-4.130288985844391e-6,
8.442219858802489e-7,
-1.1810868943974875e-7,
1.265678761244282e-8,
-1.1037855567336867e-9,
8.149952566131085e-11,
-5.2081879264071246e-12,
// [9.5,10.]: m=11 maxabs=8.285676290041566e-18 maxrel=8.171630292326099e-13
8.260577971684556e-6,
-3.3768879389243576e-6,
7.086521370430253e-7,
-1.0125448476095388e-7,
1.103785018295791e-8,
-9.762292627127046e-10,
7.293184271212119e-11,
-4.706741816487055e-12,
// [9.5,10.]: m=12 maxabs=7.606355866343617e-18 maxrel=9.126197964201454e-13
6.753775877844839e-6,
-2.8346085439829835e-6,
6.075269089369781e-7,
-8.830296902203224e-8,
9.762287682375735e-9,
-8.735735920658166e-10,
6.591019714690707e-11,
-4.289313895864914e-12,
// [9.5,10.]: m=13 maxabs=7.029526429263439e-18 maxrel=1.0003510916937864e-12
5.669217087962408e-6,
-2.430107631902989e-6,
5.298178144745794e-7,
-7.809845525429157e-8,
8.735731353876766e-9,
-7.894459444807089e-10,
6.006500727370764e-11,
-3.937088585724254e-12,
// [9.5,10.]: m=14 maxabs=6.5246947926998755e-18 maxrel=1.0791306359607637e-12
4.8602152638026955e-6,
-2.1192712543471767e-6,
4.685907318417838e-7,
-6.988599287588959e-8,
7.894455230843744e-9,
-7.194164605114151e-10,
5.513272211462106e-11,
-3.63632721934946e-12,
// [9.5,10.]: m=15 maxabs=6.089319857811165e-18 maxrel=1.1513355386473434e-12
4.23854250869129e-6,
-1.874362924069276e-6,
4.1931595754968237e-7,
-6.315577375757883e-8,
7.194160682949117e-9,
-6.60326343373762e-10,
5.092112317530948e-11,
-3.376816455848478e-12,
// [9.5,10.]: m=16 maxabs=5.707307998599476e-18 maxrel=1.2169831634796237e-12
3.7487258481356802e-6,
-1.6772638271217487e-6,
3.789346428214459e-7,
-5.755340854299217e-8,
6.603259754775689e-9,
-6.098719169523484e-10,
4.728719998041616e-11,
-3.1508246619074442e-12,
// [9.5,10.]: m=17 maxabs=5.365953720855993e-18 maxrel=1.2758674097069237e-12
3.3545276542407983e-6,
-1.5157385684024864e-6,
3.4532045151746e-7,
-5.2826193368318637e-8,
6.09871570709893e-9,
-5.663392419161974e-10,
4.4122629731247705e-11,
-2.952401552596837e-12,
// [9.5,10.]: m=18 maxabs=5.065257024580716e-18 maxrel=1.330222396509707e-12
3.0314771368024275e-6,
-1.381281803357929e-6,
3.1695716045451864e-7,
-4.878983413123659e-8,
5.663389159368827e-9,
-5.284302130100965e-10,
4.1344047537991355e-11,
-2.776893753193918e-12,
// [9.5,10.]: m=19 maxabs=4.794629997932967e-18 maxrel=1.3794826950523234e-12
2.762563606713453e-6,
-1.267828639258867e-6,
2.9273900501850524e-7,
-4.530721564396356e-8,
5.2842990497662095e-9,
-4.951458308426159e-10,
3.888636627676688e-11,
-2.6206261080673524e-12,
// [9.5,10.]: m=20 maxabs=4.552802091491864e-18 maxrel=1.4251087480383156e-12
2.5356572785154597e-6,
-1.1709560176514692e-6,
2.7184329408260775e-7,
-4.227448929999016e-8,
4.951455390226807e-9,
-4.65706143632886e-10,
3.669810184771997e-11,
-2.4806539251521113e-12,
// [9.5,10.]: m=21 maxabs=4.329185393416729e-18 maxrel=1.4654007652950873e-12
2.3419120353007692e-6,
-1.087373174030981e-6,
2.536469360084135e-7,
-3.961173509943926e-8,
4.657058656383622e-9,
-4.39494241615662e-10,
3.4738050967205914e-11,
-2.3546027653236098e-12,
// [9.5,10.]: m=22 maxabs=4.129709134338341e-18 maxrel=1.5036791656526146e-12
2.174746348059883e-6,
-1.01458774184542e-6,
2.3767041079512308e-7,
-3.7256556778527614e-8,
4.394939777655435e-9,
-4.1601638719539096e-10,
3.297287088005188e-11,
-2.2405196506717393e-12,
// [9.5,10.]: m=23 maxabs=3.947597050678667e-18 maxrel=1.5389828238774904e-12
2.0291754836888725e-6,
-9.506816410937198e-7,
2.2353934085991618e-7,
-3.515960169108229e-8,
4.1601613548758565e-9,
-3.9487314606411466e-10,
3.137533157581763e-11,
-2.1368038590469323e-12,
// [9.5,10.]: m=24 maxabs=3.779037494175061e-18 maxrel=1.5709330803370442e-12
1.9013632821855552e-6,
-8.941573614454164e-7,
2.1095761032751597e-7,
-3.328137060911938e-8,
3.94872904672788e-9,
-3.757381840561194e-10,
2.992297856641189e-11,
-2.042126299706325e-12,
// [9.5,10.]: m=25 maxabs=3.624030464827524e-18 maxrel=1.6004747023479688e-12
1.7883147228890362e-6,
-8.438304394005373e-7,
1.9968822382744507e-7,
-3.158990875488096e-8,
3.757379535522164e-9,
-3.5834248259498843e-10,
2.859714731392142e-11,
-1.9553661903234035e-12,
// [9.5,10.]: m=26 maxabs=3.482575962636056e-18 maxrel=1.6285783977285356e-12
1.6876608787993483e-6,
-7.98752893478101e-7,
1.895394526952065e-7,
-3.005910954993145e-8,
3.5834226108184707e-9,
-3.424624283700989e-10,
2.738221633074943e-11,
-1.8755594989248238e-12,
// [9.5,10.]: m=27 maxabs=3.3495917899171307e-18 maxrel=1.6537261848836528e-12
1.5975057869545784e-6,
-7.581578090200981e-7,
1.8035465745845407e-7,
-2.8667451313464447e-8,
3.4246220933429654e-9,
-3.2791069672916146e-10,
2.626495855149854e-11,
-1.8019743778351987e-12,
// [9.5,10.]: m=28 maxabs=3.228889594933393e-18 maxrel=1.6785084979370756e-12
1.5163156180385947e-6,
-7.214186281405855e-7,
1.720047080346752e-7,
-2.7397044475711462e-8,
3.2791049137495296e-9,
-3.145293049861408e-10,
2.523421537528273e-11,
-1.7338613319883888e-12,
// [9.5,10.]: m=29 maxabs=3.1153871800013166e-18 maxrel=1.7010701895452437e-12
1.4428372562796215e-6,
-6.880188305072131e-7,
1.6438226700295812e-7,
-2.62329045697296e-8,
3.1452910665520453e-9,
-3.021840896205777e-10,
2.428040729666119e-11,
-1.6706565099484405e-12,
// [9.5,10.]: m=30 maxabs=3.009084545120902e-18 maxrel=1.7219415427184277e-12
1.376037661012931e-6,
-6.575290664377739e-7,
1.5739742756187706e-7,
-2.5162391495053104e-8,
3.021838982534402e-9,
-2.907604449733896e-10,
2.3395315519177748e-11,
-1.6118509056016459e-12,
// [9.5,10.]: m=31 maxabs=2.910405206765776e-18 maxrel=1.7419134941351875e-12
1.3150581328740976e-6,
-6.295897087269995e-7,
1.5097434910930823e-7,
-2.4174772680928817e-8,
2.907602596952507e-9,
-2.801599082388661e-10,
2.2571841033874347e-11,
-1.5570069674654866e-12,
// [9.5,10.]: m=32 maxabs=2.8182903737518708e-18 maxrel=1.760901250896479e-12
1.2591794174526029e-6,
-6.03897394966792e-7,
1.450486362196333e-7,
-2.3260879593341438e-8,
2.8015972938493975e-9,
-2.702974420043864e-10,
2.1803822868467628e-11,
-1.5057362799297405e-12,
// [9.5,10.]: m=33 maxabs=2.731045980184678e-18 maxrel=1.7782997825441573e-12
1.2077947899322181e-6,
-5.801945434549941e-7,
1.3956527769093432e-7,
-2.2412835292904133e-8,
2.702972675806904e-9,
-2.6109923145163393e-10,
2.1085887478979828e-11,
-1.4577087329791265e-12,
// [9.5,10.]: m=34 maxabs=2.649307300774638e-18 maxrel=1.7949074941287492e-12
1.160389086908667e-6,
-5.582611093842258e-7,
1.344770118842583e-7,
-2.1623836587248888e-8,
2.610990624056883e-9,
-2.525009140594578e-10,
2.0413329889371608e-11,
-1.4126253590526365e-12,
// [9.5,10.]: m=35 maxabs=2.5726508190481237e-18 maxrel=1.8108475839123948e-12
1.1165222187671662e-6,
-5.37908046198871e-7,
1.297430196467708e-7,
-2.0887978518086072e-8,
2.525007497716575e-9,
-2.444461189578877e-10,
1.9782010705175946e-11,
-1.3702257726298314e-12,
// [9.5,10.]: m=36 maxabs=2.4993824691106267e-18 maxrel=1.825273267834949e-12
1.0758160923964958e-6,
-5.189720772879955e-7,
1.253278712283711e-7,
-2.0200111945739835e-8,
2.444459590759877e-9,
-2.368852731448662e-10,
1.9188277954588574e-11,
-1.330280903658179e-12,
// [9.5,10.]: m=37 maxabs=2.4301375256725877e-18 maxrel=1.838923500559871e-12
1.0379441545747797e-6,
-5.013114836511951e-7,
1.2120067179072328e-7,
-1.9555727217824696e-8,
2.368851180989677e-9,
-2.297746158383853e-10,
1.8628893903700447e-11,
-1.2925814056395194e-12,
// [9.5,10.]: m=38 maxabs=2.3653395052076337e-18 maxrel=1.8524402396444854e-12
1.0026229673012082e-6,
-4.848026859354264e-7,
1.1733436342039783e-7,
-1.895085854728992e-8,
2.297744645506673e-9,
-2.230753714172441e-10,
1.8100981119497082e-11,
-1.2569476904208855e-12,
// [9.5,10.]: m=39 maxabs=2.3032943418212562e-18 maxrel=1.8647972963210067e-12
9.696053718697033e-7,
-4.693374524870657e-7,
1.1370515139405749e-7,
-1.8382004945714168e-8,
2.230752243588985e-9,
-2.1675306801766218e-10,
1.7601972598678318e-11,
-1.223213491899193e-12,
// [9.5,10.]: m=40 maxabs=2.2448490684607095e-18 maxrel=1.8769149731448314e-12
9.386749049730114e-7,
-4.548206044129058e-7,
1.1029202978175706e-7,
-1.784606448165689e-8,
2.1675292477372652e-9,
-2.1077695704009408e-10,
1.712957110945411e-11,
-1.1912317484848256e-12
},
{
// [10.,10.5]: m=0 maxabs=1.1102230246251565e-16 maxrel=3.961582024432231e-16
0.27680913501250665,
-0.006750579939308897,
0.0002467568422952205,
-9.994833523432409e-6,
4.221170605463074e-7,
-1.8082833684735674e-8,
7.718880022084685e-10,
-3.2247039753817565e-11,
// [10.,10.5]: m=1 maxabs=2.949029909160572e-17 maxrel=2.104931448266398e-15
0.013501159878617124,
-0.0009870273691465477,
0.00005996900116594163,
-3.3769375653596498e-6,
1.8082811950901274e-7,
-9.253818988313109e-9,
4.520541885179563e-10,
-2.094526870085777e-11,
// [10.,10.5]: m=2 maxabs=2.168404344971009e-17 maxrel=1.0329448989256412e-14
0.001974054738292747,
-0.00023987600464910882,
0.000020261625394384237,
-1.446625536016574e-6,
9.25381554907887e-8,
-5.419119273753833e-9,
2.933469708617774e-10,
-1.4696625218322466e-11,
// [10.,10.5]: m=3 maxabs=1.6154612370034016e-17 maxrel=3.0915478501554705e-14
0.00047975200929805236,
-0.00008104650156653717,
8.67975321947174e-6,
-7.403056704983469e-7,
5.41911590843102e-8,
-3.5160790392576645e-9,
2.0584580947809666e-10,
-1.088729128467538e-11,
// [10.,10.5]: m=4 maxabs=1.3335686721571705e-17 maxrel=7.38330657541583e-14
0.0001620930031335041,
-0.000034719012862223315,
4.441834038992956e-6,
-4.3352971458850283e-7,
3.516052189548495e-8,
-2.4665961894593373e-9,
1.5329557815217812e-10,
-8.538314230702325e-12,
// [10.,10.5]: m=5 maxabs=1.1085967213664283e-17 maxrel=1.4031315811328995e-13
0.00006943802572444004,
-0.00001776733614923076,
2.601178288167167e-6,
-2.8128444479494594e-7,
2.4665953434918684e-8,
-1.8369583707985794e-9,
1.1956335613825018e-10,
-6.9032384938002566e-12,
// [10.,10.5]: m=6 maxabs=9.432558900623889e-18 maxrel=2.2903001226330704e-13
0.00003553467229845658,
-0.000010404713147062688,
1.6877066692503077e-6,
-1.9732785173518947e-7,
1.8369577254750227e-8,
-1.4326072525399067e-9,
9.66660451850216e-11,
-5.74174398284498e-12,
// [10.,10.5]: m=7 maxabs=8.175562006898507e-18 maxrel=3.336945850403564e-13
0.00002080942629403849,
-6.750826672251728e-6,
1.1839671108233689e-6,
-1.4695680886902412e-7,
1.4326067044024342e-8,
-1.1581605771399196e-9,
8.040196764705727e-11,
-4.88517423837336e-12,
// [10.,10.5]: m=8 maxabs=7.196391919872536e-18 maxrel=4.468392105003279e-13
0.000013501653344457608,
-4.735868439156764e-6,
8.817408535771626e-7,
-1.146087017063862e-7,
1.1581600948817138e-8,
-9.632361319057168e-10,
6.840785900441878e-11,
-4.23343879646509e-12,
// [10.,10.5]: m=9 maxabs=6.417121608398579e-18 maxrel=5.619519668429002e-13
9.471736878310258e-6,
-3.5269634106719105e-6,
6.876522105527088e-7,
-9.265295306483474e-8,
9.63235712501202e-9,
-8.194977188952524e-10,
5.928157039268416e-11,
-3.7243081129398335e-12,
// [10.,10.5]: m=10 maxabs=5.768294370801785e-18 maxrel=6.724224782956091e-13
7.053926821332225e-6,
-2.7506088389702975e-6,
5.559177186700462e-7,
-7.705898659054726e-8,
8.194973443769623e-9,
-7.101347558276647e-10,
5.215229996577959e-11,
-3.3176208787687474e-12,
// [10.,10.5]: m=11 maxabs=5.243133943504119e-18 maxrel=7.782247203986463e-13
5.501217677937982e-6,
-2.223670871763605e-6,
4.6235391979487444e-7,
-6.555990421080715e-8,
7.10134419761655e-9,
-6.247076610935926e-10,
4.645745842221784e-11,
-2.9865011559153177e-12,
// [10.,10.5]: m=12 maxabs=4.7959005473538485e-18 maxrel=8.754999467601085e-13
4.447341743524777e-6,
-1.8494156765307027e-6,
3.93359425497726e-7,
-5.68108595336065e-8,
6.247073512088711e-9,
-5.564723416234039e-10,
4.182091913724559e-11,
-2.712462091469298e-12,
// [10.,10.5]: m=13 maxabs=4.418970885825685e-18 maxrel=9.653935580237705e-13
3.6988313530591858e-6,
-1.573437699566843e-6,
3.408651574149121e-7,
-4.997668506321239e-8,
5.5647205734361914e-9,
-5.009201365754594e-10,
3.798356287721752e-11,
-2.4824024009458348e-12,
// [10.,10.5]: m=14 maxabs=1.2161699056677244e-17 maxrel=3.110835949845295e-12
3.146875399165942e-6,
-1.3634606278072452e-6,
2.9986010984682755e-7,
-4.4517845261633445e-8,
5.009203347885302e-9,
-4.5500272027458265e-10,
3.4753036543187844e-11,
-2.1699010213651326e-12,
// [10.,10.5]: m=15 maxabs=3.812918812065233e-18 maxrel=1.121867299647476e-12
2.7269212548509415e-6,
-1.199440440245281e-6,
2.671071236878191e-7,
-4.007367245220481e-8,
4.549449383605545e-9,
-4.1635092084491384e-10,
3.20239327892239e-11,
-2.118829126495821e-12,
// [10.,10.5]: m=16 maxabs=3.566855740887859e-18 maxrel=1.1897340532422858e-12
2.3988808804887652e-6,
-1.0684284928245455e-6,
2.4044203488549303e-7,
-3.639567213944407e-8,
4.163506913169159e-9,
-3.835473090524419e-10,
2.9670949085495157e-11,
-1.973034342713573e-12,
// [10.,10.5]: m=17 maxabs=3.3491682734435035e-18 maxrel=1.2512072815222764e-12
2.1368569856474016e-6,
-9.61768137739856e-7,
2.1837403299847543e-7,
-3.3308127391934334e-8,
3.835470935634191e-9,
-3.553593503389441e-10,
2.762937123901128e-11,
-1.8454464757803956e-12,
// [10.,10.5]: m=18 maxabs=8.131516293641283e-19 maxrel=3.368043000188224e-13
1.923536275479056e-6,
-8.73496130366895e-7,
1.9984876470616596e-7,
-3.068383423085885e-8,
3.5535891910029654e-9,
-3.3090689955977054e-10,
2.5848700376061573e-11,
-1.726780921996073e-12,
// [10.,10.5]: m=19 maxabs=2.9853676225977815e-18 maxrel=1.3591562144779174e-12
1.7469922606017092e-6,
-7.99395056418107e-7,
1.8410301120555987e-7,
-2.8428795641195028e-8,
3.3090241809734268e-9,
-3.0950027456013694e-10,
2.4267130662857424e-11,
-1.6330179127292456e-12,
// [10.,10.5]: m=20 maxabs=2.8299370767766174e-18 maxrel=1.4057250187083549e-12
1.598790112834795e-6,
-7.364120433147228e-7,
1.7057277398343193e-7,
-2.6472253749529875e-8,
3.0950009284391623e-9,
-2.9062666567295996e-10,
2.2868066025996964e-11,
-1.54374979769564e-12,
// [10.,10.5]: m=21 maxabs=2.68911784929559e-18 maxrel=1.4481263338645916e-12
1.4728240866281004e-6,
-6.822910945045508e-7,
1.5883352262638596e-7,
-2.4760064595859884e-8,
2.9062649342545118e-9,
-2.7386796954320053e-10,
2.1618008084542798e-11,
-1.4635384274051623e-12,
// [10.,10.5]: m=22 maxabs=2.5612158742601907e-18 maxrel=1.486939195060235e-12
1.3645821890078091e-6,
-6.353340891470912e-7,
1.485603876982859e-7,
-2.325017381273657e-8,
2.738678055057293e-9,
-2.588944411927208e-10,
2.0494784362628433e-11,
-1.3910906979509951e-12,
// [10.,10.5]: m=23 maxabs=2.445384118723165e-18 maxrel=1.5230603577880024e-12
1.2706681782929497e-6,
-5.94241549498747e-7,
1.3950104299492243e-7,
-2.1909476214973075e-8,
2.5889428291227836e-9,
-2.454403889567286e-10,
1.9480342833861392e-11,
-1.3253616069786874e-12,
// [10.,10.5]: m=24 maxabs=2.339716758553191e-18 maxrel=1.5565948964957208e-12
1.1884830989963221e-6,
-5.580041707439132e-7,
1.3145685740228972e-7,
-2.0711592064743022e-8,
2.4544023903392597e-9,
-2.332895666830663e-10,
1.85598595602481e-11,
-1.2654615183778758e-12,
// [10.,10.5]: m=25 maxabs=2.242096211382133e-18 maxrel=1.5872158766964695e-12
1.1160083414867056e-6,
-5.258274284269101e-7,
1.242695524959476e-7,
-1.963526641345881e-8,
2.332894233520832e-9,
-2.22264319635323e-10,
1.772104815152381e-11,
-1.2106601415958879e-12,
// [10.,10.5]: m=26 maxabs=2.1546400595781265e-18 maxrel=1.6174451486982917e-12
1.0516548568527385e-6,
-4.970782088506176e-7,
1.1781159858444107e-7,
-1.8663199195626323e-8,
2.22264181529622e-9,
-2.122174324255741e-10,
1.6953655603420683e-11,
-1.1603839364332193e-12,
// [10.,10.5]: m=27 maxabs=2.0707837977999508e-18 maxrel=1.6433014367117075e-12
9.94156417700291e-7,
-4.712463932487424e-7,
1.1197919526139239e-7,
-1.7781178064211122e-8,
2.1221731832875893e-9,
-2.030260374638191e-10,
1.624902963382045e-11,
-1.1139858318955571e-12,
// [10.,10.5]: m=28 maxabs=1.9930685248893687e-18 maxrel=1.6673118860363326e-12
9.424927864964868e-7,
-4.4791677999957656e-7,
1.0668706848094008e-7,
-1.6977427307047016e-8,
2.030259099095168e-9,
-1.9458667898711296e-10,
1.5599883340957606e-11,
-1.0711460987857113e-12,
// [10.,10.5]: m=29 maxabs=1.9223412737936346e-18 maxrel=1.6909636732270567e-12
8.958335599981918e-7,
-4.267482729165029e-7,
1.0186456393451779e-7,
-1.6242113083441994e-8,
1.94586556015239e-9,
-1.8681180889547289e-10,
1.499998001583015e-11,
-1.0314418917801255e-12,
// [10.,10.5]: m=30 maxabs=1.855849187434172e-18 maxrel=1.7125793898731917e-12
8.534965458320787e-7,
-4.0745825476684e-7,
9.745267858959347e-8,
-1.556696333070092e-8,
1.8681169031490123e-9,
-1.7962680535929594e-10,
1.44439808469475e-11,
-9.945444849725982e-13,
// [10.,10.5]: m=31 maxabs=1.7938040240477945e-18 maxrel=1.7328788961544015e-12
8.149165095327859e-7,
-3.8981071342072154e-7,
9.340178007000238e-8,
-1.494497273171774e-8,
1.7962669094429788e-9,
-1.7296770680571668e-10,
1.3927284493437602e-11,
-9.601682328520034e-13,
// [10.,10.5]: m=32 maxabs=1.735782267160875e-18 maxrel=1.7519841770212136e-12
7.796214268405743e-7,
-3.736071193737007e-7,
8.966983647353832e-8,
-1.4370171528064618e-8,
1.7296759585423535e-9,
-1.667793890036972e-10,
1.3445905240194573e-11,
-9.280669370159593e-13,
// [10.,10.5]: m=33 maxabs=1.6816780376550065e-18 maxrel=1.7702836970708578e-12
7.472142387465613e-7,
-3.5867934501717797e-7,
8.622102924894735e-8,
-1.3837442747328403e-8,
1.6677928159548106e-9,
-1.6101410434775473e-10,
1.2996374120586405e-11,
-8.980233788459209e-13,
// [10.,10.5]: m=34 maxabs=1.6300090278724942e-18 maxrel=1.7866433151460361e-12
7.173586900335426e-7,
-3.4488411614632675e-7,
8.302465656204976e-8,
-1.3342376506066025e-8,
1.6101400024572099e-9,
-1.5563029646585592e-10,
1.2575658508368161e-11,
-8.698475893708303e-13,
// [10.,10.5]: m=35 maxabs=1.5820457872342195e-18 maxrel=1.802811964549615e-12
6.897682322918648e-7,
-3.3209862542457606e-7,
8.005425911212663e-8,
-1.288115296424157e-8,
1.5563019551239998e-9,
-1.5059163592251635e-10,
1.218109585345983e-11,
-8.433722644057943e-13,
// [10.,10.5]: m=36 maxabs=1.5367295245561144e-18 maxrel=1.8180066545155985e-12
6.641972508483884e-7,
-3.2021703564921506e-7,
7.7286917858791e-8,
-1.245044761213157e-8,
1.5059153815494429e-9,
-1.4586623017907045e-10,
1.1810339485425221e-11,
-8.184478336634912e-13,
// [10.,10.5]: m=37 maxabs=1.493530844246145e-18 maxrel=1.831911972311764e-12
6.404340712976884e-7,
-3.091476706588385e-7,
7.470268574409469e-8,
-1.2047354105066889e-8,
1.4586613506076967e-9,
-1.414259693263913e-10,
1.1461313802940531e-11,
-7.94944017876884e-13,
// [10.,10.5]: m=38 maxabs=1.4530850210147522e-18 maxrel=1.8456015191841793e-12
6.182953413169539e-7,
-2.9881074222174317e-7,
7.228412469979197e-8,
-1.1669320990240915e-8,
1.414258768219481e-9,
-1.3724598642292342e-10,
1.1132175735007184e-11,
-7.727431677742798e-13,
// [10.,10.5]: m=39 maxabs=1.4145450219146816e-18 maxrel=1.8583139235809464e-12
5.976214844427821e-7,
-2.891364980650258e-7,
7.001592600895003e-8,
-1.1314099510869095e-8,
1.3724589643434176e-9,
-1.333042054208684e-10,
1.0821283663377678e-11,
-7.517405235997808e-13,
// [10.,10.5]: m=40 maxabs=1.3782284843011534e-18 maxrel=1.870722341481121e-12
5.782729961293658e-7,
-2.800637033211008e-7,
6.788459713097767e-8,
-1.097970030246775e-8,
1.3330411777973033e-9,
-1.2958096273670528e-10,
1.0527170778455814e-11,
-7.318416199087629e-13
},
{
// [10.5,11.]: m=0 maxabs=5.551115123125783e-17 maxrel=2.0297004015710748e-16
0.27029572185648826,
-0.006285448289492548,
0.00021913514145146604,
-8.4728296928364e-6,
3.422268131844245e-7,
-1.4066047622123804e-8,
5.785985202523054e-10,
-2.3402914926821186e-11,
// [10.5,11.]: m=1 maxabs=2.42861286636753e-17 maxrel=1.8649750167346127e-15
0.012570896578984282,
-0.0008765405657824668,
0.000050836978197376255,
-2.7378152816117934e-6,
1.4066017154007477e-7,
-6.936812506610048e-9,
3.2820277940721196e-10,
-1.4805405119039128e-11,
// [10.5,11.]: m=2 maxabs=1.474514954580286e-17 maxrel=7.931734564837422e-15
0.0017530811315645248,
-0.0002033479127792101,
0.000016426891691308853,
-1.1252817765718002e-6,
6.93681043653651e-8,
-3.93459557274311e-9,
2.0734166598742233e-10,
-1.0161353755055634e-11,
// [10.5,11.]: m=3 maxabs=1.1167282376600696e-17 maxrel=2.5304879965088253e-14
0.0004066958255584124,
-0.00006570756675796077,
6.751690660276536e-6,
-5.549451257290826e-7,
3.934594470577051e-8,
-2.485311017591835e-9,
1.4229313452858756e-10,
-7.432820773073039e-12,
// [10.5,11.]: m=4 maxabs=8.863352760068999e-18 maxrel=6.079455418238858e-14
0.00013141513351591573,
-0.000027006762635503833,
3.329670754977535e-6,
-3.14767781176147e-7,
2.485310200621451e-8,
-1.7053740321558176e-9,
1.0408589408780865e-10,
-5.712849321717116e-12,
// [10.5,11.]: m=5 maxabs=7.26415455565288e-18 maxrel=1.1875165035870007e-13
0.00005401352527100355,
-0.000013318683015452878,
1.8886066874596903e-6,
-1.9882499432655546e-7,
1.7053734921629623e-8,
-1.2473193293898727e-9,
7.99971807946513e-11,
-4.563684454435293e-12,
// [10.5,11.]: m=6 maxabs=6.118966010965066e-18 maxrel=1.9911585981322192e-13
0.000026637366030902266,
-7.554426746166635e-6,
1.1929499662883885e-6,
-1.3643002622378785e-7,
1.2473188920546572e-8,
-9.585565746835908e-10,
6.390557293666204e-11,
-3.758672773146894e-12,
// [10.5,11.]: m=7 maxabs=5.603969979034451e-18 maxrel=3.16385117308785e-13
0.000015108853492303542,
-4.77179986158395e-6,
8.185801568827893e-7,
-9.978564124580556e-8,
9.58556817832628e-9,
-7.656440731744691e-10,
5.2618989020568776e-11,
-3.2342615253923006e-12,
// [10.5,11.]: m=8 maxabs=9.24959978401696e-19 maxrel=8.156237375673351e-14
9.543599724093583e-6,
-3.274320627577209e-6,
5.987138121846718e-7,
-7.66846086367146e-8,
7.65676858923058e-9,
-6.305410396287151e-10,
4.4422125502883625e-11,
-2.7836883446614733e-12,
// [10.5,11.]: m=9 maxabs=4.092863201132779e-18 maxrel=5.201141117999795e-13
6.5486412555004225e-6,
-2.3948552450687815e-6,
4.601076282860728e-7,
-6.125425895539698e-8,
6.3056706723548385e-9,
-5.321201007091854e-10,
3.823184920814443e-11,
-2.3882165463554512e-12,
// [10.5,11.]: m=10 maxabs=3.668499694558375e-18 maxrel=6.315786873228192e-13
4.7897104901280525e-6,
-1.8404305110756068e-6,
3.6752555391090963e-7,
-5.044544807885064e-8,
5.32119862726768e-9,
-4.579882660924598e-10,
3.3442650823427534e-11,
-2.1171498561560345e-12,
// [10.5,11.]: m=11 maxabs=3.3178280543950944e-18 maxrel=7.37754047457315e-13
3.680861022149537e-6,
-1.4701022137901377e-6,
3.0267268863394027e-7,
-4.256966315730896e-8,
4.579880515869112e-9,
-4.006000742622336e-10,
2.96469643783105e-11,
-1.8979699550460402e-12,
// [10.5,11.]: m=12 maxabs=3.0277192699604966e-18 maxrel=8.377180733072204e-13
2.9402044275787487e-6,
-1.2106907528584264e-6,
2.5541797909047606e-7,
-3.6639111221881095e-8,
4.005998787168168e-9,
-3.5511945283362293e-10,
2.6577836927789564e-11,
-1.717665871658003e-12,
// [10.5,11.]: m=13 maxabs=2.7825032317303766e-18 maxrel=9.301630729970382e-13
2.4213815057154552e-6,
-1.021671914831449e-6,
2.1983466746569789e-7,
-3.204805151382575e-8,
3.551192735039091e-9,
-3.1834637271577225e-10,
2.405306296862977e-11,
-1.567111136753954e-12,
// [10.5,11.]: m=14 maxabs=2.5703214784431744e-18 maxrel=1.0139956159991077e-12
2.043343829661606e-6,
-8.793386684567698e-7,
1.9228830920715534e-7,
-2.840959812070203e-8,
3.183462070811689e-9,
-2.880968488205053e-10,
2.1944857657874667e-11,
-1.4397526859005784e-12,
// [10.5,11.]: m=15 maxabs=2.389056427730754e-18 maxrel=1.091271842902035e-12
1.7586773369123465e-6,
-7.691532355290111e-7,
1.7045758883877156e-7,
-2.5467748550128334e-8,
2.8809669617165664e-9,
-2.628392514742883e-10,
2.0161419268822012e-11,
-1.3307707052584197e-12,
// [10.5,11.]: m=16 maxabs=2.2306612665942e-18 maxrel=1.1615145632046464e-12
1.538306471056904e-6,
-6.818303541475169e-7,
1.5280649140830946e-7,
-2.3047783997029422e-8,
2.628391080914011e-9,
-2.4147331715133943e-10,
1.8635377330145738e-11,
-1.236573950809041e-12,
// [10.5,11.]: m=17 maxabs=2.0902655555867997e-18 maxrel=1.2247898967634733e-12
1.3636607082939792e-6,
-6.112259645058806e-7,
1.382867040831751e-7,
-2.102717374168184e-8,
2.4147318259647293e-9,
-2.2319162053284402e-10,
1.7316339501280787e-11,
-1.1544234436992423e-12,
// [10.5,11.]: m=18 maxabs=1.967445778234926e-18 maxrel=1.2832894385306862e-12
1.2224519290107757e-6,
-5.531468152758526e-7,
1.2616304254477817e-7,
-1.931789688133749e-8,
2.2319149432939975e-9,
-2.0739024817283283e-10,
1.6165964749650506e-11,
-1.0822011510112758e-12,
// [10.5,11.]: m=19 maxabs=1.8575432533286806e-18 maxrel=1.3363962853764623e-12
1.1062936305507718e-6,
-5.0465216918473e-7,
1.1590738137756726e-7,
-1.7855359321971714e-8,
2.0739012888533827e-9,
-1.9360973141616638e-10,
1.51546308052857e-11,
-1.0182523703415028e-12,
// [10.5,11.]: m=20 maxabs=1.7584403984999275e-18 maxrel=1.3844865043404583e-12
1.009304338368578e-6,
-4.6362952457152886e-7,
1.0713215601627885e-7,
-1.6591247860282388e-8,
1.9360961891377996e-9,
-1.814950962202071e-10,
1.4259131781878955e-11,
-9.612604679287673e-13,
// [10.5,11.]: m=21 maxabs=1.6699254555118531e-18 maxrel=1.4291613322156616e-12
9.272590491422231e-7,
-4.285286231762894e-7,
9.954748724175487e-8,
-1.5488805066303424e-8,
1.8149498953459318e-9,
-1.7076826883173104e-10,
1.3461059158443204e-11,
-9.10170579641432e-13,
// [10.5,11.]: m=22 maxabs=1.5894573255226946e-18 maxrel=1.4699335643520005e-12
8.570572463517833e-7,
-3.981899481231553e-7,
9.293283047408678e-8,
-1.451963291763705e-8,
1.7076816717811056e-9,
-1.6120866205672248e-10,
1.2745641117342367e-11,
-8.641287101779116e-13,
// [10.5,11.]: m=23 maxabs=1.5168242502956383e-18 maxrel=1.5080198082823672e-12
7.963798962455444e-7,
-3.7173132109317583e-7,
8.711779757852216e-8,
-1.3661485500751282e-8,
1.6120856519557968e-9,
-1.5263928054617273e-10,
1.2100900140903306e-11,
-8.224317321262039e-13,
// [10.5,11.]: m=24 maxabs=1.4495910101073282e-18 maxrel=1.5422777889928785e-12
7.434626421856232e-7,
-3.4847118954795156e-7,
8.196891307448546e-8,
-1.2896715860517485e-8,
1.526391872104531e-9,
-1.4491661211221748e-10,
1.1517031849213325e-11,
-7.845063648072568e-13,
// [10.5,11.]: m=25 maxabs=1.3882870005497983e-18 maxrel=1.5742951081906163e-12
6.969423790952062e-7,
-3.2787565156563383e-7,
7.738029522990905e-8,
-1.2211164268753575e-8,
1.4491652305534127e-9,
-1.379231812591396e-10,
1.0985938793254391e-11,
-7.498673914821528e-13,
// [10.5,11.]: m=26 maxabs=1.3318534304389805e-18 maxrel=1.6039309838112377e-12
6.557513031305999e-7,
-3.095211802183462e-7,
7.326698567662783e-8,
-1.1593349895824704e-8,
1.3792309575877494e-9,
-1.31561972926885e-10,
1.0500880015785747e-11,
-7.18112555449882e-13,
// [10.5,11.]: m=27 maxabs=1.2848431018663668e-18 maxrel=1.6379281451813187e-12
6.190423604360405e-7,
-2.930679420335148e-7,
6.956009943595421e-8,
-1.1033874573888652e-8,
1.3156189151585977e-9,
-1.257522121478409e-10,
1.0056184843538485e-11,
-6.889078538883799e-13,
// [10.5,11.]: m=28 maxabs=1.2313741470709391e-18 maxrel=1.656843126458251e-12
5.861358840668319e-7,
-2.7824039709946765e-7,
6.620324748790437e-8,
-1.0524977129457226e-8,
1.2575214162505035e-9,
-1.2042617935241967e-10,
9.64712533291325e-12,
-6.619401321185807e-13,
// [10.5,11.]: m=29 maxabs=1.1864814008664612e-18 maxrel=1.6805416453428576e-12
5.564807941983398e-7,
-2.6481298932953546e-7,
6.314986283379537e-8,
-1.006019621270199e-8,
1.2042610332509217e-9,
-1.1552663307144691e-10,
9.269594075338753e-12,
-6.36984385908371e-13,
// [10.5,11.]: m=30 maxabs=1.1450826655694073e-18 maxrel=1.7032416228067888e-12
5.296259786584944e-7,
-2.5259945073572836e-7,
6.036117733143065e-8,
-9.634112243642964e-9,
1.1552655948753153e-9,
-1.1100494529252561e-10,
8.920135469486276e-12,
-6.138206284210478e-13,
// [10.5,11.]: m=31 maxabs=1.1061191499957095e-18 maxrel=1.723999696979847e-12
5.051989014709012e-7,
-2.4144470874732844e-7,
5.780467351519507e-8,
-9.242147894465182e-9,
1.1100487417892052e-9,
-1.0681952608979062e-10,
8.595764338100238e-12,
-5.922646001355035e-13,
// [10.5,11.]: m=32 maxabs=1.0696967332637745e-18 maxrel=1.7434771714981585e-12
4.828894174941201e-7,
-2.3121869350200797e-7,
5.545288741825598e-8,
-8.880412284565412e-9,
1.0681945748015238e-9,
-1.0293461232301106e-10,
8.293899836789685e-12,
-5.721555713849687e-13,
// [10.5,11.]: m=33 maxabs=1.0361330527288229e-18 maxrel=1.7627319759094728e-12
4.62437387003497e-7,
-2.218115491326292e-7,
5.328247375717807e-8,
-8.545578213855792e-9,
1.0293454596511825e-9,
-9.931929047280084e-11,
8.012300855062381e-12,
-5.533534011252207e-13,
// [10.5,11.]: m=34 maxabs=1.0040516798515663e-18 maxrel=1.7799148605552035e-12
4.436230982647543e-7,
-2.1312989450550803e-7,
5.127346933150439e-8,
-8.23478460479275e-9,
9.931922598669932e-10,
-9.594670755787013e-11,
7.74901108449575e-12,
-5.357376718664088e-13,
// [10.5,11.]: m=35 maxabs=9.73770251987225e-19 maxrel=1.7959113930618513e-12
4.262597890105313e-7,
-2.0509387681899337e-7,
4.940870767532953e-8,
-7.945558360071021e-9,
9.594664542232102e-10,
-9.279343371494786e-11,
7.502316608769626e-12,
-5.191980874163204e-13,
// [10.5,11.]: m=36 maxabs=9.456064064910195e-19 maxrel=1.8117012452993498e-12
4.1018775363751463e-7,
-1.9763483020948133e-7,
4.76733502057584e-8,
-7.675751307204284e-9,
9.27933732420868e-10,
-8.983893429633508e-11,
7.270709159895562e-12,
-5.036413069189579e-13,
// [10.5,11.]: m=37 maxabs=9.191366268893227e-19 maxrel=1.8268847909134435e-12
3.9526966041850506e-7,
-1.906934003455152e-7,
4.605450788719017e-8,
-7.423488960147923e-9,
8.983887563741386e-10,
-8.706514196933933e-11,
7.0528564463784485e-12,
-4.889822076659783e-13,
// [10.5,11.]: m=38 maxabs=8.9351388023488e-19 maxrel=1.8400710984662416e-12
3.813868006905853e-7,
-1.8421803108475538e-7,
4.454093380365959e-8,
-7.187128611273073e-9,
8.706508490876672e-10,
-8.445609811848295e-11,
6.84757754202696e-12,
-4.751460477671295e-13,
// [10.5,11.]: m=39 maxabs=8.696910785933529e-19 maxrel=1.853463856127796e-12
3.68436062169078e-7,
-1.781637347634127e-7,
4.312277170925244e-8,
-6.965224841943629e-9,
8.445604259719104e-10,
-8.199765665967703e-11,
6.6538221026906695e-12,
-4.620655681718664e-13,
// [10.5,11.]: m=40 maxabs=8.468741285766902e-19 maxrel=1.865693332084166e-12
3.5632746952640286e-7,
-1.7249108639786845e-7,
4.1791349092277406e-8,
-6.75650097345528e-9,
8.199760247113076e-10,
-7.967723469513341e-11,
6.470652675615884e-12,
-4.4968168472389005e-13
},
{
// [11.,11.5]: m=0 maxabs=5.551115123125783e-17 maxrel=2.0774607158083475e-16
0.26422126459516876,
-0.00587129460661132,
0.00019563755745968133,
-7.233791664754482e-6,
2.7980858087649736e-7,
-1.1041807641498573e-8,
4.3767079272059e-10,
-1.7143995818485288e-11,
// [11.,11.5]: m=1 maxabs=2.0816681711721685e-17 maxrel=1.7140122245123301e-15
0.011742589213222819,
-0.000782550229822104,
0.0000434027500078712,
-2.2384691880657538e-6,
1.1041791475104533e-7,
-5.247483148557468e-9,
2.4041704519694147e-10,
-1.0961612405767627e-11,
// [11.,11.5]: m=2 maxabs=9.974659986866641e-18 maxrel=6.025610633548389e-15
0.0015651004596450796,
-0.00017361100001269842,
0.000013430815015266098,
-8.833438735053162e-7,
5.247662654217534e-8,
-2.881436010190734e-9,
1.4769272121073064e-10,
-7.072288040241756e-12,
// [11.,11.5]: m=3 maxabs=7.589415207398531e-18 maxrel=2.0213484697843157e-14
0.00034722200002538725,
-0.00005372326005608137,
5.30006324180449e-6,
-4.198132107428646e-7,
2.8814349943238755e-8,
-1.770409546068767e-9,
9.904473075626083e-11,
-5.076292019966356e-12,
// [11.,11.5]: m=4 maxabs=5.8140341499535175e-18 maxrel=4.8978301066863143e-14
0.00010744652011215846,
-0.00002120025296345257,
2.5188792648619317e-6,
-2.305149498855025e-7,
1.770409009242061e-8,
-1.1870951938635998e-9,
7.108540625232223e-11,
-3.841323462675023e-12,
// [11.,11.5]: m=5 maxabs=1.889899911913795e-17 maxrel=3.95355786946598e-13
0.00004240050592752692,
-0.000010075517055189877,
1.3830896879997129e-6,
-1.4163285779696008e-7,
1.1871015268114362e-8,
-8.518046891015636e-10,
5.3667258564501e-11,
-3.1484163121104294e-12,
// [11.,11.5]: m=6 maxabs=3.991219247462263e-18 maxrel=1.7246583033337055e-13
0.000020151034112969872,
-5.5323587958790714e-6,
8.497970350727768e-7,
-9.496768434504968e-8,
8.518882327577145e-9,
-6.445485745502712e-10,
4.242493776469143e-11,
-2.469217377861718e-12,
// [11.,11.5]: m=7 maxabs=3.4135427774348304e-18 maxrel=2.642940310555746e-13
0.000011064717591756273,
-3.3991881382732502e-6,
5.698061062489373e-7,
-6.815113932491412e-8,
6.445483368598143e-9,
-5.083245368745242e-10,
3.457664550917905e-11,
-2.065840932606988e-12,
// [11.,11.5]: m=8 maxabs=2.9663093812845598e-18 maxrel=3.6862338794531017e-13
6.798376276544936e-6,
-2.2792244232715095e-6,
4.0890683609842913e-7,
-5.1563935911063013e-8,
5.083243382894742e-9,
-4.142577361670284e-10,
2.8928133037714662e-11,
-1.7653259376482103e-12,
// [11.,11.5]: m=9 maxabs=2.614790708174025e-18 maxrel=4.789904744161903e-13
4.558448846541689e-6,
-1.6356273428944142e-6,
3.0938361559437236e-7,
-4.0666007024925904e-8,
4.142575655344937e-9,
-3.465620082474223e-10,
2.4720023264376957e-11,
-1.5348337130376399e-12,
// [11.,11.5]: m=10 maxabs=2.332728736738343e-18 maxrel=5.897595198630181e-13
3.271254685781306e-6,
-1.2375344610540638e-6,
2.439960422644777e-7,
-3.314065811967048e-8,
3.4656185518550355e-9,
-2.961326631801179e-10,
2.1492569998529362e-11,
-1.3536510664118698e-12,
// [11.,11.5]: m=11 maxabs=2.1031828080324277e-18 maxrel=6.972421288535587e-13
2.4750689221070607e-6,
-9.759841678779381e-7,
1.9884394882059964e-7,
-2.7724995611725795e-8,
2.961325262673999e-9,
-2.574577592717583e-10,
1.8955498576232194e-11,
-1.2082002337356898e-12,
// [11.,11.5]: m=12 maxabs=1.914717977268346e-18 maxrel=7.996739473421737e-13
1.9519683357549144e-6,
-7.953757942184762e-7,
1.6634997376250143e-7,
-2.369064465491865e-8,
2.574576364585703e-9,
-2.2705748634727547e-10,
1.6918731979412854e-11,
-1.0892959211352836e-12,
// [11.,11.5]: m=13 maxabs=1.7525111678691474e-18 maxrel=8.933586796695025e-13
1.5907515884360661e-6,
-6.653998940825544e-7,
1.4214386801446328e-7,
-2.0596649612342087e-8,
2.2705737308552144e-9,
-2.0265331599610658e-10,
1.5253767791064384e-11,
-9.905667284939223e-13,
// [11.,11.5]: m=14 maxabs=1.6165623798348322e-18 maxrel=9.80694270309871e-13
1.330799788164297e-6,
-5.68575471171563e-7,
1.2357989775194108e-7,
-1.816462529598112e-8,
2.02653212176031e-9,
-1.8270491140646383e-10,
1.3871255455156176e-11,
-9.074591099561723e-13,
// [11.,11.5]: m=15 maxabs=1.4986130419296709e-18 maxrel=1.0600615509819623e-12
1.1371509423423788e-6,
-4.943195901906469e-7,
1.0898775184786801e-7,
-1.621228965739483e-8,
1.8270481525386593e-9,
-1.6614131295581975e-10,
1.2707507571367295e-11,
-8.366607194829638e-13,
// [11.,11.5]: m=16 maxabs=1.3961220553119005e-18 maxrel=1.132417237905388e-12
9.886391803805948e-7,
-4.359510066339154e-7,
9.727373801155471e-8,
-1.4616415521838207e-8,
1.661412233380009e-9,
-1.5219919871761844e-10,
1.1716118725334007e-11,
-7.757095730504808e-13,
// [11.,11.5]: m=17 maxabs=1.3065483211397583e-18 maxrel=1.1985195099503597e-12
8.719020132671774e-7,
-3.8909495134036654e-7,
8.769849319362538e-8,
-1.329132610013288e-8,
1.5219911530423076e-9,
-1.4032239314638992e-10,
1.0862602455250324e-11,
-7.227400646342109e-13,
// [11.,11.5]: m=18 maxabs=1.2273507405714812e-18 maxrel=1.258643380530398e-12
7.78189902680119e-7,
-3.507939721139738e-7,
7.97479566597434e-8,
-1.2175955644270678e-8,
1.4032231453467122e-9,
-1.3009760416919947e-10,
1.012087656638298e-11,
-6.763241396921598e-13,
// [11.,11.5]: m=19 maxabs=1.1574705224230014e-18 maxrel=1.3140586548090106e-12
7.015879442273703e-7,
-3.1899182601848684e-7,
7.305573392100034e-8,
-1.1225809981392411e-8,
1.300975303442815e-9,
-1.2121226322851605e-10,
9.470899829699593e-12,
-6.353435245955197e-13,
// [11.,11.5]: m=20 maxabs=1.0942606887341493e-18 maxrel=1.3638803958530706e-12
6.379836520364267e-7,
-2.922229350990755e-7,
6.735485994085085e-8,
-1.0407825823622512e-8,
1.2121219321881904e-9,
-1.1342620044149056e-10,
8.897050022295423e-12,
-5.989190505588357e-13,
// [11.,11.5]: m=21 maxabs=1.0372977230312976e-18 maxrel=1.4092688730152636e-12
5.844458701976343e-7,
-2.69419439210303e-7,
6.244695499150428e-8,
-9.696997580853628e-9,
1.1342613405264452e-9,
-1.0655221889936952e-10,
8.386991812673774e-12,
-5.663459465405749e-13,
// [11.,11.5]: m=22 maxabs=9.866875044328531e-19 maxrel=1.452116330229472e-12
5.388388784201124e-7,
-2.4978781944157563e-7,
5.818198553272738e-8,
-9.074111702941668e-9,
1.0655215551528372e-9,
-1.0044250491145237e-10,
7.930869370992286e-12,
-5.370570738457216e-13,
// [11.,11.5]: m=23 maxabs=9.406300879259005e-19 maxrel=1.4914486828638075e-12
4.99575638882678e-7,
-2.3272794163226736e-7,
5.4444670262731134e-8,
-8.524192386290955e-9,
1.0044244481732898e-9,
-9.497896167924596e-11,
7.520722166898202e-12,
-5.105852956601999e-13,
// [11.,11.5]: m=24 maxabs=8.982784405631855e-19 maxrel=1.527169572121992e-12
4.6545588326408225e-7,
-2.1777868057569614e-7,
5.114515436158128e-8,
-8.035414591929948e-9,
9.497890334012963e-10,
-9.006620765092947e-11,
7.150057928624146e-12,
-4.865552589032178e-13,
// [11.,11.5]: m=25 maxabs=8.597384414631148e-19 maxrel=1.5605797169870195e-12
4.3555736115096443e-7,
-2.0458061699257108e-7,
4.8212487592749496e-8,
-7.598330417258783e-9,
9.006615270152873e-10,
-8.562645399312754e-11,
6.8135330435511764e-12,
-4.646450717071498e-13,
// [11.,11.5]: m=26 maxabs=8.237395412048071e-19 maxrel=1.5904133349598093e-12
4.0916123398473273e-7,
-1.928499499368346e-7,
4.558998254291644e-8,
-7.205309582632511e-9,
8.562640146524184e-10,
-8.159567645878554e-11,
6.506712891071111e-12,
-4.445909747856777e-13,
// [11.,11.5]: m=27 maxabs=7.912346518539233e-19 maxrel=1.6193992895208706e-12
3.856998998732754e-7,
-1.8235992975548995e-7,
4.323185753363006e-8,
-6.850128764272636e-9,
8.159562599908858e-10,
-7.792074183614854e-11,
6.225888469760295e-12,
-4.2617021308394116e-13,
// [11.,11.5]: m=28 maxabs=7.627002294432941e-19 maxrel=1.6497027479206645e-12
3.647198595105938e-7,
-1.7292742973508245e-7,
4.110077262165281e-8,
-6.527666061744977e-9,
7.792069373957456e-10,
-7.455722368135825e-11,
5.967925226716167e-12,
-4.091826530798355e-13,
// [11.,11.5]: m=29 maxabs=7.326305598157664e-19 maxrel=1.670094781908722e-12
3.458548594694748e-7,
-1.6440309010369372e-7,
3.9165996418051947e-8,
-6.2336708370406225e-9,
7.455716842134395e-10,
-7.146767008972083e-11,
5.730206709179052e-12,
-3.9350000516312465e-13,
// [11.,11.5]: m=30 maxabs=7.065842966876967e-19 maxrel=1.6933050797518303e-12
3.2880618020703667e-7,
-1.5666398530214603e-7,
3.740202505597527e-8,
-5.964588276211418e-9,
7.146762507522254e-10,
-6.862037512047917e-11,
5.510441286675339e-12,
-3.789507695682704e-13,
// [11.,11.5]: m=31 maxabs=6.821262203357287e-19 maxrel=1.7145802138344373e-12
3.133279706039538e-7,
-1.4960809986703472e-7,
3.578752968980977e-8,
-5.717424280395051e-9,
6.862033169513817e-10,
-6.59882612936356e-11,
5.306701035831919e-12,
-3.6542620722577396e-13,
// [11.,11.5]: m=32 maxabs=6.592033912006592e-19 maxrel=1.7343034658108407e-12
2.992161997337416e-7,
-1.4315011841468397e-7,
3.430454571389706e-8,
-5.489640317665331e-9,
6.598821922347794e-10,
-6.354810424016043e-11,
5.1173138339347925e-12,
-3.5282354803653857e-13,
// [11.,11.5]: m=33 maxabs=6.379746279600983e-19 maxrel=1.7534223451877148e-12
2.8630023682905094e-7,
-1.3721818252253532e-7,
3.293784193644484e-8,
-5.2790708600217215e-9,
6.35480636148694e-10,
-6.127987232246473e-11,
4.9408302160046546e-12,
-3.4105204634908904e-13,
// [11.,11.5]: m=34 maxabs=6.179105350220121e-19 maxrel=1.7709924493738585e-12
2.744363650447639e-7,
-1.3175136742347807e-7,
3.167442518961112e-8,
-5.083857981067389e-9,
6.127983299200502e-10,
-5.916620059725667e-11,
4.775987615041238e-12,
-3.300325916788934e-13,
// [11.,11.5]: m=35 maxabs=5.991699310640107e-19 maxrel=1.7878784237271271e-12
2.6350273484665725e-7,
-1.2669770044623478e-7,
3.050314791510817e-8,
-4.902399127599963e-9,
5.916616231474595e-10,
-5.719196482353271e-11,
4.621681566066466e-12,
-3.196966273731452e-13,
// [11.,11.5]: m=36 maxabs=5.816469369676874e-19 maxrel=1.8042025206717209e-12
2.5339540089217903e-7,
-1.2201259135771246e-7,
2.941439479346798e-8,
-4.73330509393174e-9,
5.719192766601612e-10,
-5.534393506765378e-11,
4.476941970816422e-12,
-3.099826470846576e-13,
// [11.,11.5]: m=37 maxabs=5.648121571410081e-19 maxrel=1.8186765247649746e-12
2.4402518271514265e-7,
-1.1765757888008395e-7,
2.8399830590675307e-8,
-4.575365964731642e-9,
5.534389894308266e-10,
-5.361048983075385e-11,
4.340913385000327e-12,
-3.008368003195858e-13,
// [11.,11.5]: m=38 maxabs=5.492479267352104e-19 maxrel=1.833475750724314e-12
2.3531515775989348e-7,
-1.1359932207733247e-7,
2.745219581471678e-8,
-4.4275233300684796e-9,
5.361045472865276e-10,
-5.198138098268357e-11,
4.212838441431658e-12,
-2.9221072976699107e-13,
// [11.,11.5]: m=39 maxabs=5.341072128030398e-19 maxrel=1.8461124711319927e-12
2.2719864415439783e-7,
-1.0980878298145938e-7,
2.656514000604579e-8,
-4.288847474531829e-9,
5.198134679133707e-10,
-5.044753778622209e-11,
4.0920447118052445e-12,
-2.84062047086337e-13,
// [11.,11.5]: m=40 maxabs=5.200782296141404e-19 maxrel=1.8591880977851484e-12
2.196175659626586e-7,
-1.062605597543035e-7,
2.573308487214118e-8,
-4.15851853841195e-9,
5.04475045267838e-10,
-4.900090403988327e-11,
3.977932833636581e-12,
-2.763522134904623e-13
},
{
// [11.5,12.]: m=0 maxabs=0. maxrel=0.
0.25853864294198275,
-0.005500654332279458,
0.00017551083334924674,
-6.216794329894424e-6,
2.3060207570098543e-7,
-8.744189051106713e-9,
3.3404713016428245e-10,
-1.2563192702964086e-11,
// [11.5,12.]: m=1 maxabs=1.3877787807814457e-17 maxrel=1.2214328522303118e-15
0.011001308664559771,
-0.0007020433333798314,
0.000037300766006450794,
-1.8448169959875445e-6,
8.744142208426338e-8,
-4.0055773036889986e-9,
1.775252546503511e-10,
-7.571364555419014e-12,
// [11.5,12.]: m=2 maxabs=9.75781955236954e-17 maxrel=6.586243868065359e-14
0.0014040866667522007,
-0.00014920306403914997,
0.000011068902110751852,
-6.995312945431504e-7,
4.005500952079887e-8,
-2.12977772550803e-9,
1.0738090969710336e-10,
-2.872214577228872e-12,
// [11.5,12.]: m=3 maxabs=4.87890977618477e-18 maxrel=1.516910470184411e-14
0.00029840612804131976,
-0.00004427560790344808,
4.19718945507616e-6,
-3.2044622978576787e-7,
2.1284242909854838e-8,
-1.271142893059142e-9,
6.942485183549863e-11,
-3.4878662954542807e-12,
// [11.5,12.]: m=4 maxabs=3.903127820947816e-18 maxrel=4.0053290150158005e-14
0.00008855121580689286,
-0.0000167887578177627,
1.9226773790236746e-6,
-1.7027404483740984e-7,
1.2711424909062493e-8,
-8.321240452251456e-10,
4.8842740138285445e-11,
-2.5962232269272834e-12,
// [11.5,12.]: m=5 maxabs=3.1374100366299285e-18 maxrel=8.323912249743289e-14
0.00003357751563552328,
-7.690709514118438e-6,
1.0216442692267821e-6,
-1.0169147825058578e-7,
8.321237774173403e-9,
-5.85355074326213e-10,
3.6355655441234266e-11,
-2.0202068562807926e-12,
// [11.5,12.]: m=6 maxabs=6.406957213031528e-18 maxrel=3.6432258083358285e-13
0.000015381419028240763,
-4.086577074929881e-6,
6.101488708517451e-7,
-6.656997140792438e-8,
5.853535256162874e-9,
-4.35631850736833e-10,
2.8324406803311714e-11,
-1.6646098564243118e-12,
// [11.5,12.]: m=7 maxabs=2.2073678605447067e-18 maxrel=2.3236812012948293e-13
8.173154150631527e-6,
-2.440595477282653e-6,
3.994197949624657e-7,
-4.682844325514654e-8,
4.356570871003455e-9,
-3.3896195184610886e-10,
2.280008905537396e-11,
-1.3497167363555394e-12,
// [11.5,12.]: m=8 maxabs=1.9083652301639387e-18 maxrel=3.3160987200038684e-13
4.881190954564302e-6,
-1.5976791787320504e-6,
2.8097065962764524e-7,
-3.485261167895187e-8,
3.3896182290661614e-9,
-2.7317185639591556e-10,
1.890015359060953e-11,
-1.1445370985770424e-12,
// [11.5,12.]: m=9 maxabs=1.6745841367217518e-18 maxrel=4.391607382226453e-13
3.195358357463237e-6,
-1.1238826375450246e-6,
2.0911567015690917e-7,
-2.711698445411429e-8,
2.7317174533630064e-9,
-2.2643107847950538e-10,
1.6027072907124635e-11,
-9.88699911373966e-13,
// [11.5,12.]: m=10 maxabs=1.1934694226813092e-18 maxrel=4.4046750840333623e-13
2.2477652750857445e-6,
-8.364626797574041e-7,
1.6270190683028758e-7,
-2.185377378414389e-8,
2.2643095368855525e-9,
-1.9199809791301026e-10,
1.384554675360713e-11,
-8.701398959068976e-13,
// [11.5,12.]: m=11 maxabs=1.3361944742936588e-18 maxrel=6.570911170161972e-13
1.6729253595574013e-6,
-6.508076264408662e-7,
1.3112264109899165e-7,
-1.811450853848663e-8,
1.9199956301193416e-9,
-1.6585020847523394e-10,
1.214413110109494e-11,
-7.704567060830118e-13,
// [11.5,12.]: m=12 maxabs=1.2112571145736495e-18 maxrel=7.603333226622514e-13
1.3016152528811237e-6,
-5.24490563720263e-7,
1.0868705128966466e-7,
-1.5359992068035047e-8,
1.658501300676173e-9,
-1.454701200199253e-10,
1.0788902755881024e-11,
-6.918614561556025e-13,
// [11.5,12.]: m=13 maxabs=1.1066485455877434e-18 maxrel=8.571037783973382e-13
1.0489811274399723e-6,
-4.3474820454638484e-7,
9.215995246154259e-8,
-1.3268034896729552e-8,
1.4547004886752728e-9,
-1.2923171584547507e-10,
9.688337461880014e-12,
-6.269771907622331e-13,
// [11.5,12.]: m=14 maxabs=1.0177100861260419e-18 maxrel=9.464802474115576e-13
8.694964090922589e-7,
-3.6863980928694384e-7,
7.960820942959463e-8,
-1.1637626278453303e-8,
1.2923165016976965e-9,
-1.1604530762501087e-10,
8.779782656574381e-12,
-5.726427777806866e-13,
// [11.5,12.]: m=15 maxabs=9.411594835179345e-19 maxrel=1.0282291690600074e-12
7.372796185734158e-7,
-3.184328372041592e-7,
6.982575771615246e-8,
-1.0338552582362291e-8,
1.160452470040069e-9,
-1.0515993004415051e-10,
8.018939193590969e-12,
-5.265689007947203e-13,
// [11.5,12.]: m=16 maxabs=8.754085509873194e-19 maxrel=1.1035660700259534e-12
6.368656744078806e-7,
-2.793030303889663e-7,
6.203131553627384e-8,
-9.283638786213662e-9,
1.051598738660826e-9,
-9.604462107773003e-11,
7.373762828339825e-12,
-4.870659951532744e-13,
// [11.5,12.]: m=17 maxabs=8.17280914981993e-19 maxrel=1.1713785068248093e-12
5.586060607775243e-7,
-2.481252617028463e-7,
5.570183275654297e-8,
-8.412807599208304e-9,
9.604456871920845e-10,
-8.831533034144746e-11,
6.820599612452705e-12,
-4.5286396776296645e-13,
// [11.5,12.]: m=18 maxabs=7.667765755019554e-19 maxrel=1.234165168143934e-12
4.962505234053091e-7,
-2.2280733061310733e-7,
5.0476845632102065e-8,
-7.683582020383408e-9,
8.83152811850298e-10,
-8.168857426471125e-11,
6.341668761663158e-12,
-4.2299316370731873e-13,
// [11.5,12.]: m=19 maxabs=7.2198970841588425e-19 maxrel=1.2915034719882127e-12
4.4561466122585413e-7,
-2.0190738214101637e-7,
4.610149215694854e-8,
-7.06523799065302e-9,
8.168852804357802e-10,
-7.595126353458539e-11,
5.9233836233604834e-12,
-3.96700541140677e-13,
// [11.5,12.]: m=20 maxabs=6.814380060660846e-19 maxrel=1.34278190231073e-12
4.03814764281692e-7,
-1.8440596826317015e-7,
4.2391427976716464e-8,
-6.535096828862087e-9,
7.595121977146229e-10,
-7.094058148570375e-11,
5.555208532250915e-12,
-3.733960370614091e-13,
// [11.5,12.]: m=21 maxabs=6.455449849261836e-19 maxrel=1.390650976361201e-12
3.688119365260203e-7,
-1.6956571156252878e-7,
3.9210581004056806e-8,
-6.076111355222968e-9,
7.094054028047912e-10,
-6.653027567579705e-11,
5.22886342342484e-12,
-3.5260745400661963e-13,
// [11.5,12.]: m=22 maxabs=6.132518538121134e-19 maxrel=1.4347765046190927e-12
3.3913142312475093e-7,
-1.5684232369008367e-7,
3.645666816078755e-8,
-5.675256267782301e-9,
6.653023640399977e-10,
-6.262112672945303e-11,
4.937760910869131e-12,
-3.3395723297167253e-13,
// [11.5,12.]: m=23 maxabs=5.837115797766197e-19 maxrel=1.4746997611808701e-12
3.136846473798796e-7,
-1.458266723335059e-7,
3.4051537634823944e-8,
-5.322431299606595e-9,
6.262108916278622e-10,
-5.913420703484837e-11,
4.676603641485462e-12,
-3.171390965694869e-13,
// [11.5,12.]: m=24 maxabs=5.569241628197025e-19 maxrel=1.5117169209333226e-12
2.9165334466673087e-7,
-1.3620615024447632e-7,
3.1934587824279106e-8,
-5.009698925816582e-9,
5.913417148243875e-10,
-5.600603212043582e-11,
4.441085673556562e-12,
-3.018990607841132e-13,
// [11.5,12.]: m=25 maxabs=5.3246608646773455e-19 maxrel=1.5459605875185647e-12
2.724123004886864e-7,
-1.277383510158235e-7,
3.005819358044156e-8,
-4.730744969970324e-9,
5.600599808115209e-10,
-5.318501631654404e-11,
4.227675820421991e-12,
-2.880292064798788e-13,
// [11.5,12.]: m=26 maxabs=5.099667738062922e-19 maxrel=1.577456750294134e-12
2.5547670203139243e-7,
-1.202327740528641e-7,
2.8384469844294965e-8,
-4.480490602522089e-9,
5.318498368015758e-10,
-5.0628851725866665e-11,
4.033453374031851e-12,
-2.753557414605839e-13,
// [11.5,12.]: m=27 maxabs=4.891085874801551e-19 maxrel=1.6061609172896363e-12
2.4046554810548406e-7,
-1.1353787911962852e-7,
2.68829436386128e-8,
-4.254808996445796e-9,
5.062882040985809e-10,
-4.8302540874607184e-11,
3.85598264843482e-12,
-2.637324259513774e-13,
// [11.5,12.]: m=28 maxabs=4.701032857261367e-19 maxrel=1.633654015904309e-12
2.2707575823902236e-7,
-1.0753177430734678e-7,
2.5528854001252715e-8,
-4.050315516942038e-9,
4.830251075218994e-10,
-4.617690357777681e-11,
3.6932181142395035e-12,
-2.5303603099084244e-13,
// [11.5,12.]: m=29 maxabs=4.514156213273387e-19 maxrel=1.6552951070391578e-12
2.1506354861446862e-7,
-1.021154157675299e-7,
2.430189312323598e-8,
-3.864210359376629e-9,
4.617687481135393e-10,
-4.422742503874378e-11,
3.5434247150222285e-12,
-2.43179660480879e-13,
// [11.5,12.]: m=30 maxabs=4.360102095991511e-19 maxrel=1.6826462829507172e-12
2.0423083153487536e-7,
-9.72075722648634e-8,
2.318526217304513e-8,
-3.694159113789775e-9,
4.4227403963250053e-10,
-4.243340127001072e-11,
3.4051458165511965e-12,
-2.34017550434132e-13,
// [11.5,12.]: m=31 maxabs=4.208165561077771e-19 maxrel=1.7051119088539869e-12
1.9441514452951662e-7,
-9.274104847193195e-8,
2.2164954702916534e-8,
-3.5382011268409624e-9,
4.243337437787969e-10,
-4.0777176468035656e-11,
3.2771060163771047e-12,
-2.2552816065306329e-13,
// [11.5,12.]: m=32 maxabs=4.0657581468206416e-19 maxrel=1.7259205933354966e-12
1.8548209694366077e-7,
-8.865981859913327e-8,
2.1229206780544994e-8,
-3.39467845134994e-9,
4.0777150474764525e-10,
-3.924366210966891e-11,
3.1582259148722244e-12,
-2.1762591426853875e-13,
// [11.5,12.]: m=33 maxabs=3.9323504576280893e-19 maxrel=1.7453562527567357e-12
1.7731963719807035e-7,
-8.491682691685282e-8,
2.0368070726957325e-8,
-3.262180250998895e-9,
3.924363696693551e-10,
-3.7819866179349396e-11,
3.0475673564149712e-12,
-2.102525921924337e-13,
// [11.5,12.]: m=34 maxabs=3.806883702316046e-19 maxrel=1.7634231571046724e-12
1.6983365383351565e-7,
-8.147228270923394e-8,
1.9573081524239996e-8,
-3.1394989010014955e-9,
3.781984184957733e-10,
-3.6494549436968896e-11,
2.9443148682708938e-12,
-2.0335739329621733e-13,
// [11.5,12.]: m=35 maxabs=3.689622578680529e-19 maxrel=1.7806875463656145e-12
1.6294456541828408e-7,
-7.829232590467346e-8,
1.8836993423666736e-8,
-3.0255950392908715e-9,
3.649452590454638e-10,
-3.5257942340532083e-11,
2.8477561641186945e-12,
-1.9689524752801303e-13,
// [11.5,12.]: m=36 maxabs=3.579243597741453e-19 maxrel=1.7969432305615152e-12
1.5658465180916777e-7,
-7.534797350831408e-8,
1.8153570252938732e-8,
-2.9195695265073997e-9,
3.525791941737439e-10,
-3.41015138877754e-11,
2.757266978323804e-12,
-1.908276809807726e-13,
// [11.5,12.]: m=37 maxabs=3.475217363906784e-19 maxrel=1.8122988619506358e-12
1.5069594701645495e-7,
-7.261428083097192e-8,
1.7517417175679895e-8,
-2.820640784645615e-9,
3.410149170604195e-10,
-3.301778391664819e-11,
2.672297376234521e-12,
-1.85119333992875e-13,
// [11.5,12.]: m=38 maxabs=3.3770144815844887e-19 maxrel=1.8268248166977684e-12
1.4522856166177544e-7,
-7.006966852719821e-8,
1.6923844724057074e-8,
-2.728126357454125e-9,
3.301776232829745e-10,
-3.200016652932493e-11,
2.5923616653244327e-12,
-1.7973986429810965e-13,
// [11.5,12.]: m=39 maxabs=3.2846349507745665e-19 maxrel=1.8408493469101906e-12
1.401393370542328e-7,
-6.769537872566064e-8,
1.6368758160436406e-8,
-2.641427808961784e-9,
3.200014557294704e-10,
-3.104284200264197e-11,
2.517028852409117e-12,
-1.7466152483478855e-13,
// [11.5,12.]: m=40 maxabs=3.197284678088967e-19 maxrel=1.8542422012152487e-12
1.3539075745116174e-7,
-6.547503247586803e-8,
1.58485668690999e-8,
-2.5600182809779324e-9,
3.104282155888455e-10,
-3.014064871945586e-11,
2.44591555549379e-12,
-1.6986028833437294e-13
},
{
// [12.,12.5]: m=0 maxabs=5.551115123125783e-17 maxrel=2.1698331247411737e-16
0.2532075048282792,
-0.005167402443078996,
0.00015816137521131442,
-5.375569627432378e-6,
1.9147597502646364e-7,
-6.983014820613868e-9,
2.5721663038514465e-10,
-9.29766968991927e-12,
// [12.,12.5]: m=1 maxabs=6.938893903907228e-18 maxrel=6.509655714306437e-16
0.010334804886158603,
-0.0006326455008384624,
0.000032253417812114887,
-1.531808060640137e-6,
6.982948514037984e-8,
-3.084344241924467e-9,
1.3225545368793587e-10,
-5.4694675813107406e-12,
// [12.,12.5]: m=2 maxabs=4.553649124439119e-18 maxrel=3.4182260203197997e-15
0.001265291001676881,
-0.00012901367124474298,
9.190848368117546e-6,
-5.586360246945974e-7,
3.084338777461824e-8,
-1.585726224602128e-9,
7.674142959170242e-11,
-3.4992049170273532e-12,
// [12.,12.5]: m=3 maxabs=3.3610267347050637e-18 maxrel=1.2121467780654626e-14
0.0002580273424894782,
-0.00003676339347008628,
3.3518161487458823e-6,
-2.4674719701308915e-7,
1.5857254714391726e-8,
-9.199902286994546e-10,
4.90133620326404e-11,
-2.41167165880385e-12,
// [12.,12.5]: m=4 maxabs=2.6156377411212794e-18 maxrel=3.2445241412559835e-14
0.00007352678694017058,
-0.000013407264593253426,
1.480483182266363e-6,
-1.2685810676284258e-7,
9.199899800961628e-9,
-5.874982904165944e-10,
3.377134247292958e-11,
-1.7642961604936246e-12,
// [12.,12.5]: m=5 maxabs=2.0735366548785272e-18 maxrel=6.917469741312571e-14
0.00002681452918650526,
-5.92193272774357e-6,
7.611486407184293e-7,
-7.359925126387749e-8,
5.874981091934627e-9,
-4.047486624142967e-10,
2.4705789259624785e-11,
-1.3533375657055343e-12,
// [12.,12.5]: m=6 maxabs=1.7059243557701609e-18 maxrel=1.265269172048933e-13
0.000011843865455486127,
-3.044594561820344e-6,
4.4159550767773043e-7,
-4.699989085349456e-8,
4.0474853756765786e-9,
-2.960652069372823e-10,
1.8950699697042555e-11,
-1.077913700126231e-12,
// [12.,12.5]: m=7 maxabs=1.4374149114905477e-18 maxrel=2.039719691560984e-13
6.089189123639913e-6,
-1.7663820298464683e-6,
2.819993451952247e-7,
-3.237991757505073e-8,
2.9606510773558944e-9,
-2.2707656819407595e-10,
1.509397300347109e-11,
-8.848076458416193e-13,
// [12.,12.5]: m=8 maxabs=1.2332799712022613e-18 maxrel=2.9728757260581463e-13
3.532764059692292e-6,
-1.1279973800540505e-6,
1.9427950551261433e-7,
-2.3685237690225493e-8,
2.270764847874466e-9,
-1.808486010260843e-10,
1.2389982178604613e-11,
-7.441870078229867e-13,
// [12.,12.5]: m=9 maxabs=2.769797737521562e-18 maxrel=1.0325548832671612e-12
2.255994760098629e-6,
-7.771180215257838e-7,
1.4211142638595605e-7,
-1.8166141477011733e-8,
1.8084840753304177e-9,
-1.4845528840855801e-10,
1.042331923600777e-11,
-6.081290853824343e-13,
// [12.,12.5]: m=10 maxabs=9.512179997665793e-19 maxrel=5.093227484979241e-13
1.5542360428535233e-6,
-5.684457042409141e-7,
1.0899686238013258e-7,
-1.4467903973380994e-8,
1.484403012765347e-9,
-1.2484275476824904e-10,
8.94056020486699e-12,
-5.567942097881614e-13,
// [12.,12.5]: m=11 maxabs=8.499975625696904e-19 maxrel=6.167657931595862e-13
1.1368914084780515e-6,
-4.3598744903989757e-7,
8.680742388235988e-8,
-1.1875243329026641e-8,
1.2484269876508712e-9,
-1.071021415320293e-10,
7.796910493223058e-12,
-4.922220609920487e-13,
// [12.,12.5]: m=12 maxabs=4.22796495621984e-18 maxrel=3.9709603951396165e-12
8.719748980807925e-7,
-3.472296951469278e-7,
7.12514599614452e-8,
-9.987431564986261e-9,
1.0710203497185026e-9,
-9.340750015789728e-11,
6.895905786674931e-12,
-4.2326851490717144e-13,
// [12.,12.5]: m=13 maxabs=6.993315770768317e-19 maxrel=8.197768518927976e-13
6.944593901988957e-7,
-2.8500583965794145e-7,
5.992459859867414e-8,
-8.568182864118096e-9,
9.339782780009366e-10,
-8.256338302006119e-11,
6.163424340717814e-12,
-3.9740660978447135e-13,
// [12.,12.5]: m=14 maxabs=6.413098201899121e-19 maxrel=9.113383412587276e-13
5.700116793155594e-7,
-2.396983940413464e-7,
5.1409097215882885e-8,
-7.471840357607905e-9,
8.256334144420891e-10,
-7.38254112169503e-11,
5.565022860447611e-12,
-3.61813033729121e-13,
// [12.,12.5]: m=15 maxabs=5.914407554203152e-19 maxrel=9.951944404185003e-13
4.793967880823965e-7,
-2.0563638853952675e-7,
4.4831042174150404e-8,
-6.605080275606253e-9,
7.382537318801269e-10,
-6.665585833903244e-11,
5.066599752889041e-12,
-3.3177449295449295e-13,
// [12.,12.5]: m=16 maxabs=2.671753673876877e-18 maxrel=5.2221001187774206e-12
4.1127277707724466e-7,
-1.793241684500029e-7,
3.963048173553311e-8,
-5.906040120650273e-9,
6.665588587415242e-10,
-6.069505464548692e-11,
4.6424256629903965e-12,
-2.8745315758266895e-13,
// [12.,12.5]: m=17 maxabs=5.116079001415974e-19 maxrel=1.1433226234486736e-12
3.5864833679502237e-7,
-1.5852192644305789e-7,
3.5436250904748324e-8,
-5.332476936501886e-9,
6.068436490979416e-10,
-5.564517212420422e-11,
4.2868807618647076e-12,
-2.8401347350835486e-13,
// [12.,12.5]: m=18 maxabs=4.788912525539001e-19 maxrel=1.2076185970558367e-12
3.170438528858762e-7,
-1.417450033604238e-7,
3.199486164208675e-8,
-4.8547595353093465e-9,
5.564514132885855e-10,
-5.134328188614593e-11,
3.977174547315121e-12,
-2.647642360161725e-13,
// [12.,12.5]: m=19 maxabs=4.50250951024864e-19 maxrel=1.2670563329315721e-12
2.8349000672062204e-7,
-1.2797944632627197e-7,
2.9128557233552143e-8,
-4.451620989089411e-9,
5.134325294718251e-10,
-4.763314083790161e-11,
3.707625381333616e-12,
-2.4787455847597927e-13,
// [12.,12.5]: m=20 maxabs=4.2452232525201465e-19 maxrel=1.3206970269671469e-12
2.559588926523325e-7,
-1.1651422870671016e-7,
2.670972595491524e-8,
-4.107469335450717e-9,
4.763311364421323e-10,
-4.440414889421591e-11,
3.4711141529404357e-12,
-2.329462932605927e-13,
// [12.,12.5]: m=21 maxabs=4.0154655655774175e-19 maxrel=1.3699304822831188e-12
2.3302845741321976e-7,
-1.068389036051381e-7,
2.4644816032041533e-8,
-3.810657672374683e-9,
4.440412311031831e-10,
-4.157099460238714e-11,
3.262073131979399e-12,
-2.1966537736936394e-13,
// [12.,12.5]: m=22 maxabs=3.809530680276216e-19 maxrel=1.4153683337876073e-12
2.13677807210087e-7,
-9.857926392525288e-8,
2.2863946052448275e-8,
-3.552337965263405e-9,
4.157097031181347e-10,
-3.906696033371026e-11,
3.076093087593236e-12,
-2.077787351079264e-13,
// [12.,12.5]: m=23 maxabs=3.622654036288236e-19 maxrel=1.4568923963378164e-12
1.9715852785032508e-7,
-9.145578401732514e-8,
2.1314027808896368e-8,
-3.3256853235611723e-9,
3.9066937229766826e-10,
-3.68392109275598e-11,
2.909642087000206e-12,
-1.9708195086671301e-13,
// [12.,12.5]: m=24 maxabs=3.451659260061274e-19 maxrel=1.4945937142107873e-12
1.8291156803447843e-7,
-8.525611105250749e-8,
1.9954111958063733e-8,
-3.1253622999689666e-9,
3.68391886361722e-10,
-3.484542308841592e-11,
2.75986064735044e-12,
-1.8741070494603164e-13,
// [12.,12.5]: m=25 maxabs=3.298399236167449e-19 maxrel=1.5305815685750305e-12
1.7051222210486175e-7,
-7.981644765779045e-8,
1.875217381512732e-8,
-2.947142068926667e-9,
3.4845402471948994e-10,
-3.305134198864128e-11,
2.6244123600789614e-12,
-1.786232775522415e-13,
// [12.,12.5]: m=26 maxabs=3.1565212175023536e-19 maxrel=1.5631907428348736e-12
1.5963289531542387e-7,
-7.500869509390452e-8,
1.7682852428662456e-8,
-2.787638862095829e-9,
3.305132183667541e-10,
-3.142897030502848e-11,
2.501371086015767e-12,
-1.7060842091813852e-13,
// [12.,12.5]: m=27 maxabs=3.026554599658022e-19 maxrel=1.5936306674198006e-12
1.5001739018765843e-7,
-7.073140955520688e-8,
1.6725833187037832e-8,
-2.64411212464712e-9,
3.142895101593432e-10,
-2.995522705900445e-11,
2.3891353352632852e-12,
-1.632692906616193e-13,
// [12.,12.5]: m=28 maxabs=2.90532300908225e-19 maxrel=1.6211419488474898e-12
1.4146281911026893e-7,
-6.690333259529179e-8,
1.586467276179984e-8,
-2.5143221956049867e-9,
2.995520849971019e-10,
-2.861092679428316e-11,
2.2863640250710865e-12,
-1.565255219492993e-13,
// [12.,12.5]: m=29 maxabs=2.77085652870563e-19 maxrel=1.6335110626820954e-12
1.3380666519044432e-7,
-6.345869090042206e-8,
1.5085933187050218e-8,
-2.396422551324865e-9,
2.861090884641638e-10,
-2.7380000697866595e-11,
2.191931036723358e-12,
-1.5031545704706128e-13,
// [12.,12.5]: m=30 maxabs=2.6917118876965563e-19 maxrel=1.671995789300008e-12
1.2691738180069342e-7,
-6.034373260666046e-8,
1.437853532131367e-8,
-2.288878368434832e-9,
2.7379985521935067e-10,
-2.6248904813665134e-11,
2.1048618817351984e-12,
-1.4455870949481634e-13,
// [12.,12.5]: m=31 maxabs=2.5953618899463796e-19 maxrel=1.6944446499781397e-12
1.2068746521319202e-7,
-5.751414114928964e-8,
1.3733270223003479e-8,
-2.1904042803537684e-9,
2.624888827879936e-10,
-2.520613224136744e-11,
2.024351251923203e-12,
-1.3922709969678943e-13,
// [12.,12.5]: m=32 maxabs=2.506688128280695e-19 maxrel=1.716210714416404e-12
1.1502828229845502e-7,
-5.4933080760892104e-8,
1.3142425694079706e-8,
-2.0999163072029965e-9,
2.5206116282143713e-10,
-2.4241863880033503e-11,
1.9496903807122086e-12,
-1.342698914045628e-13,
// [12.,12.5]: m=33 maxabs=2.42330832253535e-19 maxrel=1.7362815157167447e-12
1.0986616152166405e-7,
-5.256970264970753e-8,
1.2599497854760831e-8,
-2.016494367013015e-9,
2.4241848482090335e-10,
-2.334766605567935e-11,
1.8802714712030125e-12,
-1.2964921625881024e-13,
// [12.,12.5]: m=34 maxabs=2.34469307711831e-19 maxrel=1.7547354550701862e-12
1.0513940529929836e-7,
-5.039799129664881e-8,
1.2098966213287016e-8,
-1.939352774352975e-9,
2.334765111013981e-10,
-2.25162580355569e-11,
1.8155673184101907e-12,
-1.253325044427725e-13,
// [12.,12.5]: m=35 maxabs=2.2716364854176267e-19 maxrel=1.7726220713078474e-12
1.0079598259318473e-7,
-4.839586473470125e-8,
1.1636116656964848e-8,
-1.8678168267214845e-9,
2.2516243563777346e-10,
-2.1741323813649284e-11,
1.7551183927129243e-12,
-1.2129081942602206e-13,
// [12.,12.5]: m=36 maxabs=2.203079756249232e-19 maxrel=1.7895922547983594e-12
9.679172946929248e-8,
-4.654446651311495e-8,
1.1206900970895009e-8,
-1.8013040749066492e-9,
2.1741309722432146e-10,
-2.101735851781654e-11,
1.6985224320035273e-12,
-1.1749911748491548e-13,
// [12.,12.5]: m=37 maxabs=2.137302353939015e-19 maxrel=1.804606799657069e-12
9.308893302612279e-8,
-4.482760377231632e-8,
1.080782445971619e-8,
-1.7393092283561729e-9,
2.101734481909029e-10,
-2.0339543609518926e-11,
1.6454259369859588e-12,
-1.139351988074319e-13,
// [12.,12.5]: m=38 maxabs=2.0761571630590952e-19 maxrel=1.8195409685762393e-12
8.96552075445292e-8,
-4.3231297730879065e-8,
1.0435855380077021e-8,
-1.681391904992558e-9,
2.033953035302499e-10,
-1.970364418535631e-11,
1.5955169532632444e-12,
-1.1057899381192953e-13,
// [12.,12.5]: m=39 maxabs=2.0183206946293875e-19 maxrel=1.833624690454375e-12
8.646259546165719e-8,
-4.174342141541354e-8,
1.0088351439643678e-8,
-1.627166624055807e-9,
1.9703631267185128e-10,
-1.9105923487381668e-11,
1.5485192510506675e-12,
-1.0741326601503715e-13,
// [12.,12.5]: m=40 maxabs=1.963528250853875e-19 maxrel=1.8469162246683666e-12
8.348684283072915e-8,
-4.035340565660059e-8,
9.762999753742395e-9,
-1.5762945803544875e-9,
1.9105910937371338e-10,
-1.8543072689302065e-11,
1.5041873861771605e-12,
-1.0442231442939277e-13
},
{
// [12.5,13.]: m=0 maxabs=5.551115123125783e-17 maxrel=2.2145757956139306e-16
0.2481930729317521,
-0.004866473933555372,
0.00014311735922248193,
-4.674666707352554e-6,
1.6010879884210338e-7,
-5.621235031066313e-9,
1.9976383487438742e-10,
-7.166008834181681e-12,
// [12.5,13.]: m=1 maxabs=8.673617379884035e-18 maxrel=8.650815315050172e-16
0.009732947867111437,
-0.0005724694368808891,
0.000028048000237889603,
-1.280870664198026e-6,
5.621259048127048e-8,
-2.395217370075739e-9,
9.936565582369476e-11,
-3.996864104507978e-12,
// [12.5,13.]: m=2 maxabs=3.903127820947816e-18 maxrel=3.244457715900553e-15
0.0011449388737617893,
-0.00011219200094904005,
7.685223984903203e-6,
-4.4970082216066344e-7,
2.395217253533755e-8,
-1.1914476944150731e-9,
5.596876482940037e-11,
-2.5152251636391743e-12,
// [12.5,13.]: m=3 maxabs=2.358139725155972e-18 maxrel=9.807041997005103e-15
0.0002243840018980489,
-0.00003074089593877857,
2.6982049340672457e-6,
-1.9161741321394263e-7,
1.1914510586998055e-8,
-6.712139965164546e-10,
3.485739196622067e-11,
-1.678182430050477e-12,
// [12.5,13.]: m=4 maxabs=2.564138137928218e-17 maxrel=3.816932745529178e-13
0.00006148179187748236,
-0.000010792819736303416,
1.1497044793663564e-6,
-9.531610819448003e-8,
6.712145541220984e-9,
-4.179790057280063e-10,
2.3475912839634154e-11,
-9.344397212417673e-13,
// [12.5,13.]: m=5 maxabs=1.3857459017080354e-18 maxrel=5.765531990931574e-14
0.000021585639470169777,
-4.598817916925926e-6,
5.718967915055167e-7,
-5.369713608351859e-8,
4.17836074107939e-9,
-2.8168919605390556e-10,
1.688402691487924e-11,
-9.109901452296834e-13,
// [12.5,13.]: m=6 maxabs=1.128247885742728e-18 maxrel=1.0821134848493631e-13
9.197635833851131e-6,
-2.2875871653219236e-6,
3.221828165686828e-7,
-3.342691392113287e-8,
2.8168910589001248e-9,
-2.0233961671337163e-10,
1.2756751014890177e-11,
-7.165615747203317e-13,
// [12.5,13.]: m=7 maxabs=9.385125055577648e-19 maxrel=1.7799708108236305e-13
4.57517433064334e-6,
-1.2887312657059707e-6,
2.0056148357614866e-7,
-2.2535151216552044e-8,
2.0233955073137797e-9,
-1.5286269678345203e-10,
1.0033976272702425e-11,
-5.820953777203352e-13,
// [12.5,13.]: m=8 maxabs=8.000226186816867e-19 maxrel=2.653905078823014e-13
2.577462531411509e-6,
-8.022459338303998e-7,
1.3521090734065845e-7,
-1.618718302157642e-8,
1.5286264176890084e-9,
-1.2022569413684878e-10,
8.151093539148785e-12,
-4.853516895524323e-13,
// [12.5,13.]: m=9 maxabs=6.924494343803905e-19 maxrel=3.642934180158304e-13
1.60449186766044e-6,
-5.408436289588941e-7,
9.712309816407004e-8,
-1.2229027489359855e-8,
1.202256479351796e-9,
-9.765810650261347e-11,
6.79640326633923e-12,
-4.1337611430775196e-13,
// [12.5,13.]: m=10 maxabs=6.090166890758419e-19 maxrel=4.700860744433599e-13
1.0816872579174747e-6,
-3.8849239230632613e-7,
7.337416496634527e-8,
-9.618065831496452e-9,
9.765806620070923e-10,
-8.142247807241388e-11,
5.788555589969917e-12,
-3.582844206464976e-13,
// [12.5,13.]: m=11 maxabs=5.419952071243454e-19 maxrel=5.770879654043903e-13
7.769847846090773e-7,
-2.9349665955753655e-7,
5.7708395015777074e-8,
-7.812657604325118e-9,
8.142244243701178e-10,
-6.934451054278175e-11,
5.0171219191443556e-12,
-3.15079628767133e-13,
// [12.5,13.]: m=12 maxabs=4.875733402632566e-19 maxrel=6.81931618087273e-13
5.869933191148281e-7,
-2.3083357978916122e-7,
4.6875945649615476e-8,
-6.513806351958366e-9,
6.934447894887002e-10,
-6.010028008248399e-11,
4.4121259593019976e-12,
-2.804810541257649e-13,
// [12.5,13.]: m=13 maxabs=4.422570775851516e-19 maxrel=7.814799555924895e-13
4.616671595781003e-7,
-1.8750378235207302e-7,
3.908283813315894e-8,
-5.54756817070812e-9,
6.010025149968534e-10,
-5.2850908526566665e-11,
3.9276501080225495e-12,
-2.5227040240325334e-13,
// [12.5,13.]: m=14 maxabs=4.0429941363631823e-19 maxrel=8.748604881697377e-13
3.7500756470394306e-7,
-1.5633135230909072e-7,
3.328540904381481e-8,
-4.8080290615533144e-9,
5.28508824059683e-10,
-4.7045962287149536e-11,
3.532621959929674e-12,
-2.2890452173702487e-13,
// [12.5,13.]: m=15 maxabs=3.72270980318265e-19 maxrel=9.619284531001674e-13
3.1266270461799345e-7,
-1.3314163597085663e-7,
2.884817438736467e-8,
-4.228078768082689e-9,
4.704593822811678e-10,
-4.2312980306370595e-11,
3.2054331392999343e-12,
-2.0928421325151295e-13,
// [12.5,13.]: m=16 maxabs=3.4453065129568666e-19 maxrel=1.0414447856944818e-12
2.6628327194154036e-7,
-1.1539269736135326e-7,
2.5368472625132938e-8,
-3.7636825822020895e-9,
4.231295810513932e-10,
-3.8392968812503136e-11,
2.930689801226582e-12,
-1.9260894285829894e-13,
// [12.5,13.]: m=17 maxabs=3.204960914173459e-19 maxrel=1.1143189052854703e-12
2.3078539472254585e-7,
-1.0147389032641259e-7,
2.2582095508665666e-8,
-3.3850436129014955e-9,
3.8392948199753297e-10,
-3.5101419980136633e-11,
2.697184857752433e-12,
-1.782845384819232e-13,
// [12.5,13.]: m=18 maxabs=2.9953202597280196e-19 maxrel=1.1811364847331474e-12
2.0294778065267483e-7,
-9.032838187267292e-8,
2.0310261691864606e-8,
-3.0714423352491444e-9,
3.5101400702159955e-10,
-3.230401884240797e-11,
2.4966003215417884e-12,
-1.6586254878087264e-13,
// [12.5,13.]: m=19 maxabs=2.8110905937002093e-19 maxrel=1.24243458768501e-12
1.8065676374520436e-7,
-8.124104661607934e-8,
1.8428654025067058e-8,
-2.8081181110904247e-9,
3.230400075984737e-10,
-2.990107824234467e-11,
2.3226539810066797e-12,
-1.5499865499510527e-13,
// [12.5,13.]: m=20 maxabs=2.6464485645776546e-19 maxrel=1.2979517877240031e-12
1.6248209323202557e-7,
-7.371461595823726e-8,
1.6848708679314617e-8,
-2.5843257417127924e-9,
2.9901061212937e-10,
-2.7817312429443452e-11,
2.170526146661201e-12,
-1.454252050315189e-13,
// [12.5,13.]: m=21 maxabs=2.49927658999222e-19 maxrel=1.3486247912982148e-12
1.474292319163493e-7,
-6.739483458353281e-8,
1.550595446231423e-8,
-2.3920902459885295e-9,
2.7817296382699157e-10,
-2.5994964329568106e-11,
2.0364662505559287e-12,
-1.3693086273515284e-13,
// [12.5,13.]: m=22 maxabs=2.3679864831678034e-19 maxrel=1.3955196406972626e-12
1.3478966916694744e-7,
-6.202381772293905e-8,
1.4352541487310671e-8,
-2.2253887632702207e-9,
2.5994949154008283e-10,
-2.4389089696084602e-11,
1.9175176680917074e-12,
-1.2934719933248738e-13,
// [12.5,13.]: m=23 maxabs=2.2499312661442353e-19 maxrel=1.438880955259608e-12
1.2404763544576567e-7,
-5.741016582957491e-8,
1.335233259042889e-8,
-2.0796007190138804e-9,
2.4389075281345483e-10,
-2.2964259967395162e-11,
1.8113220666320192e-12,
-1.2253846400028381e-13,
// [12.5,13.]: m=24 maxabs=2.142463960961346e-19 maxrel=1.4785469064534915e-12
1.1482033165904287e-7,
-5.3409330248049983e-8,
1.2477604324378524e-8,
-1.9511305691811862e-9,
2.2964246233424144e-10,
-2.1692216860312596e-11,
1.7159780425499681e-12,
-1.163941226525818e-13,
// [12.5,13.]: m=25 maxabs=2.0442610786390505e-19 maxrel=1.5148909936187782e-12
1.0681866049599586e-7,
-4.991041718927892e-8,
1.1706783424915336e-8,
-1.837144027842307e-9,
2.1692203751083e-10,
-2.0550177264917934e-11,
1.629937253573935e-12,
-1.1082338638449747e-13,
// [12.5,13.]: m=26 maxabs=1.954263827993281e-19 maxrel=1.548293295159217e-12
9.982083437846042e-8,
-4.682713359638974e-8,
1.1022864176427603e-8,
-1.7353804309960048e-9,
2.0550164760560228e-10,
-1.951959035650945e-11,
1.5519276061403847e-12,
-1.0575082125123926e-13,
// [12.5,13.]: m=27 maxabs=1.8722075112280207e-19 maxrel=1.5796370460024777e-12
9.365426719268623e-8,
-4.4091456606965745e-8,
1.0412282594953581e-8,
-1.644017130621748e-9,
1.9519578376362782e-10,
-1.8585213549378156e-11,
1.4808949768323032e-12,
-1.0111367737012007e-13,
// [12.5,13.]: m=28 maxabs=1.796636290465176e-19 maxrel=1.608723067913852e-12
8.818291321384196e-8,
-4.164913028522613e-8,
9.864102792344062e-9,
-1.5615700536806744e-9,
1.8585202059650797e-10,
-1.773441746251408e-11,
1.415959180409131e-12,
-9.685906663563878e-14,
// [12.5,13.]: m=29 maxabs=1.7267560723166963e-19 maxrel=1.6357075289693993e-12
8.329826057036635e-8,
-3.94564110786116e-8,
9.369420330352975e-9,
-1.4868197953546353e-9,
1.7734406431374234e-10,
-1.695665672631572e-11,
1.3563799753308542e-12,
-9.294214607631454e-14,
// [12.5,13.]: m=30 maxabs=1.6515818982478772e-19 maxrel=1.6504206044851553e-12
7.891282215713305e-8,
-3.747768123417941e-8,
8.920918780335083e-9,
-1.4187560038036454e-9,
1.6956645899717186e-10,
-1.6243062661185184e-11,
1.301534888276026e-12,
-8.932501489276455e-14,
// [12.5,13.]: m=31 maxabs=1.6022157592907125e-19 maxrel=1.6846709679032254e-12
7.495536246827918e-8,
-3.568367503645501e-8,
8.512536030484525e-9,
-1.3565350451992921e-9,
1.6243052438765806e-10,
-1.5586127219464072e-11,
1.2508773691721777e-12,
-8.597478968101645e-14,
// [12.5,13.]: m=32 maxabs=1.5457027798410896e-19 maxrel=1.7060758837233498e-12
7.136735007283318e-8,
-3.405014404101555e-8,
8.139210278585801e-9,
-1.2994474319828194e-9,
1.5586117358835808e-10,
-1.4979454550018892e-11,
1.2039626972842972e-12,
-8.28633881654648e-14,
// [12.5,13.]: m=33 maxabs=1.4936896629237553e-19 maxrel=1.7269371758546366e-12
6.81002880819569e-8,
-3.2556841036250466e-8,
7.796684599036147e-9,
-1.2468925124189169e-9,
1.4979445019654055e-10,
-1.4417564833894994e-11,
1.160392614148342e-12,
-7.996646949035759e-14,
// [12.5,13.]: m=34 maxabs=1.444985268456633e-19 maxrel=1.7464875612463655e-12
6.51136820724289e-8,
-3.118673832069154e-8,
7.481355081436793e-9,
-1.198358619685319e-9,
1.4417555601860405e-10,
-1.389573765696531e-11,
1.1198259801298104e-12,
-7.726288273883529e-14,
// [12.5,13.]: m=35 maxabs=1.3989278519496804e-19 maxrel=1.7643844057708763e-12
6.237347664131348e-8,
-2.9925420252763644e-8,
7.190151724805146e-9,
-1.1534073674870922e-9,
1.3895728730272752e-10,
-1.340988631890381e-11,
1.081966014668172e-12,
-7.47340073184479e-14,
// [12.5,13.]: m=36 maxabs=1.3567085534849739e-19 maxrel=1.7825858643663776e-12
5.985084050545975e-8,
-2.8760606828554274e-8,
6.920444211417599e-9,
-1.1116611251177417e-9,
1.3409877653691627e-10,
-1.2956455802449357e-11,
1.0465534703483044e-12,
-7.236374214780286e-14,
// [12.5,13.]: m=37 maxabs=1.3155480462043352e-19 maxrel=1.7978796188413901e-12
5.752121365704299e-8,
-2.7681776777175404e-8,
6.669966756994603e-9,
-1.0727929520597565e-9,
1.2956447416914388e-10,
-1.2532340006656467e-11,
1.013360828833713e-12,
-7.013769465515165e-14,
// [12.5,13.]: m=38 maxabs=1.2778286102719172e-19 maxrel=1.813797164367108e-12
5.5363553554287116e-8,
-2.667986696152641e-8,
6.436757718454207e-9,
-1.036518451342742e-9,
1.2532331883362184e-10,
-1.2134813618721594e-11,
9.821876484217563e-13,
-6.804308345822026e-14,
// [12.5,13.]: m=39 maxabs=1.2415650122175924e-19 maxrel=1.8279459991106385e-12
5.3359733922990826e-8,
-2.5747030809294624e-8,
6.2191107140016414e-9,
-1.0025891315146752e-9,
1.2134805694156448e-10,
-1.1761475840622546e-11,
9.528567496336644e-13,
-6.606891137784395e-14,
// [12.5,13.]: m=40 maxabs=1.207816043225429e-19 maxrel=1.8421591818256535e-12
5.149406161852899e-8,
-2.4876442793306087e-8,
6.015534794861358e-9,
-9.707869635400251e-10,
1.176146814704074e-10,
-1.1410204130273716e-11,
9.252109279554783e-13,
-6.420503548968007e-14
},
{
// [13.,13.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.1292162577672176e-16
0.24346519637103445,
-0.004593649736315005,
0.00013000065128413485,
-4.086686872930483e-6,
1.3476474450050923e-7,
-4.559645247665849e-9,
1.5643896184367823e-10,
-5.306474896197827e-12,
// [13.,13.5]: m=1 maxabs=3.469446951953614e-18 maxrel=3.669986586913438e-16
0.00918729947263095,
-0.0005200026051241813,
0.00002452012125016583,
-1.0781182727878869e-6,
4.559617248800116e-8,
-1.875376649810867e-9,
7.528242360248925e-11,
-2.9310336766391844e-12,
// [13.,13.5]: m=2 maxabs=2.1467203015212988e-17 maxrel=1.968187170444216e-14
0.0010400052102480406,
-0.00009808048499924202,
6.4687096422118536e-6,
-3.647694435917124e-7,
1.8753694034461964e-8,
-9.028152980430594e-10,
4.126465434918005e-11,
-1.453646718860282e-12,
// [13.,13.5]: m=3 maxabs=1.4907779871675686e-18 maxrel=7.110289558684223e-15
0.0001961609699973374,
-0.000025874838559796657,
2.1886167349422043e-6,
-1.5002981631301493e-7,
9.026947480939698e-9,
-4.936603870075164e-10,
2.4975046919258284e-11,
-1.1757397615937118e-12,
// [13.,13.5]: m=4 maxabs=1.179069862577986e-18 maxrel=2.0919848437511847e-14
0.00005174967711959194,
-8.754466938946763e-6,
9.001788980030649e-7,
-7.221561247931647e-8,
4.936602203780847e-9,
-2.9938874367126724e-10,
1.6465686866374207e-11,
-8.288100527883268e-13,
// [13.,13.5]: m=5 maxabs=9.283481101907132e-19 maxrel=4.779695671809768e-14
0.00001750893387789274,
-3.600715591408811e-6,
4.332936749491566e-7,
-3.949284172849416e-8,
2.9938864755786778e-9,
-1.9735704583337247e-10,
1.160637747435534e-11,
-6.163686867281985e-13,
// [13.,13.5]: m=6 maxabs=7.420008617947671e-19 maxrel=9.12627584243784e-14
7.201431182817152e-6,
-1.7331746993296212e-6,
2.3695705041335464e-7,
-2.395111048778252e-8,
1.9735699050577473e-9,
-1.3909714431127708e-10,
8.630913896288468e-12,
-4.78422839504239e-13,
// [13.,13.5]: m=7 maxabs=6.140988867593677e-19 maxrel=1.5436392067080938e-13
3.46634939865888e-6,
-9.478282012779239e-7,
1.437066629609748e-7,
-1.5788574256547833e-8,
1.3909709867893089e-9,
-1.0342682234874214e-10,
6.699379988137421e-12,
-3.843809322580448e-13,
// [13.,13.5]: m=8 maxabs=5.183841637196318e-19 maxrel=2.347530244512003e-13
1.8956564025555686e-6,
-5.748266515338089e-7,
9.473144556612439e-8,
-1.1127780298029604e-8,
1.0342678657222578e-9,
-8.027348036874337e-11,
5.382477363793479e-12,
-3.175540697726579e-13,
// [13.,13.5]: m=9 maxabs=4.461746049662027e-19 maxrel=3.288204356748048e-13
1.1496533030673778e-6,
-3.7892578200240474e-7,
6.676668181087773e-8,
-8.274153409627124e-9,
8.027345023706719e-10,
-6.448908482026425e-11,
4.4467197544417035e-12,
-2.6837788530032127e-13,
// [13.,13.5]: m=10 maxabs=3.9069394692104603e-19 maxrel=4.318773741516191e-13
7.578515640046096e-7,
-2.670667270178203e-7,
4.9644920476999537e-8,
-6.421885046363356e-9,
6.448905921127263e-10,
-5.327397559953611e-11,
3.758108705443897e-12,
-2.310943985666417e-13,
// [13.,13.5]: m=11 maxabs=3.460129589533817e-19 maxrel=5.375077406616389e-13
5.341334540323479e-7,
-1.9857968171038282e-7,
3.8531310295546215e-8,
-5.1591326315433665e-9,
5.327395256317613e-10,
-4.502151620483107e-11,
3.2360579692162844e-12,
-2.0210250377599654e-13,
// [13.,13.5]: m=12 maxabs=2.813208176068345e-19 maxrel=5.830207539902486e-13
3.971593634206411e-7,
-1.5412524100681527e-7,
3.095479580126615e-8,
-4.261923220506925e-9,
4.502149970554799e-10,
-3.876535192231599e-11,
2.8300014562510187e-12,
-1.7950536594278428e-13,
// [13.,13.5]: m=13 maxabs=2.8026202642276662e-19 maxrel=7.43344401428656e-13
3.0825048201447095e-7,
-1.2381918306099866e-7,
2.5571539211704064e-8,
-3.6017259495094605e-9,
3.8765530512734467e-10,
-3.3900802077057953e-11,
2.5073832665731533e-12,
-1.6039012751078786e-13,
// [13.,13.5]: m=14 maxabs=2.5538043359717155e-19 maxrel=8.384293765315253e-13
2.4763836612186794e-7,
-1.0228615670519902e-7,
2.1610355709467154e-8,
-3.101248105742317e-9,
3.390078553688688e-10,
-3.003421748829387e-11,
2.245990990606606e-12,
-1.4501903389702056e-13,
// [13.,13.5]: m=15 maxabs=2.3436342859342423e-19 maxrel=9.270575051194187e-13
2.045723134102801e-7,
-8.644142270878365e-8,
1.8607488645774047e-8,
-2.7120680062502457e-9,
3.003420241306168e-10,
-2.6902324702805545e-11,
2.030748501358313e-12,
-1.3217852421328473e-13,
// [13.,13.5]: m=16 maxabs=2.1649632736227883e-19 maxrel=1.009382785523668e-12
1.7288284541745806e-7,
-7.442995446462881e-8,
1.627240804796126e-8,
-2.4027409318079688e-9,
2.6902310773112854e-10,
-2.4323489209661412e-11,
1.8509447679955656e-12,
-1.2131584152296123e-13,
// [13.,13.5]: m=17 maxabs=2.0098503651568445e-19 maxrel=1.0846831118807729e-12
1.488599089291558e-7,
-6.508963208244619e-8,
1.4416445600607537e-8,
-2.1521892377459532e-9,
2.432347620444275e-10,
-2.2169328520040185e-11,
1.6988378412665221e-12,
-1.1202379823644707e-13,
// [13.,13.5]: m=18 maxabs=1.8743250935961565e-19 maxrel=1.1534436642225577e-12
1.301792641647981e-7,
-5.766578230087277e-8,
1.2913135435535598e-8,
-1.9458821586775504e-9,
2.2169316448182772e-10,
-2.0347055698667693e-11,
1.5687193417432286e-12,
-1.0399590069961778e-13,
// [13.,13.5]: m=19 maxabs=1.7560051787765714e-19 maxrel=1.2168143150822943e-12
1.1533156460165715e-7,
-5.1652541647416897e-8,
1.1675292960544005e-8,
-1.773549104853985e-9,
2.0347044400032544e-10,
-1.8788257676482612e-11,
1.4563040406845121e-12,
-9.699879677247887e-14,
// [13.,13.5]: m=20 maxabs=1.6509201537578348e-19 maxrel=1.2745291066326176e-12
1.033050832947506e-7,
-4.670117175345632e-8,
1.064129463708936e-8,
-1.627767100837415e-9,
1.8788247065103578e-10,
-1.7441579383955482e-11,
1.3583225480928293e-12,
-9.085162232650631e-14,
// [13.,13.5]: m=21 maxabs=1.5569524361718108e-19 maxrel=1.327032212751516e-12
9.340234350683427e-8,
-4.2565178464949555e-8,
9.766602612550477e-9,
-1.5030631015790596e-9,
1.744156935247625e-10,
-1.6267841068419676e-11,
1.2722436636770743e-12,
-8.541276570158107e-14,
// [13.,13.5]: m=22 maxabs=1.4735726304264656e-19 maxrel=1.3758432418608897e-12
8.51303569298254e-8,
-3.906641037152212e-8,
9.018378616574496e-9,
-1.3953286954122553e-9,
1.6267831606635145e-10,
-1.5236710584962243e-11,
1.1960814098796309e-12,
-8.05693787543768e-14,
// [13.,13.5]: m=23 maxabs=1.3976043629695956e-19 maxrel=1.4198211785315468e-12
7.81328207429741e-8,
-3.60735143918558e-8,
8.371972179200894e-9,
-1.3014295062606246e-9,
1.52367016100151e-10,
-1.4324390443371448e-11,
1.1282586700987355e-12,
-7.623119162091417e-14,
// [13.,13.5]: m=24 maxabs=1.329444680495226e-19 maxrel=1.460849928879884e-12
7.214702878364513e-8,
-3.348788864617445e-8,
7.808577043939136e-9,
-1.2189389539618866e-9,
1.4324381940849526e-10,
-1.351198249677696e-11,
1.0675088412504206e-12,
-7.232424097229776e-14,
// [13.,13.5]: m=25 maxabs=1.2677700940232723e-19 maxrel=1.4990167388388317e-12
6.697577729228517e-8,
-3.123430810858987e-8,
7.313633729947011e-9,
-1.1459532420818526e-9,
1.3511974230408513e-10,
-1.2784311403651979e-11,
1.0128048495181451e-12,
-6.878920475848078e-14,
// [13.,13.5]: m=26 maxabs=1.211124765675641e-19 maxrel=1.533878622093536e-12
6.246861621711498e-8,
-2.9254534855769033e-8,
6.875719458596099e-9,
-1.080960499932703e-9,
1.278430334707946e-10,
-1.2129066851893409e-11,
9.633051646920465e-13,
-6.557695792051999e-14,
// [13.,13.5]: m=27 maxabs=1.159243997656315e-19 maxrel=1.5661703011836597e-12
5.850906971148004e-8,
-2.750287777320913e-8,
6.485763005163279e-9,
-1.0227467147940783e-9,
1.2129059425519677e-10,
-1.153617032080831e-11,
9.183151451382444e-13,
-6.26448958508353e-14,
// [13.,13.5]: m=28 maxabs=1.1110689987812268e-19 maxrel=1.5954406142397144e-12
5.5005755546362695e-8,
-2.594305196210143e-8,
6.136480294098991e-9,
-9.703270961377932e-10,
1.1536163203476802e-10,
-1.0997297364786396e-11,
8.772564143854728e-13,
-5.995893486336264e-14,
// [13.,13.5]: m=29 maxabs=1.0672615135404184e-19 maxrel=1.623529164683124e-12
5.188610392414943e-8,
-2.4545921120255357e-8,
5.821962581954147e-9,
-9.228953019339613e-10,
1.099729052723348e-10,
-1.0505518465379143e-11,
8.396439124884207e-13,
-5.748981402710916e-14,
// [13.,13.5]: m=30 maxabs=1.0264980529538052e-19 maxrel=1.6493379140317585e-12
4.9091842240459356e-8,
-2.3287850273901012e-8,
5.537371816536294e-9,
-8.797853988544619e-10,
1.0505511884305423e-10,
-1.0055022482521179e-11,
8.050681188767529e-13,
-5.521272751217926e-14,
// [13.,13.5]: m=31 maxabs=9.937417006967053e-20 maxrel=1.6819766965016127e-12
4.657570054775178e-8,
-2.2149487214288832e-8,
5.2787123979716495e-9,
-8.404430249046251e-10,
1.0055015994324019e-10,
-9.640906650107243e-12,
7.731856068919821e-13,
-5.309470000110708e-14,
// [13.,13.5]: m=32 maxabs=9.538385079471473e-20 maxrel=1.696498839715958e-12
4.429897442852407e-8,
-2.1114849541562634e-8,
5.0426581555114435e-9,
-8.044032897558634e-10,
9.64089667286373e-11,
-9.25899002708165e-12,
7.436850790482789e-13,
-5.115258410326153e-14,
// [13.,13.5]: m=33 maxabs=9.211483301390516e-20 maxrel=1.7177877532678443e-12
4.222969908307921e-8,
-2.0170632573869213e-8,
4.8264197429499325e-9,
-7.712736609395272e-10,
9.258984139160702e-11,
-8.905720392448553e-12,
7.163246703941469e-13,
-4.9335475963266163e-14,
// [13.,13.5]: m=34 maxabs=8.905757346990917e-20 maxrel=1.7377273831646414e-12
4.034126514769403e-8,
-1.9305678925276574e-8,
4.6276419699000475e-9,
-7.407205920866048e-10,
8.905714703273637e-11,
-8.57803068788426e-12,
6.90878848194885e-13,
-4.7641412957700714e-14,
// [13.,13.5]: m=35 maxabs=8.619883727292591e-20 maxrel=1.7565641505305474e-12
3.86113578505102e-8,
-1.8510567834622754e-8,
4.444323556640482e-9,
-7.124589753825899e-10,
8.578025189902927e-11,
-8.273274444115118e-12,
6.671558281879389e-13,
-4.6058376045619684e-14,
// [13.,13.5]: m=36 maxabs=8.349891975355283e-20 maxrel=1.7739426991190871e-12
3.702113566920378e-8,
-1.7777294183031398e-8,
4.274753856300498e-9,
-6.862437564304317e-10,
8.273269101170226e-11,
-7.98915397924531e-12,
6.449883345734647e-13,
-4.457606550907383e-14,
// [13.,13.5]: m=37 maxabs=8.096443835669035e-20 maxrel=1.7903994137759477e-12
3.5554588366022356e-8,
-1.7099015383027837e-8,
4.117462542451073e-9,
-6.618632150296108e-10,
7.989148824097932e-11,
-7.723665559517109e-12,
6.242298464294548e-13,
-4.31850521049642e-14,
// [13.,13.5]: m=38 maxabs=7.859539308233848e-20 maxrel=1.8063457859379157e-12
3.4198030766016326e-8,
-1.6469850128906854e-8,
3.9711792939477806e-9,
-6.391335417925128e-10,
7.723660534256674e-11,
-7.475054017361375e-12,
6.04751521313043e-13,
-4.187737720608802e-14,
// [13.,13.5]: m=39 maxabs=7.634546181619424e-20 maxrel=1.821091937728151e-12
3.2939700257775485e-8,
-1.5884717136095687e-8,
3.834801254419652e-9,
-6.178944305142222e-10,
7.475049132243675e-11,
-7.241775887328327e-12,
5.864396068143271e-13,
-4.0645849933247125e-14,
// [13.,13.5]: m=40 maxabs=7.422787944805849e-20 maxrel=1.8352620837121364e-12
3.1769434272154364e-8,
-1.5339204979119283e-8,
3.707366586634289e-9,
-5.98005472943418e-10,
7.241771155160424e-11,
-7.0224686944777525e-12,
5.691933468210534e-13,
-3.9483971461782725e-14
},
{
// [13.5,14.]: m=0 maxabs=0. maxrel=0.
0.23899759095537693,
-0.004345391331842475,
0.00011850581948898976,
-3.5902765708363846e-6,
1.1413493609440209e-7,
-3.7252460073973353e-9,
1.2344357306603792e-10,
-4.013872036867587e-12,
// [13.5,14.]: m=1 maxabs=0. maxrel=0.
0.008690782663685979,
-0.00047402327794633783,
0.000021541659434262776,
-9.130797150127595e-7,
3.7252145781556624e-8,
-1.4799777442253682e-9,
5.750133898436696e-11,
-2.1741806866366096e-12,
// [13.5,14.]: m=2 maxabs=1.5178830414797062e-18 maxrel=1.5292951103143768e-15
0.0009480465558926494,
-0.00008616663773551253,
5.478478292428851e-6,
-2.980172220050588e-7,
1.4799748591884044e-8,
-6.895136362168194e-10,
3.052520805985981e-11,
-1.2876422123920208e-12,
// [13.5,14.]: m=3 maxabs=1.1384122811097797e-18 maxrel=6.195356684527421e-15
0.00017233327547102508,
-0.000021913913168857352,
1.788103332091145e-6,
-1.1839802212497373e-7,
6.895135633434764e-9,
-3.6598752608814057e-10,
1.8029233230195855e-11,
-8.294024514740294e-13,
// [13.5,14.]: m=4 maxabs=8.063753657860939e-19 maxrel=1.694465985850903e-14
0.00004382782633771373,
-7.152413327807142e-6,
7.103881328375874e-7,
-5.516110742531646e-8,
3.6598742141489147e-9,
-2.1613596738593843e-10,
1.1614727804427403e-11,
-5.732093974347976e-13,
// [13.5,14.]: m=5 maxabs=6.2002811739014785e-19 maxrel=3.9212147100253703e-14
0.00001430482665561378,
-2.841552530940336e-6,
3.309666445984475e-7,
-2.927901010540059e-8,
2.161359061391117e-9,
-1.3921945543536117e-10,
8.02687831350642e-12,
-4.192161895518782e-13,
// [13.5,14.]: m=6 maxabs=4.895850435129856e-19 maxrel=7.660289220974093e-14
5.683105061880367e-6,
-1.3238665780802115e-6,
1.756740606639177e-7,
-1.7290885028894493e-8,
1.392194128437296e-9,
-9.620219528398019e-11,
5.870395537605172e-12,
-3.2089254087058884e-13,
// [13.5,14.]: m=7 maxabs=4.019171334721655e-19 maxrel=1.3280053715249756e-13
2.647733156160196e-6,
-7.026962424067245e-7,
1.0374531019541574e-7,
-1.1137562982997582e-8,
9.620216597871446e-10,
-7.034918267283039e-11,
4.493429240268674e-12,
-2.548207098876569e-13,
// [13.5,14.]: m=8 maxabs=3.366955965335844e-19 maxrel=2.0648606569942958e-13
1.4053924848132719e-6,
-4.1498124057805215e-7,
6.682537791507683e-8,
-7.696181422228045e-9,
7.034915974852377e-10,
-5.384297220687597e-11,
3.568226068190045e-12,
-2.0846983807230685e-13,
// [13.5,14.]: m=9 maxabs=2.882029603032757e-19 maxrel=2.9532137601615673e-13
8.299624811559514e-7,
-2.6730151148964465e-7,
4.617708854798353e-8,
-5.627939606293685e-9,
5.384295276744244e-10,
-4.2753181427826106e-11,
2.919198722201156e-12,
-1.7474480927326112e-13,
// [13.5,14.]: m=10 maxabs=4.419394402299312e-19 maxrel=6.949111465311745e-13
5.3460302297966e-7,
-1.8470835402891498e-7,
3.3767637632185973e-8,
-4.307442610866988e-9,
4.275314425733349e-10,
-3.497087109567998e-11,
2.448117608157959e-12,
-1.555234269762885e-13,
// [13.5,14.]: m=11 maxabs=2.211814783517792e-19 maxrel=4.983096934150483e-13
3.694167080890678e-7,
-1.350705504738558e-7,
2.584465236288823e-8,
-3.420258255799356e-9,
3.497433310973204e-10,
-2.931480458669455e-11,
2.0924908067028765e-12,
-1.2991589515021639e-13,
// [13.5,14.]: m=12 maxabs=1.97093978914235e-19 maxrel=6.021268347914426e-13
2.7014110094829725e-7,
-1.0337860933954872e-7,
2.0521549544487263e-8,
-2.7979511223755613e-9,
2.931479159702008e-10,
-2.5066942960018225e-11,
1.8192386839615878e-12,
-1.1452468870139859e-13,
// [13.5,14.]: m=13 maxabs=1.776651606865895e-19 maxrel=7.041632816023744e-13
2.0675721867933744e-7,
-8.20861980783143e-8,
1.6787706742924747e-8,
-2.3451873177266975e-9,
2.5066931404937666e-10,
-2.179256064863437e-11,
1.6037151773169006e-12,
-1.0214218936250095e-13,
// [13.5,14.]: m=14 maxabs=1.61465655570351e-19 maxrel=8.011971007500156e-13
1.641723961565468e-7,
-6.71508268818501e-8,
1.407112391421822e-8,
-2.005358106415529e-9,
2.1792550169820273e-10,
-1.9210079341890037e-11,
1.4303259028392541e-12,
-9.200776431464044e-14,
// [13.5,14.]: m=15 maxabs=1.478072492958754e-19 maxrel=8.921118062358894e-13
1.3430165376362595e-7,
-5.628449557524732e-8,
1.2032148645641329e-8,
-1.7434072786761292e-9,
1.921006980654092e-10,
-1.7132565640259327e-11,
1.2884137991366597e-12,
-8.35875151073959e-14,
// [13.5,14.]: m=16 maxabs=1.3623995560993387e-19 maxrel=9.769687026897867e-13
1.1256899115042613e-7,
-4.812859450786428e-8,
1.0460443678641854e-8,
-1.5368085726690476e-9,
1.7132556855525808e-10,
-1.5432278848999397e-11,
1.1705063694735148e-12,
-7.649880046060762e-14,
// [13.5,14.]: m=17 maxabs=3.249403674124708e-18 maxrel=2.7154233857122036e-11
9.625718901479924e-8,
-4.184177461618999e-8,
9.220851473383372e-9,
-1.3706082566884968e-9,
1.543230624800631e-10,
-1.4013635408678256e-11,
1.0692388505419628e-12,
-8.100925510761301e-14,
// [13.5,14.]: m=18 maxabs=1.1738023764372484e-19 maxrel=1.1249280193590483e-12
8.368354929146755e-8,
-3.688340570459323e-8,
8.22364380994213e-9,
-1.2345842095855488e-9,
1.4019646447278068e-10,
-1.2830434044125426e-11,
9.866952321237585e-13,
-6.526502515025021e-14,
// [13.5,14.]: m=19 maxabs=1.0973047133883444e-19 maxrel=1.1899471549281359e-12
7.376681140913165e-8,
-3.289457518044038e-8,
7.4075052627849395e-9,
-1.1215740889170093e-9,
1.2830427008367145e-10,
-1.181756068391122e-11,
9.139356104493923e-13,
-6.0752148312357e-14,
// [13.5,14.]: m=20 maxabs=1.0306008687920682e-19 maxrel=1.2503867447194137e-12
6.578915036082951e-8,
-2.963002099567347e-8,
6.7294445384422905e-9,
-1.0264363793848622e-9,
1.1817554087512954e-10,
-1.0945927395133464e-11,
8.507412962844228e-13,
-5.680009517180745e-14,
// [13.5,14.]: m=21 maxabs=9.709115157902418e-20 maxrel=1.305270460134332e-12
5.9260041991298175e-8,
-2.6917778101706428e-8,
6.158618280985378e-9,
-9.454064095374361e-10,
1.0945921160745954e-10,
-1.0188903060807288e-11,
7.954008198296164e-13,
-5.331357846921177e-14,
// [13.5,14.]: m=22 maxabs=9.166484676067631e-20 maxrel=1.354245174225314e-12
5.3835556203367274e-8,
-2.463447307490218e-8,
5.6724384616162944e-9,
-8.756756544520687e-10,
1.018889719726707e-10,
-9.525978504760659e-12,
7.465778859462205e-13,
-5.0217002059495716e-14,
// [13.5,14.]: m=23 maxabs=8.687381665276918e-20 maxrel=1.4003894275128369e-12
4.9268946149760843e-8,
-2.2689753800125177e-8,
5.254053930879535e-9,
-8.15113629324927e-10,
9.525972946140077e-11,
-8.941140786586266e-12,
7.032159922797423e-13,
-4.745008150426869e-14,
// [13.5,14.]: m=24 maxabs=8.255262513279216e-20 maxrel=1.4429399324622423e-12
4.5379507600209054e-8,
-2.101621567960703e-8,
4.890681779912074e-9,
-7.620795921087736e-10,
8.941135501627973e-11,
-8.421730358049067e-12,
6.644703078445674e-13,
-4.496408102526584e-14,
// [13.5,14.]: m=25 maxabs=7.864833264154187e-20 maxrel=1.4824805392387717e-12
4.203243135917484e-8,
-1.956272707792806e-8,
4.572477556416865e-9,
-7.152925088857754e-10,
8.421725332898456e-11,
-7.957623846022963e-12,
6.296580789358655e-13,
-4.271931561999505e-14,
// [13.5,14.]: m=26 maxabs=7.503520772591025e-20 maxrel=1.517923960951539e-12
3.912545415582001e-8,
-1.828991018593915e-8,
4.291755056843289e-9,
-6.737396157461248e-10,
7.957619109149561e-11,
-7.540641222284754e-12,
5.9822245305988e-13,
-4.068235040352291e-14,
// [13.5,14.]: m=27 maxabs=7.175295505529983e-20 maxrel=1.5511314375918804e-12
3.657982037184186e-8,
-1.716702018944523e-8,
4.042437697988258e-9,
-6.366110457016605e-10,
7.540636512351806e-11,
-7.16410783977258e-12,
5.697045548035988e-13,
-3.882742797096216e-14,
// [13.5,14.]: m=28 maxabs=6.874201762560681e-20 maxrel=1.5819513745790314e-12
3.433404037885622e-8,
-1.6169750755690904e-8,
3.819666277493241e-9,
-6.032523714279939e-10,
7.164103460170647e-11,
-6.822530599383656e-12,
5.437241961661372e-13,
-3.7130607560591406e-14,
// [13.5,14.]: m=29 maxabs=6.596930821232906e-20 maxrel=1.6105855071327719e-12
3.233950151134894e-8,
-1.5278665075232576e-8,
3.6195142317195754e-9,
-5.731296664004325e-10,
6.822526395059403e-11,
-6.511350403957872e-12,
5.199631023461734e-13,
-3.557314422641061e-14,
// [13.5,14.]: m=30 maxabs=6.341497448076531e-20 maxrel=1.637421830730693e-12
3.055733015043359e-8,
-1.447805689353931e-8,
3.438778001430661e-9,
-5.458034451506595e-10,
6.511346364165531e-11,
-6.2267551991357385e-12,
4.981533455101247e-13,
-3.4138790906772806e-14,
// [13.5,14.]: m=31 maxabs=6.104592920641344e-20 maxrel=1.6623995606321264e-12
2.8956113787048212e-8,
-1.3755111973677382e-8,
3.2748206738227858e-9,
-5.20908990924123e-10,
6.226751303363731e-11,
-5.9655349828636215e-12,
4.780678358005765e-13,
-3.281378761103188e-14,
// [13.5,14.]: m=32 maxabs=5.883570260967175e-20 maxrel=1.6854788295223268e-12
2.7510223947325514e-8,
-1.3099282664443373e-8,
3.1254539483503014e-9,
-4.981413381315907e-10,
5.965531239213514e-11,
-5.724969127222803e-12,
4.595129006733501e-13,
-3.1586185585031484e-14,
// [13.5,14.]: m=33 maxabs=5.678429469054024e-20 maxrel=1.7072798424565364e-12
2.6198565328858456e-8,
-1.2501815763668154e-8,
2.9888480315038013e-9,
-4.772436884350035e-10,
5.72496550684491e-11,
-5.502737609931861e-12,
4.423224862373981e-13,
-3.044582027772459e-14,
// [13.5,14.]: m=34 maxabs=5.487847055921807e-20 maxrel=1.728017391600391e-12
2.5003631527308984e-8,
-1.1955392097319198e-8,
2.8634621332304055e-9,
-4.57998388365285e-10,
5.502734114405946e-11,
-5.296850865765678e-12,
4.263533966765073e-13,
-2.9383808520297236e-14,
// [13.5,14.]: m=35 maxabs=5.309837788100395e-20 maxrel=1.7476223697224117e-12
2.391078419461197e-8,
-1.1453848505194382e-8,
2.7479903327273094e-9,
-4.402198382332768e-10,
5.2968474834842835e-11,
-5.105593594970845e-12,
4.1148158797284044e-13,
-2.839244579932281e-14,
// [13.5,14.]: m=36 maxabs=5.140100326404514e-20 maxrel=1.765124495263679e-12
2.2907697010363165e-8,
-1.099196130408645e-8,
2.641319031854017e-9,
-4.2374887155301924e-10,
5.1055903211270985e-11,
-4.927479612113648e-12,
3.9759904555149456e-13,
-2.746497917636635e-14,
// [13.5,14.]: m=37 maxabs=4.98326688226446e-20 maxrel=1.782509039377107e-12
2.1983922608148155e-8,
-1.0565276101442913e-8,
2.54249323169662e-9,
-4.0844826458785705e-10,
4.9274764374739596e-11,
-4.761215208246424e-12,
3.846113647929513e-13,
-2.6595507264476873e-14,
// [13.5,14.]: m=38 maxabs=4.834705244249936e-20 maxrel=1.7985845366030735e-12
2.1130552202861733e-8,
-1.0169972901610986e-8,
2.4506895898377832e-9,
-3.9419912199716736e-10,
4.7612121281897744e-11,
-4.6056692808807154e-12,
3.724356410777335e-13,
-2.5778804511214525e-14,
// [13.5,14.]: m=39 maxabs=4.695408029096006e-20 maxrel=1.8140713702320233e-12
2.033994580319864e-8,
-9.802758334926347e-9,
2.3651947342226432e-9,
-3.8089794722871036e-10,
4.60566629469748e-11,
-4.45984881606288e-12,
3.6099882142603207e-13,
-2.5010250911861377e-14,
// [13.5,14.]: m=40 maxabs=4.561735642107437e-20 maxrel=1.827893949725445e-12
1.9605516669829977e-8,
-9.460778913172507e-9,
2.2853876855490987e-9,
-3.684542522641636e-10,
4.459845916209056e-11,
-4.322878611649166e-12,
3.5023626361852887e-13,
-2.4285742799266e-14
},
{
// [14.,14.5]: m=0 maxabs=1.6653345369377348e-16 maxrel=7.031056999683863e-16
0.23476722569555653,
-0.004118711896496724,
0.00010838431484172467,
-3.168658628793588e-6,
9.72241906036157e-8,
-3.0642979133151995e-9,
9.813576971494058e-11,
-3.1974912836063828e-12,
// [14.,14.5]: m=1 maxabs=0. maxrel=0.
0.008237423792994253,
-0.0004335372593643056,
0.000019011951747785276,
-7.77793642079574e-7,
3.064320176432909e-8,
-1.1768054148556185e-9,
4.427023060436408e-11,
-1.6214228849493359e-12,
// [14.,14.5]: m=2 maxabs=9.75781955236954e-19 maxrel=1.0766696619127351e-15
0.0008670745187286016,
-0.00007604780698991983,
4.666761853837676e-6,
-2.451456566157782e-7,
1.1768026280903993e-8,
-5.308698716572464e-10,
2.2809143204912564e-11,
-9.36410692569899e-13,
// [14.,14.5]: m=3 maxabs=7.589415207398531e-19 maxrel=4.690355209354392e-15
0.0001520956139798388,
-0.000018667047414759604,
1.4708739397815433e-6,
-9.414423353529973e-8,
5.308697483331275e-9,
-2.7348782778021006e-10,
1.311375807587063e-11,
-5.890768239135208e-13,
// [14.,14.5]: m=4 maxabs=5.827586677109586e-19 maxrel=1.441667480288327e-14
0.00003733409482951852,
-5.8834957587383516e-6,
5.648654012746185e-7,
-4.246959540333948e-8,
2.7348773898961265e-9,
-1.5721570897949688e-10,
8.25005136930859e-12,
-3.9888916362144123e-13,
// [14.,14.5]: m=5 maxabs=4.2182240773264157e-19 maxrel=3.2539832502615195e-14
0.000011766991517476334,
-2.259461604818555e-6,
2.5481757245503434e-7,
-2.187903031800638e-8,
1.572156611888056e-9,
-9.889310385586166e-11,
5.586029635322642e-12,
-2.8670158635291086e-13,
// [14.,14.5]: m=6 maxabs=3.2864878353466853e-19 maxrel=6.49117002227657e-14
4.518923209636867e-6,
-1.0192702896087052e-6,
1.3127418193037735e-7,
-1.2577261347672061e-8,
9.88930744240797e-10,
-6.695124068987326e-11,
4.0147571746234435e-12,
-2.1625873889930483e-13,
// [14.,14.5]: m=7 maxabs=2.659683454378503e-19 maxrel=1.145927688201336e-13
2.038540579217256e-6,
-5.250967275557146e-7,
7.546356810069391e-8,
-7.911452582093595e-9,
6.69512211679879e-10,
-4.811347027955181e-11,
3.0282461452506944e-12,
-1.6962464376371673e-13,
// [14.,14.5]: m=8 maxabs=2.4796889530869642e-19 maxrel=2.043101586443305e-13
1.0501934551126816e-6,
-3.018542722971347e-7,
4.7468715138823365e-8,
-5.35610366099221e-9,
4.81137120252861e-10,
-3.628196689043106e-11,
2.3697448753916623e-12,
-1.4973655342487653e-13,
// [14.,14.5]: m=9 maxabs=1.8687664398798001e-19 maxrel=2.64254303501569e-13
6.037085445370701e-7,
-1.8987486190564034e-7,
3.213661836774696e-8,
-3.849080819090105e-9,
3.628743227207371e-10,
-2.8460228356687014e-11,
1.9232093138571665e-12,
-1.1412654107421608e-13,
// [14.,14.5]: m=10 maxabs=1.615715346887578e-19 maxrel=3.589058956524778e-13
3.7974972381119535e-7,
-1.2854647337635618e-7,
2.30944849227554e-8,
-2.9029983665053914e-9,
2.8460217396813913e-10,
-2.3042180519565113e-11,
1.5981221655433303e-12,
-9.687950387125461e-14,
// [14.,14.5]: m=11 maxabs=3.382837833096862e-19 maxrel=1.0985521060609145e-12
2.5709294675277314e-7,
-9.237793960639905e-8,
1.741799017002963e-8,
-2.2768206043741354e-9,
2.3042196902672247e-10,
-1.9146609321036263e-11,
1.3560594810889977e-12,
-8.249008962158661e-14,
// [14.,14.5]: m=12 maxabs=1.257843926672636e-19 maxrel=5.63423916914341e-13
1.847558792184624e-7,
-6.967196075226145e-8,
1.366092397660093e-8,
-1.8433765667344323e-9,
1.9146067537962517e-10,
-1.6251792522346985e-11,
1.1721191485107604e-12,
-7.339530350549784e-14,
// [14.,14.5]: m=13 maxabs=1.1167600013955916e-19 maxrel=6.583392424584812e-13
1.3934392150452619e-7,
-5.4643695843855596e-8,
1.1060259407816717e-8,
-1.5316879355762894e-9,
1.6251783731936457e-10,
-1.4041065806078524e-11,
1.027802030930298e-12,
-6.502758556313251e-14,
// [14.,14.5]: m=14 maxabs=1.0217334926254998e-19 maxrel=7.631874465517597e-13
1.0928739168570302e-7,
-4.424103756662692e-8,
9.190127695138442e-9,
-1.3001450966294946e-9,
1.4040987898511837e-10,
-1.2311312936963258e-11,
9.124635996307957e-13,
-5.846379428445795e-14,
// [14.,14.5]: m=15 maxabs=9.326626842657898e-20 maxrel=8.559600399702109e-13
8.848207513320748e-8,
-3.6760510728859195e-8,
7.800870584251932e-9,
-1.1232810995864118e-9,
1.2311306961302095e-10,
-1.0929713772426428e-11,
8.186844433258292e-13,
-5.293066685524762e-14,
// [14.,14.5]: m=16 maxabs=8.568267657069282e-20 maxrel=9.422103684244092e-13
7.352102145767536e-8,
-3.1203482289841545e-8,
6.7396866016461825e-9,
-9.849064435027525e-10,
1.0929708270575944e-10,
-9.8061022235537e-12,
7.412053313901727e-13,
-4.8295837031494443e-14,
// [14.,14.5]: m=17 maxabs=7.922405034787878e-20 maxrel=1.022517445885422e-12
6.240696457964347e-8,
-2.6958746363255312e-8,
5.909438664822519e-9,
-8.743783947581655e-10,
9.806097146921393e-11,
-8.877826482058858e-12,
6.763041728373637e-13,
-4.436590800950045e-14,
// [14.,14.5]: m=18 maxabs=7.35462826233148e-20 maxrel=1.0952241192804619e-12
5.391749272647369e-8,
-2.3637754619251078e-8,
5.246270372095773e-9,
-7.844893732763871e-10,
8.877821756505685e-11,
-8.100275726291428e-12,
6.212738314330275e-13,
-4.0997646126319965e-14,
// [14.,14.5]: m=19 maxabs=6.864275595210045e-20 maxrel=1.162670619534007e-12
4.727550923846788e-8,
-2.0985081451190024e-8,
4.706936242947789e-9,
-7.102272281826713e-10,
8.10027133955099e-11,
-7.44100472350182e-12,
5.741074220031122e-13,
-3.808280972665433e-14,
// [14.,14.5]: m=20 maxabs=6.43414167668247e-20 maxrel=1.224728403022967e-12
4.1970162902347855e-8,
-1.882774493708378e-8,
4.261363372189629e-9,
-6.480230954367209e-10,
7.441000597143524e-11,
-6.875961847061679e-12,
5.332913834232785e-13,
-3.553872532642903e-14,
// [14.,14.5]: m=21 maxabs=6.049668127967823e-20 maxrel=1.2809178255494815e-12
3.765548987413722e-8,
-1.7045453456235216e-8,
3.888138575529988e-9,
-5.952813486551944e-10,
6.875957967889856e-11,
-6.387008460358427e-12,
4.97666279687985e-13,
-3.330102644680636e-14,
// [14.,14.5]: m=22 maxabs=5.710193204576061e-20 maxrel=1.3331278086451178e-12
3.4090906912441884e-8,
-1.5552554271533614e-8,
3.57168809467365e-9,
-5.500778608649629e-10,
6.387004803443231e-11,
-5.960250551383229e-12,
4.663313720775207e-13,
-3.13190795662143e-14,
// [14.,14.5]: m=23 maxabs=5.407775972626674e-20 maxrel=1.3816007979900074e-12
3.110510854304024e-8,
-1.4286752349832486e-8,
3.3004671677927387e-9,
-5.109615387464457e-10,
5.96024709046849e-11,
-5.584893941721393e-12,
4.385776980247144e-13,
-2.955254006767789e-14,
// [14.,14.5]: m=24 maxabs=5.131166775788941e-20 maxrel=1.4251600004527428e-12
2.8573504699639317e-8,
-1.3201868643857827e-8,
3.065769234944246e-9,
-4.768208597654034e-10,
5.5848906524939636e-11,
-5.252444039017786e-12,
4.138408519093137e-13,
-2.7969054401481493e-14,
// [14.,14.5]: m=25 maxabs=4.880365614062863e-20 maxrel=1.4651440736038565e-12
2.6403737287691437e-8,
-1.2263076913856968e-8,
2.8609251609243718e-9,
-4.467922889931011e-10,
5.252440925752318e-11,
-4.9561369671317096e-12,
3.91666449914467e-13,
-2.6542146074818025e-14,
// [14.,14.5]: m=26 maxabs=4.651402020508185e-20 maxrel=1.5017133516484227e-12
2.4526153827690864e-8,
-1.1443700619039082e-8,
2.6807537361879154e-9,
-4.201962604044128e-10,
4.9561339952846136e-11,
-4.690528539807288e-12,
3.7168513901817195e-13,
-2.5250226230064735e-14,
// [14.,14.5]: m=27 maxabs=4.446922973085077e-20 maxrel=1.5370342255455906e-12
2.2887401238054984e-8,
-1.0723014921239008e-8,
2.521177564552895e-9,
-3.9649166008387337e-10,
4.690525703980335e-11,
-4.451193332516527e-12,
3.5359392233406464e-13,
-2.407536092263493e-14,
// [14.,14.5]: m=28 maxabs=4.2570023044429016e-20 maxrel=1.5689420732079422e-12
2.1446029842456738e-8,
-1.008471023574801e-8,
2.3789499625454674e-9,
-3.752429548576431e-10,
4.4511906097482406e-11,
-4.2345010794011154e-12,
3.371421727162121e-13,
-2.300267908994624e-14,
// [14.,14.5]: m=29 maxabs=4.0826326313167234e-20 maxrel=1.598682981856758e-12
2.01694204714757e-8,
-9.515799828678522e-9,
2.251457731099107e-9,
-3.5609610891261466e-10,
4.234498473450824e-11,
-4.0374487583020794e-12,
3.221209248371186e-13,
-2.2019599396739922e-14,
// [14.,14.5]: m=30 maxabs=3.92050523125633e-20 maxrel=1.6258445716090174e-12
1.9031599657337476e-8,
-9.005830903775418e-9,
2.1365766553557197e-9,
-3.38760702705613e-10,
4.0374462498366925e-11,
-3.857532754127637e-12,
3.083546982659755e-13,
-2.1115578824642734e-14,
// [14.,14.5]: m=31 maxabs=3.771612720996785e-20 maxrel=1.6516182944880677e-12
1.801166180753205e-8,
-8.546306601616453e-9,
2.032564218037607e-9,
-3.229964922373202e-10,
3.857530347269745e-11,
-3.692650788676246e-12,
2.956951547617749e-13,
-2.0281561191205857e-14,
// [14.,14.5]: m=32 maxabs=3.644226906663619e-20 maxrel=1.6806656940881946e-12
1.709261320321231e-8,
-8.130256853056544e-9,
1.9379789551586114e-9,
-3.086031906821823e-10,
3.6926484982224e-11,
-3.5410208828410032e-12,
2.8401511781372035e-13,
-1.951889546211346e-14,
// [14.,14.5]: m=33 maxabs=3.5042679470196464e-20 maxrel=1.697917201198564e-12
1.6260513706178276e-8,
-7.751915802308233e-9,
1.851619140982869e-9,
-2.9541261153915933e-10,
3.5410234244518495e-11,
-3.401145632673228e-12,
2.732095978821807e-13,
-1.8793825055204846e-14,
// [14.,14.5]: m=34 maxabs=3.3854848110570317e-20 maxrel=1.719582393139515e-12
1.5503831604599558e-8,
-7.406476546227997e-9,
1.772475670856874e-9,
-2.8328258208011005e-10,
3.4011434705096685e-11,
-3.2717172394273693e-12,
2.631827298692591e-13,
-1.812773337441139e-14,
// [14.,14.5]: m=35 maxabs=3.2736499922398623e-20 maxrel=1.7395463165581437e-12
1.4812953092439687e-8,
-7.089902666330614e-9,
1.6996954940479787e-9,
-2.720921615004287e-10,
3.2717151484587517e-11,
-3.151627755550115e-12,
2.5385519648506325e-13,
-1.750661442532494e-14,
// [14.,14.5]: m=36 maxabs=3.1671091293430324e-20 maxrel=1.7573454392429232e-12
1.4179805332645466e-8,
-6.798781959662252e-9,
1.63255297051637e-9,
-2.617378730555181e-10,
3.1516257366888157e-11,
-3.039915063031455e-12,
2.45157219843825e-13,
-1.6926094206989626e-14,
// [14.,14.5]: m=37 maxabs=3.069170944816754e-20 maxrel=1.7752377163163826e-12
1.359756391930923e-8,
-6.530211866067105e-9,
1.5704272397998041e-9,
-2.521306988689386e-10,
3.0399131071663796e-11,
-2.935743260856128e-12,
2.370279086077628e-13,
-1.6382363716100852e-14,
// [14.,14.5]: m=38 maxabs=2.974872354985709e-20 maxrel=1.7908187121567458e-12
1.3060423732119362e-8,
-6.281708943698693e-9,
1.512784194639162e-9,
-2.4319366858467234e-10,
2.935741360671369e-11,
-2.8383828392292815e-12,
2.294138853671894e-13,
-1.5872092440187892e-14,
// [14.,14.5]: m=39 maxabs=2.88785295454513e-20 maxrel=1.8066020465771765e-12
1.256341788738296e-8,
-6.051136763524381e-9,
1.4591620128908995e-9,
-2.348599101286156e-10,
2.8383809973099048e-11,
-2.747194464448002e-12,
2.2226818638192824e-13,
-1.5392298597387748e-14,
// [14.,14.5]: m=40 maxabs=2.80579663777987e-20 maxrel=1.8215821496434864e-12
1.210227352703476e-8,
-5.836648036972863e-9,
1.4091594621137583e-9,
-2.2707106340073403e-10,
2.747192676933304e-11,
-2.66161557879255e-12,
2.1554933906720522e-13,
-1.4940354543121242e-14
},
{
// [14.5,15.]: m=0 maxabs=0. maxrel=0.
0.23075382371016606,
-0.003911075100403791,
0.00009943244837427111,
-2.808548825661151e-6,
8.326972989971175e-8,
-2.5370350022349785e-9,
7.858798612296398e-11,
-2.2904015577606005e-12,
// [14.5,15.]: m=1 maxabs=3.469446951953614e-18 maxrel=4.3231298713937344e-16
0.007822150200807076,
-0.00039772979349265563,
0.000016851293002690312,
-6.661579248906553e-7,
2.536964948598998e-8,
-9.425208808530693e-10,
3.4346810736380884e-11,
-1.2231538021951722e-12,
// [14.5,15.]: m=2 maxabs=4.336808689942018e-19 maxrel=5.223891359074458e-16
0.0007954595869853107,
-0.00006740517200969687,
3.996947550026038e-6,
-2.0295722965568304e-7,
9.425194853942962e-9,
-4.118804225074067e-10,
1.7176837958705728e-11,
-6.858980221898333e-13,
// [14.5,15.]: m=3 maxabs=4.607859233063394e-19 maxrel=3.2196142400072286e-15
0.00013481034401938952,
-0.000015987790199681274,
1.217743378202507e-6,
-7.54015755063383e-8,
4.118801314292674e-9,
-2.059632400605555e-10,
9.610677653422792e-12,
-4.213449493149867e-13,
// [14.5,15.]: m=4 maxabs=3.6591823321385775e-19 maxrel=1.059759541075555e-14
0.00003197558039936176,
-4.870973512537487e-6,
4.5240945310455355e-7,
-3.2950421445018444e-8,
2.0596315476483354e-9,
-1.152232516676862e-10,
5.90151169380442e-12,
-2.7938518576266917e-13,
// [14.5,15.]: m=5 maxabs=2.829090043829363e-19 maxrel=2.644423230635612e-14
9.741947025074673e-6,
-1.8096378122250081e-6,
1.9770252869384597e-7,
-1.6477060089652388e-8,
1.1522322190717834e-9,
-7.074418625298711e-11,
3.912315801432891e-12,
-1.9718433168513136e-13,
// [14.5,15.]: m=6 maxabs=2.210755992333724e-19 maxrel=5.4713635339086594e-14
3.6192756244498278e-6,
-7.908101146322139e-7,
9.886236055488588e-8,
-9.217863474505527e-9,
7.074416368552112e-10,
-4.689286747689558e-11,
2.7613057437354664e-12,
-1.4646642271270857e-13,
// [14.5,15.]: m=7 maxabs=1.7533582008164017e-19 maxrel=9.773949797281487e-14
1.5816202292643173e-6,
-3.9544944210877036e-7,
5.530718085754916e-8,
-5.659537524659818e-9,
4.689285352875261e-10,
-3.309314456313201e-11,
2.0509749955535538e-12,
-1.1340161394422382e-13,
// [14.5,15.]: m=8 maxabs=3.171079596283287e-18 maxrel=3.482816169786235e-12
7.908988842168458e-7,
-2.2122872335362562e-7,
3.395722527519658e-8,
-3.751431686684095e-9,
3.309290512631875e-10,
-2.457523884237546e-11,
1.5944512703727527e-12,
-1.0035699142478193e-13,
// [14.5,15.]: m=9 maxabs=1.2165510704939889e-19 maxrel=2.3560774798645807e-13
4.4245744668296924e-7,
-1.3582890054964646e-7,
2.2508590983759995e-8,
-2.6474536620869905e-9,
2.4577635554572527e-10,
-1.9027400155707925e-11,
1.271760879942397e-12,
-7.47767524996063e-14,
// [14.5,15.]: m=10 maxabs=1.0444975030829591e-19 maxrel=3.2548564185842855e-13
2.7165780109923896e-7,
-9.003436387350548e-8,
1.5884721977747704e-8,
-1.966213305090915e-9,
1.902739317035e-10,
-1.5237510270202513e-11,
1.0470984254513273e-12,
-6.298371061461882e-14,
// [14.5,15.]: m=11 maxabs=9.09766324910322e-20 maxrel=4.231713460555316e-13
1.8006872774696348e-7,
-6.353888785818622e-8,
1.179727983507411e-8,
-1.5221935655459673e-9,
1.523750424790877e-10,
-1.254490803405785e-11,
8.81964399240046e-13,
-5.4059645702711406e-14,
// [14.5,15.]: m=12 maxabs=8.049459976876023e-20 maxrel=5.257092862589877e-13
1.2707777571633153e-7,
-4.71891192942568e-8,
9.133161397210385e-9,
-1.219002181186489e-9,
1.2544902782485782e-10,
-1.056589668256652e-11,
7.57003084737477e-13,
-4.713518587550221e-14,
// [14.5,15.]: m=13 maxabs=7.189192139820874e-20 maxrel=6.27299535072836e-13
9.43782385884772e-8,
-3.6532645548165905e-8,
7.314013090634604e-9,
-1.0035938494780886e-9,
1.0565891989402715e-10,
-9.068419782279508e-12,
6.600428537855399e-13,
-4.164473874733722e-14,
// [14.5,15.]: m=14 maxabs=6.486419491395822e-20 maxrel=7.262790649622964e-13
7.306529109648897e-8,
-2.9256052326220546e-8,
6.021563100041068e-9,
-8.452728126990678e-10,
9.068415553785723e-11,
-7.90656073024395e-12,
5.831615796517314e-13,
-3.7208625896553433e-14,
// [14.5,15.]: m=15 maxabs=5.897466895258066e-20 maxrel=8.200152249606672e-13
5.85121046524111e-8,
-2.4086252367385254e-8,
5.0716368790621735e-9,
-7.254745554342701e-10,
7.906556910731419e-11,
-6.985352129406632e-12,
5.210429263979755e-13,
-3.356492630670286e-14,
// [14.5,15.]: m=16 maxabs=5.405128994666504e-20 maxrel=9.086140253731899e-13
4.817250473474311e-8,
-2.0286547486431304e-8,
4.352847335229379e-9,
-6.325257454627451e-10,
6.985348637656944e-11,
-6.24106658457401e-12,
4.700205512749616e-13,
-3.0528650555405693e-14,
// [14.5,15.]: m=17 maxabs=4.981612521039354e-20 maxrel=9.903503870543691e-13
4.057309497283743e-8,
-1.7411389313604606e-8,
3.7951544751888985e-9,
-5.588289834738889e-10,
6.241063370034741e-11,
-5.629759192086928e-12,
4.2750392788653024e-13,
-2.7966237523239204e-14,
// [14.5,15.]: m=18 maxabs=4.616329562535937e-20 maxrel=1.0656980137046941e-12
3.482277862718599e-8,
-1.518061787557782e-8,
3.352973903067996e-9,
-4.992860766518939e-10,
5.629756228679316e-11,
-5.120379756856506e-12,
3.916220921921651e-13,
-2.5779204605245098e-14,
// [14.5,15.]: m=19 maxabs=4.2993539518056166e-20 maxrel=1.1351200908966427e-12
3.036123575113405e-8,
-1.3411895588936766e-8,
2.9957164619797174e-9,
-4.503814316707608e-10,
5.120376999451701e-11,
-4.690504843021825e-12,
3.609970879105111e-13,
-2.3893793926219355e-14,
// [14.5,15.]: m=20 maxabs=4.022744754967884e-20 maxrel=1.1992058718471291e-12
2.6823791177853346e-8,
-1.1982865826185751e-8,
2.7022885919643e-9,
-4.0963102925573127e-10,
4.6905022561300664e-11,
-4.3236198429488225e-12,
3.345958844196461e-13,
-2.2253846341627153e-14,
// [14.5,15.]: m=21 maxabs=3.776575804672103e-20 maxrel=1.2574128694427341e-12
2.3965731652352504e-8,
-1.080915434752741e-8,
2.457786177355434e-9,
-3.7524099364420375e-10,
4.3236174158243424e-11,
-4.007344533509234e-12,
3.1163148324473984e-13,
-2.0815897582390264e-14,
// [14.5,15.]: m=22 maxabs=3.5591927396931675e-20 maxrel=1.3112937299629214e-12
2.161830869503692e-8,
-9.83114469033269e-9,
2.2514459635792174e-9,
-3.4589015680331293e-10,
4.007342250109412e-11,
-3.732247981848881e-12,
2.914955860173816e-13,
-1.9545909919191374e-14,
// [14.5,15.]: m=23 maxabs=3.3633163706406105e-20 maxrel=1.3602052229379876e-12
1.966228938064849e-8,
-9.005783836329885e-9,
2.075340942438697e-9,
-3.2058809945221447e-10,
3.732245825396123e-11,
-3.4910405727266972e-12,
2.737117050771995e-13,
-1.8416928368389545e-14,
// [14.5,15.]: m=24 maxabs=3.188615825269411e-20 maxrel=1.4057452668654009e-12
1.8011567672643925e-8,
-8.301363752755025e-9,
1.9235285982368797e-9,
-2.9858034601582484e-10,
3.491038539833384e-11,
-3.2780126730417125e-12,
2.5790208204837664e-13,
-1.7407285675558736e-14,
// [14.5,15.]: m=25 maxabs=3.030458892149272e-20 maxrel=1.4475759080289248e-12
1.6602727505494995e-8,
-7.69411437683467e-9,
1.7914820775429796e-9,
-2.792837276992512e-10,
3.278010740146562e-11,
-3.088637667930008e-12,
2.4376388697567325e-13,
-1.649949665022762e-14,
// [14.5,15.]: m=26 maxabs=2.8885146990351726e-20 maxrel=1.4870146693324943e-12
1.5388228753655e-8,
-7.16592829485966e-9,
1.675702367573407e-9,
-2.622414716913337e-10,
3.088635828680178e-11,
-2.91928689461273e-12,
2.310518541083331e-13,
-1.5679239007436857e-14,
// [14.5,15.]: m=27 maxabs=2.7568275455167306e-20 maxrel=1.5223164830294494e-12
1.4331856589705628e-8,
-6.702809455709133e-9,
1.5734488314613729e-9,
-2.4709144966521805e-10,
2.9192851426427034e-11,
-2.7670218778575596e-12,
2.1956552079284456e-13,
-1.4934499112917023e-14,
// [14.5,15.]: m=28 maxabs=2.6353974315939462e-20 maxrel=1.5544250985503267e-12
1.340561891140452e-8,
-6.293795311916442e-9,
1.4825486993392945e-9,
-2.3354336834291934e-10,
2.767020096750617e-11,
-2.629440169254432e-12,
2.0913955560525237e-13,
-1.425607750730296e-14,
// [14.5,15.]: m=29 maxabs=2.5258787184919253e-20 maxrel=1.5853725736899236e-12
1.2587590623820332e-8,
-5.930194784040932e-9,
1.4012602112629827e-9,
-2.2136214037442524e-10,
2.629438561072421e-11,
-2.5045614474737133e-12,
1.9963656612029035e-13,
-1.363514238520353e-14,
// [14.5,15.]: m=30 maxabs=2.4246318115154347e-20 maxrel=1.6139582223661797e-12
1.186038956806981e-8,
-5.605040832292795e-9,
1.3281728434055866e-9,
-2.103555952429534e-10,
2.5045599008686746e-11,
-2.3907394024557656e-12,
1.9094150773247106e-13,
-1.3064997578282706e-14,
// [14.5,15.]: m=31 maxabs=2.3303332216843896e-20 maxrel=1.6400893249100602e-12
1.1210081664574065e-8,
-5.312691361376034e-9,
1.2621335725666987e-9,
-2.0036528191132748e-10,
2.390737922023373e-11,
-2.2865956634637194e-12,
1.8295737453524292e-13,
-1.2539720072885159e-14,
// [14.5,15.]: m=32 maxabs=2.2431483851213004e-20 maxrel=1.6645993088011304e-12
1.062538272274092e-8,
-5.048534278494612e-9,
1.202191692539074e-9,
-1.9125950464044169e-10,
2.2865942338033943e-11,
-2.1909680979123343e-12,
1.756018637397608e-13,
-1.2054330320333061e-14,
// [14.5,15.]: m=33 maxabs=2.1387581918171084e-20 maxrel=1.6692557965385602e-12
1.0097068556978966e-8,
-4.808766758819502e-9,
1.1475570288254192e-9,
-1.829279922518277e-10,
2.1909667646386826e-11,
-2.102868581764092e-12,
1.6880371028641487e-13,
-1.160922435964992e-14,
// [14.5,15.]: m=34 maxabs=2.0876384299613312e-20 maxrel=1.7097314630925996e-12
9.617533517636451e-9,
-4.59022810457526e-9,
1.0975679530682773e-9,
-1.7527777463169274e-10,
2.1028693177837785e-11,
-2.021461618659646e-12,
1.6250562266994693e-13,
-1.1186526368016998e-14,
// [14.5,15.]: m=35 maxabs=2.016831769526792e-20 maxrel=1.7295731446653948e-12
9.180456209140491e-9,
-4.390271801728816e-9,
1.051666648753808e-9,
-1.6822996718808452e-10,
2.0214603325170038e-11,
-1.9460185301650706e-12,
1.566525531556757e-13,
-1.0797188919521266e-14,
// [14.5,15.]: m=36 maxabs=1.9511536288900817e-20 maxrel=1.7487037747094609e-12
8.780543603447951e-9,
-4.2066665848258875e-9,
1.0093798040583816e-9,
-1.6171723416987767e-10,
1.946017289233645e-11,
-1.875918001085833e-12,
1.5120038056337816e-13,
-1.0433661591004654e-14,
// [14.5,15.]: m=37 maxabs=1.8899422635611576e-20 maxrel=1.7670674212669046e-12
8.413333169642383e-9,
-4.037519206376366e-9,
9.70303405921542e-10,
-1.556817774197745e-10,
1.8759167972978497e-11,
-1.8106194884200368e-12,
1.4610980106122644e-13,
-1.0093505971551096e-14,
// [14.5,15.]: m=38 maxabs=1.8313778761924033e-20 maxrel=1.7833842072854684e-12
8.075038412743662e-9,
-3.881213614140545e-9,
9.340906653918567e-10,
-1.5007372560450246e-10,
1.8106183224112027e-11,
-1.7496521494995436e-12,
1.4134643055471628e-13,
-9.774551280710918e-15,
// [14.5,15.]: m=39 maxabs=1.776949391886414e-20 maxrel=1.7994471579275483e-12
7.7624272282722e-9,
-3.7363626523141214e-9,
9.004423544784159e-10,
-1.4484983591526603e-10,
1.7496510142073882e-11,
-1.6926040399580231e-12,
1.3688005586202872e-13,
-9.474926808557381e-15,
// [14.5,15.]: m=40 maxabs=1.725829630030637e-20 maxrel=1.814849339977569e-12
7.47272530461967e-9,
-3.6017694089360006e-9,
8.690990163138692e-10,
-1.3997244023646958e-10,
1.6926029439381887e-11,
-1.6391133256013677e-12,
1.3268404471050187e-13,
-9.192907825418145e-15
},
{
// [15.,15.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.2129724755674178e-16
0.22693945331824295,
-0.0037203150013328736,
0.00009148217939220393,
-2.499350363158777e-6,
7.168230353613385e-8,
-2.11321717042129e-9,
6.343391839055287e-11,
-1.8368566948377092e-12,
// [15.,15.5]: m=1 maxabs=1.3608905669038052e-15 maxrel=1.784209086004273e-13
0.007440630002749485,
-0.0003659287173556356,
0.000014996100673065516,
-5.734617078746321e-7,
2.1140488826739946e-8,
-7.456489259777015e-10,
1.1267755188240578e-11,
-2.287141704058342e-11,
// [15.,15.5]: m=2 maxabs=5.421010862427522e-19 maxrel=7.107365115511729e-16
0.0007318574351156512,
-0.00005998440882969639,
3.4407519945452206e-6,
-1.6905458104173084e-7,
7.600970243069392e-9,
-3.219416346514775e-10,
1.3034520599330683e-11,
-5.068718175087467e-13,
// [15.,15.5]: m=3 maxabs=3.2526065174565133e-19 maxrel=2.558856693434221e-15
0.00011996881765939324,
-0.00001376300797785281,
1.014327486257565e-6,
-6.08077744617456e-8,
3.2194162247131756e-9,
-1.5629788652582724e-10,
7.0964213661387386e-12,
-3.0348529304176276e-13,
// [15.,15.5]: m=4 maxabs=2.608861477543245e-19 maxrel=8.799094965828596e-15
0.000027526015955704867,
-4.057309944829444e-6,
3.6484664683470486e-7,
-2.575533763788315e-8,
1.5629779978544142e-9,
-8.508269426834116e-11,
4.2516176851053165e-12,
-1.9693934437819366e-13,
// [15.,15.5]: m=5 maxabs=1.9481757786848908e-19 maxrel=2.1927646451058336e-14
8.114619889658692e-6,
-1.4593865872048504e-6,
1.54532025846448e-7,
-1.2503829326491185e-8,
8.50826677994177e-10,
-5.0968197417132105e-11,
2.7580120831689597e-12,
-1.3642055901918335e-13,
// [15.,15.5]: m=6 maxabs=1.486542822431297e-19 maxrel=4.577531888339913e-14
2.9187731744096063e-6,
-6.181281032881265e-7,
7.502297596896433e-8,
-6.8066173252716595e-9,
5.096818374472961e-10,
-3.3058727079699565e-11,
1.910329876105591e-12,
-9.97101799509213e-14,
// [15.,15.5]: m=7 maxabs=1.1625527201065272e-19 maxrel=8.32152325838896e-14
1.236256206576167e-6,
-3.00091903801522e-7,
4.083970395940121e-8,
-4.077457673838194e-9,
3.305871687351711e-10,
-2.2895402234368923e-11,
1.3962672226520897e-12,
-7.615541164885293e-14,
// [15.,15.5]: m=8 maxabs=9.5185327447702e-20 maxrel=1.3828547516871614e-13
6.001838076029901e-7,
-1.6335881577870883e-7,
2.4464746048233004e-8,
-2.644699705417064e-9,
2.2895395295711164e-10,
-1.6732595692901077e-11,
1.0663974368035835e-12,
-6.029153194964398e-14,
// [15.,15.5]: m=9 maxabs=7.919758056827708e-20 maxrel=2.0849479261532256e-13
3.267176315573725e-7,
-9.785898414492571e-8,
1.5868198236816278e-8,
-1.8316335438649394e-9,
1.6732589970069603e-10,
-1.277833484430417e-11,
8.442638793596056e-13,
-4.9159748177026544e-14,
// [15.,15.5]: m=10 maxabs=6.760381710273385e-20 maxrel=2.934480596554654e-13
1.957179682898146e-7,
-6.347279290715597e-8,
1.098980126665426e-8,
-1.3386088018768627e-9,
1.2778330250589415e-10,
-1.0115766095043661e-11,
6.883831792273663e-13,
-4.106677588679193e-14,
// [15.,15.5]: m=11 maxabs=5.86040920381569e-20 maxrel=3.879332218259498e-13
1.269455858142806e-7,
-4.395920503244033e-8,
8.031652814258905e-9,
-1.0222677872251413e-9,
1.0115762107315921e-10,
-8.247472590267902e-12,
5.750622004503315e-13,
-3.500243171850046e-14,
// [15.,15.5]: m=12 maxabs=5.0451399920834264e-20 maxrel=4.776615257820407e-13
8.791841006483366e-8,
-3.2126611227027156e-8,
6.133606729801783e-9,
-8.09262157838253e-10,
8.247461766575458e-11,
-6.889451300815076e-12,
4.903517106092685e-13,
-3.00227100270399e-14,
// [15.,15.5]: m=13 maxabs=4.581918849053731e-20 maxrel=5.887743896492079e-13
6.425322245478895e-8,
-2.453442687753686e-8,
4.855572924425874e-9,
-6.597985777652799e-10,
6.889366665113081e-11,
-5.8717090598242384e-12,
4.248189441557606e-13,
-2.6666656418468023e-14,
// [15.,15.5]: m=14 maxabs=4.871762935692312e-20 maxrel=8.140985004382582e-13
4.906885375520817e-8,
-1.9422291674696845e-8,
3.958791469446087e-9,
-5.511502542724754e-10,
5.871705396243624e-11,
-5.0889841819474e-12,
3.7344014472494186e-13,
-2.360177394398478e-14,
// [15.,15.5]: m=15 maxabs=3.7315771793492184e-20 maxrel=7.831068192630448e-13
3.884458334911625e-8,
-1.5835165853625777e-8,
3.306901560409669e-9,
-4.697373425488207e-10,
5.088929716942578e-11,
-4.473034574117028e-12,
3.3217111184401137e-13,
-2.1316155694186684e-14,
// [15.,15.5]: m=16 maxabs=3.410631101678644e-20 maxrel=8.735675981572499e-13
3.1670331707234263e-8,
-1.3227606222770528e-8,
2.818424056948729e-9,
-4.071151321220872e-10,
4.473032369173144e-11,
-3.978807340515578e-12,
2.9849668547815015e-13,
-1.9323071060851606e-14,
// [15.,15.5]: m=17 maxabs=3.1373306272911234e-20 maxrel=9.57961604914605e-13
2.6455212445525194e-8,
-1.1273696210559839e-8,
2.4426907942546874e-9,
-3.5784327894216086e-10,
3.978805311187292e-11,
-3.5753418385198166e-12,
2.7058794390010873e-13,
-1.7649191177125813e-14,
// [15.,15.5]: m=18 maxabs=2.8994334831208726e-20 maxrel=1.035080665684744e-12
2.2547392421104963e-8,
-9.770763161173303e-9,
2.1470596750627927e-9,
-3.183050587313639e-10,
3.575339960333471e-11,
-3.2409703674839626e-12,
2.4714875681612965e-13,
-1.6226816348362843e-14,
// [15.,15.5]: m=19 maxabs=2.6956161801878066e-20 maxrel=1.106984747939198e-12
1.954152632233305e-8,
-8.588238685599069e-9,
1.909830353687908e-9,
-2.860277829411584e-10,
3.2409686355608765e-11,
-2.960158186211978e-12,
2.2723083176279668e-13,
-1.5005404966484173e-14,
// [15.,15.5]: m=20 maxabs=2.5156216788962678e-20 maxrel=1.1722632829154678e-12
1.717647737118545e-8,
-7.63932140113253e-9,
1.716166698865129e-9,
-2.5927803561997946e-10,
2.9601565629292894e-11,
-2.721540020921011e-12,
2.1012759322043215e-13,
-1.3946812931683012e-14,
// [15.,15.5]: m=21 maxabs=2.3597808514912774e-20 maxrel=1.2334674642737494e-12
1.527864280225338e-8,
-6.864666782744146e-9,
1.5556682148521554e-9,
-2.368130336946514e-10,
2.7215385093960065e-11,
-2.5166480191552333e-12,
1.9530376606371575e-13,
-1.3021519792514264e-14,
// [15.,15.5]: m=22 maxabs=2.219491019602284e-20 maxrel=1.2885473015845926e-12
1.3729333565476344e-8,
-6.222672847490317e-9,
1.4208782032712003e-9,
-2.1772355753589499e-10,
2.516646559635695e-11,
-2.339067792485293e-12,
1.823478319554972e-13,
-1.2206844542785229e-14,
// [15.,15.5]: m=23 maxabs=2.0950830554743085e-20 maxrel=1.3395340357795438e-12
1.2445345694970096e-8,
-5.683512801869723e-9,
1.3063413462250296e-9,
-2.0133217337245415e-10,
2.3390664457667583e-11,
-2.183867332122461e-12,
1.7093892967578055e-13,
-1.1484585607442813e-14,
// [15.,15.5]: m=24 maxabs=1.9827519282896073e-20 maxrel=1.3859070651552512e-12
1.1367025603730358e-8,
-5.225365374316058e-9,
1.207993041154071e-9,
-1.8712573906935985e-10,
2.183866096397073e-11,
-2.0472022240750203e-12,
1.608238652591597e-13,
-1.0840144961047134e-14,
// [15.,15.5]: m=25 maxabs=1.8824976380481804e-20 maxrel=1.429319543560657e-12
1.045073074862274e-8,
-4.831972154594354e-9,
1.1227544353168564e-9,
-1.7470968858331235e-10,
2.0472010231720055e-11,
-1.9260380658359797e-12,
1.5180045064661623e-13,
-1.026207126364202e-14,
// [15.,15.5]: m=26 maxabs=1.791176898422326e-20 maxrel=1.4689902248979376e-12
9.663944309179804e-9,
-4.491017731754556e-9,
1.048258132357285e-9,
-1.637764623637437e-10,
1.9260369218530148e-11,
-1.817952558552974e-12,
1.4370561237729645e-13,
-9.74083254528284e-15,
// [15.,15.5]: m=27 maxabs=1.708624273289534e-20 maxrel=1.5061032347569526e-12
8.982035463500641e-9,
-4.193032520377825e-9,
9.82658774998952e-10,
-1.5408331580718195e-10,
1.8179514695787143e-11,
-1.720991603613317e-12,
1.3640651247470453e-13,
-9.268595883985877e-15,
// [15.,15.5]: m=28 maxabs=1.6323582208121448e-20 maxrel=1.539696820609085e-12
8.386065040747124e-9,
-3.930635091362092e-9,
9.244998956309432e-10,
-1.4543646284929883e-10,
1.7209905526927642e-11,
-1.6335635103819299e-12,
1.2979398237650983e-13,
-8.8389814019663e-15,
// [15.,15.5]: m=29 maxabs=1.5633713577252223e-20 maxrel=1.5717478051025553e-12
7.861270182716432e-9,
-3.69799957427498e-9,
8.726187778415697e-10,
-1.3767957416249165e-10,
1.6335625156485686e-11,
-1.5543603268677874e-12,
1.2377756974341498e-13,
-8.446508081339038e-15,
// [15.,15.5]: m=30 maxabs=1.4991821421911074e-20 maxrel=1.600816127750323e-12
7.395999148542493e-9,
-3.4904751034688094e-9,
8.260774456931931e-10,
-1.3068531714580107e-10,
1.5543593691870532e-11,
-1.482298296084629e-12,
1.182817520963075e-13,
-8.086685677612308e-15,
// [15.,15.5]: m=31 maxabs=1.4399560103323106e-20 maxrel=1.6278692184840824e-12
6.9809502069304505e-9,
-3.3043097751987625e-9,
7.841119035644545e-10,
-1.2434905249391413e-10,
1.48229737616826e-11,
-1.4164726338518395e-12,
1.1324303849995881e-13,
-7.755674099094007e-15,
// [15.,15.5]: m=32 maxabs=1.3853620899038107e-20 maxrel=1.6533504637292805e-12
6.608619550390644e-9,
-3.1364476069819585e-9,
7.460943156254912e-10,
-1.1858408112352502e-10,
1.4164717510113296e-11,
-1.356122610199325e-12,
1.0860768253903873e-13,
-7.450190141729186e-15,
// [15.,15.5]: m=33 maxabs=1.334904072538076e-20 maxrel=1.677433550841046e-12
6.2728952139572714e-9,
-2.9843772555023797e-9,
7.115044873800328e-10,
-1.1331802006219567e-10,
1.3561217581747568e-11,
-1.3006043841148597e-12,
1.0432992447255209e-13,
-7.16745071900111e-15,
// [15.,15.5]: m=34 maxabs=1.2875893415000429e-20 maxrel=1.6995287048095276e-12
5.968754510998365e-9,
-2.846017942776986e-9,
6.799081209885358e-10,
-1.084900103796448e-10,
1.3006035633328536e-11,
-1.2493697157707378e-12,
1.0037057671220692e-13,
-6.905037695029046e-15,
// [15.,15.5]: m=35 maxabs=1.2434178967897112e-20 maxrel=1.7201809920468363e-12
5.692035885547781e-9,
-2.7196324774492032e-9,
6.509400628724539e-10,
-1.0404854526058662e-10,
1.2493689231646952e-11,
-1.2019490811786716e-12,
9.669588639293234e-14,
-6.6608661203462315e-15,
// [15.,15.5]: m=36 maxabs=1.2023070203458257e-20 maxrel=1.739826247926194e-12
5.439264954892429e-9,
-2.6037602452074845e-9,
6.242912721383209e-10,
-9.994976514695837e-11,
1.2019483145563538e-11,
-1.1579382141282111e-12,
9.327665813968311e-14,
-6.433131516808015e-15,
// [15.,15.5]: m=37 maxabs=1.1640912760458758e-20 maxrel=1.758762914915631e-12
5.207520490409196e-9,
-2.4971650824786835e-9,
5.996985914362816e-10,
-9.615610814542097e-11,
1.157937474744136e-11,
-1.1169872976921287e-12,
9.008749814653895e-14,
-6.220233508292099e-15,
// [15.,15.5]: m=38 maxabs=1.1278607652160532e-20 maxrel=1.7760820066513447e-12
4.994330164951759e-9,
-2.3987943598655014e-9,
5.769366494112247e-10,
-9.263523316610486e-11,
1.1169865796454163e-11,
-1.0787921815457483e-12,
8.71062385346597e-14,
-6.02079474406485e-15,
// [15.,15.5]: m=39 maxabs=1.0938636420401238e-20 maxrel=1.7925452751836034e-12
4.797588719725573e-9,
-2.3077465919480624e-9,
5.55811399519203e-10,
-8.935915424627187e-11,
1.0787914845164333e-11,
-1.0430872641623537e-12,
8.431343351765733e-14,
-5.833588584488611e-15,
// [15.,15.5]: m=40 maxabs=1.061934470395577e-20 maxrel=1.8082782851602724e-12
4.615493183890811e-9,
-2.2232455925519375e-9,
5.361549259870876e-10,
-8.630353975843421e-11,
1.0430865851619803e-11,
-1.009639625893798e-12,
8.169196623486907e-14,
-5.657539776856214e-15
},
{
// [15.5,16.]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.2330229442796923e-16
0.2233081907765642,
-0.0035445721631520133,
0.00008439400190882574,
-2.232549989129927e-6,
6.20033195460314e-8,
-1.7703074901699549e-9,
5.146600332017508e-11,
-1.54205253393783e-12,
// [15.5,16.]: m=1 maxabs=0. maxrel=0.
0.007089144326302775,
-0.00033757600763307995,
0.000013395299914067752,
-4.960266514565448e-7,
1.7703289117493448e-8,
-6.170161175908718e-10,
2.1134127616434254e-11,
-7.107898398619685e-13,
// [15.5,16.]: m=2 maxabs=4.336808689942018e-19 maxrel=6.171594367516138e-16
0.0006751520152661497,
-0.000053581199655653414,
2.9761599094037286e-6,
-1.416263329458602e-7,
6.170154761947247e-9,
-2.5344695948125807e-10,
9.964898848855e-12,
-3.763890864373759e-13,
// [15.5,16.]: m=3 maxabs=2.846030702774449e-19 maxrel=2.5112000675732046e-15
0.00010716239931130562,
-0.000011904639637373703,
8.497579978442821e-7,
-4.936124720561092e-8,
2.5344669269423314e-9,
-1.1949437144971102e-10,
5.278908979785558e-12,
-2.2016192650136343e-13,
// [15.5,16.]: m=4 maxabs=1.8295911660692887e-19 maxrel=7.150905245778652e-15
0.00002380927927474685,
-3.399031991239892e-6,
2.961674832879188e-7,
-2.0275740896232137e-8,
1.1949429390499989e-9,
-6.32944043477427e-11,
3.0848863974506113e-12,
-1.3974795724448435e-13,
// [15.5,16.]: m=5 maxabs=1.3213713977167085e-19 maxrel=1.7803325352321832e-14
6.798063982479627e-6,
-1.1846699330581956e-6,
1.2165444539326817e-7,
-9.559547236410347e-9,
6.329438234473368e-10,
-3.698297779419801e-11,
1.957193214307346e-12,
-9.494019403829918e-14,
// [15.5,16.]: m=6 maxabs=9.994988777600744e-20 maxrel=3.8037821674485315e-14
2.3693398661162937e-6,
-4.866177815063715e-7,
5.7357283427555097e-8,
-5.063553254613612e-9,
3.6982965508067267e-10,
-2.3460721096279605e-11,
1.32956056138951e-12,
-6.824349812748153e-14,
// [15.5,16.]: m=7 maxabs=7.771527291058206e-20 maxrel=7.091259466643739e-14
9.732355630126902e-7,
-2.2942913365999853e-7,
3.03813195329422e-8,
-2.9586392486382483e-9,
2.3460713992718226e-10,
-1.5935455191236395e-11,
9.55638606131587e-13,
-5.1381935302950314e-14,
// [15.5,16.]: m=8 maxabs=6.268043809681823e-20 maxrel=1.1954984475732824e-13
4.588582673199568e-7,
-1.2152527809252014e-7,
1.7751835495636296e-8,
-1.8768586893073618e-9,
1.5935450171678315e-10,
-1.1452592585702124e-11,
7.195064397989948e-13,
-4.018821264905907e-14,
// [15.5,16.]: m=9 maxabs=5.1986647137732683e-20 maxrel=1.8465343897765026e-13
2.43050556185009e-7,
-7.100734195086684e-8,
1.1261152138800016e-8,
-1.2748372807805274e-9,
1.1452588675188476e-10,
-8.621914346068346e-12,
5.627595144638574e-13,
-3.2433049480855454e-14,
// [15.5,16.]: m=10 maxabs=4.3886894579613436e-20 maxrel=2.634751682195454e-13
1.4201468390170962e-7,
-4.504460852897348e-8,
7.649023686983473e-9,
-9.162081431232117e-10,
8.621911266493231e-11,
-6.743042333497495e-12,
4.541615429909087e-13,
-2.6858939446891688e-14,
// [15.5,16.]: m=11 maxabs=3.7785610381422304e-20 maxrel=3.5362505597064525e-13
9.008921705792734e-8,
-3.0596094725742284e-8,
5.4972488606352285e-9,
-6.897537889513814e-10,
6.743039795874071e-11,
-5.4414172010392e-12,
3.7610657950171964e-13,
-2.272369730709991e-14,
// [15.5,16.]: m=12 maxabs=3.306075472251941e-20 maxrel=4.510809035329555e-13
6.119218945052747e-8,
-2.1988995423408114e-8,
4.138522735362172e-9,
-5.394439481443992e-10,
5.441415010220257e-11,
-4.505939821060779e-12,
3.182019788017646e-13,
-1.957111854645561e-14,
// [15.5,16.]: m=13 maxabs=2.928219368437718e-20 maxrel=5.512299670662926e-13
4.397799084684678e-8,
-1.6554090924671805e-8,
3.2366636902859327e-9,
-4.353138691629138e-10,
4.5059379078577564e-11,
-3.812007524835504e-12,
2.740570767874098e-13,
-1.711016179109629e-14,
// [15.5,16.]: m=14 maxabs=2.6198464360779493e-20 maxrel=6.503759958442866e-13
3.310818184933033e-8,
-1.2946654746349879e-8,
2.6118832162575083e-9,
-3.6047562438682635e-10,
3.8120058160555254e-11,
-3.283003999487563e-12,
2.3959699280238836e-13,
-1.5149236067137657e-14,
// [15.5,16.]: m=15 maxabs=2.3663982963917016e-20 maxrel=7.465437031331833e-13
2.5893309492743886e-8,
-1.044753285178998e-8,
2.1628537474617986e-9,
-3.0496099488443717e-10,
3.283002470842826e-11,
-2.8700796170220413e-12,
2.121383286236938e-13,
-1.3558413541488694e-14,
// [15.5,16.]: m=16 maxabs=2.155301804068169e-20 maxrel=8.382174085885284e-13
2.089506570356915e-8,
-8.6514149778879e-9,
1.8297659703473158e-9,
-2.6264067605511074e-10,
2.870078225968763e-11,
-2.5410672837065617e-12,
1.8986238181771898e-13,
-1.2247391910113518e-14,
// [15.5,16.]: m=17 maxabs=1.9759690472666725e-20 maxrel=9.239248526021084e-13
1.730282995576594e-8,
-7.3190638704996885e-9,
1.5758440572830394e-9,
-2.296066936793066e-10,
2.5410660095895497e-11,
-2.2741666907025827e-12,
1.7150434972363425e-13,
-1.1151912827696215e-14,
// [15.5,16.]: m=18 maxabs=1.8227751978218518e-20 maxrel=1.0036686774846433e-12
1.46381277409903e-8,
-6.303376219147567e-9,
1.3776401629485292e-9,
-2.032856801684325e-10,
2.2741655258975786e-11,
-2.054217827451273e-12,
1.5616408024608395e-13,
-1.0225195029378057e-14,
// [15.5,16.]: m=19 maxabs=1.6910880443034098e-20 maxrel=1.0777406864774016e-12
1.2606752438286705e-8,
-5.510560642583054e-9,
1.2197140818221744e-9,
-1.8193361052369804e-10,
2.0542167434296134e-11,
-1.8704317546070716e-12,
1.431874554643079e-13,
-9.432692558289373e-15,
// [15.5,16.]: m=20 maxabs=1.5754481946684965e-20 maxrel=1.1453459555503987e-12
1.102112128515828e-8,
-4.878856318745944e-9,
1.0916016638998778e-9,
-1.6433768119320431e-10,
1.8704307418986247e-11,
-1.714968896342065e-12,
1.3209014668593648e-13,
-8.748346587350956e-15,
// [15.5,16.]: m=21 maxabs=1.475028468304559e-20 maxrel=1.2083216580526495e-12
9.757712637484086e-9,
-4.366406647639564e-9,
9.8602608788138e-10,
-1.4963477778107723e-10,
1.7149679396011632e-11,
-1.5820247220834456e-12,
1.225073918328012e-13,
-8.152265955231946e-15,
// [15.5,16.]: m=22 maxabs=1.3860238343938532e-20 maxrel=1.2660638063782248e-12
8.732813295272279e-9,
-3.944104344075137e-9,
8.978086673541443e-10,
-1.3719773317412636e-10,
1.582023831939699e-11,
-1.46722787169869e-12,
1.1416019898453816e-13,
-7.628888896479627e-15,
// [15.5,16.]: m=23 maxabs=1.3057873149762095e-20 maxrel=1.3181243844049411e-12
7.888208688143634e-9,
-3.5912346624163392e-9,
8.231863996886385e-10,
-1.2656218653000782e-10,
1.467227007340142e-11,
-1.3672349040873525e-12,
1.0683213382855203e-13,
-7.166280173627875e-15,
// [15.5,16.]: m=24 maxabs=1.2343189100516279e-20 maxrel=1.3662654751853264e-12
7.18246932482655e-9,
-3.2927455921585897e-9,
7.593731197708807e-10,
-1.173784244322178e-10,
1.3672341148224666e-11,
-1.2794526619984802e-12,
1.0035320911694053e-13,
-6.754587471173794e-15,
// [15.5,16.]: m=25 maxabs=1.1704605667625342e-20 maxrel=1.4110747512480632e-12
6.5854911843113006e-9,
-3.0374924728471276e-9,
7.04270547156727e-10,
-1.093789786422606e-10,
1.2794519111146586e-11,
-1.2018437193809437e-12,
9.458824780996488e-14,
-6.386130605733179e-15,
// [15.5,16.]: m=26 maxabs=1.1123924877613116e-20 maxrel=1.451986399094262e-12
6.074984945688678e-9,
-2.8170821827142e-9,
6.562738723882002e-10,
-1.0235638939568577e-10,
1.2018430065275973e-11,
-1.132788505989933e-12,
8.94286426258559e-14,
-6.054606744655461e-15,
// [15.5,16.]: m=27 maxabs=1.0596183646804285e-20 maxrel=1.4896909544126104e-12
5.634164365423074e-9,
-2.6250954839327517e-9,
6.141383368843421e-10,
-9.61476653219366e-11,
1.1327878260412793e-11,
-1.0709856373830034e-12,
8.478625055184071e-14,
-5.754872111476614e-15,
// [15.5,16.]: m=28 maxabs=1.0117246072136081e-20 maxrel=1.5248943324736744e-12
5.2501909678605635e-9,
-2.45655334218262e-9,
5.768859924144802e-10,
-9.062324025710163e-11,
1.0709849924446893e-11,
-1.0153789702427456e-12,
8.058886019103531e-14,
-5.482741938903874e-15,
// [15.5,16.]: m=29 maxabs=9.678840347482977e-21 maxrel=1.557538675192469e-12
4.913106684361564e-9,
-2.3075439645528434e-9,
5.437394419552292e-10,
-8.567900377078249e-11,
1.0153783996208841e-11,
-9.651037310587918e-13,
7.677692663696289e-14,
-5.2344099269706935e-15,
// [15.5,16.]: m=30 maxabs=9.276830569782205e-21 maxrel=1.5879892956199672e-12
4.615087929101032e-9,
-2.174957762931119e-9,
5.140740230704837e-10,
-8.123046756097245e-11,
9.651031369928646e-12,
-9.194454373856012e-13,
7.330074631633867e-14,
-5.0071774684742285e-15,
// [15.5,16.]: m=31 maxabs=8.906253655358449e-21 maxrel=1.616331999021951e-12
4.34991552585777e-9,
-2.0562960875958316e-9,
4.873828057938629e-10,
-7.720843839998717e-11,
9.194448670551934e-12,
-8.778095377511159e-13,
7.011873073877003e-14,
-4.798443952215745e-15,
// [15.5,16.]: m=32 maxabs=8.55966497869873e-21 maxrel=1.642003082591412e-12
4.112592175187372e-9,
-1.949531218677409e-9,
4.6325063081125205e-10,
-7.355576928784307e-11,
8.778089894993766e-12,
-8.396974952673199e-13,
6.719575729159069e-14,
-4.606082526988793e-15,
// [15.5,16.]: m=33 maxabs=8.242027623478368e-21 maxrel=1.666663334213786e-12
3.899062437350713e-9,
-1.853002518920583e-9,
4.41334616121293e-10,
-7.022489213729582e-11,
8.396969694015428e-12,
-8.046884974786268e-13,
6.450198872592847e-14,
-4.428261681268277e-15,
// [15.5,16.]: m=34 maxabs=8.192396786725186e-21 maxrel=1.7419747205225475e-12
3.706005037837081e-9,
-1.765338460314756e-9,
4.2134935318406007e-10,
-6.717592419169106e-11,
8.046880131228165e-12,
-7.724246297354156e-13,
6.201130032083933e-14,
-4.2640798518163835e-15,
// [15.5,16.]: m=35 maxabs=7.669618639591673e-21 maxrel=1.710939840037459e-12
3.5306769206394677e-9,
-1.6853974088079563e-9,
4.0305554491779925e-10,
-6.437519967262552e-11,
7.724245935233578e-12,
-7.426018386952628e-13,
5.970368146124259e-14,
-4.110226125363204e-15,
// [15.5,16.]: m=36 maxabs=7.414019830312787e-21 maxrel=1.7315677937983466e-12
3.3707948176122e-9,
-1.612222175796658e-9,
3.862511983913477e-10,
-6.179412246252008e-11,
7.426013648613511e-12,
-7.149563684087829e-13,
5.755832489212758e-14,
-3.967485145776133e-15,
// [15.5,16.]: m=37 maxabs=7.173310272059856e-21 maxrel=1.7506411390901648e-12
3.224444351589733e-9,
-1.5450047898210971e-9,
3.7076473511864967e-10,
-5.940825896099272e-11,
7.1495591039890276e-12,
-6.892620839304859e-13,
5.5559449877659977e-14,
-3.8341828709711625e-15,
// [15.5,16.]: m=38 maxabs=6.946662784220326e-21 maxrel=1.768384563812378e-12
3.0900095796387205e-9,
-1.483058936852068e-9,
3.564495540987297e-10,
-5.7196617731491395e-11,
6.892616404806154e-12,
-6.653223659932455e-13,
5.369274883228105e-14,
-3.70942584772461e-15,
// [15.5,16.]: m=39 maxabs=6.732423005569092e-21 maxrel=1.7847748722105427e-12
2.9661178737007803e-9,
-1.425798212886681e-9,
3.4317970671083303e-10,
-5.514107156729889e-11,
6.653219368172111e-12,
-6.429658295121921e-13,
5.1945697697706886e-14,
-3.592425377162017e-15,
// [15.5,16.]: m=40 maxabs=6.5314181167187065e-21 maxrel=1.800408270548702e-12
2.8515964257700953e-9,
-1.3727188234424903e-9,
3.308464297166183e-10,
-5.322589097943023e-11,
6.429654126902014e-12,
-6.220424408098476e-13,
5.030728881933784e-14,
-3.4824897426612652e-15
},
{
// [16.,16.5]: m=0 maxabs=0. maxrel=0.
0.21984584034828938,
-0.0033822423493213823,
0.00007805140943674489,
-2.0012620065484537e-6,
5.3873097010518796e-8,
-1.491174721611758e-9,
4.2043608792952014e-11,
-1.2018938867456616e-12,
// [16.,16.5]: m=1 maxabs=1.734723475976807e-18 maxrel=2.505506374881942e-16
0.0067644846986401825,
-0.00031220563774519283,
0.000012007572057661309,
-4.3098486756822404e-7,
1.4911682727707385e-8,
-5.039976983974256e-10,
1.675086454863142e-11,
-5.548837932322246e-13,
// [16.,16.5]: m=2 maxabs=0. maxrel=0.
0.000624411275490411,
-0.00004803028823030342,
2.5859092028996085e-6,
-1.1929347451393934e-7,
5.040008131964963e-9,
-2.008974589649331e-10,
7.673500732557705e-12,
-2.839084542320051e-13,
// [16.,16.5]: m=3 maxabs=1.2197274440461925e-19 maxrel=1.2026912789403547e-15
0.00009606057646061073,
-0.000010343636811416214,
7.157608466537619e-7,
-4.032007182405635e-8,
2.0089804568877158e-9,
-9.201979447171198e-11,
3.955750528432961e-12,
-1.6127638985527124e-13,
// [16.,16.5]: m=4 maxabs=1.1519648082658485e-19 maxrel=5.1933951233351395e-15
0.000020687273622833213,
-2.863043386512276e-6,
2.419204308667929e-7,
-1.60718476492945e-8,
9.20199017617923e-10,
-4.7431198536641466e-11,
2.2543136817505035e-12,
-9.991883439454198e-14,
// [16.,16.5]: m=5 maxabs=8.555032767268433e-20 maxrel=1.3721013337842389e-14
5.726086773024701e-6,
-9.676817234011482e-7,
9.643108588162314e-8,
-7.361594759937281e-9,
4.743121776710699e-10,
-2.7026747014955463e-11,
1.39823287381095e-12,
-6.65161299972088e-14,
// [16.,16.5]: m=6 maxabs=6.522153693858113e-20 maxrel=3.0480775625198697e-14
1.9353634468023387e-6,
-3.857243434805376e-7,
4.416956855552745e-8,
-3.794499257766368e-9,
2.7026752529224407e-10,
-1.676117345793002e-11,
9.310468373556781e-13,
-4.697873829619541e-14,
// [16.,16.5]: m=7 maxabs=5.092785595366481e-20 maxrel=5.882440423297781e-14
7.714486869610815e-7,
-1.76678274188023e-7,
2.276699554580714e-8,
-2.162141564714897e-9,
1.6761174469519118e-10,
-1.1159490468061718e-11,
6.576711504390552e-13,
-3.4842523866496796e-14,
// [16.,16.5]: m=8 maxabs=4.097521882342678e-20 maxrel=1.018502204204248e-13
3.533565483760379e-7,
-9.106798215689425e-8,
1.2972849388969356e-8,
-1.3408950097189438e-9,
1.1159489576230497e-10,
-7.881959908664764e-12,
4.878235569801389e-13,
-2.6905782888525435e-14,
// [16.,16.5]: m=9 maxabs=3.380190855136692e-20 maxrel=1.6080088620923606e-13
1.82135964313779e-7,
-5.1891397534883395e-8,
8.045370059192036e-9,
-8.927600055109221e-10,
7.88195873555122e-11,
-5.845826505253886e-12,
3.7671854765152575e-13,
-2.1479015591334856e-14,
// [16.,16.5]: m=10 maxabs=2.8428543292222455e-20 maxrel=2.343746592344893e-13
1.0378279506975652e-7,
-3.218148021954712e-8,
5.3565600340157355e-9,
-6.305573874726629e-10,
5.845825242727436e-11,
-4.514012815682865e-12,
3.007465845223673e-13,
-1.762422855362362e-14,
// [16.,16.5]: m=11 maxabs=2.439190190296368e-20 maxrel=3.2059463532935433e-13
6.436296043908483e-8,
-2.1426240121610376e-8,
3.783344325729314e-9,
-4.676665974198315e-10,
4.5140116190671756e-11,
-3.603410791399557e-12,
2.4677762229435606e-13,
-1.4794309408609375e-14,
// [16.,16.5]: m=12 maxabs=2.1175823681357508e-20 maxrel=4.138476934989954e-13
4.285248024231021e-8,
-1.513337729050111e-8,
2.8059995853754396e-9,
-3.611214239789333e-10,
3.6034096644793016e-11,
-2.956584986130195e-12,
2.0715648616353737e-13,
-1.2656931403815217e-14,
// [16.,16.5]: m=13 maxabs=1.8661194619196304e-20 maxrel=5.118489973586433e-13
3.026675458110105e-8,
-1.1223998330699878e-8,
2.166728544621247e-9,
-2.882732029818702e-10,
2.9565839788579916e-11,
-2.4817518477142038e-12,
1.772292850696069e-13,
-1.1002131680006958e-14,
// [16.,16.5]: m=14 maxabs=1.663294775721628e-20 maxrel=6.104943153535955e-13
2.2447996661392504e-8,
-8.666914169017836e-9,
1.7296392185889702e-9,
-2.3652709697687847e-10,
2.4817509151724015e-11,
-2.1231163438800423e-12,
1.5405971067464669e-13,
-9.693245685686875e-15,
// [16.,16.5]: m=15 maxabs=1.498520397701065e-20 maxrel=7.077137975664916e-13
1.7333828338084145e-8,
-6.918556865920169e-9,
1.4191625824979835e-9,
-1.9854041068558824e-10,
2.123115491547125e-11,
-1.8454770011977585e-12,
1.357327534513826e-13,
-8.638359927344616e-15,
// [16.,16.5]: m=16 maxabs=1.36054667152722e-20 maxrel=8.005246747594019e-13
1.3837113731834233e-8,
-5.676650322398879e-9,
1.1912424646984034e-9,
-1.6984954302216202e-10,
1.8454762201315903e-11,
-1.625877673642041e-12,
1.2096205905226027e-13,
-7.774081127838479e-15,
// [16.,16.5]: m=17 maxabs=1.243914205157243e-20 maxrel=8.87871013269036e-13
1.1353300644792069e-8,
-4.764969851902108e-9,
1.0190972586770821e-9,
-1.4763837324773178e-10,
1.625876948302652e-11,
-1.4488987361763174e-12,
1.0886034597435359e-13,
-7.055659580850118e-15,
// [16.,16.5]: m=18 maxabs=1.1443216594058585e-20 maxrel=9.692057175373847e-13
9.52993970379892e-9,
-4.076389028407745e-9,
8.858302399935465e-10,
-1.3007040786861378e-10,
1.4488980594167578e-11,
-1.3039050198848758e-12,
9.880090273799673e-14,
-6.45082013346718e-15,
// [16.,16.5]: m=19 maxabs=1.0594529285579178e-20 maxrel=1.045352530567699e-12
8.152778056810595e-9,
-3.5433209541766124e-9,
7.804224476800915e-10,
-1.1591207663884582e-10,
1.3039043951350059e-11,
-1.1833848448367464e-12,
9.033147271546177e-14,
-5.9357598942085264e-15,
// [16.,16.5]: m=20 maxabs=9.855029817956772e-21 maxrel=1.1154319846934664e-12
7.086641908348645e-9,
-3.1216897853555727e-9,
6.954724602711199e-10,
-1.043125661861352e-10,
1.1833842606010434e-11,
-1.0819178454081862e-12,
8.31193348048346e-14,
-5.492703063763059e-15,
// [16.,16.5]: m=21 maxabs=9.204865856490092e-21 maxrel=1.179606535561283e-12
6.243379570706868e-9,
-2.781889836095342e-9,
6.258753975274045e-10,
-9.467094039819144e-11,
1.0819172975260439e-11,
-9.955164202391956e-13,
7.691538350158405e-14,
-5.108116731880399e-15,
// [16.,16.5]: m=22 maxabs=8.629148150153185e-21 maxrel=1.2382175322694562e-12
5.56377967218662e-9,
-2.5035015854492408e-9,
5.680256427766737e-10,
-8.655357020369906e-11,
9.955159042860101e-12,
-9.211952209191037e-13,
7.153013001507265e-14,
-4.771551145349833e-15,
// [16.,16.5]: m=23 maxabs=8.127049518333497e-21 maxrel=1.2934069360248289e-12
5.007003170894733e-9,
-2.2721025667362444e-9,
5.193214215890153e-10,
-7.964144715203108e-11,
9.211947323139842e-12,
-8.566834504178996e-13,
6.681733828753912e-14,
-4.47485100912585e-15,
// [16.,16.5]: m=24 maxabs=7.672927362041885e-21 maxrel=1.3432799577168058e-12
4.5442051334688435e-9,
-2.0772856822427867e-9,
4.778486832578691e-10,
-7.369574310662368e-11,
8.566829895726823e-12,
-8.002287049494412e-13,
6.266266151262874e-14,
-4.211509388535527e-15,
// [16.,16.5]: m=25 maxabs=7.264300139440689e-21 maxrel=1.3889930867280027e-12
4.154571364482234e-9,
-1.911394729144737e-9,
4.42174458977019e-10,
-6.853479454893605e-11,
8.002282540632791e-12,
-7.504605912429492e-13,
5.897555087566769e-14,
-3.976446035558881e-15,
// [16.,16.5]: m=26 maxabs=6.897859128079698e-21 maxrel=1.4315559524115214e-12
3.822789458286184e-9,
-1.7686978322305047e-9,
4.1120876760750785e-10,
-6.401840741991302e-11,
7.50460173378695e-12,
-7.062945500965992e-13,
5.5683602366936344e-14,
-3.765395082761817e-15,
// [16.,16.5]: m=27 maxabs=6.565332521833381e-21 maxrel=1.4707916890334638e-12
3.5373956644578834e-9,
-1.6448350669384605e-9,
3.841104448177832e-10,
-6.003695352518513e-11,
7.062941527544823e-12,
-6.668625860012306e-13,
5.2728238368101874e-14,
-3.5749645167330935e-15,
// [16.,16.5]: m=28 maxabs=6.266720320701738e-21 maxrel=1.5080737910803015e-12
3.2896701338739245e-9,
-1.5364417759481548e-9,
3.6022172143660007e-10,
-5.65036651320776e-11,
6.668622059319654e-12,
-6.314629521057891e-13,
5.006165625940064e-14,
-3.402342865906513e-15,
// [16.,16.5]: m=29 maxabs=5.985478912433708e-21 maxrel=1.5405982637911412e-12
3.0728835518934604e-9,
-1.440886882577408e-9,
3.3902199106535823e-10,
-5.334910323176287e-11,
6.314625861371773e-12,
-5.995229477239516e-13,
4.7644522134369057e-14,
-3.245218776254094e-15,
// [16.,16.5]: m=30 maxabs=5.731534464379929e-21 maxrel=1.5717693579141993e-12
2.881773765152075e-9,
-1.3560879612322196e-9,
3.2009461965171926e-10,
-5.0517128053331346e-11,
5.9952260025630965e-12,
-5.705711386211844e-13,
4.544416953191283e-14,
-3.1016174593343858e-15,
// [16.,16.5]: m=31 maxabs=5.498269531639975e-21 maxrel=1.6008888831163543e-12
2.7121759224618132e-9,
-1.2803784757063463e-9,
3.031027685704478e-10,
-4.7961924037021e-11,
5.7057080520245225e-12,
-5.442163017495857e-13,
4.343330327019399e-14,
-2.9699071127203244e-15,
// [16.,16.5]: m=32 maxabs=5.281961801457358e-21 maxrel=1.6277391785828553e-12
2.5607569514101655e-9,
-1.2124110714996865e-9,
2.8777154446289274e-10,
-4.5645775696873354e-11,
5.44215981324828e-12,
-5.201313642519284e-13,
4.158894151218309e-14,
-2.848695517319032e-15,
// [16.,16.5]: m=33 maxabs=5.0834384544446316e-21 maxrel=1.6533564547899245e-12
2.424822142996937e-9,
-1.1510861751786719e-9,
2.738746544133629e-10,
-4.3537385416828345e-11,
5.2013105534803714e-12,
-4.980409809897504e-13,
3.9891610339880565e-14,
-2.73680030065333e-15,
// [16.,16.5]: m=34 maxabs=4.8973228166202e-21 maxrel=1.6767313028248957e-12
2.3021723503550053e-9,
-1.0954986150817671e-9,
2.612243127243265e-10,
-4.161058729103959e-11,
4.980406836035578e-12,
-4.77711859634412e-13,
3.8324711680090225e-14,
-2.6332009526114488e-15,
// [16.,16.5]: m=35 maxabs=4.630557069071849e-21 maxrel=1.664975870204606e-12
2.1909972301614585e-9,
-1.0448972484180063e-9,
2.4966352394327897e-10,
-3.984335388896771e-11,
4.777115888692349e-12,
-4.589443300539642e-13,
3.687362292389186e-14,
-2.5388737161446797e-15,
// [16.,16.5]: m=36 maxabs=4.56520980068016e-21 maxrel=1.7201470047510443e-12
2.089794496836871e-9,
-9.986540934601762e-10,
2.390601229798508e-10,
-3.821702134503073e-11,
4.58944860148987e-12,
-4.415703548886691e-13,
3.55272614835344e-14,
-2.447516434436964e-15,
// [16.,16.5]: m=37 maxabs=4.413422158276679e-21 maxrel=1.739188336559371e-12
1.997308186918231e-9,
-9.56240489610574e-10,
2.2930212827232883e-10,
-3.6715681160618214e-11,
4.415700858732699e-12,
-4.2544061608531597e-13,
3.427382923147818e-14,
-2.3640106601620176e-15,
// [16.,16.5]: m=38 maxabs=4.272387863836388e-21 maxrel=1.75756682174642e-12
1.912480979219093e-9,
-9.172085108567708e-10,
2.202940871596241e-10,
-3.532569616779371e-11,
4.254403554069691e-12,
-4.104287117028178e-13,
3.310448076116253e-14,
-2.2859331886802707e-15,
// [16.,16.5]: m=39 maxabs=4.1400389658279035e-21 maxrel=1.7749229443997307e-12
1.8344170217115512e-9,
-8.811763464774247e-10,
2.1195417719660377e-10,
-3.403531487227857e-11,
4.10428459016742e-12,
-3.964239652653307e-13,
3.201114272247641e-14,
-2.212778833694672e-15,
// [16.,16.5]: m=40 maxabs=4.015961873944949e-21 maxrel=1.7914976519242178e-12
1.7623526929529198e-9,
-8.478167066923982e-10,
2.042118894177344e-10,
-3.283436047855708e-11,
3.964237203524078e-12,
-3.8332966208761795e-13,
3.098673084911578e-14,
-2.14410323401417e-15
},
{
// [16.5,17.]: m=0 maxabs=1.6653345369377348e-16 maxrel=7.633057330333799e-16
0.21653970056917216,
-0.0032319350359913666,
0.00007235655618899067,
-1.7998812723676269e-6,
4.7007670782256176e-8,
-1.262494567070643e-9,
3.457145717629738e-11,
-9.29766968991927e-13,
// [16.5,17.]: m=1 maxabs=5.0306980803327406e-17 maxrel=7.6092064067273e-15
0.006463870071982394,
-0.0002894262247447107,
0.000010799287661913547,
-3.760616286214617e-7,
1.2624634301528075e-8,
-4.1325816468438864e-10,
1.372168092900033e-11,
-2.429299672030736e-12,
// [16.5,17.]: m=2 maxabs=1.0842021724855044e-19 maxrel=1.8039128991751152e-16
0.0005788524494951207,
-0.000043197150591387694,
2.256369218042491e-6,
-1.0099839920911509e-7,
4.1413237739046515e-9,
-1.6029443643757435e-10,
5.950517459846437e-12,
-2.1419364815381853e-13,
// [16.5,17.]: m=3 maxabs=2.0938654456126304e-17 maxrel=2.2993647048022017e-13
0.000086394301182688,
-9.025476871049334e-6,
6.059903968681293e-7,
-3.3130617685525987e-8,
1.6029363588618458e-9,
-7.121036085173308e-11,
3.0092552171153327e-12,
-4.23891710019876e-13,
// [16.5,17.]: m=4 maxabs=8.809142651444724e-20 maxrel=4.560948196026262e-15
0.000018050953744086506,
-2.423961579764654e-6,
1.987835705423398e-7,
-1.2823590476888069e-8,
7.136057486223536e-10,
-3.579958321734431e-11,
1.6590478140913782e-12,
-7.186294336839755e-14,
// [16.5,17.]: m=5 maxabs=5.844527336054672e-20 maxrel=1.1099742050825966e-14
4.847923159529347e-6,
-7.951342821235304e-7,
7.694154285375027e-8,
-5.708847817997877e-9,
3.579959515095977e-10,
-1.9891012020091798e-11,
1.0056638982703244e-12,
-4.687008573351399e-14,
// [16.5,17.]: m=6 maxabs=4.383395502041004e-20 maxrel=2.5003885490347414e-14
1.590268564247095e-6,
-3.0776617138309155e-7,
3.4253086904871325e-8,
-2.8639688850273035e-9,
1.9891015839908455e-10,
-1.205576295973638e-11,
6.560640700384072e-13,
-3.251445239604909e-14,
// [16.5,17.]: m=7 maxabs=3.4304834363799164e-20 maxrel=4.982248840742869e-14
6.15532342766191e-7,
-1.3701234759624433e-7,
1.7183813309376217e-8,
-1.5912821956771061e-9,
1.2055763866706294e-10,
-7.863861611938319e-12,
4.551757975784433e-13,
-2.3742661109507887e-14,
// [16.5,17.]: m=8 maxabs=2.736975210815458e-20 maxrel=8.803255489355729e-14
2.740246951924846e-7,
-6.873525321981969e-8,
9.547693174416479e-9,
-9.644618164069028e-10,
7.863861128986977e-11,
-5.455323797762466e-12,
3.324128267602463e-13,
-1.809117072736058e-14,
// [16.5,17.]: m=9 maxabs=2.2234614865425384e-20 maxrel=1.4064105944430248e-13
1.3747050643963348e-7,
-3.819077268371354e-8,
5.786770898995898e-9,
-6.291094482724709e-10,
5.455323045355904e-11,
-3.9835986057536164e-12,
2.5330084998567406e-13,
-1.4278750403481528e-14,
// [16.5,17.]: m=10 maxabs=1.8568550390590365e-20 maxrel=2.087388466624256e-13
7.638154536742074e-8,
-2.3147083584651553e-8,
3.774656690230626e-9,
-4.364262968984294e-10,
3.9835978034366776e-11,
-3.0352589298901596e-12,
1.9992836037379822e-13,
-1.1603040473873306e-14,
// [16.5,17.]: m=11 maxabs=1.5789223532412192e-20 maxrel=2.8949841666684764e-13
4.629416716929714e-8,
-1.5098626751487798e-8,
2.6185577819668628e-9,
-3.1868820164719733e-10,
3.0352581518863664e-11,
-2.3955177318833445e-12,
1.6246765631461657e-13,
-9.65981620742955e-15,
// [16.5,17.]: m=12 maxabs=2.5920531674961675e-20 maxrel=7.211302332028429e-13
3.019725350218077e-8,
-1.0474231119097788e-8,
1.912129206055051e-9,
-2.4282100150423524e-10,
2.395522129834186e-11,
-1.9462619976046717e-12,
1.3514999284164296e-13,
-8.829631907339665e-15,
// [16.5,17.]: m=13 maxabs=1.196103165751678e-20 maxrel=4.75357595055698e-13
2.094846223969989e-8,
-7.648516834742923e-9,
1.4569258368563978e-9,
-1.9164163859583722e-10,
1.946533835453475e-11,
-1.6204635596564846e-12,
1.1490558700435414e-13,
-7.090160932642057e-15,
// [16.5,17.]: m=14 maxabs=1.0611072897830239e-20 maxrel=5.729870434650838e-13
1.529703366948122e-8,
-5.827703341355887e-9,
1.1498498320173043e-9,
-1.5572294960609798e-10,
1.6204629697543316e-11,
-1.3765366007405853e-12,
9.928112979071849e-14,
-6.214190196093793e-15,
// [16.5,17.]: m=15 maxabs=9.646580303593409e-21 maxrel=6.790595499501858e-13
1.1655406682762423e-8,
-4.5993993227474654e-9,
9.34337697311419e-10,
-1.2963725408891644e-10,
1.3765365874393173e-11,
-1.1892953031764456e-12,
8.700464050156383e-14,
-5.537650113758645e-15,
// [16.5,17.]: m=16 maxabs=8.617567621577442e-21 maxrel=7.642077493265623e-13
9.198798645371406e-9,
-3.737350787353985e-9,
7.778235181459715e-10,
-1.1012307753618451e-10,
1.1893055641078298e-11,
-1.0423395698572686e-12,
7.719797356488518e-14,
-4.94200066405772e-15,
// [16.5,17.]: m=17 maxabs=7.854907096803551e-21 maxrel=8.530424802185005e-13
7.474701574704368e-9,
-3.1112940682179867e-9,
6.607384655621522e-10,
-9.514461975171358e-11,
1.0423391101546342e-11,
-9.246993869554778e-13,
6.920270802159012e-14,
-4.469953236423868e-15,
// [16.5,17.]: m=18 maxabs=7.211360580237295e-21 maxrel=9.368067463586086e-13
6.222588136432663e-9,
-2.642953858269013e-9,
5.708677188265616e-10,
-8.338728798389048e-11,
9.246989654459411e-12,
-8.289045243154617e-13,
6.259282922218248e-14,
-4.074449473848809e-15,
// [16.5,17.]: m=19 maxabs=6.656322389214214e-21 maxrel=1.014294657454094e-12
5.285907716534937e-9,
-2.2834708716540627e-9,
5.003237281989742e-10,
-7.397606331000269e-11,
8.289041302194624e-12,
-7.497117132981973e-13,
5.705490066460526e-14,
-3.739153780364611e-15,
// [16.5,17.]: m=20 maxabs=6.177384814546011e-21 maxrel=1.0861654633347602e-12
4.566941743305267e-9,
-2.001294909424392e-9,
4.438563801339766e-10,
-6.631246526681964e-11,
7.497113480487156e-12,
-6.833643146794105e-13,
5.235983827276019e-14,
-3.4518713980528838e-15,
// [16.5,17.]: m=21 maxabs=5.76462168888205e-21 maxrel=1.1534512608835625e-12
4.002589818846131e-9,
-1.7754255174072487e-9,
3.978747918577541e-10,
-5.997703298417939e-11,
6.833639720450413e-12,
-6.271167521094042e-13,
4.833716481872443e-14,
-3.20340286754846e-15,
// [16.5,17.]: m=22 maxabs=5.3940447744582935e-21 maxrel=1.2138331893451117e-12
3.5508510348119882e-9,
-1.5914991645140292e-9,
3.59862198145814e-10,
-5.46692344357714e-11,
6.271164307310862e-12,
-5.789259561499223e-13,
4.485792854339963e-14,
-2.986676256527131e-15,
// [16.5,17.]: m=23 maxabs=5.0681356131124006e-21 maxrel=1.2697711977929042e-12
3.1829983290257223e-9,
-1.4394487898527213e-9,
3.280154068411122e-10,
-5.0169423683998844e-11,
5.789256541004715e-12,
-5.37246582108841e-13,
4.182313489718532e-14,
-2.7961456669907645e-15,
// [16.5,17.]: m=24 maxabs=4.7790359890251174e-21 maxrel=1.321517699311849e-12
2.8788975797026567e-9,
-1.3120616247960266e-9,
3.0101654233997153e-10,
-4.631415500646092e-11,
5.37246276260989e-12,
-5.008921390368297e-13,
3.915570427825539e-14,
-2.6275922020037838e-15,
// [16.5,17.]: m=25 maxabs=4.523023589439955e-21 maxrel=1.3700617190008816e-12
2.6241232495899323e-9,
-1.2040661669402232e-9,
2.778849302417043e-10,
-4.2979798883073894e-11,
5.008918684506434e-12,
-4.689393807496152e-13,
3.67949486905368e-14,
-2.4774437382577403e-15,
// [16.5,17.]: m=26 maxabs=4.2881042954748955e-21 maxrel=1.413495374826717e-12
2.4081323338784273e-9,
-1.1115397186785974e-9,
2.5787879349194154e-10,
-4.00714410009837e-11,
4.689391226008957e-12,
-4.4066076282134164e-13,
3.469247373667212e-14,
-2.342960104727357e-15,
// [16.5,17.]: m=27 maxabs=4.07758682958015e-21 maxrel=1.4542437639304027e-12
2.2230794373552713e-9,
-1.0315151717977556e-9,
2.404286461901882e-10,
-3.75152166037859e-11,
4.406605170446178e-12,
-4.154764679015656e-13,
3.2809305729992166e-14,
-2.2218765799659196e-15,
// [16.5,17.]: m=28 maxabs=3.886094517774124e-21 maxrel=1.4918748252576409e-12
2.0630303435936828e-9,
-9.617145826977635e-10,
2.2509129979794955e-10,
-3.5252923879425665e-11,
4.154762341335761e-12,
-3.9291953385831205e-13,
3.1113753945478067e-14,
-2.1123319157298425e-15,
// [16.5,17.]: m=29 maxabs=3.700392470255969e-21 maxrel=1.52222919985736e-12
1.923429165393824e-9,
-9.003651972261586e-10,
2.1151754344511824e-10,
-3.3238177358795065e-11,
3.9291930886244344e-12,
-3.726102249084639e-13,
2.957984133202646e-14,
-2.012832517749583e-15,
// [16.5,17.]: m=30 maxabs=3.549845598771318e-21 maxrel=1.5584560885385485e-12
1.8007303944503623e-9,
-8.460701719012391e-10,
1.9942906431226963e-10,
-3.1433619862360704e-11,
3.726100229421842e-12,
-3.542370393374505e-13,
2.8185982411187132e-14,
-1.92198109817343e-15,
// [16.5,17.]: m=31 maxabs=3.402607449736879e-21 maxrel=1.5884392458280809e-12
1.6921403438008664e-9,
-7.977162554532181e-10,
1.8860171932855908e-10,
-2.9808873666872106e-11,
3.5423683346769847e-12,
-3.375422216559528e-13,
2.6914322142052566e-14,
-1.83881898574738e-15,
// [16.5,17.]: m=32 maxabs=3.2669498292781828e-21 maxrel=1.6164111984787561e-12
1.595432510904894e-9,
-7.544068755929755e-10,
1.7885324214918562e-10,
-2.833901552390137e-11,
3.375420242864038e-12,
-3.223109566819056e-13,
2.5749781220531666e-14,
-1.7623969709005864e-15,
// [16.5,17.]: m=33 maxabs=3.1420455567826756e-21 maxrel=1.6428002827822842e-12
1.5088137511844685e-9,
-7.154129669443451e-10,
1.700340932857585e-10,
-2.7003428036136437e-11,
3.223107666958486e-12,
-3.0836289022504324e-13,
2.4679638413621884e-14,
-1.6919425747868547e-15,
// [16.5,17.]: m=34 maxabs=3.0252062952595605e-21 maxrel=1.6669413069482732e-12
1.4308259338872544e-9,
-6.801363715542125e-10,
1.6202056835450967e-10,
-2.5784924884848962e-11,
3.083627065295272e-12,
-2.9554560372517676e-13,
2.369307504694876e-14,
-1.6267987173027626e-15,
// [16.5,17.]: m=35 maxabs=2.916845635015114e-21 maxrel=1.6896821326814627e-12
1.3602727431070445e-9,
-6.480822718882431e-10,
1.54709549441493e-10,
-2.4669077711679617e-11,
2.955454270208519e-12,
-2.8372949569280457e-13,
2.2780838861575944e-14,
-1.5663916149483816e-15,
// [16.5,17.]: m=36 maxabs=2.8151024196710914e-21 maxrel=1.7105504845010917e-12
1.296164543775143e-9,
-6.188381962910066e-10,
1.480144663987506e-10,
-2.364369315741685e-11,
2.8372932406885443e-12,
-2.7280371994370113e-13,
2.1934974187076642e-14,
-1.510236525420621e-15,
// [16.5,17.]: m=37 maxabs=2.7216310104525993e-21 maxrel=1.7311112699290708e-12
1.237676392580719e-9,
-5.920578641711348e-10,
1.4186215906853998e-10,
-2.2698402877320312e-11,
2.7280355451894863e-12,
-2.626729673488942e-13,
2.114860453401933e-14,
-1.4579026042186514e-15,
// [16.5,17.]: m=38 maxabs=2.63374307036884e-21 maxrel=1.7502418165150338e-12
1.1841157283410153e-9,
-5.674486348980633e-10,
1.3619041738401185e-10,
-2.182433940310536e-11,
2.626728072249547e-12,
-2.5325486586762114e-13,
2.0415759833770838e-14,
-1.409019156113131e-15,
// [16.5,17.]: m=39 maxabs=2.5501978285009843e-21 maxrel=1.7675245435971094e-12
1.1348972697949127e-9,
-5.447616682046295e-10,
1.309460365349409e-10,
-2.1013877832431244e-11,
2.53254710748553e-12,
-2.444778873822486e-13,
1.973123155647305e-14,
-1.3632611047042184e-15,
// [16.5,17.]: m=40 maxabs=2.471822465461585e-21 maxrel=1.7838988528954862e-12
1.0895233364080842e-9,
-5.237841448502523e-10,
1.2608326710715463e-10,
-2.0260428437899724e-11,
2.444777372823077e-12,
-2.36279642451642e-13,
1.9090457650217374e-14,
-1.320340206572927e-15
},
{
// [17.,17.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.2913077599768165e-16
0.21337836798688778,
-0.0030924396484803907,
0.00006722683206278592,
-1.6238170522567546e-6,
4.1181318669605285e-8,
-1.074065101786238e-9,
2.8556318431782535e-11,
-7.256717806766259e-13,
// [17.,17.5]: m=1 maxabs=8.673617379884035e-19 maxrel=1.3720147592350878e-16
0.006184879296960641,
-0.00026890732824585425,
9.742902321002258e-6,
-3.294506573893241e-7,
1.0740521387742502e-8,
-3.4220526838610794e-10,
1.0731296655064596e-11,
-3.3874131949553437e-13,
// [17.,17.5]: m=2 maxabs=2.168404344971009e-19 maxrel=3.887383636883753e-16
0.0005378146564928729,
-0.00003897160928401193,
1.9767039424489717e-6,
-8.592418002321508e-8,
3.4220802317840733e-9,
-1.287039682027862e-10,
4.645778732113768e-12,
-1.6343560001811216e-13,
// [17.,17.5]: m=3 maxabs=2.710505431213761e-20 maxrel=3.304325139623169e-16
0.00007794321856802853,
-7.906815769692664e-6,
5.155450796765439e-7,
-2.737664563457726e-8,
1.2870457099959135e-9,
-5.5715009191448804e-11,
2.269177629147137e-12,
-8.810684751653919e-14,
// [17.,17.5]: m=4 maxabs=6.098637220230962e-20 maxrel=3.611415710032816e-15
0.00001581363153938628,
-2.0621803186535858e-6,
1.6425987371479854e-7,
-1.0296367756217433e-8,
5.571513245501295e-10,
-2.721043671565693e-11,
1.229549770248049e-12,
-5.2064647106040877e-14,
// [17.,17.5]: m=5 maxabs=3.9810548520952116e-20 maxrel=8.908356056503197e-15
4.1243606373073375e-6,
-6.570394948261857e-7,
6.177820652043711e-8,
-4.457211905868247e-9,
2.721045879327807e-10,
-1.4742093763853528e-11,
7.282142160406441e-13,
-3.323730336242324e-14,
// [17.,17.5]: m=6 maxabs=4.676108912788409e-17 maxrel=3.236951257661514e-11
1.3140789899795076e-6,
-2.471128260595336e-7,
2.6743260965291062e-8,
-2.1768375893927555e-9,
1.4750470802364802e-10,
-8.730076282631421e-12,
2.738220188411092e-13,
-2.2635200832877704e-14,
// [17.,17.5]: m=7 maxabs=2.3187526931086472e-20 maxrel=4.207266081666329e-14
4.942256521190752e-7,
-1.0697308571613445e-7,
1.3061025535508528e-8,
-1.1793683660811638e-9,
8.73007740573321e-11,
-5.576679264814482e-12,
3.168570194645797e-13,
-1.6263973729783427e-14,
// [17.,17.5]: m=8 maxabs=1.810532924756067e-20 maxrel=7.483761906299306e-14
2.1394617143226912e-7,
-5.2244102130085666e-8,
7.076210196425608e-9,
-6.98406670098784e-10,
5.5766793449008715e-11,
-3.7977003751900315e-12,
2.2769304782579747e-13,
-1.2220818097136848e-14,
// [17.,17.5]: m=9 maxabs=1.4664257899340075e-20 maxrel=1.2246088546166064e-13
1.044882042601686e-7,
-2.8304840776385985e-8,
4.1904400208421715e-9,
-4.461347200745434e-10,
3.797700035448022e-11,
-2.728741817549866e-12,
1.7110238565896751e-13,
-9.530715595780123e-15,
// [17.,17.5]: m=10 maxabs=1.2096689277975477e-20 maxrel=1.841214468390883e-13
5.660968155276808e-8,
-1.676176007587808e-8,
2.6768083208128236e-9,
-3.0381630238449375e-10,
2.728741328127409e-11,
-2.0503534481253874e-12,
1.3344566255818479e-13,
-7.666147653076876e-15,
// [17.,17.5]: m=11 maxabs=1.0243804705856695e-20 maxrel=2.6024946784319833e-13
3.3523520151752605e-8,
-1.0707233277069444e-8,
1.8228978146394203e-9,
-2.1829955345816516e-10,
2.0503530034516227e-11,
-1.5989751352660448e-12,
1.0734030967956331e-13,
-6.3267842256439786e-15,
// [17.,17.5]: m=12 maxabs=8.79458427266379e-21 maxrel=3.4611734629343324e-13
2.1414466554135488e-8,
-7.291591253346113e-9,
1.3097973210752897e-9,
-1.6402844869829756e-10,
1.598974698009564e-11,
-1.286083064540321e-12,
8.858901015930076e-14,
-5.3347132301019134e-15,
// [17.,17.5]: m=13 maxabs=7.682853529392521e-21 maxrel=4.3988368679875627e-13
1.4583182506689124e-8,
-5.239189279827728e-9,
9.841706924873136e-10,
-1.2791815476053887e-10,
1.2860826652192762e-11,
-1.0613505878493076e-12,
7.469881729128915e-14,
-4.579889884676387e-15,
// [17.,17.5]: m=14 maxabs=6.789498467835251e-21 maxrel=5.366280254985774e-13
1.0478378559652545e-8,
-3.9366827660497885e-9,
7.675089288408139e-10,
-1.02886769176662e-10,
1.0613502173906201e-11,
-8.948887168805626e-13,
6.413032198447736e-14,
-3.992036861895576e-15,
// [17.,17.5]: m=15 maxabs=6.063233890013693e-21 maxrel=6.333079256562113e-13
7.873365532096942e-9,
-3.0700357119205893e-9,
6.173206153125321e-10,
-8.490815508885641e-11,
8.94888379223081e-12,
-7.682420282388202e-13,
5.589933617706086e-14,
-3.524774342600351e-15,
// [17.,17.5]: m=16 maxabs=5.464355126525301e-21 maxrel=7.274627520464973e-13
6.1400714238485165e-9,
-2.4692824581749085e-9,
5.094489307638078e-10,
-7.159119326303612e-11,
7.68241718983284e-12,
-6.696120010487114e-13,
4.935675731618636e-14,
-3.146659801996038e-15,
// [17.,17.5]: m=17 maxabs=4.968873939606037e-21 maxrel=8.181950828740908e-13
4.938564916347609e-9,
-2.0377957202853567e-9,
4.2954715979096267e-10,
-6.145944830330639e-11,
6.696117162055847e-12,
-5.912176134886873e-13,
4.406237298990703e-14,
-2.835827290310327e-15,
// [17.,17.5]: m=18 maxabs=4.547011827203993e-21 maxrel=9.032677851029858e-13
4.07559144056864e-9,
-1.7181886366472105e-9,
3.6875669001786515e-10,
-5.3569037957408925e-11,
5.912173488783564e-12,
-5.277821755514818e-13,
3.971005804286561e-14,
-2.5767130145869685e-15,
// [17.,17.5]: m=19 maxabs=4.188015441355979e-21 maxrel=9.829864491563723e-13
3.436377273292259e-9,
-1.47502675776768e-9,
3.214142279375607e-10,
-4.729748003885164e-11,
5.27781921758727e-12,
-4.756363613964917e-13,
3.608205268203193e-14,
-2.3580717643956775e-15,
// [17.,17.5]: m=20 maxabs=3.877822711648594e-21 maxrel=1.0567952243524726e-12
2.9500535155336008e-9,
-1.2856569096292078e-9,
2.8378488040243676e-10,
-4.222263857346558e-11,
4.756361347786202e-12,
-4.3217028748108953e-13,
3.302027245691329e-14,
-2.1714971721700672e-15,
// [17.,17.5]: m=21 maxabs=3.610229783487689e-21 maxrel=1.1256441052963615e-12
2.571313819256788e-9,
-1.13513951964591e-9,
2.533358316004082e-10,
-3.805096933073459e-11,
4.321700739490638e-12,
-3.954892342450532e-13,
3.040780416407834e-14,
-2.0107093836329447e-15,
// [17.,17.5]: m=22 maxabs=3.3744833089100764e-21 maxrel=1.188781067884826e-12
2.270279039290188e-9,
-1.0133433245736256e-9,
2.283058161420301e-10,
-3.4573679021251725e-11,
3.954890226660836e-12,
-3.641919621478061e-13,
2.8156700191407204e-14,
-1.8709843155516827e-15,
// [17.,17.5]: m=23 maxabs=3.165620204240437e-21 maxrel=1.2466250666863186e-12
2.0266866491457647e-9,
-9.132232628604929e-10,
2.074420742693333e-10,
-3.163919011660979e-11,
3.641917732568122e-12,
-3.3722469785461145e-13,
2.6199821702418328e-14,
-1.7485325638225117e-15,
// [17.,17.5]: m=24 maxabs=2.9811589276411117e-21 maxrel=1.3003100651290336e-12
1.8264465257196392e-9,
-8.297682954751479e-10,
1.8983514083336407e-10,
-2.9135405944757305e-11,
3.3722451965975468e-12,
-3.137826722868055e-13,
2.4485156050740454e-14,
-1.6404659496622225e-15,
// [17.,17.5]: m=25 maxabs=2.8173771663556123e-21 maxrel=1.35029644315215e-12
1.6595365909489597e-9,
-7.593405618250123e-10,
1.748124357944408e-10,
-2.6978021906549405e-11,
3.1378250419092274e-12,
-2.9324268919121313e-13,
2.297190935840737e-14,
-1.5444484510831786e-15,
// [17.,17.5]: m=26 maxabs=2.6668302948709612e-21 maxrel=1.3947105251683388e-12
1.518681123648694e-9,
-6.992497417522849e-10,
1.6186813156998164e-10,
-2.5102657322724824e-11,
2.9324251770559783e-12,
-2.7511589106616595e-13,
2.1627708476502605e-14,
-1.4586938374725283e-15,
// [17.,17.5]: m=27 maxabs=2.532206650177956e-21 maxrel=1.4363034648723122e-12
1.3984994835033738e-9,
-6.474725249306197e-10,
1.506159440506079e-10,
-2.3459455387832892e-11,
2.751157388518662e-12,
-2.590143836549672e-13,
2.04265824364334e-14,
-1.3816319763023452e-15,
// [17.,17.5]: m=28 maxabs=2.4104043049795226e-21 maxrel=1.4748964656841436e-12
1.294945049860101e-9,
-6.024637749210588e-10,
1.40756732435909e-10,
-2.200931036170679e-11,
2.5901423854748973e-12,
-2.4462696266303067e-13,
1.934748896173785e-14,
-1.3120566719289338e-15,
// [17.,17.5]: m=29 maxabs=2.2997688980505552e-21 maxrel=1.5108136262011777e-12
1.2049275498410328e-9,
-5.630269285238923e-10,
1.3205586227417422e-10,
-2.0721187872149318e-11,
2.4462682416817147e-12,
-2.3170150578728653e-13,
1.8373223502225372e-14,
-1.2489540036270083e-15,
// [17.,17.5]: m=30 maxabs=2.1959577311751502e-21 maxrel=1.5422723626300923e-12
1.126053857046745e-9,
-5.282234479329846e-10,
1.2432712733221486e-10,
-1.9570192479529485e-11,
2.3170137349004106e-12,
-2.2003185101955153e-13,
1.7489589985031564e-14,
-1.1915249660458138e-15,
// [17.,17.5]: m=31 maxabs=2.1053814541005937e-21 maxrel=1.574802478955128e-12
1.0564468958650594e-9,
-4.973085082177733e-10,
1.1742115496114605e-10,
-1.8536154341336733e-11,
2.200317421560757e-12,
-2.0944807050088095e-13,
1.6684822258037053e-14,
-1.1389382827366907e-15,
// [17.,17.5]: m=32 maxabs=2.0197682607013553e-21 maxrel=1.6034980924701875e-12
9.946170164345947e-10,
-4.696846187793704e-10,
1.1121692613917112e-10,
-1.7602581979917095e-11,
2.094479489794999e-12,
-1.9980884173328734e-13,
1.5949024710090572e-14,
-1.0907239107971648e-15,
// [17.,17.5]: m=33 maxabs=1.940772512202541e-21 maxrel=1.6303086839355788e-12
9.393692375578224e-10,
-4.448677035348139e-10,
1.0561549196746451e-10,
-1.675587679189403e-11,
1.998087245000235e-12,
-1.90995916233304e-13,
1.5273885463738316e-14,
-1.0463384792803076e-15,
// [17.,17.5]: m=34 maxabs=1.8675670279915982e-21 maxrel=1.6553163663271516e-12
8.897354070687417e-10,
-4.224619668879899e-10,
1.0053526083605636e-10,
-1.5984737233116897e-11,
1.9099580342490818e-12,
-1.8290961304634523e-13,
1.465234644126356e-14,
-1.0053501299335225e-15,
// [17.,17.5]: m=35 maxabs=1.79973821776225e-21 maxrel=1.6788578458147617e-12
8.449239337751254e-10,
-4.0214104239944954e-10,
9.590842348043791e-11,
-1.5279702064029098e-11,
1.829095041324458e-12,
-1.7546538014295344e-13,
1.4078385999412005e-14,
-9.673913777413957e-16,
// [17.,17.5]: m=36 maxabs=1.8305506955798502e-21 maxrel=1.7929652364583852e-12
8.042820847980382e-10,
-3.836336930087891e-10,
9.167821245482207e-11,
-1.4632796781386825e-11,
1.7546528435740337e-12,
-1.6859090210052945e-13,
1.3546597250896525e-14,
-9.323905842457502e-16,
// [17.,17.5]: m=37 maxabs=1.6769018967981254e-21 maxrel=1.7208907685817422e-12
7.672673860220344e-10,
-3.6671284897363455e-10,
8.779678053604417e-11,
-1.4037257142769512e-11,
1.6859097337123861e-12,
-1.6222479998781174e-13,
1.3053245196291494e-14,
-8.993284220452109e-16,
// [17.,17.5]: m=38 maxabs=1.6221011812164873e-21 maxrel=1.7406993125610836e-12
7.334256979464971e-10,
-3.5118712129577377e-10,
8.422354293047607e-11,
-1.348731180470948e-11,
1.6222470156201915e-12,
-1.563131722379303e-13,
1.2593746706099506e-14,
-8.687096550402598e-16,
// [17.,17.5]: m=39 maxabs=1.5700922002022157e-21 maxrel=1.7586608222077294e-12
7.023742425908019e-10,
-3.3689417090147097e-10,
8.092387089967193e-11,
-1.2978008941432807e-11,
1.5631307706538324e-12,
-1.5080992801433887e-13,
1.2164979805036168e-14,
-8.400753915978564e-16,
// [17.,17.5]: m=40 maxabs=1.5214953392147253e-21 maxrel=1.7758602775764437e-12
6.737883418022184e-10,
-3.236954828044606e-10,
7.786805371780232e-11,
-1.2505077933421229e-11,
1.5080983581308771e-12,
-1.4567478835632935e-13,
1.176400446513937e-14,
-8.132415512930382e-16
},
{
// [17.5,18.]: m=0 maxabs=5.551115123125783e-17 maxrel=2.6203199249155374e-16
0.21035157148846673,
-0.002962697914548158,
0.00006259214060470239,
-1.4692876053492862e-6,
3.6213394462327796e-8,
-9.17892597549527e-10,
2.3709057709294137e-11,
-7.256717806766259e-13,
// [17.5,18.]: m=1 maxabs=8.673617379884035e-19 maxrel=1.4329876287863182e-16
0.0059253958290966325,
-0.000250368562416441,
8.815725593220246e-6,
-2.897072052967871e-7,
9.179426757232831e-9,
-2.8428803230575993e-10,
8.6680218606896e-12,
-2.643316154222475e-13,
// [17.5,18.]: m=2 maxabs=0. maxrel=0.
0.0005007371248337151,
-0.000035262902373061265,
1.7382432308009466e-6,
-7.343542078947716e-8,
2.842894766235836e-9,
-1.0396216027260523e-10,
3.650881126312455e-12,
-1.2490200326587432e-13,
// [17.5,18.]: m=3 maxabs=1.3552527156068805e-20 maxrel=1.828572150925214e-16
0.00007052580474612615,
-6.952972923123589e-6,
4.406125244292447e-7,
-2.2743161083488953e-8,
1.0396254576428503e-9,
-4.378429482078042e-11,
1.7365087866287566e-12,
-6.573964480403332e-14,
// [17.5,18.]: m=4 maxabs=1.3944195190879194e-16 maxrel=9.407544750337657e-12
0.000013905945846102861,
-1.7624500965258945e-6,
1.3645898106779782e-7,
-8.317076040629191e-9,
4.377139614823799e-10,
-2.0213233565198434e-11,
1.2142823550549614e-12,
-1.4332961630755064e-12,
// [17.5,18.]: m=5 maxabs=2.795208725939191e-20 maxrel=7.33507185121266e-15
3.5249001953560942e-6,
-5.458358657440586e-7,
4.9902031089310246e-8,
-3.502751203360862e-9,
2.0823710701882134e-10,
-1.100162615579265e-11,
5.308750371523282e-13,
-2.3722591527866097e-14,
// [17.5,18.]: m=6 maxabs=5.4193167965330136e-18 maxrel=4.527623006526321e-12
1.0916717314992233e-6,
-1.9960812425346714e-7,
2.1016506098594146e-8,
-1.6659029007259036e-9,
1.1002622738659388e-10,
-6.317823298014498e-12,
3.093086724701266e-13,
-1.226542101219938e-13,
// [17.5,18.]: m=7 maxabs=1.5617169965001163e-20 maxrel=3.518472367873875e-14
3.9921624868331185e-7,
-8.406602886143172e-8,
9.99538486189222e-9,
-8.801307617683481e-10,
6.364550865388312e-11,
-3.9800570869351696e-12,
2.2187625372890985e-13,
-1.1199994398154308e-14,
// [17.5,18.]: m=8 maxabs=1.2123159057577174e-20 maxrel=6.397133412070832e-14
1.6813205772286293e-7,
-3.9981539439447405e-8,
5.280784570614206e-9,
-5.091643936709977e-10,
3.9800571021076544e-11,
-2.659402825471608e-12,
1.5679884564561863e-13,
-8.294511548122376e-15,
// [17.5,18.]: m=9 maxabs=9.714409113822757e-21 maxrel=1.0636612114052203e-13
7.996307887889257e-8,
-2.112313827621274e-8,
3.0549863622038043e-9,
-3.1840481781161653e-10,
2.6594025951641024e-11,
-1.8791901663977965e-12,
1.1613046338977126e-13,
-6.38830138618285e-15,
// [17.5,18.]: m=10 maxabs=7.960786215210338e-21 maxrel=1.6292497206368792e-13
4.224627655242286e-8,
-1.2219945443845758e-8,
1.910428907103881e-9,
-2.127524062834897e-10,
1.8791898521685407e-11,
-1.3916588642523849e-12,
8.944636638590964e-14,
-5.083648819240333e-15,
// [17.5,18.]: m=11 maxabs=6.667075737177403e-21 maxrel=2.331180114095556e-13
2.443989088768906e-8,
-7.641715624352515e-9,
1.276514437926197e-9,
-1.5033535062547204e-10,
1.3916585638523924e-11,
-1.071797226983553e-12,
7.118072897950717e-14,
-4.1571472879657295e-15,
// [17.5,18.]: m=12 maxabs=5.697620059265255e-21 maxrel=3.1519352320100577e-13
1.5283431248702784e-8,
-5.106057748306489e-9,
9.020121039662428e-10,
-1.1133282100102437e-10,
1.0717969418785406e-11,
-8.528644079295635e-13,
5.820919390743427e-14,
-3.477817360768737e-15,
// [17.5,18.]: m=13 maxabs=4.9465400630671055e-21 maxrel=4.056398820606188e-13
1.0212115496610865e-8,
-3.608048412967435e-9,
6.679969262059674e-10,
-8.57438712217881e-11,
8.528641419633396e-12,
-6.973981089910607e-13,
4.869794606266379e-14,
-2.9656699682529483e-15,
// [17.5,18.]: m=14 maxabs=4.3493156608038195e-21 maxrel=5.005144838042921e-13
7.216096825933025e-9,
-2.671987702313481e-9,
5.144632275076467e-10,
-6.822923176158179e-11,
6.973978723412707e-12,
-5.834115398334812e-13,
4.152697019085276e-14,
-2.570037797120779e-15,
// [17.5,18.]: m=15 maxabs=3.8695509055230635e-21 maxrel=5.969133734051162e-13
5.343975404625248e-9,
-2.0578529078251414e-9,
4.0937539073162965e-10,
-5.579191799413327e-11,
5.834113238304355e-12,
-4.974769144905838e-13,
3.598744514320168e-14,
-2.2578441547297016e-15,
// [17.5,18.]: m=16 maxabs=3.473331392110163e-21 maxrel=6.913060470342008e-13
4.115705815659885e-9,
-1.6375015609653164e-9,
3.3475150811489893e-10,
-4.6672984306678016e-11,
4.974767134984562e-12,
-4.3109673781352905e-13,
3.161626174140333e-14,
-2.0068750365341874e-15,
// [17.5,18.]: m=17 maxabs=3.1490765919893764e-21 maxrel=7.833967954649783e-13
3.2750031219292083e-9,
-1.339006030699887e-9,
2.8003790597588046e-10,
-3.9798207464761974e-11,
4.31096556453338e-12,
-3.78719466136117e-13,
2.810206488473629e-14,
-1.8017633174207184e-15,
// [17.5,18.]: m=18 maxabs=2.869489544946453e-21 maxrel=8.689251433238277e-13
2.6780120613984373e-9,
-1.1201516223100184e-9,
2.3878924491420215e-10,
-3.448778825514114e-11,
3.787192982820563e-12,
-3.366128904689397e-13,
2.5230067860664048e-14,
-1.6316922660390502e-15,
// [17.5,18.]: m=19 maxabs=2.6378789734316053e-21 maxrel=9.510596986413635e-13
2.240303244618834e-9,
-9.55156978202588e-10,
2.069267296463363e-10,
-3.029760202637939e-11,
3.3661273664689297e-12,
-3.0220247487156883e-13,
2.284860875853225e-14,
-1.4888431529302025e-15,
// [17.5,18.]: m=20 maxabs=2.4368740845812195e-21 maxrel=1.0268401168935037e-12
1.910313956404015e-9,
-8.277069172504872e-10,
1.817856122651417e-10,
-2.6929072341112788e-11,
3.0220233276363494e-12,
-2.7367052650155767e-13,
2.084835047977904e-14,
-1.3674720605842893e-15,
// [17.5,18.]: m=21 maxabs=2.2644069268639133e-21 maxrel=1.0978517625602578e-12
1.655413834499919e-9,
-7.271424478268175e-10,
1.615744341475866e-10,
-2.417623597002256e-11,
2.7367039177658787e-12,
-2.497064628721246e-13,
1.9148924811847284e-14,
-1.2632992669597348e-15,
// [17.5,18.]: m=22 maxabs=2.1101377426227736e-21 maxrel=1.16158739608613e-12
1.4542848956526613e-9,
-6.462977354447017e-10,
1.4505741591493928e-10,
-2.1893677166637258e-11,
2.4970633621176125e-12,
-2.29347190997498e-13,
1.769024913742724e-14,
-1.1730645463749656e-15,
// [17.5,18.]: m=23 maxabs=1.9765480736954596e-21 maxrel=1.2214499915640739e-12
1.2925954708884742e-9,
-5.802296625910284e-10,
1.313620630885717e-10,
-1.9976549643950242e-11,
2.2934707276077833e-12,
-2.1187263336717886e-13,
1.642668443646327e-14,
-1.0942507531933691e-15,
// [17.5,18.]: m=24 maxabs=1.851230210893676e-21 maxrel=1.271815695454191e-12
1.1604593251811823e-9,
-5.25448251353301e-10,
1.1985929794727247e-10,
-1.8347805858236556e-11,
2.1187252203743505e-12,
-1.9673586623557283e-13,
1.532307062971339e-14,
-1.0249048946364784e-15,
// [17.5,18.]: m=25 maxabs=1.7542432840718334e-21 maxrel=1.3285852210197939e-12
1.0508965027057966e-9,
-4.794371908479003e-10,
1.1008683522904554e-10,
-1.6949839409387374e-11,
1.967357616269504e-12,
-1.8351547842107596e-13,
1.435193593133395e-14,
-9.634565002591113e-16,
// [17.5,18.]: m=26 maxabs=1.658083537862544e-21 maxrel=1.3742233347389267e-12
9.588743816950135e-10,
-4.4034734002877407e-10,
1.0169903653147817e-10,
-1.5738896426756645e-11,
1.8351537812485854e-12,
-1.7188246768565075e-13,
1.3491602907141587e-14,
-9.086934608656005e-16,
// [17.5,18.]: m=27 maxabs=1.5730907299227204e-21 maxrel=1.4176472197489318e-12
8.806946800568067e-10,
-4.0679614528636406e-10,
9.443337863152245e-11,
-1.4681263830303436e-11,
1.718823731298027e-12,
-1.6157687485483588e-13,
1.2724731121969327e-14,
-8.596037142755653e-16,
// [17.5,18.]: m=28 maxabs=1.4959561378021506e-21 maxrel=1.4576125989965905e-12
8.135922905720214e-10,
-3.777335137297588e-10,
8.808758304945388e-11,
-1.3750621702336025e-11,
1.6157678478087942e-12,
-1.5239100225548007e-13,
1.2037330801437282e-14,
-8.15374738448029e-16,
// [17.5,18.]: m=29 maxabs=1.425438990582005e-21 maxrel=1.4941961741256009e-12
7.554670274588415e-10,
-3.523503314405541e-10,
8.250373027872385e-11,
-1.292617307108164e-11,
1.5239091606229208e-12,
-1.441572096862191e-13,
1.1418001842293153e-14,
-7.753393157619026e-16,
// [17.5,18.]: m=30 maxabs=1.3621596737216983e-21 maxrel=1.5292864561393002e-12
7.047006628804674e-10,
-3.3001492039327855e-10,
7.755703848842951e-11,
-1.2191302150839588e-11,
1.441571274133993e-12,
-1.3673891704846942e-13,
1.08573779807665e-14,
-7.389310124175658e-16,
// [17.5,18.]: m=31 maxabs=1.303119657500726e-21 maxrel=1.5606931126893665e-12
6.600298407857474e-10,
-3.1022815326352034e-10,
7.314781296919759e-11,
-1.1532597772331975e-11,
1.367388332980536e-12,
-1.300238520310279e-13,
1.0347688133731376e-14,
-7.057174632865389e-16,
// [17.5,18.]: m=32 maxabs=1.249146122531641e-21 maxrel=1.5902489228484945e-12
6.204563065264457e-10,
-2.925912512172811e-10,
6.919558669074866e-11,
-1.0939133043307322e-11,
1.3002377645398571e-12,
-1.239190218062702e-13,
9.88246057326892e-15,
-6.752799044098781e-16,
// [17.5,18.]: m=33 maxabs=1.1989982978956136e-21 maxrel=1.6172870991122682e-12
5.851825024339901e-10,
-2.7678234613077803e-10,
6.563479831448589e-11,
-1.0401927403265375e-11,
1.2391894904384115e-12,
-1.183467821707157e-13,
9.456244820766034e-15,
-6.473000177328526e-16,
// [17.5,18.]: m=34 maxabs=1.1537101593583353e-21 maxrel=1.6440378245607347e-12
5.535646922610083e-10,
-2.6253919265095144e-10,
6.24115644719922e-11,
-9.913540201960881e-12,
1.183467123566147e-12,
-1.1324187171391505e-13,
9.064432487410462e-15,
-6.214962337022731e-16,
// [17.5,18.]: m=35 maxabs=1.1105933699290088e-21 maxrel=1.667483493983248e-12
5.250783853013737e-10,
-2.496462573043033e-10,
5.948124126234488e-11,
-9.467760334446967e-12,
1.1324180435816207e-12,
-1.0854907434447424e-13,
8.703100480584206e-15,
-5.976296448184638e-16,
// [17.5,18.]: m=36 maxabs=1.0711988932561708e-21 maxrel=1.6904939510871975e-12
4.992925146080958e-10,
-2.379249644873087e-10,
5.680656205544849e-11,
-9.059366830208119e-12,
1.0854900941631356e-12,
-1.0422139024426959e-13,
8.368890240684328e-15,
-5.75493699158968e-16,
// [17.5,18.]: m=37 maxabs=9.9892398723435e-22 maxrel=1.6532838028158995e-12
4.758499289741976e-10,
-2.2722624767925496e-10,
5.435620102101768e-11,
-8.683942465834483e-12,
1.0422133408968167e-12,
-1.0021828515082637e-13,
8.058765306611916e-15,
-5.555962863588816e-16,
// [17.5,18.]: m=38 maxabs=9.99647770270334e-22 maxrel=1.7315950806282484e-12
4.5445249535916923e-10,
-2.1742480358963292e-10,
5.210365463112644e-11,
-8.337727144047004e-12,
1.0021852520222876e-12,
-9.650603488508071e-14,
7.770664024071015e-15,
-5.357215984942311e-16,
// [17.5,18.]: m=39 maxabs=9.669741360744894e-22 maxrel=1.7497707609668694e-12
4.3484960717880547e-10,
-2.084146180187825e-10,
5.002636290829979e-11,
-8.017502243878158e-12,
9.650597627359674e-13,
-9.30537897611031e-14,
7.501975918902992e-15,
-5.177951725664702e-16,
// [17.5,18.]: m=40 maxabs=9.366786461397347e-22 maxrel=1.7675371068708856e-12
4.1682923603711766e-10,
-2.0010545114386567e-10,
4.8105013505997586e-11,
-7.72049767401822e-12,
9.30537328764291e-13,
-8.983582614989197e-14,
7.250950748682713e-15,
-5.010115827969888e-16
},
{
// [18.,18.5]: m=0 maxabs=8.326672684688674e-17 maxrel=3.9862341546488444e-16
0.20745003174546942,
-0.0028417810943084246,
0.00005839272159290845,
-1.3331603909092241e-6,
3.195846545680824e-8,
-7.879165611297029e-10,
1.981424119894381e-11,
-5.442538355074695e-13,
// [18.,18.5]: m=1 maxabs=3.365363543395006e-16 maxrel=5.799971117889122e-14
0.005683562188612238,
-0.00023357088637091268,
7.998962398100625e-6,
-2.55667918661594e-7,
7.878887294643474e-9,
-2.3648409371325354e-10,
7.984692744949914e-12,
-2.2450470714683115e-12,
// [18.,18.5]: m=2 maxabs=0. maxrel=0.
0.00046714177273197933,
-0.00003199584934985854,
1.5340069513105758e-6,
-6.303461154433473e-8,
2.373745006339623e-9,
-8.445946264975965e-11,
2.8869857893172298e-12,
-9.615682591851531e-14,
// [18.,18.5]: m=3 maxabs=8.131516293641283e-20 maxrel=1.2108273997198105e-15
0.00006399169869971896,
-6.136027805176185e-6,
3.782076690940977e-7,
-1.8989962202011777e-8,
8.445971140876381e-10,
-3.4624755064592586e-11,
1.337741424606245e-12,
-4.9440376292741925e-14,
// [18.,18.5]: m=4 maxabs=2.879912020664621e-20 maxrel=2.2055070739143727e-15
0.000012272055610352891,
-1.5128306763427833e-6,
1.1393977315278239e-7,
-6.756778133533973e-9,
3.462484279548147e-10,
-1.6042002167168422e-11,
6.893669455684359e-13,
-2.7853811100647773e-14,
// [18.,18.5]: m=5 maxabs=1.8634724839594607e-20 maxrel=5.709111118646926e-15
3.0256613526855983e-6,
-4.5575909259436804e-7,
4.0540668794888844e-8,
-2.769988091592798e-9,
1.6042011939194782e-10,
-8.266005086337692e-12,
3.896132106029674e-13,
-1.7045303304734513e-14,
// [18.,18.5]: m=6 maxabs=1.4399560103323106e-20 maxrel=1.4444044276843963e-14
9.115181851887642e-7,
-1.6216267516852118e-7,
1.66199285460928e-8,
-1.283361394134703e-9,
8.26600984286098e-11,
-4.671159161917404e-12,
2.384796153301422e-13,
-1.1166992047308003e-14,
// [18.,18.5]: m=7 maxabs=1.0482032722271967e-20 maxrel=2.9151097476172805e-14
3.2432535033705136e-7,
-6.64797141767705e-8,
7.70016836391451e-9,
-6.612810909285856e-10,
4.671160330435273e-11,
-2.858844743142686e-12,
1.563008204910469e-13,
-7.755595702290719e-15,
// [18.,18.5]: m=8 maxabs=8.232101456127731e-21 maxrel=5.5100990185619746e-14
1.3295942835354203e-7,
-3.080067345012066e-8,
3.967686545412018e-9,
-3.7369304767482473e-10,
2.858844962282026e-11,
-1.873487276773576e-12,
1.0857125708639368e-13,
-5.65761073947988e-15,
// [18.,18.5]: m=9 maxabs=6.432156443212343e-21 maxrel=9.172146046132989e-14
6.160134690024055e-8,
-1.5870746177441166e-8,
2.2421582861053066e-9,
-2.2870776512626018e-10,
1.8734872020938627e-11,
-1.3012417139684467e-12,
7.920892929019742e-14,
-4.300859441745259e-15,
// [18.,18.5]: m=10 maxabs=5.260868695837256e-21 maxrel=1.437849590952529e-13
3.174149235488104e-8,
-8.96863314111181e-9,
1.3722465908744013e-9,
-1.4987910845465923e-10,
1.3012415580703208e-11,
-9.492377183413865e-13,
6.021702254646363e-14,
-3.3841737309099515e-15,
// [18.,18.5]: m=11 maxabs=4.360896189379562e-21 maxrel=2.0845377679290178e-13
1.793726628222221e-8,
-5.488986360818944e-9,
8.99274650862254e-10,
-1.0409943174297698e-10,
9.49237536913612e-12,
-7.215763509341315e-13,
4.7384284283770983e-14,
-2.7408036063798637e-15,
// [18.,18.5]: m=12 maxabs=3.700806060562246e-21 maxrel=2.85939197130242e-13
1.0977972721636504e-8,
-3.5970986012272803e-9,
6.245965905898226e-10,
-7.593909180310911e-11,
7.21576174807434e-12,
-5.677585693307805e-13,
3.837688188038188e-14,
-2.2740087645663244e-15,
// [18.,18.5]: m=13 maxabs=3.1896084420044747e-21 maxrel=3.724053060894543e-13
7.194197202453271e-9,
-2.498386360478384e-9,
4.5563455094060585e-10,
-5.772616920782698e-11,
5.677584072677768e-12,
-4.598005163265551e-13,
3.184129723086282e-14,
-1.925372773667413e-15,
// [18.,18.5]: m=14 maxabs=2.7875986643037033e-21 maxrel=4.645526718570456e-13
4.996772720955586e-9,
-1.822538202142432e-9,
3.463570153589993e-10,
-4.5420737369988675e-11,
4.598003669512883e-12,
-3.8147365498290655e-13,
2.6959998670923578e-14,
-1.6583309591287866e-15,
// [18.,18.5]: m=15 maxabs=2.4699613090833406e-21 maxrel=5.599843526380761e-13
3.6450764042838105e-9,
-1.3854280600203481e-9,
2.7252442431999976e-10,
-3.678408597350827e-11,
3.814735214475111e-12,
-3.2297650421031847e-13,
2.3220908925878896e-14,
-1.4491953213361951e-15,
// [18.,18.5]: m=16 maxabs=3.5155176033503676e-21 maxrel=1.0416019096238997e-12
2.770856120039987e-9,
-1.0900976960227013e-9,
2.2070451588457599e-10,
-3.051793186191642e-11,
3.2297647369005437e-12,
-2.78171051534488e-13,
2.0290059049869186e-14,
-1.2783291506522112e-15,
// [18.,18.5]: m=17 maxabs=1.9926780956402437e-21 maxrel=7.460998364876799e-13
2.1801953920531945e-9,
-8.828180626094498e-10,
1.8310759094378684e-10,
-2.5838155358872117e-11,
2.7816993981575697e-12,
-2.430817196840004e-13,
1.795436340582239e-14,
-1.1465471655799725e-15,
// [18.,18.5]: m=18 maxabs=1.8156614445538957e-21 maxrel=8.35344093645713e-13
1.7656361252180722e-9,
-7.324303627644317e-10,
1.5502893223091014e-10,
-2.22536356078955e-11,
2.430816161398173e-12,
-2.1506433542735726e-13,
1.6054971062430893e-14,
-1.034674927287648e-15,
// [18.,18.5]: m=19 maxabs=1.6632534166910004e-21 maxrel=9.184827939438084e-13
1.4648607255280945e-9,
-6.201157280044233e-10,
1.335218137208977e-10,
-1.9446566057665184e-11,
2.1506423744085707e-12,
-1.9230670459617372e-13,
1.4488584009365463e-14,
-9.411776156005167e-16,
// [18.,18.5]: m=20 maxabs=1.5311113138356542e-21 maxrel=9.95054275410125e-13
1.2402314560081323e-9,
-5.34087254041607e-10,
1.1667939641402614e-10,
-1.720517267243819e-11,
1.923066139123822e-12,
-1.735397160740518e-13,
1.3179388018203068e-14,
-8.620972057042893e-16,
// [18.,18.5]: m=21 maxabs=1.4192351359878572e-21 maxrel=1.0675935928753223e-12
1.0681745080825617e-9,
-4.66717584880042e-10,
1.0323103609711645e-10,
-1.5384560151418473e-11,
1.7353963275157652e-12,
-1.578547087662631e-13,
1.2072026033254593e-14,
-7.944895935099617e-16,
// [18.,18.5]: m=22 maxabs=1.3220414140128765e-21 maxrel=1.1349818356174429e-12
9.334351697594859e-10,
-4.129241436694053e-10,
9.230736096728056e-11,
-1.3883199378818352e-11,
1.578546304964428e-12,
-1.4458824827827254e-13,
1.112535607954095e-14,
-7.361378728624805e-16,
// [18.,18.5]: m=23 maxabs=1.2360146303073616e-21 maxrel=1.1965742788756843e-12
8.258482873382288e-10,
-3.692294431998172e-10,
8.329919632852968e-11,
-1.2628397211455511e-11,
1.4458817412127482e-12,
-1.3324726665940776e-13,
1.0308303201762189e-14,
-6.853440095526926e-16,
// [18.,18.5]: m=24 maxabs=1.1601208091056213e-21 maxrel=1.2534623227010754e-12
7.384588863990866e-10,
-3.331967846882997e-10,
7.577038332105909e-11,
-1.1567078961491607e-11,
1.332471969996135e-12,
-1.2345933949437114e-13,
9.597043008451788e-15,
-6.407833679388312e-16,
// [18.,18.5]: m=25 maxabs=1.0916716134168583e-21 maxrel=1.3047374149584622e-12
6.66393569376114e-10,
-3.0308153269684614e-10,
6.940247381804285e-11,
-1.0659799255126181e-11,
1.2345927391281577e-12,
-1.1493897184057403e-13,
8.973065701779933e-15,
-6.014348465539297e-16,
// [18.,18.5]: m=26 maxabs=1.0329417899255933e-21 maxrel=1.3550907031719006e-12
6.061630653932555e-10,
-2.776098947196539e-10,
6.395879556834453e-11,
-9.876764036140625e-12,
1.149389196646978e-12,
-1.0746437597881968e-13,
8.421804788210651e-15,
-5.664196070956093e-16,
// [18.,18.5]: m=27 maxabs=9.782444719205244e-22 maxrel=1.3991463666436806e-12
5.552197894388296e-10,
-2.5583518175106205e-10,
5.926058426175242e-11,
-9.195134465621952e-12,
1.0746431828710423e-12,
-1.0086103408840152e-13,
7.931686158224863e-15,
-5.351129250376667e-16,
// [18.,18.5]: m=28 maxabs=9.295442133564648e-22 maxrel=1.4408745648372304e-12
5.11670363501681e-10,
-2.3704233655188554e-10,
5.517080683603217e-11,
-8.597165267262164e-12,
1.0086097776287498e-12,
-9.499011625460818e-14,
7.493381817181318e-15,
-5.069728655815092e-16,
// [18.,18.5]: m=29 maxabs=8.850832554317396e-22 maxrel=1.4791004447074156e-12
4.740846731033523e-10,
-2.2068322687383122e-10,
5.1582991643705696e-11,
-8.0688970323345e-12,
9.499006274620275e-13,
-8.973999720914151e-14,
7.099332281515529e-15,
-4.815503366945071e-16,
// [18.,18.5]: m=30 maxabs=8.444480078400721e-22 maxrel=1.5143123432588435e-12
4.413664537472612e-10,
-2.06331966127053e-10,
4.841338223241299e-11,
-7.59922292982589e-12,
8.973994602206925e-13,
-8.502005404896946e-14,
6.743342197384023e-15,
-4.584804722199774e-16,
// [18.,18.5]: m=31 maxabs=8.071214826986168e-22 maxrel=1.546675821594036e-12
4.126639322537198e-10,
-1.936535285023785e-10,
4.559533761616807e-11,
-7.179212770178454e-12,
8.50200046958903e-13,
-8.075606207675935e-14,
6.420301791246614e-15,
-4.374452920204448e-16,
// [18.,18.5]: m=32 maxabs=7.734138727370809e-22 maxrel=1.5778491191153823e-12
3.8730705700446355e-10,
-1.8238135005455001e-10,
4.30752766593745e-11,
-6.8016167398073395e-12,
8.075600930820792e-13,
-7.688669539313895e-14,
6.125930454028931e-15,
-4.1823097895245836e-16,
// [18.,18.5]: m=33 maxabs=7.420327082483504e-22 maxrel=1.6062229031663188e-12
3.6476270010874496e-10,
-1.7230110624627265e-10,
4.0809700472788386e-11,
-6.460496393110073e-12,
7.688665018033816e-13,
-7.336094420567222e-14,
5.8566795265519565e-15,
-4.005814762156229e-16,
// [18.,18.5]: m=34 maxabs=7.13133085597279e-22 maxrel=1.6328947678624227e-12
3.4460221249220476e-10,
-1.6323880151581003e-10,
3.8762978391247755e-11,
-6.15094702778151e-12,
7.336090079043282e-13,
-7.013602908475884e-14,
5.609529190141615e-15,
-3.8432736054593573e-16,
// [18.,18.5]: m=35 maxabs=6.861463181127365e-22 maxrel=1.6573197768277106e-12
3.2647760303129244e-10,
-1.5505191320429883e-10,
3.6905682198060915e-11,
-5.868886490286804e-12,
7.013598726776247e-13,
-6.717585480211182e-14,
5.381920798698348e-15,
-3.693125141713314e-16,
// [18.,18.5]: m=36 maxabs=6.613825985244302e-22 maxrel=1.6809229260804376e-12
3.1010382640828e-10,
-1.4762272844515712e-10,
3.5213318972120915e-11,
-5.610892864717451e-12,
6.717581431421267e-13,
-6.444977161057785e-14,
5.1716696749253485e-15,
-3.5540358649483744e-16,
// [18.,18.5]: m=37 maxabs=6.37911348643238e-22 maxrel=1.7019933552158132e-12
2.9524545689000793e-10,
-1.40853275554008e-10,
3.3665357217623445e-11,
-5.374078523811631e-12,
6.444973255321706e-13,
-6.193160281595494e-14,
4.976899364302532e-15,
-3.424846718977992e-16,
// [18.,18.5]: m=38 maxabs=6.163012551402902e-22 maxrel=1.7225534565584351e-12
2.8170655110772046e-10,
-1.3466142854775962e-10,
3.224447117114573e-11,
-5.1559915131766715e-12,
6.19315651449129e-13,
-5.959886950240912e-14,
4.795990176624463e-15,
-3.3045519775703285e-16,
// [18.,18.5]: m=39 maxabs=5.961387277093101e-22 maxrel=1.7420554404323738e-12
2.6932285709523294e-10,
-1.2897788437281325e-10,
3.0935949106422834e-11,
-4.9545376819863265e-12,
5.959883307301498e-13,
-5.743216927423993e-14,
4.627537389859808e-15,
-3.1922764350335016e-16,
// [18.,18.5]: m=40 maxabs=5.772169711971596e-22 maxrel=1.76038123904036e-12
2.5795576874534877e-10,
-1.2374379612418088e-10,
2.9727226118465956e-11,
-4.767918705899986e-12,
5.743213392116505e-13,
-5.5414674493635636e-14,
4.470317321146898e-15,
-3.0872597775425177e-16
},
{
// [18.5,19.]: m=0 maxabs=5.415112802609201e-14 maxrel=2.6281396109129726e-13
0.20466534140145703,
-0.0027288711237203065,
0.00005457740812082105,
-1.2128415762985504e-6,
2.822827722773274e-8,
-5.386341311903154e-10,
1.685882948592252e-10,
-3.2351355072289826e-10,
// [18.5,19.]: m=1 maxabs=1.734723475976807e-18 maxrel=3.115106674889228e-16
0.005457742245548643,
-0.00021830959390016302,
7.276962482930475e-6,
-2.2639039188810514e-7,
6.791211628205078e-9,
-1.9915686428830391e-10,
5.7520472908271514e-12,
-1.6866199589945015e-13,
// [18.5,19.]: m=2 maxabs=5.421010862427522e-20 maxrel=1.2006146948078825e-16
0.0004366191878003447,
-0.000029107849931581055,
1.3583423497072337e-6,
-5.432969728904261e-8,
1.9915891138563136e-9,
-6.899147344185304e-11,
2.2967573866501936e-12,
-7.480832748796516e-14,
// [18.5,19.]: m=3 maxabs=1.3552527156068805e-20 maxrel=2.2211462736938103e-16
0.00005821569986316509,
-5.433369398788129e-6,
3.2597818348945215e-7,
-1.5932714459884835e-8,
6.89917927558175e-10,
-2.7546693559356114e-11,
1.0371489195390575e-12,
-3.7387554435037646e-14,
// [18.5,19.]: m=4 maxabs=1.3552527156068805e-20 maxrel=1.1740598512007023e-15
0.000010866738797576648,
-1.3039127339354247e-6,
9.559628671493777e-8,
-5.519344270940956e-9,
2.7546755965374206e-10,
-1.243789250881762e-11,
5.213807409266826e-13,
-2.0583086110004623e-14,
// [18.5,19.]: m=5 maxabs=1.2281977735187355e-20 maxrel=4.374577234622858e-15
2.6078254678709057e-6,
-3.823851468473239e-7,
3.311606561877047e-8,
-2.2037409680331234e-9,
1.2437902231102563e-10,
-6.251905416726519e-12,
2.87842697781518e-13,
-1.2325837373486563e-14,
// [18.5,19.]: m=6 maxabs=9.740878893424454e-21 maxrel=1.1673602089382095e-14
7.647702936946531e-7,
-1.3246426246666352e-7,
1.3222445804560469e-8,
-9.950324981829348e-10,
6.251910584427524e-11,
-3.451109137824498e-12,
1.7239578152629306e-13,
-7.915200780433407e-15,
// [18.5,19.]: m=7 maxabs=7.146840492458159e-21 maxrel=2.439771694833735e-14
2.649285249333335e-7,
-5.288978321292672e-8,
5.970194988312669e-9,
-5.001530585169774e-10,
3.451110257074032e-11,
-2.066721125957562e-12,
1.1077581844826782e-13,
-5.4006638650336376e-15,
// [18.5,19.]: m=8 maxabs=5.492479267352104e-21 maxrel=4.634767696638461e-14
1.057795664258553e-7,
-2.3880779949455727e-8,
3.0009183508760305e-9,
-2.760889721885503e-10,
2.066721441132986e-11,
-1.3278549693230196e-12,
7.559895113911296e-14,
-3.878414212219488e-15,
// [18.5,19.]: m=9 maxabs=4.137425075092236e-19 maxrel=7.633758502952386e-12
4.776155989713101e-8,
-1.2003673380913864e-8,
1.6565338711380964e-9,
-1.6533827770195596e-10,
1.3278308464070017e-11,
-9.031139451692997e-13,
5.477123321112347e-14,
-8.971130027260813e-15,
// [18.5,19.]: m=10 maxabs=3.477467295172928e-21 maxrel=1.2607610407060981e-13
2.4007346801304804e-8,
-6.626135330627688e-9,
9.920269743713312e-10,
-1.0622847879948182e-10,
9.060961664683443e-12,
-6.507551806139332e-13,
4.0723203248050224e-14,
-2.261880238430024e-15,
// [18.5,19.]: m=11 maxabs=2.8620449194334758e-21 maxrel=1.8578493391865327e-13
1.325227066125447e-8,
-3.9681078957138255e-9,
6.373708728819537e-10,
-7.248776416694175e-11,
6.507550684000606e-12,
-4.879983629281054e-13,
3.166987620004522e-14,
-1.813407270212556e-15,
// [18.5,19.]: m=12 maxabs=2.4070955825293105e-21 maxrel=2.580916707779009e-13
7.936215791426753e-9,
-2.5494834900714335e-9,
4.3492658508450617e-10,
-5.206046371841147e-11,
4.879982558590229e-12,
-3.7947932740542626e-13,
2.539096031907108e-14,
-1.491477555854492e-15,
// [18.5,19.]: m=13 maxabs=1.3189394867158026e-20 maxrel=2.179331192360208e-12
5.098966980128928e-9,
-1.7397063393042938e-9,
3.1236278361747074e-10,
-3.903990134256739e-11,
3.794777892219189e-12,
-3.042980799676281e-13,
2.0914849216499272e-14,
-1.0782534123982451e-15,
// [18.5,19.]: m=14 maxabs=1.796636290465176e-21 maxrel=4.311901766562318e-13
3.4794126782266046e-9,
-1.2494511285101976e-9,
2.342394566852581e-10,
-3.035837973047356e-11,
3.0422138455132177e-12,
-2.502059786219502e-13,
1.755037893388472e-14,
-1.0725804575120253e-15,
// [18.5,19.]: m=15 maxabs=1.5803285602825594e-21 maxrel=5.239600501128727e-13
2.498902257019711e-9,
-9.369578258306893e-10,
1.8215027844878535e-10,
-2.433774717554406e-11,
2.5020589051160977e-12,
-2.1025500479491935e-13,
1.50189491124833e-14,
-9.321031856199024e-16,
// [18.5,19.]: m=16 maxabs=1.4086885831778061e-21 maxrel=6.185615199872471e-13
1.8739156516608487e-9,
-7.286011129933752e-10,
1.4602648310911937e-10,
-2.001650330492169e-11,
2.1025492895519933e-12,
-1.7991960757621683e-13,
1.3051888416270792e-14,
-8.206989627265185e-16,
// [18.5,19.]: m=17 maxabs=1.2672406984312384e-21 maxrel=7.113335300645542e-13
1.4572022259865047e-9,
-5.841059317219196e-10,
1.200990198841754e-10,
-1.6820422862284986e-11,
1.7991953442557892e-12,
-1.5634861954155954e-13,
1.1492128934338517e-14,
-7.307815464447134e-16,
// [18.5,19.]: m=18 maxabs=1.1477130999173259e-21 maxrel=7.994981432112835e-13
1.1682118634433064e-9,
-4.803960788950118e-10,
1.0092253722384938e-10,
-1.4393588420820078e-11,
1.5634855260384718e-12,
-1.3765915050505115e-13,
1.0233084805940018e-14,
-6.570490150348641e-16,
// [18.5,19.]: m=19 maxabs=1.0484514264109626e-21 maxrel=8.841117459360541e-13
9.60792157789542e-10,
-4.036901483135725e-10,
8.636153057085693e-11,
-1.2507907480100249e-11,
1.3765908931404412e-12,
-1.2257361366745037e-13,
9.200642878116718e-15,
-5.957356186010905e-16,
// [18.5,19.]: m=20 maxabs=9.65112979696245e-22 maxrel=9.648023141049515e-13
8.073802966266973e-10,
-3.4544612175204253e-10,
7.504744492332228e-11,
-1.1012748400180284e-11,
1.2257355683082396e-12,
-1.1020366895778833e-13,
8.342114332069009e-15,
-5.441155476014761e-16,
// [18.5,19.]: m=21 maxabs=8.91804097908733e-22 maxrel=1.038425504606721e-12
6.908922435036672e-10,
-3.0018977920474766e-10,
6.607649043989855e-11,
-9.805904084988811e-12,
1.1020361707956966e-12,
-9.991780876815176e-14,
7.619281761065462e-15,
-5.001664517408513e-16,
// [18.5,19.]: m=22 maxabs=8.284213834718572e-22 maxrel=1.106910195802159e-12
6.003795584091231e-10,
-2.6430596130809353e-10,
5.883542454682988e-11,
-8.816307428031333e-12,
9.991775942338853e-13,
-9.125798676551472e-14,
7.003911734888248e-15,
-4.623870491321092e-16,
// [18.5,19.]: m=23 maxabs=7.732070775839426e-22 maxrel=1.1705217545413905e-12
5.286119226157929e-10,
-2.3534169776849874e-10,
5.289784460119343e-11,
-7.993437524866503e-12,
9.12579432888958e-13,
-8.388587337191313e-14,
6.474808499281959e-15,
-4.2960054293278706e-16,
// [18.5,19.]: m=24 maxabs=7.247136141730214e-22 maxrel=1.229501872616229e-12
4.706833955366558e-10,
-2.1159137801322434e-10,
4.7960625181818765e-11,
-7.300651124728037e-12,
8.388582996340568e-13,
-7.754735167487685e-14,
6.015794983711176e-15,
-4.009329101613978e-16,
// [18.5,19.]: m=25 maxabs=6.815968247436948e-22 maxrel=1.2837436478739441e-12
4.2318275602612613e-10,
-1.9184250036038026e-10,
4.3803906779190385e-11,
-6.710881072384918e-12,
7.754731065185403e-13,
-7.204865877960114e-14,
5.6143718189714566e-15,
-3.7567967781942766e-16,
// [18.5,19.]: m=26 maxabs=6.432363238365481e-22 maxrel=1.33401195901075e-12
3.8368500072047623e-10,
-1.7521562677174257e-10,
4.0265286463273947e-11,
-6.203798652600599e-12,
7.204862020489443e-13,
-6.723997905499679e-14,
5.260748528417671e-15,
-3.532853099387479e-16,
// [18.5,19.]: m=27 maxabs=6.0854643689760555e-22 maxrel=1.379823501285354e-12
3.5043125354319536e-10,
-1.6106114552762976e-10,
3.7222791943105165e-11,
-5.763902635856995e-12,
6.723994237407871e-13,
-6.300399345900857e-14,
4.94716855936586e-15,
-3.3330738835252604e-16,
// [18.5,19.]: m=28 maxabs=5.774754651385824e-22 maxrel=1.422607630501208e-12
3.2212229105498604e-10,
-1.4889116746441026e-10,
3.4583415841327e-11,
-5.379207709967367e-12,
6.300395857749987e-13,
-5.924775188150514e-14,
4.66741881731663e-15,
-3.153864958198248e-16,
// [18.5,19.]: m=29 maxabs=5.4914452915864125e-22 maxrel=1.4617080801950573e-12
2.9778233492855873e-10,
-1.3833366307308705e-10,
3.227524628481078e-11,
-5.040328374949258e-12,
5.924771860127544e-13,
-5.589681429266273e-14,
4.4164745465993135e-15,
-2.9922982703870763e-16,
// [18.5,19.]: m=30 maxabs=5.235019301694974e-22 maxrel=1.4982563667111503e-12
2.766673261459245e-10,
-1.2910098486130587e-10,
3.024197027358653e-11,
-4.73982860535749e-12,
5.589678249682696e-13,
-5.2890970128610724e-14,
4.190233495090984e-15,
-2.8459632028699465e-16,
// [18.5,19.]: m=31 maxabs=5.012714512071348e-22 maxrel=1.5358084147124302e-12
2.5820196972237346e-10,
-1.2096788082941065e-10,
2.8438971654894996e-11,
-4.471753196894486e-12,
5.289093987326846e-13,
-5.018107127283315e-14,
3.985315993920144e-15,
-2.712804373939958e-16,
// [18.5,19.]: m=32 maxabs=4.785756831502111e-22 maxrel=1.563547896990102e-12
2.4193576165859957e-10,
-1.1375588636674068e-10,
2.6830519203296103e-11,
-4.23128530421432e-12,
5.018104054968668e-13,
-4.772664932504038e-14,
3.7989274568234576e-15,
-2.591302423136832e-16,
// [18.5,19.]: m=33 maxabs=4.588267460255075e-22 maxrel=1.5928560678920024e-12
2.2751177273326153e-10,
-1.0732207657100121e-10,
2.538771184631302e-11,
-4.0144929311625835e-12,
4.772662134232365e-13,
-4.5494132992606857e-14,
3.6287174686501864e-15,
-2.47989955191247e-16,
// [18.5,19.]: m=34 maxabs=4.407321701259101e-22 maxrel=1.6206461196938451e-12
2.1464415314179172e-10,
-1.0155084715306914e-10,
2.4086957607131075e-11,
-3.8181389944214305e-12,
4.549410615854479e-13,
-4.345545492636589e-14,
3.4727170700315366e-15,
-2.3774506431671183e-16,
// [18.5,19.]: m=35 maxabs=4.237232687802884e-22 maxrel=1.6456149822779926e-12
2.0310169430593578e-10,
-9.634783020557371e-11,
2.2908833985923807e-11,
-3.6395374105204306e-12,
4.345542910288762e-13,
-4.158699429303773e-14,
3.329256316130224e-15,
-2.282939410754701e-16,
// [18.5,19.]: m=36 maxabs=4.082653310832037e-22 maxrel=1.6702444452671794e-12
1.9269566041095118e-10,
-9.163533572928018e-11,
2.183722448186928e-11,
-3.4764429045658404e-12,
4.158696934834232e-13,
-3.9868744094312313e-14,
3.1969121951434592e-15,
-2.195496984931878e-16,
// [18.5,19.]: m=37 maxabs=3.935828752103875e-22 maxrel=1.692088549464841e-12
1.8327067145837098e-10,
-8.734889772099143e-11,
2.0858657445496756e-11,
-3.3269658072043165e-12,
3.9868720005629957e-13,
-3.8283657130641096e-14,
3.074465575532607e-15,
-2.1143753013741702e-16,
// [18.5,19.]: m=38 maxabs=4.1433993870664e-22 maxrel=1.867831718870658e-12
1.7469779544178714e-10,
-8.343462958191388e-11,
1.996179485768032e-11,
-3.189505578901858e-12,
3.828363729516219e-13,
-3.6817064384920766e-14,
2.9607787849374494e-15,
-2.0398189276952832e-16,
// [18.5,19.]: m=39 maxabs=3.67423288338398e-22 maxrel=1.7332586369206164e-12
1.6686925916556142e-10,
-7.984717925034473e-11,
1.9137033407251823e-11,
-3.0626984054614226e-12,
3.6817104676471536e-13,
-3.5456573037481545e-14,
2.8552051289302153e-15,
-1.9685686519654108e-16,
// [18.5,19.]: m=40 maxabs=3.555325670329482e-22 maxrel=1.751789619085709e-12
1.5969435850051852e-10,
-7.65481334431798e-11,
1.8376190449122706e-11,
-2.9453758071258545e-12,
3.5456551267030354e-13,
-3.419110515617454e-14,
2.756691831581187e-15,
-1.9028300178718887e-16
},
{
// [19.,19.5]: m=0 maxabs=6.619704784327496e-14 maxrel=3.255895683460584e-13
0.20198986248673384,
-0.0026232449097173685,
0.00005110214758389735,
-1.1060871868313652e-6,
2.5224809956161302e-8,
-7.598846539456749e-10,
-1.72086259614518e-10,
3.956952156570764e-10,
// [19.,19.5]: m=1 maxabs=0. maxrel=0.
0.005246489821382824,
-0.0002044086376712403,
6.6366299132051544e-6,
-2.0110763645450187e-7,
5.8762259808342195e-9,
-1.6786054137849414e-10,
4.723953212881239e-12,
-1.3606345887686736e-13,
// [19.,19.5]: m=2 maxabs=1.0842021724855044e-19 maxrel=2.566777568989548e-16
0.00040881727534250006,
-0.000026546519652600433,
1.2066458171209689e-6,
-4.700981356339028e-8,
1.6786267027666815e-9,
-5.6650958975695486e-11,
1.8375764315586564e-12,
-5.873051642927282e-14,
// [19.,19.5]: m=3 maxabs=0. maxrel=0.
0.00005309303930520122,
-4.826583268495346e-6,
2.8205888107768133e-7,
-1.3429014114400497e-8,
5.665138105975904e-10,
-2.204240352376052e-11,
8.091155647068759e-13,
-2.8457282658980236e-14,
// [19.,19.5]: m=4 maxabs=1.1858461261560205e-20 maxrel=1.1582781313280348e-15
9.653166536991023e-6,
-1.1282355242943344e-6,
8.05740846523193e-8,
-4.532111116826564e-9,
2.2042450531565107e-10,
-9.703505437486475e-12,
3.968839355936106e-13,
-1.5309630519989316e-14,
// [19.,19.5]: m=5 maxabs=8.893845946170154e-21 maxrel=3.668103792138707e-15
2.2564710485887247e-6,
-3.222963386002876e-7,
2.719266669410406e-8,
-1.7633963970909715e-9,
9.703514532596992e-11,
-4.759229179156426e-12,
2.1404572149602775e-13,
-8.965912584835078e-15,
// [19.,19.5]: m=6 maxabs=6.564505341220828e-21 maxrel=9.354835879084943e-15
6.445926772005957e-7,
-1.0877066677083608e-7,
1.0580378380381975e-8,
-7.76281384072984e-10,
4.759232186349666e-11,
-2.5664289381516452e-12,
1.254246774567351e-13,
-5.644050795849059e-15,
// [19.,19.5]: m=7 maxabs=4.923379005915621e-21 maxrel=2.0521282418883926e-14
2.1754133354168016e-7,
-4.2321513517819676e-8,
4.657688303746357e-9,
-3.807387229508746e-10,
2.566429772807266e-11,
-1.5036766796638222e-12,
7.899173229835636e-14,
-3.781861790624904e-15,
// [19.,19.5]: m=8 maxabs=3.7190040340384124e-21 maxrel=3.933117180213407e-14
8.464302703564115e-8,
-1.8630753212375734e-8,
2.284432337552541e-9,
-2.053144861942117e-10,
1.503676865028333e-11,
-9.468986730080646e-13,
5.2940450235630386e-14,
-2.67276869781589e-15,
// [19.,19.5]: m=9 maxabs=2.871971086784112e-21 maxrel=6.813046548843062e-14
3.7261506424750986e-8,
-9.137729348276762e-9,
1.2318869171718386e-9,
-1.2029422646941251e-10,
9.468986734304612e-12,
-6.345440404160141e-13,
3.741857118409033e-14,
-1.9762266172900616e-15,
// [19.,19.5]: m=10 maxabs=2.306179547797841e-21 maxrel=1.1018770669711699e-13
1.8275458696552988e-8,
-4.9275476672035e-9,
7.21765358860415e-10,
-7.575195320159794e-11,
6.3454398099748865e-12,
-4.484534730951607e-13,
2.7669105528762626e-14,
-1.5180540721692067e-15,
// [19.,19.5]: m=11 maxabs=1.881008712945585e-21 maxrel=1.647278014579812e-13
9.85509533440632e-9,
-2.8870614342650385e-9,
4.545117192666627e-10,
-5.0763565531403034e-11,
4.484533962950164e-12,
-3.315776413692535e-13,
2.1255226171755217e-14,
-1.204199228549832e-15,
// [19.,19.5]: m=12 maxabs=1.5708159832381996e-21 maxrel=2.3223209935876333e-13
5.774122868529524e-9,
-1.818046876107816e-9,
3.045813932416382e-10,
-3.5876310048598204e-11,
3.3157757049322116e-12,
-2.5469465445959554e-13,
1.6861059834696332e-14,
-9.814002444462193e-16,
// [19.,19.5]: m=13 maxabs=1.3375510504982458e-21 maxrel=3.108738475741927e-13
3.6360937519932877e-9,
-1.2183255721589406e-9,
2.1525786034424558e-10,
-2.652623760876909e-11,
2.546945881032065e-12,
-2.020258504567883e-13,
1.3741732976791564e-14,
-8.182450076166943e-16,
// [19.,19.5]: m=14 maxabs=1.1547441351240266e-21 maxrel=3.9686910145447037e-13
2.4366511443339177e-9,
-8.610314406850824e-10,
1.5915742569715889e-10,
-2.037559422034804e-11,
2.0202578906619893e-12,
-1.6463997359084603e-13,
1.1457395855788584e-14,
-6.954651382323815e-16,
// [19.,19.5]: m=15 maxabs=1.0120554794586294e-21 maxrel=4.88191956379611e-13
1.7220628813697337e-9,
-6.366297022016923e-10,
1.2225356536348736e-10,
-1.616208659979518e-11,
1.6463991847812563e-12,
-1.372634206652722e-13,
9.738273497906538e-15,
-6.008263420559931e-16,
// [19.,19.5]: m=16 maxabs=8.976977597731733e-22 maxrel=5.815062650392722e-13
1.2732594044029805e-9,
-4.890142609398273e-10,
9.69725196361083e-11,
-1.317121404060019e-11,
1.3726337088372454e-12,
-1.1666189720900935e-13,
8.413161815205893e-15,
-5.263324830693834e-16,
// [19.,19.5]: m=17 maxabs=8.761910638467946e-22 maxrel=7.343331696637842e-13
9.78028521880107e-10,
-3.8789007809375477e-10,
7.902728426631618e-11,
-1.0981087829364782e-11,
1.1666186170657768e-12,
-1.007833397992477e-13,
7.369857706161478e-15,
-4.659083158935969e-16,
// [19.,19.5]: m=18 maxabs=7.272985535872496e-22 maxrel=7.643393314811151e-13
7.757801561761389e-10,
-3.161091366961263e-10,
6.588652739533842e-11,
-9.332964674679853e-12,
1.0078293813918185e-12,
-8.828356684704584e-14,
6.5334684427061624e-15,
-4.178711815546085e-16,
// [19.,19.5]: m=19 maxabs=6.62468273078406e-22 maxrel=8.503470842035918e-13
6.32218273391923e-10,
-2.635461092127042e-10,
5.5997788079127506e-11,
-8.062649801353433e-12,
8.828352604855319e-13,
-7.826001973707303e-14,
5.851490405816202e-15,
-3.775890792719286e-16,
// [19.,19.5]: m=20 maxabs=6.077709550733371e-22 maxrel=9.319985201081032e-13
5.270922184251288e-10,
-2.2399115198066472e-10,
4.837589883475616e-11,
-7.062695516295801e-12,
7.825998424638927e-13,
-7.008894228198158e-14,
5.287382110508917e-15,
-3.438316523180895e-16,
// [19.,19.5]: m=21 maxabs=5.6041486500467625e-22 maxrel=1.0076565781389598e-12
4.4798230396106805e-10,
-1.9350359503114337e-10,
4.2376173122484266e-11,
-6.2608110538624206e-12,
7.008890931736132e-13,
-6.333037513288936e-14,
4.814698342443203e-15,
-3.1521681911788036e-16,
// [19.,19.5]: m=22 maxabs=5.195728222598705e-22 maxrel=1.0781910434803776e-12
3.87007190062043e-10,
-1.695046922059897e-10,
3.756486634640064e-11,
-5.607124102425857e-12,
6.333034420395656e-13,
-5.766735867827282e-14,
4.414025163932354e-15,
-2.9071046838999574e-16,
// [19.,19.5]: m=23 maxabs=4.840557547083749e-22 maxrel=1.1437426449244905e-12
3.3900938441176235e-10,
-1.5025946512235824e-10,
3.364274463613809e-11,
-5.0664380654793e-12,
5.766732992507836e-13,
-5.2867226451848666e-14,
4.0708662520704985e-15,
-2.69525802044538e-16,
// [19.,19.5]: m=24 maxabs=4.5288138537278265e-22 maxrel=1.2044225113252336e-12
3.0051893024450425e-10,
-1.3457097829934748e-10,
3.039862841316354e-11,
-4.613396201645414e-12,
5.286719940645632e-13,
-4.875624517645853e-14,
3.774226539675775e-15,
-2.510595533010315e-16,
// [19.,19.5]: m=25 maxabs=4.252742324288254e-22 maxrel=1.2603708428610178e-12
2.691419565984959e-10,
-1.2159451342328104e-10,
2.7680377228930406e-11,
-4.2293851267299215e-12,
4.875621976362892e-13,
-4.520265035424816e-14,
3.5156468068110436e-15,
-2.348404965466079e-16,
// [19.,19.5]: m=26 maxabs=4.016478861827795e-22 maxrel=1.3151059720567168e-12
2.4318902684638636e-10,
-1.1072150870042953e-10,
2.537631077821563e-11,
-3.900506194130252e-12,
4.5202626497421915e-13,
-4.210507719686735e-14,
3.288531478883285e-15,
-2.20488010232544e-16,
// [19.,19.5]: m=27 maxabs=3.782283350898719e-22 maxrel=1.357964088069091e-12
2.2144301740053627e-10,
-1.0150524291036991e-10,
2.340303718698047e-11,
-3.616218228572377e-12,
4.210504972168649e-13,
-3.9384495348413353e-14,
3.0876834729814097e-15,
-2.0774088432029741e-16,
// [19.,19.5]: m=28 maxabs=3.588929882714449e-22 maxrel=1.4036377525871735e-12
2.030104858205881e-10,
-9.361214855640602e-11,
2.1697309385410306e-11,
-3.3684116415073717e-12,
3.938447724027242e-13,
-3.697859997906448e-14,
2.9089519402571794e-15,
-1.9630943924254558e-16,
// [19.,19.5]: m=29 maxabs=3.409535087367011e-22 maxrel=1.4441698177445842e-12
1.872242971126504e-10,
-8.678923735994909e-11,
2.021046986450036e-11,
-3.1507654465135215e-12,
3.6978579374889815e-13,
-3.483765956080301e-14,
2.7489913837215644e-15,
-1.8603265742701757e-16,
// [19.,19.5]: m=30 maxabs=3.247717880036325e-22 maxrel=1.4821762751063708e-12
1.735784747197449e-10,
-8.084187928537891e-11,
1.8904592693754333e-11,
-2.9582932544274295e-12,
3.4837639992555937e-13,
-3.2921616545282524e-14,
2.6050834174523566e-15,
-1.7674255175804673e-16,
// [19.,19.5]: m=31 maxabs=3.09882536977678e-22 maxrel=1.5167988409815579e-12
1.6168375857061042e-10,
-7.561837061062549e-11,
1.7749759540652825e-11,
-2.787017774480459e-12,
3.292159777206499e-13,
-3.119788354140655e-14,
2.4749962035757717e-15,
-1.6830788362150775e-16,
// [19.,19.5]: m=32 maxabs=2.9646670141783358e-22 maxrel=1.5500192303761255e-12
1.5123674122112126e-10,
-7.099903800567423e-11,
1.6722106660179812e-11,
-2.6337340972467647e-12,
3.1197865687561555e-13,
-2.963971656318051e-14,
2.35688266525313e-15,
-1.606256093742855e-16,
// [19.,19.5]: m=33 maxabs=2.8392974525882675e-22 maxrel=1.5798070974218867e-12
1.4199807601134277e-10,
-6.6888426491294e-11,
1.5802404590660318e-11,
-2.495835249444602e-12,
2.963970396272785e-13,
-2.8225009546862215e-14,
2.2492070160775582e-15,
-1.5358201985988647e-16,
// [19.,19.5]: m=34 maxabs=2.7247846365379577e-22 maxrel=1.608108671215277e-12
1.3377685298245947e-10,
-6.32096182189534e-11,
1.497501150898893e-11,
-2.3711820642384335e-12,
2.822499310537275e-13,
-2.693531276733396e-14,
2.1506746475234196e-15,
-1.471204928181771e-16,
// [19.,19.5]: m=35 maxabs=2.6180266387303326e-22 maxrel=1.6339591332157056e-12
1.264192364377823e-10,
-5.990004589808111e-11,
1.4227092397348989e-11,
-2.2580049631378737e-12,
2.693529687664302e-13,
-2.575515649275556e-14,
2.06019534876503e-15,
-1.4116795364264412e-16,
// [19.,19.5]: m=36 maxabs=2.5197989409896606e-22 maxrel=1.6585531382151427e-12
1.1980009179604235e-10,
-5.690836945689338e-11,
1.3548029790305685e-11,
-2.154829049950521e-12,
2.5755141179130933e-13,
-2.46714676628219e-14,
1.9768415738955964e-15,
-1.3566775895332545e-16,
// [19.,19.5]: m=37 maxabs=2.4285505796674047e-22 maxrel=1.6816029805383792e-12
1.1381673891367104e-10,
-5.4192119033701255e-11,
1.2928974310760941e-11,
-2.0604163949633366e-12,
2.467145292042263e-13,
-2.3673134036222763e-14,
1.8998204423146217e-15,
-1.3057107970679374e-16,
// [19.,19.5]: m=38 maxabs=2.344281554763565e-22 maxrel=1.7037541252278465e-12
1.083842380672912e-10,
-5.171589712014375e-11,
1.2362498380439737e-11,
-1.973721149366039e-12,
2.3673119815681256e-13,
-2.275065585603189e-14,
1.8284503221180847e-15,
-1.2583592968404657e-16,
// [19.,19.5]: m=39 maxabs=2.1398128470981135e-22 maxrel=1.62885631708207e-12
1.0343179424020547e-10,
-4.94499934029655e-11,
1.1842326903921824e-11,
-1.8938543410854553e-12,
2.2750644403012905e-13,
-2.1895761503148517e-14,
1.7620905855489426e-15,
-1.2166993791879262e-16,
// [19.,19.5]: m=40 maxabs=2.189702177792718e-22 maxrel=1.7424597827342715e-12
9.889998680623011e-11,
-4.7369307511354306e-11,
1.1363125982072773e-11,
-1.820055953090323e-12,
2.1895855044452807e-13,
-2.1101718572890908e-14,
1.7003860287720381e-15,
-1.1730871445914307e-16
},
{
// [19.5,20.]: m=0 maxabs=0. maxrel=0.
0.19941663819492128,
-0.0025242612094746697,
0.0000479290019315127,
-1.011158985157039e-6,
2.2398914711054202e-8,
-5.103187584669606e-10,
1.1848859543860532e-11,
-3.1748140404602384e-13,
// [19.5,20.]: m=1 maxabs=1.734723475976807e-18 maxrel=3.3710658447761586e-16
0.00504852241894581,
-0.0001917160077248487,
6.066953894583449e-6,
-1.7919133551299034e-7,
5.1033756684840995e-9,
-1.4209954749639807e-10,
3.898005497667754e-12,
-1.1055156033745473e-13,
// [19.5,20.]: m=2 maxabs=0. maxrel=0.
0.00038343201544971617,
-0.000024267815578162856,
1.0751480111453363e-6,
-4.0827009660410656e-8,
1.421018799278121e-9,
-4.67498730918069e-11,
1.478616046640827e-12,
-4.6240316102685393e-14,
// [19.5,20.]: m=3 maxabs=6.776263578034403e-21 maxrel=1.3352606985113802e-16
0.000048535631156327745,
-4.300592044565032e-6,
2.4496205768857255e-7,
-1.1368151116470387e-8,
4.675025578066581e-10,
-1.7735754353738874e-11,
6.35009867800725e-13,
-2.1846777698898055e-14,
// [19.5,20.]: m=4 maxabs=3.218725199566341e-20 maxrel=3.5337058666627507e-15
8.601184089131896e-6,
-9.798482307618762e-7,
6.820890641998382e-8,
-3.740020633060929e-9,
1.7736283743021436e-10,
-7.612653134785675e-12,
2.8301466579440606e-13,
-3.8951597694018566e-14,
// [19.5,20.]: m=5 maxabs=7.199780051661553e-21 maxrel=3.425356890230301e-15
1.959696461481905e-6,
-2.728356266159643e-7,
2.2440125692072456e-8,
-1.4188652479263019e-9,
7.615685424194692e-11,
-3.645789789199816e-12,
1.601955736784069e-13,
-6.565521415022993e-15,
// [19.5,20.]: m=6 maxabs=4.9763185651190145e-21 maxrel=8.395190028634634e-15
5.456712532319443e-7,
-8.976050276425465e-8,
8.51319148573593e-9,
-6.092549940171169e-10,
3.645792369535979e-11,
-1.9208204443140996e-12,
9.183297729004029e-14,
-4.0482595348744466e-15,
// [19.5,20.]: m=7 maxabs=3.414601568618898e-21 maxrel=1.7289212492383735e-14
1.7952100552851494e-7,
-3.405276594036306e-8,
3.6555299635348946e-9,
-2.916634920397498e-10,
1.920820733233353e-11,
-1.1010038254435692e-12,
5.6673724931582893e-14,
-2.6638909356780072e-15,
// [19.5,20.]: m=8 maxabs=2.5013941723603557e-21 maxrel=3.296773598825552e-14
6.810553188072796e-8,
-1.46221198523221e-8,
1.7499809520684945e-9,
-1.5366573118965038e-10,
1.1010040451911605e-11,
-6.793895033608149e-13,
3.728754714742229e-14,
-1.851656800203086e-15,
// [19.5,20.]: m=9 maxabs=1.945528800724721e-21 maxrel=5.898017333890701e-14
2.9244239704644042e-8,
-6.999923806953315e-9,
9.219943871269728e-10,
-8.808037637201188e-11,
6.7938951868536254e-12,
-4.4694441269074796e-13,
2.592264912855823e-14,
-1.349241424647217e-15,
// [19.5,20.]: m=10 maxabs=1.5352472168984194e-21 maxrel=9.60547678805706e-14
1.3999847613906387e-8,
-3.6879775475078772e-9,
5.284822582544741e-10,
-5.4351201483893666e-11,
4.469443830511807e-12,
-3.106879902201043e-13,
1.889031056918283e-14,
-1.0232729232507862e-15,
// [19.5,20.]: m=11 maxabs=1.2374621963793294e-21 maxrel=1.4525709016171947e-13
7.375955095015359e-9,
-2.113929032233516e-9,
3.261072089328624e-10,
-3.575558200767334e-11,
3.1068795169964915e-12,
-2.263826823452533e-13,
1.4327037427630996e-14,
-8.027224405656219e-16,
// [19.5,20.]: m=12 maxabs=1.0223952371155422e-21 maxrel=2.0709004816921354e-13
4.227858064466662e-9,
-1.3044288350982592e-9,
2.1453349208148766e-10,
-2.485506145511662e-11,
2.263826352153001e-12,
-1.7168143205119273e-13,
1.1239613506781594e-14,
-6.479590408604944e-16,
// [19.5,20.]: m=13 maxabs=1.735424925136252e-21 maxrel=5.638922092900886e-13
2.6088576701397453e-9,
-8.581339668073827e-10,
1.49130367157286e-10,
-1.811064402259712e-11,
1.7168266561074218e-12,
-1.3460602192262685e-13,
9.043598156779697e-15,
-6.635701422325216e-16,
// [19.5,20.]: m=14 maxabs=7.4570332221655445e-22 maxrel=3.6491492107077226e-13
1.7162679356045978e-9,
-5.96521474602926e-10,
1.0866379055832827e-10,
-1.3734529040778206e-11,
1.3467435649779704e-12,
-1.0870230800860335e-13,
7.501960163510952e-15,
-4.521201091566491e-16,
// [19.5,20.]: m=15 maxabs=6.509911420792328e-22 maxrel=4.544790029388039e-13
1.193042949205577e-9,
-4.3465516185407253e-10,
8.240717427076558e-11,
-1.0773963686237247e-11,
1.0870227329130132e-12,
-8.987794272047574e-14,
6.330790572625812e-15,
-3.8817856126781375e-16,
// [19.5,20.]: m=16 maxabs=5.742701402649395e-22 maxrel=5.46179436372481e-13
8.69310323707888e-10,
-3.2962869675264657e-10,
6.46437821417918e-11,
-8.696195077577523e-12,
8.987791033110679e-13,
-7.58426438322451e-14,
5.435534475906581e-15,
-3.3822222587591343e-16,
// [19.5,20.]: m=17 maxabs=5.139893531251376e-22 maxrel=6.404552126079117e-13
6.592573935050931e-10,
-2.585751282763568e-10,
5.217717047983314e-11,
-7.190244478465879e-12,
7.584262904678118e-13,
-6.511433230708543e-14,
4.735639728209958e-15,
-2.9904477510163556e-16,
// [19.5,20.]: m=18 maxabs=4.614633842280203e-22 maxrel=7.289053807836059e-13
5.171502565501636e-10,
-2.087086816893554e-10,
4.314146693473044e-11,
-6.067419571483437e-12,
6.511446863346623e-13,
-5.6732689433493573e-14,
4.178851438732114e-15,
-2.661850253371724e-16,
// [19.5,20.]: m=19 maxabs=4.1948396814095416e-22 maxrel=8.16927788810422e-13
4.17417363378515e-10,
-1.7256586750480517e-10,
3.64045174470937e-11,
-5.209166853703135e-12,
5.67326651485948e-13,
-5.005633979665912e-14,
3.727367479928872e-15,
-2.3965978796598775e-16,
// [19.5,20.]: m=20 maxabs=3.8365670785975115e-22 maxrel=8.998536048331505e-13
3.451317350094322e-10,
-1.4561806957589713e-10,
3.1255001139139754e-11,
-4.5386217103729124e-12,
5.005631728899392e-13,
-4.464682819132377e-14,
3.3559564573609002e-15,
-2.175436104659418e-16,
// [19.5,20.]: m=21 maxabs=3.527925312538663e-22 maxrel=9.770376980106778e-13
2.912361391516291e-10,
-1.2502000436230348e-10,
2.723173027789977e-11,
-4.004513152563378e-12,
4.4646807369482876e-13,
-4.019689481254553e-14,
3.046275873919626e-15,
-1.9888060940038971e-16,
// [19.5,20.]: m=22 maxabs=3.26374450440454e-22 maxrel=1.0494928454370529e-12
2.500400087244493e-10,
-1.0892692093290095e-10,
2.4027078929890783e-11,
-3.5717517369601865e-12,
4.0196875486054497e-13,
-3.648669803828212e-14,
2.784946666745176e-15,
-1.829614542102692e-16,
// [19.5,20.]: m=23 maxabs=3.0357528480696116e-22 maxrel=1.1173529604885908e-12
2.1785384186566898e-10,
-9.610831555423998e-11,
2.1430510435278837e-11,
-3.215756651017723e-12,
3.6486680012970515e-13,
-3.335588797587997e-14,
2.562036919701142e-15,
-1.692510529214125e-16,
// [19.5,20.]: m=24 maxabs=2.8346445616426567e-22 maxrel=1.1796862818098988e-12
1.9221663110834643e-10,
-8.572204158743858e-11,
1.9294539918817466e-11,
-2.918940547632731e-12,
3.3355871061537344e-13,
-3.068543862330716e-14,
2.370055429628488e-15,
-1.5733997653906044e-16,
// [19.5,20.]: m=25 maxabs=2.6573177178266014e-22 maxrel=1.2373127930399382e-12
1.7144408317475167e-10,
-7.717815953178776e-11,
1.751364329774633e-11,
-2.6684754239199074e-12,
3.0685422717436346e-13,
-2.8385572502945346e-14,
2.203268152537139e-15,
-1.469106039628219e-16,
// [19.5,20.]: m=26 maxabs=2.4996364135586805e-22 maxrel=1.2903895215718488e-12
1.5435631906345765e-10,
-7.005457305648443e-11,
1.601085255475276e-11,
-2.4548391971187954e-12,
2.8385557546740817e-13,
-2.6387574171237633e-14,
2.0572267034353416e-15,
-1.3771344665895656e-16,
// [19.5,20.]: m=27 maxabs=2.3592742033660886e-22 maxrel=1.3396270184924854e-12
1.4010914611286818e-10,
-6.404341009248613e-11,
1.472903519325992e-11,
-2.270849664534026e-12,
2.6387560124142717e-13,
-2.4638138299151476e-14,
1.9284374402972494e-15,
-1.2954959808291464e-16,
// [19.5,20.]: m=28 maxabs=2.2339046417760204e-22 maxrel=1.3855288340648964e-12
1.2808682018486475e-10,
-5.891614065362586e-11,
1.3625097997308262e-11,
-2.111009586200674e-12,
2.46381248382968e-13,
-2.3095399664501763e-14,
1.8141248955842508e-15,
-1.2226099743841137e-16,
// [19.5,20.]: m=29 maxabs=2.1193918257257106e-22 maxrel=1.4270988358468775e-12
1.17832281307151e-10,
-5.450039187621576e-11,
1.2666057526786545e-11,
-1.9710545075199857e-12,
2.3095386915616305e-13,
-2.172610366913084e-14,
1.7120615187477415e-15,
-1.1571807457777074e-16,
// [19.5,20.]: m=30 maxabs=2.0165112370394278e-22 maxrel=1.466183821873048e-12
1.0900078375233589e-10,
-5.06642299998936e-11,
1.1826327054241637e-11,
-1.847635243131963e-12,
2.1726091520543507e-13,
-2.0503556561876143e-14,
1.6204415802932335e-15,
-1.0981561051554496e-16,
// [19.5,20.]: m=31 maxabs=1.9229364302443665e-22 maxrel=1.502490415252601e-12
1.0132845999969634e-10,
-4.730530811493632e-11,
1.1085811467468069e-11,
-1.738091402605414e-12,
2.0503545001806027e-13,
-1.940612312709141e-14,
1.5377883606941321e-15,
-1.044664648394584e-16,
// [19.5,20.]: m=32 maxabs=1.836857947750567e-22 maxrel=1.535742720661814e-12
9.461061622978567e-11,
-4.4343245772597056e-11,
1.0428548423933235e-11,
-1.6402874909247527e-12,
1.9406112071059205e-13,
-1.841611009515528e-14,
1.4628841328803963e-15,
-9.959842885596508e-17,
// [19.5,20.]: m=33 maxabs=1.7584050365287409e-22 maxrel=1.567063995967289e-12
8.868649154511073e-11,
-4.171419360280388e-11,
9.841724953504154e-12,
-1.5524926826920484e-12,
1.8416099498974334e-13,
-1.751892729588406e-14,
1.3947169402707876e-15,
-9.515107873580651e-17,
// [19.5,20.]: m=34 maxabs=1.6857682389889281e-22 maxrel=1.5958239266683203e-12
8.342838720552799e-11,
-3.936689972506984e-11,
9.314956103768482e-12,
-1.47329151761336e-12,
1.7518917148433473e-13,
-1.6702450287848284e-14,
1.3324397510246063e-15,
-9.107327281433761e-17,
// [19.5,20.]: m=35 maxabs=1.6192060490725517e-22 maxrel=1.6231047992668061e-12
7.873379945006295e-11,
-3.7259824329791816e-11,
8.839749113017723e-12,
-1.4015167830225713e-12,
1.6702440506496724e-13,
-1.5956530756529055e-14,
1.2753388073387467e-15,
-8.732197944104659e-17,
// [19.5,20.]: m=36 maxabs=1.5575552440432088e-22 maxrel=1.6485744106444449e-12
7.451964865950973e-11,
-3.5358996370168193e-11,
8.409100705195875e-12,
-1.3361985164595206e-12,
1.5956521345566486e-13,
-1.5272617535495992e-14,
1.2228088756487064e-15,
-8.386027059585005e-17,
// [19.5,20.]: m=37 maxabs=1.4999110951059197e-22 maxrel=1.6719538139868294e-12
7.071799274026513e-11,
-3.363640274201201e-11,
8.017191105561328e-12,
-1.2765248584025157e-12,
1.5272608470585112e-13,
-1.464345987677717e-14,
1.174333792626586e-15,
-8.065654045543958e-17,
// [19.5,20.]: m=38 maxabs=1.4465320962021071e-22 maxrel=1.6941427229367664e-12
6.727280548395546e-11,
-3.20687643463749e-11,
7.659149156965892e-12,
-1.221811712309464e-12,
1.464345114777056e-13,
-1.4062873629278117e-14,
1.129470810108233e-15,
-7.768348108160083e-17,
// [19.5,20.]: m=39 maxabs=1.3966427655075027e-22 maxrel=1.7148460071776574e-12
6.413752869268367e-11,
-3.063659655469679e-11,
7.33087028017717e-12,
-1.1714790183893462e-12,
1.4062865204776538e-13,
-1.3525555263512277e-14,
1.0878383482327073e-15,
-7.491750162593052e-17,
// [19.5,20.]: m=40 maxabs=1.3501138560513949e-22 maxrel=1.734436134662219e-12
6.127319310932957e-11,
-2.932348105005986e-11,
7.0288741164523914e-12,
-1.1250320422037465e-12,
1.3525547112710474e-13,
-1.302693297945023e-14,
1.0491058024850645e-15,
-7.233805249532535e-17
},
{
// [20.,20.5]: m=0 maxabs=5.551115123125783e-17 maxrel=2.8012398208389113e-16
0.1969393167285447,
-0.0024313495694251266,
0.000045024987072364235,
-9.264392446040898e-7,
2.0015556298982162e-8,
-4.4472341533904097e-10,
1.007436526767472e-11,
-3.6283589033831295e-13,
// [20.,20.5]: m=1 maxabs=8.673617379884035e-19 maxrel=1.7507749062342396e-16
0.004862699138847658,
-0.00018009994828783527,
5.558635424886019e-6,
-1.60124474674667e-7,
4.447798305178033e-9,
-1.2079334743929435e-10,
3.232392978135996e-12,
-8.716565334299315e-14,
// [20.,20.5]: m=2 maxabs=5.421010862427522e-20 maxrel=1.4589792908622624e-16
0.00036019989657567705,
-0.00002223454169938572,
9.607468474234226e-7,
-3.5582390866420995e-8,
1.2079408150154425e-9,
-3.876287995756811e-11,
1.196113847232826e-12,
-3.623043924520752e-14,
// [20.,20.5]: m=3 maxabs=6.776263578034403e-21 maxrel=1.4589809095341188e-16
0.00004446908339877371,
-3.8429873896709934e-6,
2.1349434502135455e-7,
-9.663527335947709e-9,
3.8763085627526535e-10,
-1.434634700362833e-11,
5.012523346490454e-13,
-1.680308421595428e-14,
// [20.,20.5]: m=4 maxabs=1.48908392127306e-17 maxrel=1.8320747856037913e-12
7.685974779349819e-6,
-8.539773801857107e-7,
5.798116324313712e-8,
-3.1010426527940208e-9,
1.4347404127750573e-10,
-6.056872487963956e-12,
2.00540796201086e-13,
1.1548452509409895e-13,
// [20.,20.5]: m=5 maxabs=4.446922973085077e-21 maxrel=2.4317187833472546e-15
1.7079547601487566e-6,
-2.3192465597012552e-7,
1.860628341790484e-8,
-1.1477102791417093e-9,
6.011613533853483e-11,
-2.809939249315413e-12,
1.2064854956007607e-13,
-4.837461230210891e-15,
// [20.,20.5]: m=6 maxabs=3.3881317890172014e-21 maxrel=6.737919924027471e-15
4.6384931194026793e-7,
-7.442513366874205e-8,
6.886261673329797e-9,
-4.809291974007743e-10,
2.8099412007199808e-11,
-1.4466839419196314e-12,
6.766349154337466e-14,
-2.9240169356644906e-15,
// [20.,20.5]: m=7 maxabs=2.4087499437544166e-21 maxrel=1.4743848661235505e-14
1.4885026733748922e-7,
-2.7545046691445308e-8,
2.8855751838161e-9,
-2.24795370340935e-10,
1.446684716425981e-11,
-8.112521208969047e-13,
4.0911274475800676e-14,
-1.8871894754589714e-15,
// [20.,20.5]: m=8 maxabs=1.760240343512843e-21 maxrel=2.875578849047088e-14
5.509009338289165e-8,
-1.1542300733997363e-8,
1.3487722219418378e-9,
-1.1573482782954021e-10,
8.112522628052561e-12,
-4.904511062666513e-13,
2.641602454169355e-14,
-1.2900004747417486e-15,
// [20.,20.5]: m=9 maxabs=1.3267977025350564e-21 maxrel=5.1101087558293635e-14
2.308460146799905e-8,
-5.395088886873582e-9,
6.944089668129633e-10,
-6.490021699533219e-11,
4.904512605174305e-12,
-3.166458392584324e-13,
1.805597259018769e-14,
-9.256472764525667e-16,
// [20.,20.5]: m=10 maxabs=1.017432153440224e-21 maxrel=8.284296269478955e-14
1.0790177773747497e-8,
-2.7776358665865407e-9,
3.894013020072091e-10,
-3.923612775111829e-11,
3.16645786365934e-12,
-2.164123382585439e-13,
1.2960730843661108e-14,
-6.928209357076811e-16,
// [20.,20.5]: m=11 maxabs=8.255262513279216e-22 maxrel=1.290643977629429e-13
5.555271733172802e-9,
-1.5576052075036381e-9,
2.3541676652494604e-10,
-2.5331683903073255e-11,
2.164123155547283e-12,
-1.5532728375009602e-13,
9.70019106799888e-15,
-5.371999020079607e-16,
// [20.,20.5]: m=12 maxabs=6.741521992307176e-22 maxrel=1.8590602087493997e-13
3.115210415006942e-9,
-9.416670656789062e-10,
1.5199010345468446e-10,
-1.7313002028435307e-11,
1.5532723917669806e-12,
-1.1624127545491394e-13,
7.522143031912666e-15,
-4.2930494981349227e-16,
// [20.,20.5]: m=13 maxabs=5.657915389862709e-22 maxrel=2.5544643102723335e-13
1.883334131357592e-9,
-6.07960413474974e-10,
1.0387801219036286e-10,
-1.242619288272178e-11,
1.162412492826945e-12,
-9.013374457286145e-14,
6.0111049667618736e-15,
-3.518948649114621e-16,
// [20.,20.5]: m=14 maxabs=4.830734777309682e-22 maxrel=3.3464566877735297e-13
1.21592082694975e-9,
-4.1551204847359977e-10,
7.455715731502043e-11,
-9.299311456565246e-12,
9.013371977369485e-13,
-7.202273157657293e-14,
4.927318919617777e-15,
-2.947251788239044e-16,
// [20.,20.5]: m=15 maxabs=4.1979416087066154e-22 maxrel=4.218885665370997e-13
8.310240969470237e-10,
-2.9822862901452453e-10,
5.579586875617614e-11,
-7.210707403211803e-12,
7.202270932234566e-13,
-5.903354848015118e-14,
4.1268631435230895e-15,
-2.5139725935829957e-16,
// [20.,20.5]: m=16 maxabs=3.6819877016266644e-22 maxrel=5.116545327947109e-13
5.96457258028896e-10,
-2.2318347481201113e-10,
4.3264244434524944e-11,
-5.761825253365397e-12,
5.903352812776448e-13,
-4.9440684710877056e-14,
3.520218732239445e-15,
-2.1780667904938964e-16,
// [20.,20.5]: m=17 maxabs=3.269431371115842e-22 maxrel=6.03037234025294e-13
4.463669496259063e-10,
-1.7305697755100923e-10,
3.45709515340215e-11,
-4.722689721437039e-12,
4.94406662603309e-13,
-4.217090717157903e-14,
3.0498822219101132e-15,
-1.9123556941076369e-16,
// [20.,20.5]: m=18 maxabs=2.95406876258e-22 maxrel=6.985895794296597e-13
3.46113955101896e-10,
-1.3828380597045308e-10,
2.8336138338760704e-11,
-3.955259932268475e-12,
4.217089527702364e-13,
-3.6534853000144154e-14,
2.6776724157495866e-15,
-1.700533529654087e-16,
// [20.,20.5]: m=19 maxabs=2.655249766295219e-22 maxrel=7.818333913492247e-13
2.765676119402499e-10,
-1.1334455321608628e-10,
2.3731559627925246e-11,
-3.3736771871173993e-12,
3.653487783072649e-13,
-3.2076848557476314e-14,
2.3782537140848536e-15,
-1.523394347517335e-16,
// [20.,20.5]: m=20 maxabs=2.421054255366143e-22 maxrel=8.659021331936549e-13
2.2668910643206064e-10,
-9.49262383770686e-11,
2.024206313328836e-11,
-2.922795610954263e-12,
3.2076834494838524e-13,
-2.848735817119731e-14,
2.1332012102366415e-15,
-1.378217491393612e-16,
// [20.,20.5]: m=21 maxabs=2.221496932587725e-22 maxrel=9.450757452407994e-13
1.898524767540337e-10,
-8.09682524104409e-11,
1.7536773675541268e-11,
-2.5661516675435012e-12,
2.8487345105679427e-13,
-2.5551301666114046e-14,
1.929922280397891e-15,
-1.2562779377445453e-16,
// [20.,20.5]: m=22 maxabs=2.0524418948972e-22 maxrel=1.0202987562275957e-12
1.6193650482078414e-10,
-7.014709458956372e-11,
1.5396910014372334e-11,
-2.2789921117594797e-12,
2.5551289553694417e-13,
-2.3115839035860246e-14,
1.7591759911402715e-15,
-1.1526923598308276e-16,
// [20.,20.5]: m=23 maxabs=1.9097532392318026e-22 maxrel=1.0926790600312185e-12
1.4029418917904283e-10,
-6.1587639953505e-11,
1.3673952679188928e-11,
-2.0441073214347283e-12,
2.3115827431240497e-13,
-2.107021351096414e-14,
1.6141416621789921e-15,
-1.0638167424478917e-16,
// [20.,20.5]: m=24 maxabs=1.7740439199848215e-22 maxrel=1.1532173881843717e-12
1.2317527990693693e-10,
-5.4695810620481374e-11,
1.2264643936361862e-11,
-1.8492700456399018e-12,
2.1070202406851325e-13,
-1.9332707513227667e-14,
1.4897103278073077e-15,
-9.869055078943713e-17,
// [20.,20.5]: m=25 maxabs=1.6603065857587802e-22 maxrel=1.212626835051524e-12
1.0939162124088521e-10,
-4.905857565561016e-11,
1.109562028123393e-11,
-1.6856197857179009e-12,
1.93326976591447e-13,
-1.784203162250233e-14,
1.3819829931315077e-15,
-9.197548020692082e-17,
// [20.,20.5]: m=26 maxabs=1.5589769607210343e-22 maxrel=1.2670299659609793e-12
9.81171513111466e-11,
-4.438248104086626e-11,
1.011371872131824e-11,
-1.5466191752147645e-12,
1.7842022294732086e-13,
-1.6551517982128335e-14,
1.2879548767953885e-15,
-8.607098864116173e-17,
// [20.,20.5]: m=27 maxabs=1.464109684218859e-22 maxrel=1.3130840715147175e-12
8.876496208166242e-11,
-4.045487480631713e-11,
9.279715058029484e-12,
-1.4273649420822449e-12,
1.6551509087578575e-13,
-1.5425138874010367e-14,
1.2052772743543162e-15,
-8.084815009925225e-17,
// [20.,20.5]: m=28 maxabs=1.3914728866790462e-22 maxrel=1.367059223357529e-12
8.090974961254888e-11,
-3.711886015722317e-11,
8.56418965763627e-12,
-1.3241237100357037e-12,
1.5425132247664183e-13,
-1.4434735294206127e-14,
1.1320867622223736e-15,
-7.618459629502531e-17,
// [20.,20.5]: m=29 maxabs=1.3166388906371395e-22 maxrel=1.4079290156046817e-12
7.423772031437618e-11,
-3.425675856009461e-11,
7.944742267123612e-12,
-1.2340133962650203e-12,
1.4434725788501327e-13,
-1.3558018372338122e-14,
1.0668985398985974e-15,
-7.201948100265296e-17,
// [20.,20.5]: m=30 maxabs=1.2512399234571658e-22 maxrel=1.4480727002609384e-12
6.851351712012957e-11,
-3.177896900181925e-11,
7.404080383262622e-12,
-1.1547807299437944e-12,
1.3558010825860412e-13,
-1.2777181790283117e-14,
1.0085139251182707e-15,
-6.826593836762965e-17,
// [20.,20.5]: m=31 maxabs=1.1919155639006283e-22 maxrel=1.4853968797790165e-12
6.355793800358166e-11,
-2.961632146969226e-11,
6.92868438507463e-12,
-1.0846434002716184e-12,
1.2777174587794615e-13,
-1.2077839733977724e-14,
9.559533696769461e-16,
-6.487095762049056e-17,
// [20.,20.5]: m=32 maxabs=1.1377610831725473e-22 maxrel=1.5200006687143979e-12
5.923264293933061e-11,
-2.7714737479949648e-11,
6.507860406774555e-12,
-1.0221763807970089e-12,
1.2077832880246886e-13,
-1.1448269465749971e-14,
9.084126146665363e-16,
-6.178679738897459e-17,
// [20.,20.5]: m=33 maxabs=1.0801169342352582e-22 maxrel=1.5406747059392832e-12
5.5429474959851655e-11,
-2.603144156953274e-11,
6.1330582897498335e-12,
-9.662289339637326e-13,
1.1448262829965864e-13,
-1.0878835975972076e-14,
8.652271458039969e-16,
-5.897434375075154e-17,
// [20.,20.5]: m=34 maxabs=1.0421183248461035e-22 maxrel=1.5813640657028302e-12
5.206288313894317e-11,
-2.453223310378389e-11,
5.797373610580649e-12,
-9.158632347353737e-13,
1.087882898667834e-13,
-1.0361554132056526e-14,
8.258355346890553e-16,
-5.639878066858522e-17,
// [20.,20.5]: m=35 maxabs=1.000113059364895e-22 maxrel=1.6092287619566636e-12
4.9064466207520244e-11,
-2.3189494389547473e-11,
5.4951794129391466e-12,
-8.703084297924011e-13,
1.0361548103335491e-13,
-9.889763200119507e-15,
7.897757322743145e-16,
-5.403323316074495e-17,
// [20.,20.5]: m=36 maxabs=9.614682151221833e-23 maxrel=1.6355696315494564e-12
4.6378988779049334e-11,
-2.1980717601111187e-11,
5.221850583104307e-12,
-8.289258739446211e-13,
9.88975740384858e-14,
-9.457863175802311e-15,
7.566506937044353e-16,
-5.185323390594586e-17,
// [20.,20.5]: m=37 maxabs=9.254729337790554e-23 maxrel=1.6599330839778994e-12
4.396143520217845e-11,
-2.0887402283738063e-11,
4.973555247861075e-12,
-7.911825393051499e-13,
9.457857588056695e-14,
-9.061118217407818e-15,
7.261240329114294e-16,
-4.983826499082736e-17,
// [20.,20.5]: m=38 maxabs=8.919333448794444e-23 maxrel=1.682600589168584e-12
4.17748045674337e-11,
-1.9894220944589945e-11,
4.747095239874104e-12,
-7.566304810720079e-13,
9.061112832247554e-14,
-8.695498717103104e-15,
6.97907948672719e-16,
-4.7970606879301395e-17,
// [20.,20.5]: m=39 maxabs=8.607848249379944e-23 maxrel=1.7040554990929176e-12
3.9788441889138984e-11,
-1.8988380914337786e-11,
4.539782890336014e-12,
-7.248908327942298e-13,
8.695493516081345e-14,
-8.357556609122168e-15,
6.717548611590617e-16,
-4.6234984655425566e-17,
// [20.,20.5]: m=40 maxabs=8.31704256527927e-23 maxrel=1.7242359606215217e-12
3.7976761828636e-11,
-1.8159131517764054e-11,
4.349345000541822e-12,
-6.956412243521715e-13,
8.357551577735533e-14,
-8.044325846204226e-15,
6.474507169489256e-16,
-4.461811394709094e-17
},
{
// [20.5,21.]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4180195825131953e-16
0.19455208528757398,
-0.002344001015832018,
0.00004236146121142283,
-8.506312630471564e-7,
1.793491357101261e-8,
-3.8893881452722197e-10,
8.645698949467613e-12,
-2.0409518831530103e-13,
// [20.5,21.]: m=1 maxabs=2.6020852139652106e-18 maxrel=5.450512805096976e-16
0.004688002031661902,
-0.0001694458448357188,
5.103787574534079e-6,
-1.4347948359699858e-7,
3.889442524149706e-9,
-1.0308445795071934e-10,
2.692391125718429e-12,
-7.653569561823788e-14,
// [20.5,21.]: m=2 maxabs=1.6263032587282567e-19 maxrel=4.655646760738732e-16
0.00033889168967146205,
-0.000020415150298039344,
8.608768992596726e-7,
-3.111554375053099e-8,
1.0308755081166126e-9,
-3.228627370976365e-11,
9.724418201077674e-13,
-2.8656594366319396e-14,
// [20.5,21.]: m=3 maxabs=2.0328790734103208e-20 maxrel=4.772041345426383e-16
0.00004083030059607917,
-3.4435075970181274e-6,
1.8669326243041208e-7,
-8.247004761550674e-9,
3.2286375571541164e-10,
-1.1663621457634042e-11,
3.9785661824869805e-13,
-1.3071526139659986e-14,
// [20.5,21.]: m=4 maxabs=4.235164736271502e-21 maxrel=5.823051054019886e-16
6.887015194036703e-6,
-7.467730497144242e-7,
4.94820285361368e-8,
-2.582910315911117e-9,
1.1663664153073779e-10,
-4.771770418505292e-12,
1.8165981823066702e-13,
-6.54475977884183e-15,
// [20.5,21.]: m=5 maxabs=3.5998900258307764e-21 maxrel=2.2548578338162524e-15
1.493546099428885e-6,
-1.9792811414078637e-7,
1.549746189098237e-8,
-9.330932768873287e-10,
4.7717766475368136e-11,
-2.1785566448092293e-12,
9.142442721806285e-14,
-3.588648813913959e-15,
// [20.5,21.]: m=6 maxabs=2.329340604949326e-21 maxrel=5.438573695837749e-15
3.9585622828159306e-7,
-6.198984756179908e-8,
5.598559659437e-9,
-3.817422157720039e-10,
2.178559082949811e-11,
-1.0962932061860714e-12,
5.0165011462225384e-14,
-2.1235261006545395e-15,
// [20.5,21.]: m=7 maxabs=1.5881867761018131e-21 maxrel=1.1697461460620951e-14
1.2397969512360138e-7,
-2.2394238636416913e-8,
2.290453294217885e-9,
-1.742847794995069e-10,
1.0962937205975096e-11,
-6.014746309040949e-13,
2.9713626575068926e-14,
-1.3450512506783626e-15,
// [20.5,21.]: m=8 maxabs=1.1911400820763599e-21 maxrel=2.399452502155909e-14
4.4788477272836016e-8,
-9.161813175986498e-9,
1.0457086768311927e-9,
-8.77035329782959e-11,
6.014748411731072e-12,
-3.562246210093987e-13,
1.8824203816479042e-14,
-9.033095941915059e-16,
// [20.5,21.]: m=9 maxabs=8.801201717564214e-22 maxrel=4.282230657256421e-14
1.8323626351973552e-8,
-4.182834706701061e-9,
5.262211978565598e-10,
-4.8118012239048225e-11,
3.562246358355183e-12,
-2.2565102398800974e-13,
1.2645920032125774e-14,
-6.383770591620399e-16,
// [20.5,21.]: m=10 maxabs=6.832511859688009e-22 maxrel=7.196665291188859e-14
8.365669413401915e-9,
-2.104884790965484e-9,
2.8870807344093684e-10,
-2.8497989286922263e-11,
2.2565101647357478e-12,
-1.515742756156917e-13,
8.937499488236433e-15,
-4.7123777788954745e-16,
// [20.5,21.]: m=11 maxabs=5.434576624473392e-22 maxrel=1.1246385327510879e-13
4.209769581930875e-9,
-1.154832293410956e-9,
1.7098793573010228e-10,
-1.805209542483317e-11,
1.5157426318984063e-12,
-1.0711459176620623e-13,
6.5977467251401555e-15,
-3.610314716670981e-16,
// [20.5,21.]: m=12 maxabs=4.429552180221463e-22 maxrel=1.6526306113511624e-13
2.309664586821752e-9,
-6.839517426414997e-10,
1.08312572560673e-10,
-1.2125952209433257e-11,
1.0711457586455937e-12,
-7.90658949773127e-14,
5.054956687467916e-15,
-2.8548026958786377e-16,
// [20.5,21.]: m=13 maxabs=3.6933614350492686e-22 maxrel=2.3028240058294577e-13
1.3679034852828746e-9,
-4.332502900161258e-10,
7.275571326881523e-11,
-8.56917512892635e-12,
7.906587840986325e-13,
-6.0572519028524e-14,
3.997258486047348e-15,
-2.3187408991873787e-16,
// [20.5,21.]: m=14 maxabs=1.3112342993098712e-19 maxrel=1.2783851252202044e-10
8.665005800393648e-10,
-2.910228529928944e-10,
5.141505007257119e-11,
-6.325273445064516e-12,
6.057347899099151e-13,
-4.7937840426379205e-14,
3.2146897262804923e-15,
-7.479071929561282e-17,
// [20.5,21.]: m=15 maxabs=2.699710724219944e-22 maxrel=3.884472267697841e-13
5.820457057741871e-10,
-2.0566020298436276e-10,
3.7951666798460896e-11,
-4.8458065610849165e-12,
4.789483855442956e-13,
-3.890006001674978e-14,
2.6978799837906995e-15,
-1.6322695976701621e-16,
// [20.5,21.]: m=16 maxabs=2.3595326973075114e-22 maxrel=4.766763943552677e-13
4.113204059686161e-10,
-1.5180666705622164e-10,
2.9074839375267624e-11,
-3.831592580730655e-12,
3.8900048469483565e-13,
-3.2321827516801826e-14,
2.2855480052485975e-15,
-1.4057416966515246e-16,
// [20.5,21.]: m=17 maxabs=4.2253419664974345e-22 maxrel=1.148438879303678e-12
3.036133341122442e-10,
-1.162993573795663e-10,
2.2989555503674706e-11,
-3.112008739076561e-12,
3.2321801460807446e-13,
-2.7379890761345065e-14,
1.9688833374096442e-15,
-1.2453619432004824e-16,
// [20.5,21.]: m=18 maxabs=1.8678772207213056e-22 maxrel=6.586612397834849e-13
2.3259871476189812e-10,
-9.195822186605227e-11,
1.867205205458984e-11,
-2.5857495178408056e-12,
2.7380518483236925e-13,
-2.3580173631495056e-14,
1.71933930076011e-15,
-1.0855579162735879e-16,
// [20.5,21.]: m=19 maxabs=1.6848635101939482e-22 maxrel=7.47405222158286e-13
1.8391644373203007e-10,
-7.468820812362813e-11,
1.5514497114233124e-11,
-2.1904452674816023e-12,
2.3580164055038835e-13,
-2.0595701277908587e-14,
1.5200871830169827e-15,
-9.698303377730048e-17,
// [20.5,21.]: m=20 maxabs=1.5315766029302153e-22 maxrel=8.326485494007326e-13
1.493764162471858e-10,
-6.20579883716151e-11,
1.3142671611753476e-11,
-1.8864165390468265e-12,
2.0595692124376928e-13,
-1.8208260254959882e-14,
1.358054776588217e-15,
-8.743509724234287e-17,
// [20.5,21.]: m=21 maxabs=1.4007786685702678e-22 maxrel=9.128638181503322e-13
1.2411597674316492e-10,
-5.257068636940862e-11,
1.1318499240482e-11,
-1.6476584738848151e-12,
1.8208252013738816e-13,
-1.6266861161452703e-14,
1.2243545989348759e-15,
-7.945338606704392e-17,
// [20.5,21.]: m=22 maxabs=1.2898847676998775e-22 maxrel=9.888525053318901e-13
1.0514137273875724e-10,
-4.5273996890923534e-11,
9.885950849012936e-12,
-1.456663001181769e-12,
1.626685357587031e-13,
-1.4664991025128617e-14,
1.11258977609016e-15,
-7.270302425115081e-17,
// [20.5,21.]: m=23 maxabs=5.68511799978834e-20 maxrel=5.045492925338907e-10
9.05479938025527e-11,
-3.954380354647183e-11,
8.739975852851178e-12,
-1.301340542591847e-12,
1.4667907667137657e-13,
-1.3436464780254407e-14,
9.330147174167561e-16,
2.2770236412005376e-16,
// [20.5,21.]: m=24 maxabs=1.1119116890302652e-22 maxrel=1.1268427605914054e-12
7.908760666129933e-11,
-3.495991198922372e-11,
7.808105410458285e-12,
-1.1732011343308267e-12,
1.332596936265402e-13,
-1.2193593738663683e-14,
9.372940461015267e-16,
-6.195837487548152e-17,
// [20.5,21.]: m=25 maxabs=1.0383701626954726e-22 maxrel=1.187562686085303e-12
6.991982397839858e-11,
-3.1232421585546266e-11,
7.0392068106373755e-12,
-1.066079800320491e-12,
1.2193587550256945e-13,
-1.1225916894100751e-14,
8.676150143305536e-16,
-5.762934859433761e-17,
// [20.5,21.]: m=26 maxabs=9.740051712811901e-23 maxrel=1.2443904852783888e-12
6.246484317104659e-11,
-2.8156827189970755e-11,
6.396478806291781e-12,
-9.754891070424905e-13,
1.1225911083045946e-13,
-1.0391191843429273e-14,
8.069965816925241e-16,
-5.3834231576967074e-17,
// [20.5,21.]: m=27 maxabs=9.166195162853238e-23 maxrel=1.2966948684276994e-12
5.631365437989815e-11,
-2.5585915175862033e-11,
5.852934646383364e-12,
-8.9807485876248e-13,
1.0391186351696375e-13,
-9.665027112608377e-15,
7.538547531320988e-16,
-5.0483982626531774e-17,
// [20.5,21.]: m=28 maxabs=8.655669628543166e-23 maxrel=1.3454048027062616e-12
5.1171830351688277e-11,
-2.3411738539134217e-11,
5.388449156484874e-12,
-8.312967640211259e-13,
9.665021912065117e-14,
-9.028441187159369e-15,
7.069419196619272e-16,
-4.750758631979444e-17,
// [20.5,21.]: m=29 maxabs=8.19425794310343e-23 maxrel=1.3900378906852605e-12
4.682347707822847e-11,
-2.155379658214028e-11,
4.987780587840174e-12,
-7.732035049403679e-13,
9.028436237249071e-14,
-8.466484623536463e-15,
6.65264628310491e-16,
-4.4848093039280195e-17,
// [20.5,21.]: m=30 maxabs=7.778728932266245e-23 maxrel=1.431524007526336e-12
4.310759316424357e-11,
-1.9951122309891753e-11,
4.639221033172683e-12,
-7.22276557641907e-13,
8.466479923137138e-14,
-7.967252967413524e-15,
6.280235886093513e-16,
-4.245902332247918e-17,
// [20.5,21.]: m=31 maxabs=7.40068154293537e-23 maxrel=1.4697308881017332e-12
3.9902244619748196e-11,
-1.855688409332873e-11,
4.3336593492204214e-12,
-6.77319968252963e-13,
7.967248482617949e-14,
-7.521169275161182e-15,
5.94569707710216e-16,
-4.030245123741271e-17,
// [20.5,21.]: m=32 maxabs=7.058177070550131e-23 maxrel=1.505530155332945e-12
3.711376818662374e-11,
-1.7334637359429936e-11,
4.063919812734107e-12,
-6.373813766130677e-13,
7.521164993511956e-14,
-7.120456050155578e-15,
5.643711988920732e-16,
-3.8347013838799796e-17,
// [20.5,21.]: m=33 maxabs=6.745399401428518e-23 maxrel=1.538883689687755e-12
3.466927471882768e-11,
-1.625567921522397e-11,
3.824288262750428e-12,
-6.016946279275058e-13,
7.120451962520027e-14,
-6.7587416364950984e-15,
5.369888278022324e-16,
-3.656656477899204e-17,
// [20.5,21.]: m=34 maxabs=6.455886187034958e-23 maxrel=1.5693198835675942e-12
3.251135843041709e-11,
-1.5297153016877628e-11,
3.610167770513102e-12,
-5.696375218882131e-13,
6.758737706920012e-14,
-6.430763535899938e-15,
5.120577533638071e-16,
-3.4938442482038935e-17,
// [20.5,21.]: m=35 maxabs=6.190929897076567e-23 maxrel=1.5980344377704119e-12
3.059430603372738e-11,
-1.4440671049358766e-11,
3.417825134055088e-12,
-5.407003243107462e-13,
6.430759727318371e-14,
-6.132142131519832e-15,
4.892695640416091e-16,
-3.3446564198559015e-17,
// [20.5,21.]: m=36 maxabs=5.947299357285558e-23 maxrel=1.6251061872997532e-12
2.888134209868896e-11,
-1.3671300504896614e-11,
3.244201948589321e-12,
-5.144620310901508e-13,
6.132138504230542e-14,
-5.859207176663255e-15,
4.683678637979984e-16,
-3.207294111465121e-17,
// [20.5,21.]: m=37 maxabs=5.722409628247703e-23 maxrel=1.6506380739848889e-12
2.7342601009765857e-11,
-1.2976807764271805e-11,
3.0867721891559944e-12,
-4.905722837100729e-13,
5.859203693343546e-14,
-5.608862288657959e-15,
4.491325840202963e-16,
-3.080492773301789e-17,
// [20.5,21.]: m=38 maxabs=5.509798361427433e-23 maxrel=1.6734243433073893e-12
2.5953615528517208e-11,
-1.234708872768606e-11,
2.9434337047833244e-12,
-4.687374529645566e-13,
5.6088589287242474e-14,
-5.378479206819769e-15,
4.3137644330953766e-16,
-2.9631050706841603e-17,
// [20.5,21.]: m=39 maxabs=5.314635435653203e-23 maxrel=1.695595497831841e-12
2.4694177455346563e-11,
-1.1773734791258897e-11,
2.812424720227283e-12,
-4.487098292374446e-13,
5.3784759565276666e-14,
-5.165814111072215e-15,
4.149386709314468e-16,
-2.854144707622591e-17,
// [20.5,21.]: m=40 maxabs=5.132397206950114e-23 maxrel=1.7163739075422778e-12
2.3547469582493138e-11,
-1.1249698854024656e-11,
2.6922589777799617e-12,
-4.3027915185937916e-13,
5.16581097448894e-14,
-4.968941051587199e-15,
3.9968056505251217e-16,
-2.7527484111282857e-17
},
{
// [21.,21.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4352083261556195e-16
0.19224961265608248,
-0.002261760141948193,
0.000039913412534096336,
-7.826156496876291e-7,
1.6112628422223998e-8,
-3.411465245967223e-10,
7.38711195485659e-12,
-2.948041608998793e-13,
// [21.,21.5]: m=1 maxabs=0. maxrel=0.
0.004523520283895714,
-0.000159653650131256,
4.695693855309745e-6,
-1.2890111054337007e-7,
3.412051288824036e-9,
-8.830770942604654e-11,
2.253019539761878e-12,
-5.811043556199543e-14,
// [21.,21.5]: m=2 maxabs=1.0842021724855044e-19 maxrel=3.296494318014482e-16
0.0003193073002625115,
-0.000018782775420966116,
7.734066628377213e-7,
-2.729641629859419e-8,
8.830830909130491e-10,
-2.7008095539571663e-11,
7.944453925812665e-13,
-2.3253032522902136e-14,
// [21.,21.5]: m=3 maxabs=1.3552527156068805e-20 maxrel=3.461320629903716e-16
0.00003756555084193333,
-3.093626651330836e-6,
1.6377849762965682e-7,
-7.064665327294052e-9,
2.70083343675932e-10,
-9.528709329670482e-12,
3.174897087004963e-13,
-1.0175969946927173e-14,
// [21.,21.5]: m=4 maxabs=1.6940658945086007e-21 maxrel=2.5959976543993334e-16
6.187253302661965e-6,
-6.55113990512422e-7,
4.238799194443004e-8,
-2.160666977042036e-9,
9.528734522618388e-11,
-3.807869978775864e-12,
1.4164487873690325e-13,
-4.990405283412122e-15,
// [21.,21.5]: m=5 maxabs=2.329340604949326e-21 maxrel=1.6657866679248738e-15
1.310227981024886e-6,
-1.6955196777497667e-7,
1.2964001858489678e-8,
-7.622988691346947e-10,
3.80787512025449e-11,
-1.6987240685815847e-12,
6.969495276358836e-14,
-2.6763479173867048e-15,
// [21.,21.5]: m=6 maxabs=1.7999450129153882e-21 maxrel=4.915001300708469e-15
3.3910393554996414e-7,
-5.185600743234888e-8,
4.573793213679862e-9,
-3.0463007194463515e-10,
1.6987256013742556e-11,
-8.357514463250462e-13,
3.741937813049659e-14,
-1.5515862772722199e-15,
// [21.,21.5]: m=7 maxabs=1.1911400820763599e-21 maxrel=1.0509991198220693e-14
1.0371201486469923e-7,
-1.8295172853770665e-8,
1.8277804314164847e-9,
-1.358980858925533e-10,
8.357517721786558e-12,
-4.486705781735082e-13,
2.1712043330764052e-14,
-9.640752267540284e-16,
// [21.,21.5]: m=8 maxabs=8.536503921547246e-22 maxrel=2.1099459997958345e-14
3.6590345707542965e-8,
-7.311121725038926e-9,
8.153885152600218e-10,
-6.68601667538752e-11,
4.486707009472951e-12,
-2.603054445246168e-13,
1.349317253279363e-14,
-6.362035753743244e-16,
// [21.,21.5]: m=9 maxabs=6.088049308390284e-22 maxrel=3.721764404269705e-14
1.4622243450078341e-8,
-3.2615540606068905e-9,
4.0116100050695454e-10,
-3.589367338215249e-11,
2.6030546558108575e-12,
-1.617520638108917e-13,
8.906194495764769e-15,
-4.4250670115342816e-16,
// [21.,21.5]: m=10 maxabs=4.516406144539531e-22 maxrel=6.118151545140731e-14
6.523108121213773e-9,
-1.6046440017128574e-9,
2.153620402919487e-10,
-2.0824449833102077e-11,
1.6175206523225615e-12,
-1.067535390479917e-13,
6.195039073552595e-15,
-3.220696121018629e-16,
// [21.,21.5]: m=11 maxabs=3.639594695233322e-22 maxrel=9.909226013331234e-14
3.209288003425574e-9,
-8.61448160928169e-10,
1.2494669900688417e-10,
-1.294017479688206e-11,
1.0675354000049595e-12,
-7.42488449842088e-14,
4.508755599044482e-15,
-2.436518579437744e-16,
// [21.,21.5]: m=12 maxabs=2.9364911745632482e-22 maxrel=1.4731691637847999e-13
1.722896321856217e-9,
-4.997867958413257e-10,
7.764104878901397e-11,
-8.54029064613352e-12,
7.424883495017829e-13,
-5.403359777346369e-14,
3.411442048326097e-15,
-1.90561340006622e-16,
// [21.,21.5]: m=13 maxabs=2.427775097843136e-22 maxrel=2.0777852507106948e-13
9.995735916825575e-10,
-3.1056419500634306e-10,
5.124174388521854e-11,
-5.939912784923103e-12,
5.403358687299222e-13,
-4.0879813502835826e-14,
2.6682021685036636e-15,
-1.5330309028525613e-16,
// [21.,21.5]: m=14 maxabs=2.0390002099432132e-22 maxrel=2.781382801352731e-13
6.211283900125261e-10,
-2.0496697541730035e-10,
3.5639476719999286e-11,
-4.322691888509308e-12,
4.0879800886774295e-13,
-3.197103741427786e-14,
2.1466276871114343e-15,
-1.2633425203684455e-16,
// [21.,21.5]: m=15 maxabs=1.7463850682525797e-22 maxrel=3.5777301019165917e-13
4.0993395083452656e-10,
-1.425579067762097e-10,
2.5936151337898173e-11,
-3.2703882220336697e-12,
3.197102840086307e-13,
-2.571968444592727e-14,
1.7689659133899047e-15,
-1.0625529319121243e-16,
// [21.,21.5]: m=16 maxabs=1.5214953392147253e-22 maxrel=4.4458246854367334e-13
2.8511581355235184e-10,
-1.0374460526276643e-10,
1.9622329338407782e-11,
-2.557685824726142e-12,
2.571967627044167e-13,
-2.1193487627894345e-14,
1.4878339841663226e-15,
-9.09382220711731e-17,
// [21.,21.5]: m=17 maxabs=1.3389986165702135e-22 maxrel=5.338028402842296e-13
2.0748921052547436e-10,
-7.848931727645948e-11,
1.534611495392556e-11,
-2.057577188157356e-12,
2.1193480185794788e-13,
-1.7824380061902206e-14,
1.2733748929689807e-15,
-7.899863392038378e-17,
// [21.,21.5]: m=18 maxabs=1.1913985760177827e-22 maxrel=6.238315973708941e-13
1.5697863455279613e-10,
-6.13844597476108e-11,
1.2345463134001241e-11,
-1.695481130463173e-12,
1.7824373311213034e-13,
-1.5254430801742362e-14,
1.1061963340954875e-15,
-6.951093113622845e-17,
// [21.,21.5]: m=19 maxabs=1.0699064235490567e-22 maxrel=7.123625667457431e-13
1.2276891949517242e-10,
-4.9381852475599375e-11,
1.0172886787420224e-11,
-1.4259522809028732e-12,
1.5254424628779497e-13,
-1.3251164006063288e-14,
9.733502423055561e-16,
-6.184230029819914e-17,
// [21.,21.5]: m=20 maxabs=9.706447500426934e-23 maxrel=7.994793296735904e-13
9.87637049511513e-11,
-4.0691547095420194e-11,
8.555713689680825e-12,
-1.2203561404160498e-12,
1.325115834957923e-13,
-1.1659371131215165e-14,
8.659727311886099e-16,
-5.554926724803978e-17,
// [21.,21.5]: m=21 maxabs=8.856002433145853e-23 maxrel=8.814995831737746e-13
8.138309419079926e-11,
-3.4222854709580466e-11,
7.322136846411356e-12,
-1.060094633536222e-12,
1.1659365925606444e-13,
-1.0372804147907786e-14,
7.778560046822246e-16,
-5.031484448021337e-17,
// [21.,21.5]: m=22 maxabs=8.130926927454839e-23 maxrel=9.58796099319133e-13
6.844570941912315e-11,
-2.9288547340806585e-11,
6.360567804827585e-12,
-9.327510674759161e-13,
1.0372799344912293e-13,
-9.317056007569494e-15,
7.045612714767294e-16,
-4.59079177117503e-17,
// [21.,21.5]: m=23 maxabs=7.493739361847585e-23 maxrel=1.029258257646265e-12
5.85770946815769e-11,
-2.544227117812841e-11,
5.596506408228564e-12,
-8.298255945546211e-13,
9.317051519242946e-14,
-8.438925358703292e-15,
6.428542331199795e-16,
-4.215827168508009e-17,
// [21.,21.5]: m=24 maxabs=6.976751479001943e-23 maxrel=1.1000698065149864e-12
5.0884542356239413e-11,
-2.2386025594862823e-11,
4.978953569904748e-12,
-7.453656431120331e-13,
8.438921704065474e-14,
-7.699647609521802e-15,
5.903356348578932e-16,
-3.893547033955937e-17,
// [21.,21.5]: m=25 maxabs=6.503061331344623e-23 maxrel=1.1625597346575854e-12
4.477205118968823e-11,
-1.9915814244488227e-11,
4.472193861232658e-12,
-6.751151456429357e-13,
7.699644317089042e-14,
-7.070483009639351e-15,
5.45201587261037e-16,
-3.61394584878018e-17,
// [21.,21.5]: m=26 maxabs=6.090117259921666e-23 maxrel=1.2211908106815351e-12
3.983162848894766e-11,
-1.7888775412019955e-11,
4.050690876609472e-12,
-6.159728617188012e-13,
7.070479348682083e-14,
-6.529782418842775e-15,
5.060693804393035e-16,
-3.369716152329411e-17,
// [21.,21.5]: m=27 maxabs=5.719824688833475e-23 maxrel=1.2745310905314207e-12
3.5777550824012717e-11,
-1.6202763475625778e-11,
3.6958371729063074e-12,
-5.656395802913582e-13,
6.529778972119768e-14,
-6.0610020362851105e-15,
4.718703220322424e-16,
-3.1547300263724633e-17,
// [21.,21.5]: m=28 maxabs=5.441297466950385e-23 maxrel=1.3364378636381372e-12
3.240552695122628e-11,
-1.478334866267362e-11,
3.393837484161461e-12,
-5.223834757336212e-13,
6.06099883022915e-14,
-5.6513282643639736e-15,
4.4176491337797227e-16,
-2.9640718308324686e-17,
// [21.,21.5]: m=29 maxabs=5.100085464272261e-23 maxrel=1.3709073659384082e-12
2.956669732532653e-11,
-1.3575349909432666e-11,
3.1343008566187937e-12,
-4.848809950603503e-13,
5.651324744431061e-14,
-5.290712193323135e-15,
4.150912986518572e-16,
-2.794428392617874e-17,
// [21.,21.5]: m=30 maxabs=4.8344829394603125e-23 maxrel=1.4133185606849497e-12
2.715069981884242e-11,
-1.2537203400669347e-11,
2.909285972559276e-12,
-4.5210701172598e-13,
5.2907092686641374e-14,
-4.971187045026016e-15,
3.9131343944741606e-16,
-2.6422288767297674e-17,
// [21.,21.5]: m=31 maxabs=4.597960983058431e-23 maxrel=1.4537947051190616e-12
2.5074406801316828e-11,
-1.1637143865770126e-11,
2.7126420724496515e-12,
-4.2325772011142367e-13,
4.971184257621154e-14,
-4.6863668591771804e-15,
3.700011354185875e-16,
-2.5051237022506343e-17,
// [21.,21.5]: m=32 maxabs=4.3795336025561473e-23 maxrel=1.490283904809259e-12
2.3274287731519398e-11,
-1.085056826654417e-11,
2.5395463226649175e-12,
-3.9769567073989064e-13,
4.68636420081777e-14,
-4.431084594171554e-15,
3.5080229790491395e-16,
-2.3810415420030784e-17,
// [21.,21.5]: m=33 maxabs=4.1801701502337965e-23 maxrel=1.5241331080705592e-12
2.170113653306846e-11,
-1.0158185268506796e-11,
2.386174026346063e-12,
-3.749100221402352e-13,
4.431082054355432e-14,
-4.201121461147685e-15,
3.33427021620906e-16,
-2.268264561938754e-17,
// [21.,21.5]: m=34 maxabs=3.975313701656211e-23 maxrel=1.5469260153473537e-12
2.0316370536994337e-11,
-9.544696084239503e-12,
2.2494601347119418e-12,
-3.5448741031075393e-13,
4.201119001859158e-14,
-3.99300336514097e-15,
3.176353410954803e-16,
-2.1655081484908487e-17,
// [21.,21.5]: m=35 maxabs=3.8315264467397665e-23 maxrel=1.5855899442763184e-12
1.9089392168454892e-11,
-8.997840518444486e-12,
2.1269244630779365e-12,
-3.3609033140021176e-13,
3.993001731967734e-14,
-3.803850434720732e-15,
3.032244973953749e-16,
-2.071112019143604e-17,
// [21.,21.5]: m=36 maxabs=3.6786919038735235e-23 maxrel=1.613738023030982e-12
1.799568103687144e-11,
-8.507697832930544e-12,
2.0165419900792196e-12,
-3.194409137751911e-13,
3.8038482012122467e-14,
-3.631252012405498e-15,
2.9002706704034543e-16,
-1.9845035625475712e-17,
// [21.,21.5]: m=37 maxabs=3.536520236090972e-23 maxrel=1.6397023584328641e-12
1.7015395665844234e-11,
-8.06616794171527e-12,
1.916645484265272e-12,
-3.0430860013196473e-13,
3.6312498624894585e-14,
-3.473182226663695e-15,
2.778992365383955e-16,
-1.9046613709982712e-17,
// [21.,21.5]: m=38 maxabs=3.4037189736849975e-23 maxrel=1.6635413605730722e-12
1.6132335883414248e-11,
-7.666581919180842e-12,
1.825851602352583e-12,
-2.905007041874878e-13,
3.473180148468449e-14,
-3.3279251272366807e-15,
2.667190270001954e-16,
-1.830843610520623e-17,
// [21.,21.5]: m=39 maxabs=3.280611234082379e-23 maxrel=1.6860365003442384e-12
1.5333163838346017e-11,
-7.303406392197697e-12,
1.743004226624976e-12,
-2.7785510034290255e-13,
3.3279231301754e-14,
-3.1940192290891302e-15,
2.563819434544172e-16,
-1.7624024303762464e-17,
// [21.,21.5]: m=40 maxabs=3.166550782429559e-23 maxrel=1.7074976014322868e-12
1.4606812784380284e-11,
-6.972016889909049e-12,
1.667130603506418e-12,
-2.662345140228849e-13,
3.194017299223554e-14,
-3.0702128063521294e-15,
2.4679803721159314e-16,
-1.6987836990656066e-17
},
{
// [21.5,22.]: m=0 maxabs=0. maxrel=0.
0.19002699908966,
-0.0021842183762238176,
0.00003765893649415847,
-7.214353980240976e-7,
1.45115902528715e-8,
-3.0021268339023473e-10,
6.377974634853157e-12,
-1.8141794516915647e-13,
// [21.5,22.]: m=1 maxabs=8.673617379884035e-19 maxrel=1.9513851966829008e-16
0.004368436752448303,
-0.0001506357459674742,
4.328612360676249e-6,
-1.1609288038719636e-7,
3.002380170155248e-9,
-7.591911377871157e-11,
1.8919553090443573e-12,
-4.8897805533874204e-14,
// [21.5,22.]: m=2 maxabs=1.2468324983583301e-18 maxrel=4.020666721003877e-15
0.0003012714919349211,
-0.000017314449442108964,
6.96557285804299e-7,
-2.401905224777893e-8,
7.591171876072565e-10,
-2.2729257965323765e-11,
1.0298214460761857e-12,
4.5292478205561377e-13,
// [21.5,22.]: m=3 maxabs=6.776263578034403e-21 maxrel=1.879225220478485e-16
0.00003462889888505614,
-2.786229126673397e-6,
1.4411427041883282e-7,
-6.073609976201303e-9,
2.2686626471424815e-10,
-7.820801427017626e-12,
2.54649772416432e-13,
-7.994614038826353e-15,
// [21.5,22.]: m=4 maxabs=8.470329472543003e-22 maxrel=1.4429791377548704e-16
5.572458253347125e-6,
-5.764570816704611e-7,
3.644165983379286e-8,
-1.814930291630535e-9,
7.820830071587544e-11,
-3.0542678717185806e-12,
1.1105727919210088e-13,
-3.8270616027276436e-15,
// [21.5,22.]: m=5 maxabs=1.2705494208814505e-21 maxrel=1.0341440513028114e-15
1.152914163340934e-6,
-1.4576663933291957e-7,
1.0889581747124816e-8,
-6.256664909220262e-10,
3.0542718669818765e-11,
-1.3319100324839173e-12,
5.3441662625756486e-14,
-1.9976154278975302e-15,
// [21.5,22.]: m=6 maxabs=1.164670302474663e-21 maxrel=3.705808960191375e-15
2.9153327866567673e-7,
-4.35583269869056e-8,
3.753998950787025e-9,
-2.443418020256577e-10,
1.3319054812115691e-11,
-6.408441714181263e-13,
2.807952901400485e-14,
-1.1408951615635968e-15,
// [21.5,22.]: m=7 maxabs=8.337980574534519e-22 maxrel=8.776369448912874e-15
8.711665397381318e-8,
-1.5015995802460736e-8,
1.4660508118653967e-9,
-1.0655246583071442e-10,
6.4084455155814296e-12,
-3.366929401100041e-13,
1.596055377101552e-14,
-6.952012248557949e-16,
// [21.5,22.]: m=8 maxabs=5.757177063369073e-22 maxrel=1.7377247267265066e-14
3.003199160492312e-8,
-5.864203247018834e-9,
6.393147948850498e-10,
-5.126758178258098e-11,
3.366930693126668e-12,
-1.9135746630235922e-13,
9.728755382569383e-15,
-4.506140119486504e-16,
// [21.5,22.]: m=9 maxabs=4.1689902872672595e-22 maxrel=3.185492498945325e-14
1.1728406494038148e-8,
-2.557259179237849e-9,
3.0760549067183967e-10,
-2.693545761242926e-11,
1.9135749689231882e-12,
-1.1662935825887947e-13,
6.3076358064408245e-15,
-3.0833597900168694e-16,
// [21.5,22.]: m=10 maxabs=3.1184709093249143e-22 maxrel=5.4026425959800536e-14
5.114518358475671e-9,
-1.2304219624707641e-9,
1.6161274567435643e-10,
-1.5308608401943168e-11,
1.166293595355731e-12,
-7.560865675628729e-14,
4.316644570503896e-15,
-2.2113913454433724e-16,
// [21.5,22.]: m=11 maxabs=2.4360469039686665e-22 maxrel=8.674615983276982e-14
2.460843924941469e-9,
-6.464509825359284e-10,
9.185165041559422e-11,
-9.330355218916053e-12,
7.560865213262885e-13,
-5.173778306055775e-14,
3.096083557398826e-15,
-1.6515638281690866e-16,
// [21.5,22.]: m=12 maxabs=1.9521462456251453e-22 maxrel=1.308943802570299e-13
1.292901965071776e-9,
-3.6740660153755306e-10,
5.598213131795326e-11,
-6.0486971610106175e-12,
5.173777707968633e-13,
-3.710510646594249e-14,
2.312382310189642e-15,
-1.2770298588046108e-16,
// [21.5,22.]: m=13 maxabs=1.5923226791645783e-22 maxrel=1.8593386271325723e-13
7.348132030750449e-10,
-2.239285251724038e-10,
3.6292182971353816e-11,
-4.139026141278423e-12,
3.710509959935826e-13,
-2.771043748187878e-14,
1.7880594843985166e-15,
-1.0171672653188308e-16,
// [21.5,22.]: m=14 maxabs=1.3317607862103746e-22 maxrel=2.526873229278889e-13
4.478570503447448e-10,
-1.451687318042531e-10,
2.4834156852656798e-11,
-2.968411214244825e-12,
2.7710430972615646e-13,
-2.1425551210194092e-14,
1.424240195373108e-15,
-8.309554272670564e-17,
// [21.5,22.]: m=15 maxabs=1.137373342260413e-22 maxrel=3.2991303382521533e-13
2.903374636084691e-10,
-9.933662734290391e-11,
1.7810467289074378e-11,
-2.2168371875578235e-12,
2.1425546265910246e-13,
-1.7064868906549454e-14,
1.163499207101347e-15,
-6.936393713006299e-17,
// [21.5,22.]: m=16 maxabs=9.817599895238747e-23 maxrel=4.127733366536071e-13
1.9867325468582654e-10,
-7.124186909890856e-11,
1.3301023127078605e-11,
-1.714046001639092e-12,
1.7064865703859463e-13,
-1.3939887143291874e-14,
9.712096948903427e-16,
-5.89718410510776e-17,
// [21.5,22.]: m=17 maxabs=8.576828976409206e-23 maxrel=4.991270423290435e-13
1.424837381977819e-10,
-5.3204092458565336e-11,
1.0284276013492882e-11,
-1.3651912461902035e-12,
1.3939882312098108e-13,
-1.1635414559982161e-14,
8.257597171448192e-16,
-5.0936274313174925e-17,
// [21.5,22.]: m=18 maxabs=7.60230681724517e-23 maxrel=5.885435950976897e-13
1.0640818491719866e-10,
-4.11371040102594e-11,
8.19114748026644e-12,
-1.1151923272725183e-12,
1.16354103690162e-13,
-9.89239228216701e-15,
7.132418668159326e-16,
-4.459477125667221e-17,
// [21.5,22.]: m=19 maxabs=6.820362644441136e-23 maxrel=6.789666186027728e-13
8.227420802048847e-11,
-3.276458988247925e-11,
6.691153966510666e-12,
-9.308343727764083e-13,
9.892388454759094e-14,
-8.544088322486026e-15,
6.244491341998353e-16,
-3.950195693875089e-17,
// [21.5,22.]: m=20 maxabs=6.146985927034687e-23 maxrel=7.644340546351566e-13
6.552917976493259e-11,
-2.6764615831493272e-11,
5.58500623906246e-12,
-7.913924577847771e-13,
8.54408518229753e-14,
-7.480132764685545e-15,
5.531277638473688e-16,
-3.534485662128368e-17,
// [21.5,22.]: m=21 maxabs=5.59380889238985e-23 maxrel=8.478465807350899e-13
5.352923166296117e-11,
-2.2340024925084797e-11,
4.748354749127212e-12,
-6.835280610451415e-13,
7.480129542624714e-14,
-6.62556800520533e-15,
4.949310548209366e-16,
-3.1905492554610574e-17,
// [21.5,22.]: m=22 maxabs=5.124642388707429e-23 maxrel=9.270138234968019e-13
4.468004985014623e-11,
-1.8993418968160745e-11,
4.101168368498857e-12,
-5.984114972377447e-13,
6.625565036433941e-14,
-5.928288503758579e-15,
4.46771900672951e-16,
-2.902330652272993e-17,
// [21.5,22.]: m=23 maxabs=4.7220380749413853e-23 maxrel=1.001345594434963e-12
3.798683793629952e-11,
-1.6404673448033298e-11,
3.590468985517476e-12,
-5.300462413193236e-13,
5.928285721229428e-14,
-5.351294649653352e-15,
4.0641524011580766e-16,
-2.6580798359937516e-17,
// [21.5,22.]: m=24 maxabs=4.378241132849033e-23 maxrel=1.0718336614448778e-12
3.2809346896044314e-11,
-1.4361875918148394e-11,
3.180277449856661e-12,
-4.742638144217991e-13,
5.351292065246341e-14,
-4.867798895928849e-15,
3.722138162879578e-16,
-2.4489650223520335e-17,
// [21.5,22.]: m=25 maxabs=4.070633342555876e-23 maxrel=1.135386483435133e-12
2.872375183627958e-11,
-1.2721109777276033e-11,
2.8455828883821515e-12,
-4.2810425128424974e-13,
4.867796432969103e-14,
-4.458059553870249e-15,
3.4293382860990356e-16,
-2.2683229054649078e-17,
// [21.5,22.]: m=26 maxabs=3.803738348036813e-23 maxrel=1.195124162560815e-12
2.5442219554534434e-11,
-1.1382331532909623e-11,
2.5686255093917743e-12,
-3.894245393076574e-13,
4.4580573076362425e-14,
-4.107289588442742e-15,
3.176370445416455e-16,
-2.1109448076354553e-17,
// [21.5,22.]: m=27 maxabs=3.5694782136223815e-23 maxrel=1.2509858405538346e-12
2.27646630658025e-11,
-1.0274502018298602e-11,
2.336547237444596e-12,
-3.5664535530149015e-13,
4.107287459201035e-14,
-3.8042462199763e-15,
2.9560036735592545e-16,
-1.972823241411105e-17,
// [21.5,22.]: m=28 maxabs=3.3613905907770105e-23 maxrel=1.302832643206089e-12
2.054900403658145e-11,
-9.346188931701116e-12,
2.1398721333135483e-12,
-3.285837197578594e-13,
3.8042442167275705e-14,
-3.5402637817154772e-15,
2.762593023173747e-16,
-1.8507662087161623e-17,
// [21.5,22.]: m=29 maxabs=3.1465175019692904e-23 maxrel=1.3386382675705754e-12
1.8692377863390167e-11,
-8.559488516240511e-12,
1.9715023199595373e-12,
-3.0434021785604906e-13,
3.540261899909885e-14,
-3.3085789267798382e-15,
2.591674561114456e-16,
-1.7420030520529507e-17,
// [21.5,22.]: m=30 maxabs=3.005638303893853e-23 maxrel=1.3943354294432502e-12
1.7118977032461836e-11,
-7.886009263827826e-12,
1.8260413090176525e-12,
-2.8322159314871885e-13,
3.3085762648069574e-14,
-3.1038473883386726e-15,
2.439708597529519e-16,
-1.6451868543606652e-17,
// [21.5,22.]: m=31 maxabs=2.8537731133079455e-23 maxrel=1.4352068599752805e-12
1.5772018527642266e-11,
-7.304165220854106e-12,
1.6993295601722182e-12,
-2.6468670979867553e-13,
3.103845682566026e-14,
-2.921807868265773e-15,
2.303807411672006e-16,
-1.5579442749147592e-17,
// [21.5,22.]: m=32 maxabs=2.716448206927072e-23 maxrel=1.4733698728124877e-12
1.4608330441695445e-11,
-6.797318226241923e-12,
1.588120260012984e-12,
-2.483082324404891e-13,
2.9218062407189914e-14,
-2.759021934241898e-15,
2.181642819650623e-16,
-1.4791432909091312e-17,
// [21.5,22.]: m=33 maxabs=2.590109293056668e-23 maxrel=1.5081250559175242e-12
1.3594636452471594e-11,
-6.352481026303867e-12,
1.489849395812417e-12,
-2.337450491536064e-13,
2.7590203761554274e-14,
-2.612692558518541e-15,
2.0712991540237592e-16,
-1.4076539915205264e-17,
// [21.5,22.]: m=34 maxabs=2.476048841403848e-23 maxrel=1.5413091937135913e-12
1.270496205259603e-11,
-5.959397570137522e-12,
1.4024702960395299e-12,
-2.207221545496363e-13,
2.6126910699955053e-14,
-2.480524374282879e-15,
1.971191615862604e-16,
-1.342529944435541e-17,
// [21.5,22.]: m=35 maxabs=2.3855759619058607e-23 maxrel=1.5816770464522844e-12
1.191879514026356e-11,
-5.609881171630616e-12,
1.3243329283918258e-12,
-2.0901578664068646e-13,
2.48052293602256e-14,
-2.3606196971322478e-15,
1.8800000970886193e-16,
-1.2827719177695914e-17,
// [21.5,22.]: m=36 maxabs=2.2737773322404905e-23 maxrel=1.6003155920394019e-12
1.1219762343243613e-11,
-5.2973317014898595e-12,
1.2540947218289598e-12,
-1.984423153562938e-13,
2.3606172497854994e-14,
-2.2513929741764615e-15,
1.7966144537180107e-16,
-1.2283417638324999e-17,
// [21.5,22.]: m=37 maxabs=2.1841122463094494e-23 maxrel=1.6268265839777736e-12
1.059466340296936e-11,
-5.0163788758107414e-12,
1.190653893127671e-12,
-1.8884984017049622e-13,
2.2513916548059273e-14,
-2.15151963536072e-15,
1.7201006184369509e-16,
-1.1780402723638379e-17,
// [21.5,22.]: m=38 maxabs=2.1007479502005896e-23 maxrel=1.651367049527735e-12
1.0032757751611507e-11,
-4.762615561458795e-12,
1.133099041975619e-12,
-1.8011177443541585e-13,
2.1515183660631542e-14,
-2.0598771877890232e-15,
1.6496625123109172e-16,
-1.1315916976031174e-17,
// [21.5,22.]: m=39 maxabs=2.0238460026273003e-23 maxrel=1.6747503513761988e-12
9.525231122907993e-12,
-4.532396157270773e-12,
1.0806706475315429e-12,
-1.7212189453266968e-13,
2.0598759624636e-14,
-1.9755127562802944e-15,
1.5846205058596264e-16,
-1.0885806389240788e-17,
// [21.5,22.]: m=40 maxabs=1.952437051309246e-23 maxrel=1.6968547941394707e-12
9.06479231453229e-12,
-4.322682579884344e-12,
1.032731368081348e-12,
-1.647904866476708e-13,
1.975511575935568e-14,
-1.8976120953000536e-15,
1.5243906523256915e-16,
-1.048645551263066e-17
},
{
// [22.,22.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4689825546464102e-16
0.18787973243210115,
-0.0021110082271325555,
0.000035578789735633894,
-6.66269373940538e-7,
1.3100779783318514e-8,
-2.6491271977786746e-10,
5.487892841366984e-12,
-2.2677243146144559e-13,
// [22.,22.5]: m=1 maxabs=8.673617379884035e-19 maxrel=2.0198510156206413e-16
0.004222016454266803,
-0.00014231515893883652,
3.997616213914641e-6,
-1.0480631598427289e-7,
2.6495849060417067e-9,
-6.549320695078108e-11,
1.5952023225616063e-12,
-4.0393839354069995e-14,
// [22.,22.5]: m=2 maxabs=1.0625181290357943e-17 maxrel=3.628999069943066e-14
0.00028463031787842477,
-0.00001599046486877537,
6.288379161911399e-7,
-2.1196516509459542e-8,
6.547729246459368e-10,
-2.0050007571198934e-11,
9.217834278257305e-13,
1.701457608318639e-12,
// [22.,22.5]: m=3 maxabs=6.776263578034403e-21 maxrel=2.0366835396016296e-16
0.000031980929711109614,
-2.515351581278222e-6,
1.271800876949244e-7,
-5.239527379323669e-9,
1.9131832498440126e-10,
-6.447624387804643e-12,
2.052564558323674e-13,
-6.33921958064832e-15,
// [22.,22.5]: m=4 maxabs=0. maxrel=0.
5.030703162556706e-6,
-5.08720350775447e-7,
3.143716425060025e-8,
-1.5305467415355303e-9,
6.447660793117419e-11,
-2.46187333834331e-12,
8.753728663063596e-14,
-2.9578411012763014e-15,
// [22.,22.5]: m=5 maxabs=8.470329472543003e-22 maxrel=7.823506238117346e-16
1.0174407015509237e-6,
-1.2574865700074684e-7,
9.183280444097791e-9,
-5.158129259079916e-10,
2.4618798750147016e-11,
-1.049866784182394e-12,
4.12073927185106e-14,
-1.5173295775733016e-15,
// [22.,22.5]: m=6 maxabs=8.999725064576941e-22 maxrel=3.325068031995305e-15
2.51497314001492e-7,
-3.6733121775572554e-8,
3.094877554263254e-9,
-1.969504229687215e-10,
1.049868326233998e-11,
-4.941718949200111e-13,
2.119438653531373e-14,
-8.434847232684422e-16,
// [22.,22.5]: m=7 maxabs=5.69100261436483e-22 maxrel=7.117112547973211e-15
7.34662435511464e-8,
-1.2379510216558508e-8,
1.181702537632314e-9,
-8.398948582780762e-11,
4.941721152251659e-12,
-2.541434392282153e-13,
1.1802173760901535e-14,
-5.040319717064334e-16,
// [22.,22.5]: m=8 maxabs=3.8712052667481695e-22 maxrel=1.420442570547681e-14
2.4759020433116358e-8,
-4.726810150218526e-9,
5.039369149819991e-10,
-3.953378171115212e-11,
2.541434514016844e-12,
-1.4150585450921001e-13,
7.055600107413141e-15,
-3.209456993098944e-16,
// [22.,22.5]: m=9 maxabs=2.8289576949313546e-22 maxrel=2.6882474585501286e-14
9.453620300437406e-9,
-2.015747659716856e-9,
2.372026902469334e-10,
-2.0331484558144238e-11,
1.4150587968193354e-12,
-8.45861600297068e-14,
4.492459201478194e-15,
-2.1600076475640172e-16,
// [22.,22.5]: m=10 maxabs=2.125854174261281e-22 maxrel=4.6846985615002743e-14
4.031495319433732e-9,
-9.488107608381565e-10,
1.2198890734504933e-10,
-1.1320476346875218e-11,
8.458616551347027e-13,
-5.385223956767239e-14,
3.02382485209907e-15,
-1.526041084421452e-16,
// [22.,22.5]: m=11 maxabs=1.6295458067294645e-22 maxrel=7.546077492329493e-14
1.8976215216762795e-9,
-4.879556292701903e-10,
6.792285808279307e-11,
-6.76689763701284e-12,
5.385223750848912e-13,
-3.624371715464892e-14,
2.1365221448651575e-15,
-1.124531180546198e-16,
// [22.,22.5]: m=12 maxabs=1.2945376586454883e-22 maxrel=1.1532944674945861e-13
9.759112585403218e-10,
-2.7169143224719555e-10,
4.0601385825093376e-11,
-4.308182358517358e-12,
3.624371314504949e-13,
-2.5606037154691314e-14,
1.574471596685561e-15,
-8.59281341213768e-17,
// [22.,22.5]: m=13 maxabs=1.0474174506452713e-22 maxrel=1.6588101510648276e-13
5.433828644943595e-10,
-1.6240554323416235e-10,
2.5849094154056964e-11,
-2.899499698607831e-12,
2.560603319261149e-13,
-1.8868254778552344e-14,
1.2031210613063339e-15,
-6.773314845476529e-17,
// [22.,22.5]: m=14 maxabs=8.721585583605986e-23 maxrel=2.288368226024917e-13
3.24811086468288e-10,
-1.03396376562616e-10,
1.7396998194723097e-11,
-2.04848479837142e-12,
1.8868250695099507e-13,
-1.441688694894422e-14,
9.483940392312169e-16,
-5.48308340429061e-17,
// [22.,22.5]: m=15 maxabs=1.6108825441587368e-21 maxrel=6.578856264805508e-12
2.0679275312460434e-10,
-6.958799269176253e-11,
1.2290908659797574e-11,
-1.5094624495078482e-12,
1.4417033583253308e-13,
-1.1360889660218569e-14,
7.638251337561115e-16,
-4.94325214061366e-17,
// [22.,22.5]: m=16 maxabs=6.335686504273346e-23 maxrel=3.8126921762918375e-13
1.391759854690586e-10,
-4.916363513451287e-11,
9.05677097969002e-12,
-1.1533521609473634e-12,
1.1363696774599156e-13,
-9.19860184073332e-15,
6.357964326009973e-16,
-3.833966941844864e-17,
// [22.,22.5]: m=17 maxabs=5.516260709963003e-23 maxrel=4.663317807304509e-13
9.832727026900375e-11,
-3.622708388660651e-11,
6.920112967957243e-12,
-9.090970279879478e-13,
9.198598814492897e-14,
-7.617212704269628e-15,
5.368521798720397e-16,
-3.2916160826311986e-17,
// [22.,22.5]: m=18 maxabs=4.818327068121386e-23 maxrel=5.490658501938782e-13
7.245416777325021e-11,
-2.7680451844844896e-11,
5.454582171409859e-12,
-7.358890117581719e-13,
7.617208755571197e-14,
-6.431549735374697e-15,
4.609413255937763e-16,
-2.852833694270189e-17,
// [22.,22.5]: m=19 maxabs=4.340113276489167e-23 maxrel=6.434156233593686e-13
5.5360903687426536e-11,
-2.1818328655103234e-11,
4.415334152169217e-12,
-6.093777875045108e-13,
6.431473243662436e-14,
-5.521471056639358e-15,
4.0141213490929994e-16,
-2.5275482081265437e-17,
// [22.,22.5]: m=20 maxabs=3.914890742848626e-23 maxrel=7.324492025428964e-13
4.363665731018867e-11,
-1.766133658667785e-11,
3.656266726715275e-12,
-5.14518739446977e-13,
5.5214688177230414e-14,
-4.808498421766817e-15,
3.539281909174907e-16,
-2.2525073219136142e-17,
// [22.,22.5]: m=21 maxabs=3.543305702053321e-23 maxrel=8.152025284331443e-13
3.532267317334033e-11,
-1.462506688706059e-11,
3.0871124379916885e-12,
-4.417182970235404e-13,
4.808496652296437e-14,
-4.239540440307007e-15,
3.1540889339791943e-16,
-2.026014585409383e-17,
// [22.,22.5]: m=22 maxabs=3.236990381467278e-23 maxrel=8.957354803577718e-13
2.925013377410617e-11,
-1.2348449734024174e-11,
2.650309783564289e-12,
-3.846804498676406e-13,
4.2395385508166025e-14,
-3.778017149919747e-15,
2.837023628274083e-16,
-1.837179031066526e-17,
// [22.,22.5]: m=23 maxabs=2.9752652657766714e-23 maxrel=9.71692654908963e-13
2.4696899468034574e-11,
-1.0601239117870467e-11,
2.3080827005163093e-12,
-3.391637394993019e-13,
3.778015407806146e-14,
-3.3981363451904215e-15,
2.572607190573053e-16,
-1.6778452371205616e-17,
// [22.,22.5]: m=24 maxabs=2.749083067031703e-23 maxrel=1.0426070665330851e-12
2.1202478235727793e-11,
-9.232330786999706e-12,
2.0349824382079766e-12,
-3.022418350579671e-13,
3.398134730431036e-14,
-3.081345737009312e-15,
2.3494995071765897e-16,
-1.542040252081739e-17,
// [22.,22.5]: m=25 maxabs=2.553920141257473e-23 maxrel=1.1092431749012644e-12
1.8464661573997215e-11,
-8.139929738950695e-12,
1.8134510111555923e-12,
-2.718513345839676e-13,
3.081344530254488e-14,
-2.814057232809214e-15,
2.1592600320358923e-16,
-1.4250305943937602e-17,
// [22.,22.5]: m=26 maxabs=2.382667905064854e-23 maxrel=1.171005598099441e-12
1.6279859477890154e-11,
-7.253804031696217e-12,
1.6311080085728938e-12,
-2.4650807943668876e-13,
2.8140558112096347e-14,
-2.586148838657465e-15,
1.9954971064618053e-16,
-1.3234922670529805e-17,
// [22.,22.5]: m=27 maxabs=2.231125831905725e-23 maxrel=1.2279564948073888e-12
1.4507608063381965e-11,
-6.524432022233896e-12,
1.479048477617962e-12,
-2.251249471934431e-13,
2.586147511474244e-14,
-2.3899665556322005e-15,
1.8533133128294626e-16,
-1.2346445806431989e-17,
// [22.,22.5]: m=28 maxabs=2.0976783346461936e-23 maxrel=1.2812537373798102e-12
1.304886404445791e-11,
-5.916193899178897e-12,
1.3507496841015687e-12,
-2.0689225262766556e-13,
2.3899653044308623e-14,
-2.2196396177287543e-15,
1.7289021782537223e-16,
-1.1563517925101795e-17,
// [22.,22.5]: m=29 maxabs=1.9273954507339102e-23 maxrel=1.2962003440629252e-12
1.1832387798348404e-11,
-5.40299872579114e-12,
1.2413535166600437e-12,
-1.911976489489134e-13,
2.2196384271437988e-14,
-2.0706065447588923e-15,
1.6192737686177966e-16,
-1.086956788112434e-17,
// [22.,22.5]: m=30 maxabs=1.8706883423342788e-23 maxrel=1.3756017609336555e-12
1.0805997451572704e-11,
-4.965414056615212e-12,
1.1471858945741582e-12,
-1.7757147516616933e-13,
2.0706054627183053e-14,
-1.9392807711639616e-15,
1.5220383489302872e-16,
-1.0249681115630523e-17,
// [22.,22.5]: m=31 maxabs=1.7745609078676672e-23 maxrel=1.4181132450503507e-12
9.930828113222033e-12,
-4.588743568829234e-12,
1.065428851795402e-12,
-1.65648815702527e-13,
1.939279709273836e-14,
-1.8228107080985817e-15,
1.4352947287320066e-16,
-9.694042188337956e-18,
// [22.,22.5]: m=32 maxabs=1.687319202637465e-23 maxrel=1.4574242216546012e-12
9.17748713765052e-12,
-4.261715398203324e-12,
9.938928949751562e-13,
-1.551427358642488e-13,
1.8228096956503043e-14,
-1.718906171770334e-15,
1.3574897228373884e-16,
-9.193192056069722e-18,
// [22.,22.5]: m=33 maxabs=1.6076707569365583e-23 maxrel=1.4936616505874057e-12
8.523430796399032e-12,
-3.97557157136567e-12,
9.308564159118028e-13,
-1.4582511705011742e-13,
1.7189052053484328e-14,
-1.6257102709727478e-15,
1.28735580164087e-16,
-8.739654299546715e-18,
// [22.,22.5]: m=34 maxabs=1.535130894624779e-23 maxrel=1.5275163838734969e-12
7.951143142724067e-12,
-3.723425655514249e-12,
8.749507029955719e-13,
-1.3751274172867268e-13,
1.62570934566645e-14,
-1.5417041785212124e-15,
1.2238475039333262e-16,
-8.327238169048066e-18,
// [22.,22.5]: m=35 maxabs=1.4320564354824292e-23 maxrel=1.520182928406441e-12
7.446851311021512e-12,
-3.4998028042174576e-12,
8.250764510399879e-13,
-1.3005705824082774e-13,
1.5417032875511362e-14,
-1.46563536739582e-15,
1.1660989200473765e-16,
-7.95112306372503e-18,
// [22.,22.5]: m=36 maxabs=1.407337952333872e-23 maxrel=1.5881983919849041e-12
6.9996056084278114e-12,
-3.300305796719485e-12,
7.803423500948562e-13,
-1.233365606015881e-13,
1.4656345728447728e-14,
-1.3964632846850816e-15,
1.1133751327517647e-16,
-7.605795388357123e-18,
// [22.,22.5]: m=37 maxabs=1.3511155200744083e-23 maxrel=1.6158047470746483e-12
6.600611593432574e-12,
-3.1213693932611863e-12,
7.400193642209557e-13,
-1.1725105055043473e-13,
1.3964624703816326e-14,
-1.333316866328479e-15,
1.0650718047547092e-16,
-7.28869172376355e-18,
// [22.,22.5]: m=38 maxabs=1.2992551730764548e-23 maxrel=1.641822490281893e-12
6.242738786516218e-12,
-2.960077450051113e-12,
7.035063038904226e-13,
-1.1171727093186174e-13,
1.3333160836037109e-14,
-1.2754625261389453e-15,
1.0206671706938084e-16,
-6.996266578739565e-18,
// [22.,22.5]: m=39 maxabs=1.2501413242061188e-23 maxrel=1.6648764381386014e-12
5.920154900096311e-12,
-2.814025208993335e-12,
6.703036261574341e-13,
-1.0666554941931884e-13,
1.2754617715443864e-14,
-1.2222784078444828e-15,
9.797187536627067e-17,
-6.725820575208586e-18,
// [22.,22.5]: m=40 maxabs=1.2053895605972929e-23 maxrel=1.6876976404574631e-12
5.62805041798097e-12,
-2.681214498306245e-12,
6.399932970609835e-13,
-1.0203719465974712e-13,
1.2222776816482557e-14,
-1.173234350002129e-15,
9.418471590427162e-17,
-6.4750047922477364e-18
},
{
// [22.5,23.]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.4855817544357513e-16
0.18580364956651185,
-0.0020417983454357248,
0.00003365601632231332,
-6.164104898341978e-7,
1.1854030309629778e-8,
-2.345096233573708e-10,
4.750882439117285e-12,
-2.267724314614456e-14,
// [22.5,23.]: m=1 maxabs=2.6020852139652106e-18 maxrel=6.267298032200778e-16
0.004083596690873872,
-0.0001346240652841314,
3.6984629700106146e-6,
-9.483232382112878e-8,
2.3447474380858643e-9,
-5.668292082254184e-11,
1.350536128930156e-12,
-3.7559183960801926e-14,
// [22.5,23.]: m=2 maxabs=1.0842021724855044e-19 maxrel=3.9170613233328965e-16
0.0002692481305682738,
-0.000014793851879958373,
5.689939410864698e-7,
-1.8757981697115695e-8,
5.668545042029416e-10,
-1.6194948210026454e-11,
4.4504089674308696e-13,
-1.2224451383468551e-14,
// [22.5,23.]: m=3 maxabs=1.3552527156068805e-20 maxrel=4.4066945274745543e-16
0.00002958770375991734,
-2.275975764332642e-6,
1.1254789009106723e-7,
-4.534836340830868e-9,
1.619508852408431e-10,
-5.338265805572962e-12,
1.6622596392086042e-13,
-4.999401992423959e-15,
// [22.5,23.]: m=4 maxabs=0. maxrel=0.
4.551951528665449e-6,
-4.5019156036094216e-7,
2.7209018030012093e-8,
-1.2956071937800598e-9,
5.338285845958554e-11,
-1.9937655284950034e-12,
6.93552837449828e-14,
-2.2927766889397255e-15,
// [22.5,23.]: m=5 maxabs=6.352747104407253e-22 maxrel=6.639582214744574e-16
9.003831207218798e-7,
-1.0883607211865982e-7,
7.773643159338696e-9,
-4.270629186224414e-10,
1.9937701609350762e-11,
-8.31808114153028e-13,
3.1949433118060494e-14,
-1.151665260332575e-15,
// [22.5,23.]: m=6 maxabs=6.088049308390284e-22 maxrel=2.6030598724912943e-15
2.1767214423731246e-7,
-3.109457263673004e-8,
2.5623775109686743e-9,
-1.595016375613512e-10,
8.318091610882692e-12,
-3.8315745417423115e-13,
1.6089024504900596e-14,
-6.276718405061279e-16,
// [22.5,23.]: m=7 maxabs=4.1028158382630173e-22 maxrel=6.072693311478453e-15
6.218914527346185e-8,
-1.0249510043507126e-8,
9.570098251573946e-10,
-6.654474739228644e-11,
3.831577407618556e-12,
-1.929298905851124e-13,
8.778146834283645e-15,
-3.6779454761973136e-16,
// [22.5,23.]: m=8 maxabs=1.107359920914539e-18 maxrel=4.917924889923962e-11
2.0499020086344537e-8,
-3.828039347910474e-9,
3.992683366061782e-10,
-3.065193989134765e-11,
1.9309664679493606e-12,
-1.0837260110748891e-13,
7.954991213109257e-16,
4.242962050847868e-15,
// [22.5,23.]: m=9 maxabs=1.9686898578762059e-22 maxrel=2.3153997704783697e-14
7.65607860080352e-9,
-1.5970739370611515e-9,
1.8391576984427025e-10,
-1.5434403165044996e-11,
1.052513141478714e-12,
-6.170266030078696e-14,
3.217711635817587e-15,
-1.521276451118158e-16,
// [22.5,23.]: m=10 maxabs=1.4392942658422682e-22 maxrel=4.013398305288872e-14
3.194147874122344e-9,
-7.356630792732378e-10,
9.260641898550217e-11,
-8.420109274505189e-12,
6.170266659238386e-13,
-3.8572820328717484e-14,
2.129590870598573e-15,
-1.058390636116853e-16,
// [22.5,23.]: m=11 maxabs=1.104286117758292e-22 maxrel=6.613239704692788e-14
1.471326158546444e-9,
-3.7042567586666954e-10,
5.0520655647670006e-11,
-4.936216335761117e-12,
3.8572819694594637e-13,
-2.552623271483541e-14,
1.4817610830883274e-15,
-7.692078071598974e-17,
// [22.5,23.]: m=12 maxabs=8.613018128208401e-23 maxrel=1.0136549147101101e-13
7.408513517333099e-10,
-2.0208262253441727e-10,
2.961729801699581e-11,
-3.08582783755202e-12,
2.5526229481653664e-13,
-1.775937953149406e-14,
1.0769909957711569e-15,
-5.806111180770592e-17,
// [22.5,23.]: m=13 maxabs=6.93797738778852e-23 maxrel=1.4815387809149853e-13
4.0416524506881287e-10,
-1.1846919202370778e-10,
1.851496702719995e-11,
-2.0421001281175117e-12,
1.775937707776599e-13,
-1.2906910530051105e-14,
8.129327582809483e-16,
-4.5273900461019404e-17,
// [22.5,23.]: m=14 maxabs=4.692854108954749e-21 maxrel=1.6928422854917908e-11
2.3693838399851744e-10,
-7.405986803041318e-11,
1.2252601068686492e-11,
-1.4207531112463908e-12,
1.2906455804898224e-13,
-9.7283570256447e-15,
6.504348021932161e-16,
-6.676932396261488e-17,
// [22.5,23.]: m=15 maxabs=4.7950626133933323e-23 maxrel=2.741736152058781e-13
1.4811973614665347e-10,
-4.90104030532497e-11,
8.524509508338135e-12,
-1.0325538091828816e-12,
9.741576751179656e-14,
-7.595774718781539e-15,
5.083139218899131e-16,
-2.9814397217764576e-17,
// [22.5,23.]: m=16 maxabs=4.0997139109659434e-23 maxrel=3.5124042331025915e-13
9.802080610648714e-11,
-3.4098038008939724e-11,
6.195322856649391e-12,
-7.793271165051275e-13,
7.595772665043219e-14,
-6.090394331621041e-15,
4.1746696915748197e-16,
-2.4992286301283738e-17,
// [22.5,23.]: m=17 maxabs=3.54782934602822e-23 maxrel=4.3353108795405293e-13
6.819607601786426e-11,
-2.478129140576671e-11,
4.675962700459096e-12,
-6.076626462510019e-13,
6.090392453375296e-14,
-5.001607496511617e-15,
3.4995171133308424e-16,
-2.1321332755500382e-17,
// [22.5,23.]: m=18 maxabs=3.116144463852109e-23 maxrel=5.203098550355517e-13
4.956258281151993e-11,
-1.870385078379902e-11,
3.6459758787788e-12,
-4.872321177165993e-13,
5.0016058023053767e-14,
-4.1924951475626236e-15,
2.9855300517562104e-16,
-1.8466227623678022e-17,
// [22.5,23.]: m=19 maxabs=2.7671776429313004e-23 maxrel=6.083948282595253e-13
3.740770156743959e-11,
-1.45839034992274e-11,
2.92339270746294e-12,
-4.001290971697999e-13,
4.1924935919882574e-14,
-3.5765597237773736e-15,
2.5857685132813364e-16,
-1.6202974005042118e-17,
// [22.5,23.]: m=20 maxabs=2.4854192467804253e-23 maxrel=6.96995423447134e-13
2.9167806998443306e-11,
-1.1693570815808684e-11,
2.4007745840830408e-12,
-3.3540004902802895e-13,
3.576558312378836e-14,
-3.0975304042480357e-15,
2.268866437450529e-16,
-1.4377761468787856e-17,
// [22.5,23.]: m=21 maxabs=2.242111824416195e-23 maxrel=7.80419266110325e-13
2.3387141631607166e-11,
-9.603098323739132e-12,
2.0124002952502865e-12,
-2.861251684345894e-13,
3.0975289597095174e-14,
-2.71780760916541e-15,
2.01334621269753e-16,
-1.2884230558729997e-17,
// [22.5,23.]: m=22 maxabs=2.0424252546670656e-23 maxrel=8.620397017213674e-13
1.9206196647468886e-11,
-8.049601169627734e-12,
1.7167510115017617e-12,
-2.478027716837799e-13,
2.717806419228074e-14,
-2.4116485530185075e-15,
1.804172309735715e-16,
-1.1644652386155728e-17,
// [22.5,23.]: m=23 maxabs=1.8721423707547822e-23 maxrel=9.392098333560031e-13
1.6099202339246828e-11,
-6.8670040356499775e-12,
1.4868166309246696e-12,
-2.174249277786944e-13,
2.4116474599972595e-14,
-2.1610303041433537e-15,
1.6306003392273024e-16,
-1.0603476522226442e-17,
// [22.5,23.]: m=24 maxabs=1.7270626461312238e-23 maxrel=1.012387204089561e-12
1.3734008071291997e-11,
-5.947266514205965e-12,
1.304549567429995e-12,
-1.9293217648356992e-13,
2.1610292956344194e-14,
-1.953075574134837e-15,
1.484809061093703e-16,
-9.719310743115482e-18,
// [22.5,23.]: m=25 maxabs=1.5735818684114237e-23 maxrel=1.062088586430245e-12
1.1894533028403313e-11,
-5.218198260967353e-12,
1.157593059617078e-12,
-1.7288269371590137e-13,
1.9530746213500753e-14,
-1.7784103335605864e-15,
1.3610084149597864e-16,
-8.961341219082132e-18,
// [22.5,23.]: m=26 maxabs=1.490863807156121e-23 maxrel=1.1440372522212129e-12
1.0436396521928431e-11,
-4.63037223034799e-12,
1.0372961629799195e-12,
-1.56246294492977e-13,
1.7784094746023126e-14,
-1.6300933216926238e-15,
1.2548358923563398e-16,
-8.30504914925962e-18,
// [22.5,23.]: m=27 maxabs=1.3942516965493416e-23 maxrel=1.2031278572721793e-12
9.260744460689442e-12,
-4.1491846443670084e-12,
9.374777675812732e-13,
-1.4227306005224845e-13,
1.630092491505991e-14,
-1.5029031828319965e-15,
1.162972347240321e-16,
-7.732823236680818e-18,
// [22.5,23.]: m=28 maxabs=1.3081409023128643e-23 maxrel=1.2573417845644273e-12
8.298369288727863e-12,
-3.749911063263459e-12,
8.536383608991575e-13,
-1.3040768176574224e-13,
1.5029024032112655e-14,
-1.3928554675465262e-15,
1.0828445364107219e-16,
-7.230031400182435e-18,
// [22.5,23.]: m=29 maxabs=1.2320467483065213e-23 maxrel=1.308092423886424e-12
7.499822126521122e-12,
-3.414553436969622e-12,
7.824460911465209e-13,
-1.202324573242527e-13,
1.3928547323949969e-14,
-1.296868890788846e-15,
1.0124394927161668e-16,
-6.785284772260918e-18,
// [22.5,23.]: m=30 maxabs=1.1929495396663196e-23 maxrel=1.388906740767225e-12
6.829106873935163e-12,
-3.129784358345761e-12,
7.213947444659877e-13,
-1.1142862819777754e-13,
1.2968682000714558e-14,
-1.2125312693348749e-15,
9.501596793312977e-17,
-6.3894543070592254e-18,
// [22.5,23.]: m=31 maxabs=1.1021535427415537e-23 maxrel=1.3980927769953858e-12
6.25956871668595e-12,
-2.88557897198572e-12,
6.68571769685188e-13,
-1.0374969112319691e-13,
1.2125305997022508e-14,
-1.1379327355283978e-15,
8.947409260232689e-17,
-6.035291943443604e-18,
// [22.5,23.]: m=32 maxabs=1.0473851389025934e-23 maxrel=1.439349043149938e-12
5.771157943966494e-12,
-2.6742870731572014e-12,
6.224981472107773e-13,
-9.700267130188175e-14,
1.1379321070918143e-14,
-1.071545286196829e-15,
8.451418998494266e-17,
-5.71667557113572e-18,
// [22.5,23.]: m=33 maxabs=9.966557028983648e-24 maxrel=1.4762740474814708e-12
5.348574146309696e-12,
-2.4899925835410072e-12,
5.82016028261256e-13,
-9.103478063929776e-14,
1.0715446863895755e-14,
-1.0121344622510189e-15,
8.005264866004014e-17,
-5.428718589822854e-18,
// [22.5,23.]: m=34 maxabs=9.506922489391194e-24 maxrel=1.5109663222687454e-12
4.979985167077501e-12,
-2.328064107998097e-12,
5.462086842665246e-13,
-8.572377677544821e-14,
1.012133888233056e-14,
-9.586939692862427e-16,
7.602042625835763e-17,
-5.167346852593818e-18,
// [22.5,23.]: m=35 maxabs=9.089293215279949e-24 maxrel=1.5437289880821584e-12
4.656128215991904e-12,
-2.1848347322516905e-12,
5.143426610622417e-13,
-8.0970903619075e-14,
9.586934233685828e-15,
-9.10396626821825e-16,
7.236032566443036e-17,
-4.929131687295104e-18,
// [22.5,23.]: m=36 maxabs=8.66358600549924e-24 maxrel=1.5666534149386306e-12
4.3696694645005e-12,
-2.0573706396396987e-12,
4.858254220831627e-13,
-7.669565806874413e-14,
9.103961177648655e-15,
-8.665562135572677e-16,
6.902432220329811e-17,
-4.713005222599594e-18,
// [22.5,23.]: m=37 maxabs=8.348546514390177e-24 maxrel=1.6020674251100742e-12
4.114741279291073e-12,
-1.943301684025351e-12,
4.601739478672171e-13,
-7.283186443257887e-14,
8.665566440367091e-15,
-8.266036751429839e-16,
6.59732017984441e-17,
-4.511190081672456e-18,
// [22.5,23.]: m=38 maxabs=8.020582326209972e-24 maxrel=1.6284100692071388e-12
3.886603368046906e-12,
-1.8406957872427157e-12,
4.369911869588094e-13,
-6.932470055814451e-14,
8.266031906120441e-15,
-7.900557536863272e-16,
6.31721687074673e-17,
-4.326982937739248e-18,
// [22.5,23.]: m=39 maxabs=7.715236357904265e-24 maxrel=1.6527412081927053e-12
3.681391574481779e-12,
-1.7479647437751172e-12,
4.1594820369837605e-13,
-6.612841764000784e-14,
7.900552876733932e-15,
-7.565071549352077e-16,
6.059267568721857e-17,
-4.156830379659549e-18,
// [22.5,23.]: m=40 maxabs=7.43331640304e-24 maxrel=1.675900794745691e-12
3.4959294875466922e-12,
-1.6637928108874196e-12,
3.9677050617840584e-13,
-6.320457924569627e-14,
7.56506703916527e-15,
-7.256123512771309e-16,
5.821005675802649e-17,
-3.999228279649365e-18
},
{
// [23.,23.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.5019975207670735e-16
0.18379490245109786,
-0.0019762892728059692,
0.00003187563321916225,
-5.712478810111471e-7,
1.0749271913577157e-8,
-2.079744142209884e-10,
4.12725825259831e-12,
-2.4944967460759017e-13,
// [23.,23.5]: m=1 maxabs=2.6020852139652106e-18 maxrel=6.477364311904562e-16
0.0039525785456170056,
-0.00012750253287021758,
3.4274872279349937e-6,
-8.599426783354095e-8,
2.0805017149366072e-9,
-4.9212363699545925e-11,
1.1475039363873306e-12,
-3.401586471921684e-14,
// [23.,23.5]: m=2 maxabs=1.6263032587282567e-19 maxrel=6.207474185098254e-16
0.0002550050657404602,
-0.000013709948911641907,
5.159656044223911e-7,
-1.6644015963479703e-8,
4.921572376274548e-10,
-1.3758647714275429e-11,
3.7001111180252275e-13,
-1.0009876857477873e-14,
// [23.,23.5]: m=3 maxabs=2.0328790734103208e-20 maxrel=7.13859587208344e-16
0.000027419897823284227,
-2.0638624176707283e-6,
9.98640956954257e-8,
-3.937258293090162e-9,
1.3758787318977386e-10,
-4.437840218914063e-12,
1.3522745699330588e-13,
-4.013916328358107e-15,
// [23.,23.5]: m=4 maxabs=1.6940658945086007e-21 maxrel=3.9092330852418343e-16
4.127724835341706e-6,
-3.994563827793196e-7,
2.3623549735578144e-8,
-1.1007030706219757e-9,
4.437870797992687e-11,
-1.6219969009363365e-12,
5.5220242791942755e-14,
-1.7855007115799856e-15,
// [23.,23.5]: m=5 maxabs=1.0587911840678754e-22 maxrel=1.2487860768629288e-16
7.989127655586143e-7,
-9.449419894135506e-8,
6.604218421827606e-9,
-3.550297003723253e-10,
1.6219997432259564e-11,
-6.623042230930795e-13,
2.4902955424878257e-14,
-8.789957718199725e-16,
// [23.,23.5]: m=6 maxabs=3.970466940254533e-22 maxrel=1.9583451682491355e-15
1.8898839788270043e-7,
-2.6416873686841484e-8,
2.13017820169717e-9,
-1.297599981630638e-10,
6.623049670517094e-12,
-2.986576516869982e-13,
1.2281437749444972e-14,
-4.695157515552506e-16,
// [23.,23.5]: m=7 maxabs=1.2427349764759874e-17 maxrel=2.1689900852024492e-10
5.283374738121977e-8,
-8.520712273204897e-9,
7.785616467875342e-10,
-5.29921359321463e-11,
2.967867729199013e-12,
-1.122370632231025e-13,
5.5410355039916747e-14,
-5.0480220678205014e-14,
// [23.,23.5]: m=8 maxabs=1.885971796620903e-22 maxrel=1.0095612455412242e-14
1.704142561303941e-8,
-3.11423995508312e-9,
3.1790644812918525e-10,
-2.3892636063377038e-11,
1.4727565630768885e-12,
-7.873285726804993e-14,
3.77572791660211e-15,
-1.65587565234994e-16,
// [23.,23.5]: m=9 maxabs=1.348304398461435e-22 maxrel=1.953595715558267e-14
6.228479910166303e-9,
-1.271625792411125e-9,
1.4335581636806947e-10,
-1.1782056728021128e-11,
7.873287456730144e-13,
-4.526826801396419e-14,
2.317654833128032e-15,
-1.0773545524984748e-16,
// [23.,23.5]: m=10 maxabs=1.0878293594715495e-19 maxrel=3.8190183564235213e-11
2.5432515849351187e-9,
-5.734232662992064e-10,
7.069232896386357e-11,
-6.298577613579698e-12,
4.5278395635935145e-13,
-2.8259950534283586e-14,
1.276691096755919e-15,
1.0135402304563551e-15,
// [23.,23.5]: m=11 maxabs=7.175791813897515e-23 maxrel=5.5277071006961586e-14
1.1468465308028709e-9,
-2.8276936139286357e-10,
3.779179697401362e-11,
-3.6214644030397594e-12,
2.7784248310564725e-13,
-1.807525057953852e-14,
1.0329053813392889e-15,
-5.2876616314387445e-17,
// [23.,23.5]: m=12 maxabs=5.790264287871194e-23 maxrel=8.9515614651721e-14
5.65538722785695e-10,
-1.5116718785712746e-10,
2.1728786419668106e-11,
-2.2227414204677234e-12,
1.8075251933451526e-13,
-1.2380019955514347e-14,
7.401758151077084e-16,
-3.940081408019825e-17,
// [23.,23.5]: m=13 maxabs=4.611531914983129e-23 maxrel=1.3201649136058096e-13
3.0233437571424195e-10,
-8.691514564898146e-11,
1.333644852393056e-11,
-1.4460213417857105e-12,
1.2380018500688162e-13,
-8.870715995508893e-15,
5.516571532311602e-16,
-3.037943710870576e-17,
// [23.,23.5]: m=14 maxabs=3.7817663630158734e-23 maxrel=1.8647599618105942e-13
1.7383029129795036e-10,
-5.334579407216282e-11,
8.676128051956518e-12,
-9.904024223275853e-13,
8.870714376938038e-14,
-6.610840542276696e-15,
4.253633403858825e-16,
-2.411975226770376e-17,
// [23.,23.5]: m=15 maxabs=3.1329465700445923e-23 maxrel=2.4939384084543834e-13
1.0669158814431101e-10,
-3.4704512188648575e-11,
5.9424145349607e-12,
-7.096579169522429e-13,
6.610839141339074e-14,
-5.096997593626199e-15,
3.3772293729096286e-16,
-1.9637406591767003e-17,
// [23.,23.5]: m=16 maxabs=2.667657475483514e-23 maxrel=3.2363578779330163e-13
6.940902437729099e-11,
-2.3769658123885236e-11,
4.257947502687445e-12,
-5.2886776953242e-13,
5.096996295449742e-14,
-4.046548752208832e-15,
2.749652957068494e-16,
-1.6336535800299354e-17,
// [23.,23.5]: m=17 maxabs=2.297364904395323e-23 maxrel=4.0373978309862304e-13
4.7539316247760224e-11,
-1.7031789997229143e-11,
3.1732066181402098e-12,
-4.0776024446780315e-13,
4.046547506336951e-14,
-3.2943916801887543e-15,
2.287511272823616e-16,
-1.3844702278110468e-17,
// [23.,23.5]: m=18 maxabs=2.004620515733978e-23 maxrel=4.881668769978022e-13
3.4063579994450835e-11,
-1.2692826460918435e-11,
2.446561467653788e-12,
-3.237242662126419e-13,
3.294390564228568e-14,
-2.7405429183970816e-15,
1.9386131716534742e-16,
-1.1921340618989476e-17,
// [23.,23.5]: m=19 maxabs=1.773268438160553e-23 maxrel=5.757534361830369e-13
2.538565292173893e-11,
-9.786245860401658e-12,
1.94234559801222e-12,
-2.6355165166303563e-13,
2.7405419300798584e-14,
-2.3224331451502326e-15,
1.6693040880888236e-16,
-1.0407117556986129e-17,
// [23.,23.5]: m=20 maxabs=1.5813366866541084e-23 maxrel=6.621615791132065e-13
1.9572491720796206e-11,
-7.769382383070212e-12,
1.581309910648531e-12,
-2.1924371354209034e-13,
2.3224322539594704e-14,
-1.9997172351123778e-15,
1.4572814700632884e-16,
-9.193793971181176e-18,
// [23.,23.5]: m=21 maxabs=1.424624734666523e-23 maxrel=7.476468699098781e-13
1.553876476613393e-11,
-6.325239634578943e-12,
1.3154622818737592e-12,
-1.857949008781032e-13,
1.999716410622324e-14,
-1.7456604978184396e-15,
1.28739430242818e-16,
-8.205903434486867e-18,
// [23.,23.5]: m=22 maxabs=1.2937621768212198e-23 maxrel=8.303335528168088e-13
1.2650479269153241e-11,
-5.261849120248712e-12,
1.1147694058692014e-12,
-1.599776021028008e-13,
1.7456596436162523e-14,
-1.542099612164637e-15,
1.1491058499592218e-16,
-7.390899813664749e-18,
// [23.,23.5]: m=23 maxabs=1.182771340722796e-23 maxrel=9.090081981778524e-13
1.0523698240491982e-11,
-4.459077616924088e-12,
9.598656131345099e-13,
-1.3965303358072031e-13,
1.542098923039484e-14,
-1.376411001255301e-15,
1.0349463428233047e-16,
-6.709304869343444e-18,
// [23.,23.5]: m=24 maxabs=1.0884210521034663e-23 maxrel=9.83777830299753e-13
8.918155233843146e-12,
-3.839462446548547e-12,
8.379182019643132e-13,
-1.2336815341732e-13,
1.3764103618029944e-14,
-1.2396357246018516e-15,
9.395072305468071e-17,
-6.132988309987463e-18,
// [23.,23.5]: m=25 maxabs=1.0073185779820562e-23 maxrel=1.0542993175131211e-12
7.678924893092269e-12,
-3.351672802345613e-12,
7.402089209439881e-13,
-1.1011304932122441e-13,
1.2396351352472633e-14,
-1.1252932232271507e-15,
8.588072175644364e-17,
-5.64100322572037e-18,
// [23.,23.5]: m=26 maxabs=9.35424950523834e-24 maxrel=1.1186528985488093e-12
6.703345604692581e-12,
-2.960835678703402e-12,
6.60678296150814e-13,
-9.917101426590797e-14,
1.1252928470405185e-14,
-1.0286136327103887e-15,
7.898713087380754e-17,
-5.21621219572638e-18,
// [23.,23.5]: m=27 maxabs=8.732248458689677e-24 maxrel=1.179442093780128e-12
5.92167135740273e-12,
-2.642713179869622e-12,
5.950260859852546e-13,
-9.002361710672666e-14,
1.0286131128882981e-14,
-9.460278768558703e-16,
7.304361250501066e-17,
-4.847182792855717e-18,
// [23.,23.5]: m=28 maxabs=8.182948833166182e-24 maxrel=1.2358299380147486e-12
5.285426359735384e-12,
-2.3801043395231053e-12,
5.401417030086254e-13,
-8.228922574658284e-14,
9.460273861416055e-15,
-8.748268839982394e-16,
6.787625938246777e-17,
-4.523902898423349e-18,
// [23.,23.5]: m=29 maxabs=7.6966571058645e-24 maxrel=1.2883678274463033e-12
4.760208679042578e-12,
-2.160566807895124e-12,
4.93735354827186e-13,
-7.568235646600644e-14,
8.748264205170036e-15,
-8.129255916054036e-16,
6.334946999748747e-17,
-4.238735054458072e-18,
// [23.,23.5]: m=30 maxabs=7.260448579713489e-24 maxrel=1.3367523471906e-12
4.321133615786815e-12,
-1.9749414154164495e-12,
4.540941391248662e-13,
-6.99862693304117e-14,
8.12925153130746e-15,
-7.586990357847585e-16,
5.935632538342867e-17,
-3.9855974103545765e-18,
// [23.,23.5]: m=31 maxabs=6.86786090617758e-24 maxrel=1.3813972207680244e-12
3.949882830829646e-12,
-1.8163765528279625e-12,
4.1991761629348874e-13,
-6.503415911041217e-14,
7.58698621432905e-15,
-7.108660566801919e-16,
5.581161726232359e-17,
-3.75957894599847e-18,
// [23.,23.5]: m=32 maxabs=6.5124317367212e-24 maxrel=1.4224896797548819e-12
3.6327531056528255e-12,
-1.6796704617006906e-12,
3.9020495495924113e-13,
-6.069602864702318e-14,
7.108656610670298e-15,
-6.684056456777329e-16,
5.2646764106167685e-17,
-3.5567177135673265e-18,
// [23.,23.5]: m=33 maxabs=6.197392245612137e-24 maxrel=1.4622209640882524e-12
3.359340923398444e-12,
-1.5608198165422052e-12,
3.641761721631975e-13,
-5.686938467387322e-14,
6.684052708585271e-15,
-6.304960097504508e-16,
4.980604454751067e-17,
-3.3737388196586963e-18,
// [23.,23.5]: m=34 maxabs=5.905778767944517e-24 maxrel=1.4980185621020572e-12
3.121639633081602e-12,
-1.4567046855199832e-12,
3.4121630831190163e-13,
-5.347254697961116e-14,
6.30495651550735e-15,
-5.96469551862838e-16,
4.724380857210619e-17,
-3.207956086088792e-18,
// [23.,23.5]: m=35 maxabs=5.640822477986125e-24 maxrel=1.5316888485641062e-12
2.9134093710372865e-12,
-1.3648652302620894e-12,
3.2083528213424696e-13,
-5.0439771543764776e-14,
5.964692095184622e-15,
-5.657792775323949e-16,
4.492234788120802e-17,
-3.0571281710610174e-18,
// [23.,23.5]: m=36 maxabs=5.395253233634445e-24 maxrel=1.5623034395260718e-12
2.7297304605216136e-12,
-1.2833411256860667e-12,
3.026386295084109e-13,
-4.771765079883385e-14,
5.657789496986199e-15,
-5.379734120339044e-16,
4.281028814462763e-17,
-2.9193763998333196e-18,
// [23.,23.5]: m=37 maxabs=5.1710905188068424e-24 maxrel=1.591326726745112e-12
2.566682251369671e-12,
-1.210554515305929e-12,
2.8630590502898047e-13,
-4.5262425082717834e-14,
5.379730974206471e-15,
-5.126760374148176e-16,
4.0881337238400576e-17,
-2.793115795278336e-18,
// [23.,23.5]: m=38 maxabs=4.965103159235532e-24 maxrel=1.618704941790489e-12
2.4211090306094856e-12,
-1.145223617501675e-12,
2.7157455072367456e-13,
-4.3037952363752916e-14,
5.126757342524673e-15,
-4.895721711301889e-16,
3.911332338509837e-17,
-2.67700656827737e-18,
// [23.,23.5]: m=39 maxabs=4.774059980652728e-24 maxrel=1.6441858073110547e-12
2.290447235001065e-12,
-1.0862982003850375e-12,
2.5822771440140337e-13,
-4.1014159126464894e-14,
4.895718792774654e-15,
-4.683961702874779e-16,
3.74874323650236e-17,
-2.5699013181492143e-18,
// [23.,23.5]: m=40 maxabs=4.595133705574119e-24 maxrel=1.6674553540330447e-12
2.17259640076788e-12,
-1.0329108551927107e-12,
2.460849549693167e-13,
-3.91658468581234e-14,
4.683958894525399e-15,
-4.489226343216853e-16,
3.5987607993579064e-17,
-2.4708140129020798e-18
},
{
// [23.5,24.]: m=0 maxabs=5.551115123125783e-17 maxrel=3.0364716074295377e-16
0.1818499281088923,
-0.001914209769054175,
0.000030224364648880245,
-5.30251993450084e-7,
9.767781696288116e-9,
-1.850463040725396e-10,
3.611350971023521e-12,
-1.3606345887686736e-13,
// [23.5,24.]: m=1 maxabs=1.3010426069826053e-18 maxrel=3.3448632561976907e-16
0.0038284195381142866,
-0.00012089745858808311,
3.1815119406959757e-6,
-7.814237731242478e-8,
1.8507367289181907e-9,
-4.285874938447866e-11,
9.800821022224352e-13,
-2.267724314614456e-14,
// [23.5,24.]: m=2 maxabs=5.421010862427522e-20 maxrel=2.1834524149976012e-16
0.00024179491717619275,
-0.000012726047762181532,
4.6885426367761595e-7,
-1.480590287148096e-8,
4.2858924128249855e-10,
-1.1729427539673854e-11,
3.0877812615888044e-13,
-8.1496342556457e-15,
// [23.5,24.]: m=3 maxabs=1.3552527156068805e-20 maxrel=5.131113432511694e-16
0.00002545209552436403,
-1.8754170547037113e-6,
8.883541713460414e-8,
-3.428714140644568e-9,
1.1729544964027822e-10,
-3.703776411879377e-12,
1.1048927542891124e-13,
-3.2139012808439737e-15,
// [23.5,24.]: m=4 maxabs=8.470329472543003e-22 maxrel=2.1532358260207206e-16
3.7508341094075636e-6,
-3.5534166853664547e-7,
2.0572284826811374e-8,
-9.383636620104489e-10,
3.703800986303536e-11,
-1.325301095459901e-12,
4.41760904253733e-14,
-1.402794551307221e-15,
// [23.5,24.]: m=5 maxabs=1.0587911840678754e-22 maxrel=1.4055869686177866e-16
7.106833370732654e-7,
-8.228913930651568e-8,
5.630181969254769e-9,
-2.963041065384802e-10,
1.325305069772327e-11,
-5.29855267755183e-13,
1.95100555467082e-14,
-6.755317372445788e-16,
// [23.5,24.]: m=6 maxabs=3.970466940254533e-22 maxrel=2.2521505829562756e-15
1.6457827861302306e-7,
-2.2520727876656005e-8,
1.7778246385046125e-9,
-1.0602441983133443e-10,
5.298562458228875e-12,
-2.339862552412607e-13,
9.425653066021698e-15,
-3.532722156450952e-16,
// [23.5,24.]: m=7 maxabs=1.6543612251060553e-22 maxrel=3.392754876389878e-15
4.50414557533141e-8,
-7.111298553817589e-9,
6.361465188344496e-10,
-4.2388507553770135e-11,
2.339864585153858e-12,
-1.1303275867433891e-13,
4.939329766069831e-15,
-1.9940902750876037e-16,
// [23.5,24.]: m=8 maxabs=1.4889251025954498e-22 maxrel=9.568382985183202e-15
1.4222597107634482e-8,
-2.544586075186445e-9,
2.543310452029876e-10,
-1.8718921892284543e-11,
1.1303294546232588e-12,
-5.922524401830624e-14,
2.785656715378406e-15,
-1.199525157071026e-16,
// [23.5,24.]: m=9 maxabs=9.595295105615121e-23 maxrel=1.705199380964819e-14
5.089172150373042e-9,
-1.0173241807369734e-9,
1.1231353133912664e-10,
-9.042638635125242e-12,
5.922526299024816e-13,
-3.3399096750473236e-14,
1.6787347409363188e-15,
-7.675317375723557e-17,
// [23.5,24.]: m=10 maxabs=6.824240053562478e-23 maxrel=3.0017069131261196e-14
2.034648361474262e-9,
-4.4925412530414914e-10,
5.4255831790321974e-11,
-4.738023101680661e-12,
3.339912827392921e-13,
-2.0125289138793486e-14,
1.0735284843724785e-15,
-5.169559550623049e-17,
// [23.5,24.]: m=11 maxabs=5.0664812518872945e-23 maxrel=4.994195602694608e-14
8.985082506082947e-10,
-2.17023327125553e-10,
2.842813860976833e-11,
-2.6719316899038192e-12,
2.0125289641973401e-13,
-1.2868643702921057e-14,
7.23720131795084e-16,
-3.650925612443314e-17,
// [23.5,24.]: m=12 maxabs=3.908428394313056e-23 maxrel=7.893894820670054e-14
4.3404665425108934e-10,
-1.1371255441278447e-10,
1.6031590139807277e-11,
-1.6100242216743317e-12,
1.2868643267060595e-13,
-8.67456579185309e-15,
5.111421309201763e-16,
-2.685572044711529e-17,
// [23.5,24.]: m=13 maxabs=3.070908024103115e-23 maxrel=1.1719339745019054e-13
2.274251088255598e-10,
-6.412636053923729e-11,
9.66014533080651e-12,
-1.0294922609349888e-12,
8.67456480938507e-14,
-6.126030147539254e-15,
3.7601103736823985e-16,
-2.0467183532605322e-17,
// [23.5,24.]: m=14 maxabs=2.4970514741444523e-23 maxrel=1.6735375955545148e-13
1.2825272107846786e-10,
-3.864058130751376e-11,
6.176953566320252e-12,
-6.939658132013316e-13,
6.12602919628898e-14,
-4.506100675566854e-15,
2.8657116152801626e-16,
-1.608211578661082e-17,
// [23.5,24.]: m=15 maxabs=2.0563193040185422e-23 maxrel=2.2661611575333518e-13
7.728116261499987e-11,
-2.4707814252656724e-11,
4.163794880543169e-12,
-4.900828418207504e-13,
4.5060991563581925e-14,
-3.4339904444358125e-15,
2.25194785765739e-16,
-1.297614933219747e-17,
// [23.5,24.]: m=16 maxabs=1.724154589290217e-23 maxrel=2.945981754325803e-13
4.9415628505310515e-11,
-1.665517951171109e-11,
2.9404970515530855e-12,
-3.604883509686456e-13,
3.433989602414651e-14,
-2.6983206981813694e-15,
1.8169299995221653e-16,
-1.0710461653330164e-17,
// [23.5,24.]: m=17 maxabs=1.4818165192063222e-23 maxrel=3.726135887375019e-13
3.331035902341907e-11,
-1.1761988197443179e-11,
2.1629301059573814e-12,
-2.74719520100334e-13,
2.6983204025120205e-14,
-2.1769360249775835e-15,
1.4995821237119913e-16,
-9.012997679546203e-18,
// [23.5,24.]: m=18 maxabs=1.288915415419542e-23 maxrel=4.55603016065644e-13
2.3523976394881605e-11,
-8.651720416295702e-12,
1.6483171211308816e-12,
-2.1586593355294667e-13,
2.1769353247150208e-14,
-1.7966057615886055e-15,
1.262042726924919e-16,
-7.71369527203154e-18,
// [23.5,24.]: m=19 maxabs=1.1341421679926278e-23 maxrel=5.414389518648477e-13
1.7303440832541738e-11,
-6.593268477941952e-12,
1.2951956017800166e-12,
-1.7415508762305322e-13,
1.7966051406326487e-14,
-1.5119394982046644e-15,
1.0801157654728569e-16,
-6.698003121132339e-18,
// [23.5,24.]: m=20 maxabs=1.0087726064025595e-23 maxrel=6.282403054605834e-13
1.3186536955879426e-11,
-5.180782401368756e-12,
1.0449305261628531e-12,
-1.4372864130918185e-13,
1.511938933335877e-14,
-1.2939303682745108e-15,
9.379010180919099e-17,
-5.8893988083372514e-18,
// [23.5,24.]: m=21 maxabs=9.044056775530955e-24 maxrel=7.130859126834536e-13
1.0361564802733296e-11,
-4.179722099538664e-12,
8.623718482452512e-13,
-1.2095531916475524e-13,
1.2939298508469632e-14,
-1.1235180884441822e-15,
8.246811024249554e-17,
-5.234971883366678e-18,
// [23.5,24.]: m=22 maxabs=8.192642355969538e-24 maxrel=7.97004346950682e-13
8.35944419907357e-12,
-3.449487388381394e-12,
7.257319153673748e-13,
-1.0351457174997321e-13,
1.1235175765358397e-14,
-9.878550807097689e-16,
7.330597720417521e-17,
-4.697766606362371e-18,
// [23.5,24.]: m=23 maxabs=7.468859319985639e-24 maxrel=8.768745552990734e-13
6.8989747767593634e-12,
-2.902927657318437e-12,
6.210874308261654e-13,
-8.988157216828892e-14,
9.878546459527372e-15,
-8.780776876788348e-16,
6.578263824613543e-17,
-4.2507588368050656e-18,
// [23.5,24.]: m=24 maxabs=6.854128415539492e-24 maxrel=9.528482329533623e-13
5.805855314633711e-12,
-2.484349719521068e-12,
5.392894333109888e-13,
-7.902852302263714e-14,
8.780772868145904e-15,
-7.879387329350384e-16,
5.952343652120974e-17,
-3.87445695299898e-18,
// [23.5,24.]: m=25 maxabs=6.322600248488816e-24 maxrel=1.0238833922167733e-12
4.968699439039217e-12,
-2.1571577297730292e-12,
4.741711384143974e-13,
-7.024632178499376e-14,
7.879383620015511e-15,
-7.129483761508125e-16,
5.425425678566742e-17,
-3.554287613303761e-18,
// [23.5,24.]: m=26 maxabs=5.814498094879583e-24 maxrel=1.0814907650440533e-12
4.314315459542683e-12,
-1.896684550455583e-12,
4.2147793098169284e-13,
-6.30351970739343e-14,
7.129480204095767e-15,
-6.498212036916512e-16,
4.97713256944852e-17,
-3.279593884271341e-18,
// [23.5,24.]: m=27 maxabs=5.463915686824882e-24 maxrel=1.1531060929760749e-12
3.7933691009078e-12,
-1.6859117209198565e-12,
3.782111825920878e-13,
-5.703596094428711e-14,
6.498210209968849e-15,
-5.961138634266166e-16,
4.592021984683661e-17,
-3.0409734822638196e-18,
// [23.5,24.]: m=28 maxabs=5.1101021045023956e-24 maxrel=1.2107271611206176e-12
3.3718234418373042e-12,
-1.512844727601991e-12,
3.422157658952668e-13,
-5.19857923366177e-14,
5.961135575892255e-15,
-5.499803209373128e-16,
4.2583414327218407e-17,
-2.832863972457371e-18,
// [23.5,24.]: m=29 maxabs=4.79990937479501e-24 maxrel=1.2649912067001673e-12
3.0256894552017256e-12,
-1.3688630609933358e-12,
3.119147542350501e-13,
-4.768918811657495e-14,
5.499800341964542e-15,
-5.100072878744795e-16,
3.9669264259938624e-17,
-2.649805219197331e-18,
// [23.5,24.]: m=30 maxabs=4.521220594198531e-24 maxrel=1.314719764372667e-12
2.7377261219845434e-12,
-1.2476590145107607e-12,
2.8613512890288087e-13,
-4.399849991301772e-14,
5.1000701693843e-15,
-4.750982719546982e-16,
3.7105936983397314e-17,
-2.487729675518911e-18,
// [23.5,24.]: m=31 maxabs=4.284940975866734e-24 maxrel=1.3650667040263976e-12
2.4953180290201495e-12,
-1.1445405133222963e-12,
2.639909996769442e-13,
-4.0800652922166114e-14,
4.750980059933583e-15,
-4.443922875862215e-16,
3.483665588121455e-17,
-2.3437178551331702e-18,
// [23.5,24.]: m=32 maxabs=4.048661357534936e-24 maxrel=1.4041731695634486e-12
2.2890810266442674e-12,
-1.055963996519375e-12,
2.448039175409192e-13,
-3.8007927743793636e-14,
4.443922357245646e-15,
-4.1720666912779893e-16,
3.2814967890666054e-17,
-2.214082367987817e-18,
// [23.5,24.]: m=33 maxabs=3.844289585097518e-24 maxrel=1.4434497936995603e-12
2.1119279930369317e-12,
-9.792156681151208e-13,
2.280475666370491e-13,
-3.555146079993224e-14,
4.172064367246083e-15,
-3.9299297262495277e-16,
3.100459005392949e-17,
-2.0977131030987888e-18,
// [23.5,24.]: m=34 maxabs=3.659708755050285e-24 maxrel=1.4802949804581866e-12
1.95843133622851e-12,
-9.121902646024067e-13,
2.1330876496544962e-13,
-3.337659276943369e-14,
3.9299275162007575e-15,
-3.713078997873737e-16,
2.9375051573478133e-17,
-1.992478607777009e-18,
// [23.5,24.]: m=35 maxabs=3.491283796341978e-24 maxrel=1.5145014207128512e-12
1.8243805292031533e-12,
-8.532350580093073e-13,
2.0025955677527283e-13,
-3.1439494228249695e-14,
3.713076883359191e-15,
-3.5178927624651676e-16,
2.790146462894228e-17,
-1.89690907395975e-18,
// [23.5,24.]: m=36 maxabs=3.3386108121891244e-24 maxrel=1.5470194763874488e-12
1.7064701160170356e-12,
-8.010382253337249e-13,
1.8863696552079837e-13,
-2.9704685761553555e-14,
3.5178907453926432e-15,
-3.341389101335684e-16,
2.656317988552868e-17,
-1.8097666817001584e-18,
// [23.5,24.]: m=37 maxabs=3.2206729514149622e-24 maxrel=1.5883814731832462e-12
1.6020764506664896e-12,
-7.545478603984122e-13,
1.7822811470684223e-13,
-2.8143193452602318e-14,
3.3413871956939733e-15,
-3.181099323922637e-16,
2.5342896161251566e-17,
-1.7290206274917184e-18,
// [23.5,24.]: m=38 maxabs=3.0679999672621085e-24 maxrel=1.605176034039909e-12
1.5090957207859997e-12,
-7.129124572419074e-13,
1.6885916139215257e-13,
-2.6731161999400197e-14,
3.181092144800006e-15,
-3.0349402656322708e-16,
2.4226241577834368e-17,
-1.6567898241253528e-18,
// [23.5,24.]: m=39 maxabs=2.9466289838284245e-24 maxrel=1.630656357316612e-12
1.4258249144824121e-12,
-6.754366440165182e-13,
1.6038697213076456e-13,
-2.5448799242047507e-14,
3.034938474448068e-15,
-2.901188983542107e-16,
2.320078810621324e-17,
-1.589329627013771e-18,
// [23.5,24.]: m=40 maxabs=2.8353554199815695e-24 maxrel=1.6551545293672296e-12
1.3508732880316873e-12,
-6.415478870318408e-13,
1.5269279558142806e-13,
-2.42795674442269e-14,
2.9011872618378095e-15,
-2.7783683154960225e-16,
2.225612358845214e-17,
-1.5269992382396578e-18
},
{
// [24.,24.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.5343022384720602e-16
0.17996542203872173,
-0.0018553136289585436,
0.000028690416868475694,
-4.929624804438865e-7,
8.893639524410212e-9,
-1.6499820380365118e-10,
3.1521367973140938e-12,
-1.5874070202301192e-13,
// [24.,24.5]: m=1 maxabs=8.673617379884035e-19 maxrel=2.3014533581882584e-16
0.0037106272579242932,
-0.00011476166746775233,
2.957774858972908e-6,
-7.1149210884952e-8,
1.6503665656843322e-9,
-3.742976422550303e-11,
8.365776729382391e-13,
-2.1259915449510525e-14,
// [24.,24.5]: m=2 maxabs=5.421010862427522e-20 maxrel=2.301453365872762e-16
0.00022952333493550623,
-0.00001183109943584243,
4.2689526469412944e-7,
-1.3202933716673534e-8,
3.743083808653177e-10,
-1.0032734034804254e-11,
2.586623046357114e-13,
-6.732306559011666e-15,
// [24.,24.5]: m=3 maxabs=6.776263578034403e-21 maxrel=2.7617441275726524e-16
0.00002366219887168597,
-1.707581058773392e-6,
7.921760220937936e-8,
-2.994467180910789e-9,
1.0032850178857324e-10,
-3.102773412088857e-12,
9.065291616688909e-14,
-2.5633700138342116e-15,
// [24.,24.5]: m=4 maxabs=8.470329472543003e-22 maxrel=2.367209772517695e-16
3.415162117546841e-6,
-3.1687040883654446e-7,
1.7966803076519386e-8,
-8.026280584108427e-10,
3.102785365168354e-11,
-1.0874136409217134e-12,
3.550395499250167e-14,
-1.1034809630287933e-15,
// [24.,24.5]: m=5 maxabs=1.2705494208814505e-21 maxrel=1.8937700380174454e-15
6.337408176730545e-7,
-7.186721230546e-8,
4.815768348599331e-9,
-2.4822285131122936e-10,
1.0874163122252019e-11,
-4.2584892676403766e-13,
1.5360583035450588e-14,
-5.031236501235075e-16,
// [24.,24.5]: m=6 maxabs=2.117582368135751e-22 maxrel=1.3772943457201954e-15
1.437344246108448e-7,
-1.9263073393440483e-8,
1.489337116081532e-9,
-8.699331917856642e-11,
4.258402756430031e-12,
-1.8422644441517575e-13,
7.271882019326163e-15,
-2.6713305219762573e-16,
// [24.,24.5]: m=7 maxabs=1.3896634290890865e-22 maxrel=3.3373531798102146e-15
3.852614678688211e-8,
-5.957348464183422e-9,
5.219599149827269e-10,
-3.4067227799919635e-11,
1.8422657219858592e-12,
-8.720725366048974e-14,
3.735604973346795e-15,
-1.4773742412767412e-16,
// [24.,24.5]: m=8 maxabs=1.257314531080602e-22 maxrel=9.663016108596925e-15
1.1914696928367332e-8,
-2.087839659843662e-9,
2.0440336675652184e-10,
-1.473812922882043e-11,
8.72073090620238e-13,
-4.479436275949897e-14,
2.0665961668597964e-15,
-8.727456542612684e-17,
// [24.,24.5]: m=9 maxabs=6.534726839168919e-23 maxrel=1.4182821903085263e-14
4.175679319687715e-9,
-8.176134669759694e-10,
8.842877535839478e-11,
-6.97658672250696e-12,
4.479435122701663e-13,
-2.4779191836123373e-14,
1.2226853299321022e-15,
-5.489195482650421e-17,
// [24.,24.5]: m=10 maxabs=4.694249976238432e-23 maxrel=2.574994962638943e-14
1.6352269339520788e-9,
-3.537151013979262e-10,
4.185952033329211e-11,
-3.583549523172917e-12,
2.4779194034169524e-13,
-1.4658557994015476e-14,
7.684191927647511e-16,
-3.641058428581173e-17,
// [24.,24.5]: m=11 maxabs=3.484498330379629e-23 maxrel=4.3732151690659515e-14
7.07430202795844e-10,
-1.6743808130836263e-10,
2.1501297138581364e-11,
-1.9823365140993002e-12,
1.4658558724233542e-13,
-9.211522155838983e-15,
5.097221814925151e-16,
-2.53357686316389e-17,
// [24.,24.5]: m=12 maxabs=2.6211285660274064e-23 maxrel=6.879515843663029e-14
3.3487616261671043e-10,
-8.600518853634612e-11,
1.1894019084756222e-11,
-1.1726854167967601e-12,
9.211522020540082e-14,
-6.109768447211167e-15,
3.5470355922021713e-16,
-1.838806313850297e-17,
// [24.,24.5]: m=13 maxabs=2.042102137240287e-23 maxrel=1.0331726937083989e-13
1.720103770726727e-10,
-4.7576076325457516e-11,
7.036112501299914e-12,
-7.369223036626495e-13,
6.109767892089675e-14,
-4.25124600920842e-15,
2.574492676459788e-16,
-1.3846138426446567e-17,
// [24.,24.5]: m=14 maxabs=1.6478988765704848e-23 maxrel=1.4927483538650125e-13
9.515215265091016e-11,
-2.8144449994676953e-11,
4.421533822403243e-12,
-4.88781852087027e-13,
4.251245444517006e-14,
-3.085353533504374e-15,
1.9386395846389572e-16,
-1.076454425408996e-17,
// [24.,24.5]: m=15 maxabs=1.3506308439342405e-23 maxrel=2.0492154266254376e-13
5.628889998934753e-11,
-1.7686135281205553e-11,
2.9326911129749187e-12,
-3.400999717186166e-13,
3.085352941274683e-14,
-2.323140880172253e-15,
1.5072236868498551e-16,
-8.60333108671676e-18,
// [24.,24.5]: m=16 maxabs=1.1134626526788021e-23 maxrel=2.665050769534951e-13
3.537227056240666e-11,
-1.173076444502024e-11,
2.0405998307433e-12,
-2.468285105327331e-13,
2.323140328680732e-14,
-1.8060268507837732e-15,
1.2046396271330667e-16,
-7.042850320402508e-18,
// [24.,24.5]: m=17 maxabs=9.615974620928947e-24 maxrel=3.441974601343152e-13
2.3461528890032997e-11,
-8.162399317096936e-12,
1.4809710632637643e-12,
-1.858514580071092e-13,
1.806026830596187e-14,
-1.4433551739678547e-15,
9.86005737201998e-17,
-5.883197498702147e-18,
// [24.,24.5]: m=18 maxabs=8.300886693940344e-24 maxrel=4.2384941253590665e-13
1.6324798634190072e-11,
-5.923884248170371e-12,
1.115108748389954e-12,
-1.444823418851633e-13,
1.4433547185303036e-14,
-1.18133076787457e-15,
8.23792287643602e-17,
-5.002714489681001e-18,
// [24.,24.5]: m=19 maxabs=1.2105594394257493e-23 maxrel=8.459586077334162e-13
1.1847768496333547e-11,
-4.46043498931895e-12,
8.66894051736906e-13,
-1.154685465685651e-13,
1.1813302957845292e-14,
-9.869303467926383e-16,
7.005118954843624e-17,
-4.315116234116516e-18,
// [24.,24.5]: m=20 maxabs=6.4364991414282466e-24 maxrel=5.937555514030905e-13
8.920869978578373e-12,
-3.4675762034015835e-12,
6.928112794268862e-13,
-9.450656490350242e-14,
9.869293854815708e-15,
-8.392394324047282e-16,
6.049074479506608e-17,
-3.779762902071352e-18,
// [24.,24.5]: m=21 maxabs=5.767646067996697e-24 maxrel=6.807126925727586e-13
6.935152406800571e-12,
-2.7712451144394808e-12,
5.670393896666317e-13,
-7.895448153900181e-14,
8.392391058620676e-15,
-7.246343437476703e-16,
5.2927110194293594e-17,
-3.3453359503369897e-18,
// [24.,24.5]: m=22 maxabs=5.1916892547639735e-24 maxrel=7.630498304508598e-13
5.542490228876758e-12,
-2.2681575557434988e-12,
4.73726889439857e-13,
-6.713924534468855e-14,
7.246340739109244e-15,
-6.340036788486241e-16,
4.6843314584780013e-17,
-2.9904568325425986e-18,
// [24.,24.5]: m=23 maxabs=4.720745605234271e-24 maxrel=8.441753621573136e-13
4.5363151114848626e-12,
-1.894907555125228e-12,
4.02835472272243e-13,
-5.797083126684635e-14,
6.340034066090851e-15,
-5.611084502159908e-16,
4.18751067598478e-17,
-2.696736118040782e-18,
// [24.,24.5]: m=24 maxabs=4.318464408895006e-24 maxrel=9.209483664482277e-13
3.789815110248484e-12,
-1.6113418866951718e-12,
3.478249877899107e-13,
-5.0720368266971754e-14,
5.6110819852909746e-15,
-5.015822619708797e-16,
3.776235626718664e-17,
-2.450602337054329e-18,
// [24.,24.5]: m=25 maxabs=3.976767730076714e-24 maxrel=9.941040610930135e-13
3.2226837733885055e-12,
-1.3912999489695978e-12,
3.0432220977693084e-13,
-4.488874347321735e-14,
5.015820287875547e-15,
-4.523074616700368e-16,
3.431588950319918e-17,
-2.2420658107159614e-18,
// [24.,24.5]: m=26 maxabs=3.6657672068023824e-24 maxrel=1.0582807023939302e-12
2.7825998979372666e-12,
-1.2172888370904417e-12,
2.6933246100239044e-13,
-4.0126642939643855e-14,
4.523072452495445e-15,
-4.110166852482098e-16,
3.139582505895392e-17,
-2.063797298551238e-18,
// [24.,24.5]: m=27 maxabs=3.422217446368068e-24 maxrel=1.1263871946202891e-12
2.4345776741825664e-12,
-1.0773298421370264e-12,
2.4075985767784237e-13,
-3.618465435082017e-14,
4.1101658639029385e-15,
-3.760333399071063e-16,
2.889693751405537e-17,
-1.9095153015763238e-18,
// [24.,24.5]: m=28 maxabs=3.197246937973519e-24 maxrel=1.1864449029364077e-12
2.1546596842725746e-12,
-9.630394289772366e-13,
2.1710792624625913e-13,
-3.288139626865256e-14,
3.7603315145543376e-15,
-3.4609745997160747e-16,
2.6739245088087923e-17,
-1.7753704010548684e-18,
// [24.,24.5]: m=29 maxabs=2.9957024430204132e-24 maxrel=1.2411740336109295e-12
1.926078857953084e-12,
-8.684317033658679e-13,
1.9728837774490557e-13,
-3.0082716876805145e-14,
3.460972826248603e-15,
-3.2024927465726484e-16,
2.486086140367136e-17,
-1.6577204165674023e-18,
// [24.,24.5]: m=30 maxabs=2.81879565185917e-24 maxrel=1.292886126558955e-12
1.7368634067304278e-12,
-7.891535094620053e-13,
1.8049630138623147e-13,
-2.7687843310465407e-14,
3.202491072784992e-15,
-2.9774763399094256e-16,
2.3213444823419755e-17,
-1.5538349502892745e-18,
// [24.,24.5]: m=31 maxabs=2.660064215954219e-24 maxrel=1.3406034257846153e-12
1.5783070189227604e-12,
-7.219852041174394e-13,
1.661270599822231e-13,
-2.561998567741592e-14,
2.9774747484406324e-15,
-2.780132465286957e-16,
2.1758780337702225e-17,
-1.4615379998932234e-18,
// [24.,24.5]: m=32 maxabs=2.518094496563404e-24 maxrel=1.3852320381811123e-12
1.443970408233698e-12,
-6.645082385819285e-13,
1.5371991417730271e-13,
-2.381985186121947e-14,
2.7801309617572933e-15,
-2.605881998632806e-16,
2.0466341791941648e-17,
-1.3790663896991533e-18,
// [24.,24.5]: m=33 maxabs=2.38904947424373e-24 maxrel=1.4261814943888009e-12
1.3290164771627416e-12,
-6.148796554346354e-13,
1.429191112743771e-13,
-2.2241098673236694e-14,
2.605880569172072e-15,
-2.45106718994458e-16,
1.9311507591106112e-17,
-1.3049913963106619e-18,
// [24.,24.5]: m=34 maxabs=2.271919407036514e-24 maxrel=1.4641242892183634e-12
1.2297593108682071e-12,
-5.716764438882672e-13,
1.3344659214142414e-13,
-2.0847092920203328e-14,
2.4510658286179794e-15,
-2.3127378240985314e-16,
1.8274238482947506e-17,
-1.2381364142837323e-18,
// [24.,24.5]: m=35 maxabs=2.1656945529830734e-24 maxrel=1.4996644193870696e-12
1.1433528877755126e-12,
-5.337863674156346e-13,
1.2508255761906996e-13,
-1.9608572628635363e-14,
2.3127365189462404e-15,
-2.188492784186327e-16,
1.7338086864797574e-17,
-1.177532406488549e-18,
// [24.,24.5]: m=36 maxabs=2.067547634599096e-24 maxrel=1.5319627533466973e-12
1.0675727348302924e-12,
-5.003302293800613e-13,
1.1765143586532708e-13,
-1.8501935997215544e-14,
2.1884915367552083e-15,
-2.0763614180972988e-16,
1.6489446699659848e-17,
-1.1223690645061577e-18,
// [24.,24.5]: m=37 maxabs=1.979700084193684e-24 maxrel=1.5636935900651495e-12
1.000660458759191e-12,
-4.706057424143683e-13,
1.1101161607261957e-13,
-1.750797416952401e-14,
2.0763602261211986e-15,
-1.9747136616858895e-16,
1.571698274459526e-17,
-1.071965603865654e-18,
// [24.,24.5]: m=38 maxabs=1.8979109855403697e-24 maxrel=1.592604569595246e-12
9.412114848278417e-13,
-4.4404646328863774e-13,
1.0504784510292418e-13,
-1.6610921879623757e-14,
1.974712517028311e-15,
-1.882191284036306e-16,
1.501118323935504e-17,
-1.025749644215714e-18,
// [24.,24.5]: m=39 maxabs=1.8217764418556794e-24 maxrel=1.6190643936784744e-12
8.880929265764165e-13,
-4.2019137945144827e-13,
9.966553136018355e-14,
-1.5797738544943258e-14,
1.882190183549384e-15,
-1.7976548177060337e-16,
1.436401889540029e-17,
-9.832347695068405e-19,
// [24.,24.5]: m=40 maxabs=1.752306195098296e-24 maxrel=1.644723861427654e-12
8.403827589020734e-13,
-3.9866212451877617e-13,
9.478643134869905e-14,
-1.50575583448621e-14,
1.7976537620188264e-15,
-1.7201422066585606e-16,
1.376866846188086e-17,
-9.440036981280506e-19
},
{
// [24.5,25.]: m=0 maxabs=5.551115123125783e-17 maxrel=3.1004043363949757e-16
0.17813831459582904,
-0.0017993769149250787,
0.000027263286547579982,
-4.5897788923746184e-7,
8.113220626795702e-9,
-1.4744318295314202e-10,
2.789300906975781e-12,
-2.0409518831530103e-13,
// [24.5,25.]: m=1 maxabs=0. maxrel=0.
0.0035987538298585886,
-0.00010905314617921945,
2.7538672827518084e-6,
-6.490595554251675e-8,
1.4751342372067014e-9,
-3.277948990710151e-11,
7.178764783451387e-13,
-1.8070928132083947e-14,
// [24.5,25.]: m=2 maxabs=2.710505431213761e-20 maxrel=1.211600069691628e-16
0.00021810629235844917,
-0.000011015469130906425,
3.8943573232547665e-7,
-1.1801075305292543e-8,
3.278066923724205e-10,
-8.608883032082096e-12,
2.1746568201596976e-13,
-5.5142905697167924e-15,
// [24.5,25.]: m=3 maxabs=0. maxrel=0.
0.000022030938261813933,
-1.5577429292951532e-6,
7.080645175488585e-8,
-2.62245367261077e-9,
8.608970823525757e-11,
-2.6086703468587948e-12,
7.467891328910258e-14,
-2.0817000544312387e-15,
// [24.5,25.]: m=4 maxabs=1.6940658945086007e-21 maxrel=5.194736149505314e-16
3.115485858590327e-6,
-2.832258070185988e-7,
1.5734722025223317e-8,
-6.887177015539577e-10,
2.6086851254672162e-11,
-8.958156167318022e-13,
2.865979511856399e-14,
-8.740648832269463e-16,
// [24.5,25.]: m=5 maxabs=2.117582368135751e-22 maxrel=3.535309304248437e-16
5.664516140371812e-7,
-6.293888810036087e-8,
4.132306207465709e-9,
-2.0869482855220166e-10,
8.958182278860192e-12,
-3.437548761659589e-13,
1.2151482882973507e-14,
-4.044193714455636e-16,
// [24.5,25.]: m=6 maxabs=2.6469779601696886e-23 maxrel=1.968531339993777e-16
1.258777762007176e-7,
-1.652922482966212e-8,
1.2521689707786036e-9,
-7.166546616103922e-11,
3.4375558765074048e-12,
-1.4574172671811911e-13,
5.638871200155946e-15,
-2.032477675318399e-16,
// [24.5,25.]: m=7 maxabs=9.26442286059391e-23 maxrel=2.5969811314341503e-15
3.305844965932572e-8,
-5.008675882999421e-9,
4.2999279685700354e-10,
-2.7500451457381853e-11,
1.457418802846159e-12,
-6.762458780557738e-14,
2.840341864844512e-15,
-1.1020968539500492e-16,
// [24.5,25.]: m=8 maxabs=6.948317145445432e-23 maxrel=6.362876040778998e-15
1.0017351765999106e-8,
-1.7199711873643293e-9,
1.6500270871406207e-10,
-1.1659352944302552e-11,
6.762462912229782e-13,
-3.4060022394503455e-14,
1.5416008223706354e-15,
-6.398665984245165e-17,
// [24.5,25.]: m=9 maxabs=4.714929491552258e-23 maxrel=1.2446572144085789e-14
3.4399423747288832e-9,
-6.600108348175342e-10,
6.995611765639521e-11,
-5.409971876138067e-12,
3.406003462182815e-13,
-1.8484379186977296e-14,
8.95424295033182e-16,
-3.9509285519230694e-17,
// [24.5,25.]: m=10 maxabs=3.226004388956808e-23 maxrel=2.1969500139469613e-14
1.3200216696352028e-9,
-2.7982447060029694e-10,
3.245983125357644e-11,
-2.7248037788377966e-12,
1.8484383323559702e-13,
-1.073541670537385e-14,
5.530004482413822e-16,
-2.577970742612136e-17,
// [24.5,25.]: m=11 maxabs=2.3781442610899546e-23 maxrel=3.7817499062607806e-14
5.596489412005873e-10,
-1.2983932499701965e-10,
1.634882267214049e-11,
-1.478751357132802e-12,
1.0735417936263854e-13,
-6.6293746028294585e-15,
3.608760086097153e-16,
-1.766884849971583e-17,
// [24.5,25.]: m=12 maxabs=1.7939479534743788e-23 maxrel=6.087244893703241e-14
2.5967864999402477e-10,
-6.539529067619174e-11,
8.872508142719345e-12,
-8.58833929409187e-13,
6.629374687176773e-14,
-4.325767356971775e-15,
2.473613234967765e-16,
-1.2648158396026556e-17,
// [24.5,25.]: m=13 maxabs=1.370017889540952e-23 maxrel=9.139976016249744e-14
1.3079058135237156e-10,
-3.549003256167599e-11,
5.1530035766888225e-12,
-5.303503426423058e-13,
4.325767036544378e-14,
-2.9648075981368204e-15,
1.770846560195941e-16,
-9.406623762651126e-18,
// [24.5,25.]: m=14 maxabs=1.0934293722185335e-23 maxrel=1.3313920417208047e-13
7.098006512334886e-11,
-2.061201429968716e-11,
3.182102056126505e-12,
-3.460616455711221e-13,
2.9648072405682246e-14,
-2.122303118707176e-15,
1.3170405554515535e-16,
-7.232527499909975e-18,
// [24.5,25.]: m=15 maxabs=8.982664464443035e-24 maxrel=1.8660100190814147e-13
4.122402859937186e-11,
-1.2728408218912507e-11,
2.076369873699718e-12,
-2.3718480287717545e-13,
2.1223027526906488e-14,
-1.5783021154854104e-15,
1.0126707086383109e-16,
-5.7235315954534596e-18,
// [24.5,25.]: m=16 maxabs=7.386464376157114e-24 maxrel=2.4631743750226015e-13
2.5456816437821977e-11,
-8.305479490303562e-12,
1.4231088176404922e-12,
-1.6978440111891642e-13,
1.578301601819832e-14,
-1.213464772188287e-15,
8.014580096348932e-17,
-4.644588198259032e-18,
// [24.5,25.]: m=17 maxabs=6.213548116951063e-24 maxrel=3.1495407715843064e-13
1.6610958980606278e-11,
-5.692435266798778e-12,
1.0187064069398793e-12,
-1.2626427863861618e-13,
1.2134644693538716e-14,
-9.6030512039853e-16,
6.503394923672895e-17,
-3.851514879326578e-18,
// [24.5,25.]: m=18 maxabs=5.3653648716574315e-24 maxrel=3.9380443802087366e-13
1.1384870533596339e-11,
-4.0748256245960085e-12,
7.575856719176022e-13,
-9.707728424698571e-14,
9.603050439092762e-15,
-7.791893982878622e-16,
5.3922326341491826e-17,
-3.2526991027014667e-18,
// [24.5,25.]: m=19 maxabs=4.681971514020848e-24 maxrel=4.767524989771735e-13
8.14965124918976e-12,
-3.030342684952679e-12,
5.824637057904748e-13,
-7.682451254980685e-14,
7.791890181433246e-15,
-6.460207298277871e-16,
4.5549272004546846e-17,
-2.792347561517665e-18,
// [24.5,25.]: m=20 maxabs=4.121362778560105e-24 maxrel=5.608011302473795e-13
6.060685369855738e-12,
-2.329854820773293e-12,
4.609470754702425e-13,
-6.233521641277863e-14,
6.46020499400971e-15,
-5.456797290402347e-16,
3.910025417124201e-17,
-2.430596579534181e-18,
// [24.5,25.]: m=21 maxabs=3.672229555337953e-24 maxrel=6.463004711354386e-13
4.659709641544963e-12,
-1.843788299789022e-12,
3.7401129863030874e-13,
-5.1681723615955304e-14,
5.4567952464195725e-15,
-4.683999597085765e-16,
3.403488837039331e-17,
-2.1414205881216935e-18,
// [24.5,25.]: m=22 maxabs=3.2796418818020433e-24 maxrel=7.257635901724543e-13
3.6875765995766e-12,
-1.496045192659601e-12,
3.100903418391627e-13,
-4.3654436451555744e-14,
4.6839976874943995e-15,
-4.0770365591173963e-16,
2.998598245920851e-17,
-1.906616935115855e-18,
// [24.5,25.]: m=23 maxabs=2.990451784835262e-24 maxrel=8.12026281619455e-13
2.9920903853162204e-12,
-1.2403613656755461e-12,
2.6192661888421176e-13,
-3.747204862458113e-14,
4.077034654764737e-15,
-3.591885395947558e-16,
2.6698130887003262e-17,
-1.7132464256043373e-18,
// [24.5,25.]: m=24 maxabs=2.7303422562785484e-24 maxrel=8.90785246100315e-13
2.480722731349852e-12,
-1.04770647402086e-12,
2.2483229186589582e-13,
-3.2616337869935707e-14,
3.5918838184881824e-15,
-3.1979555123599974e-16,
2.3990496772472244e-17,
-1.5519668354614578e-18,
// [24.5,25.]: m=25 maxabs=2.506987335017892e-24 maxrel=9.650413092751803e-13
2.0954129480405807e-12,
-8.993291660805316e-13,
1.956980273285085e-13,
-2.8735125863929205e-14,
3.197954060077886e-15,
-2.873549680890851e-16,
2.173218502870014e-17,
-1.4159049805088438e-18,
// [24.5,25.]: m=26 maxabs=2.315136362868142e-24 maxrel=1.0351405152315278e-12
1.7986583321600025e-12,
-7.827921080442999e-13,
1.7241075528481094e-13,
-2.5583683265268016e-14,
2.8735483311605633e-15,
-2.602987221305688e-16,
1.982699029953362e-17,
-1.2999280824331482e-18,
// [24.5,25.]: m=27 maxabs=2.1333828103052208e-24 maxrel=1.0930193969322312e-12
1.565584216087632e-12,
-6.896430199666182e-13,
1.5350209968441404e-13,
-2.2988433551289246e-14,
2.6029859644026146e-15,
-2.3747370362248464e-16,
1.8203033558749303e-17,
-1.2003441312196008e-18,
// [24.5,25.]: m=28 maxabs=2.0031260976351273e-24 maxrel=1.1622220018733254e-12
1.379286039932995e-12,
-6.140083976575273e-13,
1.379306013025522e-13,
-2.0823931172042036e-14,
2.3747368792183092e-15,
-2.180188185380285e-16,
1.680582696887859e-17,
-1.1135668809944515e-18,
// [24.5,25.]: m=29 maxabs=1.873273281748507e-24 maxrel=1.2182849761590297e-12
1.2280167953141832e-12,
-5.517224041964957e-13,
1.249435871155356e-13,
-1.899793557903218e-14,
2.1801870753363314e-15,
-2.0128070986541529e-16,
1.5593488590072126e-17,
-1.0378638458283532e-18,
// [24.5,25.]: m=30 maxabs=1.7597782855925496e-24 maxrel=1.2713866224336723e-12
1.1034448083921717e-12,
-4.997743475135304e-13,
1.1398761355245625e-13,
-1.7441534544207914e-14,
2.012806055264502e-15,
-1.8675764598766093e-16,
1.453343370322174e-17,
-9.712033972214902e-19,
// [24.5,25.]: m=31 maxabs=1.658400192940787e-24 maxrel=1.3205700836018643e-12
9.995486950262823e-13,
-4.559504533189127e-13,
1.0464920733948658e-13,
-1.6102484075802177e-14,
1.8675754708746415e-15,
-1.7405914105553153e-16,
1.3600011204156847e-17,
-9.12129586998571e-19,
// [24.5,25.]: m=32 maxabs=1.510573970189611e-24 maxrel=1.3165939784234092e-12
9.119009066374583e-13,
-4.185968285182342e-13,
9.661490452416472e-14,
-1.494063736078746e-14,
1.7405904528798902e-15,
-1.6287766616323319e-16,
1.2772888885508606e-17,
-8.5982435180362345e-19,
// [24.5,25.]: m=33 maxabs=1.4855323696142753e-24 maxrel=1.4085123916070662e-12
8.371936570362188e-13,
-3.864596173064861e-13,
8.964382412777988e-14,
-1.3924755528358844e-14,
1.6287773036189149e-15,
-1.529691172814195e-16,
1.2035431871129738e-17,
-8.122765229706649e-19,
// [24.5,25.]: m=34 maxabs=1.4114173098469508e-24 maxrel=1.4478702069911422e-12
7.729192346123136e-13,
-3.5857529575923875e-13,
8.354853323332484e-14,
-1.3030248501400831e-14,
1.5296903299443218e-15,
-1.4413650555215343e-16,
1.1374569833422927e-17,
-7.697692382001485e-19,
// [24.5,25.]: m=35 maxabs=1.3443704437904066e-24 maxrel=1.4848076483550783e-12
7.171505915178493e-13,
-3.3419413221901137e-13,
7.81814910686382e-14,
-1.2237551208917857e-14,
1.4413642518259523e-15,
-1.3622058687579179e-16,
1.0779342365154814e-17,
-7.313074730733189e-19,
// [24.5,25.]: m=36 maxabs=1.2823722875272768e-24 maxrel=1.5182502626364675e-12
6.683882644374191e-13,
-3.1272596359440363e-13,
7.342530731132596e-14,
-1.1530941218573473e-14,
1.3622050972834802e-15,
-1.2909096347138026e-16,
1.0240774735465065e-17,
-6.96361251894456e-19,
// [24.5,25.]: m=37 maxabs=1.2264325830162444e-24 maxrel=1.5503938343635561e-12
6.254519271882338e-13,
-2.9370122859627944e-13,
6.918564736649053e-14,
-1.0897666737134474e-14,
1.2909088999747702e-15,
-1.2264010566067536e-16,
9.751409974291615e-18,
-6.644827683004879e-19,
// [24.5,25.]: m=38 maxabs=1.1616071492688025e-24 maxrel=1.5623675213815456e-12
5.874024571919643e-13,
-2.7674258884539177e-13,
6.538600048275945e-14,
-1.0327296044288981e-14,
1.226400294417358e-15,
-1.1677844370972516e-16,
9.30513253005286e-18,
-6.358097136731331e-19,
// [24.5,25.]: m=39 maxabs=1.1270739742818475e-24 maxrel=1.607691525815404e-12
5.534851776903565e-13,
-2.615440013075969e-13,
6.196377616199637e-14,
-9.811226600872945e-15,
1.1677860590572817e-15,
-1.114319196509405e-16,
8.896318382175152e-18,
-6.084856055901004e-19,
// [24.5,25.]: m=40 maxabs=1.0833521474708782e-24 maxrel=1.6340811236975668e-12
5.230880026146831e-13,
-2.4785510407780773e-13,
5.886735965411079e-14,
-9.342311278253347e-15,
1.1143185446473944e-15,
-1.0653689534710574e-16,
8.520885319437802e-18,
-5.837792837463121e-19
},
{
// [25.,25.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.565940664773411e-16
0.17636574995798082,
-0.0017461955440267218,
0.000025933597162125894,
-4.279471497091794e-7,
7.414925239243412e-9,
-1.3208643736011224e-10,
2.398118462704787e-12,
-2.0409518831530103e-13,
// [25.,25.5]: m=1 maxabs=0. maxrel=0.
0.0034923910880626566,
-0.00010373438864724292,
2.5676828605654403e-6,
-5.931940175062243e-8,
1.3214709787824092e-9,
-2.8782714385574564e-11,
6.182206246755581e-13,
-1.7362264283766928e-14,
// [25.,25.5]: m=2 maxabs=1.3552527156068805e-19 maxrel=6.371828885665187e-16
0.00020746877729449433,
-0.000010270731442143693,
3.559164093441323e-7,
-1.0571770083761869e-8,
2.878446403786101e-10,
-7.409715840221561e-12,
1.835051816599027e-13,
-4.62846075932052e-15,
// [25.,25.5]: m=3 maxabs=2.0328790734103208e-20 maxrel=9.557743453312734e-16
0.000020541462884288057,
-1.4236656373670168e-6,
6.343062043761811e-8,
-2.302757338311909e-9,
7.409806447462128e-11,
-2.2008581780339597e-12,
6.176171531172257e-14,
-1.702454166855335e-15,
// [25.,25.5]: m=4 maxabs=0. maxrel=0.
2.847331274734068e-6,
-2.537224817491729e-7,
1.3816544016281097e-8,
-5.927845555319846e-10,
2.2008768143057704e-11,
-7.408306298138496e-13,
2.3232789927625504e-14,
-6.962068666083199e-16,
// [25.,25.5]: m=5 maxabs=1.0587911840678754e-22 maxrel=1.9753946134741042e-16
5.074449634983306e-7,
-5.526617606474854e-8,
3.5567073310856693e-9,
-1.7607015844995355e-10,
7.40833427363225e-12,
-2.7867269939435734e-13,
9.657231816259083e-15,
-3.159228972233579e-16,
// [25.,25.5]: m=6 maxabs=7.940933880509066e-23 maxrel=6.734315681551426e-16
1.1053235212949471e-7,
-1.4226829324178232e-8,
1.0564209499819216e-9,
-5.926668040327184e-11,
2.7867361991475315e-12,
-1.1582817207463692e-13,
4.3941083842495584e-15,
-1.5534461738467823e-16,
// [25.,25.5]: m=7 maxabs=7.279189390466644e-23 maxrel=2.3742994752226237e-15
2.8453658648358075e-8,
-4.225683799839392e-9,
3.5560008232094864e-10,
-2.229389298001931e-11,
1.1582829886119118e-12,
-5.269766851461966e-14,
2.170820999741706e-15,
-8.265726404625369e-17,
// [25.,25.5]: m=8 maxabs=4.7976475528075605e-23 maxrel=5.2164215317064065e-15
8.451367599679082e-9,
-1.4224003292374344e-9,
1.3376335785225613e-10,
-9.26626575139969e-12,
5.269770383753278e-13,
-2.603218365527664e-14,
1.1560970451391497e-15,
-4.712053378330144e-17,
// [25.,25.5]: m=9 maxabs=3.3914405114674135e-23 maxrel=1.0846464589304875e-14
2.844800658475058e-9,
-5.350534313808408e-10,
5.559759450065277e-11,
-4.2158174291281485e-12,
2.603219486356961e-13,
-1.3862422658991656e-14,
6.593097659538261e-16,
-2.858847565427604e-17,
// [25.,25.5]: m=10 maxabs=2.2540671692070004e-23 maxrel=1.8975306203333595e-14
1.0701068627617902e-9,
-2.2239037798454544e-10,
2.5294904571676982e-11,
-2.082576309149621e-12,
1.3862426670967073e-13,
-7.90482423910809e-15,
4.001116022717768e-16,
-1.8347724266121358e-17,
// [25.,25.5]: m=11 maxabs=1.540623890880014e-23 maxrel=3.0896631069314273e-14
4.447807559690819e-10,
-1.0117961827455186e-10,
1.249545785394725e-11,
-1.1089946191281731e-12,
7.904825502469831e-14,
-4.7966847391434655e-15,
2.568287934852556e-16,
-1.239818410623139e-17,
// [25.,25.5]: m=12 maxabs=1.1761474334738362e-23 maxrel=5.1338675257921996e-14
2.0235923654912575e-10,
-4.9981831407639015e-11,
6.653967710506422e-12,
-6.323863725662669e-13,
4.7966913740695794e-14,
-3.078695460058946e-15,
1.7336322080380544e-16,
-8.743735706398938e-18,
// [25.,25.5]: m=13 maxabs=9.29285719415042e-24 maxrel=8.132358579451889e-14
9.996366281526176e-11,
-2.6615870836186158e-11,
3.7943182361957835e-12,
-3.837355532317653e-13,
3.078695919151218e-14,
-2.0779743787498895e-15,
1.2237756305170572e-16,
-6.418284192912851e-18,
// [25.,25.5]: m=14 maxabs=7.32830323933698e-24 maxrel=1.1929884716581785e-13
5.3231741672370417e-11,
-1.5177272940014635e-11,
2.3024133195566527e-12,
-2.462958641902352e-13,
2.0779741557047013e-14,
-1.4667009201617683e-15,
8.986315416250329e-17,
-4.8787437365286346e-18,
// [25.,25.5]: m=15 maxabs=5.854887773226899e-24 maxrel=1.6562368011692956e-13
3.035454588002819e-11,
-9.209653274491175e-12,
1.4777751853031974e-12,
-1.6623808180625375e-13,
1.4667007044672702e-14,
-1.0769244264018103e-15,
6.830934225511827e-17,
-3.821896959873088e-18,
// [25.,25.5]: m=16 maxabs=4.849992575945682e-24 maxrel=2.2412599716829554e-13
1.8419306548979093e-11,
-5.911100738208535e-12,
9.974284910069401e-13,
-1.1733617646255647e-13,
1.0769242025192537e-14,
-8.185593945783519e-16,
5.351366690048264e-17,
-3.073352159295389e-18,
// [25.,25.5]: m=17 maxabs=4.068048403141648e-24 maxrel=2.904843314748394e-13
1.182220147641627e-11,
-3.989713961557667e-12,
7.040170589287284e-13,
-8.615403497944212e-14,
8.185591917166245e-15,
-6.412158984784675e-16,
4.30333763977819e-17,
-2.5279999084579898e-18,
// [25.,25.5]: m=18 maxabs=3.481590273538622e-24 maxrel=3.6550992468000453e-13
7.979427923114312e-12,
-2.8160682336432715e-12,
5.169242100132755e-13,
-6.548481818802457e-14,
6.412157170892532e-15,
-5.156052493847699e-16,
3.5397787201399794e-17,
-2.1205258178218003e-18,
// [25.,25.5]: m=19 maxabs=3.0098388304419737e-24 maxrel=4.445217093437571e-13
5.632136467285596e-12,
-2.067696838286068e-12,
3.9290890924925645e-13,
-5.1297328046151854e-14,
5.156050881357045e-15,
-4.2409499329445944e-16,
2.96925216175961e-17,
-1.8090994271193694e-18,
// [25.,25.5]: m=20 maxabs=2.6431005510483462e-24 maxrel=5.282408197187589e-13
4.1353936765361914e-12,
-1.5716356354549852e-12,
3.077839683859282e-13,
-4.1248468243102425e-14,
4.240948470881156e-15,
-3.5572288208412896e-16,
2.5332056821784937e-17,
-1.566213479755134e-18,
// [25.,25.5]: m=21 maxabs=2.3426013441443167e-24 maxrel=6.124151712708398e-13
3.1432712709089256e-12,
-1.2311358722023225e-12,
2.474908095577922e-13,
-3.392764141732516e-14,
3.5572275035538634e-15,
-3.0346967034791486e-16,
2.1931193377423072e-17,
-1.3733069464753617e-18,
// [25.,25.5]: m=22 maxabs=2.0897619576901197e-24 maxrel=6.938350497621735e-13
2.462271744403685e-12,
-9.899632370419491e-13,
2.0356584859457615e-13,
-2.8457867593030305e-14,
3.0346955028870244e-15,
-2.6271773334982025e-16,
1.923012695205155e-17,
-1.2175066318316993e-18,
// [25.,25.5]: m=23 maxabs=1.8946798112725844e-24 maxrel=7.787577894753791e-13
1.979926474082874e-12,
-8.142633933143044e-13,
1.7074720565500898e-13,
-2.4277606563371674e-14,
2.627175966046027e-15,
-2.303529862269916e-16,
1.7049687563327077e-17,
-1.0900237172038953e-18,
// [25.,25.5]: m=24 maxabs=1.725043162213858e-24 maxrel=8.585655741220847e-13
1.6285267866278108e-12,
-6.829888216586975e-13,
1.4566563945596217e-13,
-2.1017446176502908e-14,
2.3035288554790306e-15,
-2.0422717715803825e-16,
1.5263547534739406e-17,
-9.841473770949569e-19,
// [25.,25.5]: m=25 maxabs=1.579236423380048e-24 maxrel=9.337565068554983e-13
1.365977643316656e-12,
-5.826625569494516e-13,
1.2610467712926658e-13,
-1.8428265816823166e-14,
2.0422708374404692e-15,
-1.8282684784974558e-16,
1.3781047527592364e-17,
-8.95225969283915e-19,
// [25.,25.5]: m=26 maxabs=1.4558459560289982e-24 maxrel=1.0058778135316769e-12
1.165325113898225e-12,
-5.044187077163498e-13,
1.105695949653344e-13,
-1.6338198724186493e-14,
1.828267621744492e-15,
-1.650651553672015e-16,
1.2535901681486816e-17,
-8.197356173904766e-19,
// [25.,25.5]: m=27 maxabs=1.3478035664499284e-24 maxrel=1.0727331092997634e-12
1.008837415431875e-12,
-4.4227837912357384e-13,
9.802919240768857e-14,
-1.462617046679932e-14,
1.6506507343711692e-15,
-1.5014770561845044e-16,
1.1478899311094948e-17,
-7.549540085243263e-19,
// [25.,25.5]: m=28 maxabs=1.2538975642924191e-24 maxrel=1.1354647713309687e-12
8.845567582471789e-13,
-3.921167689390168e-13,
8.775702287543604e-14,
-1.3205233319770735e-14,
1.5014759905432373e-15,
-1.374841917046361e-16,
1.0572787802719621e-17,
-6.990740773618246e-19,
// [25.,25.5]: m=29 maxabs=1.1715026204638949e-24 maxrel=1.1940134086787796e-12
7.842335378774811e-13,
-3.510280908665787e-13,
7.923139997121402e-14,
-1.2011833329052929e-14,
1.3748412176196196e-15,
-1.2662958151921801e-16,
9.789271742416412e-18,
-6.503003084855275e-19,
// [25.,25.5]: m=30 maxabs=1.0983973026552533e-24 maxrel=1.2481865117636895e-12
7.02056181732637e-13,
-3.1692559929152776e-13,
7.20710000238813e-14,
-1.0998753472319121e-14,
1.2662951554940223e-15,
-1.1724344999716725e-16,
9.10631333166871e-18,
-6.074776287765398e-19,
// [25.,25.5]: m=31 maxabs=1.0336728431036797e-24 maxrel=1.298854107358559e-12
6.338511985825673e-13,
-2.882839995391605e-13,
6.599252088040929e-14,
-1.0130383496944397e-14,
1.1724338808786535e-15,
-1.0906214196933122e-16,
8.506666477418325e-18,
-5.696280086780799e-19,
// [25.,25.5]: m=32 maxabs=9.758146288711498e-25 maxrel=1.3459650827755805e-12
5.765679990778583e-13,
-2.639700829981575e-13,
6.078230102568872e-14,
-9.379491984782646e-15,
1.0906208338333438e-15,
-1.0187900325017763e-16,
7.976664856283415e-18,
-5.359708395299816e-19,
// [25.,25.5]: m=33 maxabs=9.236109696072442e-25 maxrel=1.3894498676323865e-12
5.279401659958774e-13,
-2.431292036086783e-13,
5.627695195038447e-14,
-8.724986432723182e-15,
1.0187894774604639e-15,
-9.553026989567815e-17,
7.50536670587919e-18,
-5.058742589640127e-19,
// [25.,25.5]: m=34 maxabs=8.765569943326212e-25 maxrel=1.4299899851215759e-12
4.862584072169407e-13,
-2.2510780733387349e-13,
5.234991863603272e-14,
-8.150334525076481e-15,
9.55302170497011e-16,
-8.988483612594113e-17,
7.083928881776622e-18,
-4.788238836578169e-19,
// [25.,25.5]: m=35 maxabs=8.338449094803348e-25 maxrel=1.4676358084679202e-12
4.5021561466735186e-13,
-2.0939967410033755e-13,
4.890200718815052e-14,
-7.642435114843229e-15,
8.988478589854436e-16,
-8.483674396261442e-17,
6.705141313783404e-18,
-4.543959145533438e-19,
// [25.,25.5]: m=36 maxabs=7.94868869875175e-25 maxrel=1.5025265886221742e-12
4.1879934820029674e-13,
-1.9560802833043022e-13,
4.585461072509015e-14,
-7.190799757576673e-15,
8.483669600278908e-16,
-8.02996005250074e-17,
6.3630760744191185e-18,
-4.3223997699621533e-19,
// [25.,25.5]: m=37 maxabs=7.593259529295371e-25 maxrel=1.5351935771423438e-12
3.9121605666050087e-13,
-1.8341844249791328e-13,
4.3144798579784916e-14,
-6.786951777330615e-15,
8.029955478480076e-16,
-7.620238568742101e-17,
6.052823216060664e-18,
-4.1206295086705183e-19,
// [25.,25.5]: m=38 maxabs=7.269132360558162e-25 maxrel=1.5660836892193733e-12
3.668368849954815e-13,
-1.7257919393468965e-13,
4.072171069694475e-14,
-6.4239797597210595e-15,
7.620234178308227e-16,
-7.248626658923791e-17,
5.770285306360969e-18,
-3.936193181598657e-19,
// [25.,25.5]: m=39 maxabs=6.856147899456858e-25 maxrel=1.5687425628563813e-12
3.4515838786906093e-13,
-1.6288684241967188e-13,
3.854387858874999e-14,
-6.096202066703219e-15,
7.248622586653741e-16,
-6.910207855139729e-17,
5.5119874941665766e-18,
-3.7688272033873187e-19,
// [25.,25.5]: m=40 maxabs=6.691559960191546e-25 maxrel=1.6211118957984886e-12
3.25773684839408e-13,
-1.5417551400736028e-13,
3.657721238156774e-14,
-5.798912056791451e-15,
6.910211602594449e-16,
-6.600882563818208e-17,
5.275121986968905e-18,
-3.6113322700067643e-19
},
{
// [25.5,26.]: m=0 maxabs=1.1102230246251565e-16 maxrel=6.326090190820383e-16
0.1746450673491059,
-0.001695583178078006,
0.000024692958889711008,
-3.995624467184672e-7,
6.788669783855636e-9,
-1.185750524281e-10,
2.142999477310661e-12,
-1.8141794516915647e-13,
// [25.5,26.]: m=1 maxabs=0. maxrel=0.
0.0033911663561658353,
-0.00009877183555278761,
2.397374633427222e-6,
-5.4309455164017034e-8,
1.1863711477190363e-9,
-2.533887383169698e-11,
5.333581288395953e-13,
-1.3818945042181841e-14,
// [25.5,26.]: m=2 maxabs=5.421010862427522e-20 maxrel=2.6780860352441025e-16
0.0001975436711055773,
-9.589498533666312e-6,
3.2585673036780604e-7,
-9.490970093793666e-9,
2.533993433607311e-10,
-6.396312696037439e-12,
1.5530257507141138e-13,
-3.986234146783223e-15,
// [25.5,26.]: m=3 maxabs=5.082197683525802e-20 maxrel=2.5609197925159325e-15
0.00001917899706733381,
-1.3034269214673576e-6,
5.6945820452555014e-8,
-2.027194838637142e-9,
6.396454346625625e-11,
-1.8629980169806808e-12,
5.129577451279849e-14,
-1.4145594784765466e-15,
// [25.5,26.]: m=4 maxabs=4.235164736271502e-22 maxrel=1.5548442540228295e-16
2.606853842934674e-6,
-2.2778328180750582e-7,
1.2163169027608348e-8,
-5.117164365414632e-10,
1.8630124241504548e-11,
-6.149130581381509e-13,
1.890026899070397e-14,
-6.048556674112044e-16,
// [25.5,26.]: m=5 maxabs=0. maxrel=0.
4.5556656361577127e-7,
-4.865267611236015e-8,
3.070298589162654e-9,
-1.4904096709126876e-10,
6.149416291772749e-12,
-2.2683799281569894e-13,
7.709163168039723e-15,
-2.468904569209922e-16,
// [25.5,26.]: m=6 maxabs=2.6469779601696886e-23 maxrel=2.553129884507552e-16
9.730535222471236e-8,
-1.2281194356516758e-8,
8.942458021897477e-10,
-4.919533533020414e-11,
2.2683848759414447e-12,
-9.246395125796767e-14,
3.440438305628511e-15,
-1.1937940804168508e-16,
// [25.5,26.]: m=7 maxabs=3.3087224502121107e-23 maxrel=1.2520234414059956e-15
2.4562388713035094e-8,
-3.576983208692538e-9,
2.9517201189068144e-10,
-1.814708155998955e-11,
9.246407064413406e-13,
-4.126142991163918e-14,
1.6674817584091558e-15,
-6.232005193806535e-17,
// [25.5,26.]: m=8 maxabs=3.3087224502121107e-23 maxrel=4.256970159863447e-15
7.153966417385243e-9,
-1.1806880475279924e-9,
1.0888248933896135e-10,
-7.39712702606724e-12,
4.126146022070502e-13,
-1.9996641779782898e-14,
8.714460244964123e-16,
-3.4982545963845693e-17,
// [25.5,26.]: m=9 maxabs=2.2333876538931747e-23 maxrel=8.620914159365633e-15
2.3613760950559998e-9,
-4.355299573387688e-10,
4.43827621587131e-11,
-3.3009174912522106e-12,
1.999666017356951e-13,
-1.045050913161475e-14,
4.880427409254426e-16,
-2.079576582397345e-17,
// [25.5,26.]: m=10 maxabs=1.5923226791645783e-23 maxrel=1.6501035277378437e-14
8.710599146776145e-10,
-1.7753104862195342e-10,
1.9805504944951166e-11,
-1.5997333289684775e-12,
1.0450512495739427e-13,
-5.851580798682063e-15,
2.910341931208153e-16,
-1.3125888916064295e-17,
// [25.5,26.]: m=11 maxabs=1.1425432210888695e-23 maxrel=2.8766312444360137e-14
3.550620972439098e-10,
-7.92220197712705e-11,
9.598399973316157e-12,
-8.360413407145193e-13,
5.85158151187227e-14,
-3.48913811154551e-15,
1.8373852661915554e-16,
-8.722953795182442e-18,
// [25.5,26.]: m=12 maxabs=8.349354307957123e-24 maxrel=4.665599230295534e-14
1.5844403954254702e-10,
-3.83935998873341e-11,
5.0162480441524145e-12,
-4.681267581458327e-13,
3.489138304065946e-14,
-2.2025858144388534e-15,
1.2211501718401258e-16,
-6.069395186468845e-18,
// [25.5,26.]: m=13 maxabs=6.255553382432272e-24 maxrel=7.144451692985888e-14
7.678719977466401e-11,
-2.0064992172309204e-11,
2.8087605489291054e-12,
-2.791312362429482e-13,
2.2025857535873478e-14,
-1.4637303377478127e-15,
8.497326707647709e-17,
-4.398827314244039e-18,
// [25.5,26.]: m=14 maxabs=4.866148447284608e-24 maxrel=1.0535257149443365e-13
4.01299843446162e-11,
-1.1235042192482764e-11,
1.6747874175331504e-12,
-1.7620698950612146e-13,
1.4637302527240034e-14,
-1.0184395260959681e-15,
6.158613129871527e-17,
-3.3043766829940104e-18,
// [25.5,26.]: m=15 maxabs=5.62179086154887e-22 maxrel=2.1540033235681645e-11
2.247008438259465e-11,
-6.699149709303288e-12,
1.0572418710221855e-12,
-1.170980022348587e-13,
1.018492418190147e-14,
-7.409603918206473e-16,
4.505304315474615e-17,
2.835899287805588e-18,
// [25.5,26.]: m=16 maxabs=3.1988625251074117e-24 maxrel=2.0376095619372645e-13
1.3398299335255561e-11,
-4.22896774655618e-12,
7.025911219860995e-13,
-8.147523135906488e-14,
7.380727760211154e-15,
-5.5441948324647e-16,
3.586375496697056e-17,
-2.040476387955618e-18,
// [25.5,26.]: m=17 maxabs=2.6608720095211652e-24 maxrel=2.6627168142473503e-13
8.457935493112178e-12,
-2.8103644863183966e-12,
4.888513882496514e-13,
-5.904588711301326e-14,
5.5441935585512964e-15,
-4.2974082042100176e-16,
2.8570747208260356e-17,
-1.6645315612496381e-18,
// [25.5,26.]: m=18 maxabs=2.2602064003157924e-24 maxrel=3.377059148208073e-13
5.620728972636302e-12,
-1.9554055516447536e-12,
3.542753227630023e-13,
-4.4353602618402765e-14,
4.297407067307377e-15,
-3.423291684982441e-16,
2.3307084367911722e-17,
-1.3860428630386468e-18,
// [25.5,26.]: m=19 maxabs=1.9378967671042123e-24 maxrel=4.131612608765581e-13
3.9108111032885395e-12,
-1.4171012899043645e-12,
2.661216157891287e-13,
-3.437930243285689e-14,
3.423290644119332e-15,
-2.792444889689699e-16,
1.9407931900481178e-17,
-1.174674959695745e-18,
// [25.5,26.]: m=20 maxabs=1.6240689663455685e-24 maxrel=4.74649116474825e-13
2.8342025797827353e-12,
-1.0644864621384447e-12,
2.0627581503738421e-13,
-2.7386364076772747e-14,
2.792440707695539e-15,
-2.325208053219638e-16,
1.6456420526637018e-17,
-1.001037299920838e-18,
// [25.5,26.]: m=21 maxabs=1.5012843441697285e-24 maxrel=5.806444880516993e-13
2.1289729243287074e-12,
-8.251032580432934e-13,
1.643181872193316e-13,
-2.233957856025199e-14,
2.3251624890356314e-15,
-1.9708639060428998e-16,
1.4162197484524075e-17,
-8.82397323473745e-19,
// [25.5,26.]: m=22 maxabs=1.3385139404300458e-24 maxrel=6.643388352445169e-13
1.6502065160859757e-12,
-6.572727481165373e-13,
1.340374714193211e-13,
-1.8601330340912533e-14,
1.9708631386135076e-15,
-1.6965427305784785e-16,
1.2356012593733848e-17,
-7.788906941188343e-19,
// [25.5,26.]: m=23 maxabs=1.2052280018839036e-24 maxrel=7.473799521362678e-13
1.314545496232509e-12,
-5.361498849988099e-13,
1.1160798209977522e-13,
-1.5766932240806887e-14,
1.6965420167272447e-15,
-1.4801169591388343e-16,
1.0906738036741176e-17,
-6.945328192443544e-19,
// [25.5,26.]: m=24 maxabs=1.0929446960783657e-24 maxrel=8.273870310446507e-13
1.0722997699973196e-12,
-4.464319277840256e-13,
9.460159350200223e-14,
-1.357236061961716e-14,
1.4801161577068275e-15,
-1.306462611296337e-16,
9.72603765598182e-18,
-6.249350644932773e-19,
// [25.5,26.]: m=25 maxabs=9.97827003570437e-25 maxrel=9.038360629769526e-13
8.928638555675812e-13,
-3.7840637345449116e-13,
8.143416376233139e-14,
-1.1840951400752003e-14,
1.3064620187526338e-15,
-1.1649992615221732e-16,
8.75098228254475e-18,
-5.667180923114155e-19,
// [25.5,26.]: m=26 maxabs=9.17249595267542e-25 maxrel=9.7701852591798e-13
7.568127469085513e-13,
-3.257366545438618e-13,
7.104570844540283e-14,
-1.0451716366695216e-14,
1.1649987185450987e-15,
-1.0481771740014393e-16,
7.935786850780454e-18,
-5.17501797029165e-19,
// [25.5,26.]: m=27 maxabs=8.475774001184222e-25 maxrel=1.045777425896679e-12
6.514733090873216e-13,
-2.8418283331718047e-13,
6.271029823833942e-14,
-9.320008323655337e-15,
1.0481766675303183e-15,
-9.505113078208052e-17,
7.246641093409244e-18,
-4.754765558436571e-19,
// [25.5,26.]: m=28 maxabs=7.868919084015802e-25 maxrel=1.11005472398766e-12
5.683656666339851e-13,
-2.5084119252432927e-13,
5.592004997753266e-14,
-8.3854305003539e-15,
9.505108352156592e-16,
-8.679496348097566e-17,
6.65818059143217e-18,
-4.392639699497708e-19,
// [25.5,26.]: m=29 maxabs=7.338804555707282e-25 maxrel=1.1702617047803077e-12
5.016823850483099e-13,
-2.2368019951184714e-13,
5.0312583035312706e-14,
-7.604102612396807e-15,
8.679491936768159e-16,
-7.974523790875532e-17,
6.151104544103667e-18,
-4.0780087048219645e-19,
// [25.5,26.]: m=30 maxabs=6.872303770795784e-25 maxrel=1.2265139664150427e-12
4.4736039902336673e-13,
-2.0125033176986278e-13,
4.562461570549663e-14,
-6.943608404150747e-15,
7.974519657762226e-16,
-7.367065422083195e-17,
5.710532114155756e-18,
-3.802575616794363e-19,
// [25.5,26.]: m=31 maxabs=6.45931930969448e-25 maxrel=1.2790451980861247e-12
4.0250066353941654e-13,
-1.824984624743085e-13,
4.166165045425829e-14,
-6.3796296326116904e-15,
7.367061524428132e-16,
-6.839288917189157e-17,
5.324850159656364e-18,
-3.559794113581868e-19,
// [25.5,26.]: m=32 maxabs=6.084705043023126e-25 maxrel=1.3265941015160747e-12
3.649969249483251e-13,
-1.6664660149040302e-13,
3.827777782348643e-14,
-5.893662284411933e-15,
6.839285218164121e-16,
-6.377278235074077e-17,
4.98489356191642e-18,
-3.3444535375036417e-19,
// [25.5,26.]: m=33 maxabs=5.474820899978657e-25 maxrel=1.3053470059887363e-12
3.332932029807068e-13,
-1.5311111098596585e-13,
3.536197373240189e-14,
-5.471440497425278e-15,
6.377274631039284e-16,
-5.970043247089727e-17,
4.6833905309323894e-18,
-3.154065708767821e-19,
// [25.5,26.]: m=34 maxabs=5.455635802763682e-25 maxrel=1.41399917938189e-12
3.062222219718848e-13,
-1.4144789464009616e-13,
3.282864295912971e-14,
-5.101831430791354e-15,
5.970047378514377e-16,
-5.60884760341629e-17,
4.4143407769990536e-18,
-2.9800473970844375e-19,
// [25.5,26.]: m=35 maxabs=5.1840152158779835e-25 maxrel=1.4527578136055716e-12
2.8289578927994236e-13,
-1.3131457156063624e-13,
3.061098860851115e-14,
-4.776048937703222e-15,
5.608844445915567e-16,
-5.2866157843390035e-17,
4.173074899914667e-18,
-2.8247655082303e-19,
// [25.5,26.]: m=36 maxabs=4.936628436000674e-25 maxrel=1.488681681790402e-12
2.6262914312103443e-13,
-1.2244395417189268e-13,
2.8656293648912165e-14,
-4.487086042382952e-15,
5.286612767634989e-16,
-4.997623951798028e-17,
3.955635272759208e-18,
-2.6841899499364253e-19,
// [25.5,26.]: m=37 maxabs=4.710951108235047e-25 maxrel=1.522153248989208e-12
2.4488790834355857e-13,
-1.146251743459829e-13,
2.6922516275915113e-14,
-4.229300200450792e-15,
4.997621076870402e-16,
-4.737175671592431e-17,
3.7587845599502e-18,
-2.5563923003647904e-19,
// [25.5,26.]: m=38 maxabs=4.506983232581102e-25 maxrel=1.5542920451567535e-12
2.2925034869174813e-13,
-1.0769006486537692e-13,
2.5375801223424003e-14,
-3.998106392403665e-15,
4.737172917229841e-16,
-4.5013921173262625e-17,
3.57982911711449e-18,
-2.4397629975877e-19,
// [25.5,26.]: m=39 maxabs=4.268684130331939e-25 maxrel=1.565730346757268e-12
2.1538012973055632e-13,
-1.0150320466600111e-13,
2.3988638373311033e-14,
-3.789747440851875e-15,
4.501389585866549e-16,
-4.287052291635912e-17,
3.416490189009342e-18,
-2.3315733762664327e-19,
// [25.5,26.]: m=40 maxabs=4.14347612745526e-25 maxrel=1.6113285454216302e-12
2.0300640933149444e-13,
-9.595455327883578e-14,
2.2738484703180426e-14,
-3.601120310517228e-15,
4.2870436549421894e-16,
-4.091434526930513e-17,
3.2669326605389264e-18,
-2.2347835123602733e-19
},
{
// [26.,26.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.5969524013599642e-16
0.172973784239596,
-0.0016473693736676117,
0.00002353384818694789,
-3.735531452621381e-7,
6.225877302076193e-9,
-1.0671768891805967e-10,
1.8822111811299986e-12,
-6.803172943843368e-14,
// [26.,26.5]: m=1 maxabs=4.336808689942018e-19 maxrel=1.297523826143169e-16
0.0032947387473448975,
-0.00009413539274338196,
2.241318865384131e-6,
-4.980708448013588e-8,
1.0672943391405825e-9,
-2.236113477830465e-11,
4.617830801595765e-13,
-1.2047285421389297e-14,
// [26.,26.5]: m=2 maxabs=5.421010862427522e-20 maxrel=2.811301624742656e-16
0.00018827078548677424,
-8.965275461474746e-6,
2.988425059110738e-7,
-8.538355754320715e-9,
2.23623383649568e-10,
-5.537158819915804e-12,
1.3191113164063482e-13,
-3.4104447700256464e-15,
// [26.,26.5]: m=3 maxabs=2.40896170199123e-18 maxrel=1.2992430527596068e-13
0.000017930550922890925,
-1.19537002231522e-6,
5.123015072333643e-8,
-1.7889618180403657e-9,
5.5255589780315045e-11,
-1.8224835871231253e-12,
2.9543185436708974e-13,
5.482428378724101e-13,
// [26.,26.5]: m=4 maxabs=8.470329472543003e-22 maxrel=3.3936428271547925e-16
2.3907400472703407e-6,
-2.0492053758543047e-7,
1.0733923447491474e-8,
-4.429857381399727e-10,
1.5820720701876045e-11,
-5.122685236868833e-13,
1.5454269918718083e-14,
-4.453370960859382e-16,
// [26.,26.5]: m=5 maxabs=2.6469779601696886e-22 maxrel=6.127412053758969e-16
4.098410751708706e-7,
-4.293569378968342e-8,
2.657914427572224e-9,
-1.2656577481108858e-10,
5.1227025490456705e-12,
-1.8537274219782112e-13,
6.1804363172711374e-15,
-1.9459708578968882e-16,
// [26.,26.5]: m=6 maxabs=6.617444900424221e-23 maxrel=7.241494758470463e-16
8.587138757935959e-8,
-1.0631657710183598e-8,
7.593946484483588e-10,
-4.098162431055818e-11,
1.8537330131571212e-12,
-7.412947132076045e-14,
2.706171142692771e-15,
-9.218382731479757e-17,
// [26.,26.5]: m=7 maxabs=2.9778502051908996e-23 maxrel=1.3034746623631579e-15
2.1263315420368735e-8,
-3.0375785937425777e-9,
2.4588974577959045e-10,
-1.482986603358179e-11,
7.412958042579434e-13,
-3.2456050156771905e-14,
1.287109254703239e-15,
-4.723272231214496e-17,
// [26.,26.5]: m=8 maxabs=2.3161057151484775e-23 maxrel=3.514606304127088e-15
6.075157187484759e-9,
-9.835589830923439e-10,
8.897919618234364e-11,
-5.9303674602443335e-12,
3.2456077361222966e-13,
-1.543552636662674e-14,
6.603557043390758e-16,
-2.596353441314207e-17,
// [26.,26.5]: m=9 maxabs=6.617444900424222e-24 maxrel=3.0717287890848517e-15
1.9671179661849574e-9,
-3.55916784714219e-10,
3.558220475514127e-11,
-2.5964867935083667e-12,
1.5435535729574696e-13,
-7.91851144026537e-15,
3.6318147020555265e-16,
-1.526270868155228e-17,
// [26.,26.5]: m=10 maxabs=1.1063540692896745e-23 maxrel=1.4056934663682737e-14
7.118335694281697e-10,
-1.4232881900433738e-10,
1.55789207435695e-11,
-1.2348433280085913e-12,
7.91853859746081e-14,
-4.354311673704695e-15,
2.1280822812508145e-16,
-9.44005645112238e-18,
// [26.,26.5]: m=11 maxabs=7.909914607538327e-24 maxrel=2.4893536583449262e-14
2.846576380087026e-10,
-6.231568296822384e-11,
7.409059967406115e-12,
-6.33483329588541e-13,
4.354312573739385e-14,
-2.5513805617684e-15,
1.3213140207439446e-16,
-6.1753111262561685e-18,
// [26.,26.5]: m=12 maxabs=5.686866711302065e-24 maxrel=4.049179949779551e-14
1.2463136593645204e-10,
-2.963623986547987e-11,
3.800899977406775e-12,
-3.483451715398205e-13,
2.5513807266680607e-14,
-1.5839879392771136e-15,
8.644923420918189e-17,
-4.23465232761657e-18,
// [26.,26.5]: m=13 maxabs=4.265150033476549e-24 maxrel=6.325925674650941e-14
5.927247973095571e-11,
-1.520359990666685e-11,
2.0900710292418415e-12,
-2.041105764830649e-13,
1.5839879427255856e-14,
-1.0362549940548915e-15,
5.928492402832582e-17,
-3.0282349257219754e-18,
// [26.,26.5]: m=14 maxabs=3.2957977531409696e-24 maxrel=9.440836544467015e-14
3.040719981333256e-11,
-8.360284114769557e-12,
1.2246634589444705e-12,
-1.2671912326677777e-13,
1.036254934902872e-14,
-7.105760788365417e-16,
4.239715542494887e-17,
-2.247413747281868e-18,
// [26.,26.5]: m=15 maxabs=3.726190165609967e-23 maxrel=1.9236122240023465e-12
1.6720568227218107e-11,
-4.898653793226126e-12,
7.603146741668901e-13,
-8.290096752805006e-14,
7.106281924299181e-15,
-5.053026136817182e-16,
3.0274347482207406e-17,
-6.988886518677864e-18,
// [26.,26.5]: m=16 maxabs=2.0841074027214955e-24 maxrel=1.8202251167931468e-13
9.79730766818684e-12,
-3.041258957278799e-12,
4.974027728222281e-13,
-5.684613422722118e-14,
5.081195095004884e-15,
-3.7708011236058203e-16,
2.4126769660710918e-17,
-1.3597909162478904e-18,
// [26.,26.5]: m=17 maxabs=1.7472574853048817e-24 maxrel=2.437607784391947e-13
6.082517914558512e-12,
-1.9896110902259497e-12,
3.4107680531916026e-13,
-4.0649603456278244e-14,
3.7708019659239795e-15,
-2.891097830189594e-16,
1.9034347379605612e-17,
-1.0994052110106434e-18,
// [26.,26.5]: m=18 maxabs=1.4427193105661205e-24 maxrel=3.0525284931454855e-13
3.9792221804512985e-12,
-1.364307220389706e-12,
2.4389762079768706e-13,
-3.0166451225770723e-14,
2.8910970623064555e-15,
-2.280713990916292e-16,
1.5394092494498335e-17,
-9.08668740106374e-19,
// [26.,26.5]: m=19 maxabs=1.257330686951941e-24 maxrel=3.851291336250588e-13
2.7286144407782292e-12,
-9.755904824232375e-13,
1.8099870735604354e-13,
-2.312880666865513e-14,
2.280714068053166e-15,
-1.8444130506080679e-16,
1.2721130043376044e-17,
-7.650304766867325e-19,
// [26.,26.5]: m=20 maxabs=1.0933485928618388e-24 maxrel=4.652007733999917e-13
1.951180964847805e-12,
-7.239948287898618e-13,
1.387728399960545e-13,
-1.8245738034596503e-14,
1.844413023058448e-15,
-1.5240836653064342e-16,
1.0710831992822393e-17,
-6.545767437537975e-19,
// [26.,26.5]: m=21 maxabs=9.60870447882643e-25 maxrel=5.475520228745135e-13
1.4479896575631227e-12,
-5.550913594259528e-13,
1.0947442824736788e-13,
-1.4755326376859533e-14,
1.5240831333559105e-15,
-1.2831694125350263e-16,
9.165773981249855e-18,
-5.681049060481934e-19,
// [26.,26.5]: m=22 maxabs=8.540397486539927e-25 maxrel=6.312788580194355e-13
1.1101827188515532e-12,
-4.378977125020907e-13,
8.853195829736554e-14,
-1.2192684563987413e-14,
1.283168930460504e-15,
-1.0980210958269488e-16,
7.955010102155847e-18,
-4.991504810722142e-19,
// [26.,26.5]: m=23 maxabs=7.686155789494198e-25 maxrel=7.166557066224678e-13
8.757954250038191e-13,
-3.5412783275658866e-13,
7.315610741588411e-14,
-1.0265368756898671e-14,
1.0980206661343448e-15,
-9.52939139919979e-17,
6.989488557538313e-18,
-4.432309502313273e-19,
// [26.,26.5]: m=24 maxabs=6.921781126771246e-25 maxrel=7.945784296247465e-13
7.082556655127692e-13,
-2.926244292792394e-13,
6.159221258923359e-14,
-8.78418078840184e-15,
9.52938461386193e-16,
-8.37250401330514e-17,
6.2074011793818416e-18,
-3.974052949114703e-19,
// [26.,26.5]: m=25 maxabs=6.304828790015997e-25 maxrel=8.724990869687219e-13
5.852488585581895e-13,
-2.4636885000612573e-13,
5.2705084757969685e-14,
-7.623521723259425e-15,
8.37250034636461e-16,
-7.435410579194937e-17,
5.564846279240783e-18,
-3.592212225293163e-19,
// [26.,26.5]: m=26 maxabs=5.77572400366616e-25 maxrel=9.46112519139396e-13
4.927377000119852e-13,
-2.108203387124605e-13,
4.574113036492019e-14,
-6.698013053825439e-15,
7.435407203747742e-16,
-6.665549947205807e-17,
5.0301762685209195e-18,
-3.270808860620268e-19,
// [26.,26.5]: m=27 maxabs=5.324369348134906e-25 maxrel=1.0161841845359687e-12
4.2164067742467377e-13,
-1.8296452116696762e-13,
4.0188078346495234e-14,
-5.9483374717964875e-15,
6.66554681598241e-16,
-6.024971046266365e-17,
4.580133018616737e-18,
-2.9974506307413853e-19,
// [26.,26.5]: m=28 maxabs=5.108284568976766e-25 maxrel=1.1204007463095573e-12
3.6592904233359466e-13,
-1.6075231311611702e-13,
3.569002485385577e-14,
-5.332448244208109e-15,
6.024968029536571e-16,
-5.48579850287233e-17,
4.197390742117296e-18,
-2.763188420838133e-19,
// [26.,26.5]: m=29 maxabs=4.593821041027831e-25 maxrel=1.1441026192726687e-12
3.215046262321146e-13,
-1.427600991606835e-13,
3.199468949094215e-14,
-4.819984505172094e-15,
5.485796461374848e-16,
-5.027235999619518e-17,
3.868724146746352e-18,
-2.5595128375208655e-19,
// [26.,26.5]: m=30 maxabs=4.294432550278353e-25 maxrel=1.2018414309330823e-12
2.855201983211657e-13,
-1.279787577311294e-13,
2.89199070502765e-14,
-4.3886464745488e-15,
5.027233435959285e-16,
-4.633535848358338e-17,
3.584137943682189e-18,
-2.3821434030541434e-19,
// [26.,26.5]: m=31 maxabs=4.02836554416541e-25 maxrel=1.2552812734498702e-12
2.559575154620691e-13,
-1.1567962798369497e-13,
2.633187886538021e-14,
-4.0217954451002706e-15,
4.633533440815196e-16,
-4.2926170996045264e-17,
3.3357704933368272e-18,
-2.226241531735289e-19,
// [26.,26.5]: m=32 maxabs=3.7930956677922955e-25 maxrel=1.3055007290472134e-12
2.313592559672103e-13,
-1.0532751525758264e-13,
2.413077268770674e-14,
-3.7068349101330535e-15,
4.29261482361559e-16,
-3.9950934054970094e-17,
3.117465633833487e-18,
-2.0883179144032663e-19,
// [26.,26.5]: m=33 maxabs=3.582564469406912e-25 maxrel=1.3522567170301288e-12
2.1065503051499625e-13,
-9.65230905588771e-14,
2.2241009476949733e-14,
-3.434099536871632e-15,
3.9950912546492436e-16,
-3.7335878925107044e-17,
2.9243328770785235e-18,
-1.9655679863357805e-19,
// [26.,26.5]: m=34 maxabs=3.3902086262778203e-25 maxrel=1.3945545634782016e-12
1.930461811175939e-13,
-8.896403772658272e-14,
2.0604597236562666e-14,
-3.196080252471621e-15,
3.7335858496983886e-16,
-3.502240562340056e-17,
2.7524486477503603e-18,
-1.855723428455336e-19,
// [26.,26.5]: m=35 maxabs=3.218552493301728e-25 maxrel=1.4347547535004515e-12
1.7792807545301233e-13,
-8.241838877467526e-14,
1.9176481529449392e-14,
-2.986875542794666e-15,
3.502238615594343e-16,
-3.296349869821733e-17,
2.598635339781416e-18,
-1.7569327495491048e-19,
// [26.,26.5]: m=36 maxabs=3.0627997961748916e-25 maxrel=1.472203387684507e-12
1.6483677754920522e-13,
-7.670592595494224e-14,
1.792125327066001e-14,
-2.8017974067300433e-15,
3.2963480190137174e-16,
-3.112108685118118e-17,
2.460297828467147e-18,
-1.6676668245361128e-19,
// [26.,26.5]: m=37 maxabs=2.9201737445109327e-25 maxrel=1.5067424033316376e-12
1.5341185190974514e-13,
-7.168501292769253e-14,
1.6810784453676148e-14,
-2.637084613115498e-15,
3.112106915784636e-16,
-2.946407407777279e-17,
2.3352991078823274e-18,
-1.5866625886745352e-19,
// [26.,26.5]: m=38 maxabs=2.79016946733051e-25 maxrel=1.5391681246643766e-12
1.433700258552526e-13,
-6.724313766696417e-14,
1.5822507691352386e-14,
-2.4896914422117374e-15,
2.9464057223804206e-16,
-2.7966857240736704e-17,
2.2218664736742493e-18,
-1.512857656842697e-19,
// [26.,26.5]: m=39 maxabs=2.6710199162059283e-25 maxrel=1.569537271885905e-12
1.3448627533380111e-13,
-6.329003062425702e-14,
1.4938148665433557e-14,
-2.3571302239312036e-15,
2.7966841040994247e-16,
-2.660819615925799e-17,
2.11851878959094e-18,
-1.4453680487199813e-19,
// [26.,26.5]: m=40 maxabs=2.598066059691089e-25 maxrel=1.6208617966134406e-12
1.2658006124838146e-13,
-5.975259452655401e-14,
1.4142781357416393e-14,
-2.2373526819799413e-15,
2.660817875528313e-16,
-2.537040089646136e-17,
2.0240529266537978e-18,
-1.382164074540827e-19
},
{
// [26.5,27.]: m=0 maxabs=5.551115123125783e-17 maxrel=3.2244691814435293e-16
0.17134958128195726,
-0.0016013979558784513,
0.00002244950404982426,
-3.4968075125434755e-7,
5.719067492654174e-9,
-9.61869441320688e-11,
1.6724466820281612e-12,
-6.803172943843368e-14,
// [26.5,27.]: m=1 maxabs=4.336808689942018e-19 maxrel=1.3351317704655895e-16
0.003202795911766901,
-0.00008979801619520251,
2.098084484926352e-6,
-4.575262045070618e-8,
9.620874772556441e-10,
-1.9779339504414196e-11,
4.011037381474319e-13,
-1.2401617345547807e-14,
// [26.5,27.]: m=2 maxabs=8.131516293641283e-20 maxrel=4.4226239910737043e-16
0.0001795960323904159,
-8.392337939614022e-6,
2.7451572135985627e-7,
-7.696701540914929e-9,
1.978122850188214e-10,
-4.8065319287372735e-12,
1.1236751144876708e-13,
-2.812509648008163e-15,
// [26.5,27.]: m=3 maxabs=1.1458593947820395e-15 maxrel=6.606108121186228e-11
0.000016784675879228456,
-1.0980628854320836e-6,
4.618020916943657e-8,
-1.582498441064065e-9,
4.806642090843919e-11,
-1.3476346902738386e-12,
3.5698249304430386e-14,
-9.301213009160854e-16,
// [26.5,27.]: m=4 maxabs=8.470329472543003e-22 maxrel=3.697366413650042e-16
2.1961257708642355e-6,
-1.847208366767756e-7,
9.49499063913032e-9,
-3.8453139158268753e-10,
1.347644911054317e-11,
-4.2821026010578393e-13,
1.2677055052217896e-14,
-3.5917630593411335e-16,
// [26.5,27.]: m=5 maxabs=0. maxrel=0.
3.694416733535613e-7,
-3.797996255632031e-8,
2.3071883483893198e-9,
-1.0781159989900071e-10,
4.282118589274869e-12,
-1.5206317320279437e-13,
4.9753639105329565e-15,
-1.5346309410576039e-16,
// [26.5,27.]: m=6 maxabs=3.970466940254533e-23 maxrel=4.917571656187195e-16
7.595992511263012e-8,
-9.228753393472862e-9,
6.468695991711689e-10,
-3.4256951769900214e-11,
1.520634881247807e-12,
-5.967665635977114e-14,
2.1380997960520196e-15,
-7.145463119016802e-17,
// [26.5,27.]: m=7 maxabs=9.926167350636332e-24 maxrel=5.012155139318882e-16
1.8457506786946614e-8,
-2.587478396648614e-9,
2.0554171057325182e-10,
-1.216508047278306e-11,
5.967672202554182e-13,
-2.5643635243572625e-14,
9.982170345860589e-16,
-3.598413270930412e-17,
// [26.5,27.]: m=8 maxabs=1.819797347616661e-23 maxrel=3.2467965870718663e-15
5.174956793296991e-9,
-8.221668422735e-10,
7.299048281501291e-11,
-4.774138533350041e-12,
2.564366454099868e-13,
-1.1971263078176508e-14,
5.028364204562877e-16,
-1.9422132180151414e-17,
// [26.5,27.]: m=9 maxabs=1.1994118882018901e-23 maxrel=6.671776277796734e-15
1.6443336845472998e-9,
-2.919619312488469e-10,
2.864483119252516e-11,
-2.0514936049232274e-12,
1.1971272754225925e-13,
-6.029827071667405e-15,
2.7161020239575835e-16,
-1.1177458020546982e-17,
// [26.5,27.]: m=10 maxabs=7.754818242684634e-24 maxrel=1.2033900596893972e-14
5.839238624977063e-10,
-1.1457932476336186e-10,
1.2308961628044971e-11,
-9.57702088466836e-13,
6.029829158438457e-14,
-3.256757140463486e-15,
1.5641623748135e-16,
-6.824070017260556e-18,
// [26.5,27.]: m=11 maxabs=5.428372769879244e-24 maxrel=2.12647604183398e-14
2.2915864952675314e-10,
-4.9235846507875663e-11,
5.7462125302176645e-12,
-4.8238650462942e-13,
3.256757949880912e-14,
-1.875345700050024e-15,
9.551020029914522e-17,
-4.394022553266648e-18,
// [26.5,27.]: m=12 maxabs=3.9161832125557404e-24 maxrel=3.5369680885558856e-14
9.84716930157552e-11,
-2.2984850117962705e-11,
2.8943190276103457e-12,
-2.605407522087641e-13,
1.8753459222702194e-14,
-1.14500802508034e-15,
6.15090822044814e-17,
-2.9687720486589226e-18,
// [26.5,27.]: m=13 maxabs=2.7464981276174747e-24 maxrel=5.264653267704071e-14
4.596970023592339e-11,
-1.1577276108378877e-11,
1.5632445132181823e-12,
-1.5002775597190503e-13,
1.1450080445996816e-14,
-7.373214432299308e-16,
4.1562373084762685e-17,
-2.097853681957056e-18,
// [26.5,27.]: m=14 maxabs=2.213354373432906e-24 maxrel=8.346608164432062e-14
2.3154552216786105e-11,
-6.2529780515417624e-12,
9.001665339845951e-13,
-9.160070179086603e-14,
7.373233035155721e-15,
-4.9817725264643925e-16,
2.932053378875275e-17,
-1.5349680135200178e-18,
// [26.5,27.]: m=15 maxabs=1.7286782332651164e-24 maxrel=1.1962023680145555e-13
1.2505956103082943e-11,
-3.6006661348013245e-12,
5.496042107945411e-13,
-5.898590975321615e-14,
4.98177189262204e-15,
-3.5140993855236647e-16,
2.1491532173199502e-17,
-1.1637751482202486e-18,
// [26.5,27.]: m=16 maxabs=1.3910205222815563e-24 maxrel=1.6571152359518716e-13
7.201332269602448e-12,
-2.1984168422901977e-12,
3.5391545856224817e-13,
-3.985421065253962e-14,
3.5140988351706344e-15,
-2.575575148518324e-16,
1.6294565091170956e-17,
-9.089050181874051e-19,
// [26.5,27.]: m=17 maxabs=1.1446434843629299e-24 maxrel=2.2148128674178864e-13
4.396833684579957e-12,
-1.4156618335369e-12,
2.3912526395644423e-13,
-2.811281915135018e-14,
2.5755745941022015e-15,
-1.9526159990773468e-16,
1.2726410000494055e-17,
-7.2830342497116e-19,
// [26.5,27.]: m=18 maxabs=9.572353768313846e-25 maxrel=2.853631823938012e-13
2.831323667073903e-12,
-9.565010552328142e-13,
1.6867691492645108e-13,
-2.0604620449881325e-14,
1.952615057337183e-15,
-1.5249140031189673e-16,
1.020036557365432e-17,
-5.972241995513502e-19,
// [26.5,27.]: m=19 maxabs=8.162753993992524e-25 maxrel=3.574957853201423e-13
1.913002110465477e-12,
-6.747076592179962e-13,
1.2362772272993776e-13,
-1.5620939967780657e-14,
1.524913598098819e-15,
-1.2221712662533999e-16,
8.362428588243637e-18,
-4.993064048058554e-19,
// [26.5,27.]: m=20 maxabs=7.056076807276071e-25 maxrel=4.3510190386512916e-13
1.3494153184357999e-12,
-4.945108905050943e-13,
9.37256398360355e-14,
-1.2199325373265985e-14,
1.2221708809299668e-15,
-1.0018989817038063e-16,
6.991508306134611e-18,
-4.2465012113840288e-19,
// [26.5,27.]: m=21 maxabs=6.169523367552489e-25 maxrel=5.158207508253264e-13
9.890217809969197e-13,
-3.7490255898388883e-13,
7.319595226726315e-14,
-9.777381336112279e-15,
1.001898655558174e-15,
-8.376084968393734e-17,
5.945912004356595e-18,
-3.665192782570286e-19,
// [26.5,27.]: m=22 maxabs=5.456645544722365e-25 maxrel=5.983691131465824e-13
7.498051179675442e-13,
-2.927838087560702e-13,
5.866428803954452e-14,
-8.015201764019082e-15,
8.376081929298886e-16,
-7.123076164773412e-17,
5.1322405414651506e-18,
-3.204742572187842e-19,
// [26.5,27.]: m=23 maxabs=4.878063402397066e-25 maxrel=6.814811610047516e-13
5.855676175119082e-13,
-2.346571518812224e-13,
4.809121060487886e-14,
-6.7008766162880954e-15,
7.123073397359168e-16,
-6.148059944487103e-17,
4.487523911380916e-18,
-2.834148982020967e-19,
// [26.5,27.]: m=24 maxabs=4.392377520270594e-25 maxrel=7.621678944358542e-13
4.693143037625515e-13,
-1.9236484217344322e-13,
4.020525970487354e-14,
-5.6984685878416276e-15,
6.148058520664683e-16,
-5.375543269256939e-17,
3.9683269593692135e-18,
-2.530926819686628e-19,
// [26.5,27.]: m=25 maxabs=3.98646125288007e-25 maxrel=8.404265494916996e-13
3.8472968434670257e-13,
-1.6082103859679977e-13,
3.419081154452239e-14,
-4.9184557237004895e-15,
5.375540947326187e-16,
-4.753441917530476e-17,
3.544039175288035e-18,
-2.2800232574386905e-19,
// [26.5,27.]: m=26 maxabs=3.6466830837832757e-25 maxrel=9.163210407407683e-13
3.216420771934326e-13,
-1.3676324597593212e-13,
2.951073435814456e-14,
-4.300440843562273e-15,
4.753439796562936e-16,
-4.245085103682041e-17,
3.1927101067863694e-18,
-2.069770415039649e-19,
// [26.5,27.]: m=27 maxabs=3.3543627867445776e-25 maxrel=9.880252111435337e-13
2.7352649195170934e-13,
-1.1804293724782805e-13,
2.5802645076158864e-14,
-3.802759227015039e-15,
4.2450831354736123e-16,
-3.824158163125564e-17,
2.8983076384465218e-18,
-1.8916778739457494e-19,
// [26.5,27.]: m=28 maxabs=3.100917555115171e-25 maxrel=1.0552907933548955e-12
2.360858744955118e-13,
-1.0321058013475574e-13,
2.281655537586778e-14,
-3.396073303166468e-15,
3.8241563300484594e-16,
-3.471446435244006e-17,
2.6489347068923313e-18,
-1.7393457486346512e-19,
// [26.5,27.]: m=29 maxabs=2.8807938081222998e-25 maxrel=1.1185223779357053e-12
2.064211602693765e-13,
-9.126622134643529e-14,
2.0376439831870723e-14,
-3.059331345206143e-15,
3.4714447235698217e-16,
-3.1726919153281435e-17,
2.4356307505233834e-18,
-1.6078884287855938e-19,
// [26.5,27.]: m=30 maxabs=2.6874282230345253e-25 maxrel=1.177445595558065e-12
1.8253244269274527e-13,
-8.150575918161842e-14,
1.835598808320772e-14,
-2.777161613159489e-15,
3.1726903212477304e-16,
-2.9171561031001776e-17,
2.251553470847963e-18,
-1.493524557609451e-19,
// [26.5,27.]: m=31 maxabs=2.5175391384861282e-25 maxrel=1.2327244724119708e-12
1.6301151836311976e-13,
-7.342395219675158e-14,
1.6662969690146187e-14,
-2.5381576998782664e-15,
2.917154613130052e-16,
-2.6966391806835423e-17,
2.091410711159639e-18,
-1.3932926154086623e-19,
// [26.5,27.]: m=32 maxabs=2.3665827156630354e-25 maxrel=1.2841590696384793e-12
1.4684790439339226e-13,
-6.665187863314349e-14,
1.5228946209872915e-14,
-2.3337287878841e-15,
2.6966377686527254e-16,
-2.504799525258488e-17,
1.951061082437093e-18,
-1.304858283641757e-19,
// [26.5,27.]: m=33 maxabs=2.2320345996685396e-25 maxrel=1.3321736526117816e-12
1.3330375726618226e-13,
-6.091578471971924e-14,
1.400237273731997e-14,
-2.157315005567554e-15,
2.5047981918985165e-16,
-2.3366744092243235e-17,
1.827227809261912e-18,
-1.2263482087734654e-19,
// [26.5,27.]: m=34 maxabs=2.0189790463864488e-25 maxrel=1.3166846745656802e-12
1.218315694394221e-13,
-5.6009490836492134e-14,
1.2943890042120264e-14,
-2.0038430716300675e-15,
2.336673160674308e-16,
-2.188335004501353e-17,
1.7172927393040751e-18,
-1.156902747785511e-19,
// [26.5,27.]: m=35 maxabs=2.0002988201508152e-25 maxrel=1.4170382307055287e-12
1.1201898167261737e-13,
-5.1775560064779016e-14,
1.202305843098021e-14,
-1.869342787461734e-15,
2.1883361411133132e-16,
-2.0566499023264834e-17,
1.619139238816651e-18,
-1.0933462952190646e-19,
// [26.5,27.]: m=36 maxabs=1.901848979179233e-25 maxrel=1.4558654251447087e-12
1.0355112012946873e-13,
-4.80922336226791e-14,
1.121605673333279e-14,
-1.7506729623812188e-15,
2.0566487610739363e-16,
-1.9390796905661314e-17,
1.5310498779980109e-18,
-1.0366166622075477e-19,
// [26.5,27.]: m=37 maxabs=1.812234380346126e-25 maxrel=1.4920302079034413e-12
9.618446724527293e-14,
-4.4864226837110876e-14,
1.0504037782456218e-14,
-1.6453228575623002e-15,
1.939078602219502e-16,
-1.8335651780810538e-17,
1.4516114072323301e-18,
-9.85230717046444e-20,
// [26.5,27.]: m=38 maxabs=1.729561757478964e-25 maxrel=1.52504623814448e-12
8.972845367414019e-14,
-4.2016151038169564e-14,
9.871937153180381e-15,
-1.5512665479016125e-15,
1.8335641379933096e-16,
-1.7384142815707987e-17,
1.3796556721007052e-18,
-9.384936091290902e-20,
// [26.5,27.]: m=39 maxabs=1.6539573283225822e-25 maxrel=1.5559651973816502e-12
8.403230207626111e-14,
-3.948774852523315e-14,
9.307599294882915e-15,
-1.4668548098090906e-15,
1.7384132857877729e-16,
-1.6522274316131226e-17,
1.3142095156630308e-18,
-8.958220681926057e-20,
// [26.5,27.]: m=40 maxabs=1.5845375686631332e-25 maxrel=1.5849233695661149e-12
7.897549705039139e-14,
-3.72303970958596e-14,
8.80112886602553e-15,
-1.3907339753616043e-15,
1.6522264758873886e-16,
-1.5738386419101853e-17,
1.2544566199397844e-18,
-8.567251200995128e-20
},
{
// [27.,27.5]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.6273732758130855e-16
0.16977028877386896,
-0.0015575255850630752,
0.000021433838324431256,
-3.277345318068451e-7,
5.261779821616397e-9,
-8.687651849287981e-11,
1.496698047645541e-12,
-6.803172943843368e-14,
// [27.,27.5]: m=1 maxabs=8.673617379884035e-19 maxrel=2.7461924029651196e-16
0.0031150511701355196,
-0.00008573535329305356,
1.96640718228001e-6,
-4.209434276727852e-8,
8.689196791841675e-10,
-1.753785789793273e-11,
3.4910552827717075e-13,
-7.0866384831701746e-15,
// [27.,27.5]: m=2 maxabs=8.131516293641283e-20 maxrel=4.634199680922935e-16
0.00017147070658610423,
-7.865628729052457e-6,
2.525660567520303e-7,
-6.951358816803857e-9,
1.7537822672356677e-10,
-4.183195636906677e-12,
9.601287857432591e-14,
-2.4360319785897477e-15,
// [27.,27.5]: m=3 maxabs=3.3881317890172014e-21 maxrel=2.0853898608828568e-16
0.000015731257458105483,
-1.0102642269995915e-6,
4.170815280338943e-8,
-1.4030259886188118e-9,
4.183327170522566e-11,
-1.1513585071579983e-12,
2.99382793732365e-14,
-7.640282114667844e-16,
// [27.,27.5]: m=4 maxabs=1.6940658945086007e-21 maxrel=8.043646739194859e-16
2.020528453999264e-6,
-1.6683261121297374e-7,
8.418155924154001e-9,
-3.346661899861871e-10,
1.1513674222262011e-11,
-3.5913316065892437e-13,
1.0437653069627243e-14,
-2.917009883453348e-16,
// [27.,27.5]: m=5 maxabs=0. maxrel=0.
3.3366522242596443e-7,
-3.367262369639352e-8,
2.0079971383810353e-9,
-9.210940098164718e-11,
3.5913513713695213e-12,
-1.2519565336094969e-13,
4.021236967782402e-15,
-1.2214762619917343e-16,
// [27.,27.5]: m=6 maxabs=1.3234889800848443e-23 maxrel=1.8509538853206153e-16
6.734524739277754e-8,
-8.031988553465646e-9,
5.526564055701395e-10,
-2.8730813228496874e-11,
1.2519607697402126e-12,
-4.823362038223658e-14,
1.6965771099467611e-15,
-5.571039041945304e-17,
// [27.,27.5]: m=7 maxabs=2.6469779601696886e-23 maxrel=1.5377186447620933e-15
1.6063977106931914e-8,
-2.210625622251105e-9,
1.7238487931486848e-10,
-1.0015687295256143e-11,
4.823369292462342e-13,
-2.0348291401246143e-14,
7.777246736688497e-16,
-2.7903855294526116e-17,
// [27.,27.5]: m=8 maxabs=1.3234889800848443e-23 maxrel=2.767913708798945e-15
4.42125124450354e-9,
-6.895395172296467e-10,
6.009412357136444e-11,
-3.858696094756507e-12,
2.0348508499354946e-13,
-9.327176585813652e-15,
3.8474312548923644e-16,
-1.459802543987997e-17,
// [27.,27.5]: m=9 maxabs=8.271806125530277e-24 maxrel=5.495249867415527e-15
1.3790790344595852e-9,
-2.4037649427722354e-10,
2.3152176563445365e-11,
-1.6278810054135327e-12,
9.327183290039204e-14,
-4.613809015596922e-15,
2.0416027084080325e-16,
-8.260049394732082e-18,
// [27.,27.5]: m=10 maxabs=3.5155176033503676e-24 maxrel=6.6381196345683644e-15
4.807529885544686e-10,
-9.260870624885731e-11,
9.76728603021106e-12,
-7.461748592849038e-13,
4.613811978444859e-14,
-2.4480460299757724e-15,
1.1554932714827907e-16,
-4.9912068231422936e-18,
// [27.,27.5]: m=11 maxabs=3.877409121342317e-24 maxrel=1.8829782028198693e-14
1.8521741249781713e-10,
-3.9069144118669325e-11,
4.477049145968748e-12,
-3.69105060066397e-13,
2.4480612149344452e-14,
-1.3854804723661894e-15,
6.939210570128759e-17,
-3.1422714395568017e-18,
// [27.,27.5]: m=12 maxabs=2.68833699079734e-24 maxrel=3.066377927410877e-14
7.813828823734103e-11,
-1.7908196581828838e-11,
2.2146303602292273e-12,
-1.958449790180036e-13,
1.3854807020278242e-14,
-8.319204173097406e-16,
4.39843765340873e-17,
-2.0915810929008575e-18,
// [27.,27.5]: m=13 maxabs=1.9839410004201523e-24 maxrel=4.892119508891407e-14
3.581639316365257e-11,
-8.858521439489559e-12,
1.1750698740958168e-12,
-1.108385130394915e-13,
8.319204541456915e-15,
-5.272670387792447e-16,
2.92807189521151e-17,
-1.4537200333880468e-18,
// [27.,27.5]: m=14 maxabs=1.4960336859845774e-24 maxrel=7.390703797139963e-14
1.7717042878983008e-11,
-4.70027949519624e-12,
6.650310786054812e-13,
-6.65536797565595e-14,
5.272664506992708e-15,
-3.5096634419258664e-16,
2.0370989313861538e-17,
-1.0529871280022793e-18,
// [27.,27.5]: m=15 maxabs=1.1632227364026952e-24 maxrel=1.0734846224057749e-13
9.400558990392043e-12,
-2.660124313651571e-12,
3.9932207855920075e-13,
-4.2181346896960093e-14,
3.5096631900347873e-15,
-2.4415586177792935e-16,
1.4742605845647855e-17,
-7.891476708152127e-19,
// [27.,27.5]: m=16 maxabs=9.257314277204782e-25 maxrel=1.496534844415474e-13
5.320248627303189e-12,
-1.5972883136410965e-12,
2.53088081404406e-13,
-2.8077329349402815e-14,
2.4415583202867092e-15,
-1.7668252730804458e-16,
1.104901464871968e-17,
-6.099267863853278e-19,
// [27.,27.5]: m=17 maxabs=7.552869850948055e-25 maxrel=2.016558803894102e-13
3.1945766272814344e-12,
-1.012352325144316e-12,
1.6846397612040806e-13,
-1.9532485485824984e-14,
1.7668249558086478e-15,
-1.3240653441111467e-16,
8.539985131190729e-18,
-4.843265064674152e-19,
// [27.,27.5]: m=18 maxabs=6.280594983007608e-25 maxrel=2.624806254831981e-13
2.0247046502886783e-12,
-6.738559040968951e-13,
1.1719491293629886e-13,
-1.4134615031913602e-14,
1.324065056977385e-15,
-1.0233214150369526e-16,
6.781495330537455e-18,
-3.9377590188814673e-19,
// [27.,27.5]: m=19 maxabs=5.373846704110368e-25 maxrel=3.3488291259739784e-13
1.347711808193726e-12,
-4.687796514261197e-13,
8.480769021225919e-14,
-1.059253321818441e-14,
1.0233211406957432e-15,
-8.125543432799292e-17,
5.513728869398728e-18,
-3.2669322171050277e-19,
// [27.,27.5]: m=20 maxabs=4.56201416932932e-25 maxrel=4.0582269758140485e-13
9.375593028517358e-13,
-3.392307605761614e-13,
6.355519935929925e-14,
-8.186579988318464e-15,
8.125535990251145e-16,
-6.606094759080308e-17,
4.576085250866308e-18,
-2.7613169235377877e-19,
// [27.,27.5]: m=21 maxabs=3.966266413706412e-25 maxrel=4.844546872951459e-13
6.784615211420727e-13,
-2.542207972031099e-13,
4.911947994552894e-14,
-6.500438050301506e-15,
6.606092656017701e-16,
-5.4824151932332143e-17,
3.866516268740475e-18,
-2.3697742785119003e-19,
// [27.,27.5]: m=22 maxabs=3.493707177042817e-25 maxrel=5.661239664441798e-13
5.084415944060621e-13,
-1.9647791958075522e-13,
3.900262831617036e-14,
-5.284882178867645e-15,
5.482413279687036e-16,
-4.632088199873451e-17,
3.3182964236926847e-18,
-2.0615749316005348e-19,
// [27.,27.5]: m=23 maxabs=3.111014974702e-25 maxrel=6.488487467074161e-13
3.9295583916137155e-13,
-1.5601051308741534e-13,
3.1709293086336635e-14,
-4.385937713790064e-15,
4.632086454110286e-16,
-3.975149662207578e-17,
2.8867628059596633e-18,
-1.814872235234616e-19,
// [27.,27.5]: m=24 maxabs=2.7889072898821563e-25 maxrel=7.291114216804409e-13
3.120210261747126e-13,
-1.26837172187778e-13,
2.6315626294031595e-14,
-3.705675468271807e-15,
3.9751481261989596e-16,
-3.4580619048235385e-17,
2.541316125308276e-18,
-1.614312651610275e-19,
// [27.,27.5]: m=25 maxabs=2.5273841225832865e-25 maxrel=8.093217364774379e-13
2.5367434437523237e-13,
-1.0526250503685982e-13,
2.2234052829678543e-14,
-3.180124130423408e-15,
3.458059873741597e-16,
-3.0441547337705434e-17,
2.2605853737439676e-18,
-1.4491869427042435e-19,
// [27.,27.5]: m=26 maxabs=2.3032214077556837e-25 maxrel=8.85415039994687e-13
2.1052501007361407e-13,
-8.893621119063479e-14,
1.908074479258317e-14,
-2.7664530220258738e-15,
3.044153396778668e-16,
-2.7077845216375894e-17,
2.0292892931883376e-18,
-1.3114060492130668e-19,
// [27.,27.5]: m=27 maxabs=2.112885048543958e-25 maxrel=9.5819965414748e-13
1.778724223811722e-13,
-7.63229790536e-14,
1.6598718141408704e-14,
-2.4353273864702582e-15,
2.70778329010306e-16,
-2.4306650559116334e-17,
1.836362238200235e-18,
-1.195190686824096e-19,
// [27.,27.5]: m=28 maxabs=1.9495592867269997e-25 maxrel=1.0272566903596116e-12
1.5264595810710994e-13,
-6.639487245856822e-14,
1.461196432740488e-14,
-2.1662309144115038e-15,
2.430663913186344e-16,
-2.1995238828010237e-17,
1.6736323871796236e-18,
-1.0961694222906016e-19,
// [27.,27.5]: m=29 maxabs=1.7630094598603349e-25 maxrel=1.0651306754321178e-12
1.3278974491699832e-13,
-5.844785721090412e-14,
1.299738549531188e-14,
-1.9445350815991713e-15,
2.1995227513581617e-16,
-2.0045662522108047e-17,
1.534994722678095e-18,
-1.0112342996043289e-19,
// [27.,27.5]: m=30 maxabs=1.6832398451243861e-25 maxrel=1.1525853323098152e-12
1.1689571442167126e-13,
-5.198954188625212e-14,
1.1667210488149496e-14,
-1.7596219167699041e-15,
2.0045664422331873e-16,
-1.8384583479185438e-17,
1.4157450813387397e-18,
-9.371831072725336e-20,
// [27.,27.5]: m=31 maxabs=1.5739352780969628e-25 maxrel=1.2091806592285694e-12
1.039790837724309e-13,
-4.6668841867365053e-14,
1.055773150761207e-14,
-1.6036565629087792e-15,
1.8384574169877254e-16,
-1.6956214886620494e-17,
1.31235404901374e-18,
-8.726673937468732e-20,
// [27.,27.5]: m=32 maxabs=1.4772524855530755e-25 maxrel=1.2620309493215406e-12
9.333768373466143e-14,
-4.223092595075833e-14,
9.621939384007425e-15,
-1.4707691209852287e-15,
1.6956206155645507e-16,
-1.571765116705719e-17,
1.2220136733520648e-18,
-8.159006360368704e-20,
// [27.,27.5]: m=33 maxabs=1.390919548085688e-25 maxrel=1.311053497946125e-12
8.446185190145174e-14,
-3.848775746125583e-14,
8.824614732116464e-15,
-1.3564994833355405e-15,
1.5717642903234656e-16,
-1.4635452308919678e-17,
1.1425251667427577e-18,
-7.656335880384705e-20,
// [27.,27.5]: m=34 maxabs=1.313800505991282e-25 maxrel=1.3568638022656803e-12
7.697551492245017e-14,
-3.5298458858060584e-14,
8.138996905888441e-15,
-1.257414248334528e-15,
1.4635444480442244e-16,
-1.3683268836385087e-17,
1.072137511844477e-18,
-7.20860995416002e-20,
// [27.,27.5]: m=35 maxabs=1.2442545285869975e-25 maxrel=1.3993539177443012e-12
7.059691771606289e-14,
-3.255598755706354e-14,
7.544485495572932e-15,
-1.1708382178847875e-15,
1.3683261414796925e-16,
-1.2840120585257215e-17,
1.0094430045432337e-18,
-6.80767146044397e-20,
// [27.,27.5]: m=36 maxabs=1.1815243094038226e-25 maxrel=1.4390852445939914e-12
6.511197511407182e-14,
-3.017794191932705e-14,
7.025029312591934e-15,
-1.0946634316613039e-15,
1.2840113541167938e-16,
-1.2089139677433488e-17,
9.532995060682097e-19,
-6.44683795350907e-20,
// [27.,27.5]: m=37 maxabs=1.1246001064830744e-25 maxrel=1.4761579580150038e-12
6.035588383860135e-14,
-2.8100117190591397e-14,
6.567980595016567e-15,
-1.0272114742936487e-15,
1.208913294922641e-16,
-1.1416641197534622e-17,
9.027725774460955e-19,
-6.120613946737766e-20,
// [27.,27.5]: m=38 maxabs=1.0720935246315639e-25 maxrel=1.509876225496483e-12
5.620023438113255e-14,
-2.6271922323179263e-14,
6.163268850575194e-15,
-9.671329112778512e-16,
1.1416634776750343e-16,
-1.0811428654248558e-17,
8.570915563421943e-19,
-5.824426914766528e-20,
// [27.,27.5]: m=39 maxabs=1.0243832170837971e-25 maxrel=1.5417627172637193e-12
5.2543844646310393e-14,
-2.4653075348053446e-14,
5.802797472271451e-15,
-9.133329519673925e-16,
1.0811422514832112e-16,
-1.0264268986176314e-17,
8.156162917837162e-19,
-5.554450951168046e-20,
// [27.,27.5]: m=40 maxabs=9.807118773707619e-26 maxrel=1.5717394783289605e-12
4.930615069606087e-14,
-2.3211189837249678e-14,
5.479997716210507e-15,
-8.649158745427707e-16,
1.0264263110032632e-16,
-9.76749200244847e-18,
7.77811241948272e-19,
-5.3074623946237856e-20
},
{
// [27.5,28.]: m=0 maxabs=8.326672684688674e-17 maxrel=4.927117274763749e-16
0.1682338744689366,
-0.0015156204906982783,
0.000020481357980889712,
-3.0752789927168804e-7,
4.848406277599204e-9,
-7.862483664307645e-11,
1.3152801024763844e-12,
0,
// [27.5,28.]: m=1 maxabs=8.673617379884035e-19 maxrel=2.822827605352801e-16
0.003031240981405853,
-0.00008192543192188606,
1.845167383660699e-6,
-3.8787302130420514e-8,
7.862287286911553e-10,
-1.5581989968068283e-11,
3.049912037194364e-13,
-8.1496342556457e-15,
// [27.5,28.]: m=2 maxabs=0. maxrel=0.
0.00016385086384377708,
-7.380669534513689e-6,
2.3272381215296978e-7,
-6.289832443419237e-9,
1.5582912684385626e-10,
-3.64991640228457e-12,
8.224929789529384e-14,
-2.1038457996911456e-15,
// [27.5,28.]: m=3 maxabs=6.776263578034403e-21 maxrel=4.447423707741957e-16
0.000014761339069028205,
-9.308952486069188e-7,
3.7738994565579605e-8,
-1.2466331216192097e-9,
3.6500476504279616e-11,
-9.864892296547595e-13,
2.5188017014986494e-14,
-6.297696308285995e-16,
// [27.5,28.]: m=4 maxabs=1.2705494208814505e-21 maxrel=6.552008210901822e-16
1.8617904972138875e-6,
-1.5095597826214488e-7,
7.479798725132424e-9,
-2.9200382135534653e-10,
9.864951688884429e-12,
-3.0216396628576223e-13,
8.623345587845895e-15,
-2.366826524652539e-16,
// [27.5,28.]: m=5 maxabs=5.293955920339377e-23 maxrel=1.6683355330468594e-16
3.0191195652430004e-7,
-2.99191949003659e-8,
1.7520229269997185e-9,
-7.891961843993652e-11,
3.0216552185405643e-12,
-1.034395537300757e-13,
3.2626694991653508e-15,
-9.732016959919978e-17,
// [27.5,28.]: m=6 maxabs=1.4558378780933287e-22 maxrel=2.2939621071409692e-15
5.983838980072021e-8,
-7.008091707955146e-9,
4.735177103936576e-10,
-2.4173243548451976e-11,
1.0343988225323153e-12,
-3.9135158402241903e-14,
1.3519069159590173e-15,
-4.374000955875146e-17,
// [27.5,28.]: m=7 maxabs=1.6543612251060553e-23 maxrel=1.1028679215589423e-15
1.4016183415910392e-8,
-1.8940708415503464e-9,
1.4503946123285937e-10,
-8.275191549194014e-12,
3.9135248144617046e-13,
-1.6214027025033307e-14,
6.086356098318178e-16,
-2.1164433549781532e-17,
// [27.5,28.]: m=8 maxabs=9.926167350636332e-24 maxrel=2.4263217202644325e-15
3.78814168310078e-9,
-5.801578449202556e-10,
4.965114928176091e-11,
-3.1308202907561964e-12,
1.6214044344348647e-13,
-7.299452434768773e-15,
2.9576900522630694e-16,
-1.1026240048687114e-17,
// [27.5,28.]: m=9 maxabs=5.997059441009451e-24 maxrel=4.742704141942198e-15
1.1603156898408002e-9,
-1.9860459712096498e-10,
1.8784921740839726e-11,
-1.297123789205589e-12,
7.299457303945226e-14,
-3.546919422585661e-15,
1.5421179202509449e-16,
-6.132522353771798e-18,
// [27.5,28.]: m=10 maxabs=3.877409121342317e-24 maxrel=8.876852506413435e-15
3.972091942419856e-10,
-7.513968695975245e-11,
7.782742733891352e-12,
-5.8395672691439e-13,
3.5469212429828764e-14,
-1.849179610641964e-15,
8.579649423051051e-17,
-3.620741153591062e-18,
// [27.5,28.]: m=11 maxabs=2.1208729960100634e-20 maxrel=1.271831012983406e-10
1.5027937392542125e-10,
-3.1130971134187254e-11,
3.5037401484020586e-12,
-2.8374729562176723e-13,
1.8489391726477183e-14,
-1.0695844501245622e-15,
6.427800259626644e-17,
6.938015715832953e-17,
// [27.5,28.]: m=12 maxabs=1.8740810753154533e-24 maxrel=2.688234066158338e-14
6.226194186668362e-11,
-1.4014961442515526e-11,
1.702522728509684e-12,
-1.479344769159507e-13,
1.028709503185262e-14,
-6.07499145921785e-16,
3.16102267926571e-17,
-1.4806794944326168e-18,
// [27.5,28.]: m=13 maxabs=1.3829425866120931e-24 maxrel=4.367065432949857e-14
2.8029922885027992e-11,
-6.810090913044145e-12,
8.876068614563932e-13,
-8.229679996614156e-14,
6.074992000330956e-15,
-3.78941731686153e-16,
2.0727791656036165e-17,
-1.0155944716925174e-18,
// [27.5,28.]: m=14 maxabs=1.0210510686201435e-24 maxrel=6.576750454138174e-14
1.3620181826088842e-11,
-3.550427445123868e-12,
4.937807997930672e-13,
-4.8599964190121527e-14,
3.789417105745744e-15,
-2.484619442529149e-16,
1.4219211616474988e-17,
-7.255030677146943e-19,
// [27.5,28.]: m=15 maxabs=7.803285856701413e-25 maxrel=9.556682233814051e-14
7.10085489024737e-12,
-1.9751231986469732e-12,
2.915997851518228e-13,
-3.031535784362323e-14,
2.484619285904171e-15,
-1.7042901778938874e-16,
1.0157561703792565e-17,
-5.373016362217106e-19,
// [27.5,28.]: m=16 maxabs=6.179620787139318e-25 maxrel=1.348816285315283e-13
3.950246397294063e-12,
-1.1663991402059177e-12,
1.8189214707571206e-13,
-1.98769703397519e-14,
1.7042899912907154e-15,
-1.2173665925190503e-16,
7.522818222269004e-18,
-4.1084138328820175e-19,
// [27.5,28.]: m=17 maxabs=4.996203211562965e-25 maxrel=1.8313310707136276e-13
2.3327982804113103e-12,
-7.275685879869367e-13,
1.192618220527709e-13,
-1.3634332556250055e-14,
1.2173664047763561e-15,
-9.01526376495434e-17,
5.752379218663028e-18,
-3.231036758635542e-19,
// [27.5,28.]: m=18 maxabs=4.1177277075088463e-25 maxrel=2.4004639688442944e-13
1.4551371759739848e-12,
-4.770472879567143e-13,
8.180599535143145e-14,
-9.738941412939579e-15,
9.015261919908388e-16,
-6.893087953314469e-17,
4.524040837303057e-18,
-2.604432897695653e-19,
// [27.5,28.]: m=19 maxabs=3.4593759504475987e-25 maxrel=3.052584454587243e-13
9.540945759132904e-13,
-3.272239811961879e-13,
5.843364849045856e-14,
-7.212217916332398e-15,
6.893086249161904e-16,
-5.4208045910038684e-17,
3.6467514598443394e-18,
-2.1450320787904138e-19,
// [27.5,28.]: m=20 maxabs=2.9100763249241037e-25 maxrel=3.717245810493518e-13
6.544479623922664e-13,
-2.337345937856084e-13,
4.32733075104463e-14,
-5.514476037225548e-15,
5.420802978348216e-16,
-4.3693481040077515e-17,
3.0035539311724877e-18,
-1.8005940761968918e-19,
// [27.5,28.]: m=21 maxabs=1.8155160417118454e-25 maxrel=3.225530794958246e-13
4.674691875725641e-13,
-1.730932299001451e-13,
3.3086856152918275e-14,
-4.336647940068692e-15,
4.3693504082011475e-16,
-3.5987984489583796e-17,
2.5206998108718606e-18,
-1.4774103759832676e-19,
// [27.5,28.]: m=22 maxabs=2.2406174063173443e-25 maxrel=5.343383942397425e-13
3.461864597746312e-13,
-1.3234742470392593e-13,
2.6019890511265243e-14,
-3.4954844327636524e-15,
3.598492504601747e-16,
-3.019814481563039e-17,
2.150325442049546e-18,
-1.3288686823875923e-19,
// [27.5,28.]: m=23 maxabs=1.9851526907705718e-25 maxrel=6.158234910307539e-13
2.6469484940776264e-13,
-1.0407956193133742e-13,
2.0972906605004945e-14,
-2.878798552291946e-15,
3.019813361041671e-16,
-2.5760240639302003e-17,
1.860774491182349e-18,
-1.1643547060132804e-19,
// [27.5,28.]: m=24 maxabs=1.776640976302554e-25 maxrel=6.974277491955303e-13
2.0815912386258858e-13,
-8.389162631920524e-14,
1.7272791321360344e-14,
-2.415854719155057e-15,
2.576023050606399e-16,
-2.2290608607439226e-17,
1.6304208520350355e-18,
-1.0315324347498868e-19,
// [27.5,28.]: m=25 maxabs=1.602965359409096e-25 maxrel=7.772903518713094e-13
1.6778325263848795e-13,
-6.909116519569783e-14,
1.4495128315127062e-14,
-2.0608220372445012e-15,
2.229060570094916e-16,
-1.953048156400327e-17,
1.4442739786993901e-18,
-9.224509956716551e-20,
// [27.5,28.]: m=26 maxabs=1.456805210889747e-25 maxrel=8.544337419256199e-13
1.3818233039132776e-13,
-5.798051317924894e-14,
1.236493222987998e-14,
-1.78325170624717e-15,
1.953047304568964e-16,
-1.7300087166816432e-17,
1.2917034715743466e-18,
-8.319970803071102e-20,
// [27.5,28.]: m=27 maxabs=1.3328593854614215e-25 maxrel=9.283535652973819e-13
1.1596102635843565e-13,
-4.945972884567746e-14,
1.0699510243373044e-14,
-1.5624407971199854e-15,
1.730007933814564e-16,
-1.5472089623337285e-17,
1.1650460297735876e-18,
-7.560325222650102e-20,
// [27.5,28.]: m=28 maxabs=1.227341350779059e-25 maxrel=9.990953773333063e-13
9.891945769129721e-14,
-4.2798040905952044e-14,
9.374644788185614e-15,
-1.3840090485469959e-15,
1.5472082357982232e-16,
-1.3954618432518807e-17,
1.0586776585045063e-18,
-6.915648645990567e-20,
// [27.5,28.]: m=29 maxabs=1.134571308325068e-25 maxrel=1.0644731979251718e-12
8.559608181185065e-14,
-3.749857909059755e-14,
8.304054296370123e-15,
-1.237769074368124e-15,
1.3954611663738817e-16,
-1.268026922802644e-17,
9.684071339942742e-19,
-6.363324913023138e-20,
// [27.5,28.]: m=30 maxabs=1.0544230403546132e-25 maxrel=1.1264027827293811e-12
7.499715818114525e-14,
-3.321621712799303e-14,
7.42661445092744e-15,
-1.1163712324577504e-15,
1.2680262960236525e-16,
-1.15988125950913e-17,
8.910656647130967e-19,
-5.885984821064477e-20,
// [27.5,28.]: m=31 maxabs=9.844984097158227e-26 maxrel=1.1847920144522781e-12
6.643243425593965e-14,
-2.970645775028539e-14,
6.698227399158443e-15,
-1.0144231737104438e-15,
1.1598806726166312e-16,
-1.0672274367341296e-17,
8.242254423319193e-19,
-5.470189229262645e-20,
// [27.5,28.]: m=32 maxabs=9.22146843767154e-26 maxrel=1.2385459979331896e-12
5.941291550052706e-14,
-2.6792909546772644e-14,
6.086539046413722e-15,
-9.279065324589762e-16,
1.0672268843656666e-16,
-9.871559811581608e-18,
7.660030922249851e-19,
-5.105391629522739e-20,
// [27.5,28.]: m=33 maxabs=8.671159070189362e-26 maxrel=1.2891243152493768e-12
5.3585819093504217e-14,
-2.4346156138939367e-14,
5.567439198656331e-15,
-8.537833760165143e-16,
9.871554620810778e-17,
-9.174099765935395e-18,
7.14920693036086e-19,
-4.7832049337117894e-20,
// [27.5,28.]: m=34 maxabs=8.180172042779804e-26 maxrel=1.3363544249945952e-12
4.869231227783974e-14,
-2.226975675070607e-14,
5.12270025980373e-15,
-7.897261263601957e-16,
9.174094839661928e-17,
-8.562184485309305e-18,
6.698060788163988e-19,
-4.496935352444442e-20,
// [27.5,28.]: m=35 maxabs=7.715690741785672e-26 maxrel=1.3761589672109566e-12
4.453951350141882e-14,
-2.0490800997891287e-14,
4.738356760873753e-15,
-7.339292425109725e-16,
8.562180268691208e-17,
-8.021775020695491e-18,
6.29712030930781e-19,
-4.2401541254328684e-20,
// [27.5,28.]: m=36 maxabs=7.338930773452117e-26 maxrel=1.4208940856968464e-12
4.0981601995551103e-14,
-1.895342700750055e-14,
4.403575467125889e-15,
-6.849759522146127e-16,
8.02176380858538e-17,
-7.541599930140615e-18,
5.939040952270282e-19,
-4.011456701584346e-20,
// [27.5,28.]: m=37 maxabs=6.975423668326275e-26 maxrel=1.458481069252416e-12
3.790685401496793e-14,
-1.7614301831350344e-14,
4.1098557164483416e-15,
-6.417425907538876e-16,
7.541595722771466e-17,
-7.112583225491487e-18,
5.617384585355309e-19,
-3.8041864162120065e-20,
// [27.5,28.]: m=38 maxabs=6.647888620478511e-26 maxrel=1.4942094427213935e-12
3.5228603662669096e-14,
-1.6439422830475603e-14,
3.8504555475342345e-15,
-6.033290704935357e-16,
7.112579214469131e-17,
-6.7273000721086395e-18,
5.327143885949387e-19,
-3.6163405980808534e-20,
// [27.5,28.]: m=39 maxabs=6.346228210321996e-26 maxrel=1.5269933036512356e-12
3.287884566092106e-14,
-1.5401822156486703e-14,
3.619974425836712e-15,
-5.690076830933326e-16,
6.727296241102399e-17,
-6.3796521005072514e-18,
5.064102326188323e-19,
-3.44540404886846e-20,
// [27.5,28.]: m=40 maxabs=6.0685491716842e-26 maxrel=1.5572935718686744e-12
3.080364431294438e-14,
-1.4479897671222797e-14,
3.4140461013257074e-15,
-5.381849842083276e-16,
6.379648417846731e-17,
-6.0645878170946695e-18,
4.824743114321785e-19,
-3.2892781918687397e-20
},
{
// [28.,28.5]: m=0 maxabs=5.551115123125783e-17 maxrel=3.3144716534934834e-16
0.1667384325793881,
-0.0014755613502511937,
0.000019587097569535778,
-2.888952389075247e-7,
4.4740301508229725e-9,
-7.130859107305156e-11,
1.1848859543860532e-12,
6.803172943843368e-14,
// [28.,28.5]: m=1 maxabs=8.673617379884035e-19 maxrel=2.900162696819223e-16
0.0029511227005101157,
-0.00007834839027426087,
1.7333714650671961e-6,
-3.5792331083706804e-8,
7.126790214164191e-10,
-1.3873955073407449e-11,
2.6628044100511933e-13,
-7.795302331487193e-15,
// [28.,28.5]: m=2 maxabs=5.421010862427522e-20 maxrel=3.3835231465498837e-16
0.00015669678054852645,
-6.93348586021334e-6,
2.1475398563051165e-7,
-5.701433058372259e-9,
1.3875164784742272e-10,
-3.192432364923573e-12,
7.068921886962249e-14,
-1.7052223850128232e-15,
// [28.,28.5]: m=3 maxabs=1.6940658945086007e-21 maxrel=1.1842331023145897e-16
0.00001386697172042734,
-8.590159425176168e-7,
3.420859828960849e-8,
-1.110013316994709e-9,
3.192513473715587e-11,
-8.475546095076721e-13,
2.1260607504049895e-14,
-5.38418431631484e-16,
// [28.,28.5]: m=4 maxabs=1.0587911840678754e-21 maxrel=5.921165552458574e-16
1.7180318850353488e-6,
-1.3683439315773163e-7,
6.6600798915766225e-9,
-2.5540109542704257e-10,
8.47567468205414e-12,
-2.550161396015643e-13,
7.149182912165927e-15,
-1.9360225738934145e-16,
// [28.,28.5]: m=5 maxabs=1.0587911840678754e-22 maxrel=3.6842809464893683e-16
2.7366878631547465e-7,
-2.66403195661605e-8,
1.5324065713049073e-9,
-6.780540197354205e-11,
2.5501781965857548e-12,
-8.57554327220779e-14,
2.6569595769321087e-15,
-7.794264249678134e-17,
// [28.,28.5]: m=6 maxabs=0. maxrel=0.
5.3280639132307565e-8,
-6.129626285187591e-9,
4.0683241164518636e-10,
-2.040142680975887e-11,
8.575571952934855e-13,
-3.187126981559584e-14,
1.0814974180515518e-15,
-3.429454643154024e-17,
// [28.,28.5]: m=7 maxabs=8.271806125530277e-24 maxrel=6.312236921767214e-16
1.2259252570375172e-8,
-1.6273296465627154e-9,
1.224085608187793e-10,
-6.860458243071636e-12,
3.187132424984174e-13,
-1.2971672181999337e-14,
4.7836310114013335e-16,
-1.634303014755451e-17,
// [28.,28.5]: m=8 maxabs=6.617444900424222e-24 maxrel=1.885261392225996e-15
3.25465929312572e-9,
-4.896342432664551e-10,
4.116274944829098e-11,
-2.549706273846948e-12,
1.2971684822216677e-13,
-5.737197391664583e-15,
2.28409593256183e-16,
-8.368858751020076e-18,
// [28.,28.5]: m=9 maxabs=4.1359030627651384e-24 maxrel=3.881465489585508e-15
9.792684865329361e-10,
-1.6465099778852959e-10,
1.529823764025229e-11,
-1.037734967677797e-12,
5.737201252897224e-14,
-2.7391877811030384e-15,
1.1703933104698208e-16,
-4.575737557440154e-18,
// [28.,28.5]: m=10 maxabs=2.946830932220161e-24 maxrel=8.151355919736837e-15
3.2930199557711304e-10,
-6.119295055837689e-11,
6.2264098049675195e-12,
-4.589762047168494e-13,
2.7391892206833467e-14,
-1.4034728990779149e-15,
6.401487593329031e-17,
-2.6572968183531505e-18,
// [28.,28.5]: m=11 maxabs=1.8611563782443123e-24 maxrel=1.3729849920566161e-14
1.2238590111678005e-10,
-2.490563921826218e-11,
2.753857227893714e-12,
-2.1913520180301174e-13,
1.4034734285586146e-14,
-7.675651174612557e-16,
3.7185476072408306e-17,
-1.6311688322101989e-18,
// [28.,28.5]: m=12 maxabs=1.3118567527208173e-24 maxrel=2.3568169714063436e-14
4.9811278436523955e-11,
-1.1015428910542544e-11,
1.314811210677966e-12,
-1.1227791551942178e-13,
7.675653054277292e-15,
-4.458303872995974e-16,
2.2830286420299952e-17,
-1.0533408851291862e-18,
// [28.,28.5]: m=13 maxabs=9.079599692476593e-25 maxrel=3.6556954532808334e-14
2.2030857821085685e-11,
-5.259244842017169e-12,
6.736674930562236e-13,
-6.14052521412058e-14,
4.458304456596234e-15,
-2.7369722441068644e-16,
1.474509336544508e-17,
-7.10167432265428e-19,
// [28.,28.5]: m=14 maxabs=6.930868804399392e-25 maxrel=5.793796981523092e-14
1.0518489684025955e-11,
-2.6946699718141226e-12,
3.6843151387462346e-13,
-3.566645488409071e-14,
2.736961247688674e-15,
-1.767526226162547e-16,
9.971836902185249e-18,
-5.021067620623211e-19,
// [28.,28.5]: m=15 maxabs=5.31528167050676e-25 maxrel=8.597226528979781e-14
5.389339943628066e-12,
-1.4737260551389157e-12,
2.139987293105751e-13,
-2.1895704341203547e-14,
1.7675261518100258e-15,
-1.1952426403646472e-16,
7.029719562045991e-18,
-3.6729691694131584e-19,
// [28.,28.5]: m=16 maxabs=4.13994203059987e-25 maxrel=1.214010091257165e-13
2.947452110277523e-12,
-8.559949169676833e-13,
1.3137422608539267e-13,
-1.4140220108681728e-14,
1.1952422096562703e-15,
-8.425231283619339e-17,
5.1433690823329855e-18,
-2.7796895243218705e-19,
// [28.,28.5]: m=17 maxabs=3.2957977531409696e-25 maxrel=1.650210403967764e-13
1.7119898339357393e-12,
-5.254969041233808e-13,
8.484132058364751e-14,
-9.561946160242478e-15,
8.425238400578725e-16,
-6.163933748846797e-17,
3.889719906538544e-18,
-2.162139139852773e-19,
// [28.,28.5]: m=18 maxabs=2.706108449270159e-25 maxrel=2.1895818743169913e-13
1.050993808247421e-12,
-3.3936528215381826e-13,
5.737167699516421e-14,
-6.740197651370264e-15,
6.163928359062447e-16,
-4.6611246609555946e-17,
3.028743121594584e-18,
-1.7281118148727807e-19,
// [28.,28.5]: m=19 maxabs=2.261821987449685e-25 maxrel=2.8124036891274125e-13
6.787305643075481e-13,
-2.294867078426711e-13,
4.044118591661468e-14,
-4.9311482046904194e-15,
4.661123540975628e-16,
-3.629196077829338e-17,
2.419714443540131e-18,
-1.4119991322307944e-19,
// [28.,28.5]: m=20 maxabs=1.916490237580135e-25 maxrel=3.498890695566862e-13
4.589734156853311e-13,
-1.6176474355153428e-13,
2.9586889235994936e-14,
-3.72890342955938e-15,
3.629195033181572e-16,
-2.899244696773558e-17,
1.9771324949128367e-18,
-1.1766458686887028e-19,
// [28.,28.5]: m=21 maxabs=1.6287137793555098e-25 maxrel=4.1903889262120135e-13
3.235294871030426e-13,
-1.1834755684648618e-13,
2.2373420583585906e-14,
-2.903359925961166e-15,
2.8992438673072477e-16,
-2.3688164236506415e-17,
1.6475700393177603e-18,
-9.978648706862124e-20,
// [28.,28.5]: m=22 maxabs=1.4388822911231255e-25 maxrel=5.029256911025784e-13
2.3669511368922177e-13,
-8.949368225076955e-14,
1.7420159553196548e-14,
-2.3193984210479655e-15,
2.3688170141331507e-16,
-1.9738780832581064e-17,
1.3967339718341541e-18,
-8.582467171166275e-20,
// [28.,28.5]: m=23 maxabs=1.2707602550024235e-25 maxrel=5.841057417854979e-13
1.789873645014402e-13,
-6.968063814020119e-14,
1.3916390538196778e-14,
-1.8950565322637787e-15,
1.9738766604475914e-16,
-1.6732740990348284e-17,
1.2019648614940893e-18,
-7.484215465787257e-20,
// [28.,28.5]: m=24 maxabs=1.1326780421525376e-25 maxrel=6.653225304958784e-13
1.3936127628035076e-13,
-5.566556208831034e-14,
1.1370339198507034e-14,
-1.5791039071191485e-15,
1.6732734430716993e-16,
-1.439882406463879e-17,
1.0479999867873677e-18,
-6.600810577996601e-20,
// [28.,28.5]: m=25 maxabs=1.02539295904248e-25 maxrel=7.505592379612243e-13
1.113311241765642e-13,
-4.5481356736600165e-14,
9.474623447288991e-15,
-1.3386210512124412e-15,
1.439881807219039e-16,
-1.2553950765015582e-17,
9.243040853090012e-19,
-5.879731371852832e-20,
// [28.,28.5]: m=26 maxabs=9.232828034706722e-26 maxrel=8.238294098786583e-13
9.096271347312729e-14,
-3.7898493737184194e-14,
8.031726315482807e-15,
-1.1519075132271312e-15,
1.2553940737737643e-16,
-1.107182426456161e-17,
8.234614057246607e-19,
-5.2856825715119855e-20,
// [28.,28.5]: m=27 maxabs=8.422510112863699e-26 maxrel=8.986782928538049e-13
7.57969874743288e-14,
-3.21269052151673e-14,
6.911445083127818e-15,
-1.004317129529623e-15,
1.1071819254467535e-16,
-9.863580401621995e-18,
7.401557247265005e-19,
-4.7882930798876236e-20,
// [28.,28.5]: m=28 maxabs=7.733361226062623e-26 maxrel=9.703045834065265e-13
6.425381043029808e-14,
-2.7645780289850774e-14,
6.025902780644927e-15,
-8.857472466930184e-16,
9.863575794195548e-17,
-8.865488529517691e-18,
6.705082099889319e-19,
-4.367909494097895e-20,
// [28.,28.5]: m=29 maxabs=7.138875647888068e-26 maxrel=1.0379829538269827e-12
5.529156057966776e-14,
-2.4103611083423422e-14,
5.314483483376138e-15,
-7.890876296914836e-16,
8.8654842471096e-17,
-8.03106399279273e-18,
6.116442290774765e-19,
-4.0090992832304835e-20,
// [28.,28.5]: m=30 maxabs=6.782941607452348e-26 maxrel=1.128351421551359e-12
4.820722216680852e-14,
-2.1257933897482412e-14,
4.734525780984776e-15,
-7.092401837014879e-16,
8.031060142716578e-17,
-7.325863484250165e-18,
5.613982029395943e-19,
-3.6984965245887974e-20,
// [28.,28.5]: m=31 maxabs=6.170785545000843e-26 maxrel=1.1613653417375403e-12
4.2515867794702576e-14,
-1.893810309108844e-14,
4.255441114147675e-15,
-6.424861406087051e-16,
7.325851254949095e-17,
-6.723948717295935e-18,
5.181313442599499e-19,
-3.431773612695154e-20,
// [28.,28.5]: m=32 maxabs=5.770044205148569e-26 maxrel=1.2165779197574317e-12
3.7876206182149094e-14,
-1.7021764425366726e-14,
3.854916846292461e-15,
-5.860693493110273e-16,
6.723945206836653e-17,
-6.205586876031049e-18,
4.805604868193509e-19,
-3.197066628279207e-20,
// [28.,28.5]: m=33 maxabs=5.420421051954616e-26 maxrel=1.2693073310380407e-12
3.404352885070752e-14,
-1.5419667355965862e-14,
3.5164160983324277e-15,
-5.379167846794977e-16,
6.205583596859928e-17,
-5.755511947995474e-18,
4.476941033972016e-19,
-2.990337229138976e-20,
// [28.,28.5]: m=34 maxabs=5.103614512417858e-26 maxrel=1.3172362097883973e-12
3.083933471190731e-14,
-1.4065664365914287e-14,
3.227500710403654e-15,
-4.964477843248125e-16,
5.755508850822386e-17,
-5.361802376535411e-18,
4.1874626283750063e-19,
-2.807112920348521e-20,
// [28.,28.5]: m=35 maxabs=4.822148941435001e-26 maxrel=1.3624941333382348e-12
2.81313287318054e-14,
-1.2910002815795177e-14,
2.978686708157661e-15,
-4.604417408291414e-16,
5.3617994368844814e-17,
-5.015040792881571e-18,
3.930897897651999e-19,
-2.6437900280506355e-20,
// [28.,28.5]: m=36 maxabs=4.5684512743159236e-26 maxrel=1.4045991337129119e-12
2.5820005631568443e-14,
-1.1914746808240148e-14,
2.7626504470612044e-15,
-4.289449305455981e-16,
5.0150380162473833e-17,
-4.707711963431413e-18,
3.7021938094044775e-19,
-2.497428482373552e-20,
// [28.,28.5]: m=37 maxabs=4.3368417125430345e-26 maxrel=1.4431389730986408e-12
2.3829493616459457e-14,
-1.1050601765142262e-14,
2.5736695852566996e-15,
-4.012039653924094e-16,
4.7077093247419064e-17,
-4.433761392552773e-18,
3.497243495424507e-19,
-2.3656244590903e-20,
// [28.,28.5]: m=38 maxabs=4.1279513448405106e-26 maxrel=1.4795347850729998e-12
2.2101203530264658e-14,
-1.0294678319088274e-14,
2.4072237942491214e-15,
-3.766176235075246e-16,
4.4337588698860045e-17,
-4.188268067077651e-18,
3.3126809701588337e-19,
-2.2464000367648746e-20,
// [28.,28.5]: m=39 maxabs=3.938624727587468e-26 maxrel=1.5139347805340313e-12
2.058935663815763e-14,
-9.62889515611539e-15,
2.259705742845948e-15,
-3.547015448148825e-16,
4.188265670254589e-17,
-3.967199179348966e-18,
3.1457264186841546e-19,
-2.138093885140026e-20,
// [28.,28.5]: m=40 maxabs=3.76412869535258e-26 maxrel=1.5456060801222851e-12
1.9257790312212626e-14,
-9.038822951467244e-15,
2.1282092706184477e-15,
-3.3506205026544883e-16,
3.9671968778674135e-17,
-3.7672240818858336e-18,
2.9940673590004e-19,
-2.0393295544573037e-20
},
{
// [28.5,29.]: m=0 maxabs=8.326672684688674e-17 maxrel=5.015901304738643e-16
0.16528217383537228,
-0.0014372362942139325,
0.000018746560359811043,
-2.716892827485385e-7,
4.134386702248531e-9,
-6.46925053851639e-11,
1.0714997386553305e-12,
-6.803172943843368e-14,
// [28.5,29.]: m=1 maxabs=0. maxrel=0.
0.002874472588435023,
-0.00007498624143459424,
1.6301356826577528e-6,
-3.3075216663901234e-8,
6.47123695650184e-10,
-1.2379493746033159e-11,
2.335047380204573e-13,
-4.9606469382191225e-15,
// [28.5,29.]: m=2 maxabs=1.0842021724855044e-19 maxrel=7.073204574619102e-16
0.00014997248286918857,
-6.520542730602507e-6,
1.984512997883129e-7,
-5.17699032334722e-9,
1.2379756276922671e-10,
-2.7988028158013596e-12,
6.089526302842872e-14,
-1.5059106776736621e-15,
// [28.5,29.]: m=3 maxabs=5.082197683525802e-21 maxrel=3.7797436966303107e-16
0.00001304108546120585,
-7.938051991462957e-7,
3.106194186538063e-8,
-9.903806378613835e-10,
2.798900166248345e-11,
-7.301385601941856e-13,
1.7995840214562076e-14,
-4.4153079611939175e-16,
// [28.5,29.]: m=4 maxabs=2.117582368135751e-22 maxrel=1.2824130456422456e-16
1.5876103982926531e-6,
-1.2424776746104807e-7,
5.942283820738749e-9,
-2.2391202576766265e-10,
7.301463960898413e-12,
-2.1586675488286362e-13,
5.9460460954675535e-15,
-1.5778843497683592e-16,
// [28.5,29.]: m=5 maxabs=2.117582368135751e-22 maxrel=8.121949518266413e-16
2.484955349221031e-7,
-2.3769135282868555e-8,
1.3434721537954814e-9,
-5.841171447415986e-11,
2.1586788406716475e-12,
-7.132849884369137e-14,
2.1716671445496103e-15,
-6.26309358131739e-17,
// [28.5,29.]: m=6 maxabs=0. maxrel=0.
4.7538270565724185e-8,
-5.373888615143363e-9,
3.5047028661453657e-10,
-1.7269432027811884e-11,
7.132877706786373e-13,
-2.604894502698657e-14,
8.685784586657915e-16,
-2.7157733994265585e-17,
// [28.5,29.]: m=7 maxabs=4.963083675318166e-24 maxrel=4.3249947709758216e-16
1.0747777230287104e-8,
-1.4018811464444161e-9,
1.0361659210551028e-10,
-5.706302682521699e-12,
2.6049022346678606e-13,
-1.0418198835307813e-14,
3.777566862306828e-16,
-1.2371826560298273e-17,
// [28.5,29.]: m=8 maxabs=2.895132143935597e-24 maxrel=9.587095100403935e-16
2.8037622928899266e-9,
-4.144663683998954e-10,
3.423781605755604e-11,
-2.083922639945767e-12,
1.0418132233400732e-13,
-4.52813838498419e-15,
1.7717373417613208e-16,
-6.385622378180828e-18,
// [28.5,29.]: m=9 maxabs=3.5155176033503676e-24 maxrel=3.903349177932693e-15
8.28932736799821e-10,
-1.3695126422662806e-10,
1.2503535836107e-11,
-8.334507178114684e-13,
4.5281432734324886e-14,
-2.124778062966534e-15,
8.9240483539619e-17,
-3.430704936999569e-18,
// [28.5,29.]: m=10 maxabs=1.34416849539867e-24 maxrel=4.477480848427473e-15
2.7390252845326713e-10,
-5.001414334250713e-11,
5.00070430575243e-12,
-3.6225153767613845e-13,
2.1247795003028605e-14,
-1.0701626278688025e-15,
4.7987048665766886e-17,
-1.926424034249438e-18,
// [28.5,29.]: m=11 maxabs=1.370017889540952e-24 maxrel=1.2387701022310654e-14
1.0002828668496745e-10,
-2.0002817222778618e-11,
2.173509234978267e-12,
-1.6998238466900617e-13,
1.0701484815106942e-14,
-5.754702026897983e-16,
2.7422798401504032e-17,
-1.1839036647433905e-18,
// [28.5,29.]: m=12 maxabs=9.17653492051015e-25 maxrel=2.056656803750755e-14
4.000563444555539e-11,
-8.69403693917042e-12,
1.0198943079079737e-12,
-8.561190808873914e-14,
5.754703433759056e-15,
-3.2879064276597347e-16,
1.6570221422385454e-17,
-7.529482848141214e-19,
// [28.5,29.]: m=13 maxabs=6.526972020926234e-25 maxrel=3.336514482919487e-14
1.738807387834112e-11,
-4.0795772311384115e-12,
5.136714485024643e-13,
-4.6037647140769256e-14,
3.2879068030316863e-15,
-1.9865419229927118e-16,
1.0540121656772774e-17,
-5.019127236382342e-19,
// [28.5,29.]: m=14 maxabs=4.733670302305412e-25 maxrel=5.112523664823737e-14
8.159154462276022e-12,
-2.054685793667319e-12,
2.762258828293325e-13,
-2.6303268093634502e-14,
1.9865421214242254e-15,
-1.2635042603048495e-16,
7.02616235593639e-18,
-3.490724849538572e-19,
// [28.5,29.]: m=15 maxabs=3.5785255015721803e-25 maxrel=7.608466692049162e-14
4.1093715873346556e-12,
-1.104903531070413e-12,
1.5781960855992953e-13,
-1.5892346834590884e-14,
1.2635042799809399e-15,
-8.421932372599455e-17,
4.88696231978014e-18,
-2.5223081146847724e-19,
// [28.5,29.]: m=16 maxabs=2.762653998956401e-25 maxrel=1.0831376676202184e-13
2.2098070621406068e-12,
-6.31278434055281e-13,
9.535408101290777e-14,
-1.010804161068957e-14,
8.421931648977206e-16,
-5.857280994187044e-17,
3.531463926169864e-18,
-1.8859214831971667e-19,
// [28.5,29.]: m=17 maxabs=2.205276437763443e-25 maxrel=1.500895353053009e-13
1.262556868110625e-12,
-3.814163239095022e-13,
6.06482496694654e-14,
-6.737551000650876e-15,
5.857280266182019e-16,
-4.2323047504015305e-17,
2.6405255295637648e-18,
-1.4534368956875935e-19,
// [28.5,29.]: m=18 maxabs=1.7882530088274072e-25 maxrel=1.9983859366529376e-13
7.62832647818948e-13,
-2.4259299856542233e-13,
4.0425306009346996e-14,
-4.685828708564846e-15,
4.2323040158481214e-16,
-3.1643157792390394e-17,
2.0350483032906467e-18,
-1.1504713062694575e-19,
// [28.5,29.]: m=19 maxabs=1.48230119534649e-25 maxrel=2.5846164802468107e-13
4.851859971307897e-13,
-1.6170122394629265e-13,
2.8114972256472287e-14,
-3.3858468552862375e-15,
3.1643151082358954e-16,
-2.438561572220262e-17,
1.6108732751687025e-18,
-9.322845033073028e-20,
// [28.5,29.]: m=20 maxabs=1.2445069640766682e-25 maxrel=3.2321207714748727e-13
3.234024478925525e-13,
-1.1245988895088104e-13,
2.0315081136946144e-14,
-2.5314550954251633e-15,
2.4385609059221578e-16,
-1.9301579840876497e-17,
1.305406842311553e-18,
-7.708036147992991e-20,
// [28.5,29.]: m=21 maxabs=1.0678021213071616e-25 maxrel=3.960638225977527e-13
2.2491977790111758e-13,
-8.126032448235481e-14,
1.5188730598639178e-14,
-1.950851293268965e-15,
1.9301553969473333e-16,
-1.5640418493767407e-17,
1.0798332452798883e-18,
-6.495015499727682e-20,
// [28.5,29.]: m=22 maxabs=9.271955535605684e-26 maxrel=4.7299235791654e-13
1.625206489615712e-13,
-6.075492233968509e-14,
1.1705107763273248e-14,
-1.5441264882339114e-15,
1.564041354999506e-16,
-1.2937160558772694e-17,
9.094605480505834e-19,
-5.556921806100617e-20,
// [28.5,29.]: m=23 maxabs=8.138520186984135e-26 maxrel=5.52134317316345e-13
1.2150984467933526e-13,
-4.6820431006020385e-14,
9.264758932776938e-15,
-1.2512349669874344e-15,
1.2937156065395128e-16,
-1.089545039204834e-17,
7.781126687189378e-19,
-4.820200726994736e-20,
// [28.5,29.]: m=24 maxabs=7.224703714376115e-26 maxrel=6.327262742559087e-13
9.364086201200869e-14,
-3.7059035689781666e-14,
7.507409804996841e-15,
-1.0349741382786607e-15,
1.0895446296633359e-16,
-9.321482596599205e-18,
6.749590075910912e-19,
-4.231873255187236e-20,
// [28.5,29.]: m=25 maxabs=6.58477974806083e-26 maxrel=7.251928529705454e-13
7.411807137953098e-14,
-3.002963918333792e-14,
6.209844832412811e-15,
-8.716371698055965e-16,
9.32147895360926e-17,
-8.085432514316316e-18,
5.925790850898653e-19,
-3.753734982211126e-20,
// [28.5,29.]: m=26 maxabs=5.852716828015731e-26 maxrel=7.921395376215163e-13
6.00592783666033e-14,
-2.4839379296975955e-14,
5.229823025647921e-15,
-7.457196246625337e-16,
8.085423771675408e-17,
-7.098359192781745e-18,
5.257912884547791e-19,
-3.3628232508111756e-20,
// [28.5,29.]: m=27 maxabs=5.321340122258857e-26 maxrel=8.674804441778399e-13
4.9678758593927625e-14,
-2.0919292072938375e-14,
4.474317750298848e-15,
-6.468350878729026e-16,
7.098356091854293e-17,
-6.2981084276303105e-18,
4.708944992294132e-19,
-3.0365610880997605e-20,
// [28.5,29.]: m=28 maxabs=4.872636039369146e-26 maxrel=9.400721461166406e-13
4.183858414585422e-14,
-1.78972709742242e-14,
3.881010529389614e-15,
-5.678695662139549e-16,
6.298105559795692e-17,
-5.6403766784359244e-18,
4.252102438939668e-19,
-2.761986302476323e-20,
// [28.5,29.]: m=29 maxabs=4.490196272517999e-26 maxrel=1.0095991724232393e-12
3.5794541948427626e-14,
-1.5524042092865638e-14,
3.4072173992730598e-15,
-5.038494324839827e-16,
5.640374024688677e-17,
-5.093040952281845e-18,
3.867629960711078e-19,
-2.5285389797048393e-20,
// [28.5,29.]: m=30 maxabs=4.19926437067249e-26 maxrel=1.0856975666135158e-12
3.1048084185710676e-14,
-1.362886957433912e-14,
3.0230965968648557e-15,
-4.512308321231509e-16,
5.093038358660819e-17,
-4.632418665377025e-18,
3.5407709282378583e-19,
-2.3296882665766424e-20,
// [28.5,29.]: m=31 maxabs=3.8635251694104274e-26 maxrel=1.1351709837015425e-12
2.725773914869272e-14,
-1.2092386366001486e-14,
2.707384990330171e-15,
-4.0744392002641274e-16,
4.6324228637711496e-17,
-4.240814138763875e-18,
3.26023328440207e-19,
-2.15484331160697e-20,
// [28.5,29.]: m=32 maxabs=3.6079342361188196e-26 maxrel=1.192318854232404e-12
2.418477273198605e-14,
-1.0829539941753566e-14,
2.4446635217771935e-15,
-3.705946117708212e-16,
4.240811980439606e-17,
-3.904766304493146e-18,
3.017471078298476e-19,
-2.0036421489855834e-20,
// [28.5,29.]: m=33 maxabs=3.382004472863522e-26 maxrel=1.2457075629856499e-12
2.1659079883491162e-14,
-9.778654068838875e-15,
2.2235676721531288e-15,
-3.392656892266808e-16,
3.9047642661796235e-17,
-3.613949656156485e-18,
2.8057513849220664e-19,
-1.8708463290698612e-20,
// [28.5,29.]: m=34 maxabs=3.1806871698511196e-26 maxrel=1.295344555831172e-12
1.955730813766279e-14,
-8.894270671489384e-15,
2.0355941367933116e-15,
-3.1238182622531834e-16,
3.613947743968645e-17,
-3.3603262534200275e-18,
2.6197969348283135e-19,
-1.7534528762489338e-20,
// [28.5,29.]: m=35 maxabs=3.001457972184906e-26 maxrel=1.3419348721303831e-12
1.7788541342964634e-14,
-8.142376531069732e-15,
1.8742909587060643e-15,
-2.8911646366895687e-16,
3.360324446563853e-17,
-3.1375724021152917e-18,
2.4554123792778905e-19,
-1.6490571928646128e-20,
// [28.5,29.]: m=36 maxabs=2.82853966176046e-26 maxrel=1.3795957880593985e-12
1.62847530621464e-14,
-7.49716381967835e-15,
1.7346987829289504e-15,
-2.6882656273245857e-16,
3.1375708969335466e-17,
-2.9406641490851284e-18,
2.3091912951553387e-19,
-1.555241532927996e-20,
// [28.5,29.]: m=37 maxabs=2.6919089529761807e-26 maxrel=1.424270204255406e-12
1.4994327639251606e-14,
-6.9387951188378635e-15,
1.6129593817182972e-15,
-2.510062296274896e-16,
2.940659333952116e-17,
-2.7655565702278885e-18,
2.178521521644477e-19,
-1.4718316166045242e-20,
// [28.5,29.]: m=38 maxabs=2.561273587071581e-26 maxrel=1.46264560985648e-12
1.3877590237663656e-14,
-6.451837513239818e-15,
1.5060373789221766e-15,
-2.3525329205536114e-16,
2.765555025822707e-17,
-2.6089905098551066e-18,
2.0610586404811728e-19,
-1.39609439577857e-20,
// [28.5,29.]: m=39 maxabs=2.440420096391722e-26 maxrel=1.4973743153199871e-12
1.2903675026468025e-14,
-6.0241495027255625e-15,
1.41151975344268e-15,
-2.2124492058929209e-16,
2.6089890288229453e-17,
-2.468292541085681e-18,
1.9550062029743117e-19,
-1.3274214378916121e-20,
// [28.5,29.]: m=40 maxabs=2.330295114022869e-26 maxrel=1.5299771297990017e-12
1.2048299005440067e-14,
-5.6460790014182944e-15,
1.3274695245942833e-15,
-2.0871961640304403e-16,
2.4682911288526436e-17,
-2.3412640835237698e-18,
1.858842115821747e-19,
-1.2649016409683066e-20
},
{
// [29.,29.5]: m=0 maxabs=0. maxrel=0.
0.16386341648294103,
-0.001400542021216538,
0.00001795566693872545,
-2.557787410727007e-7,
3.82574658837411e-9,
-5.878224889019997e-11,
9.240976582053909e-13,
-1.8141794516915647e-13,
// [29.,29.5]: m=1 maxabs=8.673617379884035e-19 maxrel=3.05690760227456e-16
0.002801084042439454,
-0.00007182266775315808,
1.5346723874908046e-6,
-3.0606002115158474e-8,
5.885767397669341e-10,
-1.1066251052120685e-11,
2.0542393303089544e-13,
-5.66931078653614e-15,
// [29.,29.5]: m=2 maxabs=5.421010862427522e-20 maxrel=3.693763352858856e-16
0.00014364533550632728,
-6.138689549858875e-6,
1.8363601175230862e-7,
-4.708615627510186e-9,
1.106725768005093e-10,
-2.459300236312516e-12,
5.256846281070376e-14,
-1.2844532250745941e-15,
// [29.,29.5]: m=3 maxabs=6.776263578034403e-21 maxrel=5.3559568635018805e-16
0.000012277379099718676,
-7.345440470079414e-7,
2.825169369250487e-8,
-8.853806439245258e-10,
2.4593896627350255e-11,
-6.306071033280572e-13,
1.5276757929369142e-14,
-3.667889058672063e-16,
// [29.,29.5]: m=4 maxabs=6.352747104407253e-22 maxrel=4.1604307898482234e-16
1.4690880940158883e-6,
-1.1300677476958941e-7,
5.3122838607769096e-9,
-1.9675118367468476e-10,
6.3061184471265326e-12,
-1.832528196467798e-13,
4.961771526845602e-15,
-1.2958721249742337e-16,
// [29.,29.5]: m=5 maxabs=5.293955920339377e-23 maxrel=2.234305465533556e-16
2.2601354953918433e-7,
-2.1249135442992184e-8,
1.1805071013244588e-9,
-5.044895090313181e-11,
1.8325384279264613e-12,
-5.951724997697471e-14,
1.7810564238349554e-15,
-5.0476727965451625e-17,
// [29.,29.5]: m=6 maxabs=3.2425480012078685e-22 maxrel=7.215791764510828e-15
4.2498270885969716e-8,
-4.722028405278696e-9,
3.0269370528896725e-10,
-1.4660308109320365e-11,
5.951741748255829e-13,
-2.1366530709058213e-14,
7.010958534616575e-16,
-1.6420075281820542e-17,
// [29.,29.5]: m=7 maxabs=4.963083675318166e-24 maxrel=4.927583648833377e-16
9.444056810545515e-9,
-1.2107748210012528e-9,
8.796185004457201e-11,
-4.76139709523992e-12,
2.1364348137408308e-13,
-8.398989227590754e-15,
2.9942037013118247e-16,
-9.37923134512288e-18,
// [29.,29.5]: m=8 maxabs=4.963083675318166e-24 maxrel=1.9053355521288764e-15
2.421549642005411e-9,
-3.518474001128689e-10,
2.8568382700247044e-11,
-1.7091489294899055e-12,
8.398780402646758e-14,
-3.588337085245711e-15,
1.3802061344425402e-16,
-4.889662687848684e-18,
// [29.,29.5]: m=9 maxabs=2.3781442610899546e-24 maxrel=3.1148679250077782e-15
7.036948002257646e-10,
-1.1427353079837136e-10,
1.0254893574402414e-11,
-6.719025346716185e-13,
3.588340368587046e-14,
-1.6552737002787869e-15,
6.835225510659492e-17,
-2.5854049222342973e-18,
// [29.,29.5]: m=10 maxabs=1.4475660719677984e-24 maxrel=5.787910999761087e-15
2.2854706159675392e-10,
-4.1019574296169625e-11,
4.031415206929623e-12,
-2.8706728657072504e-13,
1.6552751410470856e-14,
-8.196813750710139e-16,
3.6150261280065253e-17,
-1.452495083336668e-18,
// [29.,29.5]: m=11 maxabs=3.2182495707141233e-24 maxrel=3.554126665004152e-14
8.203914859234156e-11,
-1.6125660826855542e-11,
1.7224037191828745e-12,
-1.3242204572286466e-13,
8.19681679427542e-15,
-4.334726331450079e-16,
2.032561468237862e-17,
-8.817739585364996e-19,
// [29.,29.5]: m=12 maxabs=6.333101564859118e-25 maxrel=1.7639360593909728e-14
3.225132165374475e-11,
-6.889614875758999e-12,
7.945322701968507e-13,
-6.557456760345457e-14,
4.33479418574649e-15,
-2.436449223901025e-16,
1.2085171088414997e-17,
-5.408788071691638e-19,
// [29.,29.5]: m=13 maxabs=4.588267460255075e-25 maxrel=2.965692978952649e-14
1.3779229751518359e-11,
-3.1781290804374768e-12,
3.9344740558443033e-13,
-3.467836742037688e-14,
2.4364497123383084e-15,
-1.4488860445480344e-16,
7.570712053291851e-18,
-3.553279141494221e-19,
// [29.,29.5]: m=14 maxabs=2.617251156906064e-25 maxrel=3.636232400694077e-14
6.356258160874278e-12,
-1.5737896220959065e-12,
2.0807020450703367e-13,
-1.949160730159754e-14,
1.4488862141047822e-15,
-9.075668068683951e-17,
4.9740664323506266e-18,
-2.4454583388321056e-19,
// [29.,29.5]: m=15 maxabs=2.4516534756820693e-25 maxrel=6.820636044224525e-14
3.1475792441976214e-12,
-8.322808178660256e-13,
1.1694964340611e-13,
-1.1591096607779056e-14,
9.075708951742538e-16,
-5.962286531180845e-17,
3.4127763476093787e-18,
-1.7393069739495657e-19,
// [29.,29.5]: m=16 maxabs=8.205607442719026e-23 maxrel=4.280902715182563e-11
1.6645616358631764e-12,
-4.677985715860929e-13,
6.954656935783035e-14,
-7.260659059703797e-15,
5.962563886761071e-16,
-4.034469235871991e-17,
2.43484966749207e-18,
-1.2040747509207962e-18,
// [29.,29.5]: m=17 maxabs=1.4762427435943927e-25 maxrel=1.3590843701492635e-13
9.355971469973884e-13,
-2.781863185051577e-13,
4.3563433116151375e-14,
-4.7698327107521275e-15,
4.090509911513357e-16,
-2.918513922963059e-17,
1.7997555530070875e-18,
-9.802174390125565e-20,
// [29.,29.5]: m=18 maxabs=1.2843917714446426e-25 maxrel=1.9727028196234156e-13
5.563726370102297e-13,
-1.7425373239028072e-13,
2.861899626733087e-14,
-3.2724109219644365e-15,
2.918513496467304e-16,
-2.1568299604408445e-17,
1.3724478190778976e-18,
-7.675292163928319e-20,
// [29.,29.5]: m=19 maxabs=9.738961191496523e-26 maxrel=2.3698079353175803e-13
3.485074647790386e-13,
-1.14475985013493e-13,
1.963446559208223e-14,
-2.334813134972503e-15,
2.1568242216585464e-16,
-1.6446475335533424e-17,
1.0760690896010604e-18,
-6.17453860253034e-20,
// [29.,29.5]: m=20 maxabs=8.153666316364378e-26 maxrel=2.998228102326271e-13
2.28951970026953e-13,
-7.853786231881385e-14,
1.4008878812944412e-14,
-1.725461357535535e-15,
1.6446471207086485e-16,
-1.2893820806778815e-17,
8.645673104704515e-19,
-5.068602084564715e-20,
// [29.,29.5]: m=21 maxabs=6.742551929105032e-26 maxrel=3.5892410060393817e-13
1.5707572463760657e-13,
-5.603551521022787e-14,
1.0352768148187556e-14,
-1.3157193546127523e-15,
1.2893816965661574e-16,
-1.0358898175872911e-17,
7.0972538538683e-19,
-4.241647363305306e-20,
// [29.,29.5]: m=22 maxabs=6.363898694598946e-26 maxrel=4.71798892548529e-13
1.1207103041822314e-13,
-4.141107255708344e-14,
7.894316110129876e-15,
-1.0315067688265324e-15,
1.0358922959122802e-16,
-8.502938219260451e-18,
5.931613705169942e-19,
-3.6827783397464656e-20,
// [29.,29.5]: m=23 maxabs=5.232987700874104e-26 maxrel=5.219043899876288e-13
8.282214511220775e-14,
-3.157726444875294e-14,
6.1890406822456606e-15,
-8.287135746679633e-16,
8.503131555634575e-17,
-7.112541229143112e-18,
5.048752333277538e-19,
-3.110803266380434e-20,
// [29.,29.5]: m=24 maxabs=4.627142525664367e-26 maxrel=6.019802576224069e-13
6.315452889748514e-14,
-2.4756162702438438e-14,
4.9722814499803015e-15,
-6.802515862215739e-16,
7.112538610127763e-17,
-6.048309840138619e-18,
4.355960265364153e-19,
-2.718100268278534e-20,
// [29.,29.5]: m=25 maxabs=4.127320256116334e-26 maxrel=6.816120099161887e-13
4.951232540485811e-14,
-1.9889125776464812e-14,
4.081509519120963e-15,
-5.690040269768509e-16,
6.048307458647219e-17,
-5.218146354490468e-18,
3.806100761601854e-19,
-2.4015163082140997e-20,
// [29.,29.5]: m=26 maxabs=3.7171125854014076e-26 maxrel=7.607887522125543e-13
3.977825155291001e-14,
-1.632603805555668e-14,
3.4140241634812016e-15,
-4.838654337253669e-16,
5.2181442006456555e-17,
-4.55928573634913e-18,
3.3628107212254366e-19,
-2.142652488741622e-20,
// [29.,29.5]: m=27 maxabs=3.3693826983799856e-26 maxrel=8.368832458793413e-13
3.265207611109788e-14,
-1.3656096635092576e-14,
2.903192603831968e-15,
-4.1745228930826e-16,
4.559283765420802e-17,
-4.028141775351284e-18,
3.0003435986519496e-19,
-1.9282594174680892e-20,
// [29.,29.5]: m=28 maxabs=3.0784507965344765e-26 maxrel=9.109733515858674e-13
2.7312193270170887e-14,
-1.1612770398250381e-14,
2.5047137372066953e-15,
-3.64743384309566e-16,
4.0281399704286867e-17,
-3.5938549107018386e-18,
2.7001398418812874e-19,
-1.7486181577023477e-20,
// [29.,29.5]: m=29 maxabs=2.8266463955879295e-26 maxrel=9.806328694136677e-13
2.3225540796487683e-14,
-1.0018854933234895e-14,
2.188460307105551e-15,
-3.2225182128783887e-16,
3.5938532489848664e-17,
-3.234180855151058e-18,
2.448596716468287e-19,
-1.5964976431726198e-20,
// [29.,29.5]: m=30 maxabs=2.6123917737299027e-26 maxrel=1.0476359995837226e-12
2.003770986645759e-14,
-8.753841214100226e-15,
1.933510928887316e-15,
-2.875088327727666e-16,
3.2341793121638334e-17,
-2.932816811046036e-18,
2.2355896855003133e-19,
-1.4664379650973986e-20,
// [29.,29.5]: m=31 maxabs=2.4218029790285062e-26 maxrel=1.1088725012968675e-12
1.750768242818888e-14,
-7.734043702318383e-15,
1.7250529977650385e-15,
-2.587348740564561e-16,
2.932815281883895e-17,
-2.677629941754585e-18,
2.0534992010950781e-19,
-1.353912488365451e-20,
// [29.,29.5]: m=32 maxabs=2.2592976325529778e-26 maxrel=1.1683578340804378e-12
1.546808740463534e-14,
-6.900211978608548e-15,
1.5524092450154966e-15,
-2.3462572032568616e-16,
2.677627715328087e-17,
-2.4594569326159484e-18,
1.8964038287272397e-19,
-1.2567455509592523e-20,
// [29.,29.5]: m=33 maxabs=2.1144627703544e-26 maxrel=1.2232532534119818e-12
1.3800423957207172e-14,
-6.20963696862212e-15,
1.4077543229007597e-15,
-2.1421067480131824e-16,
2.4594556721244768e-17,
-2.2712919891908792e-18,
1.759846799905632e-19,
-1.1713394086609382e-20,
// [29.,29.5]: m=34 maxabs=1.9863517593465077e-26 maxrel=1.2747584723487392e-12
1.2419273937234925e-14,
-5.631017280898392e-15,
1.2852640496986066e-15,
-1.967568819323163e-16,
2.2712908025902868e-17,
-2.107705922741341e-18,
1.640254688378951e-19,
-1.0960420123878809e-20,
// [29.,29.5]: m=35 maxabs=1.8718091559084168e-26 maxrel=1.3226658079495022e-12
1.1262034561787963e-14,
-5.1410561887421564e-15,
1.1805412924351103e-15,
-1.8170366627868461e-16,
2.1077048026437485e-17,
-1.964445860903397e-18,
1.534817019121342e-19,
-1.0292479767409657e-20,
// [29.,29.5]: m=36 maxabs=1.7686261495055085e-26 maxrel=1.3669890364881524e-12
1.0282112377475981e-14,
-4.722165160270248e-15,
1.090221998467468e-15,
-1.6861676300285308e-16,
1.9644448014879292e-17,
-1.8381441239871636e-18,
1.4412860656615002e-19,
-9.696615466188682e-21,
// [29.,29.5]: m=37 maxabs=1.6758561070515175e-26 maxrel=1.4084541886231e-12
9.444330320532592e-15,
-4.3608879849214035e-15,
1.0117005787715753e-15,
-1.571559420389886e-16,
1.8381431195054535e-17,
-1.726107355722618e-18,
1.3578473293572506e-19,
-9.16226859503189e-21,
// [29.,29.5]: m=38 maxabs=1.5914479901928692e-26 maxrel=1.4467151074014773e-12
8.721775969835294e-15,
-4.0468023066082765e-15,
9.429356529520255e-16,
-1.4705178866816156e-16,
1.7261063994011002e-17,
-1.6261614436939083e-18,
1.2830234212308732e-19,
-8.680784458604728e-21,
// [29.,29.5]: m=39 maxabs=1.5150862545674753e-26 maxrel=1.4827067513080734e-12
8.0936046132094e-15,
-3.771742603755435e-15,
8.823107326934977e-16,
-1.3808883403903438e-16,
1.626160531627158e-17,
-1.5365361674710246e-18,
1.2156015721281549e-19,
-8.245004950980357e-21,
// [29.,29.5]: m=40 maxabs=1.4456664949080262e-26 maxrel=1.5165644804989641e-12
7.543485207504051e-15,
-3.529242923108269e-15,
8.285330048864501e-16,
-1.3009314914540798e-16,
1.5365352983276928e-17,
-1.4557784680471048e-18,
1.1545787062113551e-19,
-7.848948870736032e-21
},
{
// [29.5,30.]: m=0 maxabs=2.7755575615628914e-17 maxrel=1.7010469703647858e-16
0.16248057811773134,
-0.0013653830093895002,
0.000017210710204324993,
-2.410463553478474e-7,
3.544773419801834e-9,
-5.365152262838476e-11,
8.957511042727101e-13,
4.535448629228912e-14,
// [29.5,30.]: m=1 maxabs=3.6038880213418167e-16 maxrel=1.3031348735955077e-13
0.002730766018778151,
-0.00006884284081240568,
1.4462782345011215e-6,
-2.83585039830552e-8,
5.357184279058325e-10,
-8.918667405541224e-12,
1.1857717841964496e-12,
-2.255322697268908e-12,
// [29.5,30.]: m=2 maxabs=2.710505431213761e-20 maxrel=1.9275209973818118e-16
0.00013768568161727718,
-5.785112671984917e-6,
1.701503724534008e-7,
-4.28950514946221e-9,
9.91272073940723e-11,
-2.165786065074026e-12,
4.55261158180534e-14,
-9.522670461759922e-16,
// [29.5,30.]: m=3 maxabs=1.6940658945086007e-21 maxrel=1.4215467358809993e-16
0.000011570225343970388,
-6.806014898120796e-7,
2.5737030875031668e-8,
-7.930177163498047e-10,
2.165804023889323e-11,
-5.459968613716955e-13,
1.3005434931149952e-14,
-3.0588810640246263e-16,
// [29.5,30.]: m=4 maxabs=1.0587911840678754e-21 maxrel=7.488505140365729e-16
1.3612029796241685e-6,
-1.0294812349969089e-7,
4.758106295905239e-9,
-1.7326433295630924e-10,
5.460004873590144e-12,
-1.5599858729768049e-13,
4.152889530545764e-15,
-1.0726845360267354e-16,
// [29.5,30.]: m=5 maxabs=7.940933880509066e-23 maxrel=3.681848405319442e-16
2.058962469993849e-7,
-1.9032425183520995e-8,
1.0395859971002901e-9,
-4.368004185527323e-11,
1.5599961382271942e-12,
-4.981435607780729e-14,
1.4656633808683041e-15,
-4.074471100553165e-17,
// [29.5,30.]: m=6 maxabs=1.9852334701272664e-23 maxrel=4.937024319099884e-16
3.8064850367018564e-8,
-4.158343988382253e-9,
2.620802510465582e-10,
-1.2479969888983034e-11,
4.981447605532887e-13,
-1.758101332956274e-14,
5.665372023005417e-16,
-1.7090503116837252e-17,
// [29.5,30.]: m=7 maxabs=1.6543612251060553e-24 maxrel=1.867208466637417e-16
8.316687976761842e-9,
-1.048321004177863e-9,
7.487981930308041e-11,
-3.985158397506647e-12,
1.7581053351637695e-13,
-6.795501647682985e-15,
2.380140464521318e-16,
-7.73425014509196e-18,
// [29.5,30.]: m=8 maxabs=1.6543612251060553e-24 maxrel=7.344361827964502e-16
2.0966420083557866e-9,
-2.9951927720827367e-10,
2.3910950377916892e-11,
-1.4064844224206025e-12,
6.795511326900375e-14,
-2.8547276993677337e-15,
1.0796946294931778e-16,
-3.763046557835725e-18,
// [29.5,30.]: m=9 maxabs=1.4475660719677984e-24 maxrel=2.2303188643938733e-15
5.990385544165697e-10,
-9.564380150972665e-11,
8.438906532094256e-12,
-5.436409832037641e-13,
2.8547308508421384e-14,
-1.294897106972993e-15,
5.258387437193638e-17,
-1.9562874717089146e-18,
// [29.5,30.]: m=10 maxabs=9.822769774067204e-25 maxrel=4.699659261116057e-15
1.912876030194602e-10,
-3.375562612732136e-11,
3.261845898474398e-12,
-2.2837851035471267e-13,
1.2948981269947088e-14,
-6.306005535201324e-16,
2.7355035431851462e-17,
-1.0814196970827747e-18,
// [29.5,30.]: m=11 maxabs=6.591595506281939e-25 maxrel=8.860759273574411e-15
6.75112522546449e-11,
-1.304738359327287e-11,
1.3702710618742704e-12,
-1.0359187505234703e-13,
6.306008931038745e-15,
-3.280223552157396e-16,
1.5129096726702425e-17,
-6.328345403364632e-19,
// [29.5,30.]: m=12 maxabs=4.652890945610781e-25 maxrel=1.6045993081893163e-14
2.6094767186546246e-11,
-5.481084247112059e-12,
6.215512502442671e-13,
-5.0448086770539263e-14,
3.2802245523792726e-15,
-1.814024859866706e-16,
8.856363791672535e-18,
-3.9036042962743266e-19,
// [29.5,30.]: m=13 maxabs=3.1827066537684854e-25 maxrel=2.5908649706924533e-14
1.0962168494224321e-11,
-2.4862050007289126e-12,
3.0268852059859923e-13,
-2.6241806322893116e-14,
1.8140252026514223e-15,
-1.0618145901336812e-16,
5.4639266638750386e-18,
-2.5272910742148966e-19,
// [29.5,30.]: m=14 maxabs=2.8353554199815695e-25 maxrel=5.045985316169153e-14
4.972410001457047e-12,
-1.2107540822260293e-12,
1.5745083792036126e-13,
-1.4512208303360623e-14,
1.0618147731481324e-15,
-6.550306373299307e-17,
3.5376743932305956e-18,
-1.7068979371645675e-19,
// [29.5,30.]: m=15 maxabs=1.6640547479094111e-25 maxrel=6.030752146727096e-14
2.421508164452931e-12,
-6.298033516027458e-13,
8.707324991321814e-14,
-8.494522310741943e-15,
6.550292170214659e-16,
-4.2408800329122984e-17,
2.3941647104212374e-18,
-1.2046057166084763e-19,
// [29.5,30.]: m=16 maxabs=1.683730579716306e-22 maxrel=1.1634582799825374e-10
1.25960670317282e-12,
-3.48293000170432e-13,
5.0967140103963316e-14,
-5.2402306091274365e-15,
4.239693590428643e-16,
-2.8566425841794505e-17,
2.0202547296889414e-18,
-5.903228006021285e-19,
// [29.5,30.]: m=17 maxabs=9.834886677571398e-26 maxrel=1.218964140309176e-13
6.965859991337818e-13,
-2.038685353979841e-13,
3.144142304260414e-14,
-3.392706489072767e-15,
2.8696981022446987e-16,
-2.0213117198700573e-17,
1.2317391481151182e-18,
-6.633581374343513e-20,
// [29.5,30.]: m=18 maxabs=7.845695018966095e-26 maxrel=1.6482238980659184e-13
4.07737070795888e-13,
-1.2576569211873868e-13,
2.0356238934277647e-14,
-2.295760543700546e-15,
2.0213108049653784e-16,
-1.4761340768020538e-17,
9.291432588194054e-19,
-5.151843908503375e-20,
// [29.5,30.]: m=19 maxabs=6.401764018049555e-26 maxrel=2.1634947289133523e-13
2.515313842375388e-13,
-8.142495569703265e-14,
1.3774563264125414e-14,
-1.6170502468765988e-15,
1.476133818160209e-16,
-1.1134333282431833e-17,
7.213413271399136e-19,
-4.1025885551929107e-20,
// [29.5,30.]: m=20 maxabs=5.331437541845686e-26 maxrel=2.762696817688147e-13
1.628499113940454e-13,
-5.50982530238552e-14,
9.702301483109846e-15,
-1.180908359972267e-15,
1.1134330822276035e-16,
-8.643565656742354e-18,
5.744410556819248e-19,
-3.3410784899146125e-20,
// [29.5,30.]: m=21 maxabs=4.5084978455191267e-26 maxrel=3.428790822596123e-13
1.1019650604772067e-13,
-3.880920590532904e-14,
7.085450161529128e-15,
-8.907475500121246e-16,
8.643563389783227e-17,
-6.882885479542626e-18,
4.678236395604997e-19,
-2.775023774715477e-20,
// [29.5,30.]: m=22 maxabs=3.868573879203842e-26 maxrel=4.1501021860518527e-13
7.761841181065224e-14,
-2.8341800623207704e-14,
5.344485301684949e-15,
-6.914859875357481e-16,
6.882883382963949e-17,
-5.605088548774159e-18,
3.8856953932867503e-19,
-2.3450393294006127e-20,
// [29.5,30.]: m=23 maxabs=3.368751609655809e-26 maxrel=4.919157813914535e-13
5.668360124546251e-14,
-2.1377941186957568e-14,
4.1489159265727665e-15,
-5.506314566494017e-16,
5.605086732564299e-17,
-4.6552893958202585e-18,
3.283636681437139e-19,
-2.0119070349860342e-20,
// [29.5,30.]: m=24 maxabs=2.9623304712859435e-26 maxrel=5.703507509465975e-13
4.275588237390242e-14,
-1.6595663689203682e-14,
3.3037887411179735e-15,
-4.48407621983671e-16,
4.655287762446317e-17,
-3.933804202417136e-18,
2.8171936294921087e-19,
-1.749178121904512e-20,
// [29.5,30.]: m=25 maxabs=2.633533245989826e-26 maxrel=6.499239456550191e-13
3.319132737839567e-14,
-1.3215154949442664e-14,
2.690445733009382e-15,
-3.724236220887239e-16,
3.933802727056804e-17,
-3.374862299401369e-18,
2.449321614877787e-19,
-1.538601675883667e-20,
// [29.5,30.]: m=26 maxabs=2.4094967489070585e-26 maxrel=7.434107397617035e-13
2.6430309898875575e-14,
-1.0761782918689042e-14,
2.234541733454962e-15,
-3.147047521236122e-16,
3.374861026438319e-17,
-2.934059599966206e-18,
2.154455487412994e-19,
-1.3670623659416877e-20,
// [29.5,30.]: m=27 maxabs=2.1352886982522348e-26 maxrel=8.057579902653852e-13
2.152356583735478e-14,
-8.938166922159413e-15,
1.8882285149087866e-15,
-2.6998935616838094e-16,
2.934056988379018e-17,
-2.58076526449119e-18,
1.9146631153925582e-19,
-1.2261898616220063e-20,
// [29.5,30.]: m=28 maxabs=1.94438435918875e-26 maxrel=8.802579135227599e-13
1.78763338443101e-14,
-7.552914048808256e-15,
1.619936137845526e-15,
-2.3472499210566893e-16,
2.5807641489455625e-17,
-2.2934388532718946e-18,
1.7170231701652977e-19,
-1.1084522319088647e-20,
// [29.5,30.]: m=29 maxabs=1.78219455707531e-26 maxrel=9.517679288221933e-13
1.5105828097608402e-14,
-6.479744541525281e-15,
1.4083499534097056e-15,
-2.0646152615978133e-16,
2.2934378176515216e-17,
-2.056643267479002e-18,
1.5521648428767474e-19,
-1.0091673820161196e-20,
// [29.5,30.]: m=30 maxabs=1.6430394933943234e-26 maxrel=1.019877731004817e-12
1.2959489083043075e-14,
-5.633399804607719e-15,
1.2387691576745552e-15,
-1.8347538662165117e-16,
2.0566423118845906e-17,
-1.859130403446195e-18,
1.413140439563053e-19,
-9.246045375563317e-21,
// [29.5,30.]: m=31 maxabs=1.5875036856667642e-26 maxrel=1.1305931758536051e-12
1.1266799609208942e-14,
-4.955076622367605e-15,
1.1008523202710823e-15,
-1.6453171755203264e-16,
1.859129601293286e-17,
-1.6925755795136409e-18,
1.2947125933852987e-19,
-8.51499689882402e-21,
// [29.5,30.]: m=32 maxabs=1.4156897805096278e-26 maxrel=1.14368167370741e-12
9.910153244747653e-15,
-4.403409273876986e-15,
9.871903072162263e-16,
-1.487306693961117e-16,
1.6925728509127547e-17,
-1.5507185844250051e-18,
1.1929627473014637e-19,
-7.88943799502235e-21,
// [29.5,30.]: m=33 maxabs=1.3227619658745926e-26 maxrel=1.200084899955336e-12
8.806818547747887e-15,
-3.948761221696506e-15,
8.923840169607706e-16,
-1.3540611479341942e-16,
1.5507178040006793e-17,
-1.4288028930464926e-18,
1.1047714405139185e-19,
-7.339509062917676e-21,
// [29.5,30.]: m=34 maxabs=1.2400893430074306e-26 maxrel=1.2523823692610945e-12
7.89752244338724e-15,
-3.569536061147003e-15,
8.124366893117939e-16,
-1.240576921496728e-16,
1.428802158004855e-17,
-1.3231546580258814e-18,
1.0277665755888004e-19,
-6.856006271010335e-21,
// [29.5,30.]: m=35 maxabs=1.1667252788218765e-26 maxrel=1.3013953516610393e-12
7.139072122288564e-15,
-3.2497467509684938e-15,
7.443461534173322e-16,
-1.1430442376666197e-16,
1.323153965583385e-17,
-1.2309092157320073e-18,
9.600625497739173e-20,
-6.428202128300306e-21,
// [29.5,30.]: m=36 maxabs=1.1010920515074883e-26 maxrel=1.3471189908868666e-12
6.49949350193189e-15,
-2.977384607762881e-15,
6.858265430884408e-16,
-1.0585255349190619e-16,
1.2309085637959568e-17,
-1.1498071960894004e-18,
9.00157092164726e-20,
-6.047450962817249e-21,
// [29.5,30.]: m=37 maxabs=1.1111894710943172e-26 maxrel=1.4819289927159563e-12
5.954769215530109e-15,
-2.743306166780815e-15,
6.351153211786489e-16,
-9.847290802283806e-17,
1.1498067472112712e-17,
-1.0780485284930032e-18,
8.468048882658653e-20,
-5.706497989732021e-21,
// [29.5,30.]: m=38 maxabs=9.887582586040162e-27 maxrel=1.4295113029829698e-12
5.486612333555289e-15,
-2.5404612803907323e-15,
5.90837448696696e-16,
-9.198473704234165e-17,
1.0780478083217893e-17,
-1.0141848242520268e-18,
7.991356990513663e-20,
-5.4004035616627315e-21,
// [29.5,30.]: m=39 maxabs=9.404799712044903e-27 maxrel=1.466745210681257e-12
5.080922560777068e-15,
-2.3633497897825553e-15,
5.519084226754359e-16,
-8.624402482397195e-17,
1.0141842618789086e-17,
-9.57041404450997e-19,
7.562365937033156e-20,
-5.123648602339662e-21,
// [29.5,30.]: m=40 maxabs=8.965404187836799e-27 maxrel=1.5015787691747813e-12
4.726699579560916e-15,
-2.207633685942582e-15,
5.174641493458176e-16,
-8.113493130208574e-17,
9.5704086795157e-18,
-9.056566312396035e-19,
7.17482610793528e-20,
-4.872568336839348e-21
},
{
// [30.,30.5]: m=0 maxabs=5.551115123125783e-17 maxrel=3.4308041032380366e-16
0.16113216826417662,
-0.0013316708120984602,
0.000016508315852455744,
-2.2738726662175179e-7,
3.28865344672196e-9,
-4.894882933095303e-11,
7.540183346093066e-13,
4.535448629228912e-14,
// [30.,30.5]: m=1 maxabs=8.673617379884035e-19 maxrel=3.216378846792597e-16
0.0026633416241965565,
-0.00006603326340775727,
1.3643236240638404e-6,
-2.630927109154922e-8,
4.892218190932542e-10,
-8.893997045321688e-12,
1.596265318334082e-13,
-4.9606469382191225e-15,
// [30.,30.5]: m=2 maxabs=0. maxrel=0.
0.00013206652681859923,
-5.457294496033671e-6,
1.5785562576986893e-7,
-3.913775828548576e-9,
8.894942876260649e-11,
-1.9112484054929723e-12,
3.953569172524861e-14,
-9.301213009160854e-16,
// [30.,30.5]: m=3 maxabs=1.6940658945086007e-21 maxrel=1.5076775846587197e-16
0.000010914588992068184,
-6.314225030710368e-7,
2.348265492242322e-8,
-7.11595579590039e-10,
1.911310004834988e-11,
-4.738706777578842e-13,
1.1100900838797967e-14,
-2.6574894311888157e-16,
// [30.,30.5]: m=4 maxabs=1.8592373192231892e-19 maxrel=1.4182938438270523e-13
1.262845006139196e-6,
-9.393061963688189e-8,
4.2695739826354625e-9,
-1.529057081643352e-10,
4.72841082537949e-12,
-1.38317404818137e-13,
5.013134949689624e-14,
5.784953100065216e-14,
// [30.,30.5]: m=5 maxabs=2.6469779601696886e-23 maxrel=1.3461407128665626e-16
1.878612393785479e-7,
-1.7078293886667594e-8,
9.174288598720733e-10,
-3.79102583904106e-11,
1.3315554538801623e-12,
-4.1816958952464205e-14,
1.2099924819790287e-15,
-3.326187129857095e-17,
// [30.,30.5]: m=6 maxabs=7.345363839470886e-22 maxrel=2.0375676217181078e-14
3.4156587773323594e-8,
-3.66971543949226e-9,
2.2746155025800543e-10,
-1.0652444358260352e-11,
4.181707054963785e-13,
-1.4511640272670457e-14,
4.612083937447411e-16,
-2.1567230918400443e-17,
// [30.,30.5]: m=7 maxabs=3.308722450212111e-24 maxrel=4.2361081674955287e-16
7.3394308789447954e-9,
-9.098462008837225e-10,
6.39146651925303e-11,
-3.345370604200343e-12,
1.451472254056534e-13,
-5.517672192172423e-15,
1.9006967039979272e-16,
-6.0757522548389316e-18,
// [30.,30.5]: m=8 maxabs=8.271806125530277e-25 maxrel=4.236111550856797e-16
1.81969240176748e-9,
-2.55658660766938e-10,
2.007222362003034e-11,
-1.161177924319924e-12,
5.517679813262527e-14,
-2.279715532297928e-15,
8.480413685009437e-17,
-2.910481322076069e-18,
// [30.,30.5]: m=9 maxabs=1.137373342260413e-24 maxrel=2.0557658123794138e-15
5.113173215338987e-10,
-8.028889447853842e-11,
6.967067543292187e-12,
-4.4141444595837753e-13,
2.279719205432096e-14,
-1.0170806740220955e-15,
4.062639772643123e-17,
-1.4873428003155481e-18,
// [30.,30.5]: m=10 maxabs=6.979336418416171e-25 maxrel=3.983696486442133e-15
1.6057778895708219e-10,
-2.786827017237708e-11,
2.6484866750924983e-12,
-1.8237756815539506e-13,
1.017081601479563e-14,
-4.872126287073274e-16,
2.0792328571889627e-17,
-8.091217485926526e-19,
// [30.,30.5]: m=11 maxabs=4.911384887033602e-25 maxrel=8.009752213028427e-15
5.573654034475706e-11,
-1.0593946699904106e-11,
1.094265408653007e-12,
-8.136654651167315e-14,
4.872129960603438e-15,
-2.4933251958740276e-16,
1.1316017295216416e-17,
-4.659984553215156e-19,
// [30.,30.5]: m=12 maxabs=3.2311742677852644e-25 maxrel=1.3747626504413881e-14
2.1187893399808872e-11,
-4.377061634332671e-12,
4.8819927899688e-13,
-3.8977050793351975e-14,
2.4933261792247912e-15,
-1.3568586937123888e-16,
6.52083877999992e-18,
-2.8309018083933897e-19,
// [30.,30.5]: m=13 maxabs=2.2779778587886114e-25 maxrel=2.3264689061826224e-14
8.754123268665617e-12,
-1.9527971158100386e-12,
2.3386230473207495e-13,
-1.9946616508074625e-14,
1.3568590569981885e-15,
-7.818226609064128e-17,
3.962123381002534e-18,
-1.8061017314656183e-19,
// [30.,30.5]: m=14 maxabs=1.5671195198758532e-25 maxrel=3.55787846476241e-14
3.905594231619248e-12,
-9.354492188092662e-13,
1.1967969904914385e-13,
-1.0854877157532088e-14,
7.818227144691029e-16,
-4.750039464695272e-17,
2.5282921210847397e-18,
-1.2020482373794392e-19,
// [30.,30.5]: m=15 maxabs=1.134949961559574e-25 maxrel=5.33503445625989e-14
1.8708984376200906e-12,
-4.787187960766003e-13,
6.512926303150552e-14,
-6.254585540273518e-15,
4.75002574758324e-16,
-3.030630467016217e-17,
1.6872616941433503e-18,
-8.379456944945206e-20,
// [30.,30.5]: m=16 maxabs=8.603001487978266e-26 maxrel=7.838207289090879e-14
9.574375921531945e-13,
-2.6051705206691003e-13,
3.752751324185639e-14,
-3.800022961082655e-15,
3.0306304341453895e-16,
-2.02244626973376e-17,
1.1731360171945043e-18,
-6.045913897175765e-20,
// [30.,30.5]: m=17 maxabs=6.613809829372963e-26 maxrel=1.0984473301413424e-13
5.210341041337454e-13,
-1.501100529233196e-13,
2.2800137767494218e-14,
-2.424506109630905e-15,
2.0224461302325496e-16,
-1.406071778120717e-17,
8.464742277287197e-19,
-4.5100156212110176e-20,
// [30.,30.5]: m=18 maxabs=5.270853024324712e-26 maxrel=1.5073857147614547e-13
3.0022010584664526e-13,
-9.12005510357006e-14,
1.4547036658578923e-14,
-1.6179582633931157e-15,
1.4060716361187455e-16,
-1.0144664691818892e-17,
6.314516040681939e-19,
-3.4709159354197295e-20,
// [30.,30.5]: m=19 maxabs=4.238391871571452e-26 maxrel=1.9799157456324207e-13
1.8240110207219337e-13,
-5.818814661039445e-14,
9.70774955311043e-15,
-1.1248583350596894e-15,
1.0144689465014176e-16,
-7.567306203804547e-18,
4.852902945773611e-19,
-2.7348631008865974e-20,
// [30.,30.5]: m=20 maxabs=3.4987558868362316e-26 maxrel=2.5429695019361266e-13
1.1637629322077575e-13,
-3.883099819085984e-14,
6.749150011587207e-15,
-8.115760202777841e-16,
7.567304556750541e-17,
-5.8151991339691886e-18,
3.829337780691312e-19,
-2.2089566846168467e-20,
// [30.,30.5]: m=21 maxabs=3.19835765412807e-26 maxrel=3.4592876978153584e-13
7.766199638170639e-14,
-2.6996600028539856e-14,
4.869456122895786e-15,
-6.053850768386943e-16,
5.815197496502507e-17,
-4.588367600292997e-18,
3.09306542059734e-19,
-1.8233548163420225e-20,
// [30.,30.5]: m=22 maxabs=2.077291644500386e-25 maxrel=3.2105857130086308e-12
5.399320005729552e-14,
-1.9477824477619085e-14,
3.632310438288584e-15,
-4.652163193784849e-16,
4.588390983036195e-17,
-3.706667869239584e-18,
2.5462633935657725e-19,
-1.3475409619877873e-20,
// [30.,30.5]: m=23 maxabs=2.1311866215450855e-26 maxrel=4.537684221270575e-13
3.895564895145043e-14,
-1.4529241816361426e-14,
2.79129846779878e-15,
-3.6707043203394565e-16,
3.705874003936107e-17,
-3.0552822085923495e-18,
2.1408996357901883e-19,
-1.3044675461901916e-20,
// [30.,30.5]: m=24 maxabs=1.9033635921172573e-26 maxrel=5.402565257068872e-13
2.905848363277468e-14,
-1.1165193859983288e-14,
2.202422590764115e-15,
-2.96470364044967e-16,
3.055283229030106e-17,
-2.5648391856878868e-18,
1.8260486643853942e-19,
-1.1278864959454854e-20,
// [30.,30.5]: m=25 maxabs=1.682482538655374e-26 maxrel=6.182832284728529e-13
2.2330387719958914e-14,
-8.809690353410594e-15,
1.7788221849927338e-15,
-2.4442304411370706e-16,
2.564838223877827e-17,
-2.187555050518487e-18,
1.579348791043423e-19,
-9.875141438137406e-21,
// [30.,30.5]: m=26 maxabs=1.482111868729237e-26 maxrel=6.870937667340035e-13
1.761938070681422e-14,
-7.115288731434676e-15,
1.4665382653420178e-15,
-2.0518739933539513e-16,
2.1875541701402612e-17,
-1.891940872625195e-18,
1.382800589097838e-19,
-8.740265186460303e-21,
// [30.,30.5]: m=27 maxabs=1.3552630351696983e-26 maxrel=7.746774154197807e-13
1.4230577462860747e-14,
-5.866153053712903e-15,
1.2311243966867437e-15,
-1.7500463979314338e-16,
1.8919401950793057e-17,
-1.6564273641247919e-18,
1.223815189306712e-19,
-7.80870595538759e-21,
// [30.,30.5]: m=28 maxabs=1.2309385565068668e-26 maxrel=8.502680827353979e-13
1.1732306107420075e-14,
-4.924497579874886e-15,
1.05002783930104e-15,
-1.513554904644839e-16,
1.6564266426061157e-17,
-1.4659397342415138e-18,
1.0934495934035498e-19,
-7.03571301461924e-21,
// [30.,30.5]: m=29 maxabs=1.1246001064830744e-26 maxrel=9.222866517806585e-13
9.848995159744552e-15,
-4.200111350966272e-15,
9.081329432837748e-16,
-1.3251438090589957e-16,
1.4659390725066537e-17,
-1.3097444460796156e-18,
9.852114908354052e-20,
-6.3866379346203294e-21,
// [30.,30.5]: m=30 maxabs=1.0341966467447465e-26 maxrel=9.914857710801563e-13
8.400222701927702e-15,
-3.632531767435019e-15,
7.950862858938467e-16,
-1.1727535378934915e-16,
1.3097438368091731e-17,
-1.180065211086442e-18,
8.943239673713818e-20,
-5.8359677975979646e-21,
// [30.,30.5]: m=31 maxabs=9.557838727657779e-27 maxrel=1.0566963760462824e-12
7.265063534865529e-15,
-3.180345138335622e-15,
7.036521231638952e-16,
-1.0477971651533359e-16,
1.1800646422398659e-17,
-1.071177012911919e-18,
8.172172447774227e-20,
-5.36441065085972e-21,
// [30.,30.5]: m=32 maxabs=8.871529740115499e-27 maxrel=1.1176496570493208e-12
6.360690276667056e-15,
-2.8146084878137253e-15,
6.286782994893857e-16,
-9.440536503671861e-17,
1.0711764843401621e-17,
-9.788016927446452e-19,
7.511864278342527e-20,
-4.957121771219311e-21,
// [30.,30.5]: m=33 maxabs=8.275939756673635e-27 maxrel=1.175637377876175e-12
5.629216975623536e-15,
-2.51471319346187e-15,
5.664321905926539e-16,
-8.569429855692967e-17,
9.78801197474742e-18,
-8.996976563770616e-19,
6.941553145564108e-20,
-4.602589924042008e-21,
// [30.,30.5]: m=34 maxabs=7.747402950175557e-27 maxrel=1.2295104381760652e-12
5.029426386920086e-15,
-2.2657287581784784e-15,
5.14165791690113e-16,
-7.830426346532444e-17,
8.99697192044407e-18,
-8.313768855919202e-19,
6.445111107182358e-20,
-4.2917666085978585e-21,
// [30.,30.5]: m=35 maxabs=7.277241850663834e-27 maxrel=1.2796754319904634e-12
4.531457516353514e-15,
-2.056663162836409e-15,
4.698255811198404e-16,
-7.197593231094458e-17,
8.313764489748912e-18,
-7.719067231290525e-19,
6.009869520970426e-20,
-4.0174679379194106e-21,
// [30.,30.5]: m=36 maxabs=6.86151215361236e-27 maxrel=1.3272397195878525e-12
4.113326325669554e-15,
-1.879302320793197e-15,
4.3185559417595135e-16,
-6.651026335208114e-17,
7.719063107089401e-18,
-7.197690574874697e-19,
5.625772347017962e-20,
-3.77393700563727e-21,
// [30.,30.5]: m=37 maxabs=6.483647780011496e-27 maxrel=1.3706712187430301e-12
3.758604641583311e-15,
-1.7274223732300978e-15,
3.9906158040609996e-16,
-6.175264379515658e-17,
7.197686668523366e-18,
-6.737589381774841e-19,
5.2847601742182216e-20,
-3.55651968939436e-21,
// [30.,30.5]: m=38 maxabs=6.146804173482124e-27 maxrel=1.4120079433632543e-12
3.4548447464572634e-15,
-1.5962463183413002e-15,
3.705158630501483e-16,
-5.758162466386193e-17,
6.737585666888021e-18,
-6.329106462906226e-19,
4.980314830411889e-20,
-3.361424242642187e-21,
// [30.,30.5]: m=39 maxabs=5.8391484204459294e-27 maxrel=1.4499818321874187e-12
3.1924926366798204e-15,
-1.482063449089177e-15,
3.45489748247857e-16,
-5.390080978177084e-17,
6.329102941467846e-18,
-5.964431592198852e-19,
4.7071193465745206e-20,
-3.1855221361020843e-21,
// [30.,30.5]: m=40 maxabs=5.561469381808133e-27 maxrel=1.485959951833993e-12
2.964126898175704e-15,
-1.3819589900356493e-15,
3.23404858942816e-16,
-5.0632941753806285e-17,
5.964428237662499e-18,
-5.637194463443373e-19,
4.4608029500985514e-20,
-3.026229464978385e-21
}
};
const double cheb_table_nintervals = 61;
