// Dummy reporter of successor states in unfolding -*- c++ -*-

/** @file DummyReporter.C
 * Interface for reporting successor states in unfolding
 */

/* Copyright  2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "DummyReporter.h"

bool
DummyReporter::do_addState (const void*,
			    size_t)
{
  return false;
}

word_t*
DummyReporter::do_popState (bool,
			    size_t&)
{
  return 0;
}

class GlobalMarking*
DummyReporter::pop (bool)
{
  return 0;
}

#ifdef EXPR_COMPILE
bool
DummyReporter::popCompiled (bool)
{
  assert (!!myCompilation);
  return false;
}
#endif // EXPR_COMPILE

bool
DummyReporter::report (const class Transition&,
		       const class Valuation&,
		       const class GlobalMarking&,
		       bool)
{
  return true;
}

void
DummyReporter::reportError (bool)
{
}

#ifdef EXPR_COMPILE
bool
DummyReporter::report (const void*,
		       size_t,
		       bool,
		       bool)
{
  return true;
}
#endif // EXPR_COMPILE

void
DummyReporter::reject ()
{
}
