# coding=utf8

import fluent.syntax.ast as FTL
from fluent.migrate import COPY, REPLACE
from fluent.migrate.helpers import MESSAGE_REFERENCE


def migrate(ctx):
    """Bug 1291693 - Migrate the menubar to FTL, part {index}"""

    ctx.add_transforms('browser/menubar.ftl', 'menubar.ftl', [
        FTL.Message(
            id=FTL.Identifier('file-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fileMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fileMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('tab-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'tabCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'tabCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('tab-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'tabCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('new-user-context-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newUserContext.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newUserContext.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('new-navigator-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newNavigatorCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newNavigatorCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('new-navigator-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newNavigatorCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('new-private-window-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newPrivateWindow.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newPrivateWindow.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('new-non-remote-window-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'newNonRemoteWindow.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('open-location-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'openLocationCmd.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('open-file-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'openFileCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'openFileCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('open-file-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'openFileCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('close-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'closeCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'closeCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('close-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'closeCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('close-window-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'closeWindow.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'closeWindow.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('save-page-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'savePageCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'savePageCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('save-page-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'savePageCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('email-page-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'emailPageCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'emailPageCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('print-setup-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'printSetupCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'printSetupCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('print-preview-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'printPreviewCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'printPreviewCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('print-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'printCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'printCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('print-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'printCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('go-offline-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'goOfflineCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'goOfflineCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('quit-application-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'quitApplicationCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'quitApplicationCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('quit-application-menuitem-win'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'quitApplicationCmdWin2.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'quitApplicationCmdWin2.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('quit-application-menuitem-mac'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'quitApplicationCmdMac2.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('quit-application-command-unix'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'quitApplicationCmdUnix.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('edit-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'editMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'editMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('undo-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'undoCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'undoCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('undo-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'undoCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('redo-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'redoCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'redoCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('redo-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'redoCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('cut-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'cutCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'cutCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('cut-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'cutCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('copy-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'copyCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'copyCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('copy-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'copyCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('paste-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pasteCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pasteCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('paste-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pasteCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('delete-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'deleteCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'deleteCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('select-all-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'selectAllCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'selectAllCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('select-all-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'selectAllCmd.key',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('find-on-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findOnCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findOnCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('find-on-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findOnCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('find-again-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findAgainCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findAgainCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('find-again-command1'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findAgainCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('find-again-command2'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findAgainCmd.commandkey2',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('find-selection-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'findSelectionCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('bidi-switch-text-direction-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bidiSwitchTextDirectionItem.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bidiSwitchTextDirectionItem.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('bidi-switch-text-direction-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bidiSwitchTextDirectionItem.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('preferences-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'preferencesCmd2.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'preferencesCmd2.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('preferences-menuitem-unix'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'preferencesCmdUnix.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'preferencesCmdUnix.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-toolbar-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewToolbarsMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewToolbarsMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-sidebar-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewSidebarMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewSidebarMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-customize-toolbar-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewCustomizeToolbar.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'viewCustomizeToolbar.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoom.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoom.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-enlarge-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomEnlargeCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomEnlargeCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-enlarge-command1'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomEnlargeCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-enlarge-command2'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomEnlargeCmd.commandkey2',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-enlarge-command3'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomEnlargeCmd.commandkey3',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-reduce-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomReduceCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomReduceCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-reduce-command1'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomReduceCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-reduce-command2'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomReduceCmd.commandkey2',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-reset-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomResetCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomResetCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-reset-command1'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomResetCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-reset-command2'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomResetCmd.commandkey2',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-zoom-toggle-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomToggleCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullZoomToggleCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('page-style-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageStyleMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageStyleMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('page-style-no-style-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageStyleNoStyle.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageStyleNoStyle.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('page-style-persistent-only-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageStylePersistentOnly.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageStylePersistentOnly.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('show-all-tabs-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'showAllTabsCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'showAllTabsCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('bidi-switch-page-direction-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bidiSwitchPageDirectionItem.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bidiSwitchPageDirectionItem.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('enter-full-screen-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'enterFullScreenCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'enterFullScreenCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('exit-full-screen-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'exitFullScreenCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'exitFullScreenCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-screen-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullScreenCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullScreenCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('full-screen-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'fullScreenCmd.macCommandKey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('history-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'historyMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'historyMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('show-all-history-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'showAllHistoryCmd2.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('show-all-history-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'showAllHistoryCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('clear-recent-history-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'clearRecentHistory.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('history-synced-tabs-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'syncTabsMenu3.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('history-restore-last-session-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'historyRestoreLastSession.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('history-undo-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'historyUndoMenu.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('history-undo-window-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'historyUndoWindowMenu.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('bookmarks-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarksMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarksMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('show-all-bookmarks-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'showAllBookmarks2.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('show-all-bookmarks-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarksCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('show-all-bookmarks-command-gtk'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarksGtkCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('bookmark-this-page-broadcaster'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarkThisPageCmd.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('edit-this-page-broadcaster'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'editThisBookmarkCmd.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('bookmark-this-page-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarkThisPageCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('subscribe-to-page-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'subscribeToPageMenupopup.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('subscribe-to-page-menupopup'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'subscribeToPageMenupopup.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('add-cur-pages-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'addCurPagesCmd.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('recent-bookmarks-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'recentBookmarks.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('other-bookmarks-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'otherBookmarksCmd.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('personalbar-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'personalbarCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'personalbarCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('tools-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'toolsMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'toolsMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('downloads-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'downloads.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'downloads.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('downloads-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'downloads.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('downloads-command-unix'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'downloadsUnix.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('addons-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'addons.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'addons.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('addons-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'addons.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('sync-sign-in-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    REPLACE(
                        'browser/chrome/browser/browser.dtd',
                        'syncSignIn.label',
                        {
                            '&syncBrand.shortName.label;': MESSAGE_REFERENCE(
                                'sync-brand-short-name'
                            )
                        }
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'syncSignIn.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('sync-sync-now-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'syncSyncNowItem.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'syncSyncNowItem.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('sync-re-auth-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    REPLACE(
                        'browser/chrome/browser/browser.dtd',
                        'syncReAuthItem.label',
                        {
                            '&syncBrand.shortName.label;': MESSAGE_REFERENCE(
                                'sync-brand-short-name'
                            )
                        }
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'syncReAuthItem.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('sync-toolbar-button'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'syncToolbarButton.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('web-developer-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'webDeveloperMenu.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'webDeveloperMenu.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('page-source-broadcaster'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageSourceCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageSourceCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('page-source-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageSourceCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('page-info-menuitem'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageInfoCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageInfoCmd.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('page-info-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'pageInfoCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('mirror-tab-menu'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'mirrorTabCmd.label',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'mirrorTabCmd.accesskey',
                    )
                ),
            ]
        ),
    ])

    ctx.add_transforms('browser/toolbar.ftl', 'toolbar.ftl', [
        FTL.Message(
            id=FTL.Identifier('urlbar-textbox'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('placeholder'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'urlbar.placeholder2',
                    )
                ),
                FTL.Attribute(
                    FTL.Identifier('accesskey'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'urlbar.accesskey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-bookmarks-broadcaster'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarksButton.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-bookmarks-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarksCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-bookmarks-command-win'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'bookmarksWinCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-history-broadcaster'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'historyButton.label',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-history-command'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('key'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'historySidebarCmd.commandkey',
                    )
                ),
            ]
        ),
        FTL.Message(
            id=FTL.Identifier('view-tabs-broadcaster'),
            attributes=[
                FTL.Attribute(
                    FTL.Identifier('label'),
                    COPY(
                        'browser/chrome/browser/browser.dtd',
                        'syncedTabs.sidebar.label',
                    )
                ),
            ]
        ),
    ])

    ctx.add_transforms('browser/branding/official/brand.ftl', 'brand.ftl', [
        FTL.Message(
            id=FTL.Identifier('brand-shorter-name'),
            value=COPY(
                'browser/branding/official/brand.dtd',
                'brandShorterName'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('brand-short-name'),
            value=COPY(
                'browser/branding/official/brand.dtd',
                'brandShortName'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('brand-full-name'),
            value=COPY(
                'browser/branding/official/brand.dtd',
                'brandFullName'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('vendor-short-name'),
            value=COPY(
                'browser/branding/official/brand.dtd',
                'vendorShortName'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('trademark-info'),
            value=COPY(
                'browser/branding/official/brand.dtd',
                'trademarkInfo.part1'
            )
        ),
        FTL.Message(
            id=FTL.Identifier('sync-brand-short-name'),
            value=COPY(
                'browser/branding/official/brand.properties',
                'syncBrandShortName'
            )
        ),
    ])
