% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{DiversityCurve-class}
\alias{DiversityCurve-class}
\alias{DiversityCurve}
\alias{print,DiversityCurve-method}
\alias{DiversityCurve-method}
\alias{plot,DiversityCurve,missing-method}
\title{S4 class defining a diversity curve}
\usage{
\S4method{print}{DiversityCurve}(x)

\S4method{plot}{DiversityCurve,missing}(x, y, ...)
}
\arguments{
\item{x}{DiversityCurve object}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotDiversityCurve}.}
}
\description{
\code{DiversityCurve} defines diversity (\eqn{D}) scores over multiple diversity 
orders (\eqn{Q}).
}
\section{Slots}{

\describe{
\item{\code{data}}{data.frame defining the diversity curve with the following columns:
\itemize{
  \item  \code{GROUP}:    group label.
  \item  \code{Q}:        diversity order.
  \item  \code{D}:        mean diversity index over all bootstrap 
                          realizations.
  \item  \code{D_SD}:     standard deviation of the diversity index 
                          over all bootstrap realizations.
  \item  \code{D_LOWER}:  diversity lower confidence inverval bound.
  \item  \code{D_UPPER}:  diversity upper confidence interval bound.
  \item  \code{E}:        evenness index calculated as \code{D} 
                          divided by \code{D} at \code{Q=0}.
  \item  \code{E_LOWER}:  evenness lower confidence inverval bound.
  \item  \code{E_UPPER}:  eveness upper confidence interval bound.
}}

\item{\code{groups}}{character vector of groups retained in the diversity calculation.}

\item{\code{n}}{numeric vector indication the number of sequences sampled from each group.}

\item{\code{nboot}}{number of bootstrap realizations performed.}

\item{\code{ci}}{confidence interval defining the upper and lower bounds 
(a value between 0 and 1).}
}}

